/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.storage;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLModelIDObject;
import oracle.dbtools.crest.model.persistence.xml.storage.AbstractWXMLStorageDesign;
import oracle.dbtools.crest.model.persistence.xml.storage.StoragePathTranslator;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GenericWXMLStorageObject
extends AbstractWXMLModelIDObject {
    private Class baseClass = StorageObject.class;
    private Class wrappeeClass = StorageObject.class;
    private Set priorities = Collections.EMPTY_SET;
    private AbstractWXMLStorageDesign storageDesignWriter;
    private static final Logger LOGGER = new Logger(GenericWXMLStorageObject.class);

    public GenericWXMLStorageObject(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    private Element appendInfo(Document doc, Element parentNode, ModelIDObject object, String objectTypeName, boolean useObjectInfoNode, String objInfoType) {
        String notes;
        object.setPersisted(true);
        String obInfo = "object";
        if (objInfoType != null) {
            obInfo = objInfoType;
        }
        Element objInfo = useObjectInfoNode ? doc.createElement(obInfo) : doc.createElement(objectTypeName);
        objInfo.setAttribute("type", objectTypeName);
        objInfo.setAttribute("id", object.getObjectID());
        if (object.getRepositoryOID() != null) {
            objInfo.setAttribute("rep_oid", object.getRepositoryOID());
        }
        if (object.getRepositoryOVID() != null) {
            objInfo.setAttribute("rep_ovid", object.getRepositoryOVID());
        }
        if (!object.hasOwnerDesignName() && object.isWriteable()) {
            object.setOwnerDesign();
        }
        Element child = doc.createElement("name");
        Text content = doc.createTextNode(StringUtilities.encodeAttributeValue(object.getName()));
        child.appendChild(content);
        objInfo.appendChild(child);
        String comment = object.getComment();
        if (comment != null) {
            child = doc.createElement("comment");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(comment));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        if ((notes = object.getNotes()) != null) {
            child = doc.createElement("notes");
            content = doc.createTextNode(StringUtilities.encodeAttributeValue(notes));
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        this.appendChange(objInfo, object.getCreation(), "created");
        this.appendChange(objInfo, object.getChange(), "changed");
        String generatorID = object.getGeneratorID();
        if (!ModelIDObject.USER_GENERATED.equalsIgnoreCase(generatorID)) {
            child = doc.createElement("generator");
            content = doc.createTextNode(generatorID);
            child.appendChild(content);
            objInfo.appendChild(child);
        }
        this.appendWrappedProperties(objInfo, (StorageObject)object);
        parentNode.appendChild(objInfo);
        return objInfo;
    }

    @Override
    protected Element appendObjectInfo(Document doc, Element parentNode, ModelIDObject object, String objectTypeName) {
        Element rootElm = this.appendInfo(doc, parentNode, object, objectTypeName, true, null);
        if ("Table".equalsIgnoreCase(objectTypeName) && object instanceof TableProxy) {
            this.writeTableElements((TableProxy)object, parentNode);
        }
        return rootElm;
    }

    protected void appendWrappedProperties(Element parent, StorageObject object) {
        PropertyMapWrapper wrapper = this.getPropertyMapWrapper(object);
        wrapper.setTranslators(object.getStorageDesign().getPropertyTranslators());
        this.releasePropertyMapWrapper(wrapper);
    }

    @Override
    protected void appendProperty(Element parameterElement, String key, String value) {
        super.appendProperty(parameterElement, key, value);
        if (this.priorities.contains(key)) {
            parameterElement.setAttribute("prioritized", VALUE_TRUE);
        }
    }

    protected PropertyMapWrapper getPropertyMapWrapper(ModelIDObject object) {
        return this.getPMWPoolMap().getInstance(this.getWrappeeClass(), this.getBaseClass(), object);
    }

    protected void releasePropertyMapWrapper(PropertyMapWrapper wrapper) {
        if (wrapper instanceof PMWPooled) {
            ((PMWPooled)wrapper).releaseFromPool();
        } else {
            LOGGER.error("releasePropertyMapWrapper: can not release");
        }
    }

    public void setBaseClass(Class baseClass) {
        this.baseClass = baseClass;
    }

    public void setWrappeeClass(Class wrappeeClass) {
        if (!StorageObject.class.isAssignableFrom(wrappeeClass)) {
            throw new IllegalArgumentException("wrappee class should be a StorageObject subclass");
        }
        this.wrappeeClass = wrappeeClass;
    }

    protected Class getBaseClass() {
        return this.baseClass;
    }

    protected Class getWrappeeClass() {
        return this.wrappeeClass;
    }

    @Override
    public Document writeDocument(Object object) {
        StorageObject stoObject = (StorageObject)object;
        boolean check = this.getPersistenceManager().isCheckDirty() && !AbstractRepositoryManager.INITIAL_WRITE_TODB ? stoObject.isDirty() : true;
        if (check) {
            Document doc = this.createDocument();
            Element docElement = doc.getDocumentElement();
            Element objectElement = this.appendObjectInfo(doc, docElement, stoObject, stoObject.getObjectTypeName());
            this.appendSpecificObjectInfo(objectElement, stoObject);
            return doc;
        }
        return null;
    }

    public void writeTableElements(TableProxy table, Element parent) {
        this.appendContained(table, parent);
        this.appendSAC_StorageObjects(table, parent);
    }

    private void appendContained(TableProxy tableProxy, Element parent) {
        Document doc = parent.getOwnerDocument();
        Element element = doc.createElement("columns");
        Element keys = doc.createElement("keys_and_indexes");
        AbstractWXMLStorageDesign stWr = this.getStorageDesignWriter();
        if (stWr != null) {
            GenericWXMLStorageObject columnWriter;
            ColumnProxy[] columns = tableProxy.getColumnProxies();
            for (int i = 0; i < columns.length; ++i) {
                ColumnProxy cp = columns[i];
                columnWriter = (GenericWXMLStorageObject)stWr.getWriterFor(cp);
                if (columnWriter == null) continue;
                Element objectElement = columnWriter.appendInfo(doc, element, cp, "Column", false, null);
                this.appendSpecificObjectInfo(objectElement, cp);
            }
            Table table = (Table)tableProxy.getObject();
            StorageDesign stoDes = tableProxy.getStorageDesign();
            KeyObject[] indexes = table.getKeys();
            for (int i = 0; i < indexes.length; ++i) {
                Index index = (Index)indexes[i];
                String id = index.getObjectID();
                StorageObject proxy = stoDes.getStorageObject(id);
                if (proxy == null && index.isFK()) {
                    id = index.getFKAssociation().getObjectID();
                    proxy = stoDes.getStorageObject(id);
                }
                if (proxy == null || (columnWriter = (GenericWXMLStorageObject)stWr.getWriterFor(proxy)) == null) continue;
                Element objectElement = columnWriter.appendInfo(doc, keys, proxy, proxy.getObjectTypeName(), false, null);
                this.appendSpecificObjectInfo(objectElement, proxy);
            }
        }
        parent.appendChild(element);
        parent.appendChild(keys);
    }

    private void appendSAC_StorageObjects(TableProxy tableProxy, Element parent) {
        Document doc = parent.getOwnerDocument();
        Element element = doc.createElement("storage_objects");
        AbstractWXMLStorageDesign stWr = this.getStorageDesignWriter();
        if (stWr != null) {
            for (StorageObject sto : tableProxy.getSAC_StorageObjects()) {
                GenericWXMLStorageObject columnWriter = (GenericWXMLStorageObject)stWr.getWriterFor(sto);
                if (columnWriter == null) continue;
                Element objectElement = columnWriter.appendInfo(doc, element, sto, sto.getObjectTypeName(), true, "storage_object");
                this.appendSpecificObjectInfo(objectElement, sto);
            }
        }
        parent.appendChild(element);
    }

    public void appendSpecificObjectInfo(Element objectElement, StorageObject storageObject) {
    }

    @Override
    public String getRelativePath() {
        throw new RuntimeException("StorageDesigns need a variable path");
    }

    @Override
    public String getRelativePath(Object object) {
        StoragePathTranslator.WRITE_OPERATION = true;
        String result = StoragePathTranslator.getPath((StorageObject)object);
        return result;
    }

    @Override
    public boolean canWrite(Object object) {
        return this.getWrappeeClass().isAssignableFrom(object.getClass());
    }

    @Override
    public String getFilenameFor(Object object) {
        String result = ((StorageObject)object).getObjectID();
        return result;
    }

    public void addPrioritizedPropertyName(String propertyName) {
        if (this.priorities.isEmpty()) {
            this.priorities = new TreeSet();
        }
        this.priorities.add(propertyName);
    }

    protected boolean isPrioritized() {
        return this.priorities.isEmpty();
    }

    public AbstractWXMLStorageDesign getStorageDesignWriter() {
        return this.storageDesignWriter;
    }

    public void setStorageDesignWriter(AbstractWXMLStorageDesign storageDesignWriter) {
        this.storageDesignWriter = storageDesignWriter;
    }
}

