/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.ContainerMapping;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.RelMapping;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RMExtendedMap
extends ExtendedMapBase {
    public static final String NAME = "ExtendedMap_RM";
    private boolean deletedMappingsGeneratedDuringLoad = false;

    public RMExtendedMap(Design design, RelationalDesign relationalModel) {
        super(design);
        this.relationalModel = relationalModel;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "mapping/ExtendedMap_RM" + this.relationalModel.getObjectID() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public MappingCollector getOrCreateCollector(DesignObject owner) {
        if (owner.getDesignPart() instanceof LogicalDesign) {
            return this.getDesign().getExtendedMap().getOrCreateCollector(owner);
        }
        String ownerID = owner.getObjectID();
        MappingCollector mc = (MappingCollector)this.collectorMap.get(ownerID);
        if (mc == null) {
            mc = new MappingCollector(this.getDesign(), ownerID);
            this.collectorMap.put(ownerID, mc);
        }
        return mc;
    }

    @Override
    protected MappingCollector getOrCreateCollector(String ownerID) {
        MappingCollector mc = (MappingCollector)this.collectorMap.get(ownerID);
        if (mc == null && (mc = this.getDesign().getExtendedMap().getCollector(ownerID)) == null) {
            mc = new MappingCollector(this.getDesign(), ownerID);
            this.collectorMap.put(ownerID, mc);
        }
        return mc;
    }

    public RelationalDesign getRelationalModel() {
        return this.relationalModel;
    }

    public LogicalDesign getLogicalModel() {
        return this.getDesign().getLogicalDesign();
    }

    public List getRelMappings() {
        ArrayList<RelMapping> list = new ArrayList<RelMapping>();
        for (XtdMapping mapping : this.mappings.values()) {
            if (mapping == null) continue;
            RelMapping rm = new RelMapping(mapping, this);
            list.add(rm);
        }
        return list;
    }

    public RelMapping createRelMapping() {
        XtdMapping mapping = this.createMapping();
        mapping.setTargetDesignPartID(this.getRelationalModel().getObjectID());
        mapping.setOwnerDesignPartID(this.getRelationalModel().getDesign().getLogicalDesign().getObjectID());
        return new RelMapping(mapping, this);
    }

    public ContainerMapping createContainerMapping() {
        XtdMapping mapping = this.createMapping();
        mapping.setTargetDesignPartID(this.getRelationalModel().getObjectID());
        mapping.setOwnerDesignPartID(this.getRelationalModel().getDesign().getLogicalDesign().getObjectID());
        return new ContainerMapping(mapping, this);
    }

    public void addRelMapping(RelMapping rm) {
        XtdMapping mapping = rm.getXtdMapping();
        this.addMapping(mapping);
    }

    public void addContainerMapping(ContainerMapping cm) {
        XtdMapping mapping = cm.getXtdMapping();
        this.addMapping(mapping);
        for (RelMapping rm : cm.getContainedMappings()) {
            this.addRelMapping(rm);
        }
    }

    public RelMapping getRelMappingByID(String id) {
        XtdMapping mapping = this.getMappingByID(id);
        if (mapping != null) {
            return new RelMapping(mapping, this);
        }
        return null;
    }

    public ContainerMapping getContainerMappingByID(String id) {
        XtdMapping mapping = this.getMappingByID(id);
        if (mapping != null) {
            return new ContainerMapping(mapping, this);
        }
        return null;
    }

    public List getContainerMappings() {
        ArrayList<ContainerMapping> list = new ArrayList<ContainerMapping>();
        ArrayList<ContainerMapping> cmaps = new ArrayList<ContainerMapping>();
        HashMap<String, ArrayList<XtdMapping>> lmap = new HashMap<String, ArrayList<XtdMapping>>();
        ArrayList<ContainerMapping> fkeys = new ArrayList<ContainerMapping>();
        for (XtdMapping mapping : this.mappings.values()) {
            DesignObject lco;
            DesignObject lob;
            ContainerMapping rm;
            DesignObject obj;
            if (mapping == null || (obj = mapping.getRelationalObject()) == null) continue;
            if (!(obj instanceof ContainedObject || obj instanceof ContainerWithKeyObject || obj instanceof KeyObject)) {
                rm = new ContainerMapping(mapping, this);
                fkeys.add(rm);
                continue;
            }
            if (obj instanceof ContainerWithKeyObject) {
                rm = new ContainerMapping(mapping, this);
                cmaps.add(rm);
                continue;
            }
            DesignObject co = RelMapping.getContainer(obj);
            if (co == null || (lob = mapping.getLogicalObject()) == null || (lco = RelMapping.getContainer(lob)) == null) continue;
            ArrayList<XtdMapping> clist = (ArrayList<XtdMapping>)lmap.get(co.getObjectID() + lco.getObjectID());
            if (clist == null) {
                clist = new ArrayList<XtdMapping>();
                lmap.put(co.getObjectID() + lco.getObjectID(), clist);
            }
            clist.add(mapping);
        }
        cmaps.addAll(fkeys);
        for (ContainerMapping cm : cmaps) {
            list.add(cm);
            List clist = (List)lmap.get(cm.getRelID() + cm.getLogID());
            if (clist == null) continue;
            for (XtdMapping mapping : clist) {
                cm.addXtdMapping(mapping);
            }
        }
        return list;
    }

    @Override
    public XtdMapping createMapping(DesignObject owner, DesignObject target) {
        XtdMapping mapping = this.getMapping(owner, target);
        if (mapping == null && (mapping = this.getMapping(target, owner)) == null) {
            if (owner.getDesignPart() instanceof LogicalDesign) {
                mapping = new XtdMapping(owner, target);
                this.addMapping(owner, target, mapping);
            } else {
                mapping = new XtdMapping(target, owner);
                this.addMapping(target, owner, mapping);
            }
            this.dirty = true;
        }
        return mapping;
    }

    @Override
    public void clearMappings() {
        Object[] maps = this.mappings.values().toArray();
        for (int i = 0; i < maps.length; ++i) {
            XtdMapping mapping = (XtdMapping)maps[i];
            this.removeMapping(mapping);
            this.getDesign().getExtendedMap().removeMapping(mapping);
        }
        this.deletedMappings.clear();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isDeletedMappingsGeneratedDuringLoad() {
        return this.deletedMappingsGeneratedDuringLoad;
    }

    public void setDeletedMappingsGeneratedDuringLoad(boolean deletedmappingsGeneratedDuringLoad) {
        this.deletedMappingsGeneratedDuringLoad = deletedmappingsGeneratedDuringLoad;
    }
}

