/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.xtdmapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;

public class XtdMapping
implements RepositoryObject {
    public static final int TYPE_ENTITY = 0;
    public static final int TYPE_ATTRIBUTE = 1;
    public static final int TYPE_KEY = 2;
    public static final int TYPE_RELATION = 3;
    public static final int TYPE_TABLE = 4;
    public static final int TYPE_COLUMN = 5;
    public static final int TYPE_INDEX = 6;
    public static final int TYPE_PKEY = 7;
    public static final int TYPE_FKEY = 8;
    public static final int TYPE_INHERITANCE = 9;
    public static final int TYPE_SUBVIEW = 10;
    public static final int TYPE_TABLE_VIEW = 11;
    public static final int TYPE_ENTITY_VIEW = 12;
    public static final int TYPE_FKARC = 13;
    public static final int TYPE_ARC = 14;
    public static final int INH_TYPE_UNKNOWN = -1;
    public static final int INH_TYPE_NONE = 0;
    public static final int INH_TYPE_SINGLE_TABLE = 1;
    public static final int INH_TYPE_LEAFS_ONLLY = 2;
    public static final int INH_TYPE_ALL = 3;
    public static final int INH_TYPE_ALL_FKINH_FKEY = 4;
    public static final int INH_TYPE_ALL_FKINH_COLUMN = 5;
    public static final int INH_TYPE_ALL_FKINH_FKEY_ARC = 6;
    public static final int INH_TYPE_ALL_FKINH_COLUMN_ARC = 7;
    private static final char SEPARATOR = '@';
    private String deletedID = null;
    private boolean propagateName;
    private DesignObject owner;
    private DesignObject target;
    private String ownerID;
    private String targetID;
    private String targetDesignPartID;
    private String ownerDesignPartID;
    private DesignPart targetDesignPart;
    private DesignPart ownerDesignPart;
    private String ownerName = "";
    private String targetName = "";
    private String targetDesignPartName = "";
    private String ownerDesignPartName = "";
    private int ownerType = -1;
    private int targetType = -1;
    private int inheritanceType = 0;
    private long creationTime;
    private String realSourceEntityID;
    private String realTargetEntityID;
    private Design design;
    private String recreatedContainerID = "";
    private boolean fwEngineer = true;
    private boolean revEngineer = true;
    private List columns;
    private List attributes;
    private List indexes;
    private List keys;
    private String columnsSelection = "";
    private String attributesSelection = "";
    private String keysSelection = "";
    private String indexesSelection = "";
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private String ownerRepOID = null;
    private String targetRepOID = null;
    private String targetContainerID = null;
    private String ownerContainerID = null;
    private boolean dirty = true;
    private boolean checkedOut = false;
    private String checkedOutBy = "";
    private boolean checkedOutByMe = false;
    private RepositoryObject pac_Element;
    private String id;

    public XtdMapping(DesignObject owner, DesignObject target) {
        this.creationTime = System.currentTimeMillis();
        this.owner = owner;
        this.target = target;
        this.ownerID = owner.getObjectID();
        this.targetID = target.getObjectID();
        this.ownerName = owner.getName();
        this.targetName = target.getName();
        this.targetDesignPart = target.getDesignPart();
        this.ownerDesignPart = owner.getDesignPart();
        this.ownerDesignPartName = this.ownerDesignPart.getName();
        this.targetDesignPartName = this.targetDesignPart.getName();
        this.ownerType = XtdMapping.getTypeFor(owner);
        this.targetType = XtdMapping.getTypeFor(target);
        this.ownerRepOID = owner.getRepositoryOID();
        this.targetRepOID = target.getRepositoryOID();
        if (owner instanceof ContainedObject) {
            this.ownerContainerID = ((ContainedObject)owner).getContainer().getObjectID();
        }
        if (target instanceof ContainedObject) {
            this.targetContainerID = ((ContainedObject)target).getContainer().getObjectID();
        }
        if (owner instanceof KeyObject) {
            this.ownerContainerID = ((KeyObject)owner).getContainerObject().getObjectID();
        }
        if (target instanceof KeyObject) {
            this.targetContainerID = ((KeyObject)target).getContainerObject().getObjectID();
        }
        this.design = owner.getDesign();
        this.setMappingID(owner, target);
    }

    public XtdMapping(DesignObject owner, DesignObject target, boolean buildContained) {
        this(owner, target);
        if (buildContained) {
            if (owner instanceof Entity) {
                this.addContainedForEntity((Entity)owner);
            } else if (owner instanceof Table) {
                this.addContainedForTable((Table)owner);
            }
            if (target instanceof Table) {
                this.addContainedForTable((Table)target);
            } else if (target instanceof Entity) {
                this.addContainedForEntity((Entity)target);
            }
        }
    }

    public XtdMapping(String ownerID, String targetID, Design design) {
        this.targetID = targetID;
        this.ownerID = ownerID;
        this.design = design;
    }

    @Override
    public Design getDesign() {
        if (this.owner != null) {
            return this.owner.getDesign();
        }
        if (this.target != null) {
            return this.target.getDesign();
        }
        return this.design;
    }

    private DesignPart getDesignPart(String designPartID) {
        if (this.getDesign().getLogicalDesign().getObjectID().equalsIgnoreCase(designPartID)) {
            return this.getDesign().getLogicalDesign();
        }
        Iterator it = this.getDesign().getRelationalDesigns().iterator();
        while (it.hasNext()) {
            RelationalDesign pdes = (RelationalDesign)it.next();
            if (!pdes.getObjectID().equalsIgnoreCase(designPartID)) continue;
            return pdes;
        }
        return null;
    }

    public DesignPart getTargetDesignPart() {
        if (this.targetDesignPart == null && this.targetDesignPartID != null) {
            this.targetDesignPart = this.getDesignPart(this.targetDesignPartID);
        }
        return this.targetDesignPart;
    }

    public DesignPart getOwnerDesignPart() {
        if (this.ownerDesignPart == null && this.ownerDesignPartID != null) {
            this.ownerDesignPart = this.getDesignPart(this.ownerDesignPartID);
        }
        return this.ownerDesignPart;
    }

    public boolean isTargetDesignPartLoaded() {
        DesignPart dp = this.getTargetDesignPart();
        if (dp == null) {
            return false;
        }
        return this.getTargetDesignPart().isLoaded();
    }

    public boolean isOwnerDesignPartLoaded() {
        if (this.getOwnerDesignPart() != null) {
            return this.getOwnerDesignPart().isLoaded();
        }
        return false;
    }

    public DesignObject getTargetObject() {
        if (this.target == null) {
            if (this.isTargetDesignPartLoaded()) {
                DesignPartView dpv;
                this.target = this.getDesign().getDesignObject(this.targetID);
                if (this.target == null && this.getTargetType() == 10 && this.getTargetDesignPart() != null && (dpv = this.getTargetDesignPart().getSubViewByID(this.targetID)) != null) {
                    this.target = dpv.getPlaceHolder();
                }
                return this.target;
            }
            return null;
        }
        return this.target;
    }

    public DesignObject getOwnerObject() {
        if (this.owner == null && this.isOwnerDesignPartLoaded()) {
            DesignPartView dpv;
            this.owner = this.getDesign().getDesignObject(this.ownerID);
            if (this.owner == null && this.getTargetType() == 10 && this.getOwnerDesignPart() != null && (dpv = this.getOwnerDesignPart().getSubViewByID(this.ownerID)) != null) {
                this.owner = dpv.getPlaceHolder();
            }
            return this.owner;
        }
        return this.owner;
    }

    public boolean isPropagateName() {
        return this.propagateName;
    }

    public void setPropagateName(boolean propagateName) {
        this.propagateName = propagateName;
    }

    public String getTargetID() {
        if (this.target != null) {
            this.targetID = this.target.getObjectID();
        }
        return this.targetID;
    }

    public String getTargetShortID() {
        if (this.target != null) {
            this.targetID = this.target.getShortObjectID();
        }
        return this.targetID;
    }

    public String getOwnerID() {
        if (this.owner != null) {
            this.ownerID = this.owner.getObjectID();
        }
        return this.ownerID;
    }

    public String getOwnerShortID() {
        if (this.owner != null) {
            this.ownerID = this.owner.getShortObjectID();
        }
        return this.ownerID;
    }

    public String getOwnerDesignPartID() {
        int ind;
        if (this.owner != null) {
            return this.owner.getDesignPart().getObjectID();
        }
        if (this.ownerDesignPartID == null && this.ownerID != null && (ind = this.ownerID.indexOf(64)) > -1) {
            this.ownerDesignPartID = this.ownerID.substring(0, ind);
        }
        return this.ownerDesignPartID;
    }

    public String getTargetDesignPartID() {
        int ind;
        if (this.target != null) {
            return this.target.getDesignPart().getObjectID();
        }
        if (this.targetDesignPartID == null && this.targetID != null && (ind = this.targetID.indexOf(64)) > -1) {
            this.targetDesignPartID = this.targetID.substring(0, ind);
        }
        return this.targetDesignPartID;
    }

    public String getOwnerName() {
        if (this.owner != null) {
            this.ownerName = this.owner.getName();
        }
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getTargetName() {
        if (this.target != null) {
            this.targetName = this.target.getName();
        }
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getOwnerDesignPartName() {
        if (this.ownerDesignPart != null) {
            this.ownerDesignPartName = this.ownerDesignPart.getName();
        }
        return this.ownerDesignPartName;
    }

    public void setOwnerDesignPartName(String ownerDesignPartName) {
        this.ownerDesignPartName = ownerDesignPartName;
    }

    public String getTargetDesignPartName() {
        if (this.targetDesignPart != null) {
            this.targetDesignPartName = this.targetDesignPart.getName();
        }
        return this.targetDesignPartName;
    }

    public void setTargetDesignPartName(String targetDesignPartName) {
        this.targetDesignPartName = targetDesignPartName;
    }

    public int getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(int ownerType) {
        this.ownerType = ownerType;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    public static int getTypeFor(DesignObject object) {
        if (object instanceof Entity) {
            return 0;
        }
        if (object instanceof Attribute) {
            return 1;
        }
        if (object instanceof CandidateKey) {
            return 2;
        }
        if (object instanceof EntityView) {
            return 12;
        }
        if (object instanceof Arc) {
            return 14;
        }
        if (object instanceof InheritanceRelation) {
            return 9;
        }
        if (object instanceof Relation) {
            return 3;
        }
        if (object instanceof Table) {
            return 4;
        }
        if (object instanceof Column) {
            return 5;
        }
        if (object instanceof FKIndexAssociation) {
            return 8;
        }
        if (object instanceof Index) {
            if (((Index)object).isPK()) {
                return 7;
            }
            if (object instanceof FKIndexAssociation) {
                return 8;
            }
            return 6;
        }
        if (object instanceof TableView) {
            return 11;
        }
        if (object instanceof FKArc) {
            return 13;
        }
        if (object instanceof DesignPartViewPlaceHolder) {
            return 10;
        }
        return -1;
    }

    public DesignObject getObjectMappedTo(DesignObject object) {
        if (this.deletedID != null) {
            return null;
        }
        if (this.getOwnerObject() == object) {
            return this.getTargetObject();
        }
        return this.getOwnerObject();
    }

    public int getTypeOfObjectMappedTo(DesignObject object) {
        if (this.getOwnerObject() == object) {
            return this.getTargetType();
        }
        return this.getOwnerType();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setOwnerDesignPartID(String ownerDesignPartID) {
        this.ownerDesignPartID = ownerDesignPartID;
    }

    public void setTargetDesignPartID(String targetDesignPartID) {
        this.targetDesignPartID = targetDesignPartID;
    }

    public int getInheritanceType() {
        return this.inheritanceType;
    }

    public void setInheritanceType(int inheritanceType) {
        this.inheritanceType = inheritanceType;
    }

    public String getRealSourceEntityID() {
        return this.realSourceEntityID;
    }

    public void setRealSourceEntityID(String realSourceEntityID) {
        this.realSourceEntityID = realSourceEntityID;
    }

    public String getRealTargetEntityID() {
        return this.realTargetEntityID;
    }

    public void setRealTargetEntityID(String realTargetEntityID) {
        this.realTargetEntityID = realTargetEntityID;
    }

    public String getOtherID(String id) {
        if (this.targetID != null && this.targetID.equals(id)) {
            return this.ownerID;
        }
        if (this.ownerID != null && this.ownerID.equals(id)) {
            return this.targetID;
        }
        throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(id));
    }

    public String getNameFor(String id) {
        if (this.targetID != null && this.targetID.equals(id)) {
            if (this.target != null) {
                return this.target.getName();
            }
            return this.targetName;
        }
        if (this.ownerID != null && this.ownerID.equals(id)) {
            if (this.owner != null) {
                return this.owner.getName();
            }
            return this.ownerName;
        }
        throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(id));
    }

    public void resetNameFor(String id) {
        if (this.targetID != null && this.targetID.equals(id) && this.target != null) {
            this.targetName = this.target.getName();
        }
        if (this.ownerID != null && this.ownerID.equals(id) && this.owner != null) {
            this.ownerName = this.owner.getName();
        }
    }

    public String getNameForOtherID(String id) {
        if (this.targetID != null && this.targetID.equals(id)) {
            if (this.owner != null) {
                return this.owner.getName();
            }
            return this.ownerName;
        }
        if (this.ownerID != null && this.ownerID.equals(id)) {
            if (this.target != null) {
                return this.target.getName();
            }
            return this.targetName;
        }
        throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(id));
    }

    public DesignObject getNoneDeletedObject() {
        if (this.deletedID != null) {
            if (this.targetID != null && this.targetID.equals(this.deletedID)) {
                return this.owner;
            }
            if (this.ownerID != null && this.ownerID.equals(this.deletedID)) {
                return this.target;
            }
            throw new RuntimeException("Wrong input ID in method getOtherID(id) - input ID " + String.valueOf(this.deletedID));
        }
        return null;
    }

    public boolean isDeleted() {
        return this.deletedID != null;
    }

    public String getDeletedID() {
        return this.deletedID;
    }

    public void setDeletedID(String deletedID) {
        this.deletedID = deletedID;
    }

    void clearDeletedID() {
        this.deletedID = null;
    }

    void restoreObject(DesignObject object) {
        if (object.getObjectID().equalsIgnoreCase(this.owner.getObjectID())) {
            this.owner = object;
        } else if (object.getObjectID().equalsIgnoreCase(this.target.getObjectID())) {
            this.target = object;
        }
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public String getRecreatedContainerID() {
        return this.recreatedContainerID;
    }

    public void setRecreatedContainerID(String recreatedContainerID) {
        this.recreatedContainerID = recreatedContainerID;
    }

    void nulifyObjects() {
        this.owner = null;
        this.target = null;
    }

    public String getOtherName(String id) {
        if (id.equalsIgnoreCase(this.targetID)) {
            return this.ownerName;
        }
        if (id.equalsIgnoreCase(this.ownerID)) {
            return this.targetName;
        }
        return "";
    }

    public boolean isFwEngineer() {
        return this.fwEngineer;
    }

    public void setFwEngineer(boolean fwEngineer) {
        this.fwEngineer = fwEngineer;
    }

    public boolean isRevEngineer() {
        return this.revEngineer;
    }

    public void setRevEngineer(boolean revEngineer) {
        this.revEngineer = revEngineer;
    }

    private void addContainedForTable(Table table) {
        for (DesignObject dobj : table.getElementsCollection()) {
            if (!dobj.shouldBeEngineered()) {
                if (this.getColumns().contains(dobj.getObjectID())) continue;
                this.getColumns().add(dobj.getObjectID());
                continue;
            }
            this.getColumns().remove(dobj.getObjectID());
        }
        for (DesignObject dobj : table.getPKandUKConstraints()) {
            if (!dobj.shouldBeEngineered()) {
                if (this.getIndexes().contains(dobj.getObjectID())) continue;
                this.getIndexes().add(dobj.getObjectID());
                continue;
            }
            this.getIndexes().remove(dobj.getObjectID());
        }
    }

    private void addContainedForEntity(Entity entity) {
        for (DesignObject dobj : entity.getElementsCollection()) {
            if (!dobj.shouldBeEngineered()) {
                if (this.getAttributes().contains(dobj.getObjectID())) continue;
                this.getAttributes().add(dobj.getObjectID());
                continue;
            }
            this.getAttributes().remove(dobj.getObjectID());
        }
        Iterator it = entity.getKeySet().iterator();
        while (it.hasNext()) {
            DesignObject dobj;
            dobj = (DesignObject)it.next();
            if (!dobj.shouldBeEngineered()) {
                if (!this.getKeys().contains(dobj.getObjectID())) continue;
                this.getKeys().add(dobj.getObjectID());
                continue;
            }
            this.getKeys().remove(dobj.getObjectID());
        }
    }

    public void initializeContained() {
        if (this.owner != null && this.target != null) {
            if (this.owner instanceof Entity) {
                this.addContainedForEntity((Entity)this.owner);
            } else if (this.owner instanceof Table) {
                this.addContainedForTable((Table)this.owner);
            }
            if (this.target instanceof Table) {
                this.addContainedForTable((Table)this.target);
            } else if (this.target instanceof Entity) {
                this.addContainedForEntity((Entity)this.target);
            }
        }
    }

    @Override
    public boolean canBedeleted() {
        return true;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getName() {
        if (this.owner != null) {
            return this.owner.getName();
        }
        return "noName";
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public void setCheckedOutBy(String checkedOutBy) {
        this.checkedOutBy = checkedOutBy;
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
        this.checkedOutByMe = checkedOutByMe;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setRepositoryOID(String repositoryOID) {
        this.repositoryOID = repositoryOID;
    }

    @Override
    public void setRepositoryOVID(String repositoryOVID) {
        this.repositoryOVID = repositoryOVID;
    }

    public String getOwnerRepOID() {
        if (this.owner != null) {
            return this.owner.getRepositoryOID();
        }
        return this.ownerRepOID;
    }

    public void setOwnerRepOID(String ownerRepOID) {
        this.ownerRepOID = ownerRepOID;
    }

    public String getTargetRepOID() {
        if (this.target != null) {
            return this.target.getRepositoryOID();
        }
        return this.targetRepOID;
    }

    public void setTargetRepOID(String targetRepOID) {
        this.targetRepOID = targetRepOID;
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject object) {
        if (!this.isPAC_Element()) {
            this.pac_Element = object;
        }
    }

    public boolean isMappingForContainer(String containerID) {
        if (this.ownerContainerID != null && this.ownerContainerID.equals(containerID)) {
            return true;
        }
        if (this.targetContainerID != null && this.targetContainerID.equals(containerID)) {
            return true;
        }
        if (this.deletedID != null && this.deletedID.equals(containerID)) {
            return true;
        }
        return this.recreatedContainerID != null && this.recreatedContainerID.equals(containerID);
    }

    public String getTargetContainerID() {
        if (this.targetContainerID == null) {
            if (this.target == null && this.getDesign() != null) {
                this.target = this.getDesign().getDesignObject(this.targetID);
            }
            if (this.target != null) {
                if (this.target instanceof Attribute) {
                    Attribute attr = (Attribute)this.target;
                    this.targetContainerID = attr.getContainerRelation() != null ? attr.getContainerRelation().getObjectID() : ((ContainedObject)this.target).getContainer().getObjectID();
                } else if (this.target instanceof ContainedObject) {
                    this.targetContainerID = ((ContainedObject)this.target).getContainer().getObjectID();
                } else if (this.target instanceof KeyObject) {
                    this.targetContainerID = ((KeyObject)this.target).getContainerObject().getObjectID();
                }
            }
        }
        return this.targetContainerID;
    }

    public void setTargetContainerID(String targetContainerID) {
        this.targetContainerID = targetContainerID;
    }

    public String getOwnerContainerID() {
        if (this.ownerContainerID == null) {
            if (this.owner == null && this.getDesign() != null) {
                this.owner = this.getDesign().getDesignObject(this.ownerID);
            }
            if (this.owner != null) {
                if (this.owner instanceof Attribute) {
                    Attribute attr = (Attribute)this.owner;
                    this.ownerContainerID = attr.getContainerRelation() != null ? attr.getContainerRelation().getObjectID() : ((ContainedObject)this.owner).getContainer().getObjectID();
                } else if (this.owner instanceof ContainedObject) {
                    this.ownerContainerID = ((ContainedObject)this.owner).getContainer().getObjectID();
                } else if (this.owner instanceof KeyObject) {
                    this.ownerContainerID = ((KeyObject)this.owner).getContainerObject().getObjectID();
                }
            }
        }
        return this.ownerContainerID;
    }

    public void setOwnerContainerID(String ownerContainerID) {
        this.ownerContainerID = ownerContainerID;
    }

    public String getID() {
        if ("nullnull".equals(this.id)) {
            this.id = null;
        }
        if (this.id == null) {
            String oid = this.getOwnerShortID();
            if (oid == null) {
                oid = this.getDeletedID();
            }
            if (oid == null) {
                String tid = this.getTargetShortID();
                if (tid == null) {
                    return "";
                }
                return tid;
            }
            String tid = this.getTargetShortID();
            if (tid == null) {
                tid = this.getDeletedID();
            }
            DesignObject left = null;
            DesignObject right = null;
            try {
                left = this.getOwnerObject();
                right = this.getTargetObject();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (left != null && right != null) {
                this.setMappingID(left, right);
            } else if (left != null) {
                if (left.getDesignPart() instanceof LogicalDesign) {
                    this.id = left.getShortObjectID() + tid;
                } else if (tid != null) {
                    this.id = tid + left.getShortObjectID();
                }
            } else if (right != null) {
                if (right.getDesignPart() instanceof LogicalDesign) {
                    this.id = right.getShortObjectID() + oid;
                } else if (oid != null) {
                    this.id = oid + right.getShortObjectID();
                }
            } else {
                this.id = tid != null ? oid + tid : oid;
            }
        }
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    private void setMappingID(DesignObject left, DesignObject right) {
        this.id = left.getDesignPart() instanceof LogicalDesign || !(right.getDesignPart() instanceof RelationalDesign) ? left.getShortObjectID() + right.getShortObjectID() : right.getShortObjectID() + left.getShortObjectID();
    }

    public void setTargetID(String id) {
        this.targetID = id;
    }

    public void setOwnerID(String id) {
        this.ownerID = id;
    }

    public String getOtherContainerID(String containerID) {
        if (containerID != null) {
            this.getOwnerContainerID();
            this.getTargetContainerID();
            if (containerID.equals(this.ownerContainerID) && !containerID.equals(this.targetContainerID)) {
                return this.targetContainerID;
            }
            if (!containerID.equals(this.ownerContainerID) && containerID.equals(this.targetContainerID)) {
                return this.ownerContainerID;
            }
        }
        return "null";
    }

    public List getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList();
            if (this.columnsSelection != null && !"".equals(this.columnsSelection)) {
                String[] ids;
                for (String id : ids = this.columnsSelection.trim().split(",")) {
                    this.columns.add(id);
                }
            }
        }
        return this.columns;
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
            if (this.attributesSelection != null && !"".equals(this.attributesSelection)) {
                String[] ids;
                for (String id : ids = this.attributesSelection.trim().split(",")) {
                    this.attributes.add(id);
                }
            }
        }
        return this.attributes;
    }

    public List getIndexes() {
        if (this.indexes == null) {
            this.indexes = new ArrayList();
            if (this.indexesSelection != null && !"".equals(this.indexesSelection)) {
                String[] ids;
                for (String id : ids = this.indexesSelection.trim().split(",")) {
                    this.indexes.add(id);
                }
            }
        }
        return this.indexes;
    }

    public List getKeys() {
        if (this.keys == null) {
            this.keys = new ArrayList();
            if (this.keysSelection != null && !"".equals(this.keysSelection)) {
                String[] ids;
                for (String id : ids = this.keysSelection.trim().split(",")) {
                    this.keys.add(id);
                }
            }
        }
        return this.keys;
    }

    public DesignObject getLogicalObject() {
        DesignObject obj = this.getOwnerObject();
        if (obj != null && obj.getDesignPart() instanceof LogicalDesign) {
            return obj;
        }
        obj = this.getTargetObject();
        if (obj != null && obj.getDesignPart() instanceof LogicalDesign) {
            return obj;
        }
        return null;
    }

    public DesignObject getRelationalObject() {
        DesignObject obj = this.getTargetObject();
        if (obj != null && obj.getDesignPart() instanceof RelationalDesign) {
            return obj;
        }
        obj = this.getOwnerObject();
        if (obj != null && obj.getDesignPart() instanceof RelationalDesign) {
            return obj;
        }
        return null;
    }

    public String getColumnsSelection() {
        if (this.columns != null) {
            this.columnsSelection = XtdMapping.getListToString(this.columns);
        }
        return this.columnsSelection;
    }

    public void setColumnsSelection(String columnsSelection) {
        this.columnsSelection = columnsSelection;
    }

    public String getAttributesSelection() {
        if (this.attributes != null) {
            this.attributesSelection = XtdMapping.getListToString(this.attributes);
        }
        return this.attributesSelection;
    }

    public void setAttributesSelection(String attributesSelection) {
        this.attributesSelection = attributesSelection;
    }

    public String getKeysSelection() {
        if (this.keys != null) {
            this.keysSelection = XtdMapping.getListToString(this.keys);
        }
        return this.keysSelection;
    }

    public void setKeysSelection(String keysSelection) {
        this.keysSelection = keysSelection;
    }

    public String getIndexesSelections() {
        if (this.indexes != null) {
            this.indexesSelection = XtdMapping.getListToString(this.indexes);
        }
        return this.indexesSelection;
    }

    public void setIndexesSelections(String indexesSelections) {
        this.indexesSelection = indexesSelections;
    }

    public static String getListToString(List list) {
        String res = "";
        for (int i = 0; i < list.size(); ++i) {
            res = i == 0 ? (String)list.get(i) : res + "," + (String)list.get(i);
        }
        return res;
    }
}

