/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignObjectView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.TopViewListener;
import oracle.ide.Ide;

public abstract class ContainerView
extends TopView
implements DesignObjectView,
ContainerObjectListener {
    public static final int BORDER_N = 8;
    public static final int BORDER_NE = 7;
    public static final int BORDER_E = 11;
    public static final int BORDER_SE = 5;
    public static final int BORDER_S = 9;
    public static final int BORDER_SW = 4;
    public static final int BORDER_W = 10;
    public static final int BORDER_NW = 6;
    private static final int LEFT = 0;
    private static final int UPPER = 0;
    private static final int MIDDLE = 1;
    private static final int RIGHT = 2;
    private static final int LOWER = 2;
    Object selectedObject = null;
    private Set cvlisteners = new HashSet();
    private final SelectableObject CONTAINER_FOCUS;
    private SelectableObject currentSelection = this.CONTAINER_FOCUS = new SelectionWrapper();

    public ContainerView(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public ContainerView createViewSynonim(DesignPartView dpv) {
        return this.createViewSynonim(dpv, true);
    }

    public ContainerView createViewSynonim(DesignPartView dpv, boolean shiftNew) {
        ContainerView tvt;
        if (this.getApplicationView() == null) {
            this.applicationView = dpv.getApplicationView();
        }
        if ((tvt = this.createViewSynonim(this.getApplicationView(), dpv)) != null) {
            Rectangle r = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
            if (shiftNew) {
                r.x += 30;
                r.y += 30;
            }
            tvt.setModel(this.getModel());
            tvt.setBounds(r);
            dpv.registerForTreemodel(tvt);
            if (dpv.isVisible()) {
                dpv.add(tvt, r, null);
            }
            tvt.setHideElementsInCurrentOnly(this.isHideElementsInCurrentOnly());
            tvt.getHiddenElements().addAll(this.getHiddenElements());
        }
        return tvt;
    }

    public void copyBounds(TopView topView) {
        if (topView != null) {
            Rectangle r = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
            topView.setBounds(r);
        }
    }

    protected abstract ContainerView createViewSynonim(ApplicationView var1, DesignPartView var2);

    public boolean shouldShowLongNameContained() {
        return false;
    }

    @Override
    public void setModel(DesignObject object) {
        ContainerObject oldModel = (ContainerObject)this.getModel();
        super.setModel(object);
        if (oldModel != null) {
            oldModel.removeContainerListener(this);
        }
        ((ContainerObject)object).addContainerListener(this);
        this.selectedObject = object;
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (this.getCellView() != null && this.getCellView().getDiagram() != null) {
            this.getCellView().getDiagram().repaint();
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (!object.getDesign().isClosing()) {
            if (event.isType(ObjectChangeEvent.OBJECT_REMOVED) && this.getCellView() != null && this.getCellView().getCell() != null) {
                this.getDesignPartView().getWorkSpace().getModel().remove(new Object[]{this.getCellView().getCell()});
            }
            if (this.getCellView() != null && this.getCellView().getDiagram() != null) {
                this.getCellView().getDiagram().repaint();
            }
        }
    }

    protected int pointInBorder(Point point) {
        int cornerRange = 10;
        Rectangle rect = this.getBounds();
        int xregion = this.beginMiddleEnd(point.x, cornerRange, rect.width);
        int yregion = this.beginMiddleEnd(point.y, cornerRange, rect.height);
        switch (xregion + 7 * yregion) {
            case 0: {
                return 6;
            }
            case 7: {
                return 10;
            }
            case 14: {
                return 4;
            }
            case 2: {
                return 7;
            }
            case 9: {
                return 11;
            }
            case 16: {
                return 5;
            }
            case 1: {
                return 8;
            }
            case 15: {
                return 9;
            }
        }
        return 6;
    }

    private int beginMiddleEnd(int coord, int range, int max) {
        if (coord < range) {
            return 0;
        }
        if (coord > max - range) {
            return 2;
        }
        return 1;
    }

    public int minimumComponentSize() {
        return 50;
    }

    protected void setCurrentSelection(SelectableObject selObj) {
        boolean dirty = this.getDesignPartView().getDesignPart().isDirty();
        boolean designDirty = this.getDesign().isDirty();
        this.currentSelection = selObj;
        this.selectedObject = this.currentSelection.getSelectedObject();
        this.getDesignPartView().setCurrentSelection(this.currentSelection, this);
        this.selectedObject = this.currentSelection.getSelectedObject();
        this.getDesignPartView().setCurrentSelection(this.currentSelection, this);
        this.getDesignPartView().getDesignPart().setDirty(dirty);
        this.getDesign().setDirty(designDirty);
    }

    public void setCurrentSelectionToContainer() {
        this.setCurrentSelection(this.CONTAINER_FOCUS);
    }

    public boolean isSelected() {
        SelectableObject selObj = this.getDesignPartView().getCurrentSelection();
        if (selObj == null) {
            return false;
        }
        return selObj.getSelectedObject() == this.getModel();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.currentSelection;
    }

    public void remove() {
        this.remove("");
    }

    public void remove(String logMessage) {
        String msg = "";
        if (this.hasRelations()) {
            msg = "\n" + Messages.getString("ContainerView.ContainverView.HasRelationshipsToBeRemoved");
        }
        if (this.canRemove()) {
            int res = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ContainerView.HasMoreThan1GraphicalRepresentation") + msg, this.getModel().getName()), Messages.getString("ContainerView.WhatWouldYouLikeToDo"), 1, 3, null, new String[]{Messages.getString("ContainerView.RemoveObject"), Messages.getString("ContainerView.RemoveView"), Messages.getString("ContainerView.Cancel")}, Messages.getString("ContainerView.RemoveView"));
            if (res == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                this.remove(true);
                if (!"".equals(logMessage)) {
                    ApplicationView.log(logMessage);
                }
            }
            if (res == 1) {
                DesignPartView dpv = this.getDesignPartView();
                dpv.unregisterFromTreemodel(this);
                this.remove(false);
            }
        } else {
            int res = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ContainerView.SureYouWantToDelete") + msg, this.getModel().getName()), Messages.getString("ContainerView.ConfirmObjectDelete"), 0);
            if (res == 0) {
                this.getModel().getDesignPart().postUndoableRemoveEditForObject(this.getModel());
                this.remove(true);
                if (!"".equals(logMessage)) {
                    ApplicationView.log(logMessage);
                }
            }
        }
    }

    protected boolean hasRelations() {
        if (this.getModel() instanceof Entity) {
            Entity entity = (Entity)this.getModel();
            return entity.getRelationConnections().length > 0;
        }
        return false;
    }

    protected int getPreferredIconSize() {
        return 24;
    }

    protected abstract void doPrivateActions();

    public void remove(boolean removeModel) {
        if (removeModel) {
            this.getModel().remove();
            this.getDesignPartView().setDirty(true);
            this.getDesignPartView().getWorkSpace().repaint();
        } else {
            if (this.getCellView() != null) {
                Object[] cells = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(cells);
                this.getDesignPartView().setDirty(true);
            }
            this.doPrivateActions();
            this.getDesignPartView().removeView(this);
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }

    public void removeNoneCascade(boolean removeModel) {
        if (removeModel) {
            this.getModel().remove();
            this.getDesignPartView().getWorkSpace().repaint();
        } else {
            if (this.getCellView() != null) {
                Object[] cells = new Object[]{this.getCellView().getCell()};
                this.getDesignPartView().getWorkSpace().removeCells(cells);
            }
            this.doPrivateActions();
            this.getDesignPartView().removeViewNoneCascade(this);
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }

    public void addTopViewListener(TopViewListener listener) {
        this.cvlisteners.add(listener);
    }

    protected void fireChange(ObjectChangeEvent event) {
        TopViewListener[] listenersCopy = this.cvlisteners.toArray(new TopViewListener[0]);
        for (int i = 0; i < listenersCopy.length; ++i) {
            try {
                listenersCopy[i].changed(this, event);
                continue;
            }
            catch (Exception e) {
                System.out.println("Listener caused exception: ContainerView");
            }
        }
    }

    public void addTVTypeSubstitutions() {
        ContainerObject cont = (ContainerObject)this.getModel();
        DesignPartView dpv = this.getDesignPartView();
        TypeSubstitution ts = cont.getTypeSubstitution();
        if (ts != null && ts.getChildCV(dpv) == null) {
            ts.setChildCV(this);
        }
        for (TypeSubstitution tss : cont.getSubTypeSubstitutions()) {
            if (tss.getParentCV(dpv) != null) continue;
            tss.setParentCV(this);
        }
    }

    public void removeTopViewListener(TopViewListener listener) {
        this.cvlisteners.remove(listener);
    }

    protected abstract void hideRelations();

    @Override
    public boolean canRemove() {
        DesignPartView dpv = this.getDesignPartView();
        int count = this.getModel().getViewsCountForDPV(dpv);
        if (count > 1) {
            return true;
        }
        DesignPartView masterDPV = dpv.getMasterDPV();
        if (masterDPV == null) {
            masterDPV = dpv;
        }
        return masterDPV != this.getModel().getDesignPart().getMainView();
    }

    public Rectangle getActualBounds() {
        Rectangle bounds = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
        return bounds;
    }

    public void setActualBoundsRect(Rectangle rect) {
        if (this.getCellView() != null) {
            this.getCellView().setNewBounds(rect);
        }
        this.location.x = rect.x;
        this.location.y = rect.y;
        this.size.width = rect.width;
        this.size.height = rect.height;
    }

    public void setActualBounds(int x, int y, int width, int height) {
        if (this.getCellView() != null) {
            this.getCellView().setNewBounds(new Rectangle(x, y, width, height));
        }
        this.location.x = x;
        this.location.y = y;
        this.size.width = width;
        this.size.height = height;
    }

    class SelectionWrapper
    implements SelectableObject {
        SelectionWrapper() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        public ContainerView getContainerView() {
            return ContainerView.this;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return ContainerView.this.getModel();
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

