/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class LogReport
extends CustomDialog {
    private JDialog dialog;
    private JEditorPane editor;
    private JPanel footerPanel;
    private JButton saveButton;
    private JButton closeButton;
    private String name = Messages.getString("LogReport.ViewLog");
    private static final Logger LOGGER;
    private static File lastFolder;

    public LogReport(ApplicationView appView) {
        super(appView);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getEditorPane()), "Center");
        this.add((Component)this.getFooterPanel(), "South");
    }

    protected JEditorPane getEditorPane() {
        if (this.editor == null) {
            this.editor = new JEditorPane();
            this.editor.setEditorKit(new StyledEditorKit());
        }
        return this.editor;
    }

    @Override
    protected void close() {
        this.dialog.dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.name);
            this.dialog.setContentPane(this);
            Dimension dim = this.getApplicationView().getFrame().getSize();
            this.dialog.setSize(dim.width - 20, dim.height - 40);
            this.setDefaultActions(this.dialog, false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    public void showDialog(Dimension dim) {
        this.getDialog().setSize(dim);
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    public void showModalDialog(Dimension dim) {
        this.getDialog().setSize(dim);
        ((JDialog)this.getDialog()).setModal(true);
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    public JPanel getFooterPanel() {
        if (this.footerPanel == null) {
            this.footerPanel = new JPanel();
            this.footerPanel.add(this.getSaveButton());
            this.footerPanel.add(this.getCloseButton());
        }
        return this.footerPanel;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("LogReport.Save"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    LogReport.this.saveLocalCopy();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("LogReport.SaveLog"));
        }
        return this.saveButton;
    }

    public JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(Messages.getString("LogReport.Close"));
            this.closeButton.setMnemonic(67);
            this.closeButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    LogReport.this.close();
                }
            });
            this.closeButton.setToolTipText(Messages.getString("LogReport.Close"));
        }
        return this.closeButton;
    }

    public void setLog(String contents) {
        this.getEditorPane().setText(contents);
    }

    public void saveLocalCopy() {
        try {
            URLFilter filter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".log") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("LogReport.LogFiles");
                }
            };
            URLChooser fileChooser = DialogUtil.newURLChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(filter);
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            fileChooser.setFileNameURL(this.getApplicationView().getDesignName() + ".log");
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("LogReport.SaveLog"));
            if (status == 0) {
                File file = new File(fileChooser.getSelectedURL().getPath());
                if (file != null) {
                    lastFolder = file.getParentFile();
                    FileOpenHistory.getInstance().updateFileHistory(lastFolder.toURI().toURL());
                    this.saveLocalCopy(file);
                }
                ApplicationView.log(Messages.getString("LogReport.LogSaved"));
            } else {
                ApplicationView.log(Messages.getString("LogReport.SaveLogCanceled"));
            }
        }
        catch (IOException ioe) {
            LOGGER.error("", ioe);
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("LogReport.CanNotWriteToFile"), ioe.getMessage()}, Messages.getString("LogReport.WriteError"), 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), new Object[]{Messages.getString("LogReport.UnexpectedError"), t.getMessage()}, Messages.getString("LogReport.WriteError"), 0);
        }
    }

    protected void saveLocalCopy(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("LogReport.FileExists"), file.getAbsolutePath()), Messages.getString("LogReport.Warning"), 0, 3, null)) == 1) {
            return;
        }
        String editedContent = this.getEditorPane().getText();
        file.getParentFile().mkdirs();
        ApplicationView.log(MessageFormat.format(Messages.getString("LogReport.SavingLogFile"), file));
        file.createNewFile();
        PrintWriter out = new PrintWriter(new BufferedOutputStream(new FileOutputStream(file)));
        out.print(editedContent);
        out.flush();
        out.close();
    }

    @Override
    public void setName(String name) {
        this.name = name;
        ((JDialog)this.getDialog()).setTitle(name);
    }

    static {
        lastFolder = null;
        LOGGER = new Logger(LogReport.class);
    }
}

