/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBActionListener;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class MDBAction
extends AbstractAction
implements MDBActionListener {
    public static final ImageIcon APPLICATION_ICON = (ImageIcon)GUIConfiguration.getInstance().getIcon("APPLICATION_ICON", 16);
    private static final JFrame OWNER_FRAME;
    private static final Logger LOGGER;
    public static final String[] DEFAULT_MENU_PATH;
    private String[] menuPath = DEFAULT_MENU_PATH;
    private boolean inToolbar = true;
    private String name = "  ";
    private Set listeners = new HashSet();
    private List propertyChangeListeners = new ArrayList();
    private int mnemonic;
    private int position = -1;
    private boolean oldState = true;
    private KeyStroke accelerator;
    private boolean isObjectAction = false;
    private JMenu menu;

    public MDBAction() {
    }

    public MDBAction(String name) {
        super(name);
        this.name = name;
    }

    public MDBAction(String name, Icon icon) {
        super(name, icon);
        this.name = name;
    }

    public String getToolTipText() {
        return null;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.remove(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        this.propertyChangeListeners.add(propertyChangeListener);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        PropertyChangeListener[] retValue = this.propertyChangeListeners.toArray(new PropertyChangeListener[this.propertyChangeListeners.size()]);
        return retValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.putValue("Name", name);
        this.name = name;
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setMenuPath(String[] path) {
        this.menuPath = path;
    }

    public String[] getMenuPath() {
        return this.menuPath;
    }

    public void setAllowedInToolbar(boolean value) {
        this.inToolbar = value;
    }

    public boolean isAllowedInToolbar() {
        return this.inToolbar;
    }

    public boolean needSelectedObject() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ActionInvoker invoker = new ActionInvoker(event);
        SwingUtilities.invokeLater(invoker);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke accelerator) {
        this.accelerator = accelerator;
    }

    public void addMDBActionListener(MDBActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeMDBActionListener(MDBActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireBefore(ActionEvent event) {
        if (!this.listeners.isEmpty()) {
            for (MDBActionListener listener : this.listeners) {
                listener.beforeAction(this, event);
            }
        }
    }

    protected void fireAfter(ActionEvent event) {
        if (!this.listeners.isEmpty()) {
            for (MDBActionListener listener : this.listeners) {
                listener.afterAction(this, event);
            }
        }
    }

    public abstract void doActionPerformed(ActionEvent var1);

    @Override
    public void afterAction(MDBAction actionSource, ActionEvent event) {
    }

    @Override
    public void beforeAction(MDBAction actionSource, ActionEvent event) {
    }

    public void setDelegate(MDBAction delegate) {
        throw new IllegalStateException(Messages.getString("MDBAction.ThisActionIsNotReplaceable"));
    }

    public MDBAction getDelegate() {
        throw new IllegalStateException(Messages.getString("MDBAction.ThisActionIsNotReplaceable"));
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean addSeparatorAfter() {
        return false;
    }

    public boolean addSeparatorAfterInRoot() {
        return false;
    }

    public boolean addSeparatorBefore() {
        return false;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
    }

    public void setOldState(boolean enable) {
        this.oldState = enable;
    }

    public void reset() {
        this.setEnabled(this.oldState);
    }

    public boolean isToggleButton() {
        return false;
    }

    public boolean addToolbarSeparator() {
        return false;
    }

    public boolean isObjectAction() {
        return this.isObjectAction;
    }

    public void setObjectAction(boolean isObjectAction) {
        this.isObjectAction = isObjectAction;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void setMenu(JMenu menu) {
        this.menu = menu;
    }

    public boolean isPopupMenu() {
        return false;
    }

    static {
        LOGGER = new Logger(MDBAction.class);
        OWNER_FRAME = new JFrame();
        OWNER_FRAME.setIconImage(APPLICATION_ICON.getImage());
        DEFAULT_MENU_PATH = new String[]{"Object"};
    }

    class ActionInvoker
    implements Runnable {
        ActionEvent event;

        ActionInvoker(ActionEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MDBAction.this.fireBefore(this.event);
                MDBAction.this.doActionPerformed(this.event);
                MDBAction.this.fireAfter(this.event);
            }
            catch (Throwable thr) {
                LOGGER.error(thr);
                thr.printStackTrace();
            }
            finally {
                this.event = null;
            }
        }
    }
}

