/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.util.logging.Logger;

public class ProgressDialog {
    private ProgressDialog root;
    private JDialog dialog;
    private ProgressOptionPane pane;
    private JProgressBar myBar;
    private JLabel noteLabel;
    private Component parentComponent;
    private String note;
    private long to;
    private int millisToDecideToPopup = 0;
    private int millisToPopup = 0;
    private int min;
    private int max;
    private int lastDisp;
    private int reportDelta;
    private ApplicationView view;
    private boolean indeterminateMode = false;
    private boolean addCancelButton = false;
    private JButton btnCancel;
    private static final Logger LOGGER = new Logger(ProgressDialog.class);

    public ProgressDialog(ApplicationView view, String note, int min, int max) {
        this(view, note, min, max, false, false);
    }

    public ProgressDialog(ApplicationView view, String note, int min, int max, boolean indeterminateMode, boolean addCancelButton) {
        this(view.getFrame(), note, min, max, null);
        this.view = view;
        this.indeterminateMode = indeterminateMode;
        this.addCancelButton = addCancelButton;
    }

    private ProgressDialog(Component parentComponent, String note, int min, int max, ProgressDialog group) {
        this.min = min;
        this.max = max;
        this.parentComponent = parentComponent;
        this.reportDelta = (max - min) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.note = note;
        if (group != null) {
            this.root = group.root != null ? group.root : group;
            this.to = this.root.to;
            this.dialog = this.root.dialog;
        } else {
            this.to = System.currentTimeMillis();
        }
    }

    public void increaseProgress(int step) {
        this.setProgress(this.lastDisp + step);
    }

    public void setProgress(int nv) {
        try {
            if (nv < this.max && nv >= this.lastDisp + this.reportDelta) {
                this.lastDisp = nv;
                if (this.myBar != null) {
                    this.myBar.setValue(nv);
                } else {
                    int predictedCompletionTime;
                    long t = System.currentTimeMillis();
                    long dT = (int)(t - this.to);
                    if (dT >= (long)this.millisToDecideToPopup && (predictedCompletionTime = nv > this.min ? (int)(dT * (long)(this.max - this.min) / (long)(nv - this.min)) : this.millisToPopup) >= this.millisToPopup) {
                        this.myBar = new JProgressBar();
                        this.myBar.setPreferredSize(new Dimension(250, 18));
                        this.myBar.setMinimum(this.min);
                        this.myBar.setForeground(new Color(64, 140, 245));
                        this.myBar.setMaximum(this.max);
                        this.myBar.setValue(nv);
                        this.myBar.setIndeterminate(this.indeterminateMode);
                        if (this.note != null) {
                            this.noteLabel = new JLabel(this.note);
                            this.noteLabel.setHorizontalAlignment(0);
                            this.noteLabel.setVerticalAlignment(0);
                        }
                        if (this.addCancelButton) {
                            this.btnCancel = new JButton(Messages.getString("ProgressDialog.Cancel"));
                            this.btnCancel.setPreferredSize(new Dimension(100, 23));
                            this.pane = new ProgressOptionPane(this.noteLabel, this.myBar, this.btnCancel);
                        } else {
                            this.pane = new ProgressOptionPane(this.noteLabel, this.myBar, null);
                        }
                        this.dialog = this.pane.createDialog(this.parentComponent);
                        this.dialog.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
                        this.dialog.setVisible(true);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error updating ProgressMonitor!", e);
        }
    }

    public void close() {
        try {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
                this.pane = null;
                this.myBar = null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error closing ProgressMonitor!", e);
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int m) {
        this.min = m;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int m) {
        this.max = m;
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String note) {
        this.note = note;
        if (this.noteLabel != null) {
            this.noteLabel.setText(note);
        }
    }

    public String getNote() {
        return this.note;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public JButton getButtonCancel() {
        return this.btnCancel;
    }

    private class ProgressOptionPane {
        private JLabel label;
        private JProgressBar bar;
        private Icon icon;
        private JButton btnCancel;

        ProgressOptionPane(JLabel nLabel, JProgressBar pBar, JButton btnCancel) {
            this.icon = ProgressDialog.this.view.getConfiguration().getIcon("PROGRESS_ICON");
            this.label = nLabel;
            this.bar = pBar;
            this.btnCancel = btnCancel;
        }

        public JDialog createDialog(Component parentComponent) {
            Frame frame = JOptionPane.getFrameForComponent(parentComponent);
            JDialog dialog = new JDialog(frame);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createBevelBorder(0));
            JPanel iconPanel = new JPanel();
            iconPanel.add(new JLabel(this.icon));
            panel.add((Component)iconPanel, "Center");
            JPanel statusPanel = new JPanel(new GridLayout(0, 1));
            JPanel lbPanel = new JPanel(new BorderLayout());
            lbPanel.add(this.label);
            statusPanel.add(lbPanel);
            JPanel status = new JPanel();
            status.add(this.bar);
            statusPanel.add(status);
            if (this.btnCancel != null) {
                JPanel btnPanel = new JPanel(new FlowLayout(2));
                btnPanel.add(this.btnCancel);
                statusPanel.add(btnPanel);
            }
            panel.add((Component)statusPanel, "After");
            contentPane.add((Component)panel, "Center");
            dialog.setUndecorated(true);
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            return dialog;
        }
    }
}

