/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.domains;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.ConstrainedObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AVTEditor
extends JDialog {
    private static final String[] TYPES_NUMBER = new String[]{"DECIMAL", "INTEGER", "REAL", "SMALLINT", "NUMERIC", "DOUBLE", "FLOAT", "TINYINT", "BIGINT"};
    private JDialog dialog;
    private JTable editorPane;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private ConstrainedObject object;
    private JButton bnAddAVT;
    private JButton bnModifyAVT;
    private JButton bnRemoveAVT;
    private boolean readOnly = false;
    private JTextField tfBeginValue;
    private JTextField tfEndValue;
    private JTextField tfDesc;
    private JRadioButton rbAsc;
    private JRadioButton rbDesc;
    private List avtList;
    private LogicalDatatype logicalDataType;
    private Dialog parent;
    private JButton bnCancel;
    KeyListener escKey = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                AVTEditor.this.bnCancel.doClick();
            }
        }
    };

    public AVTEditor(Dialog parent) {
        this.parent = parent;
    }

    public AVTEditor(Dialog parent, boolean readOnly) {
        this.parent = parent;
        this.readOnly = readOnly;
    }

    public void configureEditComponentFor(ConstrainedObject object, LogicalDatatype logicalDataType) {
        this.object = object;
        this.logicalDataType = logicalDataType;
    }

    public void doEditing(ConstrainedObject object) {
        this.dialog = this.getDialog();
        this.dialog.setTitle(MessageFormat.format(Messages.getString("AVTEditor.AVTTitle"), object.getName()));
        this.dialog.setVisible(true);
    }

    protected JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("AVTEditor.AVT"));
            this.dialog.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.setSize(new Dimension(680, 350));
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = AVTEditor.this.dialog.getWidth();
                    int h = AVTEditor.this.dialog.getHeight();
                    w = Math.max(680, w);
                    h = Math.max(350, h);
                    AVTEditor.this.dialog.setSize(w, h);
                }
            });
            this.initData();
        }
        CommonUtil.centerOnScreen(this.dialog);
        return this.dialog;
    }

    private void initData() {
        this.avtList.clear();
        for (AVT next : this.object.getAVTs()) {
            AVT avt = new AVT();
            next.copyTo(avt);
            this.avtList.add(avt);
        }
        if (this.object.getAVTSortOrder() == 0) {
            this.rbAsc.setSelected(true);
        } else {
            this.rbDesc.setSelected(true);
        }
        this.sortList();
        this.editorPane.updateUI();
        this.editorPane.setEnabled(!this.readOnly);
        this.rbAsc.setEnabled(!this.readOnly);
        this.rbDesc.setEnabled(!this.readOnly);
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            JPanel pnTop = new JPanel(new FlowLayout(0));
            JPanel pnBegin = new JPanel(new BorderLayout());
            JLabel lbBeginValue = new JLabel(Messages.getString("AVTEditor.BeginValueS"));
            this.tfBeginValue = new JTextField(14);
            this.tfBeginValue.setEnabled(!this.readOnly);
            this.tfBeginValue.addKeyListener(this.escKey);
            pnBegin.add((Component)lbBeginValue, "North");
            pnBegin.add((Component)this.tfBeginValue, "Center");
            JPanel pnEnd = new JPanel(new BorderLayout());
            JLabel lbEndValue = new JLabel(Messages.getString("AVTEditor.EndValueS"));
            this.tfEndValue = new JTextField(14);
            this.tfEndValue.setEnabled(!this.readOnly);
            this.tfEndValue.addKeyListener(this.escKey);
            pnEnd.add((Component)lbEndValue, "North");
            pnEnd.add((Component)this.tfEndValue, "Center");
            JPanel pnDesc = new JPanel(new BorderLayout());
            JLabel lbDesc = new JLabel(Messages.getString("AVTEditor.DescriptionS"));
            this.tfDesc = new JTextField(30);
            this.tfDesc.setEnabled(!this.readOnly);
            this.tfDesc.addKeyListener(this.escKey);
            pnDesc.add((Component)lbDesc, "North");
            pnDesc.add((Component)this.tfDesc, "Center");
            pnTop.add(pnBegin);
            pnTop.add(pnEnd);
            pnTop.add(pnDesc);
            JPanel pnCenter = new JPanel(new BorderLayout());
            pnCenter.add((Component)pnTop, "North");
            pnCenter.add((Component)new JScrollPane(this.getEditorPane()), "Center");
            this.mainPanel.add((Component)pnCenter, "Center");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel north = new JPanel(new GridLayout(0, 1, 5, 5));
            this.bnRemoveAVT = new JButton(Messages.getString("AVTEditor.Remove"));
            this.bnRemoveAVT.setMnemonic(82);
            this.bnRemoveAVT.setEnabled(!this.readOnly);
            this.bnRemoveAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AVTEditor.this.editorPane.getSelectedRow();
                    if (row > -1 && AVTEditor.this.avtList.size() > 0) {
                        AVTEditor.this.avtList.remove(row);
                        AVTEditor.this.editorPane.updateUI();
                        if (AVTEditor.this.avtList.size() > 0) {
                            AVTEditor.this.editorPane.removeRowSelectionInterval(0, AVTEditor.this.avtList.size() - 1);
                        }
                        AVTEditor.this.tfBeginValue.setText("");
                        AVTEditor.this.tfBeginValue.requestFocus();
                        AVTEditor.this.tfEndValue.setText("");
                        AVTEditor.this.tfDesc.setText("");
                        AVTEditor.this.bnRemoveAVT.setEnabled(false);
                        AVTEditor.this.bnModifyAVT.setEnabled(false);
                    }
                }
            });
            this.bnRemoveAVT.addKeyListener(this.escKey);
            this.bnRemoveAVT.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnRemoveAVT.setEnabled(false);
            this.bnModifyAVT = new JButton(Messages.getString("AVTEditor.Modify"));
            this.bnModifyAVT.setMnemonic(77);
            this.bnModifyAVT.setEnabled(!this.readOnly);
            this.bnModifyAVT.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnModifyAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row;
                    if (AVTEditor.this.canAdd() && (row = AVTEditor.this.editorPane.getSelectedRow()) > -1) {
                        AVT avt = (AVT)AVTEditor.this.avtList.get(row);
                        avt.setBeginValue(AVTEditor.this.tfBeginValue.getText());
                        avt.setEndValue(AVTEditor.this.tfEndValue.getText());
                        avt.setDescription(AVTEditor.this.tfDesc.getText());
                        AVTEditor.this.sortList();
                        AVTEditor.this.editorPane.updateUI();
                    }
                }
            });
            this.bnModifyAVT.setEnabled(false);
            this.bnModifyAVT.addKeyListener(this.escKey);
            this.bnAddAVT = new JButton(Messages.getString("AVTEditor.Add"));
            this.bnAddAVT.setMnemonic(65);
            this.bnAddAVT.setEnabled(!this.readOnly);
            this.bnAddAVT.setPreferredSize(MessageDialogs.BUTTON_SIZE_EX);
            this.bnAddAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AVTEditor.this.canAdd()) {
                        AVT avt = new AVT(AVTEditor.this.tfBeginValue.getText(), AVTEditor.this.tfEndValue.getText(), AVTEditor.this.tfDesc.getText());
                        AVTEditor.this.avtList.add(avt);
                        AVTEditor.this.sortList();
                        AVTEditor.this.editorPane.updateUI();
                        AVTEditor.this.tfBeginValue.setText("");
                        AVTEditor.this.tfBeginValue.requestFocus();
                        AVTEditor.this.tfEndValue.setText("");
                        AVTEditor.this.tfDesc.setText("");
                        AVTEditor.this.editorPane.removeRowSelectionInterval(0, AVTEditor.this.avtList.size() - 1);
                        AVTEditor.this.bnRemoveAVT.setEnabled(false);
                        AVTEditor.this.bnModifyAVT.setEnabled(false);
                    }
                }
            });
            this.bnAddAVT.addKeyListener(this.escKey);
            north.add(this.bnAddAVT);
            north.add(this.bnModifyAVT);
            north.add(this.bnRemoveAVT);
            north.add(new JPanel());
            this.rbAsc = new JRadioButton(Messages.getString("AVTEditor.Ascending"));
            this.rbAsc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AVTEditor.this.sortList();
                    AVTEditor.this.editorPane.updateUI();
                }
            });
            this.rbAsc.addKeyListener(this.escKey);
            this.rbDesc = new JRadioButton(Messages.getString("AVTEditor.Descending"));
            this.rbDesc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AVTEditor.this.sortList();
                    AVTEditor.this.editorPane.updateUI();
                }
            });
            this.rbDesc.addKeyListener(this.escKey);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbAsc);
            bg.add(this.rbDesc);
            JPanel pnSort = new JPanel(new GridLayout(0, 1));
            pnSort.setBorder(BorderFactory.createTitledBorder(Messages.getString("AVTEditor.SortOrder")));
            pnSort.add(this.rbAsc);
            pnSort.add(this.rbDesc);
            JPanel jpanel = new JPanel(new BorderLayout());
            jpanel.add((Component)north, "North");
            jpanel.add((Component)pnSort, "Center");
            panel.add((Component)jpanel, "North");
            this.mainPanel.add((Component)panel, "East");
        }
        return this.mainPanel;
    }

    protected JTable getEditorPane() {
        if (this.editorPane == null) {
            this.avtList = new ArrayList();
            this.editorPane = new JTable(new AVTTableModel());
            this.editorPane.setSelectionMode(0);
            ListSelectionModel rowSM = this.editorPane.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!AVTEditor.this.readOnly) {
                        try {
                            AVTEditor.this.bnRemoveAVT.setEnabled(true);
                            AVTEditor.this.bnModifyAVT.setEnabled(true);
                            int row = AVTEditor.this.editorPane.getSelectedRow();
                            if (row > -1 && AVTEditor.this.avtList.size() > 0) {
                                AVT avt = (AVT)AVTEditor.this.avtList.get(row);
                                AVTEditor.this.tfBeginValue.setText(avt.getBeginValue());
                                AVTEditor.this.tfEndValue.setText(avt.getEndValue());
                                AVTEditor.this.tfDesc.setText(avt.getDescription());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.editorPane.addKeyListener(this.escKey);
        }
        return this.editorPane;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            if (!this.readOnly) {
                JButton ok = new JButton(Messages.getString("AVTEditor.OK"));
                ok.setMnemonic(79);
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AVTEditor.this.setProperties();
                        AVTEditor.this.getDialog().setVisible(false);
                    }
                });
                this.buttonPanel.add(ok);
            }
            String caption = this.readOnly ? Messages.getString("AVTEditor.Close") : Messages.getString("AVTEditor.Cancel");
            this.bnCancel = new JButton(caption);
            this.bnCancel.setMnemonic(67);
            this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AVTEditor.this.getDialog().setVisible(false);
                }
            });
            this.buttonPanel.add(this.bnCancel);
        }
        return this.buttonPanel;
    }

    private void setProperties() {
        this.object.clearAVTs();
        if (this.object instanceof Column) {
            ((Column)this.object).setUseDomainConstraints(false);
        }
        for (AVT next : this.avtList) {
            AVT avt = new AVT();
            next.copyTo(avt);
            this.object.addAVT(avt);
        }
        if (this.rbAsc.isSelected()) {
            this.object.setAVTSortOrder(0);
        } else {
            this.object.setAVTSortOrder(1);
        }
    }

    private boolean canAdd() {
        if ("".equalsIgnoreCase(this.tfBeginValue.getText())) {
            MessageDialogs.showWarningMessage(Messages.getString("AVTEditor.BeginValueCanNotBeEmpty"));
            return false;
        }
        if (this.isNumber()) {
            String bv = this.tfBeginValue.getText();
            try {
                Double.parseDouble(bv);
            }
            catch (Exception e) {
                MessageDialogs.showWarningMessage(MessageFormat.format(Messages.getString("AVTEditor.BeginValueCanNotBeConverted"), this.logicalDataType.toString()));
                return false;
            }
            String ev = this.tfEndValue.getText();
            if (!"".equals(ev)) {
                try {
                    Double.parseDouble(ev);
                }
                catch (Exception e) {
                    MessageDialogs.showWarningMessage(MessageFormat.format(Messages.getString("AVTEditor.EndValueCanNotBeConverted"), this.logicalDataType.toString()));
                    return false;
                }
            }
        }
        return true;
    }

    private String getNativeDataType() {
        int pos;
        Map map = this.logicalDataType.getToPhysical();
        String nativeDT = (String)map.get(StorageDesignDB2v70.RDBMS_TYPE.getTypeName());
        if (nativeDT == null) {
            nativeDT = this.logicalDataType.toString();
        }
        if ((pos = nativeDT.indexOf(44)) > -1) {
            nativeDT = nativeDT.substring(0, pos).trim();
        }
        return nativeDT;
    }

    private boolean isNumber() {
        String nativeDT = this.getNativeDataType();
        for (int i = 0; i < TYPES_NUMBER.length; ++i) {
            if (!TYPES_NUMBER[i].equalsIgnoreCase(nativeDT)) continue;
            return true;
        }
        return false;
    }

    private void sortList() {
        if (this.isNumber()) {
            Collections.sort(this.avtList, new AVTNumberComparator(this.rbAsc.isSelected()));
        } else {
            Collections.sort(this.avtList, new AVTStringComparator(this.rbAsc.isSelected()));
        }
    }

    private class AVTNumberComparator
    implements Comparator {
        boolean asc;

        public AVTNumberComparator(boolean asc) {
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            double d2;
            double d1;
            String bv1 = ((AVT)o1).getBeginValue();
            String bv2 = ((AVT)o2).getBeginValue();
            try {
                d1 = Double.parseDouble(bv1);
            }
            catch (Exception e) {
                d1 = 0.0;
            }
            try {
                d2 = Double.parseDouble(bv2);
            }
            catch (Exception e) {
                d2 = 0.0;
            }
            if (d1 > d2) {
                if (this.asc) {
                    return 1;
                }
                return -1;
            }
            if (d2 > d1) {
                if (this.asc) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    private class AVTStringComparator
    implements Comparator {
        boolean asc;

        public AVTStringComparator(boolean asc) {
            this.asc = asc;
        }

        public int compare(Object o1, Object o2) {
            if (this.asc) {
                return ((AVT)o1).getBeginValue().compareTo(((AVT)o2).getBeginValue());
            }
            return ((AVT)o2).getBeginValue().compareTo(((AVT)o1).getBeginValue());
        }
    }

    class AVTTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("AVTEditor.BeginValue"), Messages.getString("AVTEditor.EndValue"), Messages.getString("AVTEditor.Description")};

        AVTTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return AVTEditor.this.avtList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        public Class getColumnClass(int c) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            AVT avt = (AVT)AVTEditor.this.avtList.get(row);
            if (col == 0) {
                return avt.getBeginValue();
            }
            if (col == 1) {
                return avt.getEndValue();
            }
            if (col == 2) {
                return avt.getDescription();
            }
            return new Integer(row * col);
        }
    }
}

