/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.objects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.ide.Ide;

public class ObjectNamesAdmin
extends CustomDialog {
    private final String TABLES = "Tables";
    private final String COLUMNS = "Columns";
    private final String PKUK_CONSTRAINT = "PK and UK Constraints";
    private final String INDEXES = "Indexes";
    private final String FOREIGN_KEYS = "Foreign Keys";
    private final String TABLES_VIEWS = "Views";
    private final String SCHEMA_OBJECTS = "Schemas";
    private final String ENTITIES = "Entities";
    private final String ATTRIBUTES = "Attributes";
    private final String RELATIONS = "Relations";
    private final String IDENTIFIERS = "Identifiers";
    private final String ENTITIES_VIEWS = "Views";
    private JDialog dialog;
    private boolean result = false;
    private JPanel mainPanel;
    private JTabbedPane tpane;
    private JButton btnApply;
    private JButton btnClose;
    private JPanel tablesPanel;
    private JPanel columnsPanel;
    private JPanel pkukPanel;
    private JPanel indexesPanel;
    private JPanel fkPanel;
    private JPanel tableViewsPanel;
    private JPanel soPanel;
    private JPanel entitiesPanel;
    private JPanel attributesPanel;
    private JPanel relationsPanel;
    private JPanel identifiersPanel;
    private JPanel entityViewsPanel;
    private List tablesList;
    private List columnsList;
    private List pkukList;
    private List indexesList;
    private List fkList;
    private List tableViewsList;
    private List schemaObjectList;
    private List entitiesList;
    private List attributesList;
    private List relationsList;
    private List identifiersList;
    private List entityViewsList;
    private JTable tablesTable;
    private JTable columnsTable;
    private JTable pkukTable;
    private JTable indexesTable;
    private JTable fkTable;
    private JTable tableViewsTable;
    private JTable soTable;
    private JTable entitiesTable;
    private JTable attributesTable;
    private JTable relationsTable;
    private JTable identifiersTable;
    private JTable entityViewsTable;
    private JTextField tableNamefilter;
    private JTextField columnNamefilter;
    private JTextField pkukNamefilter;
    private JTextField indexNamefilter;
    private JTextField fkNamefilter;
    private JTextField tableViewNamefilter;
    private JTextField soNamefilter;
    private JTextField entityNamefilter;
    private JTextField attributeNamefilter;
    private JTextField relationNamefilter;
    private JTextField identifierNamefilter;
    private JTextField entityViewNamefilter;
    private JButton btnLockAllTables;
    private JButton btnLockAllColumn;
    private JButton btnLockAllPKUK;
    private JButton btnLockAllIdx;
    private JButton btnLockAllFK;
    private JButton btnLockAllViews;
    private JButton btnLockAllSO;
    private JButton btnLockAllEntities;
    private JButton btnLockAllAttributes;
    private JButton btnLockAllRelations;
    private JButton btnLockAllIdentifiers;
    private JButton btnLockAllEntityViews;
    private JButton btnUnLockAllTables;
    private JButton btnUnLockAllColumn;
    private JButton btnUnLockAllPKUK;
    private JButton btnUnLockAllIdx;
    private JButton btnUnLockAllFK;
    private JButton btnUnLockAllViews;
    private JButton btnUnLockAllSO;
    private JButton btnUnLockAllEntities;
    private JButton btnUnLockAllAttributes;
    private JButton btnUnLockAllRelations;
    private JButton btnUnLockAllIdentifiers;
    private JButton btnUnLockAllEntityViews;
    private TableRowSorter<TwoColumnsTableModel> twoCSorter;
    private TableRowSorter<ThreeColumnsTableModel> threeCSorter;
    private TableRowSorter<FiveColumnsTableModel> fiveCSorter;
    private TableRowSorter<FourColumnsTableModel> fourCSorter;
    private JButton btnHelp;
    private ApplicationView appView;

    public ObjectNamesAdmin(ApplicationView appView) {
        super(appView);
        this.appView = appView;
        this.initUI();
    }

    private void initUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(550, 490));
        this.tpane = new JTabbedPane();
        DesignPartView currentModel = this.appView.getCurrentDPV();
        if (currentModel instanceof DPVRelational) {
            this.initTables();
            this.initColumns();
            this.initPKUK();
            this.initIndexes();
            this.initFK();
            this.initTableViews();
            this.initSchemaObjects();
        } else if (currentModel instanceof DPVLogical) {
            this.initEntities();
            this.initAttributes();
            this.initRelations();
            this.initIdentifiers();
            this.initEntityViews();
        }
        this.initData(currentModel);
        this.tpane.addChangeListener(new TabsListener());
        this.mainPanel.add((Component)this.tpane, "Center");
        this.initButtons();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initTables() {
        this.tablesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.tableNamefilter = new JTextField();
        this.tableNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 2));
        this.tableNamefilter.setEnabled(false);
        this.tableNamefilter.setPreferredSize(new Dimension(200, 20));
        this.tableNamefilter.setMinimumSize(new Dimension(200, 20));
        this.tableNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllTables = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllTables.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllTables.setEnabled(false);
        this.btnLockAllTables.setMnemonic(83);
        this.btnLockAllTables.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.tablesTable, ObjectNamesAdmin.this.tablesList, true);
                ObjectNamesAdmin.this.tablesTable.updateUI();
            }
        });
        this.btnUnLockAllTables = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllTables.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllTables.setEnabled(false);
        this.btnUnLockAllTables.setMnemonic(68);
        this.btnUnLockAllTables.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.tablesTable, ObjectNamesAdmin.this.tablesList, false);
                ObjectNamesAdmin.this.tablesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllTables);
        toolBar.add(this.btnUnLockAllTables);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.tableNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.tablesList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.tablesList, "Tables");
        this.tablesTable = new JTable(model);
        this.tableNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableNamefilter, this.tablesTable, 1));
        TableColumn col0 = this.tablesTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        col0.setMaxWidth(250);
        TableColumn col1 = this.tablesTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        col1.setMaxWidth(250);
        TableColumn col2 = this.tablesTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tablesTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.tablesPanel.add((Component)northPanel, "North");
        this.tablesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Tables", this.getConfiguration().getIcon("TABLE_ICON"), this.tablesPanel);
    }

    private void initColumns() {
        this.columnsPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.columnNamefilter = new JTextField();
        this.columnNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 3));
        this.columnNamefilter.setEnabled(false);
        this.columnNamefilter.setPreferredSize(new Dimension(200, 20));
        this.columnNamefilter.setMinimumSize(new Dimension(200, 20));
        this.columnNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllColumn = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllColumn.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllColumn.setEnabled(false);
        this.btnLockAllColumn.setMnemonic(83);
        this.btnLockAllColumn.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.columnsTable, ObjectNamesAdmin.this.columnsList, true);
                ObjectNamesAdmin.this.columnsTable.updateUI();
            }
        });
        this.btnUnLockAllColumn = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllColumn.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllColumn.setEnabled(false);
        this.btnUnLockAllColumn.setMnemonic(68);
        this.btnUnLockAllColumn.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.columnsTable, ObjectNamesAdmin.this.columnsList, false);
                ObjectNamesAdmin.this.columnsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllColumn);
        toolBar.add(this.btnUnLockAllColumn);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.columnNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.columnsList = new ArrayList();
        FourColumnsTableModel model = new FourColumnsTableModel(this.columnsList, "Columns");
        this.columnsTable = new JTable(model);
        this.columnNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.columnNamefilter, this.columnsTable, 2));
        TableColumn col0 = this.columnsTable.getColumnModel().getColumn(0);
        col0.setWidth(166);
        col0.setMaxWidth(166);
        TableColumn col1 = this.columnsTable.getColumnModel().getColumn(1);
        col1.setWidth(166);
        col1.setMaxWidth(166);
        TableColumn col2 = this.columnsTable.getColumnModel().getColumn(2);
        col2.setWidth(168);
        col2.setMaxWidth(168);
        TableColumn col3 = this.columnsTable.getColumnModel().getColumn(3);
        col3.setWidth(50);
        col3.setMaxWidth(50);
        this.fourCSorter = new TableRowSorter<FourColumnsTableModel>(model);
        this.fourCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.columnsPanel.add((Component)northPanel, "North");
        this.columnsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Columns", this.getConfiguration().getIcon("COLUMN_ICON"), this.columnsPanel);
    }

    private void initPKUK() {
        this.pkukPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.pkukNamefilter = new JTextField();
        this.pkukNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 3));
        this.pkukNamefilter.setEnabled(false);
        this.pkukNamefilter.setPreferredSize(new Dimension(200, 20));
        this.pkukNamefilter.setMinimumSize(new Dimension(200, 20));
        this.pkukNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllPKUK = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllPKUK.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllPKUK.setEnabled(false);
        this.btnLockAllPKUK.setMnemonic(83);
        this.btnLockAllPKUK.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllPKUK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.pkukTable, ObjectNamesAdmin.this.pkukList, true);
                ObjectNamesAdmin.this.pkukTable.updateUI();
            }
        });
        this.btnUnLockAllPKUK = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllPKUK.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllPKUK.setEnabled(false);
        this.btnUnLockAllPKUK.setMnemonic(68);
        this.btnUnLockAllPKUK.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllPKUK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.pkukTable, ObjectNamesAdmin.this.pkukList, false);
                ObjectNamesAdmin.this.pkukTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllPKUK);
        toolBar.add(this.btnUnLockAllPKUK);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.pkukNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.pkukList = new ArrayList();
        FourColumnsTableModel model = new FourColumnsTableModel(this.pkukList, "PK and UK Constraints");
        this.pkukTable = new JTable(model);
        this.pkukNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.pkukNamefilter, this.pkukTable, 2));
        TableColumn col0 = this.pkukTable.getColumnModel().getColumn(0);
        col0.setWidth(166);
        col0.setMaxWidth(166);
        TableColumn col1 = this.pkukTable.getColumnModel().getColumn(1);
        col1.setWidth(166);
        col1.setMaxWidth(166);
        TableColumn col2 = this.pkukTable.getColumnModel().getColumn(2);
        col2.setWidth(168);
        col2.setMaxWidth(168);
        TableColumn col3 = this.pkukTable.getColumnModel().getColumn(3);
        col3.setWidth(50);
        col3.setMaxWidth(50);
        this.fourCSorter = new TableRowSorter<FourColumnsTableModel>(model);
        this.fourCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.pkukTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.pkukPanel.add((Component)northPanel, "North");
        this.pkukPanel.add((Component)sp, "Center");
        this.tpane.addTab("PK and UK Constraints", this.getConfiguration().getIcon("PK_ICON"), this.pkukPanel);
    }

    private void initIndexes() {
        this.indexesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.indexNamefilter = new JTextField();
        this.indexNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 4));
        this.indexNamefilter.setEnabled(false);
        this.indexNamefilter.setPreferredSize(new Dimension(200, 20));
        this.indexNamefilter.setMinimumSize(new Dimension(200, 20));
        this.indexNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllIdx = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllIdx.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllIdx.setEnabled(false);
        this.btnLockAllIdx.setMnemonic(83);
        this.btnLockAllIdx.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllIdx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.indexesTable, ObjectNamesAdmin.this.indexesList, true);
                ObjectNamesAdmin.this.indexesTable.updateUI();
            }
        });
        this.btnUnLockAllIdx = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllIdx.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllIdx.setEnabled(false);
        this.btnUnLockAllIdx.setMnemonic(68);
        this.btnUnLockAllIdx.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllIdx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.indexesTable, ObjectNamesAdmin.this.indexesList, false);
                ObjectNamesAdmin.this.indexesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllIdx);
        toolBar.add(this.btnUnLockAllIdx);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.indexNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.indexesList = new ArrayList();
        FiveColumnsTableModel model = new FiveColumnsTableModel(this.indexesList, "Indexes");
        this.indexesTable = new JTable(model);
        this.indexNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.indexNamefilter, this.indexesTable, 3));
        TableColumn col0 = this.indexesTable.getColumnModel().getColumn(0);
        col0.setWidth(125);
        col0.setMaxWidth(125);
        TableColumn col1 = this.indexesTable.getColumnModel().getColumn(1);
        col1.setWidth(125);
        col1.setMaxWidth(125);
        TableColumn col2 = this.indexesTable.getColumnModel().getColumn(2);
        col2.setWidth(125);
        col2.setMaxWidth(125);
        TableColumn col3 = this.indexesTable.getColumnModel().getColumn(3);
        col3.setWidth(125);
        col3.setMaxWidth(125);
        TableColumn col4 = this.indexesTable.getColumnModel().getColumn(4);
        col4.setWidth(50);
        col4.setMaxWidth(50);
        this.fiveCSorter = new TableRowSorter<FiveColumnsTableModel>(model);
        this.fiveCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.indexesTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.indexesPanel.add((Component)northPanel, "North");
        this.indexesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Indexes", this.getConfiguration().getIcon("INDEX_ICON"), this.indexesPanel);
    }

    private void initFK() {
        this.fkPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.fkNamefilter = new JTextField();
        this.fkNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 3));
        this.fkNamefilter.setEnabled(false);
        this.fkNamefilter.setPreferredSize(new Dimension(200, 20));
        this.fkNamefilter.setMinimumSize(new Dimension(200, 20));
        this.fkNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllFK = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllFK.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllFK.setEnabled(false);
        this.btnLockAllFK.setMnemonic(83);
        this.btnLockAllFK.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.fkTable, ObjectNamesAdmin.this.fkList, true);
                ObjectNamesAdmin.this.fkTable.updateUI();
            }
        });
        this.btnUnLockAllFK = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllFK.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllFK.setEnabled(false);
        this.btnUnLockAllFK.setMnemonic(68);
        this.btnUnLockAllFK.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.fkTable, ObjectNamesAdmin.this.fkList, false);
                ObjectNamesAdmin.this.fkTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllFK);
        toolBar.add(this.btnUnLockAllFK);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.fkNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.fkList = new ArrayList();
        FourColumnsTableModel model = new FourColumnsTableModel(this.fkList, "Foreign Keys");
        this.fkTable = new JTable(model);
        this.fkNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.fkNamefilter, this.fkTable, 2));
        TableColumn col0 = this.fkTable.getColumnModel().getColumn(0);
        col0.setWidth(166);
        col0.setMaxWidth(166);
        TableColumn col1 = this.fkTable.getColumnModel().getColumn(1);
        col1.setWidth(166);
        col1.setMaxWidth(166);
        TableColumn col2 = this.fkTable.getColumnModel().getColumn(2);
        col2.setWidth(168);
        col2.setMaxWidth(168);
        TableColumn col3 = this.fkTable.getColumnModel().getColumn(3);
        col3.setWidth(50);
        col3.setMaxWidth(50);
        this.fourCSorter = new TableRowSorter<FourColumnsTableModel>(model);
        this.fourCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.fkTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.fkPanel.add((Component)northPanel, "North");
        this.fkPanel.add((Component)sp, "Center");
        this.tpane.addTab("Foreign Keys", this.getConfiguration().getIcon("FK_ICON"), this.fkPanel);
    }

    private void initTableViews() {
        this.tableViewsPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.tableViewNamefilter = new JTextField();
        this.tableViewNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 2));
        this.tableViewNamefilter.setEnabled(false);
        this.tableViewNamefilter.setPreferredSize(new Dimension(200, 20));
        this.tableViewNamefilter.setMinimumSize(new Dimension(200, 20));
        this.tableViewNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllViews = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllViews.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllViews.setEnabled(false);
        this.btnLockAllViews.setMnemonic(83);
        this.btnLockAllViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.tableViewsTable, ObjectNamesAdmin.this.tableViewsList, true);
                ObjectNamesAdmin.this.tableViewsTable.updateUI();
            }
        });
        this.btnUnLockAllViews = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllViews.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllViews.setEnabled(false);
        this.btnUnLockAllViews.setMnemonic(68);
        this.btnUnLockAllViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.tableViewsTable, ObjectNamesAdmin.this.tableViewsList, false);
                ObjectNamesAdmin.this.tableViewsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllViews);
        toolBar.add(this.btnUnLockAllViews);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.tableViewNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.tableViewsList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.tableViewsList, "Views");
        this.tableViewsTable = new JTable(model);
        this.tableViewNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableViewNamefilter, this.tableViewsTable, 1));
        TableColumn col0 = this.tableViewsTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        col0.setMaxWidth(250);
        TableColumn col1 = this.tableViewsTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        col1.setMaxWidth(250);
        TableColumn col2 = this.tableViewsTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tableViewsTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.tableViewsPanel.add((Component)northPanel, "North");
        this.tableViewsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Views", this.getConfiguration().getIcon("VIEW_ICON"), this.tableViewsPanel);
    }

    private void initSchemaObjects() {
        this.soPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.soNamefilter = new JTextField();
        this.soNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 1));
        this.soNamefilter.setEnabled(false);
        this.soNamefilter.setPreferredSize(new Dimension(200, 20));
        this.soNamefilter.setMinimumSize(new Dimension(200, 20));
        this.soNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllSO = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllSO.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllSO.setEnabled(false);
        this.btnLockAllSO.setMnemonic(83);
        this.btnLockAllSO.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllSO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.soTable, ObjectNamesAdmin.this.schemaObjectList, true);
                ObjectNamesAdmin.this.soTable.updateUI();
            }
        });
        this.btnUnLockAllSO = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllSO.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllSO.setEnabled(false);
        this.btnUnLockAllSO.setMnemonic(68);
        this.btnUnLockAllSO.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllSO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.soTable, ObjectNamesAdmin.this.schemaObjectList, false);
                ObjectNamesAdmin.this.soTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllSO);
        toolBar.add(this.btnUnLockAllSO);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.soNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.schemaObjectList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.schemaObjectList);
        this.soTable = new JTable(model);
        this.soNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.soNamefilter, this.soTable, 0));
        TableColumn col0 = this.soTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        col0.setMaxWidth(500);
        TableColumn col1 = this.soTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.soTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.soPanel.add((Component)northPanel, "North");
        this.soPanel.add((Component)sp, "Center");
        this.tpane.addTab("Schemas", this.getConfiguration().getIcon("SCHEMA_ICON"), this.soPanel);
    }

    private void initEntities() {
        this.entitiesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.entityNamefilter = new JTextField();
        this.entityNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 1));
        this.entityNamefilter.setEnabled(false);
        this.entityNamefilter.setPreferredSize(new Dimension(200, 20));
        this.entityNamefilter.setMinimumSize(new Dimension(200, 20));
        this.entityNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllEntities = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllEntities.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllEntities.setEnabled(false);
        this.btnLockAllEntities.setMnemonic(83);
        this.btnLockAllEntities.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.entitiesTable, ObjectNamesAdmin.this.entitiesList, true);
                ObjectNamesAdmin.this.entitiesTable.updateUI();
            }
        });
        this.btnUnLockAllEntities = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllEntities.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllEntities.setEnabled(false);
        this.btnUnLockAllEntities.setMnemonic(68);
        this.btnUnLockAllEntities.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.entitiesTable, ObjectNamesAdmin.this.entitiesList, false);
                ObjectNamesAdmin.this.entitiesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllEntities);
        toolBar.add(this.btnUnLockAllEntities);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.entityNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.entitiesList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.entitiesList);
        this.entitiesTable = new JTable(model);
        this.entityNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.entityNamefilter, this.entitiesTable, 0));
        TableColumn col0 = this.entitiesTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        col0.setMaxWidth(500);
        TableColumn col1 = this.entitiesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.entitiesTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.entitiesPanel.add((Component)northPanel, "North");
        this.entitiesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Entities", this.getConfiguration().getIcon("ENTITY_ICON"), this.entitiesPanel);
    }

    private void initAttributes() {
        this.attributesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.attributeNamefilter = new JTextField();
        this.attributeNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 2));
        this.attributeNamefilter.setEnabled(false);
        this.attributeNamefilter.setPreferredSize(new Dimension(200, 20));
        this.attributeNamefilter.setMinimumSize(new Dimension(200, 20));
        this.attributeNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllAttributes = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllAttributes.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllAttributes.setEnabled(false);
        this.btnLockAllAttributes.setMnemonic(83);
        this.btnLockAllAttributes.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.attributesTable, ObjectNamesAdmin.this.attributesList, true);
                ObjectNamesAdmin.this.attributesTable.updateUI();
            }
        });
        this.btnUnLockAllAttributes = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllAttributes.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllAttributes.setEnabled(false);
        this.btnUnLockAllAttributes.setMnemonic(68);
        this.btnUnLockAllAttributes.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllAttributes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.attributesTable, ObjectNamesAdmin.this.attributesList, false);
                ObjectNamesAdmin.this.attributesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllAttributes);
        toolBar.add(this.btnUnLockAllAttributes);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.attributeNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.attributesList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.attributesList, "Attributes");
        this.attributesTable = new JTable(model);
        this.attributeNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.attributeNamefilter, this.attributesTable, 1));
        TableColumn col0 = this.attributesTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        col0.setMaxWidth(250);
        TableColumn col1 = this.attributesTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        col1.setMaxWidth(250);
        TableColumn col2 = this.attributesTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.attributesTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.attributesPanel.add((Component)northPanel, "North");
        this.attributesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Attributes", this.getConfiguration().getIcon("ATTRIBUTE_ICON"), this.attributesPanel);
    }

    private void initRelations() {
        this.relationsPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.relationNamefilter = new JTextField();
        this.relationNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 2));
        this.relationNamefilter.setEnabled(false);
        this.relationNamefilter.setPreferredSize(new Dimension(200, 20));
        this.relationNamefilter.setMinimumSize(new Dimension(200, 20));
        this.relationNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllRelations = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllRelations.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllRelations.setEnabled(false);
        this.btnLockAllRelations.setMnemonic(83);
        this.btnLockAllRelations.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.relationsTable, ObjectNamesAdmin.this.relationsList, true);
                ObjectNamesAdmin.this.relationsTable.updateUI();
            }
        });
        this.btnUnLockAllRelations = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllRelations.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllRelations.setEnabled(false);
        this.btnUnLockAllRelations.setMnemonic(68);
        this.btnUnLockAllRelations.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllRelations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.relationsTable, ObjectNamesAdmin.this.relationsList, false);
                ObjectNamesAdmin.this.relationsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllRelations);
        toolBar.add(this.btnUnLockAllRelations);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.relationNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.relationsList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.relationsList, "Relations");
        this.relationsTable = new JTable(model);
        this.relationNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.relationNamefilter, this.relationsTable, 1));
        TableColumn col0 = this.relationsTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        col0.setMaxWidth(250);
        TableColumn col1 = this.relationsTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        col1.setMaxWidth(250);
        TableColumn col2 = this.relationsTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.relationsTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.relationsPanel.add((Component)northPanel, "North");
        this.relationsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Relations", this.getConfiguration().getIcon("KEY_ICON"), this.relationsPanel);
    }

    private void initIdentifiers() {
        this.identifiersPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.identifierNamefilter = new JTextField();
        this.identifierNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 2));
        this.identifierNamefilter.setEnabled(false);
        this.identifierNamefilter.setPreferredSize(new Dimension(200, 20));
        this.identifierNamefilter.setMinimumSize(new Dimension(200, 20));
        this.identifierNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllIdentifiers = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllIdentifiers.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllIdentifiers.setEnabled(false);
        this.btnLockAllIdentifiers.setMnemonic(83);
        this.btnLockAllIdentifiers.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllIdentifiers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.identifiersTable, ObjectNamesAdmin.this.identifiersList, true);
                ObjectNamesAdmin.this.identifiersTable.updateUI();
            }
        });
        this.btnUnLockAllIdentifiers = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllIdentifiers.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllIdentifiers.setEnabled(false);
        this.btnUnLockAllIdentifiers.setMnemonic(68);
        this.btnUnLockAllIdentifiers.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllIdentifiers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.identifiersTable, ObjectNamesAdmin.this.identifiersList, false);
                ObjectNamesAdmin.this.identifiersTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllIdentifiers);
        toolBar.add(this.btnUnLockAllIdentifiers);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.identifierNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.identifiersList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.identifiersList, "Identifiers");
        this.identifiersTable = new JTable(model);
        this.identifierNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.identifierNamefilter, this.identifiersTable, 0));
        TableColumn col0 = this.identifiersTable.getColumnModel().getColumn(0);
        col0.setWidth(250);
        col0.setMaxWidth(250);
        TableColumn col1 = this.identifiersTable.getColumnModel().getColumn(1);
        col1.setWidth(250);
        col1.setMaxWidth(250);
        TableColumn col2 = this.identifiersTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.identifiersTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.identifiersPanel.add((Component)northPanel, "North");
        this.identifiersPanel.add((Component)sp, "Center");
        this.tpane.addTab("Identifiers", this.getConfiguration().getIcon("INDEX_ICON"), this.identifiersPanel);
    }

    private void initEntityViews() {
        this.entityViewsPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(550, 23));
        JLabel filterLabel = new JLabel(Messages.getString("ObjectNamesAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.entityViewNamefilter = new JTextField();
        this.entityViewNamefilter.setToolTipText(MessageFormat.format(Messages.getString("ObjectNamesAdmin.FilteringColumn"), 1));
        this.entityViewNamefilter.setEnabled(false);
        this.entityViewNamefilter.setPreferredSize(new Dimension(200, 20));
        this.entityViewNamefilter.setMinimumSize(new Dimension(200, 20));
        this.entityViewNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnLockAllEntityViews = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnLockAllEntityViews.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnLockAllEntityViews.setEnabled(false);
        this.btnLockAllEntityViews.setMnemonic(83);
        this.btnLockAllEntityViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnLockAllEntityViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.entityViewsTable, ObjectNamesAdmin.this.entityViewsList, true);
                ObjectNamesAdmin.this.entityViewsTable.updateUI();
            }
        });
        this.btnUnLockAllEntityViews = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnLockAllEntityViews.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnLockAllEntityViews.setEnabled(false);
        this.btnUnLockAllEntityViews.setMnemonic(68);
        this.btnUnLockAllEntityViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnLockAllEntityViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectNamesAdmin.this.checkAll(ObjectNamesAdmin.this.entityViewsTable, ObjectNamesAdmin.this.entityViewsList, false);
                ObjectNamesAdmin.this.entityViewsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnLockAllEntityViews);
        toolBar.add(this.btnUnLockAllEntityViews);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.entityViewNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.entityViewsList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.entityViewsList);
        this.entityViewsTable = new JTable(model);
        this.entityViewNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.entityViewNamefilter, this.entityViewsTable, 0));
        TableColumn col0 = this.entityViewsTable.getColumnModel().getColumn(0);
        col0.setWidth(500);
        col0.setMaxWidth(500);
        TableColumn col1 = this.entityViewsTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.entityViewsTable);
        sp.setPreferredSize(new Dimension(550, 400));
        this.entityViewsPanel.add((Component)northPanel, "North");
        this.entityViewsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Views", this.getConfiguration().getIcon("VIEW_ICON"), this.entityViewsPanel);
    }

    private void initData(DesignPartView currentModel) {
        Iterator objectsIt = currentModel.getTVShapes().iterator();
        if (currentModel instanceof DPVRelational) {
            FixableNameObject o;
            while (objectsIt.hasNext()) {
                TopView tv = (TopView)objectsIt.next();
                DesignObject desObj = tv.getModel();
                if (desObj instanceof Table) {
                    FixableNameObject o1;
                    Table table = (Table)desObj;
                    FixableNameObject o2 = new FixableNameObject(table, table.isNameFixed());
                    this.tablesList.add(o2);
                    Column[] columns = (Column[])table.getElements();
                    for (int i = 0; i < columns.length; ++i) {
                        Column column = columns[i];
                        o1 = new FixableNameObject(column, column.isNameFixed());
                        this.columnsList.add(o1);
                    }
                    Iterator itPK = table.getPKeys().iterator();
                    while (itPK.hasNext()) {
                        Index index = (Index)((ContainerObjectPlaceHolder)itPK.next()).getObject();
                        o1 = new FixableNameObject(index, index.isNameFixed());
                        this.pkukList.add(o1);
                    }
                    Iterator itUK = table.getUKeys().iterator();
                    while (itUK.hasNext()) {
                        Index index = (Index)((ContainerObjectPlaceHolder)itUK.next()).getObject();
                        FixableNameObject o12 = new FixableNameObject(index, index.isNameFixed());
                        this.pkukList.add(o12);
                    }
                    Iterator indexesIt = table.getIndexes().iterator();
                    while (indexesIt.hasNext()) {
                        Index index = (Index)((ContainerObjectPlaceHolder)indexesIt.next()).getObject();
                        FixableNameObject o13 = new FixableNameObject(index, index.isNameFixed());
                        this.indexesList.add(o13);
                    }
                    for (FKIndexAssociation fk : table.getFKAssociationsList()) {
                        FixableNameObject o14 = new FixableNameObject(fk, fk.isNameFixed());
                        this.fkList.add(o14);
                    }
                    continue;
                }
                if (!(desObj instanceof TableView)) continue;
                o = new FixableNameObject(desObj, desObj.isNameFixed());
                this.tableViewsList.add(o);
            }
            Iterator schemasIt = ((RelationalDesign)currentModel.getDesignPart()).getSchemaObjectSet().iterator();
            while (schemasIt.hasNext()) {
                SchemaObject so = (SchemaObject)schemasIt.next();
                o = new FixableNameObject(so, so.isNameFixed());
                this.schemaObjectList.add(o);
            }
            if (this.columnsList.size() > 0) {
                this.columnsTable.setRowSorter(this.fourCSorter);
                this.columnsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.columnsTable, 2);
                this.btnLockAllColumn.setEnabled(true);
                this.btnUnLockAllColumn.setEnabled(true);
                this.columnNamefilter.setEnabled(true);
            }
            if (this.tablesList.size() > 0) {
                this.tablesTable.setRowSorter(this.threeCSorter);
                this.tablesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.tablesTable, 1);
                this.btnLockAllTables.setEnabled(true);
                this.btnUnLockAllTables.setEnabled(true);
                this.tableNamefilter.setEnabled(true);
            }
            if (this.indexesList.size() > 0) {
                this.indexesTable.setRowSorter(this.fiveCSorter);
                this.indexesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.indexesTable, 3);
                this.btnLockAllIdx.setEnabled(true);
                this.btnUnLockAllIdx.setEnabled(true);
                this.indexNamefilter.setEnabled(true);
            }
            if (this.tableViewsList.size() > 0) {
                this.tableViewsTable.setRowSorter(this.threeCSorter);
                this.tableViewsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.tableViewsTable, 1);
                this.btnLockAllViews.setEnabled(true);
                this.btnUnLockAllViews.setEnabled(true);
                this.tableViewNamefilter.setEnabled(true);
            }
            if (this.pkukList.size() > 0) {
                this.pkukTable.setRowSorter(this.fourCSorter);
                this.pkukTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.pkukTable, 2);
                this.btnLockAllPKUK.setEnabled(true);
                this.btnUnLockAllPKUK.setEnabled(true);
                this.pkukNamefilter.setEnabled(true);
            }
            if (this.schemaObjectList.size() > 0) {
                this.soTable.setRowSorter(this.twoCSorter);
                this.soTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.soTable, 0);
                this.btnLockAllSO.setEnabled(true);
                this.btnUnLockAllSO.setEnabled(true);
                this.soNamefilter.setEnabled(true);
            }
            if (this.fkList.size() > 0) {
                this.fkTable.setRowSorter(this.fourCSorter);
                this.fkTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.fkTable, 2);
                this.btnLockAllFK.setEnabled(true);
                this.btnUnLockAllFK.setEnabled(true);
                this.fkNamefilter.setEnabled(true);
            }
        } else if (currentModel instanceof DPVLogical) {
            while (objectsIt.hasNext()) {
                FixableNameObject o;
                TopView tv = (TopView)objectsIt.next();
                DesignObject desObj = tv.getModel();
                if (desObj instanceof Entity) {
                    FixableNameObject o1;
                    o = new FixableNameObject(desObj, desObj.isNameFixed());
                    this.entitiesList.add(o);
                    Entity entity = (Entity)desObj;
                    Attribute[] atributes = (Attribute[])entity.getElements();
                    for (int i = 0; i < atributes.length; ++i) {
                        Attribute attribute = atributes[i];
                        o1 = new FixableNameObject(attribute, attribute.isNameFixed());
                        this.attributesList.add(o1);
                    }
                    Iterator identifiersIt = entity.getKeySet().iterator();
                    while (identifiersIt.hasNext()) {
                        CandidateKey key = (CandidateKey)identifiersIt.next();
                        o1 = new FixableNameObject(key, key.isNameFixed());
                        this.identifiersList.add(o1);
                    }
                    for (Relation rel : entity.getRelations()) {
                        FixableNameObject o15 = new FixableNameObject(rel, rel.isNameFixed());
                        this.relationsList.add(o15);
                    }
                    continue;
                }
                if (!(desObj instanceof EntityView)) continue;
                o = new FixableNameObject(desObj, desObj.isNameFixed());
                this.entityViewsList.add(o);
            }
            if (this.entitiesList.size() > 0) {
                this.entitiesTable.setRowSorter(this.twoCSorter);
                this.entitiesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.entitiesTable, 0);
                this.btnLockAllEntities.setEnabled(true);
                this.btnUnLockAllEntities.setEnabled(true);
                this.entityNamefilter.setEnabled(true);
            }
            if (this.attributesList.size() > 0) {
                this.attributesTable.setRowSorter(this.threeCSorter);
                this.attributesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.attributesTable, 1);
                this.btnLockAllAttributes.setEnabled(true);
                this.btnUnLockAllAttributes.setEnabled(true);
                this.attributeNamefilter.setEnabled(true);
            }
            if (this.relationsList.size() > 0) {
                this.relationsTable.setRowSorter(this.threeCSorter);
                this.relationsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.relationsTable, 1);
                this.btnLockAllRelations.setEnabled(true);
                this.btnUnLockAllRelations.setEnabled(true);
                this.relationNamefilter.setEnabled(true);
            }
            if (this.identifiersList.size() > 0) {
                this.identifiersTable.setRowSorter(this.threeCSorter);
                this.identifiersTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.identifiersTable, 1);
                this.btnLockAllIdentifiers.setEnabled(true);
                this.btnUnLockAllIdentifiers.setEnabled(true);
                this.identifierNamefilter.setEnabled(true);
            }
            if (this.entityViewsList.size() > 0) {
                this.entityViewsTable.setRowSorter(this.twoCSorter);
                this.entityViewsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.entityViewsTable, 0);
                this.btnLockAllEntityViews.setEnabled(true);
                this.btnUnLockAllEntityViews.setEnabled(true);
                this.entityViewNamefilter.setEnabled(true);
            }
        }
    }

    private void initButtons() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.btnApply = new JButton(Messages.getString("ObjectNamesAdmin.Apply"));
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.addActionListener(new ApplyAction());
        this.btnApply.setMnemonic(65);
        buttonsPanel.add(this.btnApply);
        this.btnClose = new JButton(Messages.getString("ObjectNamesAdmin.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new CloseAction());
        this.btnClose.setMnemonic(67);
        buttonsPanel.add(this.btnClose);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonsPanel.add(this.btnHelp);
        this.mainPanel.add((Component)buttonsPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ObjectNamesAdmin.ObjectNamesAdmin"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "FIXED_NAMES_ADMIN_DIALOG";
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void checkAll(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                Object obj = objects.get(table.convertRowIndexToModel(selected[i]));
                ((FixableNameObject)obj).setNameFixed(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), true);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), false);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), false);
            }
        }
    }

    private void setSelected(Object obj, boolean selected) {
        if (obj != null) {
            ((FixableNameObject)obj).setNameFixed(selected);
        }
    }

    private void newFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ObjectNamesAdmin.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ObjectNamesAdmin.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ObjectNamesAdmin.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    private class TabsListener
    implements ChangeListener {
        private TabsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.tablesPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.tablesList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.columnsPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.columnsList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.pkukPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.pkukList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.indexesPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.indexesList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.fkPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.fkList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.tableViewsPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.tableViewsList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.soPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.schemaObjectList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.entitiesPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.entitiesList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.attributesPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.attributesList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.relationsPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.relationsList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.identifiersPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.identifiersList.size() > 0);
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.entityViewsPanel) {
                ObjectNamesAdmin.this.btnApply.setEnabled(ObjectNamesAdmin.this.entityViewsList.size() > 0);
            }
        }
    }

    private class FixableNameObject {
        private ModelIDObject object;
        private boolean nameFixed;

        FixableNameObject(ModelIDObject object, boolean nameFixed) {
            this.object = object;
            this.nameFixed = nameFixed;
        }

        public ModelIDObject getObject() {
            return this.object;
        }

        public boolean isNameFixed() {
            return this.nameFixed;
        }

        public void setNameFixed(boolean nameFixed) {
            this.nameFixed = nameFixed;
        }
    }

    private class FiveColumnsTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public FiveColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ObjectNamesAdmin.TSchema");
            }
            if (column == 1) {
                return Messages.getString("ObjectNamesAdmin.ISchema");
            }
            if (column == 2) {
                return Messages.getString("ObjectNamesAdmin.Table");
            }
            if (column == 3) {
                return Messages.getString("ObjectNamesAdmin.Name");
            }
            if (column == 4) {
                return Messages.getString("ObjectNamesAdmin.Fixed");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            Index index = (Index)o.getObject();
            Table table = (Table)index.getContainerObject();
            SchemaObject tableSchemaObj = table.getSchemaObject();
            SchemaObject indexSchemaObj = index.getSchemaObject();
            if (columnIndex == 0) {
                return tableSchemaObj != null ? tableSchemaObj.getName() : "";
            }
            if (columnIndex == 1) {
                return indexSchemaObj != null ? indexSchemaObj.getName() : "";
            }
            if (columnIndex == 2) {
                return table.getName();
            }
            if (columnIndex == 3) {
                return index.getName();
            }
            if (columnIndex == 4) {
                return o.isNameFixed();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            if (columnIndex == 4) {
                o.setNameFixed((Boolean)value);
            }
        }
    }

    private class FourColumnsTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public FourColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ObjectNamesAdmin.Schema");
            }
            if (column == 1) {
                return Messages.getString("ObjectNamesAdmin.Table");
            }
            if (column == 2) {
                return Messages.getString("ObjectNamesAdmin.Name");
            }
            if (column == 3) {
                return Messages.getString("ObjectNamesAdmin.Fixed");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 3;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            DesignObject dObj = (DesignObject)o.getObject();
            SchemaObject schemaObj = null;
            Table table = null;
            if (dObj instanceof Column) {
                table = (Table)((Column)dObj).getContainer();
                schemaObj = table.getSchemaObject();
            } else if (dObj instanceof FKIndexAssociation) {
                table = (Table)((FKIndexAssociation)dObj).getContainerWithKeyObject();
                schemaObj = table.getSchemaObject();
            } else if (dObj instanceof Index) {
                table = (Table)((Index)dObj).getContainerWithKeyObject();
                schemaObj = table.getSchemaObject();
            }
            if (columnIndex == 0) {
                return schemaObj != null ? schemaObj.getName() : "";
            }
            if (columnIndex == 1) {
                return table.getName();
            }
            if (columnIndex == 2) {
                return dObj.getName();
            }
            if (columnIndex == 3) {
                return o.isNameFixed();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            if (columnIndex == 3) {
                o.setNameFixed((Boolean)value);
            }
        }
    }

    private class ThreeColumnsTableModel
    extends AbstractTableModel {
        private List modelList;
        private String type;

        public ThreeColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                if (this.type.equals("Tables") || this.type.equals("Views") || this.type.equals("Indexes")) {
                    return Messages.getString("ObjectNamesAdmin.Schema");
                }
                if (this.type.equals("Columns")) {
                    return Messages.getString("ObjectNamesAdmin.Table");
                }
                if (this.type.equals("Attributes") || this.type.equals("Relations") || this.type.equals("Identifiers")) {
                    return Messages.getString("ObjectNamesAdmin.Entity");
                }
                return "";
            }
            if (column == 1) {
                return Messages.getString("ObjectNamesAdmin.Name");
            }
            if (column == 2) {
                return Messages.getString("ObjectNamesAdmin.Fixed");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            ModelIDObject obj = o.getObject();
            if (columnIndex == 0) {
                if (obj instanceof Table || obj instanceof Index || obj instanceof TableView) {
                    SchemaObject schemaObj = ((ContainerObject)obj).getSchemaObject();
                    return schemaObj != null ? schemaObj.getName() : "";
                }
                if (obj instanceof ContainedObjectWithDomain) {
                    return ((DesignObject)((ContainedObjectWithDomain)obj).getParent()).getName();
                }
                if (obj instanceof Relation) {
                    return ((Relation)obj).getSourceEntity().getName();
                }
                if (obj instanceof CandidateKey) {
                    return ((CandidateKey)obj).getContainerObject().getName();
                }
                return "";
            }
            if (columnIndex == 1) {
                return o.getObject().getName();
            }
            if (columnIndex == 2) {
                return o.isNameFixed();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            if (columnIndex == 2) {
                o.setNameFixed((Boolean)value);
            }
        }
    }

    private class TwoColumnsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("ObjectNamesAdmin.Name"), Messages.getString("ObjectNamesAdmin.Fixed")};
        private List modelList;

        public TwoColumnsTableModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            if (columnIndex == 0) {
                return o.getObject().getName();
            }
            if (columnIndex == 1) {
                return o.isNameFixed();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            FixableNameObject o = (FixableNameObject)this.modelList.get(rowIndex);
            if (columnIndex == 1) {
                o.setNameFixed((Boolean)value);
            }
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Iterator objectsIt = null;
            if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.tablesPanel) {
                objectsIt = ObjectNamesAdmin.this.tablesList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.columnsPanel) {
                objectsIt = ObjectNamesAdmin.this.columnsList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.pkukPanel) {
                objectsIt = ObjectNamesAdmin.this.pkukList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.indexesPanel) {
                objectsIt = ObjectNamesAdmin.this.indexesList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.fkPanel) {
                objectsIt = ObjectNamesAdmin.this.fkList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.tableViewsPanel) {
                objectsIt = ObjectNamesAdmin.this.tableViewsList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.soPanel) {
                objectsIt = ObjectNamesAdmin.this.schemaObjectList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.entitiesPanel) {
                objectsIt = ObjectNamesAdmin.this.entitiesList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.attributesPanel) {
                objectsIt = ObjectNamesAdmin.this.attributesList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.relationsPanel) {
                objectsIt = ObjectNamesAdmin.this.relationsList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.identifiersPanel) {
                objectsIt = ObjectNamesAdmin.this.identifiersList.iterator();
            } else if (ObjectNamesAdmin.this.tpane.getSelectedComponent() == ObjectNamesAdmin.this.entityViewsPanel) {
                objectsIt = ObjectNamesAdmin.this.entityViewsList.iterator();
            }
            while (objectsIt.hasNext()) {
                FixableNameObject obj = (FixableNameObject)objectsIt.next();
                ModelIDObject mObj = obj.getObject();
                if (obj.isNameFixed()) {
                    mObj.setNameFixed(true);
                } else {
                    mObj.setNameFixed(false);
                }
                mObj.setDirty(true);
            }
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ObjectNamesAdmin.FixedNamesApplied"), Messages.getString("ObjectNamesAdmin.ObjectNamesAdmin"), 1);
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ObjectNamesAdmin.this.close();
        }
    }
}

