/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.objects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SubViewObjectsAdmin
extends CustomDialog {
    private final String TABLES = "Tables";
    private final String TABLES_VIEWS = "Views";
    private final String ENTITIES = "Entities";
    private final String ENTIIES_VIEWS = "Views";
    private final String STRUCTURED_TYPES = "Structured Types";
    private JDialog dialog;
    private JPanel mainPanel;
    private JButton btnApply;
    private JButton btnClose;
    private JButton btnHelp;
    private DesignPartView dpv;
    private JTabbedPane tpane;
    private JPanel tablesPanel;
    private JPanel tablesViewsPanel;
    private JPanel entitiesPanel;
    private JPanel entitiesViewsPanel;
    private JPanel structuredtypesPanel;
    private JTextField tableNamefilter;
    private JTextField tableViewNamefilter;
    private JTextField entityNamefilter;
    private JTextField entityViewNamefilter;
    private JTextField structuredTypeNamefilter;
    private JButton btnSelectAllTables;
    private JButton btnUnSelectAllTables;
    private JButton btnSelectAllTablesViews;
    private JButton btnUnSelectAllTablesViews;
    private JButton btnSelectAllEntities;
    private JButton btnUnSelectAllEntities;
    private JButton btnSelectAllEntitiesViews;
    private JButton btnUnSelectAllEntitiesViews;
    private JButton btnSelectAllStructuredTypes;
    private JButton btnUnSelectAllStructuredTypes;
    private JTable tablesTable;
    private JTable tablesViewsTable;
    private JTable entitiesTable;
    private JTable entitiesViewsTable;
    private JTable structuredTypesTable;
    private List tablesList;
    private List tablesViewsList;
    private List entitiesList;
    private List entitiesViewsList;
    private List structuredTypesList;
    private int pWidth = 400;
    private TableRowSorter<TwoColumnsTableModel> twoCSorter;
    private TableRowSorter<ThreeColumnsTableModel> threeCSorter;

    public SubViewObjectsAdmin(ApplicationView appView, DesignPartView dpv) {
        super(appView);
        this.dpv = dpv;
        this.init();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(this.pWidth, 490));
        this.tpane = new JTabbedPane();
        if (this.dpv instanceof DPVRelationalSubView) {
            this.initTables();
            this.initTablesViews();
        } else if (this.dpv instanceof DPVLogicalSubView) {
            this.initEntities();
            this.initEntitiesViews();
        } else if (this.dpv instanceof DPVDataTypesSubView) {
            this.initStructuredTypes();
        }
        this.initData(this.dpv);
        this.tpane.addChangeListener(new TabsListener());
        this.mainPanel.add((Component)this.tpane, "Center");
        this.initButtons();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initTables() {
        this.tablesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(this.pWidth, 23));
        JLabel filterLabel = new JLabel(Messages.getString("SubViewObjectsAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.tableNamefilter = new JTextField();
        this.tableNamefilter.setEnabled(false);
        this.tableNamefilter.setPreferredSize(new Dimension(200, 20));
        this.tableNamefilter.setMinimumSize(new Dimension(200, 20));
        this.tableNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnSelectAllTables = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllTables.setToolTipText(Messages.getString("SubViewObjectsAdmin.SelectAll"));
        this.btnSelectAllTables.setEnabled(false);
        this.btnSelectAllTables.setMnemonic(83);
        this.btnSelectAllTables.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.tablesTable, SubViewObjectsAdmin.this.tablesList, true);
                SubViewObjectsAdmin.this.tablesTable.updateUI();
            }
        });
        this.btnUnSelectAllTables = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnSelectAllTables.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnSelectAllTables.setEnabled(false);
        this.btnUnSelectAllTables.setMnemonic(68);
        this.btnUnSelectAllTables.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnSelectAllTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.tablesTable, SubViewObjectsAdmin.this.tablesList, false);
                SubViewObjectsAdmin.this.tablesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnSelectAllTables);
        toolBar.add(this.btnUnSelectAllTables);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.tableNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.tablesList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.tablesList, "Tables");
        this.tablesTable = new JTable(model);
        this.tableNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableNamefilter, this.tablesTable, 1));
        TableColumn col0 = this.tablesTable.getColumnModel().getColumn(0);
        col0.setWidth(150);
        col0.setMaxWidth(150);
        TableColumn col1 = this.tablesTable.getColumnModel().getColumn(1);
        col1.setWidth(200);
        col1.setMaxWidth(200);
        TableColumn col2 = this.tablesTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tablesTable);
        sp.setPreferredSize(new Dimension(this.pWidth, 405));
        this.tablesPanel.add((Component)northPanel, "North");
        this.tablesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Tables", this.getConfiguration().getIcon("TABLE_ICON"), this.tablesPanel);
    }

    private void initTablesViews() {
        this.tablesViewsPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(this.pWidth, 23));
        JLabel filterLabel = new JLabel(Messages.getString("SubViewObjectsAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.tableViewNamefilter = new JTextField();
        this.tableViewNamefilter.setEnabled(false);
        this.tableViewNamefilter.setPreferredSize(new Dimension(200, 20));
        this.tableViewNamefilter.setMinimumSize(new Dimension(200, 20));
        this.tableViewNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnSelectAllTablesViews = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllTablesViews.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnSelectAllTablesViews.setEnabled(false);
        this.btnSelectAllTablesViews.setMnemonic(83);
        this.btnSelectAllTablesViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllTablesViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.tablesViewsTable, SubViewObjectsAdmin.this.tablesViewsList, true);
                SubViewObjectsAdmin.this.tablesViewsTable.updateUI();
            }
        });
        this.btnUnSelectAllTablesViews = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnSelectAllTablesViews.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnSelectAllTablesViews.setEnabled(false);
        this.btnUnSelectAllTablesViews.setMnemonic(68);
        this.btnUnSelectAllTablesViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnSelectAllTablesViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.tablesViewsTable, SubViewObjectsAdmin.this.tablesViewsList, false);
                SubViewObjectsAdmin.this.tablesViewsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnSelectAllTablesViews);
        toolBar.add(this.btnUnSelectAllTablesViews);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.tableViewNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.tablesViewsList = new ArrayList();
        ThreeColumnsTableModel model = new ThreeColumnsTableModel(this.tablesViewsList, "Views");
        this.tablesViewsTable = new JTable(model);
        this.tableViewNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.tableViewNamefilter, this.tablesViewsTable, 1));
        TableColumn col0 = this.tablesViewsTable.getColumnModel().getColumn(0);
        col0.setWidth(150);
        col0.setMaxWidth(150);
        TableColumn col1 = this.tablesViewsTable.getColumnModel().getColumn(1);
        col1.setWidth(200);
        col1.setMaxWidth(200);
        TableColumn col2 = this.tablesViewsTable.getColumnModel().getColumn(2);
        col2.setWidth(50);
        col2.setMaxWidth(50);
        this.threeCSorter = new TableRowSorter<ThreeColumnsTableModel>(model);
        this.threeCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.tablesViewsTable);
        sp.setPreferredSize(new Dimension(this.pWidth, 400));
        this.tablesViewsPanel.add((Component)northPanel, "North");
        this.tablesViewsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Views", this.getConfiguration().getIcon("VIEW_ICON"), this.tablesViewsPanel);
    }

    private void initEntities() {
        this.entitiesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(this.pWidth, 23));
        JLabel filterLabel = new JLabel(Messages.getString("SubViewObjectsAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.entityNamefilter = new JTextField();
        this.entityNamefilter.setEnabled(false);
        this.entityNamefilter.setPreferredSize(new Dimension(200, 20));
        this.entityNamefilter.setMinimumSize(new Dimension(200, 20));
        this.entityNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnSelectAllEntities = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllEntities.setToolTipText(Messages.getString("SubViewObjectsAdmin.SelectAll"));
        this.btnSelectAllEntities.setEnabled(false);
        this.btnSelectAllEntities.setMnemonic(83);
        this.btnSelectAllEntities.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.entitiesTable, SubViewObjectsAdmin.this.entitiesList, true);
                SubViewObjectsAdmin.this.entitiesTable.updateUI();
            }
        });
        this.btnUnSelectAllEntities = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnSelectAllEntities.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnSelectAllEntities.setEnabled(false);
        this.btnUnSelectAllEntities.setMnemonic(68);
        this.btnUnSelectAllEntities.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnSelectAllEntities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.entitiesTable, SubViewObjectsAdmin.this.entitiesList, false);
                SubViewObjectsAdmin.this.entitiesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnSelectAllEntities);
        toolBar.add(this.btnUnSelectAllEntities);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.entityNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.entitiesList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.entitiesList, "Entities");
        this.entitiesTable = new JTable(model);
        this.entityNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.entityNamefilter, this.entitiesTable, 0));
        TableColumn col0 = this.entitiesTable.getColumnModel().getColumn(0);
        col0.setWidth(350);
        col0.setMaxWidth(350);
        TableColumn col1 = this.entitiesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.entitiesTable);
        sp.setPreferredSize(new Dimension(this.pWidth, 405));
        this.entitiesPanel.add((Component)northPanel, "North");
        this.entitiesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Entities", this.getConfiguration().getIcon("ENTITY_ICON"), this.entitiesPanel);
    }

    private void initEntitiesViews() {
        this.entitiesViewsPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(this.pWidth, 23));
        JLabel filterLabel = new JLabel(Messages.getString("SubViewObjectsAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.entityViewNamefilter = new JTextField();
        this.entityViewNamefilter.setEnabled(false);
        this.entityViewNamefilter.setPreferredSize(new Dimension(200, 20));
        this.entityViewNamefilter.setMinimumSize(new Dimension(200, 20));
        this.entityViewNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnSelectAllEntitiesViews = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllEntitiesViews.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnSelectAllEntitiesViews.setEnabled(false);
        this.btnSelectAllEntitiesViews.setMnemonic(83);
        this.btnSelectAllEntitiesViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllEntitiesViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.entitiesViewsTable, SubViewObjectsAdmin.this.entitiesViewsList, true);
                SubViewObjectsAdmin.this.entitiesViewsTable.updateUI();
            }
        });
        this.btnUnSelectAllEntitiesViews = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnSelectAllEntitiesViews.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnSelectAllEntitiesViews.setEnabled(false);
        this.btnUnSelectAllEntitiesViews.setMnemonic(68);
        this.btnUnSelectAllEntitiesViews.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnSelectAllEntitiesViews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.entitiesViewsTable, SubViewObjectsAdmin.this.entitiesViewsList, false);
                SubViewObjectsAdmin.this.entitiesViewsTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnSelectAllEntitiesViews);
        toolBar.add(this.btnUnSelectAllEntitiesViews);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.entityViewNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.entitiesViewsList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.entitiesViewsList, "Views");
        this.entitiesViewsTable = new JTable(model);
        this.entityViewNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.entityViewNamefilter, this.entitiesViewsTable, 0));
        TableColumn col0 = this.entitiesViewsTable.getColumnModel().getColumn(0);
        col0.setWidth(350);
        col0.setMaxWidth(350);
        TableColumn col1 = this.entitiesViewsTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.entitiesViewsTable);
        sp.setPreferredSize(new Dimension(this.pWidth, 400));
        this.entitiesViewsPanel.add((Component)northPanel, "North");
        this.entitiesViewsPanel.add((Component)sp, "Center");
        this.tpane.addTab("Views", this.getConfiguration().getIcon("ENTITY_VIEW_ICON"), this.entitiesViewsPanel);
    }

    private void initStructuredTypes() {
        this.structuredtypesPanel = new JPanel();
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setPreferredSize(new Dimension(this.pWidth, 23));
        JLabel filterLabel = new JLabel(Messages.getString("SubViewObjectsAdmin.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        this.structuredTypeNamefilter = new JTextField();
        this.structuredTypeNamefilter.setEnabled(false);
        this.structuredTypeNamefilter.setPreferredSize(new Dimension(200, 20));
        this.structuredTypeNamefilter.setMinimumSize(new Dimension(200, 20));
        this.structuredTypeNamefilter.setMaximumSize(new Dimension(200, 20));
        this.btnSelectAllStructuredTypes = new JButton(GUIConfiguration.getInstance().getIcon("SELECT_ALL", 16));
        this.btnSelectAllStructuredTypes.setToolTipText(Messages.getString("ObjectNamesAdmin.SelectAll"));
        this.btnSelectAllStructuredTypes.setEnabled(false);
        this.btnSelectAllStructuredTypes.setMnemonic(83);
        this.btnSelectAllStructuredTypes.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSelectAllStructuredTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.structuredTypesTable, SubViewObjectsAdmin.this.structuredTypesList, true);
                SubViewObjectsAdmin.this.structuredTypesTable.updateUI();
            }
        });
        this.btnUnSelectAllStructuredTypes = new JButton(GUIConfiguration.getInstance().getIcon("DESELECT_ALL", 16));
        this.btnUnSelectAllStructuredTypes.setToolTipText(Messages.getString("ObjectNamesAdmin.DeselectAll"));
        this.btnUnSelectAllStructuredTypes.setEnabled(false);
        this.btnUnSelectAllStructuredTypes.setMnemonic(68);
        this.btnUnSelectAllStructuredTypes.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnUnSelectAllStructuredTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin.this.checkAll(SubViewObjectsAdmin.this.structuredTypesTable, SubViewObjectsAdmin.this.structuredTypesList, false);
                SubViewObjectsAdmin.this.structuredTypesTable.updateUI();
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.btnSelectAllStructuredTypes);
        toolBar.add(this.btnUnSelectAllStructuredTypes);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(this.structuredTypeNamefilter);
        northPanel.add((Component)toolBar, "North");
        this.structuredTypesList = new ArrayList();
        TwoColumnsTableModel model = new TwoColumnsTableModel(this.structuredTypesList, "Structured Types");
        this.structuredTypesTable = new JTable(model);
        this.structuredTypeNamefilter.getDocument().addDocumentListener(new FilterObjectListener(this.structuredTypeNamefilter, this.structuredTypesTable, 0));
        TableColumn col0 = this.structuredTypesTable.getColumnModel().getColumn(0);
        col0.setWidth(350);
        col0.setMaxWidth(350);
        TableColumn col1 = this.structuredTypesTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(50);
        this.twoCSorter = new TableRowSorter<TwoColumnsTableModel>(model);
        this.twoCSorter.setSortsOnUpdates(true);
        JScrollPane sp = new JScrollPane(this.structuredTypesTable);
        sp.setPreferredSize(new Dimension(this.pWidth, 400));
        this.structuredtypesPanel.add((Component)northPanel, "North");
        this.structuredtypesPanel.add((Component)sp, "Center");
        this.tpane.addTab("Structured Types", this.getConfiguration().getIcon("STRUCTURED_TYPE_ICON"), this.structuredtypesPanel);
    }

    private void initButtons() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.btnApply = new JButton(Messages.getString("SubViewObjectsAdmin.Apply"));
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.addActionListener(new ApplyAction());
        this.btnApply.setMnemonic(65);
        buttonsPanel.add(this.btnApply);
        this.btnClose = new JButton(Messages.getString("SubViewObjectsAdmin.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new CloseAction());
        this.btnClose.setMnemonic(67);
        buttonsPanel.add(this.btnClose);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonsPanel.add(this.btnHelp);
        this.mainPanel.add((Component)buttonsPanel, "South");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SubViewObjectsAdmin.AddRemoveObjects"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "SUBVIEW_OBJECTS_ADMIN_DIALOG";
    }

    private void newFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void checkAll(JTable table, List objects, boolean checked) {
        int[] selected = table.getSelectedRows();
        if (selected.length > 0) {
            for (int i = selected.length - 1; i >= 0; --i) {
                Object obj = objects.get(table.convertRowIndexToModel(selected[i]));
                ((SWObject)obj).setUsedInSubView(checked);
            }
        } else {
            this.selectAll(table, objects, checked);
        }
        table.updateUI();
    }

    private void selectAll(JTable table, List objects, boolean selected) {
        if (selected) {
            this.selectAll(table, objects);
        } else {
            this.deselectAll(table, objects);
        }
    }

    private void selectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), true);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), true);
            }
        }
    }

    private void deselectAll(JTable table, List list) {
        if (table != null && table.getRowCount() != table.getModel().getRowCount()) {
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int index = table.convertRowIndexToModel(i);
                if (index <= -1 || index >= list.size()) continue;
                this.setSelected(list.get(index), false);
            }
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.setSelected(it.next(), false);
            }
        }
    }

    private void setSelected(Object obj, boolean selected) {
        if (obj != null) {
            ((SWObject)obj).setUsedInSubView(selected);
        }
    }

    private void initData(DesignPartView dpv) {
        Iterator existingObjectsIt = null;
        if (dpv instanceof DPVRelationalSubView) {
            SWObject o;
            DesignObject desObj;
            boolean isUsed;
            Iterator it = ((RelationalDesign)dpv.getDesignPart()).getTableSet().iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                isUsed = false;
                for (TopView tv : dpv.getTVShapes()) {
                    desObj = tv.getModel();
                    if (table != desObj) continue;
                    isUsed = true;
                    break;
                }
                o = new SWObject(table, isUsed);
                this.tablesList.add(o);
            }
            it = ((RelationalDesign)dpv.getDesignPart()).getTableViewSet().iterator();
            while (it.hasNext()) {
                TableView tableView = (TableView)it.next();
                isUsed = false;
                for (TopView tv : dpv.getTVShapes()) {
                    desObj = tv.getModel();
                    if (tableView != desObj) continue;
                    isUsed = true;
                    break;
                }
                o = new SWObject(tableView, isUsed);
                this.tablesViewsList.add(o);
            }
            if (this.tablesList.size() > 0) {
                this.tablesTable.setRowSorter(this.threeCSorter);
                this.tablesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.tablesTable, 1);
                this.btnSelectAllTables.setEnabled(true);
                this.btnUnSelectAllTables.setEnabled(true);
                this.tableNamefilter.setEnabled(true);
            }
            if (this.tablesViewsList.size() > 0) {
                this.tablesViewsTable.setRowSorter(this.threeCSorter);
                this.tablesViewsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.tablesViewsTable, 1);
                this.btnSelectAllTablesViews.setEnabled(true);
                this.btnUnSelectAllTablesViews.setEnabled(true);
                this.tableViewNamefilter.setEnabled(true);
            }
        } else if (dpv instanceof DPVLogicalSubView) {
            SWObject o;
            DesignObject desObj;
            boolean isUsed;
            Iterator it = ((LogicalDesign)dpv.getDesignPart()).getEntitySet().iterator();
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                isUsed = false;
                for (TopView tv : dpv.getTVShapes()) {
                    desObj = tv.getModel();
                    if (entity != desObj) continue;
                    isUsed = true;
                    break;
                }
                o = new SWObject(entity, isUsed);
                this.entitiesList.add(o);
            }
            it = ((LogicalDesign)dpv.getDesignPart()).getEntityViewSet().iterator();
            while (it.hasNext()) {
                EntityView entityView = (EntityView)it.next();
                isUsed = false;
                for (TopView tv : dpv.getTVShapes()) {
                    desObj = tv.getModel();
                    if (entityView != desObj) continue;
                    isUsed = true;
                    break;
                }
                o = new SWObject(entityView, isUsed);
                this.entitiesViewsList.add(o);
            }
            if (this.entitiesList.size() > 0) {
                this.entitiesTable.setRowSorter(this.twoCSorter);
                this.entitiesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.entitiesTable, 0);
                this.btnSelectAllEntities.setEnabled(true);
                this.btnUnSelectAllEntities.setEnabled(true);
                this.entityNamefilter.setEnabled(true);
            }
            if (this.entitiesViewsList.size() > 0) {
                this.entitiesViewsTable.setRowSorter(this.twoCSorter);
                this.entitiesViewsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.entitiesViewsTable, 0);
                this.btnSelectAllEntitiesViews.setEnabled(true);
                this.btnUnSelectAllEntitiesViews.setEnabled(true);
                this.entityViewNamefilter.setEnabled(true);
            }
        } else if (dpv instanceof DPVDataTypesSubView) {
            Iterator it = ((DataTypesDesign)dpv.getDesignPart()).getStructuredTypeSet().iterator();
            while (it.hasNext()) {
                StructuredType structuredType = (StructuredType)it.next();
                boolean isUsed = false;
                for (TopView tv : dpv.getTVShapes()) {
                    DesignObject desObj = tv.getModel();
                    if (structuredType != desObj) continue;
                    isUsed = true;
                    break;
                }
                SWObject o = new SWObject(structuredType, isUsed);
                this.structuredTypesList.add(o);
            }
            if (this.structuredTypesList.size() > 0) {
                this.structuredTypesTable.setRowSorter(this.twoCSorter);
                this.structuredTypesTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.structuredTypesTable, 0);
                this.btnSelectAllStructuredTypes.setEnabled(true);
                this.btnUnSelectAllStructuredTypes.setEnabled(true);
                this.structuredTypeNamefilter.setEnabled(true);
            }
        }
    }

    private class SWObject {
        private DesignObject object;
        private boolean usedInSubView;

        SWObject(DesignObject object, boolean usedInSubView) {
            this.object = object;
            this.usedInSubView = usedInSubView;
        }

        public DesignObject getObject() {
            return this.object;
        }

        public boolean isUsedInSubView() {
            return this.usedInSubView;
        }

        public void setUsedInSubView(boolean usedInSubView) {
            this.usedInSubView = usedInSubView;
        }
    }

    private class TabsListener
    implements ChangeListener {
        private TabsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (SubViewObjectsAdmin.this.tpane.getSelectedComponent() == SubViewObjectsAdmin.this.tablesPanel) {
                SubViewObjectsAdmin.this.btnApply.setEnabled(SubViewObjectsAdmin.this.tablesList.size() > 0);
            } else if (SubViewObjectsAdmin.this.tpane.getSelectedComponent() == SubViewObjectsAdmin.this.tablesViewsPanel) {
                SubViewObjectsAdmin.this.btnApply.setEnabled(SubViewObjectsAdmin.this.tablesViewsList.size() > 0);
            } else if (SubViewObjectsAdmin.this.tpane.getSelectedComponent() == SubViewObjectsAdmin.this.entitiesPanel) {
                SubViewObjectsAdmin.this.btnApply.setEnabled(SubViewObjectsAdmin.this.entitiesList.size() > 0);
            } else if (SubViewObjectsAdmin.this.tpane.getSelectedComponent() == SubViewObjectsAdmin.this.entitiesViewsPanel) {
                SubViewObjectsAdmin.this.btnApply.setEnabled(SubViewObjectsAdmin.this.entitiesViewsList.size() > 0);
            } else if (SubViewObjectsAdmin.this.tpane.getSelectedComponent() == SubViewObjectsAdmin.this.structuredtypesPanel) {
                SubViewObjectsAdmin.this.btnApply.setEnabled(SubViewObjectsAdmin.this.structuredTypesList.size() > 0);
            }
        }
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SubViewObjectsAdmin.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SubViewObjectsAdmin.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SubViewObjectsAdmin.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    private class ThreeColumnsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SubViewObjectsAdmin.Schema"), Messages.getString("SubViewObjectsAdmin.Name"), Messages.getString("SubViewObjectsAdmin.Include")};
        private List modelList;
        private String type;

        public ThreeColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SWObject o = (SWObject)this.modelList.get(rowIndex);
            if (columnIndex == 0) {
                DesignObject obj = o.getObject();
                SchemaObject schemaObj = ((ContainerObject)obj).getSchemaObject();
                return schemaObj != null ? schemaObj.getName() : "";
            }
            if (columnIndex == 1) {
                return o.getObject().getName();
            }
            if (columnIndex == 2) {
                return o.isUsedInSubView();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            SWObject o = (SWObject)this.modelList.get(rowIndex);
            if (columnIndex == 2) {
                o.setUsedInSubView((Boolean)value);
            }
        }
    }

    private class TwoColumnsTableModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SubViewObjectsAdmin.Name"), Messages.getString("SubViewObjectsAdmin.Include")};
        private List modelList;
        private String type;

        public TwoColumnsTableModel(List modelList, String type) {
            this.modelList = modelList;
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SWObject o = (SWObject)this.modelList.get(rowIndex);
            if (columnIndex == 0) {
                return o.getObject().getName();
            }
            if (columnIndex == 1) {
                return o.isUsedInSubView();
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            SWObject o = (SWObject)this.modelList.get(rowIndex);
            if (columnIndex == 1) {
                o.setUsedInSubView((Boolean)value);
            }
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TopView tv;
            boolean rearrange = false;
            if (SubViewObjectsAdmin.this.dpv.getTopviewsList().size() == 0) {
                rearrange = true;
            }
            ArrayList l = new ArrayList();
            if (SubViewObjectsAdmin.this.dpv instanceof DPVRelationalSubView) {
                l.addAll(SubViewObjectsAdmin.this.tablesList);
                l.addAll(SubViewObjectsAdmin.this.tablesViewsList);
            } else if (SubViewObjectsAdmin.this.dpv instanceof DPVLogicalSubView) {
                l.addAll(SubViewObjectsAdmin.this.entitiesList);
                l.addAll(SubViewObjectsAdmin.this.entitiesViewsList);
            } else if (SubViewObjectsAdmin.this.dpv instanceof DPVDataTypesSubView) {
                l.addAll(SubViewObjectsAdmin.this.structuredTypesList);
            }
            ArrayList<DesignObject> addist = new ArrayList<DesignObject>();
            ArrayList<TopView> removeist = new ArrayList<TopView>();
            for (SWObject obj : l) {
                DesignObject desObj = obj.getObject();
                if (obj.isUsedInSubView()) {
                    addist.add(desObj);
                    continue;
                }
                tv = SubViewObjectsAdmin.this.dpv.getViewFor(desObj);
                if (tv == null) continue;
                removeist.add(tv);
            }
            if (addist.size() > 0) {
                for (DesignObject desObj : addist) {
                    SubViewObjectsAdmin.this.dpv.addViewFor(desObj);
                }
                for (DesignObject desObj : addist) {
                    if (desObj instanceof Table) {
                        tv = (TVTable)desObj.getFirstViewForDPV(SubViewObjectsAdmin.this.dpv);
                        if (tv == null) continue;
                        ((TVTable)tv).addTVFKRelations();
                        ((TVTable)tv).addArcs();
                        continue;
                    }
                    if (!(desObj instanceof Entity)) continue;
                    tv = (TVEntity)desObj.getFirstViewForDPV(SubViewObjectsAdmin.this.dpv);
                    ((TVEntity)tv).addTVRelations();
                    ((TVEntity)tv).addArcs();
                }
            }
            if (removeist.size() > 0) {
                SubViewObjectsAdmin.this.dpv.removeTopViewsWithUndo(removeist.toArray());
            }
            if (rearrange) {
                if (SubViewObjectsAdmin.this.dpv instanceof DPVRelationalSubView) {
                    ((DPVRelationalSubView)SubViewObjectsAdmin.this.dpv).rearrangeNewDiagram();
                } else if (SubViewObjectsAdmin.this.dpv instanceof DPVLogicalSubView) {
                    ((DPVLogicalSubView)SubViewObjectsAdmin.this.dpv).rearrangeNewDiagram();
                } else if (SubViewObjectsAdmin.this.dpv instanceof DPVDataTypesSubView) {
                    ((DPVDataTypesSubView)SubViewObjectsAdmin.this.dpv).rearrangeDiagram();
                }
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubViewObjectsAdmin.this.close();
        }
    }
}

