/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.ddl;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IStoredProcedure;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.compare.CompareModelsDialog;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.DMSQLFormatter;
import oracle.dbtools.raptor.config.DBConfig;

public class CDDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private StatusBarOwner statusBarOwner = new StatusBarOwner.NullStatusBarOwner();
    private String content;
    private CompareObjectSelection merger;
    private static int alterIndex = 0;
    private static int dropTable = 0;
    private static int dropIndex = 0;
    private static int dropTableView = 0;
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;
    private static int alterSequence = 0;
    private static int dropSequence = 0;
    private static int replaceOption;
    private static final char INTERVAL = ' ';
    private DBConfig options = null;

    public void setStorageDesign(Object storageDesignOrSite) {
        if (storageDesignOrSite instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)storageDesignOrSite);
        } else if (storageDesignOrSite instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getDesign().getStorageDesign((RDBMSSite)storageDesignOrSite);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBarOwner = statusBarOwner != null ? statusBarOwner : new StatusBarOwner.NullStatusBarOwner();
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private int getIteratorSize(Iterator it) {
        int size = 0;
        while (it.hasNext()) {
            ++size;
            it.next();
        }
        return size;
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    public void generateDDLContent(ProgressDialog monitor) {
        int size = this.getIteratorSize(this.getMerger().ddlObjects());
        monitor.setMaximum(size + 10);
        RDBMSSite defaultSite = this.getDesign().getSelectedRDBMSSite();
        this.getDesign().setSelectedRDBMSSite(this.getStorageDesign().getRDBMSSite());
        monitor.setNote(Messages.getString("CDDLFileMaker.ClearContent"));
        monitor.setProgress(0);
        this.clearContent();
        this.buffer().append(Messages.getString("CDDLFileMaker.GeneratedBy")).append(Extension.getExtensionVersion()).append(this.newline());
        this.buffer().append(Messages.getString("CDDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        if (this.getMerger() != null) {
            this.buffer().append(Messages.getString("CDDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
            this.buffer().append(Messages.getString("CDDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            int i = 0;
            int p = 0;
            this.resetCounters();
            CDDLFileMaker.setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator ddlAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator();
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                CDDLFileMaker.setddlAdvancedGenenerator(ddlAdvancedGenerator);
                CDDLFileMaker.setReplaceOption(CompareModelsDialog.getReplaceOption());
                ddlAdvancedGenerator.setDDLExceptionList(this.getDesign().getAppView().getDDLExceptionList());
                ddlAdvancedGenerator.addAdvanceHeader(this.buffer());
                if (CompareModelsDialog.getUnloadStatement()) {
                    ddlAdvancedGenerator.unloadStatement(this.buffer());
                }
            }
            DDLGenerator dropGenerator = this.getMerger().getDDLDropGenerator();
            Iterator it = this.getMerger().ddlDropObjects();
            monitor.setNote(Messages.getString("CDDLFileMaker.GenerateDropStatements"));
            monitor.setProgress(5);
            while (it.hasNext()) {
                ModelObject object = (ModelObject)it.next();
                this.appendStatementFor(object, dropGenerator);
            }
            monitor.setProgress(10);
            DDLGenerator ddlGenerator = this.getMerger().getDDLGenerator();
            it = this.getMerger().ddlCreateObjects();
            while (it.hasNext()) {
                ModelObject object = (ModelObject)it.next();
                monitor.setNote(Messages.getString("CDDLFileMaker.AppendDDLInfoFor") + object.getName());
                monitor.setProgress(++p);
                this.appendStatementFor(object, ddlGenerator);
                ++i;
            }
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                ddlAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            monitor.setNote(Messages.getString("CDDLFileMaker.FinishingGeneration"));
            monitor.setProgress(97);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.getMerger().removeDDLObjects();
            this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
            SSBAutoIncrementColumnOracle.clearGenSequenceSet();
        } else {
            monitor.setProgress(100);
            this.buffer().append(Messages.getString("CDDLFileMaker.NoStorageDesignAvailable"));
        }
        this.getDesign().setSelectedRDBMSSite(defaultSite);
    }

    private void appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            boolean formatStatement = true;
            if (!this.getDBConfig().getBoolean("AUTO_READONLY_FORMAT").booleanValue()) {
                System.out.println(object.getClass());
                if (object instanceof TableView || object instanceof TableViewProxy || object instanceof IStoredProcedure || object instanceof Trigger || object instanceof PackageOracle) {
                    formatStatement = false;
                }
            }
            if (formatStatement) {
                String formatted = this.formatSQL(result, this.getStorageDesign());
                if (!"".equalsIgnoreCase(result.trim())) {
                    result = formatted;
                }
            }
            this.buffer().append(this.newline());
            this.buffer().append(result);
        }
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        if (!this.getAppView().getSettings().useSQLDevFormatting()) {
            return sql;
        }
        DMSQLFormatter command = new DMSQLFormatter();
        if (storageDesign instanceof StorageDesignOracle) {
            return command.formatSQL(sql, "Oracle");
        }
        if (storageDesign instanceof StorageDesignSqlServer) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (storageDesign instanceof AbstractStorageDesignDB2 || storageDesign instanceof StorageDesignUDB) {
            return command.formatSQL(sql, "DB2");
        }
        return command.formatSQL(sql, "Oracle");
    }

    private DBConfig getDBConfig() {
        if (this.options == null) {
            this.options = DBConfig.getInstance();
        }
        return this.options;
    }

    private void appendCounters(StringBuffer buffer, RDBMSType type) {
        buffer.append(Messages.getString("CDDLFileMaker.SummaryReport"));
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TABLE", CDDLFileMaker.getCreateTable());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE INDEX", CDDLFileMaker.getCreateIndex());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE VIEW", CDDLFileMaker.getCreateView());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TABLE", CDDLFileMaker.getAlterTable());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER INDEX", alterIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP TABLE", dropTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP INDEX", dropIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TRIGGER", CDDLFileMaker.getCreateTrigger());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TRIGGER", CDDLFileMaker.getAlterTrigger());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE SEQUENCE", CDDLFileMaker.getCreateSequence());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER SEQUENCE", alterSequence);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP SEQUENCE", dropSequence);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", CDDLFileMaker.getCreateSnapshot());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- DROP VIEW", dropTableView);
        buffer.append(this.newline());
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ERRORS", CDDLFileMaker.getErrors());
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- WARNINGS", CDDLFileMaker.getWarnings());
        buffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer buffer, String string, int number) {
        int n = new Integer(number).toString().length();
        buffer.append(string);
        for (int i = 0; i < 45 - string.length() - n; ++i) {
            buffer.append(' ');
        }
        buffer.append(number);
    }

    public static void incrementCreateTable() {
        DDLFileMaker.incrementCreateTable();
    }

    public static int getCreateTable() {
        return DDLFileMaker.getCreateTable();
    }

    public static void incrementCreateIndex() {
        DDLFileMaker.incrementCreateIndex();
    }

    public static int getCreateIndex() {
        return DDLFileMaker.getCreateIndex();
    }

    public static void incrementCreateView() {
        DDLFileMaker.incrementCreateView();
    }

    public static int getCreateView() {
        return DDLFileMaker.getCreateView();
    }

    public static void incrementAlterTable() {
        DDLFileMaker.incrementAlterTable();
    }

    public static int getAlterTable() {
        return DDLFileMaker.getAlterTable();
    }

    public static void incrementAlterIndex() {
        ++alterIndex;
    }

    public static int getCreateTrigger() {
        return DDLFileMaker.getCreateTrigger();
    }

    public static int getRedactionPolicies() {
        return DDLFileMaker.getRedactionPolicies();
    }

    public static int getTSDPPolicies() {
        return DDLFileMaker.getTSDPPolicies();
    }

    public static int getAlterTrigger() {
        return DDLFileMaker.getAlterTrigger();
    }

    public static void incrementCreateSequence() {
        DDLFileMaker.incrementCreateSequence();
    }

    public static int getCreateSequence() {
        return DDLFileMaker.getCreateSequence();
    }

    public static void incrementCreateSnapshot() {
        DDLFileMaker.incrementCreateSnapshot();
    }

    public static int getCreateSnapshot() {
        return DDLFileMaker.getCreateSnapshot();
    }

    public static void incrementAlterSequence() {
        ++alterSequence;
    }

    public static void incrementDropSequence() {
        ++dropSequence;
    }

    public static void incrementErrors() {
        DDLFileMaker.incrementErrors();
    }

    public static int getErrors() {
        return DDLFileMaker.getErrors();
    }

    public static void incrementWarnings() {
        DDLFileMaker.incrementWarnings();
    }

    public static int getWarnings() {
        return DDLFileMaker.getWarnings();
    }

    private void resetCounters() {
        DDLFileMaker.resetCounters();
        alterIndex = 0;
        dropTable = 0;
        dropIndex = 0;
        dropTableView = 0;
        alterSequence = 0;
        dropSequence = 0;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void saveContentDDLFile() {
        this.getAppView().getPersistenceManager().write(this);
    }

    public void statusMessage(String message, Object object) {
        this.statusMessage(message + object);
    }

    public void statusMessage(String message) {
        this.statusBarOwner.setTempStatusMessage(message, 5000);
    }

    public void checkErrors(Component parent) {
        int errors = CDDLFileMaker.getErrors();
        if (errors > 0) {
            String message = errors == 1 ? Messages.getString("CDDLFileMaker.OneError") : MessageFormat.format(Messages.getString("CDDLFileMaker.ManyErrors"), errors);
            MessageDialogs.showMessage(parent, MessageFormat.format(Messages.getString("CDDLFileMaker.CheckDesignRules"), message));
        }
    }

    public CompareObjectSelection getMerger() {
        return this.merger;
    }

    public void setMerger(CompareObjectSelection merger) {
        this.merger = merger;
    }

    public static void incrementDropTable() {
        ++dropTable;
    }

    public static void incrementDropIndex() {
        ++dropIndex;
    }

    public static void incrementDropView() {
        ++dropTableView;
    }

    public static void incrementAdvancedStep() {
        DDLFileMaker.incrementAdvancedStep();
    }

    public static int getAdvancedStep() {
        return DDLFileMaker.getAdvancedStep();
    }

    public static DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return ddlAdvancedGenenerator;
    }

    public static void setddlAdvancedGenenerator(DDLAdvancedGenerator ddladvgen) {
        ddlAdvancedGenenerator = ddladvgen;
    }

    public static int getReplaceOption() {
        return replaceOption;
    }

    private static void setReplaceOption(int replaceOption) {
        CDDLFileMaker.replaceOption = replaceOption;
    }
}

