/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.compare.ddl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.compare.Messages;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.FindDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.ddlsourceeditor.DDLSourceEditor;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.config.EnvironOptions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.editor.BasicEditorPane;

public class CDDLFileMakerEditor
extends CustomDialog {
    private JScrollPane m_scrollPane;
    private DDLSourceEditor ddlSourceEditor;
    private JPanel bottomPanel;
    private JButton saveButton;
    private JFrame dialog;
    private CDDLFileMaker fileMaker;
    private CompareObjectSelection merger;
    private JButton findButton;
    private FindDialog findDialog;
    private static File lastFolder = null;
    private JPanel leftMargin = new JPanel(new BorderLayout());
    private static final Logger LOGGER = new Logger(CDDLFileMakerEditor.class);
    private Action actionFind = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CDDLFileMakerEditor.this.ddlSourceEditor.getFindDialog((Frame)CDDLFileMakerEditor.this.getDialog()).showFind(((CDDLFileMakerEditor)CDDLFileMakerEditor.this).ddlSourceEditor.hlPlugin, (JTextComponent)CDDLFileMakerEditor.this.ddlSourceEditor.getEditor());
        }
    };

    public CDDLFileMakerEditor(ApplicationView applicationView) {
        super(applicationView);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.ddlSourceEditor = new DDLSourceEditor(this.leftMargin);
        this.m_scrollPane = new JScrollPane((Component)this.ddlSourceEditor.getEditor(), 20, 30);
        this.m_scrollPane.setRowHeaderView(this.leftMargin);
        JViewport viewport = this.m_scrollPane.getViewport();
        viewport.setScrollMode(1);
        this.add((Component)this.m_scrollPane, "Center");
        this.add((Component)this.getBottomPanel(), "South");
    }

    public CDDLFileMakerEditor(ApplicationView applicationView, CompareObjectSelection merger) {
        this(applicationView);
        this.merger = merger;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JFrame(Messages.getString("CDDLFileMakerEditor.DDLFileEditor"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(750, 600);
            this.dialog.setIconImage(this.getApplicationView().getFrame().getIconImage());
            this.setDefaultActions(this, true);
            int condition = 1;
            KeyStroke ksFind = KeyStroke.getKeyStroke(70, 128, false);
            this.getInputMap(condition).put(ksFind, "KEY_FIND");
            this.getActionMap().put("KEY_FIND", this.actionFind);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "CDDL_FILE_EDITOR_DIALOG";
    }

    public BasicEditorPane getEditor() {
        return this.ddlSourceEditor.getEditor();
    }

    public BasicEditorPane getEditorPane() {
        return this.getEditor();
    }

    public JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FlowLayout(2));
            this.bottomPanel.add(this.getSaveButton());
            this.bottomPanel.add(this.getFindButton());
            JButton bnClose = new JButton(Messages.getString("CDDLFileMakerEditor.Close"));
            bnClose.setMnemonic(67);
            bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CDDLFileMakerEditor.this.close();
                }
            });
            this.bottomPanel.add(bnClose);
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setMnemonic(72);
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.bottomPanel.add(bnHelp);
        }
        return this.bottomPanel;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getString("CDDLFileMakerEditor.Save"));
            this.saveButton.setMnemonic(83);
            this.saveButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CDDLFileMakerEditor.this.saveLocalCopy();
                }
            });
            this.saveButton.setToolTipText(Messages.getString("CDDLFileMakerEditor.SaveDDLContent"));
        }
        return this.saveButton;
    }

    public void saveLocalCopy() {
        try {
            File file;
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".sql") || file.getName().toLowerCase().endsWith(".ddl") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("CDDLFileMakerEditor.DDLFiles");
                }
            };
            URLChooser fileChooser = DialogUtil.newURLChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CDDLFileMakerEditor.SaveDDLLocally"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                FileOpenHistory.getInstance().updateFileHistory(lastFolder.toURI().toURL());
                this.saveLocalCopy(file);
            }
        }
        catch (IOException ioe) {
            LOGGER.error("", ioe);
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("CDDLFileMakerEditor.CanNotWrite"), ioe.getMessage()}, Messages.getString("CDDLFileMakerEditor.WriteError"), 0);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.getDialog(), new Object[]{Messages.getString("CDDLFileMakerEditor.UnexpectedError"), t.getMessage()}, Messages.getString("CDDLFileMakerEditor.WriteError"), 0);
        }
    }

    protected void saveLocalCopy(File file) throws IOException {
        int result;
        if (file.exists() && (result = JOptionPane.showConfirmDialog(this.getDialog(), MessageFormat.format(Messages.getString("CDDLFileMakerEditor.FileExist"), file.getAbsolutePath()), Messages.getString("CDDLFileMakerEditor.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
            return;
        }
        String editedContent = this.ddlSourceEditor.getEditor().getText();
        file.getParentFile().mkdirs();
        file.createNewFile();
        EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, environOptions.getEncoding());
        osw.write(editedContent);
        osw.close();
    }

    public CDDLFileMaker getDDLFileMaker() {
        if (this.fileMaker == null) {
            this.fileMaker = new CDDLFileMaker();
            this.fileMaker.setDesign(this.getApplicationView().getCurrentDesign());
            this.fileMaker.setMerger(this.getMerger());
            this.fileMaker.setStatusBarOwner(this.getApplicationView());
        }
        return this.fileMaker;
    }

    public JScrollPane getScrollPane() {
        return this.m_scrollPane;
    }

    public void setStorageDesignSelection(Object selected) {
        this.getDDLFileMaker().setStorageDesign(selected);
        ((JFrame)this.getDialog()).setTitle(new StringBuffer(Messages.getString("CDDLFileMakerEditor.DDLFileEditorS")).append(String.valueOf(selected)).toString());
        this.repaint();
    }

    public CompareObjectSelection getMerger() {
        return this.merger;
    }

    public JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton(Messages.getString("CDDLFileMakerEditor.Find"));
            this.findButton.setMnemonic(70);
            this.findButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CDDLFileMakerEditor.this.ddlSourceEditor.getFindDialog((Frame)CDDLFileMakerEditor.this.getDialog()).showFind(((CDDLFileMakerEditor)CDDLFileMakerEditor.this).ddlSourceEditor.hlPlugin, (JTextComponent)CDDLFileMakerEditor.this.ddlSourceEditor.getEditor());
                }
            });
            this.findButton.setToolTipText("Find");
        }
        return this.findButton;
    }
}

