/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.datatypes.StructuredTypeDiagramCell;
import oracle.dbtools.crest.swingui.search.SearchPanel;
import oracle.dbtools.crest.util.GUID;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;

public class ControllerDataTypes
extends AbstractController {
    private final String[] OBJECT_DTD_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.DTD_CAPTION};
    private final DockStation dockStation = DockStation.getDockStation();
    private DesignPartView dpv = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private STCollector stCollector = null;
    private NewStructuredType newStructureType;
    private NewReferenceLink newRefLink;
    private NewEmbeddedStructureLink newEmbeddedStructureLink;
    private NewCollectionOfRefsLink newCollectionOfRefsLink;
    private NewCollectionOfEmbeddedStructureLink newCollectionOfEmbeddedStructureLink;
    private NewNote newNote;
    private Delete delete;

    public ControllerDataTypes(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectDataTypesMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_DTD_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newStructureType = new NewStructuredType();
            this.newRefLink = new NewReferenceLink();
            this.newEmbeddedStructureLink = new NewEmbeddedStructureLink();
            this.newCollectionOfRefsLink = new NewCollectionOfRefsLink();
            this.newCollectionOfEmbeddedStructureLink = new NewCollectionOfEmbeddedStructureLink();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newStructureType);
            this.add(this.newRefLink);
            this.add(this.newEmbeddedStructureLink);
            this.add(this.newCollectionOfRefsLink);
            this.add(this.newCollectionOfEmbeddedStructureLink);
            this.add(this.newNote);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public void select_SelectAction() {
        if (this.stCollector != null) {
            this.stCollector.stopWaiting();
        }
        this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
        this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
    }

    public Select getSelectAction() {
        return this.select;
    }

    public NewStructuredType getNewStructuredTypeAction() {
        return this.newStructureType;
    }

    public NewReferenceLink getNewReferenceLinkAction() {
        return this.newRefLink;
    }

    public NewEmbeddedStructureLink getNewEmbeddedStructureLinkAction() {
        return this.newEmbeddedStructureLink;
    }

    public NewCollectionOfRefsLink getNewCollectionOfRefsLinkAction() {
        return this.newCollectionOfRefsLink;
    }

    public NewCollectionOfEmbeddedStructureLink getNewCollectionOfEmbeddedStructureLinkAction() {
        return this.newCollectionOfEmbeddedStructureLink;
    }

    public NewNote getNewNoteAction() {
        return this.newNote;
    }

    public Delete getDeleteAction() {
        return this.delete;
    }

    public ZoomIn getZoomInAction() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOutAction() {
        return this.zoomOut;
    }

    public FitScreen getFitScreenAction() {
        return this.fitScreen;
    }

    public ActualSize getDefaultSizeAction() {
        return this.actualSize;
    }

    @Override
    public MDBAction getFindAction() {
        return this.search;
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerDataTypes.DataTypes");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public void setDesignPartView(DesignPartView dpv) {
        this.dpv = dpv;
    }

    @Override
    public void updateActions() {
        boolean enabled = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            enabled = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newStructureType, enabled);
        this.setEnabled(this.newRefLink, enabled);
        this.setEnabled(this.newEmbeddedStructureLink, enabled);
        this.setEnabled(this.newCollectionOfRefsLink, enabled);
        this.setEnabled(this.newCollectionOfEmbeddedStructureLink, enabled);
        this.setEnabled(this.newNote, enabled);
        this.setEnabled(this.delete, enabled);
    }

    public class STCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        private int type = 1;

        public STCollector() {
            this.startCollecting();
        }

        public STCollector(int type) {
            this.type = type;
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerDataTypes.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] points) {
            TVStructuredType sourceTV = this.getTopViewFor(points[0]);
            TVStructuredType targetTV = this.getTopViewFor(points[1]);
            ArrayList<String> errors = new ArrayList<String>();
            if (sourceTV == null) {
                errors.add(Messages.getString("ControllerDataTypes.NoSourceObjectSelected"));
            }
            if (targetTV == null) {
                errors.add(Messages.getString("ControllerDataTypes.NoTargetObjectSelected"));
            }
            if (errors.size() == 0) {
                DTReference ref;
                TypeElement tp = this.createRelation(sourceTV, targetTV);
                if (tp != null && (ref = tp.getReferenceRelation()) != null && sourceTV == targetTV && !sourceTV.getDesignPartView().isAutoRoute()) {
                    ref.createDefaultSelfReferencePoints();
                }
            } else {
                JOptionPane.showMessageDialog(ControllerDataTypes.this.getDesignPartView(), errors.toArray(), Messages.getString("ControllerDataTypes.NewReference"), 0);
            }
            ControllerDataTypes.this.select_SelectAction();
        }

        private TVStructuredType getTopViewFor(Point point) {
            Object cell = ControllerDataTypes.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (cell != null && cell instanceof StructuredTypeDiagramCell) {
                return (TVStructuredType)((StructuredTypeDiagramCell)cell).getTopView();
            }
            return null;
        }

        private boolean hasValidContainment(StructuredType owner, StructuredType newTE) {
            if (this.type == 2 || this.type == 4) {
                if (owner.isParentOf(newTE) || newTE.isParentOf(owner)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ControllerDataTypes.TypePartOf"), newTE.getName(), owner.getName()), Messages.getString("ControllerDataTypes.ForbidenSelfContainment"), 0);
                    return false;
                }
                if (newTE.containsElementOfStructuredType(owner)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ControllerDataTypes.CyclicContainment"), newTE.getName()), Messages.getString("ControllerDataTypes.ForbidenCyclicContainment"), 0);
                    return false;
                }
            }
            return true;
        }

        private TypeElement createRelation(TVStructuredType sourceTV, TVStructuredType targetTV) {
            StructuredType source = (StructuredType)sourceTV.getModel();
            StructuredType target = (StructuredType)targetTV.getModel();
            if (source != null && target != null && this.hasValidContainment(target, source)) {
                if (this.type == 1) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateReferenceTo"), source.getName()));
                } else if (this.type == 2) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateUsageOf"), source.getName()));
                } else if (this.type == 3) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateCollectionOfReferences"), source.getName()));
                } else if (this.type == 4) {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ControllerDataTypes.CreateCollectionOf"), source.getName()));
                }
                DataTypesDesign dd = (DataTypesDesign)source.getDesignPart();
                if (this.type == 1 || this.type == 2) {
                    TypeElement tp = new TypeElement(target.getDesignPart(), target);
                    tp.setDesign(target.getDesign());
                    target.add(tp);
                    tp.setType(source);
                    if (this.type == 1) {
                        tp.setReference(true);
                        tp.setName(dd.getReferencePrefix() + source.getName());
                    } else {
                        tp.setName(dd.getEmbeddedStructuredTypePrefix() + source.getName());
                    }
                    tp.updateReference();
                    return tp;
                }
                if (this.type == 3 || this.type == 4) {
                    CollectionType ct = dd.getOrCreateCollectionFor(source, this.type == 3);
                    TypeElement tp = new TypeElement(target.getDesignPart(), target);
                    tp.setDesign(target.getDesign());
                    target.add(tp);
                    tp.setType(ct);
                    if (this.type == 3) {
                        tp.setName(dd.getCollectionOfRefsPrefix() + source.getName());
                    } else {
                        tp.setName(dd.getCollectionPrefix() + source.getName());
                    }
                    tp.updateReference();
                    return tp;
                }
            }
            return null;
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerDataTypes.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("SEARCH_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPart dp = ControllerDataTypes.this.getDesignPartView().getDesignPart();
            SearchDockable lastNonPinnedView = dp.getLastNonPinnedSearchDockable();
            if (lastNonPinnedView == null) {
                ViewId vId = new ViewId(new GUID().toString(), Integer.toString(dp.getSearchDockableIdSequence()));
                SearchDockable sdNew = new SearchDockable(vId);
                dp.addSearchDockable(sdNew);
                ((SearchPanel)sdNew.getGUI()).resetItems(dp);
                sdNew.show();
            } else {
                ControllerDataTypes.this.dockStation.activateDockable((Dockable)lastNonPinnedView);
            }
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            dpv.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            dpv.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            dpv.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerDataTypes.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            DesignPartView dpv = ControllerDataTypes.this.getApplicationView().getCurrentDPV();
            dpv.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("DELETE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NOTE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerDataTypes.this.updateToolbar(this);
        }
    }

    class NewCollectionOfEmbeddedStructureLink
    extends MDBAction {
        private NewCollectionOfEmbeddedStructureLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_COLLECTION_OF_EMBEDDED_STRUCTURE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_COL_COMPOSITIONS_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_COLLECTION_OF_EMBEDDED_STRUCTURE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector(4);
        }
    }

    class NewCollectionOfRefsLink
    extends MDBAction {
        private NewCollectionOfRefsLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_COLLECTION_OF_REFERENCE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_COL_REFS_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_COLLECTION_OF_REFERENCE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector(3);
        }
    }

    class NewEmbeddedStructureLink
    extends MDBAction {
        private NewEmbeddedStructureLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_EMBEDDED_STRUCTURE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_COMPOSITION_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_EMBEDDED_STRUCTURE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector(2);
        }
    }

    class NewReferenceLink
    extends MDBAction {
        private NewReferenceLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_REFERENCE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("NEW_REFERENCE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_REFERENCE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerDataTypes.this.updateToolbar(this);
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.stCollector = new STCollector();
        }
    }

    class NewStructuredType
    extends MDBAction {
        private NewStructuredType() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_STRUCTURED_TYPE_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("STRUCTURED_TYPE_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_STRUCTURED_TYPE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(17);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerDataTypes.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerDataTypes.this.getConfiguration().getIcon("SELECT_ICON", ControllerDataTypes.this.getPreferredIconSize()));
            this.setMenuPath(ControllerDataTypes.this.OBJECT_DTD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent e) {
            if (ControllerDataTypes.this.stCollector != null) {
                ControllerDataTypes.this.stCollector.stopWaiting();
            }
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerDataTypes.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerDataTypes.this.updateToolbar(this);
        }
    }
}

