/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTReferenceSet;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.SelectNeighborsDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.admin.objects.SubViewObjectsAdmin;
import oracle.dbtools.crest.swingui.datatypes.ControllerDataTypes;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVDTInheritance;
import oracle.dbtools.crest.swingui.datatypes.TVDTReference;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;

public class DPVDataTypes
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    public static final String MI_ATTRIBUTES = Messages.getString("DPVDataTypes.Attributes");
    public static final String MI_METHODS = Messages.getString("DPVDataTypes.Methods");
    private ControllerDataTypes controller;
    private JPopupMenu menu;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miShowPageGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miDatatype;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miShowLegend;
    public static final String TOOLBAR_NAME = "DataTypes Model";

    public DPVDataTypes(ApplicationView applicationView, DesignPart desPart) {
        super(applicationView, desPart);
        this.controller = new ControllerDataTypes(applicationView);
        this.controller.setName("DataTypes");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    public TopView createViewSynonim(DesignObject object) {
        AbstractDTObject dtObject = (AbstractDTObject)object;
        TopView tv = dtObject.getFirstViewForDPV(this);
        if (tv == null) {
            if (object instanceof DTInheritance) {
                tv = new TVDTInheritance(this.getApplicationView(), this);
            } else if (object instanceof DTReference) {
                tv = new TVDTReference(this.getApplicationView(), this);
            }
        }
        if (tv != null) {
            tv.setModel(object);
            this.modelToView.put(object, tv);
            this.add(tv);
        }
        return tv;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVDataTypes(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public boolean canCreateDisplays() {
        return true;
    }

    @Override
    public TopView createTopViewFor(DesignObject object) {
        TopView view = null;
        if (object instanceof StructuredType) {
            TVStructuredType tv = new TVStructuredType(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
            view.setSize(new Dimension(TOPVIEW_SIZE));
        } else if (object instanceof DTInheritance) {
            TVDTInheritance tv = new TVDTInheritance(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof DTReference) {
            TVDTReference tv = new TVDTReference(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof Note) {
            TVNote tv = new TVNote(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof Legend) {
            TVLegend tv = new TVLegend(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else if (object instanceof DiagramView) {
            TVDiagramView tv = new TVDiagramView(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
        } else {
            return null;
        }
        this.registerForTreemodel(view);
        this.setDirty(true);
        return view;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.addSubViewAndDisplayMenus(this.menu);
            this.menu.addSeparator();
            if (!this.isMainDiagram()) {
                this.menu.add(this.getObjectsSubMenu());
                this.menu.addSeparator();
            }
            this.menu.add(this.getLayoutSubMenu());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        JMenuItem miProperties = this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.showPropertiesDialog();
            }
        });
        miProperties.setIcon(this.getConfiguration().getIcon("PROPERTIES_ICON", 16));
        if (this.isEditable()) {
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miDatatype.setSelected(this.showDatatype());
            this.miKeys.setSelected(this.showKeys());
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu showMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        showMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowGrid(!DPVDataTypes.this.showGrid());
            }
        });
        showMenu.add(this.miShowGrid);
        this.miShowPageGrid = new JCheckBoxMenuItem(MI_SHOW_PAGE_GRID);
        this.miShowPageGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowPageGrid(!DPVDataTypes.this.showPageGrid());
            }
        });
        showMenu.add(this.miShowPageGrid);
        showMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowLegend(!DPVDataTypes.this.showLegend());
            }
        });
        showMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowPageGrid.setSelected(this.showPageGrid());
        this.miShowLegend.setSelected(this.showLegend());
        return showMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ATTRIBUTES));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_ATTRIBUTES));
        this.miDatatype = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_DATATYPE));
        this.miDatatype.setMnemonic(MenuUtils.getMnemonicKey(MI_DATATYPE));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_METHODS));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_METHODS));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowAllDetails(true);
                DPVDataTypes.this.setShowNamesOnly(false);
                DPVDataTypes.this.setShowElements(false);
                DPVDataTypes.this.setShowDatatype(false);
                DPVDataTypes.this.setShowKeys(false);
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowNamesOnly(true);
                DPVDataTypes.this.setShowAllDetails(false);
                DPVDataTypes.this.setShowNamesOnly(true);
                DPVDataTypes.this.setShowElements(false);
                DPVDataTypes.this.setShowDatatype(false);
                DPVDataTypes.this.setShowKeys(false);
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowElements(!DPVDataTypes.this.showElements());
                if (!DPVDataTypes.this.showElements()) {
                    DPVDataTypes.this.setShowDatatype(false);
                    if (!DPVDataTypes.this.showKeys()) {
                        DPVDataTypes.this.setShowAllDetails(true);
                    }
                } else {
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miElements);
        this.miDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowDatatype(!DPVDataTypes.this.showDatatype());
                if (DPVDataTypes.this.showDatatype()) {
                    DPVDataTypes.this.setShowElements(true);
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miDatatype);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setShowKeys(!DPVDataTypes.this.showKeys());
                if (DPVDataTypes.this.showKeys()) {
                    DPVDataTypes.this.setShowAllDetails(false);
                    DPVDataTypes.this.setShowNamesOnly(false);
                } else if (!DPVDataTypes.this.showElements()) {
                    DPVDataTypes.this.setShowAllDetails(true);
                }
                DPVDataTypes.this.getWorkSpace().invalidate();
                DPVDataTypes.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miKeys);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miDatatype.setSelected(this.showDatatype());
        this.miKeys.setSelected(this.showKeys());
        return this.detailsMenu;
    }

    protected void showPropertiesDialog() {
        if (!this.isMasterDPV()) {
            if (!this.getPlaceHolder().isDialogVisible()) {
                ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
                dialog.initProperties(this.getPlaceHolder());
                dialog.show();
            }
        } else {
            this.getDesignPart().showPropertyDialog();
        }
    }

    @Override
    public void createSubViewFromSelected() {
        DesignPartView subView;
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects.length > 0 && (subView = this.getApplicationView().createSubview(this)) != null) {
            subView.setAutoRoute(false);
            for (int i = 0; i < selectedObjects.length; ++i) {
                Object obj = selectedObjects[i];
                if (!(obj instanceof StructuredType)) continue;
                ContainerView tvt = ((ContainerView)((DesignObject)obj).getTopView()).createViewSynonim(subView);
                TopView tv = this.getViewFor((DesignObject)obj);
                if (tvt.getCellView() != null) {
                    tvt.getCellView().setNewBounds(tv.getBounds());
                } else {
                    tvt.setBounds(tv.getBounds());
                }
                if (tvt instanceof TVStructuredType) {
                    ((TVStructuredType)tvt).addTVRelations();
                    ((TVStructuredType)tvt).addTVInheritances();
                }
                subView.synchronizeSynonymWithDisplays(tvt);
            }
            DTReferenceSet rs = ((DataTypesDesign)this.getDesignPart()).getDTReferenceSet();
            for (int k = 0; k < selectedObjects.length; ++k) {
                Object obj = selectedObjects[k];
                if (!(obj instanceof StructuredType)) continue;
                StructuredType structuredType = (StructuredType)obj;
                Collection list = rs.getRelationsToSource(structuredType);
                list.addAll(((DataTypesDesign)this.getDesignPart()).getDTInheritanceSet().getInheritancesToSource(structuredType));
                Object[] objs = list.toArray();
                for (int n = 0; n < objs.length; ++n) {
                    List t_edgePoints;
                    List s_edgePoints;
                    DesignObject dobj = (DesignObject)objs[n];
                    TVConnector tvc = (TVConnector)dobj.getFirstViewForDPV(this);
                    TVConnector tvc_t = (TVConnector)dobj.getFirstViewForDPV(subView);
                    if (tvc_t == null || tvc == null) continue;
                    EdgeView ev = null;
                    if (tvc.getEdge() != null) {
                        ev = (EdgeView)tvc.getEdge().getCellView();
                    }
                    if (ev != null) {
                        s_edgePoints = ev.getPoints();
                        t_edgePoints = tvc_t.getEdgePoints();
                        t_edgePoints.clear();
                        for (int i = 0; i < s_edgePoints.size(); ++i) {
                            Object p = s_edgePoints.get(i);
                            Point2D point = null;
                            if (p instanceof Point2D) {
                                point = (Point2D)p;
                            } else if (p instanceof PortView) {
                                point = ((PortView)p).getPoint();
                            }
                            if (point == null) continue;
                            t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                        }
                        if (tvc_t.getEdge() == null || tvc_t.getEdge().getCellView() == null) continue;
                        Hashtable hashtable = new Hashtable();
                        DiagramConstants.setPoints(hashtable, t_edgePoints);
                        tvc_t.getEdge().changeAttributes(hashtable);
                        tvc_t.getEdge().getCellView().update();
                        if (t_edgePoints.size() != 2) continue;
                        tvc_t.getEdge().straightLine(false);
                        continue;
                    }
                    s_edgePoints = tvc.getEdgePoints();
                    t_edgePoints = tvc_t.getEdgePoints();
                    t_edgePoints.clear();
                    for (int j = 0; j < s_edgePoints.size(); ++j) {
                        Point2D point = (Point2D)s_edgePoints.get(j);
                        t_edgePoints.add(DiagramConstants.createPoint(point.getX(), point.getY()));
                    }
                }
            }
            subView.setAutoRoute(this.isAutoRoute());
            subView.getWorkSpace().updateSettings();
        }
    }

    public void selectNeighbors(AbstractDTObject dtObject) {
        SelectNeighborsDialog dialog = new SelectNeighborsDialog(this.getApplicationView());
        dialog.showDialog();
        int zones = dialog.getZones();
        if (zones > -1) {
            ArrayList<AbstractDTObject> list = new ArrayList<AbstractDTObject>();
            list.add(dtObject);
            this.collectNeighbors(dtObject, list, zones, zones == 0);
            this.getWorkSpace().setSelectionCells(this.getCellsFromObjects(list).toArray());
        }
    }

    private void collectNeighbors(AbstractDTObject dtObject, List list, int zones, boolean unlimited) {
        int moreZones = --zones;
        DTRelation.Connection[] connections = dtObject.getAllLinks();
        for (int i = 0; i < connections.length; ++i) {
            AbstractDTObject other;
            DTRelation.Connection connection = connections[i];
            if (connection.getDTRelation() instanceof DTInheritance || list.contains(other = connection.getDTRelation().getOtherDTObject(dtObject))) continue;
            list.add(other);
            if (!unlimited && moreZones <= 0) continue;
            this.collectNeighbors(other, list, moreZones, unlimited);
        }
    }

    @Override
    public String getToolbarName() {
        return TOOLBAR_NAME;
    }

    public void resizeStructuredTypes() {
        List stypes = (List)this.getTVStructuredTypes();
        for (TopView topView : stypes) {
            if (topView == null) continue;
            this.resizeStructuredType(topView);
        }
    }

    public Collection getTVStructuredTypes() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVStructuredType)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeStructuredType(TopView topView) {
        Dimension dim = this.getSTSize(topView, (StructuredType)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getSTSize(TopView tv, StructuredType structuredType) {
        int cl;
        int i;
        int colTextHeight;
        int w = 35;
        int h = 25;
        int colCount = 0;
        int dtLength = 1;
        String title = structuredType.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        h += 6;
        if (this.isShowNamesOnly()) {
            return new Dimension(w * 2 + titleLength, h);
        }
        Font colFont = tv.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
        Font methodFont = tv.getFontObject(EditableFonts.FO_METHOD).getFont();
        if (this.showAllDetails() || this.showElements()) {
            colCount = structuredType.getElements().length;
            fm = this.getFontMetrics(colFont);
            colTextHeight = fm.getHeight();
            h += colCount * colTextHeight;
            h += 6;
        }
        int keyWidth = 0;
        if (this.showAllDetails() || this.showKeys()) {
            fm = this.getFontMetrics(methodFont);
            int keyCount = 0;
            if (structuredType.getMethods().length > 0) {
                for (i = 0; i < structuredType.getMethods().length; ++i) {
                    Method method = structuredType.getMethods()[i];
                    ++keyCount;
                    cl = fm.stringWidth(method.getName());
                    keyWidth = Math.max(cl, keyWidth);
                }
            }
            if (keyCount > 0) {
                h += 6;
                colTextHeight = fm.getHeight();
                h += keyCount * colTextHeight;
            }
        }
        fm = this.getFontMetrics(colFont);
        int colLength = 1;
        for (i = 0; i < colCount; ++i) {
            TypeElement element = structuredType.getElements()[i];
            cl = fm.stringWidth(element.getName());
            colLength = Math.max(cl, colLength);
            if (!this.showAllDetails() && !this.showDatatype()) continue;
            int dtl = fm.stringWidth(element.getDataType()) + 40;
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = fm.stringWidth(structuredType.getName());
        }
        colLength = Math.max(keyWidth, colLength + dtLength);
        colLength = Math.max(titleLength, colLength);
        return new Dimension(w + colLength, h);
    }

    private JMenu getObjectsSubMenu() {
        JMenu miObjects = new JMenu(Messages.getString("DPVDataTypes.Objects"));
        miObjects.add(new AbstractAction(ADD_REMOVE_OBJECTS){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubViewObjectsAdmin soa = new SubViewObjectsAdmin(DPVDataTypes.this.getApplicationView(), DPVDataTypes.this);
                soa.showDialog();
            }
        });
        return miObjects;
    }

    private JMenu getLayoutSubMenu() {
        JMenu miLayout = new JMenu(Messages.getString("DPVDataTypes.Layout"));
        this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
        this.miAutoRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVDataTypes.this.setAutoRoute(!DPVDataTypes.this.isAutoRoute());
                DPVDataTypes.this.getWorkSpace().updateSettings();
            }
        });
        miLayout.add(this.miAutoRoute);
        miLayout.addSeparator();
        miLayout.add(this.getStraightenLinesItem());
        JMenuItem miResizeToVisible = miLayout.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                DPVDataTypes.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVDataTypes.this.getName());
                try {
                    DPVDataTypes.this.resizeStructuredTypes();
                    if (!DPVDataTypes.this.isAutoRoute()) {
                        DPVDataTypes.this.straightenLines(false);
                    }
                }
                finally {
                    DPVDataTypes.this.stopAutoLayoutEdit();
                }
            }
        });
        miResizeToVisible.setIcon(this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", 16));
        return miLayout;
    }
}

