/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.ControllerDataTypes;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.datatypes.Messages;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;

public class DPVDataTypesSubView
extends DPVDataTypes {
    private AbstractController controller;
    private DesignObjectCollection tvStructuredTypes = new DesignObjectCollection(true);

    public DPVDataTypesSubView(ApplicationView applicationView, DesignPart desPart) {
        super(applicationView, desPart);
        ((DataTypesDesign)desPart).getStructuredTypeSet().addSetListener(this.tvStructuredTypes);
        this.controller = new ControllerDataTypes(applicationView);
        this.controller.setName("DataTypes_SubView");
        this.controller.setDesignPartView(this);
        this.tvStructuredTypes.setElementDescriptor(StructuredType.class);
        this.tvStructuredTypes.setName(Messages.getString("DPVDataTypesSubView.DPVDataTypesSubView.StructuredTypes"));
    }

    @Override
    public void clearDPV() {
        ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().removeSetListener(this.tvStructuredTypes);
        super.clearDPV();
    }

    @Override
    public void sortCollections() {
        this.tvStructuredTypes.sort();
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return;
        }
        TopView view = this.getViewFor(object);
        if (view == null) {
            this.addViewFor(object);
        }
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        TopView view = null;
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return null;
        }
        view = this.createTopViewFor(object);
        return view;
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.tvStructuredTypes;
            }
            case 1: {
                return this.getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.tvStructuredTypes) {
            return 0;
        }
        if (child == this.getDisplays()) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public void setPlaceHolder(PlaceHolder host) {
        super.setPlaceHolder(host);
        this.tvStructuredTypes.setParent(this.getPlaceHolder());
        this.getDisplays().setParent(this.getPlaceHolder());
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    @Override
    public void registerForTreemodel(TopView tv) {
        if (tv instanceof TVStructuredType && !this.tvStructuredTypes.containsPlaceHolderFor(tv.getModel())) {
            DesignObjectPlaceHolder tvph = new DesignObjectPlaceHolder(tv.getModel().getDesignPart(), tv.getModel());
            tvph.setTopView(tv);
            this.tvStructuredTypes.add(tvph);
        }
        if (this.getViewFor(tv.getModel()) == null) {
            this.modelToView.put(tv.getModel(), tv);
        }
    }

    @Override
    public void unregisterFromTreemodel(TopView tv) {
        if (tv != null) {
            this.unregisterTopView(tv);
            if (tv instanceof TVStructuredType) {
                this.tvStructuredTypes.removePlaceHolderFor(tv.getModel());
            }
        }
    }

    private Collection getSTTopViews() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        Iterator it = this.tvStructuredTypes.iterator();
        while (it.hasNext()) {
            DesignObjectPlaceHolder tvph = (DesignObjectPlaceHolder)it.next();
            TopView tv = tvph.getTopView();
            if (tv == null) continue;
            col.add(tv);
        }
        return col;
    }

    public void rearrangeDiagram() {
        int left = 20;
        int top = 20;
        int width = 35;
        int height = 25;
        int count = 0;
        Collection structuredTypes = this.getSTTopViews();
        float square = (float)Math.sqrt(structuredTypes.size());
        long maxTypePerRow = (int)square;
        if (Math.sqrt(square * square) != (double)square) {
            ++maxTypePerRow;
        }
        ++maxTypePerRow;
        for (TopView topView : structuredTypes) {
            if (topView == null) continue;
            ++count;
            Dimension dim = this.getTypeSize((StructuredType)topView.getModel());
            width = dim.width;
            height = Math.max(dim.height, height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(left, top), dim));
            } else {
                topView.setBounds(new Rectangle(new Point(left, top), dim));
            }
            left = left + width + 50;
            if ((long)count != maxTypePerRow) continue;
            count = 0;
            left = 20;
            top = top + height + 50;
            height = 25;
        }
    }

    public Dimension getTypeSize(StructuredType type) {
        int w = 35;
        int h = 25;
        int colCount = type.getElements().length + type.getMethods().length + 1;
        h += colCount * 14;
        int colLength = type.getName().length() * 6;
        int dtLength = 1;
        for (int i = 0; i < type.getElements().length; ++i) {
            TypeElement element = type.getElements()[i];
            int cl = element.getName().length() * 7;
            int dtl = element.getDataType().toString().length() * 7 + 10;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = type.getName().length() * 7;
        }
        return new Dimension(w + colLength + dtLength, h);
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVDataTypesSubView(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    protected void showPropertiesDialog() {
        if (!this.getPlaceHolder().isDialogVisible()) {
            ModelPropertiesDialogEx dialog = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
            dialog.initProperties(this.getPlaceHolder());
            dialog.show();
        }
    }
}

