/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.SQLAnalyzer;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.IStoredProcedure;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k8.StorageDesignSqlServerv2k8;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v97.StorageDesignUDBv9;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.DMSQLFormatter;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;

public class DDLFileMaker
extends ModelObject {
    private StorageDesign storageDesign;
    private StringBuffer contentBuffer;
    private StatusBarOwner statusBarOwner = new StatusBarOwner.NullStatusBarOwner();
    private String content;
    private String ddlFilesFolder = null;
    private static int createDatabase = 0;
    private static int createTable = 0;
    private static int createIndex = 0;
    private static int createTablespace = 0;
    private static int createView = 0;
    private static int alterTable = 0;
    private static int createTrigger = 0;
    private static int alterTrigger = 0;
    private static int createPackage = 0;
    private static int createPackageBody = 0;
    private static int createProc = 0;
    private static int createFunction = 0;
    private static int redactionPolicies = 0;
    private static int tsdpPolicies = 0;
    private static int createAlias = 0;
    private static int createAuxTable = 0;
    private static int createDistinctType = 0;
    private static int createStructuredType = 0;
    private static int createStructuredTypeBody = 0;
    private static int createStoGroup = 0;
    private static int createSynomym = 0;
    private static int createCluster = 0;
    private static int createContext = 0;
    private static int createDimension = 0;
    private static int createDirectory = 0;
    private static int createRole = 0;
    private static int createRollbackSegment = 0;
    private static int createSequence = 0;
    private static int createSnapshot = 0;
    private static int createDiskgroup = 0;
    private static int createUser = 0;
    private static int createDefault = 0;
    private static int createRule = 0;
    private static int createIndexOnView = 0;
    private static int createInstance = 0;
    private static int createNodeGroup = 0;
    private static int createDbPartitionGroup = 0;
    private static int createBufferPool = 0;
    private static int createSchema = 0;
    private static int dropDatabase = 0;
    private static int dropTablespace = 0;
    private static int dropAlias = 0;
    private static int dropTriggers = 0;
    private static int dropProcedures = 0;
    private static int dropStogroup = 0;
    private static int dropSynonym = 0;
    private static int dropDistinctType = 0;
    private static int dropSequence = 0;
    private static int errors = 0;
    private static int warnings = 0;
    private static int createCollectionType = 0;
    private static int createPartitionFunction = 0;
    private static int createPartitionScheme = 0;
    private static int advancedStep = 10;
    private static boolean normalIncrement = true;
    private static final char INTERVAL = ' ';
    private static DDLAdvancedGenerator ddlAdvancedGenenerator = null;
    private List sorted = new ArrayList();
    private Map sortedMap = new HashMap();
    private Map tracedMap = new HashMap();
    private DBConfig options = null;
    private static final Logger LOGGER = new Logger(DDLFileMaker.class);

    public DDLFileMaker(Design design) {
        this.setDesign(design);
    }

    public void setStorageDesign(Object storageDesignOrSite) {
        if (storageDesignOrSite instanceof StorageDesign) {
            this.setStorageDesign((StorageDesign)storageDesignOrSite);
        } else if (storageDesignOrSite instanceof RDBMSSite) {
            StorageDesign storageDesign = this.getAppView().getCurrentDesign().getStorageDesign((RDBMSSite)storageDesignOrSite);
            this.setStorageDesign(storageDesign);
        }
    }

    public void setStorageDesign(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public void setStatusBarOwner(StatusBarOwner statusBarOwner) {
        this.statusBarOwner = statusBarOwner != null ? statusBarOwner : new StatusBarOwner.NullStatusBarOwner();
    }

    public StringBuffer buffer() {
        if (this.contentBuffer == null) {
            this.contentBuffer = new StringBuffer();
        }
        return this.contentBuffer;
    }

    private String getDDLFilesMainFolder() {
        if (this.ddlFilesFolder == null) {
            this.ddlFilesFolder = this.getAppView().getSettings().getDefaultDDLFilesPath().trim();
            if (this.ddlFilesFolder == null || this.ddlFilesFolder.isEmpty()) {
                File file;
                URLChooser fileChooser = DialogUtil.newURLChooser();
                try {
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(1);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                }
                catch (Exception e) {
                    LOGGER.error("URLChooser: ", e);
                }
                JCheckBox chSaveAsDefault = new JCheckBox(Messages.getString("DDLFileMaker.SaveAsDefault"));
                fileChooser.add((Component)chSaveAsDefault, (Object)new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
                int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DDLFileMaker.SelectDDLFilesFolder"));
                if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                    this.ddlFilesFolder = file.getAbsolutePath();
                    if (chSaveAsDefault.isSelected()) {
                        this.getAppView().getSettings().setDefaultDDLFilesPath(this.ddlFilesFolder);
                    }
                }
            }
        }
        return this.ddlFilesFolder;
    }

    private static String fixPathName(String path) {
        return path.replaceAll("\\\\|/", " ");
    }

    private void saveDDLToFile(String content, String folder, String fileName, boolean isDataObject) {
        if (!content.isEmpty()) {
            try {
                String basePath = this.getDDLFilesMainFolder();
                if (!basePath.isEmpty()) {
                    File file = new File(basePath, DDLFileMaker.fixPathName(this.getAppView().getCurrentDesign().getName()));
                    file = new File(file.getAbsolutePath(), DDLFileMaker.fixPathName(this.getStorageDesign().getPhysicalDesign().getName()));
                    file = new File(file.getAbsolutePath(), DDLFileMaker.fixPathName(this.getStorageDesign().getName()));
                    if (folder != null && !folder.isEmpty()) {
                        file = isDataObject ? new File(file.getAbsolutePath(), "DataObjects") : new File(file.getAbsolutePath(), "Code");
                        file = new File(file.getAbsolutePath(), folder);
                    }
                    file.mkdirs();
                    String ext = isDataObject || !(this.getStorageDesign() instanceof StorageDesignOracle) ? ".sql" : (folder.equalsIgnoreCase("Package") ? ".pks" : (folder.equalsIgnoreCase("Package Body") ? ".pkb" : fileName + ".pls"));
                    String FN = fileName + ext;
                    file = new File(file.getAbsolutePath(), FN);
                    if (file.exists()) {
                        file.delete();
                    }
                    FileOutputStream fs = new FileOutputStream(file);
                    OutputStreamWriter bs = new OutputStreamWriter((OutputStream)fs, "UTF-8");
                    bs.write(content);
                    bs.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to Save File: " + fileName, e);
            }
        }
    }

    public int getTextSize() {
        return this.buffer().length();
    }

    private DBConfig getDBConfig() {
        if (this.options == null) {
            this.options = DBConfig.getInstance();
        }
        return this.options;
    }

    private String appendStatementFor(Object object, DDLGenerator generator) {
        StringBuffer buffer = new StringBuffer();
        generator.appendDDLFor(buffer, object);
        String result = buffer.toString();
        if (!"".equalsIgnoreCase(result.trim())) {
            boolean formatStatement = true;
            if (!this.getDBConfig().getBoolean("AUTO_READONLY_FORMAT").booleanValue() && (object instanceof TableView || object instanceof TableViewProxy || object instanceof IStoredProcedure || object instanceof Trigger || object instanceof PackageOracle)) {
                formatStatement = false;
            }
            if (formatStatement) {
                String formatted = this.formatSQL(result, this.getStorageDesign());
                if (!"".equalsIgnoreCase(result.trim())) {
                    result = formatted;
                }
            }
            this.buffer().append(this.newline());
            this.buffer().append(result);
        }
        return result;
    }

    public void generateDDLContent(ProgressDialog monitor) {
        List listOfDDLObjects = this.getStorageDesign().getListOfDDLObjects();
        int size = listOfDDLObjects.size();
        monitor.setMaximum(size + 10);
        RDBMSSite defaultSite = this.getAppView().getCurrentDesign().getSelectedRDBMSSite();
        this.getAppView().getCurrentDesign().setSelectedRDBMSSite(this.getStorageDesign().getRDBMSSite());
        monitor.setNote(Messages.getString("DDLFileMaker.ClearContent"));
        monitor.setProgress(0);
        this.clearContent();
        this.buffer().append(Messages.getString("DDLFileMaker.GeneratedBy")).append(Extension.getExtensionVersion()).append(this.newline());
        this.buffer().append(Messages.getString("DDLFileMaker.At")).append(MDConfiguration.timeToString(System.currentTimeMillis())).append(this.newline());
        if (this.getStorageDesign() != null) {
            ModelObject object;
            ModelObject object2;
            ModelObject object3;
            String result;
            ModelObject object4;
            this.buffer().append(Messages.getString("DDLFileMaker.Site")).append(this.getStorageDesign().getName()).append(this.newline());
            this.buffer().append(Messages.getString("DDLFileMaker.Type")).append(this.getStorageDesign().getRDBMSType()).append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            int p = 0;
            DDLFileMaker.resetCounters();
            DDLFileMaker.setddlAdvancedGenenerator(null);
            DDLAdvancedGenerator ddlAdvancedGenerator = this.getStorageDesign().createDDLAdvancedGenerator();
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                DDLFileMaker.setddlAdvancedGenenerator(ddlAdvancedGenerator);
                ddlAdvancedGenerator.setDDLExceptionList(this.getAppView().getDDLExceptionList());
                ddlAdvancedGenerator.addAdvanceHeader(this.buffer());
            }
            DDLGenerator dropGenerator = this.getStorageDesign().getDDLDropGenerator();
            dropGenerator.clearTemporaryObjects();
            Iterator it = this.getStorageDesign().ddlDropObjects();
            monitor.setNote(Messages.getString("DDLFileMaker.GenerateDropStatements"));
            monitor.setProgress(5);
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                while (it.hasNext()) {
                    object4 = (ModelObject)it.next();
                    result = this.appendStatementFor(object4, dropGenerator);
                    if (result == null || result.isEmpty()) continue;
                    content.append(result);
                    content.append(this.newline());
                }
                this.saveDDLToFile(content.toString(), null, "DropStatements", true);
            } else {
                while (it.hasNext()) {
                    ModelObject object5 = (ModelObject)it.next();
                    this.appendStatementFor(object5, dropGenerator);
                }
            }
            monitor.setProgress(10);
            DDLGenerator userGenerator = this.getStorageDesign().getDDLUserGenerator();
            it = this.getStorageDesign().ddlUserObjects();
            monitor.setNote(Messages.getString("DDLFileMaker.DDLFileMaker.GenerateUserDefinitions"));
            monitor.setProgress(12);
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    object4 = (ModelObject)it.next();
                    result = this.appendStatementFor(object4, userGenerator);
                    if (result == null || result.isEmpty()) continue;
                    this.saveDDLToFile(result, ((ModelIDObject)object4).getOldObjectTypeName(), object4.getName(), true);
                }
            } else {
                while (it.hasNext()) {
                    object4 = (ModelObject)it.next();
                    this.appendStatementFor(object4, userGenerator);
                }
            }
            monitor.setProgress(14);
            monitor.setNote(Messages.getString("DDLFileMaker.GenerateIncompleteTypeDefinitions"));
            ArrayList<ModelIDObject> list = new ArrayList<ModelIDObject>();
            ArrayList<StructuredTypeProxy> refList = new ArrayList<StructuredTypeProxy>();
            it = this.getStorageDesign().ddlTypeObjects();
            while (it.hasNext()) {
                ModelIDObject obj = (ModelIDObject)it.next();
                if (!obj.isMarkedGenerate()) continue;
                list.add(obj);
                this.getStorageDesign().processDependencies(obj, Collections.EMPTY_LIST, refList);
            }
            DDLGenerator incompleteTypesGenerator = this.getStorageDesign().getDDLIncompleteTypeGenerator();
            it = this.getStorageDesign() instanceof StorageDesignOracle ? refList.iterator() : this.getStorageDesign().ddlIncompleteTypeObjects();
            while (it.hasNext()) {
                ModelObject object6 = (ModelObject)it.next();
                this.appendStatementFor(object6, incompleteTypesGenerator);
            }
            monitor.setProgress(16);
            monitor.setNote(Messages.getString("DDLFileMaker.GenerateTypeDefinitions"));
            DDLGenerator typesGenerator = this.getStorageDesign().getDDLTypeGenerator();
            this.sortObjects(list);
            it = this.sorted.iterator();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    object3 = (ModelObject)it.next();
                    String result2 = this.appendStatementFor(object3, typesGenerator);
                    if (result2 == null || result2.isEmpty()) continue;
                    this.saveDDLToFile(result2, ((ModelIDObject)object3).getOldObjectTypeName(), object3.getLongName(), true);
                }
            } else {
                while (it.hasNext()) {
                    object3 = (ModelObject)it.next();
                    this.appendStatementFor(object3, typesGenerator);
                }
            }
            monitor.setProgress(20);
            DDLGenerator ddlGenerator = this.getStorageDesign().getDDLGenerator();
            list.clear();
            for (ModelIDObject obj : listOfDDLObjects) {
                if (!obj.isMarkedGenerate()) continue;
                list.add(obj);
            }
            monitor.setNote(Messages.getString("DDLFileMaker.FindingDependencies"));
            monitor.setProgress(25);
            this.getStorageDesign().parse(list);
            monitor.setProgress(30);
            this.sortObjects(list);
            it = this.sorted.iterator();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                while (it.hasNext()) {
                    object2 = (ModelObject)it.next();
                    monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AppendDDLInfoFor"), object2.getName()));
                    monitor.setProgress(++p);
                    String result3 = this.appendStatementFor(object2, ddlGenerator);
                    if (result3 == null || result3.isEmpty()) continue;
                    this.saveDDLToFile(result3, ((ModelIDObject)object2).getOldObjectTypeName(), object2.getLongName(), ((ModelIDObject)object2).isDataObject());
                }
            } else {
                while (it.hasNext()) {
                    object2 = (ModelObject)it.next();
                    monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AppendDDLInfoFor"), object2.getName()));
                    monitor.setProgress(++p);
                    this.appendStatementFor(object2, ddlGenerator);
                }
            }
            this.sorted.clear();
            DDLGenerator scopeGenerator = this.getStorageDesign().getDDLScopeGenerator();
            it = this.getStorageDesign().ddlScopeObjects();
            while (it.hasNext()) {
                ModelObject object7 = (ModelObject)it.next();
                monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.AlterTableAddScopeFor"), object7.getName()));
                monitor.setProgress(++p);
                this.appendStatementFor(object7, scopeGenerator);
            }
            DDLGenerator redactionPolicyGenerator = this.getStorageDesign().getRedactionPolicyGenerator();
            it = this.getStorageDesign().ddlRedactionPolicyObjects();
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                while (it.hasNext()) {
                    object = (ModelObject)it.next();
                    String result4 = this.appendStatementFor(object, redactionPolicyGenerator);
                    if (result4 == null || result4.isEmpty()) continue;
                    content.append(result4);
                    content.append(this.newline());
                }
                this.saveDDLToFile(content.toString(), null, "RedactionPolicies", true);
            } else {
                while (it.hasNext()) {
                    Object object8 = it.next();
                    this.appendStatementFor(object8, redactionPolicyGenerator);
                }
            }
            DDLGenerator tsdpGenerator = this.getStorageDesign().getTSDPGenerator();
            tsdpGenerator.clearTemporaryObjects();
            it = this.getStorageDesign().ddlTSDPPolicyObjects();
            while (it.hasNext()) {
                object = it.next();
                this.appendStatementFor(object, tsdpGenerator);
            }
            if (DDLGenerationOptions.generateDDLInFiles()) {
                StringBuffer content = new StringBuffer();
                tsdpGenerator.doOnFinish(content);
                this.saveDDLToFile(content.toString(), null, "TSDPPolicies", true);
                this.buffer().append(content.toString());
            } else {
                tsdpGenerator.doOnFinish(this.buffer());
            }
            DDLGenerator triggerGenerator = this.getStorageDesign().getDDLTriggerGenerator();
            it = this.getStorageDesign().ddlTriggersCausingObjects();
            while (it.hasNext()) {
                Object object9 = it.next();
                this.appendStatementFor(object9, triggerGenerator);
            }
            DDLGenerator autoIncrementColumnGenerator = this.getStorageDesign().getDDLAutoIncrementColumnGenerator();
            it = this.getStorageDesign().ddlAutoIncrementColumnObjects();
            while (it.hasNext()) {
                Object object10 = it.next();
                this.appendStatementFor(object10, autoIncrementColumnGenerator);
            }
            SSBAutoIncrementColumnOracle.clearGenSequenceSet();
            for (DDLGenerator endScriptGenerator : this.getStorageDesign().getDDLEndScriptGenerators()) {
                it = this.getStorageDesign().ddlEndScriptObjects();
                while (it.hasNext()) {
                    ModelObject object11 = (ModelObject)it.next();
                    monitor.setNote(MessageFormat.format(Messages.getString("DDLFileMaker.EndScriptFor"), object11.getName()));
                    monitor.setProgress(++p);
                    this.appendStatementFor(object11, endScriptGenerator);
                }
            }
            if (DDLGenerationOptions.getDDLType() > 0 && ddlAdvancedGenerator != null) {
                ddlAdvancedGenerator.addStatementFinisher(this.buffer());
            }
            monitor.setNote(Messages.getString("DDLFileMaker.FinishingGeneration"));
            monitor.setProgress(97);
            this.buffer().append(this.newline());
            this.buffer().append(this.newline());
            this.appendCounters(this.buffer(), this.getStorageDesign().getRDBMSType());
        } else {
            monitor.setProgress(100);
            this.buffer().append(Messages.getString("DDLFileMaker.NoStorageDesignAvailable"));
        }
        this.getAppView().getCurrentDesign().setSelectedRDBMSSite(defaultSite);
        this.ddlFilesFolder = null;
    }

    private void appendCounters(StringBuffer buffer, RDBMSType type) {
        buffer.append(Messages.getString("DDLFileMaker.SummaryReport"));
        buffer.append(this.newline());
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TABLE", createTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE INDEX", createIndex);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TABLE", alterTable);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE VIEW", createView);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE", createPackage);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PACKAGE BODY", createPackageBody);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE PROCEDURE", createProc);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE FUNCTION", createFunction);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- CREATE TRIGGER", createTrigger);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ALTER TRIGGER", alterTrigger);
        if (type == StorageDesignDB2v70.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE AUX TABLE", createAuxTable);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STOGROUP", createStoGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP ALIAS", dropAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SYNONYM", dropSynonym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP STOGROUP", dropStogroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP PROCEDURES", dropProcedures);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TRIGGERS", dropTriggers);
            buffer.append(this.newline());
        } else if (type == StorageDesignDB2v80.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE AUX TABLE", createAuxTable);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STOGROUP", createStoGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP ALIAS", dropAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SYNONYM", dropSynonym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP STOGROUP", dropStogroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DISTINCT TYPE", dropDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP PROCEDURES", dropProcedures);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TRIGGERS", dropTriggers);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP SEQUENCE", dropSequence);
            buffer.append(this.newline());
        } else if (type == StorageDesignUDBv71.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE BUFFERPOOL", createBufferPool);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INSTANCE", createInstance);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE NODE GROUP", createNodeGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignUDBv81.RDBMS_TYPE || type == StorageDesignUDBv9.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ALIAS", createAlias);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE BUFFERPOOL", createBufferPool);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISTINCT TYPE", createDistinctType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INSTANCE", createInstance);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE PARTITION GROUP", createDbPartitionGroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SCHEMA", createSchema);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev9i.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignOraclev10g.RDBMS_TYPE || type == StorageDesignOraclev11g.RDBMS_TYPE || type == StorageDesignOraclev12c.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE COLLECTION TYPE", createCollectionType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE", createStructuredType);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE STRUCTURED TYPE BODY", createStructuredTypeBody);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CLUSTER", createCluster);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE CONTEXT", createContext);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIMENSION", createDimension);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DIRECTORY", createDirectory);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DISK GROUP", createDiskgroup);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SEQUENCE", createSequence);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE MATERIALIZED VIEW", createSnapshot);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE SYNONYM", createSynomym);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE TABLESPACE", createTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE USER", createUser);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP TABLESPACE", dropTablespace);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
            if (type != StorageDesignOraclev10g.RDBMS_TYPE) {
                buffer.append("-- ");
                buffer.append(this.newline());
                this.appendFormattedString(buffer, "-- REDACTION POLICY", redactionPolicies);
                buffer.append(this.newline());
                if (type == StorageDesignOraclev12c.RDBMS_TYPE) {
                    this.appendFormattedString(buffer, "-- TSDP POLICY", tsdpPolicies);
                    buffer.append(this.newline());
                }
            }
        } else if (type == StorageDesignSqlServerv2k.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DEFAULT", createDefault);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE RULE", createRule);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        } else if (type == StorageDesignSqlServerv2k5.RDBMS_TYPE || type == StorageDesignSqlServerv2k8.RDBMS_TYPE) {
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DATABASE", createDatabase);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE DEFAULT", createDefault);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE INDEX ON VIEW", createIndexOnView);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLLBACK SEGMENT", createRollbackSegment);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE ROLE", createRole);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE RULE", createRule);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE PARTITION FUNCTION", createPartitionFunction);
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- CREATE PARTITION SCHEME", createPartitionScheme);
            buffer.append(this.newline());
            buffer.append("-- ");
            buffer.append(this.newline());
            this.appendFormattedString(buffer, "-- DROP DATABASE", dropDatabase);
            buffer.append(this.newline());
        }
        buffer.append("-- ");
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- ERRORS", errors);
        buffer.append(this.newline());
        this.appendFormattedString(buffer, "-- WARNINGS", warnings);
        buffer.append(this.newline());
    }

    private void appendFormattedString(StringBuffer buffer, String string, int number) {
        int n = Integer.valueOf(number).toString().length();
        buffer.append(string);
        for (int i = 0; i < 45 - string.length() - n; ++i) {
            buffer.append(' ');
        }
        buffer.append(number);
    }

    public static void incrementCreateDatabase() {
        if (normalIncrement) {
            ++createDatabase;
        }
    }

    public static void incrementCreateTable() {
        if (normalIncrement) {
            ++createTable;
        }
    }

    public static int getCreateTable() {
        return createTable;
    }

    public static void incrementCreateIndex() {
        if (normalIncrement) {
            ++createIndex;
        }
    }

    public static int getCreateIndex() {
        return createIndex;
    }

    public static void incrementCreateTablespace() {
        if (normalIncrement) {
            ++createTablespace;
        }
    }

    public static void incrementCreateView() {
        if (normalIncrement) {
            ++createView;
        }
    }

    public static int getCreateView() {
        return createView;
    }

    public static void incrementAlterTable() {
        if (normalIncrement) {
            ++alterTable;
        }
    }

    public static int getAlterTable() {
        return alterTable;
    }

    public static void incrementCreateTrigger() {
        if (normalIncrement) {
            ++createTrigger;
        }
    }

    public static int getCreateTrigger() {
        return createTrigger;
    }

    public static int getRedactionPolicies() {
        return redactionPolicies;
    }

    public static int getTSDPPolicies() {
        return tsdpPolicies;
    }

    public static void incrementAlterTrigger() {
        if (normalIncrement) {
            ++alterTrigger;
        }
    }

    public static int getAlterTrigger() {
        return alterTrigger;
    }

    public static void incrementCreatePackage() {
        if (normalIncrement) {
            ++createPackage;
        }
    }

    public static void incrementCreateProc() {
        if (normalIncrement) {
            ++createProc;
        }
    }

    public static void incrementCreateFunction() {
        if (normalIncrement) {
            ++createFunction;
        }
    }

    public static void incrementCreatePackageBody() {
        if (normalIncrement) {
            ++createPackageBody;
        }
    }

    public static void incrementCreateAlias() {
        if (normalIncrement) {
            ++createAlias;
        }
    }

    public static void incrementCreateAuxTable() {
        if (normalIncrement) {
            ++createAuxTable;
        }
    }

    public static void incrementCreateDistinctType() {
        if (normalIncrement) {
            ++createDistinctType;
        }
    }

    public static void incrementCreateStructuredType() {
        if (normalIncrement) {
            ++createStructuredType;
        }
    }

    public static void incrementCreateStructuredTypeBody() {
        if (normalIncrement) {
            ++createStructuredTypeBody;
        }
    }

    public static void incrementCreateCollectionType() {
        if (normalIncrement) {
            ++createCollectionType;
        }
    }

    public static void incrementCreateStoGroup() {
        if (normalIncrement) {
            ++createStoGroup;
        }
    }

    public static void incrementCreateSynomym() {
        if (normalIncrement) {
            ++createSynomym;
        }
    }

    public static void incrementCreateCluster() {
        if (normalIncrement) {
            ++createCluster;
        }
    }

    public static void incrementCreateContext() {
        if (normalIncrement) {
            ++createContext;
        }
    }

    public static void incrementCreateDimension() {
        if (normalIncrement) {
            ++createDimension;
        }
    }

    public static void incrementCreateDirectory() {
        if (normalIncrement) {
            ++createDirectory;
        }
    }

    public static void incrementCreateRole() {
        if (normalIncrement) {
            ++createRole;
        }
    }

    public static void incrementCreateRollbackSegment() {
        if (normalIncrement) {
            ++createRollbackSegment;
        }
    }

    public static void incrementCreateSequence() {
        if (normalIncrement) {
            ++createSequence;
        }
    }

    public static int getCreateSequence() {
        return createSequence;
    }

    public static void incrementCreateSnapshot() {
        if (normalIncrement) {
            ++createSnapshot;
        }
    }

    public static int getCreateSnapshot() {
        return createSnapshot;
    }

    public static void incrementCreateDiskgroup() {
        if (normalIncrement) {
            ++createDiskgroup;
        }
    }

    public static void incrementCreateUser() {
        if (normalIncrement) {
            ++createUser;
        }
    }

    public static void incrementCreateDefault() {
        if (normalIncrement) {
            ++createDefault;
        }
    }

    public static void incrementCreateRule() {
        if (normalIncrement) {
            ++createRule;
        }
    }

    public static void incrementCreateIndexOnView() {
        if (normalIncrement) {
            ++createIndexOnView;
        }
    }

    public static void incrementCreateInstance() {
        if (normalIncrement) {
            ++createInstance;
        }
    }

    public static void incrementCreateNodeGroup() {
        if (normalIncrement) {
            ++createNodeGroup;
        }
    }

    public static void incrementCreateDbPartitionGroup() {
        if (normalIncrement) {
            ++createDbPartitionGroup;
        }
    }

    public static void incrementCreateBufferPool() {
        if (normalIncrement) {
            ++createBufferPool;
        }
    }

    public static void incrementCreateSchema() {
        if (normalIncrement) {
            ++createSchema;
        }
    }

    public static void incrementRedactionPolicies() {
        if (normalIncrement) {
            ++redactionPolicies;
        }
    }

    public static void incrementTSDPPolicies() {
        if (normalIncrement) {
            ++tsdpPolicies;
        }
    }

    public static void incrementDropAlias() {
        if (normalIncrement) {
            ++dropAlias;
        }
    }

    public static void incrementDropTriggers() {
        if (normalIncrement) {
            ++dropTriggers;
        }
    }

    public static void incrementDropProcedures() {
        if (normalIncrement) {
            ++dropProcedures;
        }
    }

    public static void incrementDropSynonym() {
        if (normalIncrement) {
            ++dropSynonym;
        }
    }

    public static void incrementDropStogroup() {
        if (normalIncrement) {
            ++dropStogroup;
        }
    }

    public static void incrementDropDistinctType() {
        if (normalIncrement) {
            ++dropDistinctType;
        }
    }

    public static void incrementDropSequence() {
        if (normalIncrement) {
            ++dropSequence;
        }
    }

    public static void incrementDropDatabase() {
        if (normalIncrement) {
            ++dropDatabase;
        }
    }

    public static void incrementDropTablespace() {
        if (normalIncrement) {
            ++dropTablespace;
        }
    }

    public static void incrementErrors() {
        if (normalIncrement) {
            ++errors;
        }
    }

    public static int getErrors() {
        return errors;
    }

    public static void incrementWarnings() {
        if (normalIncrement) {
            ++warnings;
        }
    }

    public static int getWarnings() {
        return warnings;
    }

    public static void incrementPartitionFunction() {
        if (normalIncrement) {
            ++createPartitionFunction;
        }
    }

    public static void incrementPartitionSheme() {
        if (normalIncrement) {
            ++createPartitionScheme;
        }
    }

    public static void incrementAdvancedStep() {
        if (normalIncrement) {
            advancedStep += 10;
        }
    }

    public static void resetCounters() {
        createDatabase = 0;
        createTable = 0;
        createIndex = 0;
        createTablespace = 0;
        createView = 0;
        alterTable = 0;
        createTrigger = 0;
        alterTrigger = 0;
        createPackage = 0;
        createPackageBody = 0;
        createProc = 0;
        createFunction = 0;
        redactionPolicies = 0;
        tsdpPolicies = 0;
        createAlias = 0;
        createAuxTable = 0;
        createDistinctType = 0;
        createStructuredType = 0;
        createStructuredTypeBody = 0;
        createCollectionType = 0;
        createStoGroup = 0;
        createSynomym = 0;
        createCluster = 0;
        createContext = 0;
        createDimension = 0;
        createDirectory = 0;
        createRole = 0;
        createRollbackSegment = 0;
        createSequence = 0;
        createSnapshot = 0;
        createDiskgroup = 0;
        createUser = 0;
        createDefault = 0;
        createRule = 0;
        createIndexOnView = 0;
        createInstance = 0;
        createNodeGroup = 0;
        createDbPartitionGroup = 0;
        createBufferPool = 0;
        createSchema = 0;
        createPartitionFunction = 0;
        createPartitionScheme = 0;
        dropDatabase = 0;
        dropTablespace = 0;
        dropAlias = 0;
        dropSynonym = 0;
        dropStogroup = 0;
        dropSequence = 0;
        dropDistinctType = 0;
        dropProcedures = 0;
        dropTriggers = 0;
        errors = 0;
        warnings = 0;
        advancedStep = 10;
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public void clearContent() {
        this.buffer().setLength(0);
        this.content = null;
    }

    public String getContent() {
        if (this.content == null) {
            this.content = this.buffer().toString();
        }
        return this.content;
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        if (!this.getAppView().getSettings().useSQLDevFormatting()) {
            return sql;
        }
        DMSQLFormatter command = new DMSQLFormatter();
        if (storageDesign instanceof StorageDesignOracle) {
            return command.formatSQL(sql, "Oracle");
        }
        if (storageDesign instanceof StorageDesignSqlServer) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (storageDesign instanceof AbstractStorageDesignDB2 || storageDesign instanceof StorageDesignUDB) {
            return command.formatSQL(sql, "DB2");
        }
        return command.formatSQL(sql, "Oracle");
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void saveContentDDLFile() {
        this.getAppView().getPersistenceManager().write(this);
    }

    public void statusMessage(String message, Object object) {
        this.statusMessage(message + object);
    }

    public void statusMessage(String message) {
        this.statusBarOwner.setTempStatusMessage(message, 5000);
    }

    public void checkErrors(Component parent) {
        if (errors > 0) {
            String message = errors == 1 ? Messages.getString("DDLFileMaker.OneError") : MessageFormat.format(Messages.getString("DDLFileMaker.MultipleErrors"), errors);
            MessageDialogs.showMessage(parent, MessageFormat.format(Messages.getString("DDLFileMaker.CheckDesignRules"), message));
        }
    }

    public static int getAdvancedStep() {
        return advancedStep;
    }

    public static DDLAdvancedGenerator getddlAdvancedGenenerator() {
        return ddlAdvancedGenenerator;
    }

    public static void setddlAdvancedGenenerator(DDLAdvancedGenerator ddladvgen) {
        ddlAdvancedGenenerator = ddladvgen;
    }

    private void sortObjects(List objects) {
        this.sorted.clear();
        this.sortedMap.clear();
        this.tracedMap.clear();
        for (ModelIDObject obj : objects) {
            this.addToSorted(obj, obj, objects);
            this.tracedMap.clear();
        }
        this.sortedMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSorted(ModelIDObject obj, ModelIDObject topLevelObj, List initialList) {
        if (this.sortedMap.containsKey(obj)) {
            return;
        }
        this.tracedMap.put(obj, obj);
        List<ModelIDObject> list = obj.getParsedDependOnList();
        if (list != null) {
            for (ModelIDObject dep : list) {
                if (this.sortedMap.containsKey(dep) || !initialList.contains(dep) || this.tracedMap.containsKey(dep)) continue;
                if ((topLevelObj instanceof FunctionOracle || topLevelObj instanceof StoredProcedureOracle) && dep instanceof TableProxyOracle) {
                    DDLAdvancedGenerator savedGenerator = DDLFileMaker.getddlAdvancedGenenerator();
                    DDLFileMaker.setddlAdvancedGenenerator(null);
                    normalIncrement = false;
                    try {
                        StringBuffer ddlStringBuffer = new StringBuffer();
                        this.storageDesign.getDDLGenerator().appendDDLFor(ddlStringBuffer, dep);
                        String sql = ddlStringBuffer.toString();
                        this.storageDesign.processDependencies(dep, SQLAnalyzer.getTablesAndFunctions(sql), null);
                    }
                    finally {
                        DDLFileMaker.setddlAdvancedGenenerator(savedGenerator);
                        normalIncrement = true;
                    }
                }
                this.addToSorted(dep, topLevelObj, initialList);
            }
        }
        this.sorted.add(obj);
        this.sortedMap.put(obj, obj);
    }
}

