/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateListener;
import oracle.dbtools.crest.model.propertyholder.functionality.UpdateSubject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.DMSQLFormatter;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.FindHighlightPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.editor.plugins.StatusBarPlugin;

public class DDLViewer
extends CustomDialog
implements ObjectListener,
UpdateListener {
    private Object ddlObject;
    private StringBuffer buffer = new StringBuffer();
    private JDialog dialog;
    private BasicEditorPane m_editor;
    private JPanel headerPanel;
    private JLabel headerLabel;
    private JPanel leftMargin = new JPanel(new BorderLayout());
    private static final Logger LOGGER = new Logger(DDLViewer.class);

    public DDLViewer(ApplicationView applicationView) {
        super(applicationView);
        this.setLayout(new BorderLayout());
        JScrollPane m_scrollPane = new JScrollPane((Component)this.getEditor(), 20, 30);
        m_scrollPane.setRowHeaderView(this.leftMargin);
        JViewport viewport = m_scrollPane.getViewport();
        viewport.setScrollMode(1);
        this.add((Component)m_scrollPane, "Center");
        JButton bnClose = new JButton(Messages.getString("DDLViewer.Close"));
        bnClose.setMnemonic(67);
        bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLViewer.this.close();
            }
        });
        JPanel pnButtons = new JPanel();
        pnButtons.add(bnClose);
        this.add((Component)pnButtons, "South");
    }

    @Override
    protected void close() {
        this.getDialog().setVisible(false);
        this.setDDLObject(null);
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public void setDDLObject(Object object) {
        if (this.ddlObject instanceof DesignObject) {
            ((DesignObject)this.ddlObject).removeObjectListener(this);
        } else if (this.ddlObject instanceof UpdateSubject) {
            ((UpdateSubject)this.ddlObject).removeUpdateListener(this);
        }
        this.ddlObject = object;
        if (object != null) {
            if (object instanceof DesignObject) {
                if (!(((DesignObject)object).getDesignPart() instanceof RelationalDesign)) {
                    return;
                }
                ((DesignObject)object).addObjectListener(this);
            } else if (object instanceof UpdateSubject) {
                ((UpdateSubject)object).addUpdateListener(this);
            }
            this.doChange(this.ddlObject);
        }
    }

    public Object getDDLObject() {
        return this.ddlObject;
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (!object.getIsBeingRemoved() && this.getDialog().isVisible()) {
            this.doChange(object);
        }
    }

    @Override
    public void update() {
        this.doChange(this.ddlObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChange(Object object) {
        HashMap<StorageObject, Boolean> map = new HashMap<StorageObject, Boolean>();
        List list = null;
        StorageDesign storageDesign = null;
        if (object instanceof StorageObject) {
            storageDesign = ((StorageObject)object).getStorageDesign();
        } else if (object instanceof DesignObject) {
            storageDesign = ((RelationalDesign)((DesignObject)object).getDesignPart()).getStorageDesign();
        } else if (object instanceof ModelIDObject) {
            storageDesign = this.getDesign().getRelationalDesign().getStorageDesign();
        }
        if (storageDesign != null) {
            StorageObject sto;
            boolean oldState = ((ModelIDObject)this.ddlObject).isMarkedGenerate();
            try {
                ((ModelIDObject)this.ddlObject).setMarkedGenerate(true);
                this.buffer.setLength(0);
                list = this.getListOfObjects(object, storageDesign);
                for (ModelIDObject ddlob : list) {
                    if (ddlob instanceof DesignObject && storageDesign.isOpen() && (sto = storageDesign.getStorageObject(ddlob.getObjectID())) != null) {
                        map.put(sto, sto.isMarkedGenerate());
                        sto.setMarkedGenerate(true);
                    }
                    if (ddlob instanceof AbstractStorageObjectOracle) {
                        storageDesign.getDDLUserGenerator().appendDDLFor(this.buffer, ddlob);
                    }
                    storageDesign.getDDLGenerator().appendDDLFor(this.buffer, ddlob);
                }
                for (ModelIDObject ddlob : list) {
                    if (!(ddlob instanceof Table) && !(ddlob instanceof TableView) && !(ddlob instanceof TableProxy) && !(ddlob instanceof TableViewProxy) && !(ddlob instanceof FKArc)) continue;
                    this.appendExtraDDL(ddlob, storageDesign);
                }
                this.getEditor().setText("");
                BasicDocument document = (BasicDocument)this.getEditor().getDocument();
                document.getTextBuffer().remove(0, document.getTextBuffer().getLength());
                try {
                    this.getEditor().getDocument().insertString(0, this.formatSQL(this.buffer.toString(), storageDesign), null);
                }
                catch (BadLocationException e) {
                    LOGGER.error("DDLViewer", e);
                }
                this.getEditor().setCaretPosition(0);
                this.getEditor().ensureCaretVisible();
            }
            finally {
                ((ModelIDObject)this.ddlObject).setMarkedGenerate(oldState);
                if (list != null) {
                    for (ModelIDObject ddlob : list) {
                        Boolean bool;
                        if (!(ddlob instanceof DesignObject) || !storageDesign.isOpen() || (sto = storageDesign.getStorageObject(ddlob.getObjectID())) == null || (bool = (Boolean)map.get(sto)) == null) continue;
                        sto.setMarkedGenerate(bool);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void ddlPreview(Object[] objects, RelationalDesign relDesign) {
        HashMap<StorageObject, Boolean> map = new HashMap<StorageObject, Boolean>();
        ArrayList<Object> list = null;
        StorageDesign storageDesign = relDesign.getStorageDesign();
        if (storageDesign != null) {
            DDLFileMaker.setddlAdvancedGenenerator(null);
            this.getApplicationView().initLineTerminator();
            ArrayList<ModelIDObject> fkeys = new ArrayList<ModelIDObject>();
            ArrayList<Table> tables = new ArrayList<Table>();
            ArrayList<Object> views = new ArrayList<Object>();
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                Table table = null;
                if (object instanceof Table) {
                    table = (Table)object;
                } else if (object instanceof TableProxy) {
                    table = (Table)((TableProxy)object).getObject();
                }
                if (table != null) {
                    tables.add(table);
                    for (ModelIDObject modelIDObject : table.getFKAssociationsList()) {
                        if (!modelIDObject.isMarkedGenerate()) continue;
                        fkeys.add(modelIDObject);
                    }
                    for (ModelIDObject arc : table.getArcs()) {
                        if (!arc.isMarkedGenerate()) continue;
                        fkeys.add(arc);
                    }
                    continue;
                }
                if (!(object instanceof TableView)) continue;
                views.add(object);
            }
            Collections.sort(tables, ModelObjectSet.NAME_COMPARATOR);
            Collections.sort(fkeys, ModelObjectSet.LONG_NAME_COMPARATOR);
            Collections.sort(views, ModelObjectSet.NAME_COMPARATOR);
            list = new ArrayList<Object>();
            list.addAll(tables);
            list.addAll(fkeys);
            list.addAll(views);
            this.buffer.setLength(0);
            try {
                for (ModelIDObject modelIDObject : list) {
                    void var10_15;
                    StorageObject sto;
                    if (modelIDObject instanceof DesignObject && storageDesign.isOpen() && (sto = storageDesign.getStorageObject(modelIDObject.getObjectID())) != null) {
                        map.put(sto, sto.isMarkedGenerate());
                        sto.setMarkedGenerate(true);
                    }
                    if (modelIDObject instanceof Table) {
                        SnapshotOracle snapshotOracle;
                        Table table = (Table)modelIDObject;
                        RelationalObjectProxy tableProxy = storageDesign.getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy instanceof TableProxyOracle && (snapshotOracle = ((TableProxyOracle)tableProxy).getSnapshot()) != null) {
                            SnapshotOracle snapshotOracle2 = snapshotOracle;
                        }
                    }
                    boolean oldmark = var10_15.isMarkedGenerate();
                    var10_15.setMarkedGenerate(true);
                    try {
                        storageDesign.getDDLGenerator().appendDDLFor(this.buffer, var10_15);
                    }
                    finally {
                        var10_15.setMarkedGenerate(oldmark);
                    }
                }
            }
            finally {
                if (list != null) {
                    for (ModelIDObject modelIDObject : list) {
                        Boolean bool;
                        StorageObject sto;
                        if (!(modelIDObject instanceof DesignObject) || !storageDesign.isOpen() || (sto = storageDesign.getStorageObject(modelIDObject.getObjectID())) == null || (bool = (Boolean)map.get(sto)) == null) continue;
                        sto.setMarkedGenerate(bool);
                    }
                }
            }
            for (ModelIDObject modelIDObject : list) {
                boolean oldmark = modelIDObject.isMarkedGenerate();
                modelIDObject.setMarkedGenerate(true);
                try {
                    if (!(modelIDObject instanceof Table) && !(modelIDObject instanceof TableView) && !(modelIDObject instanceof FKArc)) continue;
                    this.appendExtraDDL(modelIDObject, storageDesign);
                }
                finally {
                    modelIDObject.setMarkedGenerate(oldmark);
                }
            }
            this.getEditor().setText("");
            BasicDocument basicDocument = (BasicDocument)this.getEditor().getDocument();
            basicDocument.getTextBuffer().remove(0, basicDocument.getTextBuffer().getLength());
            try {
                this.getEditor().getDocument().insertString(0, this.formatSQL(this.buffer.toString(), storageDesign), null);
            }
            catch (BadLocationException e) {
                LOGGER.error("DDLViewer", e);
            }
            this.getEditor().setCaretPosition(0);
            this.getEditor().ensureCaretVisible();
        }
    }

    private void appendExtraDDL(ModelIDObject ddlob, StorageDesign storageDesign) {
        StorageObjectCollection triggers;
        TableProxy tableProxy;
        storageDesign.getDDLScopeGenerator().appendDDLFor(this.buffer, ddlob);
        storageDesign.getRedactionPolicyGenerator().appendDDLFor(this.buffer, ddlob);
        storageDesign.getTSDPGenerator().clearTemporaryObjects();
        storageDesign.getTSDPGenerator().appendDDLFor(this.buffer, ddlob);
        storageDesign.getTSDPGenerator().doOnFinish(this.buffer);
        if ((ddlob instanceof Table || ddlob instanceof TableProxy) && (tableProxy = (TableProxy)storageDesign.getTableProxySet().getProxy(ddlob.getObjectID())) != null && (triggers = tableProxy.getTriggers()) != null) {
            Iterator triggerIt = triggers.iterator();
            while (triggerIt.hasNext()) {
                Trigger trigger = (Trigger)triggerIt.next();
                storageDesign.getDDLPhysicalTriggerGenerator().appendDDLFor(this.buffer, trigger);
            }
        }
        storageDesign.getDDLTriggerGenerator().appendDDLFor(this.buffer, ddlob);
        storageDesign.getDDLAutoIncrementColumnGenerator().appendDDLFor(this.buffer, ddlob);
        SSBAutoIncrementColumnOracle.clearGenSequenceSet();
        for (DDLGenerator endScriptGenerator : storageDesign.getDDLEndScriptGenerators()) {
            endScriptGenerator.appendDDLFor(this.buffer, ddlob);
        }
    }

    List getListOfObjects(Object object, StorageDesign storageDesign) {
        SnapshotOracle implementingMV;
        ArrayList<Object> list = new ArrayList<Object>();
        Table table = null;
        RelationalObjectProxy tableProxy = null;
        if (object instanceof Table) {
            table = (Table)object;
            tableProxy = storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxy) {
            tableProxy = (TableProxy)object;
            table = (Table)tableProxy.getObject();
        }
        if (tableProxy instanceof TableProxyOracle && (implementingMV = ((TableProxyOracle)tableProxy).getSnapshot()) != null) {
            object = implementingMV;
        }
        list.add(object);
        if (table != null) {
            for (ModelIDObject modelIDObject : table.getFKAssociationsList()) {
                if (!modelIDObject.isMarkedGenerate()) continue;
                list.add(modelIDObject);
            }
            for (ModelIDObject arc : table.getArcs()) {
                if (!arc.isMarkedGenerate()) continue;
                list.add(arc);
            }
        }
        return list;
    }

    public BasicEditorPane getEditor() {
        if (this.m_editor == null) {
            this.m_editor = new BasicEditorPane();
            this.m_editor.setContentType(CodeEditorConstants.TYPE_SQL);
            this.m_editor.setLanguageSupport(".sql");
            this.m_editor.putBooleanProperty("show-line-numbers", true);
            this.m_editor.setVisible(true);
            this.m_editor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
            final FindHighlightPlugin hlPlugin = new FindHighlightPlugin();
            MouseAdapter doubleClickHandler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() != 2) {
                        return;
                    }
                    hlPlugin.findText(DDLViewer.this.m_editor.getSelectedText(), 0, true, false, true, true, true);
                }
            };
            this.m_editor.addMouseListener((MouseListener)doubleClickHandler);
            this.m_editor.installPlugin((EditorPlugin)hlPlugin);
            StatusBarPlugin statusBar = new StatusBarPlugin(this.m_editor.getFont());
            this.m_editor.installPlugin((EditorPlugin)statusBar);
            EditorStatusBar m_statusBar = new EditorStatusBar();
            this.m_editor.putProperty("finder", (Object)hlPlugin);
            this.m_editor.putBooleanProperty("language-support", true);
            this.m_editor.putBooleanProperty("brace-matching-auto", true);
            this.m_editor.putBooleanProperty("code-folding-enabled", true);
            this.m_editor.putBooleanProperty("use-auto-indent", true);
            this.m_editor.putBooleanProperty("use-smart-indent", true);
            this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
            this.m_editor.installPlugin((EditorPlugin)m_statusBar);
            LineGutterPlugin sqlGutter = new LineGutterPlugin();
            FileOverviewMargin m_fileOverviewMargin = new FileOverviewMargin();
            this.m_editor.installPlugin((EditorPlugin)sqlGutter);
            WorksheetFoldingPlugin m_foldingPlugin = new WorksheetFoldingPlugin();
            this.m_editor.installPlugin((EditorPlugin)m_foldingPlugin);
            CodeFoldingMargin codeFoldingMargin = m_foldingPlugin.getCodeFoldingMargin();
            this.leftMargin.add((Component)codeFoldingMargin, "East");
            this.leftMargin.add((Component)sqlGutter, "Center");
            this.m_editor.installPlugin((EditorPlugin)m_fileOverviewMargin);
            this.m_editor.setEditable(false);
        }
        return this.m_editor;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DDLViewer.DDLPreview"));
            this.dialog.setContentPane(this);
            this.dialog.setSize(840, 700);
            this.setDefaultActions(this.dialog, false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    public void setDialogVisible(boolean value) {
        this.getDialog().setVisible(value);
    }

    public boolean isDialogVisible() {
        return this.getDialog().isVisible();
    }

    public JPanel getHeaderPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel(new BorderLayout());
            this.headerPanel.add((Component)this.getHeaderLabel(), "Center");
        }
        return this.headerPanel;
    }

    public JLabel getHeaderLabel() {
        if (this.headerLabel == null) {
            this.headerLabel = new JLabel();
            this.headerLabel.setForeground(Color.black);
            Font font = this.headerLabel.getFont().deriveFont(0, 10.0f);
            this.headerLabel.setFont(font);
            this.headerLabel.setText(Messages.getString("DDLViewer.NotInitialized"));
        }
        return this.headerLabel;
    }

    private String formatSQL(String sql, StorageDesign storageDesign) {
        if (!this.getApplicationView().getSettings().useSQLDevFormatting()) {
            return sql;
        }
        DMSQLFormatter command = new DMSQLFormatter();
        if (storageDesign instanceof StorageDesignOracle) {
            return command.formatSQL(sql, "Oracle");
        }
        if (storageDesign instanceof StorageDesignSqlServer) {
            return command.formatSQL(sql, "Microsoft SQL Server");
        }
        if (storageDesign instanceof AbstractStorageDesignDB2 || storageDesign instanceof StorageDesignUDB) {
            return command.formatSQL(sql, "DB2");
        }
        return command.formatSQL(sql, "Oracle");
    }
}

