/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainerObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.process.RoleSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SequenceSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StoredProcedureSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SynonymSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerSetOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionOraclev8i
extends ModelIdObjectSelection
implements DDLSelectionLists {
    private static final String CLUSTERS = Messages.getString("DDLSelectionOraclev8i.Clusters");
    private static final String CONTEXTS = Messages.getString("DDLSelectionOraclev8i.Contexts");
    private static final String DIMENSIONS = Messages.getString("DDLSelectionOraclev8i.Dimensions");
    private static final String DIRECTORIES = Messages.getString("DDLSelectionOraclev8i.Directories");
    private static final String ROLES = Messages.getString("DDLSelectionOraclev8i.Roles");
    private static final String ROLLBACK_SEGMENTS = Messages.getString("DDLSelectionOraclev8i.RollbackSegments");
    private static final String SEQUENCES = Messages.getString("DDLSelectionOraclev8i.Sequences");
    private static final String SNAPSHOTS = Messages.getString("DDLSelectionOraclev8i.Snapshots");
    private static final String PACKAGES = Messages.getString("DDLSelectionOraclev8i.Packages");
    private static final String STORED_PROCEDURES = Messages.getString("DDLSelectionOraclev8i.StoredProcedures");
    private static final String FUNCTIONS = Messages.getString("DDLSelectionOraclev8i.Functions");
    private static final String PACKAGE_BODIES = Messages.getString("DDLSelectionOraclev8i.PackageBodies");
    private static final String STRUCTURED_TYPES = Messages.getString("DDLSelectionOraclev8i.StructuredTypes");
    private static final String TABLES = Messages.getString("DDLSelectionOraclev8i.Tables");
    private static final String SYNONYMS = Messages.getString("DDLSelectionOraclev8i.Synonyms");
    private static final String TABLESPACES = Messages.getString("DDLSelectionOraclev8i.Tablespaces");
    private static final String TEMP_TABLESPACES = Messages.getString("DDLSelectionOraclev8i.TempTablespaces");
    private static final String ASSIGNED_TO_USERS = Messages.getString("DDLSelectionOraclev8i.AssignedToUsers");
    private static final String NOT_ASSIGNED_TO_USERS = Messages.getString("DDLSelectionOraclev8i.NotAssignedToUsers");
    private static final String USERS = Messages.getString("DDLSelectionOraclev8i.UsersSchemas");
    private static final String VIEWS = Messages.getString("DDLSelectionOraclev8i.Views");
    private static final String CONSTRAINTS = Messages.getString("DDLSelectionOraclev8i.PKUKConstraints");
    private static final String INDEXES = Messages.getString("DDLSelectionOraclev8i.Indexes");
    private static final String FOREIGN_KEYS = Messages.getString("DDLSelectionOraclev8i.ForeignKeys");
    private static final String TRIGGERS = Messages.getString("DDLSelectionOraclev8i.Triggers");
    private StorageDesign stdes;
    private RelationalDesign phdes;
    private List triggerList;
    private List clusterList;
    private List dimensionList;
    private List sequenceList;
    private List snapshotList;
    private List packagesList;
    private List packageBodiesList;
    private List storedProceduresList;
    private List functionsList;
    private List synonymList;
    private List typeList;
    private List bjList;
    private List extTableList;
    private List collTypeList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionOraclev8i(StorageDesign design) {
        super(design.getName());
        this.stdes = design;
        this.phdes = this.stdes.getPhysicalDesign();
        if (design.isOpen()) {
            this.setElementDescriptor(design.getClass());
            this.addFromStorageDesign();
        } else {
            this.setName(this.phdes.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, this.selectedSubView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    public DDLSelectionOraclev8i(StorageDesign design, DesignPartView selectedSubView) {
        super(design.getName());
        this.stdes = design;
        this.phdes = this.stdes.getPhysicalDesign();
        this.selectedSubView = selectedSubView;
        if (design.isOpen()) {
            this.setElementDescriptor(design.getClass());
            this.addFromStorageDesign();
        } else if (selectedSubView != null) {
            this.setName(selectedSubView.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, selectedSubView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    protected void addFromStorageDesign() {
        this.addObjects(CONTEXTS, this, this.getStorageDesign().getContextSet().getElementsList());
        this.addObjects(DIRECTORIES, this, this.getStorageDesign().getDirectorySet().getElementsList());
        this.addObjects(ROLES, this, this.getStorageDesign().getRoleSet().getElementsList());
        this.addObjects(ROLLBACK_SEGMENTS, this, this.getStorageDesign().getRollbackSegmentSet().getElementsList());
        this.addObjects(TABLESPACES, this, this.getStorageDesign().getTableSpaceSet().getElementsList());
        this.addObjects(TEMP_TABLESPACES, this, this.getStorageDesign().getTemporaryTablespaceSet().getElementsList());
        this.addUsers(USERS, this, this.getStorageDesign().getUserSet().getElementsList());
        this.addObjectsAssignedToUsers(ASSIGNED_TO_USERS, this, this.getStorageDesign().getUserSet().getElementsList());
        this.addObjectsNotAssignedToUsers(NOT_ASSIGNED_TO_USERS, this);
        this.sort();
    }

    protected void addUsers(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection userSel = new ModelIdObjectSelection(nodeName);
        userSel.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        for (UserOracle user : list) {
            ModelIdObjectSelection isel = new ModelIdObjectSelection(user);
            userSel.addChild(isel);
        }
        selection.addChild(userSel);
    }

    protected void addObjectsAssignedToUsers(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection userSel = new ModelIdObjectSelection(nodeName);
        userSel.setElementDescriptor(SchemaObjectSet.class);
        for (UserOracle user : list) {
            ModelIdObjectSelection isel = new ModelIdObjectSelection(user.getName());
            isel.setElementDescriptor(SchemaObject.class);
            this.addUserDetails(user, isel);
            userSel.addChild(isel);
        }
        selection.addChild(userSel);
    }

    protected void addObjectsNotAssignedToUsers(String nodeName, ModelIdObjectSelection root) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(SchemaSetUDB.class);
        this.addContainerObjects(CLUSTERS, selection, this.getClustersWithoutUser(), this.getClusterList());
        this.addContainerObjects(DIMENSIONS, selection, this.getDimensionsWithoutUser(), this.getDimensionList());
        this.addContainerObjects(SEQUENCES, selection, this.getSequencesWithoutUser(), this.getSequenceList());
        this.addSnapshots(selection, this.getSnapshotsWithoutUser(), this.getSnapshotList());
        this.addPackages(selection);
        this.addContainerObjects(STORED_PROCEDURES, selection, this.getProcWithoutUser(), this.getStoredProceduresList());
        this.addContainerObjects(FUNCTIONS, selection, this.getFunctionsWithoutUser(), this.getFunctionsList());
        this.addStructuredTypes(STRUCTURED_TYPES, selection, this.getStrTypeWithoutUser(), this.getTypeList());
        this.addContainerObjects(SYNONYMS, selection, this.getSynonymsWithoutUser(), this.getSynonymList());
        this.addTables(TABLES, selection, this.getTableWithoutUser());
        this.addViews(VIEWS, selection, this.getViewWithoutUser());
        selection.sort();
        root.addChild(selection);
    }

    protected void addObjects(String nodeName, ModelIdObjectSelection selection, List list) {
        Iterator it = list.iterator();
        if (it.hasNext()) {
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(nodeName);
            while (it.hasNext()) {
                Object obj = it.next();
                ModelIdObjectSelection isel = new ModelIdObjectSelection((ModelIDObject)obj, true);
                objSel.setElementDescriptor(obj.getClass());
                objSel.addChild(isel);
            }
            selection.addChild(objSel);
        }
    }

    protected void addStructuredTypes(String nodeName, ModelIdObjectSelection selection, List list, List listToAdd) {
        ModelIdObjectSelection strSel = new ModelIdObjectSelection(nodeName);
        strSel.setElementDescriptor(StructuredTypeProxyOracle.class);
        Iterator it = list.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                StructuredTypeProxyOracle strType = (StructuredTypeProxyOracle)it.next();
                if (((StructuredType)strType.getObject()).isPredefined()) continue;
                ModelIdObjectSelection isel = new ModelIdObjectSelection(strType, true);
                strSel.addChild(isel);
                listToAdd.add(isel);
            }
            selection.addChild(strSel);
        }
    }

    protected void addTables(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection tableSel = new ModelIdObjectSelection(nodeName);
        tableSel.setElementDescriptor(TableSet.class);
        Iterator it = list.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                TableProxyOracle table = (TableProxyOracle)it.next();
                ModelIdObjectSelection sel = new ModelIdObjectSelection(table, true);
                this.addTableProxyDetails(table, sel);
                tableSel.addChild(sel);
                this.getTableList().add(sel);
            }
            selection.addChild(tableSel);
        }
    }

    protected void addViews(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection viewSel = new ModelIdObjectSelection(nodeName);
        viewSel.setElementDescriptor(TableViewSet.class);
        Iterator it = list.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                TableViewProxy viewProxy = (TableViewProxy)it.next();
                ModelIdObjectSelection isel = new ModelIdObjectSelection(viewProxy, true);
                this.addViewProxyDetails(viewProxy, isel);
                viewSel.addChild(isel);
                this.getViewList().add(isel);
            }
            selection.addChild(viewSel);
        }
    }

    protected void addPackages(ModelIdObjectSelection parent) {
        List<ModelIdObjectSelection> packages = this.addContainerObjects(PACKAGES, parent, this.getPackagesWithoutUser(), this.getPackagesList());
        for (ModelIdObjectSelection packageSel : packages) {
            List packageBodiesList = this.getPackageBodiesList();
            PackageBodyOracle packageBody = ((PackageOracle)packageSel.getObject()).getBody();
            if (packageBody == null) continue;
            this.addContainerObject(packageSel, packageBody, packageBodiesList);
        }
    }

    protected void addTableProxyDetails(TableProxyOracle tableProxy, ModelIdObjectSelection selection) {
        List triggersList;
        if (tableProxy.getPrimaryKeys().size() > 0 || tableProxy.getUniqueKeys().size() > 0) {
            ModelIdObjectSelection itemSel = new ModelIdObjectSelection(CONSTRAINTS);
            Iterator it = tableProxy.getPrimaryKeys().iterator();
            while (it.hasNext()) {
                IndexProxy pkIndex = (IndexProxy)it.next();
                ModelIdObjectSelection isel = new ModelIdObjectSelection(pkIndex, true);
                isel.setName("(PK) " + pkIndex.getName());
                itemSel.addChild(isel);
                this.getConstraintList().add(isel);
            }
            it = tableProxy.getUniqueKeys().iterator();
            while (it.hasNext()) {
                IndexProxy unIndex = (IndexProxy)it.next();
                ModelIdObjectSelection usel = new ModelIdObjectSelection(unIndex, true);
                itemSel.addChild(usel);
                this.getConstraintList().add(usel);
            }
            selection.addChild(itemSel);
        }
        if (tableProxy.getIndexes().size() > 0) {
            this.addContainerObjects(INDEXES, selection, tableProxy.getIndexes().getElementsList(), this.getIndexList());
        }
        if (tableProxy.getFKeys().size() > 0) {
            this.addContainerObjects(FOREIGN_KEYS, selection, tableProxy.getFKeys().getElementsList(), this.getFkList());
        }
        if ((triggersList = this.getTriggersForTable(this.getStorageDesign(), tableProxy)).size() > 0) {
            this.addContainerObjects(TRIGGERS, selection, triggersList, this.getTriggerList());
        }
    }

    protected List<ModelIdObjectSelection> addContainerObjects(String nodeName, ModelIdObjectSelection parent, List list, List listToAdd) {
        ModelIdObjectSelection node = new ModelIdObjectSelection(nodeName);
        List<ModelIdObjectSelection> addedObjects = this.addContainerObjects(node, list);
        if (addedObjects.size() > 0) {
            this.putNodeIcon(node, nodeName);
            parent.addChild(node);
            listToAdd.addAll(addedObjects);
        }
        return addedObjects;
    }

    protected void addSnapshots(ModelIdObjectSelection parent, List list, List listToAdd) {
        ModelIdObjectSelection node = new ModelIdObjectSelection(SNAPSHOTS);
        ArrayList<ModelIdObjectSelection> addedObjects = new ArrayList<ModelIdObjectSelection>();
        if (list != null && list.size() > 0) {
            for (SnapshotOracle snapshot : list) {
                ModelIdObjectSelection snapshotSel = new ModelIdObjectSelection(snapshot, true);
                addedObjects.add(snapshotSel);
                TableProxyOracle table = snapshot.getImplementedTable();
                if (table != null) {
                    this.addTableProxyDetails(table, snapshotSel);
                }
                node.addChild(snapshotSel);
            }
            this.putNodeIcon(node, SNAPSHOTS);
            parent.addChild(node);
            listToAdd.addAll(addedObjects);
        }
    }

    protected List<ModelIdObjectSelection> addContainerObjects(ModelIdObjectSelection parent, List objectsList) {
        ArrayList<ModelIdObjectSelection> addedObjects = new ArrayList<ModelIdObjectSelection>();
        Iterator it = objectsList.iterator();
        while (it.hasNext()) {
            this.addContainerObject(parent, (ModelIDObject)it.next(), addedObjects);
        }
        return addedObjects;
    }

    protected void addContainerObject(ModelIdObjectSelection parent, ModelIDObject object, List<ModelIdObjectSelection> addedObjects) {
        ModelIdObjectSelection isel = new ModelIdObjectSelection(object);
        parent.addChild(isel);
        addedObjects.add(isel);
    }

    protected void addViewProxyDetails(TableViewProxy viewProxy, ModelIdObjectSelection parent) {
        List list = this.getTriggersForView(this.getStorageDesign(), viewProxy);
        if (list.size() > 0) {
            this.addContainerObjects(TRIGGERS, parent, list, this.getTriggerList());
        }
    }

    protected void addUserDetails(UserOracle user, ModelIdObjectSelection parent) {
        List<PlSqlSourceStorageObjectOracle> list = this.getClustersForUser(user);
        if (list.size() > 0) {
            this.addContainerObjects(CLUSTERS, parent, list, this.getClusterList());
        }
        if ((list = this.getDimensionsForUser(user)).size() > 0) {
            this.addContainerObjects(DIMENSIONS, parent, list, this.getDimensionList());
        }
        if ((list = this.getSequencesForUser(user)).size() > 0) {
            this.addContainerObjects(SEQUENCES, parent, list, this.getSequenceList());
        }
        if ((list = this.getSnapshotsForUser(user)).size() > 0) {
            this.addSnapshots(parent, list, this.getSnapshotList());
        }
        if ((list = this.getPackagesForUser(user)).size() > 0) {
            this.addContainerObjects(PACKAGES, parent, list, this.getPackagesList());
        }
        if ((list = this.getPackageBodiesForUser(user)).size() > 0) {
            this.addContainerObjects(PACKAGE_BODIES, parent, list, this.getPackageBodiesList());
        }
        if ((list = this.getProcForUser(user)).size() > 0) {
            this.addContainerObjects(STORED_PROCEDURES, parent, list, this.getStoredProceduresList());
        }
        if ((list = this.getFunctionsForUser(user)).size() > 0) {
            this.addContainerObjects(FUNCTIONS, parent, list, this.getFunctionsList());
        }
        if ((list = this.getSynonymsForUser(user)).size() > 0) {
            this.addContainerObjects(SYNONYMS, parent, list, this.getSynonymList());
        }
        if ((list = this.getStrTypeForUser(user)).size() > 0) {
            this.addStructuredTypes(STRUCTURED_TYPES, parent, list, this.getTypeList());
        }
        if ((list = this.getTableForUser(user)).size() > 0) {
            this.addTables(TABLES, parent, list);
        }
        if ((list = this.getViewForUser(user)).size() > 0) {
            this.addViews(VIEWS, parent, list);
        }
        parent.sort();
    }

    private List getClustersForUser(UserOracle user) {
        ArrayList<ClusterOracle> list = new ArrayList<ClusterOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getClusterSet().iterator();
        while (it.hasNext()) {
            ClusterOracle cluster = (ClusterOracle)it.next();
            if (cluster.getUser() == null || !cluster.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(cluster);
        }
        return list;
    }

    private List getClustersWithoutUser() {
        ArrayList<ClusterOracle> list = new ArrayList<ClusterOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getClusterSet().iterator();
        while (it.hasNext()) {
            ClusterOracle cluster = (ClusterOracle)it.next();
            if (cluster.getUser() != null) continue;
            list.add(cluster);
        }
        return list;
    }

    private List getDimensionsForUser(UserOracle user) {
        ArrayList<DimensionOracle> list = new ArrayList<DimensionOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getDimensionSet().iterator();
        while (it.hasNext()) {
            DimensionOracle dim = (DimensionOracle)it.next();
            if (dim.getUser() == null || !dim.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(dim);
        }
        return list;
    }

    private List getDimensionsWithoutUser() {
        ArrayList<DimensionOracle> list = new ArrayList<DimensionOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getDimensionSet().iterator();
        while (it.hasNext()) {
            DimensionOracle dim = (DimensionOracle)it.next();
            if (dim.getUser() != null) continue;
            list.add(dim);
        }
        return list;
    }

    private List getSequencesForUser(UserOracle user) {
        ArrayList<SequenceOracle> list = new ArrayList<SequenceOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getSequenceSet().iterator();
        while (it.hasNext()) {
            SequenceOracle sequence = (SequenceOracle)it.next();
            if (sequence.getUser() == null || !sequence.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(sequence);
        }
        return list;
    }

    private List getSequencesWithoutUser() {
        ArrayList<SequenceOracle> list = new ArrayList<SequenceOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getSequenceSet().iterator();
        while (it.hasNext()) {
            SequenceOracle sequence = (SequenceOracle)it.next();
            if (sequence.getUser() != null) continue;
            list.add(sequence);
        }
        return list;
    }

    private List getSnapshotsForUser(UserOracle user) {
        ArrayList<SnapshotOracle> list = new ArrayList<SnapshotOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getSnapshotSet().iterator();
        while (it.hasNext()) {
            TableProxyOracle table;
            SnapshotOracle snapshot = (SnapshotOracle)it.next();
            if (snapshot.getUser() != null && snapshot.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(snapshot);
                continue;
            }
            if (snapshot.getUser() != null || (table = snapshot.getImplementedTable()) == null) continue;
            if (table.getUser() == user) {
                list.add(snapshot);
                continue;
            }
            if (table.getSchemaImplementationName().compareTo(user.getName()) != 0) continue;
            list.add(snapshot);
        }
        return list;
    }

    private List getSnapshotsWithoutUser() {
        ArrayList<SnapshotOracle> list = new ArrayList<SnapshotOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getSnapshotSet().iterator();
        while (it.hasNext()) {
            SnapshotOracle snapshot = (SnapshotOracle)it.next();
            if (snapshot.getUser() != null) continue;
            TableProxyOracle table = snapshot.getImplementedTable();
            if (table != null) {
                if (table.getUser() != null) continue;
                if (table.getSchemaImplementationName() == null) {
                    list.add(snapshot);
                    continue;
                }
                if (table.getSchemaImplementationName().compareTo("") != 0) continue;
                list.add(snapshot);
                continue;
            }
            list.add(snapshot);
        }
        return list;
    }

    private List<PackageOracle> getPackagesForUser(UserOracle user) {
        ArrayList<PackageOracle> list = new ArrayList<PackageOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getPackageSet().iterator();
        while (it.hasNext()) {
            PackageOracle packageOracle = (PackageOracle)it.next();
            UserOracle packageOwner = packageOracle.getOwner();
            if (packageOwner == null || !packageOwner.getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(packageOracle);
        }
        return list;
    }

    private List<PackageOracle> getPackagesWithoutUser() {
        ArrayList<PackageOracle> list = new ArrayList<PackageOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getPackageSet().iterator();
        while (it.hasNext()) {
            PackageOracle packageOracle = (PackageOracle)it.next();
            if (packageOracle.getOwner() != null) continue;
            list.add(packageOracle);
        }
        return list;
    }

    private List getProcForUser(UserOracle user) {
        ArrayList<StoredProcedureOracle> list = new ArrayList<StoredProcedureOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureOracle stProc = (StoredProcedureOracle)it.next();
            if (stProc.getOwner() == null || !stProc.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(stProc);
        }
        return list;
    }

    private List getProcWithoutUser() {
        ArrayList<StoredProcedureOracle> list = new ArrayList<StoredProcedureOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureOracle stProc = (StoredProcedureOracle)it.next();
            if (stProc.getOwner() != null) continue;
            list.add(stProc);
        }
        return list;
    }

    private List<FunctionOracle> getFunctionsForUser(UserOracle user) {
        ArrayList<FunctionOracle> list = new ArrayList<FunctionOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getFunctionSet().iterator();
        while (it.hasNext()) {
            FunctionOracle functionOracle = (FunctionOracle)it.next();
            UserOracle owner = functionOracle.getOwner();
            if (owner == null || !owner.getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(functionOracle);
        }
        return list;
    }

    private List<FunctionOracle> getFunctionsWithoutUser() {
        ArrayList<FunctionOracle> list = new ArrayList<FunctionOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getFunctionSet().iterator();
        while (it.hasNext()) {
            FunctionOracle functionOracle = (FunctionOracle)it.next();
            if (functionOracle.getOwner() != null) continue;
            list.add(functionOracle);
        }
        return list;
    }

    private List<PackageBodyOracle> getPackageBodiesForUser(UserOracle user) {
        ArrayList<PackageBodyOracle> list = new ArrayList<PackageBodyOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getPackageSet().iterator();
        while (it.hasNext()) {
            PackageBodyOracle packageBody;
            PackageOracle packageOracle = (PackageOracle)it.next();
            UserOracle packageOwner = packageOracle.getOwner();
            if (packageOwner == null || !packageOwner.getObjectID().equalsIgnoreCase(user.getObjectID()) || (packageBody = packageOracle.getBody()) == null) continue;
            list.add(packageBody);
        }
        return list;
    }

    private List getSynonymsForUser(UserOracle user) {
        ArrayList<SynonymOracle> list = new ArrayList<SynonymOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getSynonymSet().iterator();
        while (it.hasNext()) {
            SynonymOracle synonym = (SynonymOracle)it.next();
            if (synonym.getUser() == null || !synonym.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(synonym);
        }
        return list;
    }

    private List getSynonymsWithoutUser() {
        ArrayList<SynonymOracle> list = new ArrayList<SynonymOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getSynonymSet().iterator();
        while (it.hasNext()) {
            SynonymOracle synonym = (SynonymOracle)it.next();
            if (synonym.getUser() != null) continue;
            list.add(synonym);
        }
        return list;
    }

    private List getStrTypeForUser(UserOracle user) {
        ArrayList<StructuredTypeProxyOracle> list = new ArrayList<StructuredTypeProxyOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getStructuredTypeProxySet().iterator();
        while (it.hasNext()) {
            StructuredTypeProxyOracle type = (StructuredTypeProxyOracle)it.next();
            if (type.getOwner() == null || !type.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(type);
        }
        return list;
    }

    private List getStrTypeWithoutUser() {
        ArrayList<StructuredTypeProxyOracle> list = new ArrayList<StructuredTypeProxyOracle>();
        Iterator it = ((StorageDesignOracle)this.stdes).getStructuredTypeProxySet().iterator();
        while (it.hasNext()) {
            StructuredTypeProxyOracle type = (StructuredTypeProxyOracle)it.next();
            if (type.getOwner() != null) continue;
            list.add(type);
        }
        return list;
    }

    private List getTableForUser(UserOracle user) {
        ArrayList<TableProxyOracle> list = new ArrayList<TableProxyOracle>();
        Iterator it = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableProxySet().iterator();
        while (it.hasNext()) {
            Table table;
            TableProxyOracle proxy = (TableProxyOracle)it.next();
            if (proxy.getUser() != null && proxy.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                if (proxy.getSnapshot() != null) continue;
                list.add(proxy);
                continue;
            }
            if (proxy.getUser() != null || (table = (Table)proxy.getObject()).getSchemaObject() == null || table.getSchemaObject() != user.getSchemaObject() || proxy.getSnapshot() != null) continue;
            list.add(proxy);
        }
        return list;
    }

    private List getTableWithoutUser() {
        ArrayList<TableProxyOracle> list = new ArrayList<TableProxyOracle>();
        Iterator it = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableProxySet().iterator();
        while (it.hasNext()) {
            Table table;
            TableProxyOracle proxy = (TableProxyOracle)it.next();
            if (proxy.getUser() != null || (table = (Table)proxy.getObject()).getSchemaObject() != null && proxy.getStorageDesign().getUserSchemaSet().getBySchemaObject(table.getSchemaObject()) != null || proxy.getSnapshot() != null) continue;
            list.add(proxy);
        }
        return list;
    }

    private List getViewForUser(UserOracle user) {
        ArrayList<TableViewProxyOracle> list = new ArrayList<TableViewProxyOracle>();
        Iterator it = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableViewProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableView tableView;
            TableViewProxyOracle view = (TableViewProxyOracle)it.next();
            if (view.getUser() != null && view.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(view);
                continue;
            }
            if (view.getUser() != null || (tableView = (TableView)view.getObject()).getSchemaObject() == null || tableView.getSchemaObject() != user.getSchemaObject()) continue;
            list.add(view);
        }
        return list;
    }

    private List getViewWithoutUser() {
        ArrayList<TableViewProxyOracle> list = new ArrayList<TableViewProxyOracle>();
        Iterator it = this.selectedSubView != null ? ((StorageDesignOracle)this.stdes).getSubViewTableViewProxySet().iterator() : ((StorageDesignOracle)this.stdes).getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableView table;
            TableViewProxyOracle proxy = (TableViewProxyOracle)it.next();
            if (proxy.getUser() != null || (table = (TableView)proxy.getObject()).getSchemaObject() != null && proxy.getStorageDesign().getUserSchemaSet().getBySchemaObject(table.getSchemaObject()) != null) continue;
            list.add(proxy);
        }
        return list;
    }

    public List getTriggerList() {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        return this.triggerList;
    }

    public List getClusterList() {
        if (this.clusterList == null) {
            this.clusterList = new ArrayList();
        }
        return this.clusterList;
    }

    public List getDimensionList() {
        if (this.dimensionList == null) {
            this.dimensionList = new ArrayList();
        }
        return this.dimensionList;
    }

    public List getSequenceList() {
        if (this.sequenceList == null) {
            this.sequenceList = new ArrayList();
        }
        return this.sequenceList;
    }

    public List getSnapshotList() {
        if (this.snapshotList == null) {
            this.snapshotList = new ArrayList();
        }
        return this.snapshotList;
    }

    public List getPackagesList() {
        if (this.packagesList == null) {
            this.packagesList = new ArrayList();
        }
        return this.packagesList;
    }

    public List getPackageBodiesList() {
        if (this.packageBodiesList == null) {
            this.packageBodiesList = new ArrayList();
        }
        return this.packageBodiesList;
    }

    public List getStoredProceduresList() {
        if (this.storedProceduresList == null) {
            this.storedProceduresList = new ArrayList();
        }
        return this.storedProceduresList;
    }

    public List getFunctionsList() {
        if (this.functionsList == null) {
            this.functionsList = new ArrayList();
        }
        return this.functionsList;
    }

    public List getSynonymList() {
        if (this.synonymList == null) {
            this.synonymList = new ArrayList();
        }
        return this.synonymList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        return this.typeList;
    }

    protected StorageDesignOracle getStorageDesign() {
        return (StorageDesignOracle)this.stdes;
    }

    private List getTriggersForTable(StorageDesignOracle strdes, TableProxy table) {
        ArrayList<TriggerOracle> list = new ArrayList<TriggerOracle>();
        if (strdes.getTriggerSet().size() > 0) {
            Iterator it = strdes.getTriggerSet().iterator();
            while (it.hasNext()) {
                TriggerOracle trigger = (TriggerOracle)it.next();
                if (trigger.getTable() == null || !trigger.getTable().equals(table)) continue;
                list.add(trigger);
            }
        }
        return list;
    }

    private List getTriggersForView(StorageDesignOracle strdes, TableViewProxy view) {
        ArrayList<TriggerOracle> list = new ArrayList<TriggerOracle>();
        if (strdes.getTriggerSet().size() > 0) {
            Iterator it = strdes.getTriggerSet().iterator();
            while (it.hasNext()) {
                TriggerOracle trigger = (TriggerOracle)it.next();
                if (trigger.getView() == null || !trigger.getView().equals(view)) continue;
                list.add(trigger);
            }
        }
        return list;
    }

    private void addSpecificObjectsFromRelationalModel() {
        Iterator it = ((StorageDesignOracle)this.stdes).getStructuredTypeProxySet().iterator();
        ModelIdObjectSelection strTypeSel = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.StructuredTypes"));
        strTypeSel.setElementDescriptor(StructuredTypeProxyOracle.class);
        while (it.hasNext()) {
            StructuredTypeProxyOracle strType = (StructuredTypeProxyOracle)it.next();
            if (((StructuredType)strType.getObject()).isPredefined()) continue;
            ModelIdObjectSelection sel = new ModelIdObjectSelection(strType);
            strTypeSel.addChild(sel);
        }
        this.addChild(strTypeSel);
        if (this.stdes instanceof StorageDesignOraclev9i || this.stdes instanceof StorageDesignOraclev10g) {
            it = ((StorageDesignOracle)this.stdes).getCollectionTypeProxySet().iterator();
            ModelIdObjectSelection collTypeSel = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.CollectionTypes"));
            collTypeSel.setElementDescriptor(StructuredTypeProxyOracle.class);
            while (it.hasNext()) {
                CollectionTypeProxyOracle collType = (CollectionTypeProxyOracle)it.next();
                ModelIdObjectSelection sel = new ModelIdObjectSelection(collType);
                collTypeSel.addChild(sel);
            }
            this.addChild(collTypeSel);
        }
    }

    public void setSelectedSubView(DesignPartView selectedSubView) {
        this.selectedSubView = selectedSubView;
    }

    private void addTableDetails(Table table, ModelIdObjectSelection parent) {
        FKIndexAssociation[] fkeys;
        ModelIdObjectSelection isel;
        ModelIdObjectSelection sel;
        if (table.getPKandUKConstraints().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.PKUKConstraints"));
            for (KeyObject key : table.getPKandUKConstraints()) {
                ModelIdObjectSelection isel2 = new ModelIdObjectSelection(key);
                if (key.isPK()) {
                    isel2.setName("(PK) " + key.getName());
                }
                sel.addChild(isel2);
                this.getConstraintList().add(isel2);
            }
            parent.addChild(sel);
        }
        if (table.getIndexes().size() > 0) {
            sel = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.Indexes"));
            Iterator it = table.getIndexes().iterator();
            while (it.hasNext()) {
                ContainerObjectPlaceHolder ph = (ContainerObjectPlaceHolder)it.next();
                Index ind = (Index)ph.getDesignObject();
                isel = new ModelIdObjectSelection(ind);
                sel.addChild(isel);
                this.getIndexList().add(isel);
            }
            parent.addChild(sel);
        }
        if ((fkeys = table.getFKAssociations()).length > 0) {
            ModelIdObjectSelection sel2 = new ModelIdObjectSelection(Messages.getString("DDLSelectionOraclev8i.ForeignKeys"));
            for (int i = 0; i < fkeys.length; ++i) {
                FKIndexAssociation fk = fkeys[i];
                isel = new ModelIdObjectSelection(fk);
                sel2.addChild(isel);
                this.getFkList().add(isel);
            }
            parent.addChild(sel2);
        }
    }

    public List getBjList() {
        if (this.bjList == null) {
            this.bjList = new ArrayList();
        }
        return this.bjList;
    }

    public List getExtTableList() {
        if (this.extTableList == null) {
            this.extTableList = new ArrayList();
        }
        return this.extTableList;
    }

    public List getCollTypeList() {
        if (this.collTypeList == null) {
            this.collTypeList = new ArrayList();
        }
        return this.collTypeList;
    }

    private void putNodeIcon(ModelIdObjectSelection node, String nodeName) {
        DDLTreeNodeName _nodeName = DDLTreeNodeName.fromString(nodeName);
        if (_nodeName != null) {
            switch (DDLTreeNodeName.fromString(nodeName)) {
                case NN_CONTEXTS: {
                    node.setElementDescriptor(ContextOraclev9i.class);
                    break;
                }
                case NN_ROLES: {
                    node.setElementDescriptor(RoleSet.class);
                    break;
                }
                case NN_ROLLBACK_SEGMENTS: {
                    node.setElementDescriptor(SegmentOraclev9i.class);
                    break;
                }
                case NN_TABLESPACES: 
                case NN_TEMP_TABLESPACES: {
                    node.setElementDescriptor(TableSpaceOraclev9i.class);
                    break;
                }
                case NN_SNAPSHOTS: {
                    node.setElementDescriptor(SnapshotSetOracle.class);
                    break;
                }
                case NN_FUNCTIONS: {
                    node.setElementDescriptor(FunctionSetOracle.class);
                    break;
                }
                case NN_CLUSTERS: {
                    node.setElementDescriptor(ClusterOraclev9i.class);
                    break;
                }
                case NN_DIMENSIONS: {
                    node.setElementDescriptor(Dimension.class);
                    break;
                }
                case NN_SEQUENCES: {
                    node.setElementDescriptor(SequenceSetOraclev10g.class);
                    break;
                }
                case NN_STORED_PROCEDURES: {
                    node.setElementDescriptor(StoredProcedureSetOraclev10g.class);
                    break;
                }
                case NN_SYNONYMS: {
                    node.setElementDescriptor(SynonymSetOraclev10g.class);
                    break;
                }
                case NN_PACKAGES: 
                case NN_PACKAGE_BODIES: {
                    node.setElementDescriptor(PackageSetOracle.class);
                    break;
                }
                case NN_INDEXES: {
                    node.setElementDescriptor(IndexSet.class);
                    break;
                }
                case NN_FOREIGN_KEYS: {
                    node.setElementDescriptor(FKIndexAssociationSet.class);
                    break;
                }
                case NN_TRIGGERS: {
                    node.setElementDescriptor(TriggerSetOraclev10g.class);
                    break;
                }
            }
        }
    }

    static /* synthetic */ String access$000() {
        return CONTEXTS;
    }

    static /* synthetic */ String access$100() {
        return DIRECTORIES;
    }

    static /* synthetic */ String access$200() {
        return ROLES;
    }

    static /* synthetic */ String access$300() {
        return ROLLBACK_SEGMENTS;
    }

    static /* synthetic */ String access$400() {
        return TABLESPACES;
    }

    static /* synthetic */ String access$500() {
        return TEMP_TABLESPACES;
    }

    static /* synthetic */ String access$600() {
        return SNAPSHOTS;
    }

    static /* synthetic */ String access$700() {
        return FUNCTIONS;
    }

    static /* synthetic */ String access$800() {
        return CLUSTERS;
    }

    static /* synthetic */ String access$900() {
        return DIMENSIONS;
    }

    static /* synthetic */ String access$1000() {
        return SEQUENCES;
    }

    static /* synthetic */ String access$1100() {
        return STORED_PROCEDURES;
    }

    static /* synthetic */ String access$1200() {
        return SYNONYMS;
    }

    static /* synthetic */ String access$1300() {
        return PACKAGES;
    }

    static /* synthetic */ String access$1400() {
        return INDEXES;
    }

    static /* synthetic */ String access$1500() {
        return FOREIGN_KEYS;
    }

    static /* synthetic */ String access$1600() {
        return TRIGGERS;
    }

    static /* synthetic */ String access$1700() {
        return PACKAGE_BODIES;
    }

    private static enum DDLTreeNodeName {
        NN_CONTEXTS(DDLSelectionOraclev8i.access$000()),
        NN_DIRECTORIES(DDLSelectionOraclev8i.access$100()),
        NN_ROLES(DDLSelectionOraclev8i.access$200()),
        NN_ROLLBACK_SEGMENTS(DDLSelectionOraclev8i.access$300()),
        NN_TABLESPACES(DDLSelectionOraclev8i.access$400()),
        NN_TEMP_TABLESPACES(DDLSelectionOraclev8i.access$500()),
        NN_SNAPSHOTS(DDLSelectionOraclev8i.access$600()),
        NN_FUNCTIONS(DDLSelectionOraclev8i.access$700()),
        NN_CLUSTERS(DDLSelectionOraclev8i.access$800()),
        NN_DIMENSIONS(DDLSelectionOraclev8i.access$900()),
        NN_SEQUENCES(DDLSelectionOraclev8i.access$1000()),
        NN_STORED_PROCEDURES(DDLSelectionOraclev8i.access$1100()),
        NN_SYNONYMS(DDLSelectionOraclev8i.access$1200()),
        NN_PACKAGES(DDLSelectionOraclev8i.access$1300()),
        NN_INDEXES(DDLSelectionOraclev8i.access$1400()),
        NN_FOREIGN_KEYS(DDLSelectionOraclev8i.access$1500()),
        NN_TRIGGERS(DDLSelectionOraclev8i.access$1600()),
        NN_PACKAGE_BODIES(DDLSelectionOraclev8i.access$1700());

        private String name;

        private DDLTreeNodeName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DDLTreeNodeName fromString(String text) {
            if (text != null) {
                for (DDLTreeNodeName n : DDLTreeNodeName.values()) {
                    if (!text.equals(n.name)) continue;
                    return n;
                }
            }
            return null;
        }
    }
}

