/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionOraclev8i;

public class DDLSelectionOraclev9i
extends DDLSelectionOraclev8i {
    private static final String UNDO_TABLESPACES = Messages.getString("DDLSelectionOraclev9i.UndoTablespaces");
    private static final String BJINDEXES = Messages.getString("DDLSelectionOraclev9i.BitmapJoinIndexes");
    private static final String EXTERNAL_TABLES = Messages.getString("DDLSelectionOraclev9i.ExternalTables");
    private static final String COLLECTION_TYPES = Messages.getString("DDLSelectionOraclev9i.CollectionTypes");
    private List extTableList;
    private List collTypeList;
    private List bjList;

    public DDLSelectionOraclev9i(StorageDesign design) {
        super(design);
    }

    public DDLSelectionOraclev9i(StorageDesign design, DesignPartView selectedSubView) {
        super(design, selectedSubView);
    }

    @Override
    protected void addFromStorageDesign() {
        super.addFromStorageDesign();
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            this.addObjects(UNDO_TABLESPACES, this, ((StorageDesignOraclev9i)this.getStorageDesign()).getUndoTablespaceSet().getElementsList());
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            this.addObjects(UNDO_TABLESPACES, this, ((StorageDesignOraclev10g)this.getStorageDesign()).getUndoTablespaceSet().getElementsList());
        }
        this.sort();
    }

    @Override
    protected void addObjectsNotAssignedToUsers(String nodeName, ModelIdObjectSelection root) {
        super.addObjectsNotAssignedToUsers(nodeName, root);
        for (ModelIdObjectSelection modelSel : root.getChilds()) {
            if (!modelSel.getName().equalsIgnoreCase(nodeName)) continue;
            this.addContainerObjects(COLLECTION_TYPES, modelSel, this.getCollTypeWithoutUser(), this.getCollTypeList());
            this.addContainerObjects(EXTERNAL_TABLES, modelSel, this.getExtTablesWithoutUser(), this.getExtTableList());
            modelSel.sort();
        }
    }

    @Override
    protected void addUserDetails(UserOracle user, ModelIdObjectSelection parent) {
        super.addUserDetails(user, parent);
        List list = this.getExtTablesForUser(user);
        if (list.size() > 0) {
            this.addContainerObjects(EXTERNAL_TABLES, parent, list, this.getExtTableList());
            parent.sort();
        }
        if ((list = this.getCollTypeForUser(user)).size() > 0) {
            this.addContainerObjects(COLLECTION_TYPES, parent, list, this.getCollTypeList());
            parent.sort();
        }
    }

    @Override
    protected void addTableProxyDetails(TableProxyOracle tableProxy, ModelIdObjectSelection selection) {
        super.addTableProxyDetails(tableProxy, selection);
        StorageObjectCollection bjs = null;
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            bjs = ((TableProxyOraclev9i)tableProxy).getBjIndexes();
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            bjs = ((TableProxyOraclev10g)tableProxy).getBjIndexes();
        }
        if (bjs != null && bjs.size() > 0) {
            this.addContainerObjects(BJINDEXES, selection, bjs.getElementsList(), this.getBjList());
        }
    }

    @Override
    public List getExtTableList() {
        if (this.extTableList == null) {
            this.extTableList = new ArrayList();
        }
        return this.extTableList;
    }

    @Override
    public List getCollTypeList() {
        if (this.collTypeList == null) {
            this.collTypeList = new ArrayList();
        }
        return this.collTypeList;
    }

    private List getExtTablesWithoutUser() {
        ArrayList<ExternalTableOracle> list = new ArrayList<ExternalTableOracle>();
        List tableList = new ArrayList();
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            tableList = ((StorageDesignOraclev9i)this.getStorageDesign()).getExternalTableSet().getElementsList();
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            tableList = ((StorageDesignOraclev10g)this.getStorageDesign()).getExternalTableSet().getElementsList();
        }
        if (tableList.size() > 0) {
            for (ExternalTableOracle extTable : tableList) {
                if (extTable.getOwner() != null) continue;
                list.add(extTable);
            }
        }
        return list;
    }

    private List getExtTablesForUser(UserOracle user) {
        ArrayList<ExternalTableOracle> list = new ArrayList<ExternalTableOracle>();
        List tableList = new ArrayList();
        if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
            tableList = ((StorageDesignOraclev9i)this.getStorageDesign()).getExternalTableSet().getElementsList();
        } else if (this.getStorageDesign() instanceof StorageDesignOraclev10g) {
            tableList = ((StorageDesignOraclev10g)this.getStorageDesign()).getExternalTableSet().getElementsList();
        }
        if (tableList.size() > 0) {
            for (ExternalTableOracle extTable : tableList) {
                if (extTable.getOwner() == null || !extTable.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
                list.add(extTable);
            }
        }
        return list;
    }

    private List getCollTypeWithoutUser() {
        ArrayList<CollectionTypeProxyOracle> list = new ArrayList<CollectionTypeProxyOracle>();
        Iterator it = this.getStorageDesign().getCollectionTypeProxySet().iterator();
        while (it.hasNext()) {
            CollectionTypeProxyOracle type = (CollectionTypeProxyOracle)it.next();
            if (type.getOwner() != null) continue;
            list.add(type);
        }
        return list;
    }

    private List getCollTypeForUser(UserOracle user) {
        ArrayList<CollectionTypeProxyOracle> list = new ArrayList<CollectionTypeProxyOracle>();
        Iterator it = this.getStorageDesign().getCollectionTypeProxySet().iterator();
        while (it.hasNext()) {
            CollectionTypeProxyOracle type = (CollectionTypeProxyOracle)it.next();
            if (type.getOwner() == null || !type.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(type);
        }
        return list;
    }

    @Override
    public List getBjList() {
        if (this.bjList == null) {
            this.bjList = new ArrayList();
        }
        return this.bjList;
    }
}

