/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.process.RoleSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RuleSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DefaultSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionSqlServerv2k
extends ModelIdObjectSelection
implements DDLSelectionLists {
    protected static final String ASSIGNED_TO_DATABASE = Messages.getString("DDLSelectionSqlServerv2k.AssignedToDatabase");
    protected static final String NOT_ASSIGNED_TO_DATABASE = Messages.getString("DDLSelectionSqlServerv2k.NotAssignedToDatabase");
    protected static final String TABLES = Messages.getString("DDLSelectionSqlServerv2k.Tables");
    protected static final String VIEWS = Messages.getString("DDLSelectionSqlServerv2k.Views");
    protected static final String LOGINS = Messages.getString("DDLSelectionSqlServerv2k.Logins");
    private static final String USER_DEFINED_TYPES = Messages.getString("DDLSelectionSqlServerv2k.UserDefinedTypes");
    protected static final String DEFAULTS = Messages.getString("DDLSelectionSqlServerv2k.Defaults");
    protected static final String STORED_PROCEDURES = Messages.getString("DDLSelectionSqlServerv2k.StoredProcedures");
    protected static final String RULES = Messages.getString("DDLSelectionSqlServerv2k.Rules");
    private static final String CONSTRAINTS = Messages.getString("DDLSelectionSqlServerv2k.PKUKConstraints");
    private static final String INDEXES = Messages.getString("DDLSelectionSqlServerv2k.Indexes");
    private static final String FOREIGN_KEYS = Messages.getString("DDLSelectionSqlServerv2k.ForeignKeys");
    private static final String TRIGGERS = Messages.getString("DDLSelectionSqlServerv2k.Triggers");
    private static final String ASSIGNED_TO_USER = Messages.getString("DDLSelectionSqlServerv2k.AssignedToUser");
    private static final String NOT_ASSIGNED_TO_USER = Messages.getString("DDLSelectionSqlServerv2k.NotAssignedToUser");
    protected static final String ROLES = Messages.getString("DDLSelectionSqlServerv2k.Roles");
    private StorageDesign storageDesign;
    private List constraintList;
    private List fkList;
    private List indexList;
    private List tableList;
    private List viewList;
    private List databaseList;
    private List triggerList;
    private List userList;
    private List defaultList;
    private List roleList;
    private List ruleList;
    private List procedureList;
    private List typeList;
    private List schemaList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionSqlServerv2k(StorageDesign design) {
        super(design.getName());
        this.storageDesign = design;
        if (this.storageDesign.isOpen()) {
            this.setElementDescriptor(design.getClass());
            this.addFromStorageDesign();
        }
    }

    public DDLSelectionSqlServerv2k(StorageDesign design, DesignPartView selectedSubView) {
        super(design.getName());
        this.storageDesign = design;
        this.selectedSubView = selectedSubView;
        if (this.storageDesign.isOpen()) {
            this.setElementDescriptor(design.getClass());
            this.addFromStorageDesign();
        }
    }

    protected void addFromStorageDesign() {
        this.setElementDescriptor(DataBaseSqlServer.class);
        this.addAssignedToDatabase(ASSIGNED_TO_DATABASE, this);
        this.addLogins(LOGINS, this, this.getStorageDesign().getLoginSet().getElementsList());
    }

    private void addAssignedToDatabase(String nodeName, ModelIdObjectSelection parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(DataBaseSqlServer.class);
        Iterator it = this.getStorageDesign().getDataBaseSet().iterator();
        while (it.hasNext()) {
            DataBaseSqlServer db = (DataBaseSqlServer)it.next();
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(db);
            ModelIdObjectSelection strSel = new ModelIdObjectSelection(db.getName());
            if (this.getUsersForDatabase(db).size() > 0) {
                this.addAssignedToUser(ASSIGNED_TO_USER, strSel, this.getUsersForDatabase(db));
            }
            this.addNotAssignedToUser(NOT_ASSIGNED_TO_USER, strSel, db);
            this.getDatabaseList().add(objSel);
            selection.addChild(strSel);
        }
        parent.addChild(selection);
    }

    private void addAssignedToUser(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        for (UserSqlServer user : list) {
            ModelIdObjectSelection strSel = new ModelIdObjectSelection(user.getName());
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(user);
            this.addUserDetails(user, strSel);
            this.getUserList().add(objSel);
            selection.addChild(strSel);
        }
        parent.addChild(selection);
    }

    private void addNotAssignedToUser(String nodeName, ModelIdObjectSelection parent, DataBaseSqlServer db) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(SchemaSetUDB.class);
        parent.addChild(selection);
        this.addAllWithNullUser(selection, db);
    }

    protected void addNotAssignedToDatabase(String nodeName, ModelIdObjectSelection parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        Iterator it = this.getStorageDesign().getDataBaseSet().iterator();
        while (it.hasNext()) {
            DataBaseSqlServer database = (DataBaseSqlServer)it.next();
            if (!database.isNullInstance()) continue;
            if (this.getUsersWithNullDatabase().size() > 0) {
                this.addUsersWithNullDatabase(ASSIGNED_TO_USER, selection, this.getUsersWithNullDatabase());
            }
            this.addNotAssignedToUser(NOT_ASSIGNED_TO_USER, selection, database);
        }
        parent.addChild(selection);
    }

    private void addAllWithNullUser(ModelIdObjectSelection parent, DataBaseSqlServer db) {
        this.addTables(TABLES, parent, this.getTablesWithNullUser(db));
        this.addViews(VIEWS, parent, this.getViewsWithNullUser(db));
        this.addContainerObjects(USER_DEFINED_TYPES, parent, this.getUserTypesWithNullUser(db), this.getTypeList());
        this.addContainerObjects(DEFAULTS, parent, this.getDefaultsWithNullUser(db), this.getDefaultList());
        this.addContainerObjects(STORED_PROCEDURES, parent, this.getProceduresWithNullUser(db), this.getProcedureList());
        this.addContainerObjects(RULES, parent, this.getRulesWithNullUser(db), this.getRuleList());
        this.addContainerObjects(ROLES, parent, this.getRolesWithNullUser(db), this.getRoleList());
        this.sort();
    }

    private void addUsersWithNullDatabase(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        for (UserSqlServer user : list) {
            ModelIdObjectSelection strSel = new ModelIdObjectSelection(user.getName());
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(user);
            this.addUserDetails(user, strSel);
            this.getUserList().add(objSel);
            selection.addChild(strSel);
        }
        parent.addChild(selection);
    }

    protected void addLogins(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(LoginSqlServer.class);
        Iterator it = list.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                LoginSqlServer login = (LoginSqlServer)it.next();
                if (login.isNullInstance()) continue;
                ModelIdObjectSelection isel = new ModelIdObjectSelection(login);
                selection.addChild(isel);
            }
            if (selection.getChilds().size() > 0) {
                parent.addChild(selection);
            }
        }
    }

    protected void addUserDetails(UserSqlServer user, ModelIdObjectSelection parent) {
        this.addTables(TABLES, parent, this.getTablesForUser(user));
        this.addViews(VIEWS, parent, this.getViewsForUser(user));
        this.addContainerObjects(USER_DEFINED_TYPES, parent, this.getUserTypesForUser(user), this.getTypeList());
        this.addContainerObjects(DEFAULTS, parent, this.getDefaultsForUser(user), this.getDefaultList());
        this.addContainerObjects(STORED_PROCEDURES, parent, this.getProceduresForUser(user), this.getProcedureList());
        this.addContainerObjects(RULES, parent, this.getRulesForUser(user), this.getRuleList());
        this.addContainerObjects(ROLES, parent, this.getRolesForUser(user), this.getRoleList());
        this.sort();
    }

    protected void addTables(String nodeName, ModelIdObjectSelection parent, List list) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
            selection.setElementDescriptor(TableSet.class);
            for (TableProxySqlServer tableProxy : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection(tableProxy);
                this.addTableProxyDetails(tableProxy, isel);
                this.getTableList().add(isel);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
    }

    protected void addTableProxyDetails(TableProxySqlServer table, ModelIdObjectSelection parent) {
        if (table.getPkeys().size() > 0 || table.getUkeys().size() > 0) {
            ModelIdObjectSelection isel;
            ModelIdObjectSelection selection = new ModelIdObjectSelection(CONSTRAINTS);
            selection.setElementDescriptor(PKProxySetSqlServer.class);
            Iterator it = table.getPkeys().iterator();
            while (it.hasNext()) {
                PKProxySqlServer pkProxy = (PKProxySqlServer)it.next();
                isel = new ModelIdObjectSelection(pkProxy);
                isel.setName("(PK) " + pkProxy.getName());
                this.getConstraintList().add(isel);
                selection.addChild(isel);
            }
            it = table.getUkeys().iterator();
            while (it.hasNext()) {
                UniqueProxySqlServer unique = (UniqueProxySqlServer)it.next();
                isel = new ModelIdObjectSelection(unique);
                this.getConstraintList().add(isel);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
        if (table.getIndexes().size() > 0) {
            this.addContainerObjects(INDEXES, parent, table.getIndexes().getElementsList(), this.getIndexList());
        }
        if (table.getFkeys().size() > 0) {
            this.addContainerObjects(FOREIGN_KEYS, parent, table.getFkeys().getElementsList(), this.getFkList());
        }
        if (table.getTriggers().size() > 0) {
            this.addContainerObjects(TRIGGERS, parent, table.getTriggers().getElementsList(), this.getTriggerList());
        }
    }

    protected void addViews(String nodeName, ModelIdObjectSelection parent, List list) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
            selection.setElementDescriptor(TableViewSet.class);
            for (TableViewProxySqlServer view : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection(view);
                this.addViewProxyDetails(view, isel);
                this.getViewList().add(isel);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
    }

    protected void addViewProxyDetails(TableViewProxySqlServer view, ModelIdObjectSelection parent) {
        if (view.getIndexesOnView().size() > 0) {
            this.addContainerObjects(INDEXES, parent, view.getIndexesOnView().getElementsList(), this.getIndexList());
        }
        if (view.getTriggers().size() > 0) {
            this.addContainerObjects(TRIGGERS, parent, view.getTriggers().getElementsList(), this.getTriggerList());
        }
    }

    protected void addContainerObjects(String nodeName, ModelIdObjectSelection parent, List list, List listToAdd) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
            this.putNodeIcon(selection, nodeName);
            for (ModelIDObject obj : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection(obj);
                isel.setElementDescriptor(obj.getClass());
                listToAdd.add(isel);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
    }

    private List getTablesWithNullUser(DataBaseSqlServer db) {
        ArrayList<TableProxySqlServer> list = new ArrayList<TableProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxySqlServer tableProxy = (TableProxySqlServer)it.next();
            if (tableProxy.getUser() != null || !db.equals(tableProxy.getDatabase())) continue;
            list.add(tableProxy);
        }
        return list;
    }

    private List getTablesForUser(UserSqlServer user) {
        ArrayList<TableProxySqlServer> list = new ArrayList<TableProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxySqlServer tableProxy = (TableProxySqlServer)it.next();
            if (tableProxy.getUser() != null && tableProxy.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(tableProxy);
                continue;
            }
            if (tableProxy.getUser() == null || !tableProxy.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(tableProxy);
        }
        return list;
    }

    private List getViewsWithNullUser(DataBaseSqlServer db) {
        ArrayList<TableViewProxySqlServer> list = new ArrayList<TableViewProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)it.next();
            if (view.getUser() != null || !db.equals(view.getDataBase())) continue;
            list.add(view);
        }
        return list;
    }

    private List getViewsForUser(UserSqlServer user) {
        ArrayList<TableViewProxySqlServer> list = new ArrayList<TableViewProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)it.next();
            if (view.getUser() != null && view.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(view);
                continue;
            }
            if (view.getUser() == null || !view.getUser().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(view);
        }
        return list;
    }

    private List getUserTypesWithNullUser(DataBaseSqlServer db) {
        ArrayList<UserDefinedTypeSqlServer> list = new ArrayList<UserDefinedTypeSqlServer>();
        Iterator it = this.getStorageDesign().getUserDefinedTypeSet().iterator();
        while (it.hasNext()) {
            UserDefinedTypeSqlServer type = (UserDefinedTypeSqlServer)it.next();
            if (type.getOwner() != null || !db.equals(type.getOwner())) continue;
            list.add(type);
        }
        return list;
    }

    private List getUserTypesForUser(UserSqlServer user) {
        ArrayList<UserDefinedTypeSqlServer> list = new ArrayList<UserDefinedTypeSqlServer>();
        Iterator it = this.getStorageDesign().getUserDefinedTypeSet().iterator();
        while (it.hasNext()) {
            UserDefinedTypeSqlServer type = (UserDefinedTypeSqlServer)it.next();
            if (type.getOwner() != null && type.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(type);
                continue;
            }
            if (type.getOwner() == null || !type.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(type);
        }
        return list;
    }

    private List getDefaultsWithNullUser(DataBaseSqlServer db) {
        ArrayList<DefaultSqlServer> list = new ArrayList<DefaultSqlServer>();
        Iterator it = this.getStorageDesign().getDefaultSet().iterator();
        while (it.hasNext()) {
            DefaultSqlServer def = (DefaultSqlServer)it.next();
            if (def.getOwner() != null || !db.equals(def.getOwner())) continue;
            list.add(def);
        }
        return list;
    }

    private List getDefaultsForUser(UserSqlServer user) {
        ArrayList<DefaultSqlServer> list = new ArrayList<DefaultSqlServer>();
        Iterator it = this.getStorageDesign().getDefaultSet().iterator();
        while (it.hasNext()) {
            DefaultSqlServer def = (DefaultSqlServer)it.next();
            if (def.getOwner() != null && def.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(def);
                continue;
            }
            if (def.getOwner() == null || !def.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(def);
        }
        return list;
    }

    private List getProceduresWithNullUser(DataBaseSqlServer db) {
        ArrayList<StoredProcedureSqlServer> list = new ArrayList<StoredProcedureSqlServer>();
        Iterator it = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureSqlServer proc = (StoredProcedureSqlServer)it.next();
            if (proc.getOwner() != null || !db.equals(proc.getOwner())) continue;
            list.add(proc);
        }
        return list;
    }

    private List getProceduresForUser(UserSqlServer user) {
        ArrayList<StoredProcedureSqlServer> list = new ArrayList<StoredProcedureSqlServer>();
        Iterator it = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureSqlServer proc = (StoredProcedureSqlServer)it.next();
            if (proc.getOwner() != null && proc.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(proc);
                continue;
            }
            if (proc.getOwner() == null || !proc.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(proc);
        }
        return list;
    }

    private List getRulesWithNullUser(DataBaseSqlServer db) {
        ArrayList<RuleSqlServer> list = new ArrayList<RuleSqlServer>();
        Iterator it = this.getStorageDesign().getRuleSet().iterator();
        while (it.hasNext()) {
            RuleSqlServer rule = (RuleSqlServer)it.next();
            if (rule.getOwner() != null || !db.equals(rule.getDatabase())) continue;
            list.add(rule);
        }
        return list;
    }

    private List getRulesForUser(UserSqlServer user) {
        ArrayList<RuleSqlServer> list = new ArrayList<RuleSqlServer>();
        Iterator it = this.getStorageDesign().getRuleSet().iterator();
        while (it.hasNext()) {
            RuleSqlServer rule = (RuleSqlServer)it.next();
            if (rule.getOwner() != null && rule.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) {
                list.add(rule);
                continue;
            }
            if (rule.getOwner() == null || !rule.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID())) continue;
            list.add(rule);
        }
        return list;
    }

    private List getUsersForDatabase(DataBaseSqlServer database) {
        ArrayList<UserSqlServer> list = new ArrayList<UserSqlServer>();
        Iterator it = this.getStorageDesign().getUserSet().iterator();
        while (it.hasNext()) {
            UserSqlServer user = (UserSqlServer)it.next();
            if (user.getDatabase() == null || !user.getDatabase().getObjectID().equalsIgnoreCase(database.getObjectID())) continue;
            list.add(user);
        }
        return list;
    }

    private List getUsersWithNullDatabase() {
        ArrayList<UserSqlServer> list = new ArrayList<UserSqlServer>();
        Iterator it = this.getStorageDesign().getUserSet().iterator();
        while (it.hasNext()) {
            UserSqlServer user = (UserSqlServer)it.next();
            if (!user.getDatabase().isNullInstance()) continue;
            list.add(user);
        }
        return list;
    }

    private List getRolesWithNullUser(DataBaseSqlServer db) {
        ArrayList<RoleSqlServer> list = new ArrayList<RoleSqlServer>();
        Iterator it = this.getStorageDesign().getRoleSet().iterator();
        while (it.hasNext()) {
            RoleSqlServer role = (RoleSqlServer)it.next();
            if (role.getOwner() != null || !db.equals(role.getDatabase()) || role.isNullInstance()) continue;
            list.add(role);
        }
        return list;
    }

    private List getRolesForUser(UserSqlServer user) {
        ArrayList<RoleSqlServer> list = new ArrayList<RoleSqlServer>();
        Iterator it = this.getStorageDesign().getRoleSet().iterator();
        while (it.hasNext()) {
            RoleSqlServer role = (RoleSqlServer)it.next();
            if (role.getOwner() == null || !role.getOwner().getObjectID().equalsIgnoreCase(user.getObjectID()) || role.isNullInstance()) continue;
            list.add(role);
        }
        return list;
    }

    public StorageDesignSqlServer getStorageDesign() {
        return (StorageDesignSqlServer)this.storageDesign;
    }

    @Override
    public List getConstraintList() {
        if (this.constraintList == null) {
            this.constraintList = new ArrayList();
        }
        return this.constraintList;
    }

    @Override
    public List getFkList() {
        if (this.fkList == null) {
            this.fkList = new ArrayList();
        }
        return this.fkList;
    }

    @Override
    public List getIndexList() {
        if (this.indexList == null) {
            this.indexList = new ArrayList();
        }
        return this.indexList;
    }

    @Override
    public List getTableList() {
        if (this.tableList == null) {
            this.tableList = new ArrayList();
        }
        return this.tableList;
    }

    @Override
    public List getViewList() {
        if (this.viewList == null) {
            this.viewList = new ArrayList();
        }
        return this.viewList;
    }

    public List getDatabaseList() {
        if (this.databaseList == null) {
            this.databaseList = new ArrayList();
        }
        return this.databaseList;
    }

    public List getTriggerList() {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        return this.triggerList;
    }

    public List getUserList() {
        if (this.userList == null) {
            this.userList = new ArrayList();
        }
        return this.userList;
    }

    public List getDefaultList() {
        if (this.defaultList == null) {
            this.defaultList = new ArrayList();
        }
        return this.defaultList;
    }

    public List getRoleList() {
        if (this.roleList == null) {
            this.roleList = new ArrayList();
        }
        return this.roleList;
    }

    public List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    public List getProcedureList() {
        if (this.procedureList == null) {
            this.procedureList = new ArrayList();
        }
        return this.procedureList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        return this.typeList;
    }

    @Override
    public List getSchemaList() {
        if (this.schemaList == null) {
            this.schemaList = new ArrayList();
        }
        return this.schemaList;
    }

    private void putNodeIcon(ModelIdObjectSelection node, String nodeName) {
        DDLTreeNodeName _nodeName = DDLTreeNodeName.fromString(nodeName);
        if (_nodeName != null) {
            switch (DDLTreeNodeName.fromString(nodeName)) {
                case NN_ROLES: {
                    node.setElementDescriptor(RoleSet.class);
                    break;
                }
                case NN_INDEXES: {
                    node.setElementDescriptor(IndexSet.class);
                    break;
                }
                case NN_FOREIGN_KEYS: {
                    node.setElementDescriptor(FKIndexAssociationSet.class);
                    break;
                }
                case NN_TRIGGERS: {
                    node.setElementDescriptor(TriggerSetSqlServer.class);
                    break;
                }
                case NN_STORED_PROCEDURES: {
                    node.setElementDescriptor(StoredProcedureSqlServer.class);
                    break;
                }
                case NN_USER_DEFINED_TYPES: {
                    node.setElementDescriptor(StructuredTypeProxyOracle.class);
                    break;
                }
                case NN_DEFAULTS: {
                    node.setElementDescriptor(DefaultSqlServerv2k5.class);
                    break;
                }
                case NN_RULES: {
                    node.setElementDescriptor(RuleSqlServerv2k.class);
                    break;
                }
            }
        }
    }

    static /* synthetic */ String access$000() {
        return INDEXES;
    }

    static /* synthetic */ String access$100() {
        return FOREIGN_KEYS;
    }

    static /* synthetic */ String access$200() {
        return TRIGGERS;
    }

    static /* synthetic */ String access$300() {
        return USER_DEFINED_TYPES;
    }

    private static enum DDLTreeNodeName {
        NN_ROLES(ROLES),
        NN_STORED_PROCEDURES(STORED_PROCEDURES),
        NN_INDEXES(DDLSelectionSqlServerv2k.access$000()),
        NN_FOREIGN_KEYS(DDLSelectionSqlServerv2k.access$100()),
        NN_TRIGGERS(DDLSelectionSqlServerv2k.access$200()),
        NN_USER_DEFINED_TYPES(DDLSelectionSqlServerv2k.access$300()),
        NN_DEFAULTS(DEFAULTS),
        NN_RULES(RULES);

        private String name;

        private DDLTreeNodeName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DDLTreeNodeName fromString(String text) {
            if (text != null) {
                for (DDLTreeNodeName n : DDLTreeNodeName.values()) {
                    if (!text.equals(n.name)) continue;
                    return n;
                }
            }
            return null;
        }
    }
}

