/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DistinctTypeProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UsedUserDefinedData;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.XMLSchemaCollectionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k;

public class DDLSelectionSqlServerv2k5
extends DDLSelectionSqlServerv2k {
    private static final String UDDT_DISTINCT_TYPES = Messages.getString("DDLSelectionSqlServerv2k5.UDDTDistinctTypes");
    private static final String UDDT_DOMAINS = Messages.getString("DDLSelectionSqlServerv2k5.UDDTDomains");
    private static final String ASSIGNED_TO_SCHEMA = Messages.getString("DDLSelectionSqlServerv2k5.AssignedToSchema");
    private static final String NOT_ASSIGNED_TO_SCHEMA = Messages.getString("DDLSelectionSqlServerv2k5.NotAssignedToSchema");
    private static final String XML_SCHEMA_COLLECTION = Messages.getString("DDLSelectionSqlServerv2k5.XMLSchemaCollection");
    private static final String SYNONYMS = Messages.getString("DDLSelectionSqlServerv2k5.Synonyms");
    private StorageDesign storageDesign;
    private List distTypeList;
    private List domainTypeList;
    private List collTypeList;
    private List synonymList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionSqlServerv2k5(StorageDesign design) {
        super(design);
        this.storageDesign = design;
    }

    public DDLSelectionSqlServerv2k5(StorageDesign design, DesignPartView selectedSubView) {
        super(design, selectedSubView);
        this.storageDesign = design;
        this.selectedSubView = selectedSubView;
    }

    @Override
    protected void addFromStorageDesign() {
        this.addAssignedToDatabase(ASSIGNED_TO_DATABASE, this);
        this.addLogins(LOGINS, this, this.getStorageDesign().getLoginSet().getElementsList());
        this.addUddtDistinctType(UDDT_DISTINCT_TYPES, this, this.getStorageDesign().getDistinctTypeProxySet().getElements());
        this.addUddtDomain(UDDT_DOMAINS, this, this.getStorageDesign().getUserDefinedTypeSet().getElementsList());
    }

    protected void addAssignedToDatabase(String nodeName, ModelIdObjectSelection parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(DataBaseSqlServer.class);
        Iterator it = this.getStorageDesign().getDataBaseSet().iterator();
        while (it.hasNext()) {
            DataBaseSqlServer db = (DataBaseSqlServer)it.next();
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(db);
            objSel.setElementDescriptor(DataBaseSqlServer.class);
            ModelIdObjectSelection strSel = new ModelIdObjectSelection(db.getName());
            strSel.setElementDescriptor(DataBaseSqlServer.class);
            if (this.getSchemasForDatabase(db).size() > 0) {
                this.addAssignedToSchema(ASSIGNED_TO_SCHEMA, strSel, this.getSchemasForDatabase(db));
            }
            this.addNotAssignedToSchema(NOT_ASSIGNED_TO_SCHEMA, strSel, db);
            this.getDatabaseList().add(objSel);
            selection.addChild(strSel);
        }
        parent.addChild(selection);
    }

    @Override
    protected void addNotAssignedToDatabase(String nodeName, ModelIdObjectSelection parent) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        Iterator it = this.getStorageDesign().getDataBaseSet().iterator();
        while (it.hasNext()) {
            DataBaseSqlServer database = (DataBaseSqlServer)it.next();
            if (!database.isNullInstance()) continue;
            if (this.getSchemasWithNullDatabase().size() > 0) {
                this.addSchemasWithNullDatabase(ASSIGNED_TO_SCHEMA, selection, this.getSchemasWithNullDatabase());
            }
            this.addNotAssignedToSchema(NOT_ASSIGNED_TO_SCHEMA, selection, database);
        }
        parent.addChild(selection);
    }

    private void addAllWithNullSchema(ModelIdObjectSelection parent, DataBaseSqlServer db) {
        this.addTables(TABLES, parent, this.getTablesWithNullSchema(db));
        this.addViews(VIEWS, parent, this.getViewsWithNullSchema(db));
        this.addContainerObjects(DEFAULTS, parent, this.getDefaultsWithNullSchema(db), this.getDefaultList());
        this.addProcedureObjects(STORED_PROCEDURES, parent, this.getProceduresWithNullSchema(db), this.getProcedureList());
        this.addContainerObjects(RULES, parent, this.getRulesWithNullSchema(db), this.getRuleList());
        this.addContainerObjects(ROLES, parent, this.getRoles(db), this.getRoleList());
        this.addContainerObjects(UDDT_DISTINCT_TYPES, parent, this.getDistinctTypesWithNullSchema(db), this.getDistTypeList());
        this.addContainerObjects(UDDT_DOMAINS, parent, this.getDomainsWithNullSchema(db), this.getDomainTypeList());
        this.addContainerObjects(XML_SCHEMA_COLLECTION, parent, this.getXMLCollectionsWithNullSchema(db), this.getCollTypeList());
        this.sort();
    }

    private void addUddtDistinctType(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(StructuredTypeProxy.class);
        Iterator it = list.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                DistinctTypeProxySqlServer type = (DistinctTypeProxySqlServer)it.next();
                ModelIdObjectSelection isel = new ModelIdObjectSelection(type);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
    }

    private void addUddtDomain(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(Domain.class);
        Iterator it = list.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                UserDefinedTypeSqlServer type = (UserDefinedTypeSqlServer)it.next();
                ModelIdObjectSelection isel = new ModelIdObjectSelection(type);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
    }

    private void addAssignedToSchema(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        for (SchemaSqlServer schema : list) {
            ModelIdObjectSelection strSel = new ModelIdObjectSelection(schema.getName());
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(schema);
            this.addSchemaDetails(schema, strSel);
            this.getUserList().add(objSel);
            selection.addChild(strSel);
        }
        parent.addChild(selection);
    }

    private void addNotAssignedToSchema(String nodeName, ModelIdObjectSelection parent, DataBaseSqlServer db) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(SchemaSetUDB.class);
        parent.addChild(selection);
        this.addAllWithNullSchema(selection, db);
    }

    private void addSchemasWithNullDatabase(String nodeName, ModelIdObjectSelection parent, List list) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(SchemaSetSqlServerv2k5.class);
        for (SchemaSqlServer schema : list) {
            ModelIdObjectSelection strSel = new ModelIdObjectSelection(schema.getName());
            ModelIdObjectSelection objSel = new ModelIdObjectSelection(schema);
            this.addSchemaDetails(schema, strSel);
            this.getUserList().add(objSel);
            selection.addChild(strSel);
        }
        parent.addChild(selection);
    }

    protected void addSchemaDetails(SchemaSqlServer schema, ModelIdObjectSelection parent) {
        this.addTables(TABLES, parent, this.getTablesForSchema(schema));
        this.addViews(VIEWS, parent, this.getViewsForSchema(schema));
        this.addContainerObjects(DEFAULTS, parent, this.getDefaultsForSchema(schema), this.getDefaultList());
        this.addProcedureObjects(STORED_PROCEDURES, parent, this.getProceduresForSchema(schema), this.getProcedureList());
        this.addContainerObjects(RULES, parent, this.getRulesForSchema(schema), this.getRuleList());
        this.addContainerObjects(UDDT_DISTINCT_TYPES, parent, this.getDistinctTypesForSchema(schema), this.getDistTypeList());
        this.addContainerObjects(UDDT_DOMAINS, parent, this.getDomainsForSchema(schema), this.getDomainTypeList());
        this.addContainerObjects(XML_SCHEMA_COLLECTION, parent, this.getXMLCollectionsForSchema(schema), this.getCollTypeList());
        this.sort();
    }

    @Override
    protected void addTableProxyDetails(TableProxySqlServer table, ModelIdObjectSelection parent) {
        super.addTableProxyDetails(table, parent);
        if (this.getSynonymsForTable(table).size() > 0) {
            this.addContainerObjects(SYNONYMS, parent, this.getSynonymsForTable(table), this.getSynonymList());
        }
    }

    @Override
    protected void addViewProxyDetails(TableViewProxySqlServer view, ModelIdObjectSelection parent) {
        super.addViewProxyDetails(view, parent);
        if (this.getSynonymsForView(view).size() > 0) {
            this.addContainerObjects(SYNONYMS, parent, this.getSynonymsForView(view), this.getSynonymList());
        }
    }

    private void addProcedureObjects(String nodeName, ModelIdObjectSelection parent, List list, List listToAdd) {
        if (!list.isEmpty()) {
            ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
            for (ModelIDObject obj : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection(obj);
                isel.setElementDescriptor(obj.getClass());
                this.getSynonymsForProcedure((StoredProcedureSqlServer)obj);
                listToAdd.add(isel);
                selection.addChild(isel);
            }
            parent.addChild(selection);
        }
    }

    private List getSchemasForDatabase(DataBaseSqlServer database) {
        ArrayList<SchemaSqlServer> list = new ArrayList<SchemaSqlServer>();
        Iterator it = this.getStorageDesign().getSchemaSet().iterator();
        while (it.hasNext()) {
            SchemaSqlServer schema = (SchemaSqlServer)it.next();
            if (schema.getDatabase() == null || !schema.getDatabase().getObjectID().equalsIgnoreCase(database.getObjectID())) continue;
            list.add(schema);
        }
        return list;
    }

    private List getSchemasWithNullDatabase() {
        ArrayList<SchemaSqlServer> list = new ArrayList<SchemaSqlServer>();
        Iterator it = this.getStorageDesign().getSchemaSet().iterator();
        while (it.hasNext()) {
            SchemaSqlServer schema = (SchemaSqlServer)it.next();
            if (!schema.getDatabase().isNullInstance()) continue;
            list.add(schema);
        }
        return list;
    }

    private List getTablesWithNullSchema(DataBaseSqlServer db) {
        ArrayList<TableProxySqlServer> list = new ArrayList<TableProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxySqlServer tableProxy = (TableProxySqlServer)it.next();
            if (tableProxy.getSchema() != null || !db.equals(tableProxy.getDatabase())) continue;
            list.add(tableProxy);
        }
        return list;
    }

    private List getTablesForSchema(SchemaSqlServer schema) {
        ArrayList<TableProxySqlServer> list = new ArrayList<TableProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxySqlServer tableProxy = (TableProxySqlServer)it.next();
            if (tableProxy.getSchema() == null || !tableProxy.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(tableProxy);
        }
        return list;
    }

    private List getViewsWithNullSchema(DataBaseSqlServer db) {
        ArrayList<TableViewProxySqlServer> list = new ArrayList<TableViewProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)it.next();
            if (view.getSchema() != null || !db.equals(view.getDataBase())) continue;
            list.add(view);
        }
        return list;
    }

    private List getViewsForSchema(SchemaSqlServer schema) {
        ArrayList<TableViewProxySqlServer> list = new ArrayList<TableViewProxySqlServer>();
        Iterator it = this.getStorageDesign().getSelectedSubView() != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxySqlServer view = (TableViewProxySqlServer)it.next();
            if ((schema == null || view.getSchema() == null || !view.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || view.getSchema() != null)) continue;
            list.add(view);
        }
        return list;
    }

    private List getDefaultsWithNullSchema(DataBaseSqlServer db) {
        ArrayList<DefaultSqlServer> list = new ArrayList<DefaultSqlServer>();
        Iterator it = this.getStorageDesign().getDefaultSet().iterator();
        while (it.hasNext()) {
            DefaultSqlServer def = (DefaultSqlServer)it.next();
            if (def.getSchema() != null || !db.equals(def.getDataBase())) continue;
            list.add(def);
        }
        return list;
    }

    private List getDefaultsForSchema(SchemaSqlServer schema) {
        ArrayList<DefaultSqlServer> list = new ArrayList<DefaultSqlServer>();
        Iterator it = this.getStorageDesign().getDefaultSet().iterator();
        while (it.hasNext()) {
            DefaultSqlServer def = (DefaultSqlServer)it.next();
            if ((schema == null || def.getSchema() == null || !def.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || def.getSchema() != null)) continue;
            list.add(def);
        }
        return list;
    }

    private List getProceduresWithNullSchema(DataBaseSqlServer db) {
        ArrayList<StoredProcedureSqlServer> list = new ArrayList<StoredProcedureSqlServer>();
        Iterator it = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureSqlServer proc = (StoredProcedureSqlServer)it.next();
            if (proc.getSchema() != null || !db.equals(proc.getDatabase())) continue;
            list.add(proc);
        }
        return list;
    }

    private List getProceduresForSchema(SchemaSqlServer schema) {
        ArrayList<StoredProcedureSqlServer> list = new ArrayList<StoredProcedureSqlServer>();
        Iterator it = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureSqlServer proc = (StoredProcedureSqlServer)it.next();
            if ((schema == null || proc.getSchema() == null || !proc.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || proc.getSchema() != null)) continue;
            list.add(proc);
        }
        return list;
    }

    private List getRulesWithNullSchema(DataBaseSqlServer db) {
        ArrayList<RuleSqlServer> list = new ArrayList<RuleSqlServer>();
        Iterator it = this.getStorageDesign().getRuleSet().iterator();
        while (it.hasNext()) {
            RuleSqlServer rule = (RuleSqlServer)it.next();
            if (rule.getSchema() != null || !db.equals(rule.getDatabase())) continue;
            list.add(rule);
        }
        return list;
    }

    private List getRulesForSchema(SchemaSqlServer schema) {
        ArrayList<RuleSqlServer> list = new ArrayList<RuleSqlServer>();
        Iterator it = this.getStorageDesign().getRuleSet().iterator();
        while (it.hasNext()) {
            RuleSqlServer rule = (RuleSqlServer)it.next();
            if ((schema == null || rule.getSchema() == null || !rule.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || rule.getSchema() != null)) continue;
            list.add(rule);
        }
        return list;
    }

    private List getRoles(DataBaseSqlServer db) {
        ArrayList<RoleSqlServer> list = new ArrayList<RoleSqlServer>();
        Iterator it = this.getStorageDesign().getRoleSet().iterator();
        while (it.hasNext()) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)it.next();
            if (!db.equals(roleSqlServer.getDatabase()) || roleSqlServer.isNullInstance()) continue;
            list.add(roleSqlServer);
        }
        return list;
    }

    private List getDistinctTypesWithNullSchema(DataBaseSqlServer db) {
        ArrayList<UsedUserDefinedData> list = new ArrayList<UsedUserDefinedData>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (it.hasNext()) {
            UsedUserDefinedData type = (UsedUserDefinedData)it.next();
            if (type.getSchema() != null || !db.equals(type.getDatabase())) continue;
            list.add(type);
        }
        return list;
    }

    private List getDistinctTypesForSchema(SchemaSqlServer schema) {
        ArrayList<UsedUserDefinedData> list = new ArrayList<UsedUserDefinedData>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (it.hasNext()) {
            UsedUserDefinedData type = (UsedUserDefinedData)it.next();
            if ((schema == null || !type.isBaseOnDistinctType() || type.getSchema() == null || !type.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || type.getSchema() != null)) continue;
            list.add(type);
        }
        return list;
    }

    private List getDomainsWithNullSchema(DataBaseSqlServer db) {
        ArrayList<UsedUserDefinedData> list = new ArrayList<UsedUserDefinedData>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (it.hasNext()) {
            UsedUserDefinedData type = (UsedUserDefinedData)it.next();
            if (type.isBaseOnDistinctType() || type.getSchema() != null || !db.equals(type.getDatabase())) continue;
            list.add(type);
        }
        return list;
    }

    private List getDomainsForSchema(SchemaSqlServer schema) {
        ArrayList<UsedUserDefinedData> list = new ArrayList<UsedUserDefinedData>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getUsedUserDefinedDataSet().iterator();
        while (it.hasNext()) {
            UsedUserDefinedData type = (UsedUserDefinedData)it.next();
            if (type.isBaseOnDistinctType() || (schema == null || type.getSchema() == null || !type.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || type.getSchema() != null)) continue;
            list.add(type);
        }
        return list;
    }

    private List getXMLCollectionsWithNullSchema(DataBaseSqlServer db) {
        ArrayList<XMLSchemaCollectionSqlServer> list = new ArrayList<XMLSchemaCollectionSqlServer>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getXmlSchemaCollectionSet().iterator();
        while (it.hasNext()) {
            XMLSchemaCollectionSqlServer type = (XMLSchemaCollectionSqlServer)it.next();
            if (type.getSchema() != null || !db.equals(type.getDatabase())) continue;
            list.add(type);
        }
        return list;
    }

    private List getXMLCollectionsForSchema(SchemaSqlServer schema) {
        ArrayList<XMLSchemaCollectionSqlServer> list = new ArrayList<XMLSchemaCollectionSqlServer>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getXmlSchemaCollectionSet().iterator();
        while (it.hasNext()) {
            XMLSchemaCollectionSqlServer type = (XMLSchemaCollectionSqlServer)it.next();
            if ((schema == null || type.getSchema() == null || !type.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) && (schema != null || type.getSchema() != null)) continue;
            list.add(type);
        }
        return list;
    }

    private List getSynonymsForProcedure(StoredProcedureSqlServer procedure) {
        ArrayList<SynonymSqlServer> list = new ArrayList<SynonymSqlServer>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSynonymSet().iterator();
        while (it.hasNext()) {
            SynonymSqlServer synonym = (SynonymSqlServer)it.next();
            if (synonym.getProcedure() == null || !synonym.getProcedure().getObjectID().equalsIgnoreCase(procedure.getObjectID())) continue;
            this.getSynonymList().add(new ModelIdObjectSelection(synonym));
            list.add(synonym);
        }
        return list;
    }

    private List getSynonymsForTable(TableProxySqlServer table) {
        ArrayList<SynonymSqlServer> list = new ArrayList<SynonymSqlServer>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSynonymSet().iterator();
        while (it.hasNext()) {
            SynonymSqlServer synonym = (SynonymSqlServer)it.next();
            if (synonym.getTable() == null || !synonym.getTable().getObjectID().equalsIgnoreCase(table.getObjectID())) continue;
            list.add(synonym);
        }
        return list;
    }

    private List getSynonymsForView(TableViewProxySqlServer view) {
        ArrayList<SynonymSqlServer> list = new ArrayList<SynonymSqlServer>();
        Iterator it = ((StorageDesignSqlServerv2k5)this.getStorageDesign()).getSynonymSet().iterator();
        while (it.hasNext()) {
            SynonymSqlServer synonym = (SynonymSqlServer)it.next();
            if (synonym.getView() == null || !synonym.getView().getObjectID().equalsIgnoreCase(view.getObjectID())) continue;
            list.add(synonym);
        }
        return list;
    }

    public List getDistTypeList() {
        if (this.distTypeList == null) {
            this.distTypeList = new ArrayList();
        }
        return this.distTypeList;
    }

    public List getDomainTypeList() {
        if (this.domainTypeList == null) {
            this.domainTypeList = new ArrayList();
        }
        return this.domainTypeList;
    }

    public List getCollTypeList() {
        if (this.collTypeList == null) {
            this.collTypeList = new ArrayList();
        }
        return this.collTypeList;
    }

    public List getSynonymList() {
        if (this.synonymList == null) {
            this.synonymList = new ArrayList();
        }
        return this.synonymList;
    }
}

