/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TriggerSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.util.MessageDialogs;

public class DDLSelectionTabs {
    private JPanel panel;
    private JTable table;
    private List list;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JButton btnSelectAll;
    private JButton btnDeselectAll;
    private GUIConfiguration configuration;
    private JTextField tfFilterText = new JTextField();

    public DDLSelectionTabs(JPanel panel, JTable table, List list) {
        this.panel = panel;
        this.table = table;
        this.list = list;
        this.initPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
        this.table.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.configuration = GUIConfiguration.getInstance();
        this.btnSelectAll = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.btnSelectAll.setToolTipText(Messages.getString("DDLSelectionTabs.SelectAll"));
        this.btnDeselectAll = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.btnDeselectAll.setToolTipText(Messages.getString("DDLSelectionTabs.DeselectAll"));
        this.btnSelectAll.addActionListener(new SelectAllListener(this.list, this.table));
        this.btnDeselectAll.addActionListener(new DeselectAllListener(this.list, this.table));
        this.toolBar = new JToolBar(0);
        this.toolBar.setFloatable(false);
        this.toolBar.add(this.btnSelectAll);
        this.toolBar.add(this.btnDeselectAll);
        JLabel lblFormat = new JLabel(Messages.getString("DDLGenerationOptions.Filter"));
        this.tfFilterText.setPreferredSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        this.tfFilterText.setMaximumSize(new Dimension(150, MessageDialogs.BUTTON_SIZE_EX.height));
        this.tfFilterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DDLSelectionTabs.this.newFilter(DDLSelectionTabs.this.tfFilterText, DDLSelectionTabs.this.table);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DDLSelectionTabs.this.newFilter(DDLSelectionTabs.this.tfFilterText, DDLSelectionTabs.this.table);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DDLSelectionTabs.this.newFilter(DDLSelectionTabs.this.tfFilterText, DDLSelectionTabs.this.table);
            }
        });
        lblFormat.setLabelFor(this.tfFilterText);
        JPanel fp = new JPanel(new FlowLayout(0));
        fp.add(new JPanel());
        fp.add(lblFormat);
        fp.add(this.tfFilterText);
        this.toolBar.add(fp);
        this.panel.add((Component)this.toolBar, "North");
        this.panel.add((Component)this.scrollPane, "Center");
    }

    private void newFilter(JTextField filterText, JTable currentTable) {
        RowFilter rf = null;
        if (currentTable == null) {
            return;
        }
        if (currentTable != null) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("^(?i)" + filterText.getText(), this.getFilterColumn(currentTable));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    protected int getFilterColumn(JTable table) {
        if (table != null) {
            if (table.getColumnModel().getColumnCount() > 2) {
                return table.getColumnModel().getColumn(2).getModelIndex();
            }
            return table.getColumnModel().getColumn(1).getModelIndex();
        }
        return -1;
    }

    private int getPreferredIconSize() {
        return 16;
    }

    public class DeselectAllListener
    implements ActionListener {
        private List deselList;
        private JTable deselTable;

        public DeselectAllListener(List deselList, JTable deselTable) {
            this.deselList = deselList;
            this.deselTable = deselTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ModelIdObjectSelection obj : this.deselList) {
                obj.setSelected(false);
            }
            this.deselTable.updateUI();
        }
    }

    public class SelectAllListener
    implements ActionListener {
        private List selList;
        private JTable selTable;

        public SelectAllListener(List selList, JTable selTable) {
            this.selList = selList;
            this.selTable = selTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ModelIdObjectSelection obj : this.selList) {
                obj.setSelected(true);
            }
            this.selTable.updateUI();
        }
    }

    public class ObjectModel
    extends AbstractTableModel {
        private List modelList;

        public ObjectModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.ObjectName");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                SynonymOracle syn;
                if (modelObject.getObject() instanceof SynonymSqlServer) {
                    if (((SynonymSqlServer)modelObject.getObject()).getProcedure() != null) {
                        return ((SynonymSqlServer)modelObject.getObject()).getProcedure().getLongName();
                    }
                    if (((SynonymSqlServer)modelObject.getObject()).getTable() != null) {
                        return ((SynonymSqlServer)modelObject.getObject()).getTable().getLongName();
                    }
                    if (((SynonymSqlServer)modelObject.getObject()).getView() != null) {
                        return ((SynonymSqlServer)modelObject.getObject()).getView().getLongName();
                    }
                }
                if ((syn = (SynonymOracle)modelObject.getObject()).getObjectUser() != null) {
                    return new StringBuffer(syn.getObjectUser().getLongName()).append('.').append(syn.getObject()).toString();
                }
                return syn.getObject();
            }
            if (col == 2) {
                if (modelObject.getObject() instanceof SynonymOracle) {
                    SynonymOracle syn = (SynonymOracle)modelObject.getObject();
                    return syn.getLongName();
                }
                return modelObject.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class UserModel
    extends AbstractTableModel {
        private List modelList;

        public UserModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                if (modelObject.getObject() instanceof UserSqlServer) {
                    return ((UserSqlServer)modelObject.getObject()).getDatabase().getName() + "." + modelObject.getObject().getName();
                }
                return ((SchemaSqlServer)modelObject.getObject()).getDatabase().getName() + "." + modelObject.getObject().getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class ConstraintModel
    extends AbstractTableModel {
        private List modelList;

        public ConstraintModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.TableName");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.modelList.size()) return null;
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                if (modelObject.getObject() instanceof Index) {
                    if (!modelObject.getObject().getDesign().getRelationalDesign().getStorageDesign().isOpen()) return ((Index)modelObject.getObject()).getContainerObject().getLongName();
                    Iterator it = modelObject.getObject().getDesign().getRelationalDesign().getStorageDesign().getTableProxySet().iterator();
                    while (it.hasNext()) {
                        TableProxy tableProxy = (TableProxy)it.next();
                        if (!tableProxy.getObjectID().equals(((Index)modelObject.getObject()).getContainerObject().getObjectID())) continue;
                        return tableProxy.getLongName();
                    }
                    return ((IndexProxy)modelObject.getObject()).getTableProxy().getLongName();
                } else {
                    if (modelObject.getObject() instanceof FKIndexAssociation) {
                        return ((FKIndexAssociation)modelObject.getObject()).getContainerWithKeyObject().getLongName();
                    }
                    if (modelObject.getObject() instanceof BitmapJoinIndexOracle) {
                        return ((BitmapJoinIndexOracle)modelObject.getObject()).getTable().getLongName();
                    }
                    if (modelObject.getObject() instanceof Trigger) {
                        if (modelObject.getObject().getDesign().getRelationalDesign().getStorageDesign() instanceof StorageDesignOracle) {
                            if (((TriggerOracle)modelObject.getObject()).getTable() != null) {
                                return ((TriggerOracle)modelObject.getObject()).getTable().getLongName();
                            }
                            if (((TriggerOracle)modelObject.getObject()).getView() == null) return ((IndexProxy)modelObject.getObject()).getTableProxy().getLongName();
                            return ((TriggerOracle)modelObject.getObject()).getView().getLongName();
                        }
                        if (modelObject.getObject().getDesign().getRelationalDesign().getStorageDesign() instanceof StorageDesignUDB) {
                            if (((TriggerUDB)modelObject.getObject()).getTable() != null) {
                                return ((TriggerUDB)modelObject.getObject()).getTable().getLongName();
                            }
                            if (((TriggerUDBv81)modelObject.getObject()).getView() == null) return ((IndexProxy)modelObject.getObject()).getTableProxy().getLongName();
                            return ((TriggerUDBv81)modelObject.getObject()).getView().getLongName();
                        }
                        if (!(modelObject.getObject().getDesign().getRelationalDesign().getStorageDesign() instanceof StorageDesignSqlServer)) return ((IndexProxy)modelObject.getObject()).getTableProxy().getLongName();
                        if (((TriggerSqlServer)modelObject.getObject()).getTable() != null) {
                            return ((TriggerSqlServer)modelObject.getObject()).getTable().getLongName();
                        }
                        if (((TriggerSqlServer)modelObject.getObject()).getView() == null) return ((IndexProxy)modelObject.getObject()).getTableProxy().getLongName();
                        return ((TriggerSqlServer)modelObject.getObject()).getView().getLongName();
                    }
                    if (!(modelObject.getObject() instanceof IndexOnViewSqlServer)) return ((IndexProxy)modelObject.getObject()).getTableProxy().getLongName();
                    return ((IndexOnViewSqlServer)modelObject.getObject()).getView().getLongName();
                }
            }
            if (col != 2) return new Integer(row * col);
            if (modelObject.getObject() instanceof Index) {
                if (!((Index)modelObject.getObject()).isPK()) return modelObject.getName();
                return "(PK) " + modelObject.getName();
            }
            if (!(modelObject.getObject() instanceof IndexProxy)) return modelObject.getName();
            if (!((IndexProxy)modelObject.getObject()).getIndex().isPK()) return modelObject.getName();
            return "(PK) " + modelObject.getName();
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class TableViewSchemaModel
    extends AbstractTableModel {
        private List modelList;

        public TableViewSchemaModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.Schema");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.modelList.size()) {
                ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
                ModelIDObject obj = modelObject.getObject();
                String longName = obj.getLongName();
                String schema = "";
                String name = longName;
                int k = longName.indexOf(46);
                if (k > 0 && k < longName.length() - 1) {
                    schema = longName.substring(0, k);
                    name = longName.substring(k + 1);
                }
                if (col == 0) {
                    return modelObject.isSelected();
                }
                if (col == 1) {
                    return schema;
                }
                if (col == 2) {
                    return name;
                }
                return new Integer(row * col);
            }
            return null;
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }

    public class TableViewModel
    extends AbstractTableModel {
        private List modelList;

        public TableViewModel(List modelList) {
            this.modelList = modelList;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.modelList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionTabs.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionTabs.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                return modelObject.isSelected();
            }
            if (col == 1) {
                return modelObject.getObject().getLongName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            ModelIdObjectSelection modelObject = (ModelIdObjectSelection)this.modelList.get(row);
            if (col == 0) {
                modelObject.setSelected((Boolean)obj);
            }
        }
    }
}

