/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.PartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerSetDB2;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.NodeGroupUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v81.ContainerUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;

public class DDLSelectionUDBv71
extends ModelIdObjectSelection
implements DDLSelectionLists {
    private static final String ALIASES = Messages.getString("DDLSelectionUDBv71.Aliases");
    private static final String DATABASES = Messages.getString("DDLSelectionUDBv71.Databases");
    private static final String NODEGROUPS = Messages.getString("DDLSelectionUDBv71.Nodegroups");
    private static final String ASSIGNED_TO_SCHEMAS = Messages.getString("DDLSelectionRelational.AssignedToSchemas");
    private static final String NOT_ASSIGNED_TO_SCHEMAS = Messages.getString("DDLSelectionRelational.NotAssignedToSchemas");
    private static final String SCHEMAS = Messages.getString("DDLSelectionUDBv71.Schemas");
    private static final String BUFFERPOOLS = Messages.getString("DDLSelectionUDBv71.BufferPools");
    private static final String STORED_PROCEDURES = Messages.getString("DDLSelectionUDBv71.StoredProcedures");
    private static final String STRUCTURED_TYPES = Messages.getString("DDLSelectionUDBv71.StructuredTypes");
    private static final String TABLES = Messages.getString("DDLSelectionUDBv71.Tables");
    private static final String TABLESPACES = Messages.getString("DDLSelectionUDBv71.Tablespaces");
    private static final String VIEWS = Messages.getString("DDLSelectionUDBv71.Views");
    private static final String DBPARTITIONS = Messages.getString("DDLSelectionUDBv71.DBPartitions");
    private static final String CONSTRAINTS = Messages.getString("DDLSelectionUDBv71.PKUKConstraints");
    private static final String INDEXES = Messages.getString("DDLSelectionUDBv71.Indexes");
    private static final String FOREIGN_KEYS = Messages.getString("DDLSelectionUDBv71.ForeignKeys");
    private static final String TRIGGERS = Messages.getString("DDLSelectionUDBv71.Triggers");
    private StorageDesign design;
    private RelationalDesign phdes;
    private List triggerList;
    private List aliasList;
    private List storedProcedureList;
    private List typeList;
    private DesignPartView selectedSubView = null;

    public DDLSelectionUDBv71(StorageDesign design) {
        super(design.getName());
        this.design = design;
        this.phdes = design.getPhysicalDesign();
        if (design.isOpen()) {
            this.setElementDescriptor(design.getClass());
            this.addFromStorageDesign();
        } else {
            this.setName(this.phdes.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, this.selectedSubView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    public DDLSelectionUDBv71(StorageDesign design, DesignPartView selectedSubView) {
        super(design.getName());
        this.design = design;
        this.selectedSubView = selectedSubView;
        this.phdes = design.getPhysicalDesign();
        if (design.isOpen()) {
            this.setElementDescriptor(design.getClass());
            this.addFromStorageDesign();
        } else if (selectedSubView != null) {
            this.setName(selectedSubView.getName());
            this.addCommonObjectsFromRelationalModel(this.phdes, selectedSubView);
            this.addSpecificObjectsFromRelationalModel();
        }
    }

    private void addFromStorageDesign() {
        this.addObjects(DATABASES, this, this.getStorageDesign().getDataBaseSet().getElementsList());
        this.addObjects(TABLESPACES, this, this.getStorageDesign().getTableSpaceSet().getElementsList());
        this.addNotNulObjects(BUFFERPOOLS, this, this.getStorageDesign().getBufferPoolSet().getElementsList());
        if (this.getStorageDesign() instanceof StorageDesignUDBv71) {
            this.addNotNulObjects(NODEGROUPS, this, this.getStorageDesign().getNodeGroupSet().getElementsList());
        } else if (this.getStorageDesign() instanceof StorageDesignUDBv81) {
            this.addNotNulObjects(DBPARTITIONS, this, this.getStorageDesign().getNodeGroupSet().getElementsList());
        }
        this.addNotNulObjects(SCHEMAS, this, this.getStorageDesign().getSchemaSet().getElementsList());
        this.addAssignedToSchema(ASSIGNED_TO_SCHEMAS, this, this.getStorageDesign().getSchemaSet().getElementsList());
        this.addNotAssignedToSchema(NOT_ASSIGNED_TO_SCHEMAS, this);
        this.sort();
    }

    protected void addObjects(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection objSel = new ModelIdObjectSelection(nodeName);
        if (list.size() > 0) {
            this.putNodeIcon(objSel, nodeName);
            for (Object obj : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection((ModelIDObject)obj);
                objSel.setElementDescriptor(obj.getClass());
                objSel.addChild(isel);
            }
            selection.addChild(objSel);
        }
    }

    private void addNotNulObjects(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection objSel = new ModelIdObjectSelection(nodeName);
        if (list.size() > 0) {
            this.putNodeIcon(objSel, nodeName);
            for (StorageObject stObject : list) {
                if (stObject.isNullInstance()) continue;
                ModelIdObjectSelection isel = new ModelIdObjectSelection(stObject);
                objSel.setElementDescriptor(stObject.getClass());
                objSel.addChild(isel);
            }
            if (objSel.getChilds().size() > 0) {
                selection.addChild(objSel);
            }
        }
    }

    private void addAssignedToSchema(String nodeName, ModelIdObjectSelection selection, List list) {
        Iterator it;
        ModelIdObjectSelection shSel = new ModelIdObjectSelection(nodeName);
        shSel.setElementDescriptor(SchemaUDB.class);
        if (list.size() > 0 && (it = list.iterator()).hasNext()) {
            while (it.hasNext()) {
                SchemaUDB schema = (SchemaUDB)it.next();
                ModelIdObjectSelection isel = new ModelIdObjectSelection(schema.getName());
                this.addSchemaDetails(schema, isel);
                shSel.addChild(isel);
            }
            selection.addChild(shSel);
        }
    }

    protected void addSchemaDetails(SchemaUDB schema, ModelIdObjectSelection parent) {
        if (this.getAliasForSchema(schema).size() > 0) {
            this.addContainerObjects(ALIASES, parent, this.getAliasForSchema(schema), this.getAliasList());
        }
        if (this.getStoredProcedureForSchema(schema).size() > 0) {
            this.addContainerObjects(STORED_PROCEDURES, parent, this.getStoredProcedureForSchema(schema), this.getStoredProcedureList());
        }
        if (this.getTypeForSchema(schema).size() > 0) {
            this.addStructuredType(STRUCTURED_TYPES, parent, this.getTypeForSchema(schema), this.getTypeList());
        }
        if (this.getTableForSchema(schema).size() > 0) {
            this.addTable(TABLES, parent, this.getTableForSchema(schema));
        }
        if (this.getViewForSchema(schema).size() > 0) {
            this.addView(VIEWS, parent, this.getViewForSchema(schema));
        }
    }

    protected void addContainerObjects(String nodeName, ModelIdObjectSelection parent, List list, List listToAdd) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        if (list.size() > 0) {
            this.putNodeIcon(selection, nodeName);
            for (Object obj : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection((ModelIDObject)obj);
                selection.addChild(isel);
                listToAdd.add(isel);
            }
            parent.addChild(selection);
        }
    }

    protected void addNotAssignedToSchema(String nodeName, ModelIdObjectSelection root) {
        ModelIdObjectSelection selection = new ModelIdObjectSelection(nodeName);
        selection.setElementDescriptor(SchemaSetUDB.class);
        this.addContainerObjects(ALIASES, selection, this.getAliasWithoutSchema(), this.getAliasList());
        this.addContainerObjects(STORED_PROCEDURES, selection, this.getStoredProcedureWithoutSchema(), this.getStoredProcedureList());
        this.addStructuredType(STRUCTURED_TYPES, selection, this.getTypeWithoutSchema(), this.getTypeList());
        this.addTable(TABLES, selection, this.getTableWithoutSchema());
        this.addView(VIEWS, selection, this.getViewWithoutSchema());
        selection.sort();
        root.addChild(selection);
    }

    private void addStructuredType(String nodeName, ModelIdObjectSelection selection, List list, List addToList) {
        ModelIdObjectSelection typeSel = new ModelIdObjectSelection(nodeName);
        if (list.size() > 0) {
            typeSel.setElementDescriptor(StructuredTypeProxyUDB.class);
            for (StructuredTypeProxyUDB type : list) {
                if (type.getStructuredType().isPredefined()) continue;
                ModelIdObjectSelection isel = new ModelIdObjectSelection(type);
                typeSel.addChild(isel);
                addToList.add(isel);
            }
            selection.addChild(typeSel);
        }
    }

    private void addTable(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection tblSel = new ModelIdObjectSelection(nodeName);
        if (list.size() > 0) {
            tblSel.setElementDescriptor(TableSet.class);
            for (TableProxyUDB table : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection(table);
                this.addTableProxyDetails(table, isel);
                tblSel.addChild(isel);
                this.getTableList().add(isel);
            }
            selection.addChild(tblSel);
        }
    }

    private void addView(String nodeName, ModelIdObjectSelection selection, List list) {
        ModelIdObjectSelection viewSel = new ModelIdObjectSelection(nodeName);
        if (list.size() > 0) {
            viewSel.setElementDescriptor(TableViewSet.class);
            for (TableViewProxyUDB view : list) {
                ModelIdObjectSelection isel = new ModelIdObjectSelection(view);
                if (this.getStorageDesign() instanceof StorageDesignUDBv81) {
                    this.addContainerObjects(TRIGGERS, isel, this.getTriggerForView(view), this.getTriggerList());
                }
                viewSel.addChild(isel);
                this.getViewList().add(isel);
            }
            selection.addChild(viewSel);
        }
    }

    protected void addTableProxyDetails(TableProxyUDB table, ModelIdObjectSelection parent) {
        List list = null;
        if (((Table)table.getObject()).getPKandUKConstraints().size() > 0) {
            this.addContainerObjects(CONSTRAINTS, parent, ((Table)table.getObject()).getPKandUKConstraints(), this.getConstraintList());
        }
        if (table.getIndexes().size() > 0) {
            this.addContainerObjects(INDEXES, parent, table.getIndexes().getElementsList(), this.getIndexList());
        }
        StorageObject fkProxy = null;
        list = this.getObjectForTable(table, this.getStorageDesign().getFKProxySet().getElements(), fkProxy);
        if (list.size() > 0) {
            this.addContainerObjects(FOREIGN_KEYS, parent, list, this.getFkList());
        }
        StorageObject trigger = null;
        list = this.getObjectForTable(table, this.getStorageDesign().getTriggerSet().getElementsList(), trigger);
        if (list.size() > 0) {
            this.addContainerObjects(TRIGGERS, parent, list, this.getTriggerList());
        }
    }

    private List getObjectForTable(TableProxyUDB table, List list, StorageObject obj2) {
        ArrayList<StorageObject> returnList = new ArrayList<StorageObject>();
        for (StorageObject obj2 : list) {
            Object parrent = null;
            if (obj2.getParent() instanceof StorageObjectCollection) {
                parrent = ((StorageObjectCollection)obj2.getParent()).getParent();
            }
            if (obj2.getParent() instanceof StorageObjectSet) {
                parrent = ((StorageObjectSet)obj2.getParent()).getParent();
            }
            if (parrent == null || !(parrent instanceof TableProxyUDB) || !((TableProxyUDB)parrent).getObjectID().equalsIgnoreCase(table.getObjectID())) continue;
            returnList.add(obj2);
        }
        return returnList;
    }

    private List getTriggerForView(TableViewProxyUDB view) {
        ArrayList<TriggerUDBv81> list = new ArrayList<TriggerUDBv81>();
        Iterator it = this.getStorageDesign().getTriggerSet().iterator();
        while (it.hasNext()) {
            TriggerUDBv81 trigger = (TriggerUDBv81)it.next();
            if (trigger.getView() == null || !trigger.getView().getObjectID().equalsIgnoreCase(view.getObjectID())) continue;
            list.add(trigger);
        }
        return list;
    }

    private List getAliasForSchema(SchemaUDB schema) {
        ArrayList<AliasUDB> list = new ArrayList<AliasUDB>();
        Iterator it = this.getStorageDesign().getAliasSet().iterator();
        while (it.hasNext()) {
            AliasUDB alias = (AliasUDB)it.next();
            if (alias.getSchema() == null || !alias.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(alias);
        }
        return list;
    }

    private List getAliasWithoutSchema() {
        ArrayList<AliasUDB> list = new ArrayList<AliasUDB>();
        Iterator it = this.getStorageDesign().getAliasSet().iterator();
        while (it.hasNext()) {
            AliasUDB alias = (AliasUDB)it.next();
            if (alias.getSchema() != null) continue;
            list.add(alias);
        }
        return list;
    }

    private List getStoredProcedureForSchema(SchemaUDB schema) {
        ArrayList<StoredProcedureUDB> list = new ArrayList<StoredProcedureUDB>();
        Iterator it = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureUDB proc = (StoredProcedureUDB)it.next();
            if (proc.getSchema() == null || !proc.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(proc);
        }
        return list;
    }

    private List getStoredProcedureWithoutSchema() {
        ArrayList<StoredProcedureUDB> list = new ArrayList<StoredProcedureUDB>();
        Iterator it = this.getStorageDesign().getStoredProcedureSet().iterator();
        while (it.hasNext()) {
            StoredProcedureUDB proc = (StoredProcedureUDB)it.next();
            if (proc.getSchema() != null) continue;
            list.add(proc);
        }
        return list;
    }

    private List getTypeForSchema(SchemaUDB schema) {
        ArrayList<StructuredTypeProxyUDB> list = new ArrayList<StructuredTypeProxyUDB>();
        Iterator it = this.getStorageDesign().getStructuredTypeProxySet().iterator();
        while (it.hasNext()) {
            StructuredTypeProxyUDB type = (StructuredTypeProxyUDB)it.next();
            if (type.getSchema() == null || !type.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(type);
        }
        return list;
    }

    private List getTypeWithoutSchema() {
        ArrayList<StructuredTypeProxyUDB> list = new ArrayList<StructuredTypeProxyUDB>();
        Iterator it = this.getStorageDesign().getStructuredTypeProxySet().iterator();
        while (it.hasNext()) {
            StructuredTypeProxyUDB type = (StructuredTypeProxyUDB)it.next();
            if (type.getSchema() != null) continue;
            list.add(type);
        }
        return list;
    }

    private List getTableForSchema(SchemaUDB schema) {
        ArrayList<TableProxyUDB> list = new ArrayList<TableProxyUDB>();
        Iterator it = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyUDB table = (TableProxyUDB)it.next();
            if (table.getSchema() == null || !table.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(table);
        }
        return list;
    }

    private List getTableWithoutSchema() {
        ArrayList<TableProxyUDB> list = new ArrayList<TableProxyUDB>();
        Iterator it = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableProxySet().iterator() : this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyUDB table = (TableProxyUDB)it.next();
            if (table.getSchema() != null) continue;
            list.add(table);
        }
        return list;
    }

    private List getViewForSchema(SchemaUDB schema) {
        ArrayList<TableViewProxyUDB> list = new ArrayList<TableViewProxyUDB>();
        Iterator it = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxyUDB view = (TableViewProxyUDB)it.next();
            if (view.getSchema() == null || !view.getSchema().getObjectID().equalsIgnoreCase(schema.getObjectID())) continue;
            list.add(view);
        }
        return list;
    }

    private List getViewWithoutSchema() {
        ArrayList<TableViewProxyUDB> list = new ArrayList<TableViewProxyUDB>();
        Iterator it = this.selectedSubView != null ? this.getStorageDesign().getSubViewTableViewProxySet().iterator() : this.getStorageDesign().getTableViewProxySet().iterator();
        while (it.hasNext()) {
            TableViewProxyUDB view = (TableViewProxyUDB)it.next();
            if (view.getSchema() != null) continue;
            list.add(view);
        }
        return list;
    }

    public List getTriggerList() {
        if (this.triggerList == null) {
            this.triggerList = new ArrayList();
        }
        return this.triggerList;
    }

    public List getAliasList() {
        if (this.aliasList == null) {
            this.aliasList = new ArrayList();
        }
        return this.aliasList;
    }

    public List getStoredProcedureList() {
        if (this.storedProcedureList == null) {
            this.storedProcedureList = new ArrayList();
        }
        return this.storedProcedureList;
    }

    public List getTypeList() {
        if (this.typeList == null) {
            this.typeList = new ArrayList();
        }
        return this.typeList;
    }

    protected StorageDesignUDB getStorageDesign() {
        return (StorageDesignUDB)this.design;
    }

    private void addSpecificObjectsFromRelationalModel() {
        Iterator it = ((StorageDesignUDB)this.design).getStructuredTypeProxySet().iterator();
        ModelIdObjectSelection strTypeSel = new ModelIdObjectSelection(Messages.getString("DDLSelectionUDBv71.StructuredTypes"));
        strTypeSel.setElementDescriptor(StructuredTypeProxyOracle.class);
        while (it.hasNext()) {
            StructuredTypeProxyUDB strType = (StructuredTypeProxyUDB)it.next();
            if (((StructuredType)strType.getObject()).isPredefined()) continue;
            ModelIdObjectSelection sel = new ModelIdObjectSelection(strType);
            strTypeSel.addChild(sel);
        }
        this.addChild(strTypeSel);
    }

    private void putNodeIcon(ModelIdObjectSelection node, String nodeName) {
        DDLTreeNodeName _nodeName = DDLTreeNodeName.fromString(nodeName);
        if (_nodeName != null) {
            switch (DDLTreeNodeName.fromString(nodeName)) {
                case NN_STORED_PROCEDURES: {
                    node.setElementDescriptor(StoredProcedureSetDB2.class);
                    break;
                }
                case NN_INDEXES: {
                    node.setElementDescriptor(IndexSet.class);
                    break;
                }
                case NN_FOREIGN_KEYS: {
                    node.setElementDescriptor(FKIndexAssociationSet.class);
                    break;
                }
                case NN_TRIGGERS: {
                    node.setElementDescriptor(TriggerSetDB2.class);
                    break;
                }
                case NN_TABLESPACES: {
                    node.setElementDescriptor(TableSpaceDB2.class);
                    break;
                }
                case NN_SCHEMAS: {
                    node.setElementDescriptor(SchemaSetSqlServerv2k5.class);
                    break;
                }
                case NN_BUFFERPOOLS: {
                    node.setElementDescriptor(ContainerUDBv81.class);
                    break;
                }
                case NN_NODEGROUPS: {
                    node.setElementDescriptor(NodeGroupUDBv71.class);
                    break;
                }
                case NN_DBPARTITIONS: {
                    node.setElementDescriptor(PartitionDB2.class);
                    break;
                }
                case NN_DATABASES: {
                    node.setElementDescriptor(StorageDesignUDBv71.class);
                    break;
                }
                case NN_ALIASES: {
                    node.setElementDescriptor(AliasDB2.class);
                    break;
                }
                case NN_STOREDPROCEDURES: {
                    node.setElementDescriptor(StoredProcedureSetDB2.class);
                    break;
                }
                case NN_CONSTRAINTS: {
                    node.setElementDescriptor(Constraint.class);
                    break;
                }
            }
        }
    }

    static /* synthetic */ String access$000() {
        return TABLESPACES;
    }

    static /* synthetic */ String access$100() {
        return STORED_PROCEDURES;
    }

    static /* synthetic */ String access$200() {
        return INDEXES;
    }

    static /* synthetic */ String access$300() {
        return FOREIGN_KEYS;
    }

    static /* synthetic */ String access$400() {
        return TRIGGERS;
    }

    static /* synthetic */ String access$500() {
        return BUFFERPOOLS;
    }

    static /* synthetic */ String access$600() {
        return NODEGROUPS;
    }

    static /* synthetic */ String access$700() {
        return DBPARTITIONS;
    }

    static /* synthetic */ String access$800() {
        return SCHEMAS;
    }

    static /* synthetic */ String access$900() {
        return DATABASES;
    }

    static /* synthetic */ String access$1000() {
        return ALIASES;
    }

    static /* synthetic */ String access$1100() {
        return CONSTRAINTS;
    }

    private static enum DDLTreeNodeName {
        NN_TABLESPACES(DDLSelectionUDBv71.access$000()),
        NN_STORED_PROCEDURES(DDLSelectionUDBv71.access$100()),
        NN_INDEXES(DDLSelectionUDBv71.access$200()),
        NN_FOREIGN_KEYS(DDLSelectionUDBv71.access$300()),
        NN_TRIGGERS(DDLSelectionUDBv71.access$400()),
        NN_BUFFERPOOLS(DDLSelectionUDBv71.access$500()),
        NN_NODEGROUPS(DDLSelectionUDBv71.access$600()),
        NN_DBPARTITIONS(DDLSelectionUDBv71.access$700()),
        NN_SCHEMAS(DDLSelectionUDBv71.access$800()),
        NN_DATABASES(DDLSelectionUDBv71.access$900()),
        NN_ALIASES(DDLSelectionUDBv71.access$1000()),
        NN_STOREDPROCEDURES(DDLSelectionUDBv71.access$100()),
        NN_CONSTRAINTS(DDLSelectionUDBv71.access$1100());

        private String name;

        private DDLTreeNodeName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static DDLTreeNodeName fromString(String text) {
            if (text != null) {
                for (DDLTreeNodeName n : DDLTreeNodeName.values()) {
                    if (!text.equals(n.name)) continue;
                    return n;
                }
            }
            return null;
        }
    }
}

