/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.designrules.CheckResult;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.CheckResultComponent;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomDesignRulesManager
extends CustomDialog {
    private static final long serialVersionUID = -4695332256421700394L;
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private final String RULE_NAME = "Rule";
    private final String ATTRIBUTE = "attribute";
    private final String ENTITY = "entity";
    private final String KEY = "key";
    private final String ENTITY_VIEW = "entView";
    private final String EXTERNAL_AGENT = "extAgent";
    private final String INFORMATION_FLOW = "infFlow";
    private final String INFORMATION_STORE = "infStore";
    private final String PROCESS = "process";
    private final String TRANSFORMATION_TASK = "trTask";
    private final String TRANSFORMATION = "transformation";
    private final String COLUMN = "column";
    private final String DOMAIN = "domain";
    private final String INDEX = "index";
    private final String TL_CONSTRAINT = "tlConstraint";
    private final String TABLE = "table";
    private int result = 0;
    private JDialog dialog;
    private RelationalDesign relDesign;
    public List<DRCustomValidationScript> customScriptsContainerList;
    private JTable customRulesTable;
    public JButton bnSaveRules;
    public JButton bnApply;
    public JButton bnClose;
    private JButton bnImport;
    private JButton bnExport;
    private JButton btnAddCustomRule;
    private JButton btnRemoveCustomRule;
    private DRCustomValidationScript currentRule;
    private CheckResultComponent checkResultComponent;
    private int cgCounter = 0;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JSplitPane mainPanel;
    private JSplitPane leftPanel;
    private boolean rulesSaved = true;
    private RSyntaxTextArea scriptEditor;
    private ApplicationView appView;
    private TreeMap<String, Object> objects;
    private TreeMap<String, String> mapVariables = new TreeMap();
    private TreeMap<String, Object> mapClasses = new TreeMap();
    private ScriptEngineManager scriptEngineManager;
    private JComboBox cbMethod = new JComboBox();
    private JComboBox cbLibrary;
    private File file;
    private JComboBox obCombo;
    private JComboBox engCombo;
    private JComboBox resCombo;
    private boolean autoChanged = false;
    private ArrayList allEngines;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    private ArrayList allCR;
    private static final Logger LOGGER = new Logger(CustomDesignRulesManager.class);

    public CustomDesignRulesManager(ApplicationView appView, RelationalDesign relDesign, ScriptEngineManager scriptEngineManager) {
        super(appView);
        this.appView = appView;
        this.relDesign = relDesign;
        this.scriptEngineManager = scriptEngineManager;
        UIManager.put("TextArea.inactiveForeground", Color.BLACK);
        this.allEngines = appView.getScriptEngines();
        this.allCR = appView.getCustomDesignRules();
        this.init();
        this.loadCustomDR();
    }

    private void init() {
        JPanel tablePanel = new JPanel(new BorderLayout());
        JPanel scriptPanel = new JPanel(new BorderLayout());
        scriptPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomDesignRulesManager.RuleScript")));
        this.leftPanel = new JSplitPane(0, tablePanel, scriptPanel);
        this.leftPanel.setMinimumSize(new Dimension(650, 800));
        this.leftPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.leftPanel.setDividerLocation(200);
        this.mainPanel = new JSplitPane(1, this.leftPanel, this.getCheckResultComponent());
        this.mainPanel.setDividerLocation(660);
        this.customScriptsContainerList = new ArrayList<DRCustomValidationScript>();
        this.customRulesTable = new JTable(new CustomRuleModel());
        this.customRulesTable.setSelectionMode(0);
        this.customRulesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        TableColumn col0 = this.customRulesTable.getColumnModel().getColumn(0);
        col0.setWidth(30);
        col0.setMaxWidth(30);
        JTextField tf = new JTextField();
        TableColumn col1 = this.customRulesTable.getColumnModel().getColumn(1);
        col1.setWidth(220);
        col1.setMaxWidth(1000);
        col1.setCellEditor(new TFCellEditor(tf));
        this.obCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getObjecTypes().toArray()));
        TableColumn col2 = this.customRulesTable.getColumnModel().getColumn(2);
        col2.setWidth(120);
        col2.setMaxWidth(120);
        col2.setCellEditor(new DefaultCellEditor(this.obCombo));
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.appView.getScriptEngines().toArray()));
        TableColumn col3 = this.customRulesTable.getColumnModel().getColumn(3);
        col3.setWidth(300);
        col3.setMaxWidth(300);
        col3.setCellEditor(new DefaultCellEditor(this.engCombo));
        this.resCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getResultTypes().toArray()));
        TableColumn col4 = this.customRulesTable.getColumnModel().getColumn(4);
        col4.setWidth(100);
        col4.setMaxWidth(100);
        col4.setCellEditor(new DefaultCellEditor(this.resCombo));
        TableColumn col5 = this.customRulesTable.getColumnModel().getColumn(5);
        col5.setWidth(100);
        col5.setMaxWidth(100);
        TableColumn col6 = this.customRulesTable.getColumnModel().getColumn(6);
        this.customRulesTable.getColumnModel().removeColumn(col6);
        this.obCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    String item = (String)evt.getItem();
                    CustomDesignRulesManager.this.customRulesTable.setValueAt(CustomDesignRulesManager.this.mapVariables.get(item), CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 5);
                    CustomDesignRulesManager.this.updateUI();
                }
                String oldValue = (String)CustomDesignRulesManager.this.customRulesTable.getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 2);
                String newValue = (String)CustomDesignRulesManager.this.obCombo.getSelectedItem();
                if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                    CustomDesignRulesManager.this.rulesSaved = false;
                }
            }
        });
        this.engCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String oldValue = (String)CustomDesignRulesManager.this.customRulesTable.getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 3);
                String newValue = (String)CustomDesignRulesManager.this.engCombo.getSelectedItem();
                if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                    CustomDesignRulesManager.this.rulesSaved = false;
                }
                if (evt.getStateChange() == 1) {
                    boolean engineSupportsInvocable = true;
                    if (!CustomDesignRulesManager.this.cbLibrary.getSelectedItem().equals("")) {
                        engineSupportsInvocable = CustomDesignRulesManager.this.checkIfEngineSupportsInvocable(newValue);
                    }
                    if (!engineSupportsInvocable && !CustomDesignRulesManager.this.engCombo.getSelectedItem().equals("")) {
                        JOptionPane.showMessageDialog(CustomDesignRulesManager.this, MessageFormat.format(Messages.getString("CustomDesignRulesManager.EnginNotSupportingInvocable"), CustomDesignRulesManager.this.currentRule.getEngineName()), Messages.getString("CustomDesignRulesManager.Error"), 0);
                        CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                        CustomDesignRulesManager.this.cbMethod.removeAllItems();
                        CustomDesignRulesManager.this.scriptEditor.setText("");
                        CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                    }
                }
            }
        });
        this.resCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String oldValue = (String)CustomDesignRulesManager.this.customRulesTable.getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 4);
                String newValue = (String)CustomDesignRulesManager.this.resCombo.getSelectedItem();
                if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                    CustomDesignRulesManager.this.rulesSaved = false;
                }
            }
        });
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                CustomDesignRulesManager.this.rulesSaved = false;
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
            }
        });
        this.customRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selRow = CustomDesignRulesManager.this.customRulesTable.getSelectedRow();
                    if (selRow == -1) {
                        CustomDesignRulesManager.this.btnRemoveCustomRule.setEnabled(false);
                        CustomDesignRulesManager.this.bnApply.setEnabled(false);
                        CustomDesignRulesManager.this.bnSaveRules.setEnabled(false);
                        CustomDesignRulesManager.this.scriptEditor.setEnabled(false);
                    } else {
                        CustomDesignRulesManager.this.saveSelected();
                        CustomDesignRulesManager.this.currentRule = ((CustomRuleModel)CustomDesignRulesManager.this.customRulesTable.getModel()).getCustomRulesContainerList().get(selRow);
                        CustomDesignRulesManager.this.scriptEditor.setText("");
                        CustomDesignRulesManager.this.scriptEditor.setText(CustomDesignRulesManager.this.currentRule.getScript());
                        if (CustomDesignRulesManager.this.currentRule != null) {
                            String ename = CustomDesignRulesManager.this.currentRule.getEngineName();
                            if (ename != null) {
                                ename = ename.toUpperCase();
                            }
                            if (ename != null && ename.indexOf("RHINO") > -1) {
                                CustomDesignRulesManager.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                            } else if (ename != null && ename.indexOf("RUBY") > -1) {
                                CustomDesignRulesManager.this.scriptEditor.setSyntaxEditingStyle("text/ruby");
                            } else {
                                CustomDesignRulesManager.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                            }
                        }
                        CustomDesignRulesManager.this.scriptEditor.setCaretPosition(0);
                        CustomDesignRulesManager.this.autoChanged = true;
                        CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                        CustomDesignRulesManager.this.cbLibrary.setSelectedItem(CustomDesignRulesManager.this.currentRule.getLibrary() != null ? CustomDesignRulesManager.this.currentRule.getLibrary().getName() : "");
                        CustomDesignRulesManager.this.cbMethod.setSelectedItem(CustomDesignRulesManager.this.currentRule.getFunction());
                        CustomDesignRulesManager.this.autoChanged = false;
                        CustomDesignRulesManager.this.btnRemoveCustomRule.setEnabled(true);
                        CustomDesignRulesManager.this.bnApply.setEnabled(true);
                        CustomDesignRulesManager.this.bnSaveRules.setEnabled(!CustomDesignRulesManager.this.rulesSaved);
                        CustomDesignRulesManager.this.scriptEditor.setEnabled(CustomDesignRulesManager.this.currentRule.getLibrary() == null);
                    }
                }
            }
        });
        tablePanel.add((Component)this.createCustomRulesToolbarPanel(), "North");
        JScrollPane scrollPane = new JScrollPane(this.customRulesTable);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        tablePanel.add((Component)scrollPane, "Center");
        JPanel librariesPanel = new JPanel(new FlowLayout(1));
        JLabel libLabel = new JLabel(Messages.getString("CustomDesignRulesManager.Library"));
        libLabel.setPreferredSize(new Dimension(70, 20));
        this.cbLibrary = new JComboBox<Object>(this.getLibraries().toArray());
        this.cbLibrary.setPreferredSize(new Dimension(230, 20));
        this.cbLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    boolean engineSupportsInvocable = true;
                    if (!CustomDesignRulesManager.this.autoChanged && CustomDesignRulesManager.this.currentRule.getEngineName() != null && !CustomDesignRulesManager.this.currentRule.getEngineName().equals("")) {
                        engineSupportsInvocable = CustomDesignRulesManager.this.checkIfEngineSupportsInvocable((String)CustomDesignRulesManager.this.engCombo.getSelectedItem());
                    }
                    if (engineSupportsInvocable) {
                        String item = (String)evt.getItem();
                        if (item != "") {
                            CustomDesignRulesManager.this.cbMethod.removeAllItems();
                            for (DRLibrary lib : CustomDesignRulesManager.this.appView.getCustomLibraries()) {
                                if (!lib.getName().equals(item)) continue;
                                Iterator<String> it1 = lib.getFunctions().iterator();
                                while (it1.hasNext()) {
                                    CustomDesignRulesManager.this.cbMethod.addItem(it1.next());
                                }
                                CustomDesignRulesManager.this.scriptEditor.setText("");
                                CustomDesignRulesManager.this.scriptEditor.setText(lib.getScript());
                                CustomDesignRulesManager.this.scriptEditor.setCaretPosition(0);
                                CustomDesignRulesManager.this.scriptEditor.setEnabled(false);
                                break;
                            }
                            CustomDesignRulesManager.this.cbMethod.updateUI();
                            CustomDesignRulesManager.this.bnApply.setEnabled(true);
                        } else if (item == "") {
                            CustomDesignRulesManager.this.cbMethod.removeAllItems();
                            CustomDesignRulesManager.this.cbMethod.updateUI();
                            CustomDesignRulesManager.this.scriptEditor.setText("");
                            CustomDesignRulesManager.this.scriptEditor.setText(CustomDesignRulesManager.this.currentRule.getScript());
                            CustomDesignRulesManager.this.scriptEditor.setCaretPosition(0);
                            CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                        }
                        if (!CustomDesignRulesManager.this.autoChanged) {
                            CustomDesignRulesManager.this.rulesSaved = false;
                            CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                        }
                    } else if (!CustomDesignRulesManager.this.cbLibrary.getSelectedItem().equals("")) {
                        JOptionPane.showMessageDialog(CustomDesignRulesManager.this, MessageFormat.format(Messages.getString("CustomDesignRulesManager.EnginNotSupportingInvocable"), CustomDesignRulesManager.this.currentRule.getEngineName()), Messages.getString("CustomDesignRulesManager.Error"), 0);
                        CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                        CustomDesignRulesManager.this.cbMethod.removeAllItems();
                        CustomDesignRulesManager.this.scriptEditor.setText("");
                        CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                    }
                }
            }
        });
        this.cbMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1 && !CustomDesignRulesManager.this.autoChanged) {
                    CustomDesignRulesManager.this.rulesSaved = false;
                    CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                }
            }
        });
        JLabel metLabel = new JLabel(Messages.getString("CustomDesignRulesManager.Method"));
        metLabel.setPreferredSize(new Dimension(70, 20));
        this.cbMethod.setPreferredSize(new Dimension(230, 20));
        librariesPanel.add(libLabel);
        librariesPanel.add(this.cbLibrary);
        librariesPanel.add(metLabel);
        librariesPanel.add(this.cbMethod);
        scriptPanel.add((Component)librariesPanel, "North");
        this.scriptEditor = new RSyntaxTextArea();
        this.scriptEditor.setEnabled(false);
        this.scriptEditor.setSyntaxEditingStyle("text/javascript");
        this.scriptEditor.setCodeFoldingEnabled(true);
        this.scriptEditor.setAntiAliasingEnabled(true);
        this.scriptEditor.setHyperlinksEnabled(true);
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(e.getURL().toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.scriptEditor.addHyperlinkListener(listener);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                CustomDesignRulesManager.this.rulesSaved = false;
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        RTextScrollPane scrollPaneSE = new RTextScrollPane((RTextArea)this.scriptEditor);
        scrollPaneSE.setPreferredSize(new Dimension(300, 550));
        scriptPanel.add((Component)scrollPaneSE, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnApply = new JButton(Messages.getString("CustomDesignRulesManager.Apply"));
        this.bnApply.setToolTipText(Messages.getString("CustomDesignRulesManager.ApplyTooltip"));
        this.bnApply.setEnabled(false);
        this.bnApply.setMnemonic(65);
        this.bnSaveRules = new JButton(Messages.getString("CustomDesignRulesManager.Save"));
        this.bnSaveRules.setToolTipText(Messages.getString("CustomDesignRulesManager.SaveTooltip"));
        this.bnSaveRules.setEnabled(false);
        this.bnSaveRules.setMnemonic(83);
        this.bnApply.addActionListener(new ApplyAction());
        this.bnSaveRules.addActionListener(new SaveAction());
        this.bnSaveRules.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnSaveRules);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnApply);
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setToolTipText(Messages.getString("CustomDesignRulesManager.importTooltip"));
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnImport);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setToolTipText(Messages.getString("CustomDesignRulesManager.ExportTooltip"));
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnExport);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setToolTipText(Messages.getString("CustomDesignRulesManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        btnPanel.add(this.bnClose);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setToolTipText(Messages.getString("CustomDesignRulesManager.HelpTooltip"));
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(bnHelp);
        scriptPanel.add((Component)btnPanel, "South");
    }

    private void saveSelected() {
        if (this.currentRule != null) {
            if (this.scriptEditor.isEnabled()) {
                this.currentRule.setScript(this.scriptEditor.getText());
                this.currentRule.setLibrary(null);
                this.currentRule.setFunction(null);
            } else {
                for (DRLibrary l : this.appView.getCustomLibraries()) {
                    if (!l.getName().equals(this.cbLibrary.getSelectedItem())) continue;
                    this.currentRule.setLibrary(l);
                    break;
                }
                this.currentRule.setFunction((String)this.cbMethod.getSelectedItem());
                this.currentRule.setScript(null);
            }
        }
    }

    private void loadCustomDR() {
        Iterator it = this.allCR.iterator();
        this.customScriptsContainerList.clear();
        while (it.hasNext()) {
            DRCustomValidationScript drcs;
            Object o = it.next();
            if (!(o instanceof DRCustomValidationScript) || !(drcs = ((DRCustomValidationScript)o).copy()).getPurpose().equals("validation")) continue;
            drcs.setVariable(this.mapVariables.get(drcs.getObject()));
            this.customScriptsContainerList.add(drcs);
        }
        if (this.customScriptsContainerList.size() > 0) {
            this.customRulesTable.clearSelection();
            this.customRulesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.customRulesTable.updateUI();
        this.rulesSaved = true;
        this.bnSaveRules.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomDesignRulesManager.this.customRulesTable.getRowCount(); ++i) {
                    if (!CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(i, 6).equals("err")) continue;
                    JOptionPane.showMessageDialog(CustomDesignRulesManager.this, Messages.getString("CustomDesignRulesManager.MissingEngine"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    break;
                }
            }
        });
    }

    protected JPanel createCustomRulesToolbarPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnAddCustomRule = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddCustomRule.setToolTipText(Messages.getString("DesignRuleView.AddRule"));
        this.btnAddCustomRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DRCustomValidationScript cs = new DRCustomValidationScript(CustomDesignRulesManager.this.generateRuleName(), null, "validation");
                cs.setScriptEngineManager(CustomDesignRulesManager.this.scriptEngineManager);
                CustomDesignRulesManager.this.customScriptsContainerList.add(cs);
                CustomDesignRulesManager.this.customRulesTable.updateUI();
                CustomDesignRulesManager.this.customRulesTable.getSelectionModel().setSelectionInterval(CustomDesignRulesManager.this.customRulesTable.getRowCount() - 1, CustomDesignRulesManager.this.customRulesTable.getRowCount() - 1);
                CustomDesignRulesManager.this.customRulesTable.scrollRectToVisible(new Rectangle(CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth() * CustomDesignRulesManager.this.customRulesTable.getSelectedColumn(), CustomDesignRulesManager.this.customRulesTable.getRowHeight() * CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth(), CustomDesignRulesManager.this.customRulesTable.getRowHeight()));
                CustomDesignRulesManager.this.btnRemoveCustomRule.setEnabled(CustomDesignRulesManager.this.customScriptsContainerList.size() > 0);
                CustomDesignRulesManager.this.scriptEditor.setEnabled(true);
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                CustomDesignRulesManager.this.rulesSaved = false;
            }
        });
        this.btnRemoveCustomRule = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveCustomRule.setToolTipText(Messages.getString("DesignRuleView.RemoveRule"));
        this.btnRemoveCustomRule.setEnabled(false);
        this.btnRemoveCustomRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CustomDesignRulesManager.this.customRulesTable.getSelectedRow();
                CustomDesignRulesManager.this.customScriptsContainerList.remove(selected);
                CustomDesignRulesManager.this.customRulesTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomDesignRulesManager.this.customRulesTable.updateUI();
                CustomDesignRulesManager.this.customRulesTable.scrollRectToVisible(new Rectangle(CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth() * CustomDesignRulesManager.this.customRulesTable.getSelectedColumn(), CustomDesignRulesManager.this.customRulesTable.getRowHeight() * CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), CustomDesignRulesManager.this.customRulesTable.getColumnModel().getColumn(1).getWidth(), CustomDesignRulesManager.this.customRulesTable.getRowHeight()));
                if (CustomDesignRulesManager.this.customScriptsContainerList.size() == 0) {
                    CustomDesignRulesManager.this.cbLibrary.setSelectedItem("");
                    CustomDesignRulesManager.this.cbMethod.removeAllItems();
                    CustomDesignRulesManager.this.scriptEditor.setText("");
                    CustomDesignRulesManager.this.scriptEditor.setEnabled(false);
                    CustomDesignRulesManager.this.bnApply.setEnabled(false);
                }
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(true);
                CustomDesignRulesManager.this.rulesSaved = false;
            }
        });
        toolBar.add(this.btnAddCustomRule);
        toolBar.add(this.btnRemoveCustomRule);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    protected String generateRuleName() {
        String name = "Rule";
        int newNumber = 0;
        int lastNumber = this.customScriptsContainerList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String ruleName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.ruleExists(ruleName)) {
            newNumber = ++this.cgCounter;
            ruleName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return ruleName;
    }

    private boolean ruleExists(String name) {
        for (int i = 0; i < this.customScriptsContainerList.size(); ++i) {
            DRCustomValidationScript rule = this.customScriptsContainerList.get(i);
            if (!name.equalsIgnoreCase(rule.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomDesignRulesManager.CustomDesignRules"), false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.setContentPane(this);
            this.dialog.setSize(1000, 600);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOM_DESIGN_RULES_DIALOG";
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public void setCheckResults(Collection checkResults) {
        this.getCheckResultComponent().clearCheckResults();
        if (checkResults.size() > 0) {
            this.getCheckResultComponent().add(checkResults.toArray(new CheckResult[0]));
            this.getCheckResultComponent().bnSaveCSV.setEnabled(true);
            this.getCheckResultComponent().bnClearAll.setEnabled(true);
        } else if (!this.currentRule.hasEvalError()) {
            JOptionPane.showMessageDialog(this, Messages.getString("DesignRuleView.CheckDesignOK"));
        }
    }

    private void stopCellediting() {
        if (this.scriptEditor.isEnabled()) {
            this.currentRule.setScript(this.scriptEditor.getText());
        }
        for (DRLibrary l : this.appView.getCustomLibraries()) {
            if (!l.getName().equals(this.cbLibrary.getSelectedItem())) continue;
            this.currentRule.setLibrary(l);
            break;
        }
        this.currentRule.setFunction((String)this.cbMethod.getSelectedItem());
        TableCellEditor cellEditor = this.customRulesTable.getCellEditor();
        if (cellEditor != null) {
            this.customRulesTable.getCellEditor().stopCellEditing();
        }
    }

    public Action closeAction() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomDesignRulesManager.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomDesignRulesManager.this.canClose()) {
                    CustomDesignRulesManager.this.nullifyDesignRuleManager();
                    CustomDesignRulesManager.this.close();
                }
            }
        };
        return action;
    }

    private ArrayList getObjecTypes() {
        DesignRuleManager drm = this.getRuleManager();
        ArrayList<String> se = new ArrayList<String>();
        this.objects = drm.getObjects();
        se.addAll(this.objects.keySet());
        Set<Map.Entry<String, Object>> set = this.objects.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String k = entry.getKey();
            if (k.equals("Attribute")) {
                this.mapVariables.put(k, "attribute");
                this.mapClasses.put("attribute", Attribute.class);
                continue;
            }
            if (k.equals("Entity")) {
                this.mapVariables.put(k, "entity");
                this.mapClasses.put("entity", Entity.class);
                continue;
            }
            if (k.equals("Key")) {
                this.mapVariables.put(k, "key");
                continue;
            }
            if (k.equals("View")) {
                this.mapVariables.put(k, "entView");
                this.mapClasses.put("entView", EntityView.class);
                continue;
            }
            if (k.equals("External Agent")) {
                this.mapVariables.put(k, "extAgent");
                this.mapClasses.put("extAgent", ExternalAgent.class);
                continue;
            }
            if (k.equals("Information Flow")) {
                this.mapVariables.put(k, "infFlow");
                this.mapClasses.put("infFlow", Flow.class);
                continue;
            }
            if (k.equals("Information Store")) {
                this.mapVariables.put(k, "infStore");
                this.mapClasses.put("infStore", InfoStore.class);
                continue;
            }
            if (k.equals("Process")) {
                this.mapVariables.put(k, "process");
                this.mapClasses.put("process", Process.class);
                continue;
            }
            if (k.equals("Transformation Task")) {
                this.mapVariables.put(k, "trTask");
                this.mapClasses.put("trTask", TransformationTask.class);
                continue;
            }
            if (k.equals("Transformation")) {
                this.mapVariables.put(k, "transformation");
                this.mapClasses.put("transformation", Transformation.class);
                continue;
            }
            if (k.equals("Column")) {
                this.mapVariables.put(k, "column");
                this.mapClasses.put("column", Column.class);
                continue;
            }
            if (k.equals("Domain")) {
                this.mapVariables.put(k, "domain");
                this.mapClasses.put("domain", Domain.class);
                continue;
            }
            if (k.equals("Index/Constraint")) {
                this.mapVariables.put(k, "index");
                this.mapClasses.put("index", Index.class);
                continue;
            }
            if (k.equals("Table Level Constraint")) {
                this.mapVariables.put(k, "tlConstraint");
                this.mapClasses.put("tlConstraint", Constraint.class);
                continue;
            }
            if (!k.equals("Table")) continue;
            this.mapVariables.put(k, "table");
            this.mapClasses.put("table", Table.class);
        }
        return se;
    }

    public CheckResultComponent getCheckResultComponent() {
        if (this.checkResultComponent == null) {
            this.checkResultComponent = new CheckResultComponent(this.appView);
        }
        return this.checkResultComponent;
    }

    private DesignRuleManager getRuleManager() {
        if (this.getRelDesign() != null) {
            return this.getDesign().getAppView().getDesignRuleManager(this.getRelDesign());
        }
        return this.getDesign().getAppView().getDesignRuleManager(this.appView.getCurrentDesign().getRelationalDesign());
    }

    protected boolean canSave() {
        block6: {
            block7: {
                if (this.customScriptsContainerList.size() <= 0) break block6;
                if (this.customRulesTable.getSelectedRow() <= -1) break block7;
                if (this.customRulesTable.getModel().getValueAt(this.customRulesTable.getSelectedRow(), 2) == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.NoObjectChosen"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                if (this.customRulesTable.getModel().getValueAt(this.customRulesTable.getSelectedRow(), 3) == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.NoEngineChosen"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                if (this.customRulesTable.getModel().getValueAt(this.customRulesTable.getSelectedRow(), 4) == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.NoTypeChosen"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                if (this.scriptEditor.getText().trim().length() == 0 || this.scriptEditor.getText() == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.NoScript"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                for (DRCustomValidationScript drcs : this.customScriptsContainerList) {
                    if (drcs.getObject() != null && drcs.getEngineName() != null && drcs.getResultType() != null && (drcs.getLibrary() != null || !drcs.getScript().equals(""))) continue;
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.NoObjectEngineScript"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    return false;
                }
                break block6;
            }
            if (this.customRulesTable.getSelectedRow() != -1) break block6;
            for (DRCustomValidationScript drcs : this.customScriptsContainerList) {
                if (drcs.getObject() != null && drcs.getEngineName() != null && drcs.getResultType() != null && (drcs.getLibrary() != null || !drcs.getScript().equals(""))) continue;
                JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.NoObjectEngineScript"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canClose() {
        if (!this.rulesSaved) {
            String s1 = Messages.getString("CustomDesignRulesManager.Yes");
            String s2 = Messages.getString("CustomDesignRulesManager.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("CustomDesignRulesManager.RulesNotSaved"), Messages.getString("CustomDesignRulesManager.CloseConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    public ArrayList getResultTypes() {
        ArrayList<String> v = new ArrayList<String>();
        v.add("Warning");
        v.add("Error");
        return v;
    }

    public RelationalDesign getRelDesign() {
        return this.relDesign;
    }

    public ArrayList<String> getLibraries() {
        ArrayList<String> v = new ArrayList<String>();
        Iterator<DRLibrary> it = this.appView.getCustomLibraries().iterator();
        v.add("");
        while (it.hasNext()) {
            v.add(it.next().getName());
        }
        return v;
    }

    private boolean checkIfEngineSupportsInvocable(String selected) {
        ScriptEngine engine;
        String selectedEngine = selected;
        return selectedEngine != null && !selectedEngine.equals("") && (engine = this.scriptEngineManager.getEngineByName(selectedEngine)) instanceof Invocable;
    }

    public Action createImportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomDesignRulesManager.Import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("CustomDesignRulesManager.XMLFiles");
                        }
                    };
                    URLChooser fileChooser = DialogUtil.newURLChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    if (lastImpFolder != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                    } else {
                        String lastDir = CustomDesignRulesManager.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = CustomDesignRulesManager.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("CustomDesignRulesManager.ImportCDR"));
                    if (status == 0) {
                        CustomDesignRulesManager.this.file = new File(fileChooser.getSelectedURL().getPath());
                        if (CustomDesignRulesManager.this.file != null) {
                            lastImpFolder = CustomDesignRulesManager.this.file.getParentFile();
                            FileOpenHistory.getInstance().updateFileHistory(lastImpFolder.toURI().toURL());
                            try {
                                int ch;
                                StringBuffer buffer = new StringBuffer();
                                FileInputStream fis = new FileInputStream(CustomDesignRulesManager.this.file);
                                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                BufferedReader in = new BufferedReader(isr);
                                while ((ch = ((Reader)in).read()) > -1) {
                                    buffer.append((char)ch);
                                }
                                ((Reader)in).close();
                                CustomDesignRulesManager.this.importCDR(buffer.toString());
                            }
                            catch (Exception ex) {
                                LOGGER.error("Unable to load custom design rules from imported file: ", ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error import custom design rules ", ex);
                }
            }
        };
        return action;
    }

    public void importCDR(String str) {
        try {
            StringReader sr = new StringReader(str);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(sr);
            Document doc = builder.parse(inputSource);
            ArrayList<DRCustomValidationScript> loadedScripts = new ArrayList<DRCustomValidationScript>();
            NodeList nodes = doc.getElementsByTagName("scr");
            int nodesLength = nodes.getLength();
            for (int i = 0; i < nodesLength; ++i) {
                DRLibrary currentLibrary = null;
                Element elm = (Element)nodes.item(i);
                DRCustomValidationScript drs = new DRCustomValidationScript(elm.getAttribute(StringUtilities.decodeAttributeValue("name")), elm.getAttribute("id"), elm.getAttribute("purpose"));
                drs.setObject(elm.getAttribute("object"));
                drs.setEngineName(elm.getAttribute("engine"));
                drs.setResultType(elm.getAttribute("type"));
                drs.setVariable(elm.getAttribute("var"));
                drs.setScriptEngineManager(this.appView.getScriptEngineManager());
                NodeList script = elm.getChildNodes();
                StringBuffer c = new StringBuffer();
                for (int j = 0; j < script.getLength(); ++j) {
                    Node nScript = script.item(j);
                    c.append(nScript.getTextContent());
                }
                String lib = elm.getAttribute("library");
                if (lib != null && lib.trim().length() > 0) {
                    String method = elm.getAttribute("method");
                    for (DRLibrary l : this.appView.getCustomLibraries()) {
                        if (!l.getName().equals(StringUtilities.decodeAttributeValue(lib))) continue;
                        drs.setLibrary(l);
                        if (l.getFunctions().contains(method)) {
                            drs.setFunction(method);
                        } else {
                            l.getFunctions().add(method);
                            drs.setFunction(method);
                        }
                        currentLibrary = l;
                        break;
                    }
                    if (currentLibrary == null) {
                        currentLibrary = new DRLibrary(StringUtilities.decodeAttributeValue(elm.getAttribute("library")), null);
                        currentLibrary.setFunctions(new ArrayList<String>());
                        currentLibrary.setEngine(elm.getAttribute("engine"));
                        currentLibrary.getFunctions().add(StringUtilities.decodeAttributeValue(method));
                        currentLibrary.setScript(c.toString().trim());
                        drs.setFunction(method);
                        drs.setLibrary(currentLibrary);
                        this.appView.getCustomLibraries().add(currentLibrary);
                        this.cbLibrary.removeAllItems();
                        Iterator<String> it1 = this.getLibraries().iterator();
                        while (it1.hasNext()) {
                            this.cbLibrary.addItem(it1.next());
                        }
                    }
                }
                drs.setScript(c.toString().trim());
                loadedScripts.add(drs);
            }
            boolean added = false;
            Iterator it = loadedScripts.iterator();
            while (it.hasNext()) {
                boolean exists = false;
                DRCustomValidationScript o = (DRCustomValidationScript)it.next();
                String currentRuleId = o.getRuleId();
                for (DRCustomScript o1 : this.allCR) {
                    String currentRuleId1 = o1.getRuleId();
                    if (!currentRuleId.equals(currentRuleId1)) {
                        exists = false;
                        continue;
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.allCR.add(o);
                this.customScriptsContainerList.add(o);
                added = true;
            }
            if (added) {
                this.appView.saveCustomDRScripts();
            }
            this.customRulesTable.updateUI();
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to export libraries: ", e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to import custom design rules: ", e);
            JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.ImportError"), Messages.getString("CustomDesignRulesManager.Error"), 0);
        }
    }

    public Action createExportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomDesignRulesManager.Export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    if (CustomDesignRulesManager.this.rulesSaved) {
                        try {
                            URLFilter fileFilter = new URLFilter(){

                                public boolean accept(URL url) {
                                    File file = new File(url.getPath());
                                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                                }

                                public String toString() {
                                    return Messages.getString("CustomDesignRulesManager.XMLFiles");
                                }
                            };
                            URLChooser fileChooser = DialogUtil.newURLChooser();
                            fileChooser.clearChooseableURLFilters();
                            fileChooser.setSelectionScope(0);
                            fileChooser.setSelectionMode(0);
                            fileChooser.setShowJarsAsDirs(false);
                            fileChooser.setURLFilter(fileFilter);
                            if (lastExpFolder != null) {
                                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                            } else {
                                String lastDir = CustomDesignRulesManager.this.getApplicationView().getSettings().getDefaultSavePath();
                                if (lastDir != null && lastDir.length() > 0) {
                                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                                } else {
                                    URL url = CustomDesignRulesManager.this.getApplicationView().getUserHomeDirectory();
                                    if (url != null) {
                                        fileChooser.setSelectedURL(url);
                                    }
                                }
                            }
                            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CustomDesignRulesManager.ExportCDR"));
                            if (status != 0) break block12;
                            String path = fileChooser.getSelectedURL().getPath();
                            int dotPos = path.lastIndexOf(".");
                            if (dotPos > -1) {
                                CustomDesignRulesManager.this.file = new File(path.substring(0, dotPos) + ".xml");
                            } else {
                                CustomDesignRulesManager.this.file = new File(path + ".xml");
                            }
                            if (CustomDesignRulesManager.this.file != null) {
                                lastExpFolder = CustomDesignRulesManager.this.file.getParentFile();
                                FileOpenHistory.getInstance().updateFileHistory(lastExpFolder.toURI().toURL());
                                CustomDesignRulesManager.this.exportCDR();
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error export custom design rules ", ex);
                        }
                    } else {
                        JOptionPane.showMessageDialog(CustomDesignRulesManager.this, Messages.getString("CustomDesignRulesManager.NotSaved"), Messages.getString("CustomDesignRulesManager.Error"), 0);
                    }
                }
            }
        };
        return action;
    }

    public void exportCDR() {
        boolean saveIt = true;
        try {
            int result;
            StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            buffer.append("\n");
            buffer.append("<!-- File contains Custom Validation Scripts -->");
            buffer.append("\n");
            buffer.append("<").append("custom__validation_scripts").append(">");
            for (DRCustomValidationScript drcs : this.customScriptsContainerList) {
                buffer.append("\n");
                buffer.append("\t").append("<").append("scr").append(' ');
                buffer.append("id=\"").append(drcs.getRuleId()).append("\"").append(' ');
                buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(drcs.getName())).append("\"").append(' ');
                buffer.append("object=\"").append(drcs.getObject()).append("\"").append(' ');
                buffer.append("engine=\"").append(drcs.getEngineName()).append("\"").append(' ');
                buffer.append("type=\"").append(drcs.getResultType() != null ? drcs.getResultType() : "").append("\"").append(' ');
                buffer.append("var=\"").append(drcs.getVariable()).append("\"").append(' ');
                buffer.append("library=\"").append(StringUtilities.encodeAttributeValue(drcs.getLibrary() != null ? drcs.getLibrary().getName() : "")).append("\"").append(' ');
                buffer.append("method=\"").append(StringUtilities.encodeAttributeValue(drcs.getFunction())).append("\"").append(' ');
                buffer.append("purpose=\"").append(StringUtilities.encodeAttributeValue(drcs.getPurpose())).append("\"").append(' ');
                buffer.append(">");
                buffer.append("\n");
                buffer.append("\t\t").append("<").append("script").append(">");
                buffer.append("\n");
                buffer.append("\t\t\t").append("<![CDATA[").append(drcs.getScript() != null ? drcs.getScript() : "").append("]]>");
                buffer.append("\n");
                buffer.append("\t\t").append("</").append("script").append(">");
                buffer.append("\n");
                buffer.append("\t").append("</").append("scr").append(">");
            }
            buffer.append("\n");
            buffer.append("</").append("custom__validation_scripts").append(">");
            File f = new File(this.file.toString());
            if (f.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomDesignRulesManager.FileExists"), f), Messages.getString("CustomDesignRulesManager.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                saveIt = false;
            }
            if (saveIt) {
                FileOutputStream fos = new FileOutputStream(f);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(buffer.toString());
                osw.close();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to export libraries: ", e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to export custom design rules: ", e);
        }
    }

    private void nullifyDesignRuleManager() {
        this.getDesign().getAppView().nullifyDesignRuleManager();
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 489944703777167381L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
            } else {
                comp.setBackground(table.getBackground());
                comp.setForeground(table.getForeground());
            }
            if (table.getModel().getValueAt(row, 6).equals("err")) {
                comp.setForeground(Color.RED);
            }
            return comp;
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomDesignRulesManager.this.rulesSaved) {
                if (CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 6).equals("err")) {
                    JOptionPane.showMessageDialog(CustomDesignRulesManager.this, MessageFormat.format(Messages.getString("CustomDesignRulesManager.CannotApply"), CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 1), CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 2), CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 3)), Messages.getString("CustomDesignRulesManager.Error"), 0);
                } else if (CustomDesignRulesManager.this.customRulesTable.getModel().getValueAt(CustomDesignRulesManager.this.customRulesTable.getSelectedRow(), 6).equals("ok")) {
                    ArrayList checkResults = new ArrayList();
                    if (CustomDesignRulesManager.this.customRulesTable.getSelectedRow() > -1 && CustomDesignRulesManager.this.scriptEditor.getText() != null && !CustomDesignRulesManager.this.scriptEditor.getText().trim().equals("")) {
                        DRCustomValidationScript selected = CustomDesignRulesManager.this.customScriptsContainerList.get(CustomDesignRulesManager.this.customRulesTable.getSelectedRow());
                        RuleHandler rh = selected.getRuleHandler();
                        rh.hasEvalErr = false;
                        rh.applyRule(checkResults, selected);
                        CustomDesignRulesManager.this.setCheckResults(checkResults);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(CustomDesignRulesManager.this, Messages.getString("CustomDesignRulesManager.ApplyRuleNotSaved"), Messages.getString("CustomDesignRulesManager.Warning"), 0);
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomDesignRulesManager.this.stopCellediting();
            if (CustomDesignRulesManager.this.canSave()) {
                CustomDesignRulesManager.this.saveSelected();
                ArrayList<DRCustomValidationScript> removalList = new ArrayList<DRCustomValidationScript>();
                for (Object o : CustomDesignRulesManager.this.allCR) {
                    DRCustomValidationScript drcs;
                    if (!(o instanceof DRCustomValidationScript) || !(drcs = (DRCustomValidationScript)o).getPurpose().equals("validation")) continue;
                    removalList.add(drcs);
                }
                for (DRCustomValidationScript cs : CustomDesignRulesManager.this.customScriptsContainerList) {
                    cs.compiledScript = null;
                }
                CustomDesignRulesManager.this.allCR.removeAll(removalList);
                CustomDesignRulesManager.this.allCR.addAll(CustomDesignRulesManager.this.customScriptsContainerList);
                CustomDesignRulesManager.this.getRuleManager().addRemoveCustomRules();
                CustomDesignRulesManager.this.bnSaveRules.setEnabled(false);
                CustomDesignRulesManager.this.bnApply.setEnabled(true);
                CustomDesignRulesManager.this.rulesSaved = true;
                CustomDesignRulesManager.this.appView.saveCustomDRScripts();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = table;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String newValue = tf.getText().trim();
            if (newValue.length() == 0) {
                JOptionPane.showMessageDialog(CustomDesignRulesManager.this, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            TableModel obj = this.tab.getModel();
            for (DRCustomValidationScript cs : ((CustomRuleModel)obj).getCustomRulesContainerList()) {
                if (!cs.getName().equals(newValue) || newValue.equals(this.val)) continue;
                JOptionPane.showMessageDialog(CustomDesignRulesManager.this, Messages.getString("DesignRuleView.NameExists"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            CustomDesignRulesManager.this.currentRule.setScript(CustomDesignRulesManager.this.scriptEditor.getText());
            return super.stopCellEditing();
        }
    }

    private class CustomRuleModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -362794593669886434L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomDesignRulesManager.Name"), Messages.getString("CustomDesignRulesManager.Object"), Messages.getString("CustomDesignRulesManager.Engine"), Messages.getString("CustomDesignRulesManager.Type"), Messages.getString("CustomDesignRulesManager.Variable"), "state"};

        private CustomRuleModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomDesignRulesManager.this.customScriptsContainerList.size();
        }

        public List<DRCustomValidationScript> getCustomRulesContainerList() {
            return CustomDesignRulesManager.this.customScriptsContainerList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || columnIndex == 5) {
                return false;
            }
            return columnIndex != 3 || !this.getValueAt(rowIndex, 6).equals("err");
        }

        @Override
        public Object getValueAt(int row, int col) {
            DRCustomValidationScript cs = CustomDesignRulesManager.this.customScriptsContainerList.get(row);
            String o = cs.getObject();
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return cs.getName();
            }
            if (col == 2) {
                return o;
            }
            if (col == 3) {
                return cs.getEngineName();
            }
            if (col == 4) {
                return cs.getResultType();
            }
            if (col == 5) {
                if (o != null) {
                    return CustomDesignRulesManager.this.mapVariables.get(cs.getObject());
                }
            } else if (col == 6) {
                if (cs.getEngineName() != null) {
                    for (String engineName : CustomDesignRulesManager.this.allEngines) {
                        if (!engineName.equals(cs.getEngineName())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            if (this.getRowCount() > rowIndex) {
                DRCustomValidationScript cs = CustomDesignRulesManager.this.customScriptsContainerList.get(rowIndex);
                if (columnIndex == 1) {
                    cs.setName(obj.toString());
                } else if (columnIndex == 2) {
                    cs.setObject((String)obj);
                    if (obj != null) {
                        cs.setVariable((String)CustomDesignRulesManager.this.mapVariables.get(obj));
                        cs.setRuleHandler((RuleHandler)CustomDesignRulesManager.this.objects.get(obj));
                    }
                } else if (columnIndex == 3) {
                    cs.setEngineName((String)obj);
                } else if (columnIndex == 4) {
                    cs.setResultType((String)obj);
                }
            }
        }
    }
}

