/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomDesignRulesPersistence {
    public static final String DRCS_FILE_NAME = "dr_custom_scripts.xml";
    private ApplicationView appView;
    private static final Logger LOGGER = new Logger(XMLPersistenceManager.class);

    public CustomDesignRulesPersistence(ApplicationView appView) {
        this.appView = appView;
    }

    public void saveCustomDRScripts() {
        Iterator<DRCustomScript> it0 = this.appView.getCustomDesignRules().iterator();
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("dr_custom_scripts").append(">");
        while (it0.hasNext()) {
            DRCustomScript drcs = it0.next();
            buffer.append("\n");
            buffer.append("\t").append("<").append("scr").append(' ');
            buffer.append("id=\"").append(drcs.getRuleId()).append("\"").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(drcs.getName())).append("\"").append(' ');
            buffer.append("object=\"").append(drcs.getObject()).append("\"").append(' ');
            buffer.append("engine=\"").append(drcs.getEngineName()).append("\"").append(' ');
            buffer.append("type=\"").append(drcs.getResultType() != null ? drcs.getResultType() : "").append("\"").append(' ');
            buffer.append("var=\"").append(drcs.getVariable()).append("\"").append(' ');
            buffer.append("library=\"").append(StringUtilities.encodeAttributeValue(drcs.getLibrary() != null ? drcs.getLibrary().getName() : "")).append("\"").append(' ');
            buffer.append("method=\"").append(StringUtilities.encodeAttributeValue(drcs.getFunction() != null ? drcs.getFunction() : "")).append("\"").append(' ');
            buffer.append("purpose=\"").append(StringUtilities.encodeAttributeValue(drcs.getPurpose())).append("\"").append(' ');
            buffer.append(">");
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("script").append(">");
            buffer.append("\n");
            buffer.append("\t\t\t").append("<![CDATA[").append(drcs.getScript() != null ? drcs.getScript() : "").append("]]>");
            buffer.append("\n");
            buffer.append("\t\t").append("</").append("script").append(">");
            buffer.append("\n");
            buffer.append("\t").append("</").append("scr").append(">");
        }
        Iterator<DRLibrary> it1 = this.appView.getCustomLibraries().iterator();
        buffer.append("\n");
        while (it1.hasNext()) {
            DRLibrary lib = it1.next();
            buffer.append("\n");
            buffer.append("\t").append("<").append("lib").append(' ');
            buffer.append("id=\"").append(lib.getLibraryId()).append("\"").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(lib.getName())).append("\"").append(' ');
            buffer.append("engine=\"").append(lib.getEngine()).append("\"").append(' ');
            Iterator<String> it3 = lib.getFunctions().iterator();
            StringBuffer f = new StringBuffer();
            while (it3.hasNext()) {
                f.append("," + it3.next());
            }
            buffer.append("methods=\"").append(StringUtilities.encodeAttributeValue(f.toString()).replaceFirst(",", "")).append("\"").append(' ');
            buffer.append(">");
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("script").append(">");
            buffer.append("\n");
            buffer.append("\t\t\t").append("<![CDATA[").append(lib.getScript()).append("]]>");
            buffer.append("\n");
            buffer.append("\t\t").append("</").append("script").append(">");
            buffer.append("\n");
            buffer.append("\t").append("</").append("lib").append(">");
        }
        buffer.append("\n");
        buffer.append("</").append("dr_custom_scripts").append(">");
        this.saveData(buffer);
    }

    private void saveData(StringBuffer buffer) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(XMLTransformationManager.getDefaultSystemTypesPath(), DRCS_FILE_NAME));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
        }
        catch (Exception e) {
            LOGGER.error("Unable to save Design Rule Custom Scripts: ", e);
        }
    }

    public void loadCustomDRScripts(Settings settings) {
        try {
            File file = new File(XMLTransformationManager.getDefaultSystemTypesPath(settings), DRCS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(doc);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load Design Rule Custom Scripts: ", e);
        }
    }

    private void loadData(Document doc) {
        ArrayList<DRLibrary> loadedLibraries = new ArrayList<DRLibrary>();
        NodeList nodes1 = doc.getElementsByTagName("lib");
        int nodesLength1 = nodes1.getLength();
        for (int i = 0; i < nodesLength1; ++i) {
            Element elm = (Element)nodes1.item(i);
            DRLibrary lib = new DRLibrary(elm.getAttribute(StringUtilities.decodeAttributeValue("name")), elm.getAttribute("id"));
            lib.setEngine(elm.getAttribute("engine"));
            lib.setFunctions(new ArrayList<String>());
            lib.setScriptEngineManager(this.appView.getScriptEngineManager());
            StringTokenizer st = new StringTokenizer(StringUtilities.decodeAttributeValue(elm.getAttribute("methods")), ",");
            while (st.hasMoreTokens()) {
                lib.getFunctions().add(st.nextToken());
            }
            NodeList script = elm.getChildNodes();
            StringBuffer c = new StringBuffer();
            for (int j = 0; j < script.getLength(); ++j) {
                Node nScript = script.item(j);
                c.append(nScript.getTextContent());
            }
            lib.setScript(c.toString().trim());
            loadedLibraries.add(lib);
        }
        this.appView.getCustomLibraries().clear();
        this.appView.getCustomLibraries().addAll(loadedLibraries);
        ArrayList<DRCustomScript> loadedScripts = new ArrayList<DRCustomScript>();
        NodeList nodes = doc.getElementsByTagName("scr");
        int nodesLength = nodes.getLength();
        for (int i = 0; i < nodesLength; ++i) {
            Node nScript;
            int j;
            StringBuffer c;
            NodeList script;
            DRCustomScript drs;
            Element elm = (Element)nodes.item(i);
            String purpose = elm.getAttribute("purpose");
            if (purpose.equals("transformation")) {
                drs = new DRCustomScript(elm.getAttribute(StringUtilities.decodeAttributeValue("name")), elm.getAttribute("id"), elm.getAttribute("purpose"));
                drs.setObject(elm.getAttribute("object"));
                drs.setEngineName(elm.getAttribute("engine"));
                drs.setResultType(elm.getAttribute("type"));
                drs.setVariable(elm.getAttribute("var"));
                for (DRLibrary l : this.appView.getCustomLibraries()) {
                    if (!l.getName().equals(StringUtilities.decodeAttributeValue(elm.getAttribute("library")))) continue;
                    drs.setLibrary(l);
                    break;
                }
                drs.setFunction(StringUtilities.decodeAttributeValue(elm.getAttribute("method")));
                drs.setScriptEngineManager(this.appView.getScriptEngineManager());
                script = elm.getChildNodes();
                c = new StringBuffer();
                for (j = 0; j < script.getLength(); ++j) {
                    nScript = script.item(j);
                    c.append(nScript.getTextContent());
                }
                drs.setScript(c.toString().trim());
                loadedScripts.add(drs);
                continue;
            }
            if (!purpose.equals("validation")) continue;
            drs = new DRCustomValidationScript(elm.getAttribute(StringUtilities.decodeAttributeValue("name")), elm.getAttribute("id"), elm.getAttribute("purpose"));
            drs.setObject(elm.getAttribute("object"));
            drs.setEngineName(elm.getAttribute("engine"));
            drs.setResultType(elm.getAttribute("type"));
            drs.setVariable(elm.getAttribute("var"));
            for (DRLibrary l : this.appView.getCustomLibraries()) {
                if (!l.getName().equals(StringUtilities.decodeAttributeValue(elm.getAttribute("library")))) continue;
                drs.setLibrary(l);
                break;
            }
            drs.setFunction(StringUtilities.decodeAttributeValue(elm.getAttribute("method")));
            drs.setScriptEngineManager(this.appView.getScriptEngineManager());
            script = elm.getChildNodes();
            c = new StringBuffer();
            for (j = 0; j < script.getLength(); ++j) {
                nScript = script.item(j);
                c.append(nScript.getTextContent());
            }
            drs.setScript(c.toString().trim());
            loadedScripts.add(drs);
        }
        this.appView.getCustomDesignRules().clear();
        this.appView.getCustomDesignRules().addAll(loadedScripts);
    }

    public Element getFirstElementByTagName(String tag, Element element) {
        NodeList nodes = element.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            Element elem = (Element)nodes.item(0);
            return elem;
        }
        return null;
    }
}

