/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomLibrariesManager
extends CustomDialog {
    private static final long serialVersionUID = 1284535107187895237L;
    private final String LIB_NAME = "Lib";
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JDialog dialog;
    private JSplitPane mainPanel;
    public List<DRLibrary> customLibrariesContainerList;
    public ArrayList<String> methodsList;
    private JTable librariesTable;
    private JTable methodsTable;
    private JButton btnAddLib;
    private JButton btnRemoveLib;
    private JButton btnAddMethod;
    private JButton btnRemoveMethod;
    private int cgCounter = 0;
    private RSyntaxTextArea scriptEditor;
    private ApplicationView appView;
    private JButton bnSave;
    private JButton bnClose;
    private JButton bnImport;
    private JButton bnExport;
    private DRLibrary currentLibrary;
    private boolean saved = true;
    private File file;
    private JComboBox engCombo;
    private boolean noRowSelectedState;
    private JPanel np;
    private JPanel sp;
    private ArrayList allEngines;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    ArrayList<DRLibrary> allLibraries;
    private static final Logger LOGGER = new Logger(CustomLibrariesManager.class);

    public CustomLibrariesManager(ApplicationView appView) {
        super(appView);
        this.appView = appView;
        this.allEngines = appView.getScriptEngines();
        this.allLibraries = appView.getCustomLibraries();
        this.init();
        this.loadLibraries();
    }

    private void init() {
        this.np = new JPanel(new BorderLayout());
        this.sp = new JPanel(new BorderLayout());
        this.mainPanel = new JSplitPane(0, this.np, this.sp);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setDividerLocation(200);
        this.initNorthPanel();
        this.initSouthPanel();
        this.initButtonsPanel();
    }

    private void initNorthPanel() {
        this.customLibrariesContainerList = new ArrayList<DRLibrary>();
        this.librariesTable = new JTable(new CustomRuleModel());
        this.librariesTable.setSelectionMode(0);
        this.librariesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        JScrollPane scrollPane = new JScrollPane(this.librariesTable);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        TableColumn col0 = this.librariesTable.getColumnModel().getColumn(0);
        col0.setWidth(30);
        col0.setMaxWidth(30);
        JTextField tf = new JTextField();
        TableColumn col1 = this.librariesTable.getColumnModel().getColumn(1);
        col1.setWidth(220);
        col1.setMaxWidth(1000);
        col1.setCellEditor(new TFCellEditor(tf));
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.allEngines.toArray()));
        TableColumn col2 = this.librariesTable.getColumnModel().getColumn(2);
        col2.setWidth(170);
        col2.setMaxWidth(170);
        col2.setCellEditor(new DefaultCellEditor(this.engCombo));
        TableColumn col3 = this.librariesTable.getColumnModel().getColumn(3);
        this.librariesTable.getColumnModel().removeColumn(col3);
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                CustomLibrariesManager.this.saved = false;
                CustomLibrariesManager.this.bnSave.setEnabled(true);
            }
        });
        this.engCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String oldValue = (String)CustomLibrariesManager.this.librariesTable.getValueAt(CustomLibrariesManager.this.librariesTable.getSelectedRow(), 2);
                String newValue = (String)CustomLibrariesManager.this.engCombo.getSelectedItem();
                if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    CustomLibrariesManager.this.bnSave.setEnabled(true);
                    CustomLibrariesManager.this.saved = false;
                }
            }
        });
        this.librariesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selRow = CustomLibrariesManager.this.librariesTable.getSelectedRow();
                    if (selRow == -1) {
                        CustomLibrariesManager.this.btnRemoveLib.setEnabled(false);
                        CustomLibrariesManager.this.btnAddMethod.setEnabled(false);
                        CustomLibrariesManager.this.btnRemoveMethod.setEnabled(false);
                        if (e.getValueIsAdjusting()) {
                            CustomLibrariesManager.this.stopCellediting();
                            CustomLibrariesManager.this.methodsList.clear();
                            CustomLibrariesManager.this.methodsTable.updateUI();
                            CustomLibrariesManager.this.noRowSelectedState = true;
                        }
                        CustomLibrariesManager.this.scriptEditor.setEnabled(false);
                        CustomLibrariesManager.this.bnSave.setEnabled(false);
                        CustomLibrariesManager.this.methodsTable.clearSelection();
                        CustomLibrariesManager.this.methodsTable.setEnabled(false);
                    } else {
                        CustomLibrariesManager.this.btnRemoveLib.setEnabled(true);
                        CustomLibrariesManager.this.btnAddMethod.setEnabled(true);
                        if (CustomLibrariesManager.this.currentLibrary != null && !CustomLibrariesManager.this.noRowSelectedState) {
                            CustomLibrariesManager.this.stopCellediting();
                        }
                        CustomLibrariesManager.this.currentLibrary = ((CustomRuleModel)CustomLibrariesManager.this.librariesTable.getModel()).getCustomRulesContainerList().get(selRow);
                        CustomLibrariesManager.this.methodsList.clear();
                        CustomLibrariesManager.this.methodsList.addAll(CustomLibrariesManager.this.currentLibrary.getFunctions());
                        CustomLibrariesManager.this.methodsTable.getSelectionModel().setSelectionInterval(0, 0);
                        CustomLibrariesManager.this.btnRemoveMethod.setEnabled(CustomLibrariesManager.this.methodsList.size() > 0);
                        CustomLibrariesManager.this.methodsTable.updateUI();
                        CustomLibrariesManager.this.scriptEditor.setText("");
                        CustomLibrariesManager.this.scriptEditor.setText(CustomLibrariesManager.this.customLibrariesContainerList.get(selRow).getScript());
                        if (CustomLibrariesManager.this.currentLibrary != null) {
                            String ename = CustomLibrariesManager.this.currentLibrary.getEngine();
                            if (ename != null) {
                                ename = ename.toUpperCase();
                            }
                            if (ename != null && ename.indexOf("RHINO") > -1) {
                                CustomLibrariesManager.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                            } else if (ename != null && ename.indexOf("RUBY") > -1) {
                                CustomLibrariesManager.this.scriptEditor.setSyntaxEditingStyle("text/ruby");
                            } else {
                                CustomLibrariesManager.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                            }
                        }
                        CustomLibrariesManager.this.scriptEditor.setCaretPosition(0);
                        CustomLibrariesManager.this.scriptEditor.setCaretPosition(0);
                        CustomLibrariesManager.this.scriptEditor.setEnabled(true);
                        CustomLibrariesManager.this.noRowSelectedState = false;
                        CustomLibrariesManager.this.methodsTable.setEnabled(true);
                        CustomLibrariesManager.this.bnSave.setEnabled(!CustomLibrariesManager.this.saved);
                    }
                }
            }
        });
        this.np.add((Component)this.createScriptToolbarPanel(), "North");
        this.np.add((Component)scrollPane, "Center");
    }

    private void initSouthPanel() {
        this.scriptEditor = new RSyntaxTextArea();
        this.scriptEditor.setSyntaxEditingStyle("text/javascript");
        this.scriptEditor.setCodeFoldingEnabled(true);
        this.scriptEditor.setAntiAliasingEnabled(true);
        this.scriptEditor.setHyperlinksEnabled(true);
        this.scriptEditor.setEnabled(false);
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(e.getURL().toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.scriptEditor.addHyperlinkListener(listener);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        RTextScrollPane scrollPaneSE = new RTextScrollPane((RTextArea)this.scriptEditor);
        scrollPaneSE.setBorder((Border)BorderFactory.createTitledBorder(Messages.getString("CustomLibrariesManager.Script")));
        scrollPaneSE.setPreferredSize(new Dimension(300, 620));
        this.sp.add((Component)scrollPaneSE, "Center");
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomLibrariesManager.Functions")));
        this.methodsList = new ArrayList();
        this.methodsTable = new JTable(new FunctionModel());
        this.methodsTable.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.methodsTable);
        scrollPane.setPreferredSize(new Dimension(80, 100));
        TableColumn col0 = this.methodsTable.getColumnModel().getColumn(0);
        col0.setWidth(30);
        col0.setMaxWidth(30);
        JTextField tf = new JTextField();
        TableColumn col1 = this.methodsTable.getColumnModel().getColumn(1);
        col1.setWidth(50);
        col1.setMaxWidth(1000);
        col1.setCellEditor(new TFCellEditor(tf));
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                CustomLibrariesManager.this.saved = false;
                CustomLibrariesManager.this.bnSave.setEnabled(true);
            }
        });
        this.methodsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = CustomLibrariesManager.this.methodsTable.getSelectedRow();
                if (selRow == -1) {
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(false);
                    CustomLibrariesManager.this.scriptEditor.setEnabled(false);
                    CustomLibrariesManager.this.bnSave.setEnabled(false);
                } else {
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(true);
                    CustomLibrariesManager.this.scriptEditor.setEnabled(true);
                    CustomLibrariesManager.this.bnSave.setEnabled(true);
                }
            }
        });
        p.add((Component)this.createFunctionsToolbarPanel(), "North");
        p.add((Component)scrollPane, "Center");
        this.sp.add((Component)p, "West");
    }

    private void initButtonsPanel() {
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnSave = new JButton(Messages.getString("CustomLibrariesManager.Save"));
        this.bnSave.setToolTipText(Messages.getString("CustomLibrariesManager.SaveTooltip"));
        this.bnSave.setEnabled(false);
        this.bnSave.addActionListener(new SaveAction());
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnSave.setMnemonic(83);
        btnPanel.add(this.bnSave);
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setToolTipText(Messages.getString("CustomLibrariesManager.ImportTooltip"));
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnImport);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setToolTipText(Messages.getString("CustomLibrariesManager.ExportTooltip"));
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnExport);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setToolTipText(Messages.getString("CustomLibrariesManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        btnPanel.add(this.bnClose);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setToolTipText(Messages.getString("CustomLibrariesManager.HelpTooltip"));
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(bnHelp);
        this.sp.add((Component)btnPanel, "South");
    }

    protected JPanel createScriptToolbarPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnAddLib = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddLib.setToolTipText(Messages.getString("CustomLibrariesManager.AddLibrary"));
        this.btnAddLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DRLibrary lib = new DRLibrary(CustomLibrariesManager.this.generateLibraryName(), null);
                lib.setScriptEngineManager(CustomLibrariesManager.this.appView.getScriptEngineManager());
                lib.setFunctions(new ArrayList<String>());
                CustomLibrariesManager.this.customLibrariesContainerList.add(lib);
                CustomLibrariesManager.this.librariesTable.updateUI();
                CustomLibrariesManager.this.librariesTable.getSelectionModel().setSelectionInterval(CustomLibrariesManager.this.librariesTable.getRowCount() - 1, CustomLibrariesManager.this.librariesTable.getRowCount() - 1);
                CustomLibrariesManager.this.librariesTable.scrollRectToVisible(new Rectangle(CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth() * CustomLibrariesManager.this.librariesTable.getSelectedColumn(), CustomLibrariesManager.this.librariesTable.getRowHeight() * CustomLibrariesManager.this.librariesTable.getSelectedRow(), CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth(), CustomLibrariesManager.this.librariesTable.getRowHeight()));
                CustomLibrariesManager.this.btnRemoveLib.setEnabled(true);
                CustomLibrariesManager.this.btnAddMethod.setEnabled(true);
                CustomLibrariesManager.this.scriptEditor.setEnabled(true);
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        this.btnRemoveLib = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveLib.setToolTipText(Messages.getString("CustomLibrariesManager.RemoveLibrary"));
        this.btnRemoveLib.setEnabled(false);
        this.btnRemoveLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CustomLibrariesManager.this.librariesTable.getSelectedRow();
                CustomLibrariesManager.this.customLibrariesContainerList.remove(selected);
                CustomLibrariesManager.this.librariesTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomLibrariesManager.this.librariesTable.scrollRectToVisible(new Rectangle(CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth() * CustomLibrariesManager.this.librariesTable.getSelectedColumn(), CustomLibrariesManager.this.librariesTable.getRowHeight() * CustomLibrariesManager.this.librariesTable.getSelectedRow(), CustomLibrariesManager.this.librariesTable.getColumnModel().getColumn(1).getWidth(), CustomLibrariesManager.this.librariesTable.getRowHeight()));
                CustomLibrariesManager.this.librariesTable.updateUI();
                CustomLibrariesManager.this.btnRemoveLib.setEnabled(CustomLibrariesManager.this.customLibrariesContainerList.size() > 0);
                if (CustomLibrariesManager.this.customLibrariesContainerList.size() == 0) {
                    CustomLibrariesManager.this.scriptEditor.setText("");
                    CustomLibrariesManager.this.methodsList.clear();
                    CustomLibrariesManager.this.methodsTable.updateUI();
                    CustomLibrariesManager.this.btnAddMethod.setEnabled(false);
                    CustomLibrariesManager.this.btnRemoveMethod.setEnabled(false);
                } else if (CustomLibrariesManager.this.customLibrariesContainerList.size() > 0) {
                    CustomLibrariesManager.this.currentLibrary = ((CustomRuleModel)CustomLibrariesManager.this.librariesTable.getModel()).getCustomRulesContainerList().get(CustomLibrariesManager.this.librariesTable.getSelectedRow());
                    CustomLibrariesManager.this.scriptEditor.setText("");
                    CustomLibrariesManager.this.scriptEditor.setText(CustomLibrariesManager.this.currentLibrary.getScript());
                    CustomLibrariesManager.this.scriptEditor.setCaretPosition(0);
                    CustomLibrariesManager.this.methodsList.clear();
                    CustomLibrariesManager.this.methodsList.addAll(CustomLibrariesManager.this.currentLibrary.getFunctions());
                    CustomLibrariesManager.this.methodsTable.updateUI();
                }
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        toolBar.add(this.btnAddLib);
        toolBar.add(this.btnRemoveLib);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    protected JPanel createFunctionsToolbarPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnAddMethod = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddMethod.setEnabled(false);
        this.btnAddMethod.setToolTipText(Messages.getString("CustomLibrariesManager.AddFunction"));
        this.btnAddMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomLibrariesManager.this.methodsList.add("");
                CustomLibrariesManager.this.methodsTable.getSelectionModel().setSelectionInterval(CustomLibrariesManager.this.methodsTable.getRowCount() - 1, CustomLibrariesManager.this.methodsTable.getRowCount() - 1);
                CustomLibrariesManager.this.methodsTable.scrollRectToVisible(new Rectangle(CustomLibrariesManager.this.methodsTable.getColumnModel().getColumn(1).getWidth() * CustomLibrariesManager.this.methodsTable.getSelectedColumn(), CustomLibrariesManager.this.methodsTable.getRowHeight() * CustomLibrariesManager.this.methodsTable.getSelectedRow(), CustomLibrariesManager.this.methodsTable.getColumnModel().getColumn(1).getWidth(), CustomLibrariesManager.this.methodsTable.getRowHeight()));
                CustomLibrariesManager.this.methodsTable.updateUI();
                CustomLibrariesManager.this.btnRemoveMethod.setEnabled(true);
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        this.btnRemoveMethod = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveMethod.setToolTipText(Messages.getString("CustomLibrariesManager.RemoveFunction"));
        this.btnRemoveMethod.setEnabled(false);
        this.btnRemoveMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String current = "";
                int[] selected = CustomLibrariesManager.this.methodsTable.getSelectedRows();
                ArrayList<String> tempList = new ArrayList<String>();
                for (int i = 0; i < selected.length; ++i) {
                    current = CustomLibrariesManager.this.methodsList.get(selected[i]);
                    tempList.add(current);
                }
                CustomLibrariesManager.this.methodsList.removeAll(tempList);
                CustomLibrariesManager.this.btnRemoveMethod.setEnabled(CustomLibrariesManager.this.methodsList.size() > 0);
                CustomLibrariesManager.this.methodsTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomLibrariesManager.this.methodsTable.updateUI();
                CustomLibrariesManager.this.bnSave.setEnabled(true);
                CustomLibrariesManager.this.saved = false;
            }
        });
        toolBar.add(this.btnAddMethod);
        toolBar.add(this.btnRemoveMethod);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    protected String generateLibraryName() {
        String name = "Lib";
        int newNumber = 0;
        int lastNumber = this.customLibrariesContainerList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String ruleName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.xists(ruleName)) {
            newNumber = ++this.cgCounter;
            ruleName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return ruleName;
    }

    private boolean xists(String name) {
        for (int i = 0; i < this.customLibrariesContainerList.size(); ++i) {
            DRLibrary rule = this.customLibrariesContainerList.get(i);
            if (!name.equalsIgnoreCase(rule.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomLibrariesManager.Libraries"), false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 600);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOM_LIBRARIES_DIALOG";
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action closeAction() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomLibrariesManager.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomLibrariesManager.this.canClose()) {
                    CustomLibrariesManager.this.close();
                }
            }
        };
        return action;
    }

    protected boolean canSave() {
        if (this.customLibrariesContainerList.size() > 0) {
            if (this.librariesTable.getModel().getValueAt(this.librariesTable.getSelectedRow(), 2) == null) {
                JOptionPane.showMessageDialog(this, Messages.getString("CustomLibrariesManager.NoEngineChosen"), Messages.getString("CustomLibrariesManager.Warning"), 2);
                return false;
            }
            if (this.scriptEditor.getText().trim().length() == 0 || this.scriptEditor.getText() == null) {
                JOptionPane.showMessageDialog(this, Messages.getString("CustomLibrariesManager.NoScript"), Messages.getString("CustomLibrariesManager.Warning"), 2);
                return false;
            }
            for (String value : this.methodsList) {
                if (value != null && value.length() != 0) continue;
                JOptionPane.showMessageDialog(this, Messages.getString("CustomLibrariesManager.NoFunctionName"), Messages.getString("CustomLibrariesManager.Warning"), 2);
                return false;
            }
            for (DRLibrary drcs : this.customLibrariesContainerList) {
                boolean flagEmptyName = false;
                for (String value : drcs.getFunctions()) {
                    if (value != null && value.length() != 0) continue;
                    flagEmptyName = true;
                }
                if (drcs.getEngine() != null && drcs.getScript().trim().length() != 0 && !flagEmptyName) continue;
                JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("CustomLibrariesManager.NoEngineScriptFN"), drcs.getName()), Messages.getString("CustomLibrariesManager.NoScript"), 2);
                return false;
            }
        }
        return true;
    }

    private void loadLibraries() {
        Iterator<DRLibrary> it = this.allLibraries.iterator();
        this.customLibrariesContainerList.clear();
        while (it.hasNext()) {
            DRLibrary drcs = it.next().copy();
            this.customLibrariesContainerList.add(drcs);
        }
        if (this.customLibrariesContainerList.size() > 0) {
            this.librariesTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.librariesTable.updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomLibrariesManager.this.librariesTable.getRowCount(); ++i) {
                    if (!CustomLibrariesManager.this.librariesTable.getModel().getValueAt(i, 3).equals("err")) continue;
                    JOptionPane.showMessageDialog(CustomLibrariesManager.this, Messages.getString("CustomLibrariesManager.MissingEngine"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    break;
                }
            }
        });
    }

    @Override
    protected boolean canClose() {
        if (!this.saved) {
            String s1 = Messages.getString("CustomLibrariesManager.Yes");
            String s2 = Messages.getString("CustomLibrariesManager.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("CustomLibrariesManager.NotSaved"), Messages.getString("CustomLibrariesManager.CloseConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    private void stopCellediting() {
        TableCellEditor cellEditor1;
        this.currentLibrary.setScript(this.scriptEditor.getText());
        TableCellEditor cellEditor = this.librariesTable.getCellEditor();
        if (cellEditor != null) {
            this.librariesTable.getCellEditor().stopCellEditing();
        }
        if ((cellEditor1 = this.methodsTable.getCellEditor()) != null) {
            this.methodsTable.getCellEditor().stopCellEditing();
        }
        this.currentLibrary.getFunctions().clear();
        Iterator<String> it = this.methodsList.iterator();
        while (it.hasNext()) {
            this.currentLibrary.getFunctions().add(it.next());
        }
    }

    public Action createImportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomLibrariesManager.Import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("CustomLibrariesManager.XMLFiles");
                        }
                    };
                    URLChooser fileChooser = DialogUtil.newURLChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    if (lastImpFolder != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                    } else {
                        String lastDir = CustomLibrariesManager.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = CustomLibrariesManager.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("CustomLibrariesManager.ImportLibraries"));
                    if (status == 0) {
                        CustomLibrariesManager.this.file = new File(fileChooser.getSelectedURL().getPath());
                        if (CustomLibrariesManager.this.file != null) {
                            lastImpFolder = CustomLibrariesManager.this.file.getParentFile();
                            FileOpenHistory.getInstance().updateFileHistory(lastImpFolder.toURI().toURL());
                            try {
                                int ch;
                                StringBuffer buffer = new StringBuffer();
                                FileInputStream fis = new FileInputStream(CustomLibrariesManager.this.file);
                                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                BufferedReader in = new BufferedReader(isr);
                                while ((ch = ((Reader)in).read()) > -1) {
                                    buffer.append((char)ch);
                                }
                                ((Reader)in).close();
                                CustomLibrariesManager.this.importLib(buffer.toString());
                            }
                            catch (Exception ex) {
                                LOGGER.error("Unable to load libraries from imported file: ", ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error import libraries ", ex);
                }
            }
        };
        return action;
    }

    public void importLib(String str) {
        try {
            StringReader sr = new StringReader(str);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(sr);
            Document doc = builder.parse(inputSource);
            ArrayList<DRLibrary> loadedLibraries = new ArrayList<DRLibrary>();
            NodeList nodes1 = doc.getElementsByTagName("lib");
            int nodesLength1 = nodes1.getLength();
            for (int i = 0; i < nodesLength1; ++i) {
                Element elm = (Element)nodes1.item(i);
                DRLibrary lib = new DRLibrary(elm.getAttribute(StringUtilities.decodeAttributeValue("name")), elm.getAttribute("id"));
                lib.setEngine(elm.getAttribute("engine"));
                lib.setFunctions(new ArrayList<String>());
                lib.setScriptEngineManager(this.appView.getScriptEngineManager());
                StringTokenizer st = new StringTokenizer(StringUtilities.decodeAttributeValue(elm.getAttribute("methods")), ",");
                while (st.hasMoreTokens()) {
                    lib.getFunctions().add(st.nextToken());
                }
                NodeList script = elm.getChildNodes();
                StringBuffer c = new StringBuffer();
                for (int j = 0; j < script.getLength(); ++j) {
                    Node nScript = script.item(j);
                    c.append(nScript.getTextContent());
                }
                lib.setScript(c.toString().trim());
                loadedLibraries.add(lib);
            }
            boolean added = false;
            Iterator it = loadedLibraries.iterator();
            while (it.hasNext()) {
                boolean exists = false;
                DRLibrary o = (DRLibrary)it.next();
                String currentLibId = o.getLibraryId();
                for (DRLibrary o1 : this.allLibraries) {
                    String currentLibId1 = o1.getLibraryId();
                    if (!currentLibId.equals(currentLibId1)) {
                        exists = false;
                        continue;
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.allLibraries.add(o);
                this.customLibrariesContainerList.add(o);
                added = true;
            }
            if (added) {
                this.appView.saveCustomDRScripts();
            }
            this.librariesTable.updateUI();
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to export libraries: ", e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to import custom libraries: ", e);
            JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.ImportError"), Messages.getString("CustomDesignRulesManager.Error"), 0);
        }
    }

    public Action createExportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomLibrariesManager.Export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    if (CustomLibrariesManager.this.saved) {
                        try {
                            URLFilter fileFilter = new URLFilter(){

                                public boolean accept(URL url) {
                                    File file = new File(url.getPath());
                                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                                }

                                public String toString() {
                                    return Messages.getString("CustomLibrariesManager.XMLFiles");
                                }
                            };
                            URLChooser fileChooser = DialogUtil.newURLChooser();
                            fileChooser.clearChooseableURLFilters();
                            fileChooser.setSelectionScope(0);
                            fileChooser.setSelectionMode(0);
                            fileChooser.setShowJarsAsDirs(false);
                            fileChooser.setURLFilter(fileFilter);
                            if (lastExpFolder != null) {
                                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                            } else {
                                String lastDir = CustomLibrariesManager.this.getApplicationView().getSettings().getDefaultSavePath();
                                if (lastDir != null && lastDir.length() > 0) {
                                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                                } else {
                                    URL url = CustomLibrariesManager.this.getApplicationView().getUserHomeDirectory();
                                    if (url != null) {
                                        fileChooser.setSelectedURL(url);
                                    }
                                }
                            }
                            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CustomLibrariesManager.ExportLibraries"));
                            if (status != 0) break block12;
                            String path = fileChooser.getSelectedURL().getPath();
                            int dotPos = path.lastIndexOf(".");
                            if (dotPos > -1) {
                                CustomLibrariesManager.this.file = new File(path.substring(0, dotPos) + ".xml");
                            } else {
                                CustomLibrariesManager.this.file = new File(path + ".xml");
                            }
                            if (CustomLibrariesManager.this.file != null) {
                                lastExpFolder = CustomLibrariesManager.this.file.getParentFile();
                                FileOpenHistory.getInstance().updateFileHistory(lastExpFolder.toURI().toURL());
                                CustomLibrariesManager.this.exportLib();
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error export custom libraries ", ex);
                        }
                    } else {
                        JOptionPane.showMessageDialog(CustomLibrariesManager.this, Messages.getString("CustomLibrariesManager.NotSavedBeforeExport"), Messages.getString("CustomLibrariesManager.Error"), 0);
                    }
                }
            }
        };
        return action;
    }

    public void exportLib() {
        boolean saveIt = true;
        try {
            int result;
            StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            buffer.append("\n");
            buffer.append("<!-- File contains Custom Libraries Scripts -->");
            buffer.append("\n");
            buffer.append("<").append("custom_libraries").append(">");
            for (DRLibrary lib : this.customLibrariesContainerList) {
                buffer.append("\n");
                buffer.append("\t").append("<").append("lib").append(' ');
                buffer.append("id=\"").append(lib.getLibraryId()).append("\"").append(' ');
                buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(lib.getName())).append("\"").append(' ');
                buffer.append("engine=\"").append(lib.getEngine()).append("\"").append(' ');
                Iterator<String> it3 = lib.getFunctions().iterator();
                StringBuffer f = new StringBuffer();
                while (it3.hasNext()) {
                    f.append("," + it3.next());
                }
                buffer.append("methods=\"").append(StringUtilities.encodeAttributeValue(f.toString()).replaceFirst(",", "")).append("\"").append(' ');
                buffer.append(">");
                buffer.append("\n");
                buffer.append("\t\t").append("<").append("script").append(">");
                buffer.append("\n");
                buffer.append("\t\t\t").append("<![CDATA[").append(lib.getScript()).append("]]>");
                buffer.append("\n");
                buffer.append("\t\t").append("</").append("script").append(">");
                buffer.append("\n");
                buffer.append("\t").append("</").append("lib").append(">");
            }
            buffer.append("\n");
            buffer.append("</").append("custom_libraries").append(">");
            if (this.file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomLibrariesManager.FileExists"), this.file), Messages.getString("CustomLibrariesManager.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                saveIt = false;
            }
            if (saveIt) {
                FileOutputStream fos = new FileOutputStream(this.file);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(buffer.toString());
                osw.close();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to export libraries: ", e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to export libraries: ", e);
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -3166272761720379941L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color fc = null;
            if (table.getModel().getValueAt(row, 3).equals("err")) {
                fc = Color.RED;
            }
            comp.setForeground(fc);
            return comp;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomLibrariesManager.this.stopCellediting();
            if (CustomLibrariesManager.this.canSave()) {
                for (DRLibrary lib : CustomLibrariesManager.this.customLibrariesContainerList) {
                    String libId = lib.getLibraryId();
                    for (DRCustomScript cs : CustomLibrariesManager.this.appView.getCustomDesignRules()) {
                        if (cs.getLibrary() == null || !cs.getLibrary().getLibraryId().equalsIgnoreCase(libId)) continue;
                        cs.setLibrary(lib);
                    }
                }
                CustomLibrariesManager.this.allLibraries.clear();
                CustomLibrariesManager.this.allLibraries.addAll(CustomLibrariesManager.this.customLibrariesContainerList);
                CustomLibrariesManager.this.bnSave.setEnabled(false);
                CustomLibrariesManager.this.saved = true;
                CustomLibrariesManager.this.appView.saveCustomDRScripts();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = table;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String newValue = tf.getText().trim();
            if (newValue.length() == 0) {
                JOptionPane.showMessageDialog(CustomLibrariesManager.this, Messages.getString("DesignRuleView.NameEmpty"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            int dCount = 0;
            TableModel obj = this.tab.getModel();
            if (obj instanceof CustomRuleModel) {
                for (DRLibrary cs : ((CustomRuleModel)obj).getCustomRulesContainerList()) {
                    if (!cs.getName().equals(newValue) || newValue.equals(this.val)) continue;
                    ++dCount;
                    JOptionPane.showMessageDialog(CustomLibrariesManager.this, Messages.getString("DesignRuleView.NameExists"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    tf.setText(this.val);
                    tf.setBorder(new LineBorder(Color.black));
                    tf.requestFocusInWindow();
                    return false;
                }
            } else if (obj instanceof FunctionModel) {
                for (String s : ((FunctionModel)obj).getFunctionsContainerList()) {
                    if (!s.equals(newValue) || newValue.equals(this.val)) continue;
                    ++dCount;
                    JOptionPane.showMessageDialog(CustomLibrariesManager.this, Messages.getString("DesignRuleView.NameExists"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    tf.setText(this.val);
                    tf.setBorder(new LineBorder(Color.black));
                    tf.requestFocusInWindow();
                    return false;
                }
            }
            CustomLibrariesManager.this.currentLibrary.setScript(CustomLibrariesManager.this.scriptEditor.getText());
            return super.stopCellEditing();
        }
    }

    private class FunctionModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5810038160110518939L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomDesignRulesManager.Name")};

        private FunctionModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomLibrariesManager.this.methodsList.size();
        }

        public List<String> getFunctionsContainerList() {
            return CustomLibrariesManager.this.methodsList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            String s = CustomLibrariesManager.this.methodsList.get(row);
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return s;
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                CustomLibrariesManager.this.methodsList.set(rowIndex, (String)obj);
            }
        }
    }

    private class CustomRuleModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5810038160110518939L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomDesignRulesManager.Name"), Messages.getString("CustomDesignRulesManager.Engine"), "state"};

        private CustomRuleModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomLibrariesManager.this.customLibrariesContainerList.size();
        }

        public List<DRLibrary> getCustomRulesContainerList() {
            return CustomLibrariesManager.this.customLibrariesContainerList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return false;
            }
            return columnIndex != 2 || !this.getValueAt(rowIndex, 3).equals("err");
        }

        @Override
        public Object getValueAt(int row, int col) {
            DRLibrary obj = CustomLibrariesManager.this.customLibrariesContainerList.get(row);
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return obj.getName();
            }
            if (col == 2) {
                return obj.getEngine();
            }
            if (col == 3) {
                if (obj.getEngine() != null) {
                    for (String engineName : CustomLibrariesManager.this.allEngines) {
                        if (!engineName.equals(obj.getEngine())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DRLibrary cs = CustomLibrariesManager.this.customLibrariesContainerList.get(rowIndex);
            if (columnIndex == 1) {
                cs.setName(obj.toString());
            } else if (columnIndex == 2) {
                cs.setEngine((String)obj);
            }
        }
    }
}

