/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.swingui.transformations.ApplyCustomTransformation;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.SwingGui;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.ShellContextFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CustomTransformationsManager
extends CustomDialog {
    private static final long serialVersionUID = 908911503909816768L;
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private final String NAME = "Tr";
    String MODEL = "model";
    private JDialog dialog;
    private DesignPart dp;
    public List<DRCustomScript> customTransformationsContainerList;
    private JTable customTransformationsTable;
    public JButton bnSave;
    public JButton bnApply;
    public JButton bnDebug;
    public JButton bnClose;
    private JButton bnImport;
    private JButton bnExport;
    private JButton btnAddCustomTransformation;
    private JButton btnRemoveCustomTransformation;
    private DRCustomScript currentTransformation;
    private int cgCounter = 0;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private JSplitPane mainPanel;
    private boolean saved = true;
    private RSyntaxTextArea scriptEditor;
    private ApplicationView appView;
    private ScriptEngineManager scriptEngineManager;
    private JComboBox cbMethod = new JComboBox();
    private JComboBox cbLibrary;
    private File file;
    private boolean autoChanged = false;
    private JComboBox obCombo;
    private JComboBox engCombo;
    private ArrayList allEngines;
    private static File lastImpFolder = null;
    private static File lastExpFolder = null;
    private ArrayList<DRCustomScript> allCR;
    private static final Logger LOGGER = new Logger(CustomTransformationsManager.class);
    private boolean debugEnabled = true;

    public CustomTransformationsManager(ApplicationView appView, DesignPart dp, ScriptEngineManager scriptEngineManager) {
        super(appView);
        this.appView = appView;
        this.dp = dp;
        this.scriptEngineManager = scriptEngineManager;
        UIManager.put("TextArea.inactiveForeground", Color.BLACK);
        this.allEngines = appView.getScriptEngines();
        this.allCR = appView.getCustomDesignRules();
        this.init();
        this.loadCustomTS();
    }

    private void init() {
        JPanel tablePanel = new JPanel(new BorderLayout());
        JPanel scriptPanel = new JPanel(new BorderLayout());
        scriptPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CustomTransformationsManager.Script")));
        this.mainPanel = new JSplitPane(0, tablePanel, scriptPanel);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.setDividerLocation(200);
        this.customTransformationsContainerList = new ArrayList<DRCustomScript>();
        this.customTransformationsTable = new JTable(new CustomTransformationModel());
        this.customTransformationsTable.setSelectionMode(0);
        this.customTransformationsTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        TableColumn col0 = this.customTransformationsTable.getColumnModel().getColumn(0);
        col0.setWidth(30);
        col0.setMaxWidth(30);
        JTextField tf = new JTextField();
        TableColumn col1 = this.customTransformationsTable.getColumnModel().getColumn(1);
        col1.setWidth(220);
        col1.setMaxWidth(1000);
        col1.setCellEditor(new TFCellEditor(tf));
        this.obCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getObjecTypes().toArray()));
        TableColumn col2 = this.customTransformationsTable.getColumnModel().getColumn(2);
        col2.setWidth(120);
        col2.setMaxWidth(120);
        col2.setCellEditor(new DefaultCellEditor(this.obCombo));
        this.engCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.appView.getScriptEngines().toArray()));
        TableColumn col3 = this.customTransformationsTable.getColumnModel().getColumn(3);
        col3.setWidth(300);
        col3.setMaxWidth(300);
        col3.setCellEditor(new DefaultCellEditor(this.engCombo));
        TableColumn col4 = this.customTransformationsTable.getColumnModel().getColumn(4);
        col4.setWidth(100);
        col4.setMaxWidth(100);
        TableColumn col5 = this.customTransformationsTable.getColumnModel().getColumn(5);
        this.customTransformationsTable.getColumnModel().removeColumn(col5);
        tf.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                CustomTransformationsManager.this.saved = false;
                CustomTransformationsManager.this.bnSave.setEnabled(true);
            }
        });
        this.obCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String oldValue = (String)CustomTransformationsManager.this.customTransformationsTable.getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 2);
                String newValue = (String)CustomTransformationsManager.this.obCombo.getSelectedItem();
                if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    CustomTransformationsManager.this.bnSave.setEnabled(true);
                    CustomTransformationsManager.this.saved = false;
                }
            }
        });
        this.engCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                String oldValue = (String)CustomTransformationsManager.this.customTransformationsTable.getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 3);
                String newValue = (String)CustomTransformationsManager.this.engCombo.getSelectedItem();
                if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    CustomTransformationsManager.this.bnSave.setEnabled(true);
                    CustomTransformationsManager.this.saved = false;
                }
            }
        });
        this.customTransformationsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selRow = CustomTransformationsManager.this.customTransformationsTable.getSelectedRow();
                if (selRow == -1) {
                    CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(false);
                    CustomTransformationsManager.this.bnApply.setEnabled(false);
                    CustomTransformationsManager.this.bnSave.setEnabled(false);
                    CustomTransformationsManager.this.bnDebug.setEnabled(false);
                    CustomTransformationsManager.this.scriptEditor.setEnabled(false);
                } else {
                    if (CustomTransformationsManager.this.currentTransformation != null) {
                        CustomTransformationsManager.this.currentTransformation.setScript(CustomTransformationsManager.this.scriptEditor.getText());
                        CustomTransformationsManager.this.currentTransformation.setFunction((String)CustomTransformationsManager.this.cbMethod.getSelectedItem());
                        for (DRLibrary l : CustomTransformationsManager.this.appView.getCustomLibraries()) {
                            if (!l.getName().equals(CustomTransformationsManager.this.cbLibrary.getSelectedItem())) continue;
                            CustomTransformationsManager.this.currentTransformation.setLibrary(l);
                            break;
                        }
                    }
                    CustomTransformationsManager.this.currentTransformation = ((CustomTransformationModel)CustomTransformationsManager.this.customTransformationsTable.getModel()).getCustomTransformationsContainerList().get(selRow);
                    boolean debug = true;
                    String lib = (String)CustomTransformationsManager.this.cbLibrary.getSelectedItem();
                    if (lib != null && !"".equals(lib)) {
                        debug = false;
                    }
                    CustomTransformationsManager.this.scriptEditor.setText("");
                    CustomTransformationsManager.this.scriptEditor.setText(CustomTransformationsManager.this.currentTransformation.getScript());
                    if (CustomTransformationsManager.this.currentTransformation != null) {
                        String ename = CustomTransformationsManager.this.currentTransformation.getEngineName();
                        if (ename != null) {
                            ename = ename.toUpperCase();
                        }
                        if (ename != null && ename.indexOf("RHINO") > -1) {
                            CustomTransformationsManager.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                            CustomTransformationsManager.this.bnDebug.setEnabled(CustomTransformationsManager.this.debugEnabled);
                        } else if (ename != null && ename.indexOf("RUBY") > -1) {
                            CustomTransformationsManager.this.scriptEditor.setSyntaxEditingStyle("text/ruby");
                        } else {
                            CustomTransformationsManager.this.scriptEditor.setSyntaxEditingStyle("text/javascript");
                        }
                        if (ename != null && ename.indexOf("RHINO") > -1) {
                            CustomTransformationsManager.this.bnDebug.setEnabled(debug && CustomTransformationsManager.this.debugEnabled);
                        } else {
                            CustomTransformationsManager.this.bnDebug.setEnabled(false);
                        }
                    }
                    CustomTransformationsManager.this.scriptEditor.setCaretPosition(0);
                    CustomTransformationsManager.this.autoChanged = true;
                    CustomTransformationsManager.this.cbLibrary.setSelectedItem(CustomTransformationsManager.this.currentTransformation.getLibrary() != null ? CustomTransformationsManager.this.currentTransformation.getLibrary().getName() : "");
                    CustomTransformationsManager.this.cbMethod.setSelectedItem(CustomTransformationsManager.this.currentTransformation.getFunction());
                    CustomTransformationsManager.this.autoChanged = false;
                    CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(true);
                    CustomTransformationsManager.this.bnApply.setEnabled(CustomTransformationsManager.this.debugEnabled);
                    CustomTransformationsManager.this.bnSave.setEnabled(!CustomTransformationsManager.this.saved);
                    CustomTransformationsManager.this.bnDebug.setEnabled(true);
                    CustomTransformationsManager.this.scriptEditor.setEnabled(debug);
                }
            }
        });
        tablePanel.add((Component)this.createCustomTransformationsToolbarPanel(), "North");
        JScrollPane scrollPane = new JScrollPane(this.customTransformationsTable);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        tablePanel.add((Component)scrollPane, "Center");
        JPanel librariesPanel = new JPanel(new FlowLayout(1));
        JLabel libLabel = new JLabel(Messages.getString("CustomTransformationsManager.Library"));
        libLabel.setPreferredSize(new Dimension(70, 20));
        this.cbLibrary = new JComboBox<Object>(this.getLibraries().toArray());
        this.cbLibrary.setPreferredSize(new Dimension(250, 20));
        this.cbLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    String item = (String)evt.getItem();
                    if (item != "") {
                        CustomTransformationsManager.this.cbMethod.removeAllItems();
                        for (DRLibrary lib : CustomTransformationsManager.this.appView.getCustomLibraries()) {
                            if (!lib.getName().equals(item)) continue;
                            Iterator<String> it1 = lib.getFunctions().iterator();
                            while (it1.hasNext()) {
                                CustomTransformationsManager.this.cbMethod.addItem(it1.next());
                            }
                            CustomTransformationsManager.this.scriptEditor.setText("");
                            CustomTransformationsManager.this.scriptEditor.setText(lib.getScript());
                            CustomTransformationsManager.this.scriptEditor.setCaretPosition(0);
                            CustomTransformationsManager.this.scriptEditor.setEnabled(false);
                            break;
                        }
                        CustomTransformationsManager.this.cbMethod.updateUI();
                        CustomTransformationsManager.this.bnApply.setEnabled(CustomTransformationsManager.this.debugEnabled);
                    } else if (item == "") {
                        CustomTransformationsManager.this.cbMethod.removeAllItems();
                        CustomTransformationsManager.this.cbMethod.updateUI();
                        CustomTransformationsManager.this.scriptEditor.setText("");
                        CustomTransformationsManager.this.scriptEditor.setText(CustomTransformationsManager.this.currentTransformation.getScript());
                        CustomTransformationsManager.this.scriptEditor.setCaretPosition(0);
                        CustomTransformationsManager.this.scriptEditor.setEnabled(true);
                    }
                    if (!CustomTransformationsManager.this.autoChanged) {
                        CustomTransformationsManager.this.saved = false;
                        CustomTransformationsManager.this.bnSave.setEnabled(true);
                    }
                }
            }
        });
        this.cbMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1 && !CustomTransformationsManager.this.autoChanged) {
                    CustomTransformationsManager.this.saved = false;
                    CustomTransformationsManager.this.bnSave.setEnabled(true);
                }
            }
        });
        JLabel metLabel = new JLabel(Messages.getString("CustomTransformationsManager.Method"));
        metLabel.setPreferredSize(new Dimension(70, 20));
        this.cbMethod.setPreferredSize(new Dimension(250, 20));
        librariesPanel.add(libLabel);
        librariesPanel.add(this.cbLibrary);
        librariesPanel.add(metLabel);
        librariesPanel.add(this.cbMethod);
        scriptPanel.add((Component)librariesPanel, "North");
        this.scriptEditor = new RSyntaxTextArea();
        this.scriptEditor.setEnabled(false);
        this.scriptEditor.setSyntaxEditingStyle("text/javascript");
        this.scriptEditor.setCodeFoldingEnabled(true);
        this.scriptEditor.setAntiAliasingEnabled(true);
        this.scriptEditor.setHyperlinksEnabled(true);
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop desktop = Desktop.getDesktop();
                            try {
                                desktop.browse(e.getURL().toURI());
                            }
                            catch (URISyntaxException uRISyntaxException) {}
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
        this.scriptEditor.addHyperlinkListener(listener);
        this.scriptEditor.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                CustomTransformationsManager.this.saved = false;
                CustomTransformationsManager.this.bnSave.setEnabled(true);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        RTextScrollPane scrollPaneSE = new RTextScrollPane((RTextArea)this.scriptEditor);
        scrollPaneSE.setPreferredSize(new Dimension(300, 550));
        scriptPanel.add((Component)scrollPaneSE, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        this.bnApply = new JButton(Messages.getString("CustomTransformationsManager.Apply"));
        this.bnApply.setToolTipText(Messages.getString("CustomTransformationsManager.ApplyTooltip"));
        this.bnApply.setEnabled(false);
        this.bnApply.setMnemonic(65);
        this.bnDebug = new JButton(Messages.getString("CustomTransformationsManager.Debug"));
        this.bnDebug.setToolTipText(Messages.getString("CustomTransformationsManager.DebugTooltip"));
        this.bnDebug.setEnabled(false);
        this.bnDebug.setMnemonic(68);
        this.bnSave = new JButton(Messages.getString("CustomTransformationsManager.Save"));
        this.bnSave.setToolTipText(Messages.getString("CustomTransformationsManager.SaveTooltip"));
        this.bnSave.setEnabled(false);
        this.bnApply.addActionListener(new ApplyAction());
        this.bnDebug.addActionListener(new DebugAction());
        this.bnSave.addActionListener(new SaveAction());
        this.bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnSave);
        this.bnSave.setMnemonic(83);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnApply);
        this.bnDebug.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnDebug);
        this.bnImport = new JButton(this.createImportButton());
        this.bnImport.setToolTipText(Messages.getString("CustomTransformationsManager.ImportTooltip"));
        this.bnImport.setMnemonic(73);
        this.bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnImport);
        this.bnExport = new JButton(this.createExportButton());
        this.bnExport.setToolTipText(Messages.getString("CustomTransformationsManager.ExportTooltip"));
        this.bnExport.setMnemonic(69);
        this.bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(this.bnExport);
        this.bnClose = new JButton(this.closeAction());
        this.bnClose.setToolTipText(Messages.getString("CustomTransformationsManager.CloseDialogTooltip"));
        this.bnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnClose.setMnemonic(67);
        btnPanel.add(this.bnClose);
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setToolTipText(Messages.getString("CustomTransformationsManager.HelpTooltip"));
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnPanel.add(bnHelp);
        scriptPanel.add((Component)btnPanel, "South");
    }

    private void resetDebugButton() {
        boolean debug = true;
        String lib = (String)this.cbLibrary.getSelectedItem();
        if (lib != null && !"".equals(lib)) {
            debug = false;
        }
        if (this.currentTransformation != null) {
            String ename = this.currentTransformation.getEngineName();
            if (ename != null) {
                ename = ename.toUpperCase();
            }
            if (ename != null && ename.indexOf("RHINO") > -1) {
                this.bnDebug.setEnabled(debug && this.debugEnabled);
            } else {
                this.bnDebug.setEnabled(false);
            }
        }
    }

    private void loadCustomTS() {
        Iterator<DRCustomScript> it = this.allCR.iterator();
        this.customTransformationsContainerList.clear();
        while (it.hasNext()) {
            DRCustomScript drcs = it.next().copy();
            if (!drcs.getPurpose().equals("transformation")) continue;
            drcs.setVariable(this.MODEL);
            this.customTransformationsContainerList.add(drcs);
        }
        this.customTransformationsTable.updateUI();
        if (this.customTransformationsContainerList.size() > 0) {
            this.customTransformationsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.saved = true;
        this.bnSave.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < CustomTransformationsManager.this.customTransformationsTable.getRowCount(); ++i) {
                    if (!CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(i, 5).equals("err")) continue;
                    JOptionPane.showMessageDialog(CustomTransformationsManager.this, Messages.getString("CustomTransformationsManager.MissingEngine"), Messages.getString("CustomDesignRulesManager.Warning"), 2);
                    break;
                }
            }
        });
    }

    protected JPanel createCustomTransformationsToolbarPanel() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        this.btnAddCustomTransformation = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAddCustomTransformation.setToolTipText(Messages.getString("CustomTransformationsManager.AddTransformation"));
        this.btnAddCustomTransformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DRCustomScript cs = new DRCustomScript(CustomTransformationsManager.this.generateName(), null, "transformation");
                cs.setScriptEngineManager(CustomTransformationsManager.this.scriptEngineManager);
                CustomTransformationsManager.this.customTransformationsContainerList.add(cs);
                CustomTransformationsManager.this.customTransformationsTable.updateUI();
                CustomTransformationsManager.this.customTransformationsTable.getSelectionModel().setSelectionInterval(CustomTransformationsManager.this.customTransformationsTable.getRowCount() - 1, CustomTransformationsManager.this.customTransformationsTable.getRowCount() - 1);
                CustomTransformationsManager.this.customTransformationsTable.scrollRectToVisible(new Rectangle(CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth() * CustomTransformationsManager.this.customTransformationsTable.getSelectedColumn(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight() * CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight()));
                CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(CustomTransformationsManager.this.customTransformationsContainerList.size() > 0);
                CustomTransformationsManager.this.scriptEditor.setEnabled(true);
                CustomTransformationsManager.this.bnSave.setEnabled(true);
                CustomTransformationsManager.this.saved = false;
            }
        });
        this.btnRemoveCustomTransformation = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemoveCustomTransformation.setToolTipText(Messages.getString("CustomTransformationsManager.RemoveTransformation"));
        this.btnRemoveCustomTransformation.setEnabled(false);
        this.btnRemoveCustomTransformation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected = CustomTransformationsManager.this.customTransformationsTable.getSelectedRow();
                CustomTransformationsManager.this.customTransformationsContainerList.remove(selected);
                CustomTransformationsManager.this.customTransformationsTable.getSelectionModel().setSelectionInterval(0, 0);
                CustomTransformationsManager.this.customTransformationsTable.updateUI();
                CustomTransformationsManager.this.customTransformationsTable.scrollRectToVisible(new Rectangle(CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth() * CustomTransformationsManager.this.customTransformationsTable.getSelectedColumn(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight() * CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), CustomTransformationsManager.this.customTransformationsTable.getColumnModel().getColumn(1).getWidth(), CustomTransformationsManager.this.customTransformationsTable.getRowHeight()));
                if (CustomTransformationsManager.this.customTransformationsContainerList.size() == 0) {
                    CustomTransformationsManager.this.cbLibrary.setSelectedItem("");
                    CustomTransformationsManager.this.cbMethod.removeAllItems();
                    CustomTransformationsManager.this.scriptEditor.setText("");
                    CustomTransformationsManager.this.scriptEditor.setEnabled(false);
                    CustomTransformationsManager.this.bnApply.setEnabled(false);
                    CustomTransformationsManager.this.bnDebug.setEnabled(false);
                    CustomTransformationsManager.this.btnRemoveCustomTransformation.setEnabled(false);
                }
                CustomTransformationsManager.this.bnSave.setEnabled(true);
                CustomTransformationsManager.this.saved = false;
            }
        });
        toolBar.add(this.btnAddCustomTransformation);
        toolBar.add(this.btnRemoveCustomTransformation);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        buttonGeneral.add(toolBar);
        return buttonGeneral;
    }

    protected String generateName() {
        String name = "Tr";
        int newNumber = 0;
        int lastNumber = this.customTransformationsContainerList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.exists(nName)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean exists(String name) {
        for (int i = 0; i < this.customTransformationsContainerList.size(); ++i) {
            DRCustomScript rule = this.customTransformationsContainerList.get(i);
            if (!name.equalsIgnoreCase(rule.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    public Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("CustomTransformationsManager.CustomTransformations"), false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.setContentPane(this);
            this.dialog.setSize(800, 600);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this.mainPanel);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "CUSTOM_TRANSFORMATIONS_DIALOG";
    }

    private void stopCellediting() {
        if (this.scriptEditor.isEnabled()) {
            this.currentTransformation.setScript(this.scriptEditor.getText());
        }
        for (DRLibrary l : this.appView.getCustomLibraries()) {
            if (!l.getName().equals(this.cbLibrary.getSelectedItem())) continue;
            this.currentTransformation.setLibrary(l);
            break;
        }
        this.currentTransformation.setFunction((String)this.cbMethod.getSelectedItem());
        TableCellEditor cellEditor = this.customTransformationsTable.getCellEditor();
        if (cellEditor != null) {
            this.customTransformationsTable.getCellEditor().stopCellEditing();
        }
    }

    public Action closeAction() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomTransformationsManager.Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomTransformationsManager.this.canClose()) {
                    CustomTransformationsManager.this.close();
                }
            }
        };
        return action;
    }

    private ArrayList<String> getObjecTypes() {
        ArrayList<String> se = new ArrayList<String>();
        se.add("logical");
        se.add("relational");
        return se;
    }

    protected boolean canSave() {
        block5: {
            block6: {
                if (this.customTransformationsContainerList.size() <= 0) break block5;
                if (this.customTransformationsTable.getSelectedRow() <= -1) break block6;
                if (this.customTransformationsTable.getModel().getValueAt(this.customTransformationsTable.getSelectedRow(), 2) == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomTransformationsManager.NoObjectChosen"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                if (this.customTransformationsTable.getModel().getValueAt(this.customTransformationsTable.getSelectedRow(), 3) == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomTransformationsManager.NoEngineChosen"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                if (this.scriptEditor.getText().trim().length() == 0 || this.scriptEditor.getText() == null) {
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomTransformationsManager.NoScript"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                for (DRCustomScript drcs : this.customTransformationsContainerList) {
                    if (drcs.getObject() != null && drcs.getEngineName() != null && (drcs.getLibrary() != null || !drcs.getScript().equals(""))) continue;
                    JOptionPane.showMessageDialog(this, Messages.getString("CustomTransformationsManager.NoObjectEngineScript"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                    return false;
                }
                break block5;
            }
            if (this.customTransformationsTable.getSelectedRow() != -1) break block5;
            for (DRCustomScript drcs : this.customTransformationsContainerList) {
                if (drcs.getObject() != null && drcs.getEngineName() != null && (drcs.getLibrary() != null || !drcs.getScript().equals(""))) continue;
                JOptionPane.showMessageDialog(this, Messages.getString("CustomTransformationsManager.NoObjectEngineScript"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean canClose() {
        if (!this.saved) {
            String s1 = Messages.getString("CustomTransformationsManager.Yes");
            String s2 = Messages.getString("CustomTransformationsManager.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("CustomTransformationsManager.TransformationsNotSaved"), Messages.getString("CustomTransformationsManager.CloseConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    public ArrayList<String> getLibraries() {
        ArrayList<String> v = new ArrayList<String>();
        Iterator<DRLibrary> it = this.appView.getCustomLibraries().iterator();
        v.add("");
        while (it.hasNext()) {
            v.add(it.next().getName());
        }
        return v;
    }

    public Action createImportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomTransformationsManager.Import")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("CustomTransformationsManager.XMLFiles");
                        }
                    };
                    URLChooser fileChooser = DialogUtil.newURLChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    if (lastImpFolder != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastImpFolder));
                    } else {
                        String lastDir = CustomTransformationsManager.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = CustomTransformationsManager.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsManager.ImportS"));
                    if (status == 0) {
                        CustomTransformationsManager.this.file = new File(fileChooser.getSelectedURL().getPath());
                        if (CustomTransformationsManager.this.file != null) {
                            lastImpFolder = CustomTransformationsManager.this.file.getParentFile();
                            FileOpenHistory.getInstance().updateFileHistory(lastImpFolder.toURI().toURL());
                            try {
                                int ch;
                                StringBuffer buffer = new StringBuffer();
                                FileInputStream fis = new FileInputStream(CustomTransformationsManager.this.file);
                                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                BufferedReader in = new BufferedReader(isr);
                                while ((ch = ((Reader)in).read()) > -1) {
                                    buffer.append((char)ch);
                                }
                                ((Reader)in).close();
                                CustomTransformationsManager.this.importTS(buffer.toString());
                            }
                            catch (Exception ex) {
                                LOGGER.error("Unable to load custom transformation scripts from imported file: ", ex);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error import custom transformations ", ex);
                }
            }
        };
        return action;
    }

    public void importTS(String str) {
        try {
            StringReader sr = new StringReader(str);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource(sr);
            Document doc = builder.parse(inputSource);
            ArrayList<DRCustomScript> loadedScripts = new ArrayList<DRCustomScript>();
            NodeList nodes = doc.getElementsByTagName("scr");
            int nodesLength = nodes.getLength();
            for (int i = 0; i < nodesLength; ++i) {
                DRLibrary currentLibrary = null;
                Element elm = (Element)nodes.item(i);
                DRCustomScript drs = new DRCustomScript(elm.getAttribute(StringUtilities.decodeAttributeValue("name")), elm.getAttribute("id"), elm.getAttribute("purpose"));
                drs.setObject(elm.getAttribute("object"));
                drs.setEngineName(elm.getAttribute("engine"));
                drs.setVariable(elm.getAttribute("var"));
                drs.setScriptEngineManager(this.appView.getScriptEngineManager());
                NodeList script = elm.getChildNodes();
                StringBuffer c = new StringBuffer();
                for (int j = 0; j < script.getLength(); ++j) {
                    Node nScript = script.item(j);
                    c.append(nScript.getTextContent());
                }
                String lib = elm.getAttribute("library");
                if (lib != null && lib.trim().length() > 0) {
                    String method = elm.getAttribute("method");
                    for (DRLibrary l : this.appView.getCustomLibraries()) {
                        if (!l.getName().equals(StringUtilities.decodeAttributeValue(lib))) continue;
                        drs.setLibrary(l);
                        if (l.getFunctions().contains(method)) {
                            drs.setFunction(method);
                        } else {
                            l.getFunctions().add(method);
                            drs.setFunction(method);
                        }
                        currentLibrary = l;
                        break;
                    }
                    if (currentLibrary == null) {
                        currentLibrary = new DRLibrary(StringUtilities.decodeAttributeValue(elm.getAttribute("library")), null);
                        currentLibrary.setFunctions(new ArrayList<String>());
                        currentLibrary.setEngine(elm.getAttribute("engine"));
                        currentLibrary.getFunctions().add(StringUtilities.decodeAttributeValue(method));
                        currentLibrary.setScript(c.toString().trim());
                        drs.setFunction(method);
                        drs.setLibrary(currentLibrary);
                        this.appView.getCustomLibraries().add(currentLibrary);
                        this.cbLibrary.removeAllItems();
                        Iterator<String> it1 = this.getLibraries().iterator();
                        while (it1.hasNext()) {
                            this.cbLibrary.addItem(it1.next());
                        }
                    }
                }
                drs.setScript(c.toString().trim());
                loadedScripts.add(drs);
            }
            boolean added = false;
            Iterator it = loadedScripts.iterator();
            while (it.hasNext()) {
                boolean exists = false;
                DRCustomScript o = (DRCustomScript)it.next();
                String currentRuleId = o.getRuleId();
                for (DRCustomScript o1 : this.allCR) {
                    String currentRuleId1 = o1.getRuleId();
                    if (!currentRuleId.equals(currentRuleId1)) {
                        exists = false;
                        continue;
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                this.allCR.add(o);
                this.customTransformationsContainerList.add(o);
                added = true;
            }
            if (added) {
                this.appView.saveCustomDRScripts();
            }
            this.customTransformationsTable.updateUI();
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to import custom transformation scripts: ", e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to import custom transformation scripts: ", e);
            JOptionPane.showMessageDialog(this, Messages.getString("CustomDesignRulesManager.ImportError"), Messages.getString("CustomDesignRulesManager.Error"), 0);
        }
    }

    public Action createExportButton() {
        AbstractAction action = new AbstractAction(Messages.getString("CustomTransformationsManager.Export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    if (CustomTransformationsManager.this.saved) {
                        try {
                            URLFilter fileFilter = new URLFilter(){

                                public boolean accept(URL url) {
                                    File file = new File(url.getPath());
                                    return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                                }

                                public String toString() {
                                    return Messages.getString("CustomTransformationsManager.XMLFiles");
                                }
                            };
                            URLChooser fileChooser = DialogUtil.newURLChooser();
                            fileChooser.clearChooseableURLFilters();
                            fileChooser.setSelectionScope(0);
                            fileChooser.setSelectionMode(0);
                            fileChooser.setShowJarsAsDirs(false);
                            fileChooser.setURLFilter(fileFilter);
                            if (lastExpFolder != null) {
                                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastExpFolder));
                            } else {
                                String lastDir = CustomTransformationsManager.this.getApplicationView().getSettings().getDefaultSavePath();
                                if (lastDir != null && lastDir.length() > 0) {
                                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                                } else {
                                    URL url = CustomTransformationsManager.this.getApplicationView().getUserHomeDirectory();
                                    if (url != null) {
                                        fileChooser.setSelectedURL(url);
                                    }
                                }
                            }
                            int status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsManager.ExportS"));
                            if (status != 0) break block12;
                            String path = fileChooser.getSelectedURL().getPath();
                            int dotPos = path.lastIndexOf(".");
                            if (dotPos > -1) {
                                CustomTransformationsManager.this.file = new File(path.substring(0, dotPos) + ".xml");
                            } else {
                                CustomTransformationsManager.this.file = new File(path + ".xml");
                            }
                            if (CustomTransformationsManager.this.file != null) {
                                lastExpFolder = CustomTransformationsManager.this.file.getParentFile();
                                FileOpenHistory.getInstance().updateFileHistory(lastExpFolder.toURI().toURL());
                                CustomTransformationsManager.this.exportTS();
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error export custom transformations ", ex);
                        }
                    } else {
                        JOptionPane.showMessageDialog(CustomTransformationsManager.this, Messages.getString("CustomTransformationsManager.NotSaved"), Messages.getString("CustomTransformationsManager.Error"), 0);
                    }
                }
            }
        };
        return action;
    }

    public void exportTS() {
        boolean saveIt = true;
        try {
            int result;
            StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
            buffer.append("\n");
            buffer.append("<!-- File contains Custom Transformation scripts -->");
            buffer.append("\n");
            buffer.append("<").append("custom_transformation_scripts").append(">");
            for (DRCustomScript drcs : this.customTransformationsContainerList) {
                buffer.append("\n");
                buffer.append("\t").append("<").append("scr").append(' ');
                buffer.append("id=\"").append(drcs.getRuleId()).append("\"").append(' ');
                buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(drcs.getName())).append("\"").append(' ');
                buffer.append("object=\"").append(drcs.getObject()).append("\"").append(' ');
                buffer.append("engine=\"").append(drcs.getEngineName()).append("\"").append(' ');
                buffer.append("var=\"").append(drcs.getVariable()).append("\"").append(' ');
                buffer.append("library=\"").append(StringUtilities.encodeAttributeValue(drcs.getLibrary() != null ? drcs.getLibrary().getName() : "")).append("\"").append(' ');
                buffer.append("method=\"").append(StringUtilities.encodeAttributeValue(drcs.getFunction() != null ? drcs.getFunction() : "")).append("\"").append(' ');
                buffer.append("purpose=\"").append(StringUtilities.encodeAttributeValue(drcs.getPurpose())).append("\"").append(' ');
                buffer.append(">");
                buffer.append("\n");
                buffer.append("\t\t").append("<").append("script").append(">");
                buffer.append("\n");
                buffer.append("\t\t\t").append("<![CDATA[").append(drcs.getLibrary() != null ? drcs.getLibrary().getScript() : drcs.getScript()).append("]]>");
                buffer.append("\n");
                buffer.append("\t\t").append("</").append("script").append(">");
                buffer.append("\n");
                buffer.append("\t").append("</").append("scr").append(">");
            }
            buffer.append("\n");
            buffer.append("</").append("custom_transformation_scripts").append(">");
            if (this.file.exists() && (result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("CustomTransformationsManager.FileExists"), this.file), Messages.getString("CustomTransformationsManager.Warning"), 0, 3, this.getConfiguration().getIcon("SAVE_ICON", 32))) == 1) {
                saveIt = false;
            }
            if (saveIt) {
                FileOutputStream fos = new FileOutputStream(this.file);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(buffer.toString());
                osw.close();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Unable to export libraries: ", e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to export custom transformation scripts: ", e);
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 2737192443575947005L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color fc = null;
            if (table.getModel().getValueAt(row, 5).equals("err")) {
                fc = Color.RED;
            }
            comp.setForeground(fc);
            return comp;
        }
    }

    private class DebugAction
    implements ActionListener {
        private DebugAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            final DRCustomScript selected = CustomTransformationsManager.this.customTransformationsContainerList.get(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow());
            ShellContextFactory ctxFac = Main.shellContextFactory;
            Global scope = Main.getGlobal();
            final DesignPart model = "relational".equalsIgnoreCase(selected.getObject()) ? (CustomTransformationsManager.this.dp instanceof RelationalDesign ? CustomTransformationsManager.this.dp : CustomTransformationsManager.this.dp.getDesign().getRelationalDesign()) : CustomTransformationsManager.this.dp.getDesign().getLogicalDesign();
            scope.put("model", (Scriptable)scope, (Object)model);
            Frame[] fr1 = IdeMainWindow.getFrames();
            org.mozilla.javascript.tools.debugger.Main.mainEmbedded((ContextFactory)ctxFac, (Scriptable)scope, (String)"Debug JavaScript");
            Frame[] fr2 = IdeMainWindow.getFrames();
            Frame fr = null;
            if (fr2.length > fr1.length) {
                fr = fr2[fr2.length - 1];
            }
            if (fr != null && fr instanceof SwingGui) {
                ((SwingGui)fr).setExitAction(null);
            }
            try {
                ctxFac.call(new ContextAction(){

                    public Object run(Context cx) {
                        CustomTransformationsManager.this.debugEnabled = false;
                        CustomTransformationsManager.this.bnDebug.setEnabled(false);
                        CustomTransformationsManager.this.bnApply.setEnabled(false);
                        Context cx2 = Context.enter((Context)cx);
                        ImporterTopLevel scope = new ImporterTopLevel(cx2);
                        String scriptStr = CustomTransformationsManager.this.scriptEditor.getText().trim();
                        scope.put("model", (Scriptable)scope, (Object)model);
                        Object returnValue = cx2.evaluateString((Scriptable)scope, scriptStr.trim(), selected.getName(), 1, null);
                        if (null == returnValue) {
                            returnValue = new Object();
                        }
                        Context.exit();
                        CustomTransformationsManager.this.debugEnabled = true;
                        return returnValue;
                    }
                });
            }
            catch (Exception ee) {
                if (ee instanceof ScriptException) {
                    ScriptException ex = (ScriptException)ee;
                    JOptionPane.showMessageDialog(CustomTransformationsManager.this, oracle.dbtools.crest.model.Messages.getString("DRCustomScript.EvaluateError") + "\n\nName     : " + selected.getName() + "\n\nLine        : " + ex.getLineNumber() + "\nColumn   : " + ex.getColumnNumber() + "\nMessage : " + ex.getMessage(), oracle.dbtools.crest.model.Messages.getString("DRCustomScript.Error"), 0);
                } else if (ee instanceof EcmaError) {
                    EcmaError ex = (EcmaError)ee;
                    JOptionPane.showMessageDialog(CustomTransformationsManager.this, oracle.dbtools.crest.model.Messages.getString("DRCustomScript.EvaluateError") + "\n\nName     : " + selected.getName() + "\n\nLine        : " + ex.lineNumber() + "\nColumn   : " + ex.columnNumber() + "\nMessage : " + ex.getMessage(), oracle.dbtools.crest.model.Messages.getString("DRCustomScript.Error"), 0);
                } else {
                    JOptionPane.showMessageDialog(CustomTransformationsManager.this, ee.getMessage(), oracle.dbtools.crest.model.Messages.getString("DRCustomScript.EvaluateError"), 0);
                }
            }
            finally {
                CustomTransformationsManager.this.debugEnabled = true;
                CustomTransformationsManager.this.resetDebugButton();
                CustomTransformationsManager.this.bnApply.setEnabled(true);
                if (fr != null && fr instanceof SwingGui) {
                    fr.dispose();
                }
            }
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CustomTransformationsManager.this.saved) {
                DRCustomScript selected = CustomTransformationsManager.this.customTransformationsContainerList.get(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow());
                DesignPart model = "relational".equalsIgnoreCase(selected.getObject()) ? (CustomTransformationsManager.this.dp instanceof RelationalDesign ? CustomTransformationsManager.this.dp : CustomTransformationsManager.this.dp.getDesign().getRelationalDesign()) : CustomTransformationsManager.this.dp.getDesign().getLogicalDesign();
                if (CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 5).equals("err")) {
                    JOptionPane.showMessageDialog(CustomTransformationsManager.this, MessageFormat.format(Messages.getString("CustomTransformationsManager.CannotApply"), CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 1), CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 2), CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 3)), Messages.getString("CustomDesignRulesManager.Error"), 0);
                } else if (CustomTransformationsManager.this.customTransformationsTable.getModel().getValueAt(CustomTransformationsManager.this.customTransformationsTable.getSelectedRow(), 5).equals("ok") && CustomTransformationsManager.this.customTransformationsTable.getSelectedRow() > -1 && CustomTransformationsManager.this.scriptEditor.getText() != null && !CustomTransformationsManager.this.scriptEditor.getText().trim().equals("")) {
                    try {
                        ApplyCustomTransformation act = new ApplyCustomTransformation(selected.getObject(), model, new ArrayList<DRCustomScript>(Arrays.asList(selected)));
                        boolean hasErr = act.runTransformation();
                        if (!hasErr) {
                            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("CustomTransformationsManager.Finished"), Messages.getString("CustomTransformationsManager.CustomTransformations"), 1);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error during execution of custom transformation script : ", ex);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(CustomTransformationsManager.this, Messages.getString("CustomTransformationsManager.NotSavedBeforeApply"), Messages.getString("CustomTransformationsManager.Warning"), 2);
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CustomTransformationsManager.this.stopCellediting();
            if (CustomTransformationsManager.this.canSave()) {
                ArrayList<DRCustomScript> removalList = new ArrayList<DRCustomScript>();
                for (DRCustomScript drcs : CustomTransformationsManager.this.allCR) {
                    if (!drcs.getPurpose().equals("transformation")) continue;
                    removalList.add(drcs);
                }
                for (DRCustomScript cs : CustomTransformationsManager.this.customTransformationsContainerList) {
                    cs.compiledScript = null;
                }
                CustomTransformationsManager.this.allCR.removeAll(removalList);
                CustomTransformationsManager.this.allCR.addAll(CustomTransformationsManager.this.customTransformationsContainerList);
                CustomTransformationsManager.this.bnSave.setEnabled(false);
                CustomTransformationsManager.this.bnApply.setEnabled(CustomTransformationsManager.this.debugEnabled);
                CustomTransformationsManager.this.saved = true;
                CustomTransformationsManager.this.appView.saveCustomDRScripts();
            }
        }
    }

    class TFCellEditor
    extends DefaultCellEditor
    implements FocusListener {
        private static final long serialVersionUID = 5665190670341352527L;
        private JTextField tf;
        private String val;
        private JTable tab;

        public TFCellEditor(JTextField tf) {
            super(tf);
            this.tf = tf;
            tf.addFocusListener(this);
            super.setClickCountToStart(1);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.tf.setText(value.toString());
            this.tf.selectAll();
            this.tf.setBorder(null);
            this.val = this.tf.getText();
            this.tab = table;
            return this.tf;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.tf.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public boolean stopCellEditing() {
            JTextField tf = (JTextField)this.getComponent();
            String newValue = tf.getText().trim();
            if (newValue.length() == 0) {
                JOptionPane.showMessageDialog(CustomTransformationsManager.this, Messages.getString("CustomTransformationsManager.NameEmpty"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            TableModel obj = this.tab.getModel();
            for (DRCustomScript cs : ((CustomTransformationModel)obj).getCustomTransformationsContainerList()) {
                if (!cs.getName().equals(newValue) || newValue.equals(this.val)) continue;
                JOptionPane.showMessageDialog(CustomTransformationsManager.this, Messages.getString("CustomTransformationsManager.NameExists"), Messages.getString("CustomTransformationsManager.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
            CustomTransformationsManager.this.currentTransformation.setScript(CustomTransformationsManager.this.scriptEditor.getText());
            return super.stopCellEditing();
        }
    }

    private class CustomTransformationModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -362794593669886434L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("CustomTransformationsManager.Name"), Messages.getString("CustomTransformationsManager.Object"), Messages.getString("CustomTransformationsManager.Engine"), Messages.getString("CustomTransformationsManager.Variable"), "state"};

        private CustomTransformationModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return CustomTransformationsManager.this.customTransformationsContainerList.size();
        }

        public List<DRCustomScript> getCustomTransformationsContainerList() {
            return CustomTransformationsManager.this.customTransformationsContainerList;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || columnIndex == 4) {
                return false;
            }
            return columnIndex != 3 || !this.getValueAt(rowIndex, 5).equals("err");
        }

        @Override
        public Object getValueAt(int row, int col) {
            DRCustomScript cs = CustomTransformationsManager.this.customTransformationsContainerList.get(row);
            String o = cs.getObject();
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return cs.getName();
            }
            if (col == 2) {
                return o;
            }
            if (col == 3) {
                return cs.getEngineName();
            }
            if (col == 4) {
                return CustomTransformationsManager.this.MODEL;
            }
            if (col == 5) {
                if (cs.getEngineName() != null) {
                    for (String engineName : CustomTransformationsManager.this.allEngines) {
                        if (!engineName.equals(cs.getEngineName())) continue;
                        return "ok";
                    }
                    return "err";
                }
                return "ok";
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            DRCustomScript cs = CustomTransformationsManager.this.customTransformationsContainerList.get(rowIndex);
            if (columnIndex == 1) {
                cs.setName(obj.toString());
            } else if (columnIndex == 2) {
                cs.setObject((String)obj);
                cs.setVariable(CustomTransformationsManager.this.MODEL);
            } else if (columnIndex == 3) {
                cs.setEngineName((String)obj);
            }
        }
    }
}

