/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.designrules.DRTemporary;
import oracle.dbtools.crest.swingui.designrules.DesignRuleSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.designrules.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DesignRuleSetPropertiesDialog
extends CustomDialog {
    private static final long serialVersionUID = -8255158459996467257L;
    private static final String NA = "N/A";
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private JDialog dialog;
    private int result = 0;
    private JPanel mainPanel;
    private JTable allDesignRulesTable;
    private JTable selDesignRulesTable;
    private List<DesignRule> allDesignRulesList;
    private List<DesignRule> selDesignRulesList;
    private DesignRuleView parent;
    private JButton buttonRuleAdd;
    private JButton buttonRuleRemove;
    private DesignRule currentRule;
    private JPanel btnPanel;
    private DesignRuleSet drs;
    private ArrayList<DesignRule> allRules = new ArrayList();

    public DesignRuleSetPropertiesDialog(ApplicationView view, DesignRuleSet rs, DesignRuleView drv) {
        super(view);
        this.parent = drv;
        this.drs = rs;
        this.init();
        this.add((Component)this.mainPanel, "Center");
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.allDesignRulesList = new ArrayList<DesignRule>();
        this.selDesignRulesList = new ArrayList<DesignRule>();
        this.allDesignRulesTable = new JTable(new AllRulesTableModel());
        this.selDesignRulesTable = new JTable(new SelRulesTableModel());
        this.allDesignRulesTable.setAutoResizeMode(0);
        this.selDesignRulesTable.setAutoResizeMode(0);
        this.selDesignRulesTable.setDefaultRenderer(Object.class, new SelectedDRRenderer());
        this.allDesignRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleSetPropertiesDialog.this.allDesignRulesTable.getSelectedRow() == -1) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(false);
                } else {
                    DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(true);
                }
            }
        });
        this.selDesignRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectedRow() == -1 || DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getValueAt(DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectedRow(), 2).equals(DesignRuleSetPropertiesDialog.NA)) {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(false);
                } else {
                    DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(true);
                }
            }
        });
        TableColumn col0 = this.allDesignRulesTable.getColumnModel().getColumn(0);
        col0.setMinWidth(30);
        col0.setMaxWidth(30);
        TableColumn col1 = this.allDesignRulesTable.getColumnModel().getColumn(1);
        col1.setMinWidth(120);
        TableColumn col2 = this.allDesignRulesTable.getColumnModel().getColumn(2);
        col2.setMinWidth(120);
        TableColumn col3 = this.allDesignRulesTable.getColumnModel().getColumn(3);
        col3.setMinWidth(370);
        col0 = this.selDesignRulesTable.getColumnModel().getColumn(0);
        col0.setMinWidth(30);
        col0.setMaxWidth(30);
        col1 = this.selDesignRulesTable.getColumnModel().getColumn(1);
        col1.setMinWidth(120);
        col2 = this.selDesignRulesTable.getColumnModel().getColumn(2);
        col2.setMinWidth(120);
        col3 = this.selDesignRulesTable.getColumnModel().getColumn(3);
        col3.setMinWidth(370);
        JScrollPane allScrollPane = new JScrollPane(this.allDesignRulesTable);
        JScrollPane selScrollPane = new JScrollPane(this.selDesignRulesTable);
        allScrollPane.setPreferredSize(new Dimension(600, 300));
        selScrollPane.setPreferredSize(new Dimension(600, 300));
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignRuleView.AllRules")));
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignRuleView.SelectedRules")));
        rightPanel.add((Component)selScrollPane, "West");
        JPanel buttonPanel = new JPanel(new GridLayout(3, 1));
        JPanel jp1 = new JPanel();
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JPanel jpButtons = new JPanel(new BorderLayout());
        this.buttonRuleAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonRuleAdd.addActionListener(new AddRuleActionListener());
        this.buttonRuleAdd.setEnabled(false);
        this.buttonRuleAdd.setToolTipText(Messages.getString("DesignRuleView.AddRule"));
        this.buttonRuleRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonRuleRemove.setEnabled(false);
        this.buttonRuleRemove.addActionListener(new RemoveRuleActionListener());
        this.buttonRuleRemove.setToolTipText(Messages.getString("DesignRuleView.RemoveRule"));
        this.buttonRuleAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRuleRemove.setPreferredSize(this.buttonRuleAdd.getPreferredSize());
        jpButtons.add((Component)this.buttonRuleAdd, "North");
        jpButtons.add((Component)this.buttonRuleRemove, "Center");
        jp1.add(jpButtons);
        buttonPanel.add(new JPanel());
        buttonPanel.add(jp1);
        buttonPanel.add(new JPanel());
        leftPanel.add((Component)allScrollPane, "West");
        this.mainPanel.add((Component)buttonPanel, "Center");
        this.mainPanel.add((Component)leftPanel, "West");
        this.mainPanel.add((Component)rightPanel, "East");
        JPanel bottomPanel = this.getButtonPanel();
        this.mainPanel.add((Component)bottomPanel, "South");
        this.initRules();
    }

    public String getCaption() {
        return Messages.getString("DesignRuleView.RuleSetProperties");
    }

    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 680 : 630;
    }

    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 560 : 500;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("DesignRuleView.RuleSetProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "RULESET_PROPERRTIES_DIALOG";
    }

    public int showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    private void initRules() {
        this.allDesignRulesList.clear();
        this.selDesignRulesList.clear();
        this.allRules.clear();
        this.allDesignRulesList.addAll(this.parent.getAllDesignRules());
        this.selDesignRulesList.addAll(this.drs.getDesignRules());
        this.selDesignRulesList.addAll(this.drs.getDesignRulesMissing());
        this.allRules.addAll(this.allDesignRulesList);
        for (DesignRule dr : this.selDesignRulesList) {
            for (DesignRule dr1 : this.allRules) {
                if (!dr.getRuleId().equals(dr1.getRuleId())) continue;
                this.allDesignRulesList.remove(dr1);
            }
        }
        this.sort(this.allDesignRulesList);
        this.sort(this.selDesignRulesList);
        this.allDesignRulesTable.updateUI();
        this.selDesignRulesTable.updateUI();
    }

    protected JPanel getButtonPanel() {
        if (this.btnPanel == null) {
            this.btnPanel = new JPanel();
            JButton ok = new JButton(Messages.getString("DesignRuleView.OK"));
            ok.setMnemonic(79);
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignRuleSetPropertiesDialog.this.applyRulesToRuleset();
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
                    DesignRuleSetPropertiesDialog.this.result = 1;
                    DesignRuleSetPropertiesDialog.this.close();
                }
            });
            JButton cancel = new JButton(Messages.getString("DesignRuleView.Cancel"));
            cancel.setMnemonic(67);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignRuleSetPropertiesDialog.this.result = 0;
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(false);
                    ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = true;
                    DesignRuleSetPropertiesDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnPanel.add(ok);
            this.btnPanel.add(cancel);
            this.btnPanel.add(bnHelp);
        }
        return this.btnPanel;
    }

    private void applyRulesToRuleset() {
        this.drs.getDesignRules().clear();
        int i = this.selDesignRulesList.size();
        if (i > 0) {
            for (int h = 0; h < i; ++h) {
                if (this.selDesignRulesTable.getValueAt(h, 2).equals(NA)) continue;
                DesignRule dr = this.selDesignRulesList.get(h);
                this.drs.addRule(dr);
            }
        }
    }

    public void sort(List list) {
        Collections.sort(list, new DRComparator());
    }

    class DRComparator
    implements Comparator {
        DRComparator() {
        }

        public int compare(Object one, Object two) {
            DesignRule dr1 = (DesignRule)one;
            DesignRule dr2 = (DesignRule)two;
            if (!(dr1 instanceof DRTemporary) && !(dr2 instanceof DRTemporary)) {
                String s1 = "";
                s1 = dr1.getRuleHandler() != null ? dr1.getContextString() + dr1.getRuleHandler().getLabel() + dr1.getName() : dr1.getContextString() + "" + dr1.getName();
                String s2 = "";
                s2 = dr2.getRuleHandler() != null ? dr2.getContextString() + dr2.getRuleHandler().getLabel() + dr2.getName() : dr2.getContextString() + "" + dr2.getName();
                return s1.compareTo(s2);
            }
            return 0;
        }
    }

    public class SelectedDRRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 3947219013441913836L;
        Color color = new Color(204, 255, 255);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color fc = null;
            if (table.getValueAt(row, 2).equals(DesignRuleSetPropertiesDialog.NA)) {
                fc = Color.RED;
            }
            comp.setForeground(fc);
            return comp;
        }
    }

    private class RemoveRuleActionListener
    implements ActionListener {
        private RemoveRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectedRows();
            ArrayList<DesignRule> tempList = new ArrayList<DesignRule>();
            for (int i = 0; i < selected.length; ++i) {
                DesignRuleSetPropertiesDialog.this.currentRule = (DesignRule)DesignRuleSetPropertiesDialog.this.selDesignRulesList.get(selected[i]);
                if (DesignRuleSetPropertiesDialog.this.allDesignRulesList.contains(DesignRuleSetPropertiesDialog.this.currentRule)) continue;
                tempList.add(DesignRuleSetPropertiesDialog.this.currentRule);
                DesignRuleSetPropertiesDialog.this.allDesignRulesList.add(DesignRuleSetPropertiesDialog.this.currentRule);
            }
            DesignRuleSetPropertiesDialog.this.selDesignRulesList.removeAll(tempList);
            DesignRuleSetPropertiesDialog.this.sort(DesignRuleSetPropertiesDialog.this.allDesignRulesList);
            DesignRuleSetPropertiesDialog.this.allDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.selDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.selDesignRulesTable.getSelectionModel().setSelectionInterval(0, 0);
            DesignRuleSetPropertiesDialog.this.buttonRuleRemove.setEnabled(DesignRuleSetPropertiesDialog.this.selDesignRulesList.size() > 0);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
        }
    }

    private class AddRuleActionListener
    implements ActionListener {
        private AddRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = DesignRuleSetPropertiesDialog.this.allDesignRulesTable.getSelectedRows();
            ArrayList<DesignRule> tempList = new ArrayList<DesignRule>();
            for (int i = 0; i < selected.length; ++i) {
                DesignRuleSetPropertiesDialog.this.currentRule = (DesignRule)DesignRuleSetPropertiesDialog.this.allDesignRulesList.get(selected[i]);
                if (DesignRuleSetPropertiesDialog.this.selDesignRulesList.contains(DesignRuleSetPropertiesDialog.this.currentRule)) continue;
                tempList.add(DesignRuleSetPropertiesDialog.this.currentRule);
                DesignRuleSetPropertiesDialog.this.selDesignRulesList.add(DesignRuleSetPropertiesDialog.this.currentRule);
            }
            DesignRuleSetPropertiesDialog.this.allDesignRulesList.removeAll(tempList);
            DesignRuleSetPropertiesDialog.this.sort(DesignRuleSetPropertiesDialog.this.selDesignRulesList);
            DesignRuleSetPropertiesDialog.this.allDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.selDesignRulesTable.updateUI();
            DesignRuleSetPropertiesDialog.this.allDesignRulesTable.getSelectionModel().setSelectionInterval(0, 0);
            DesignRuleSetPropertiesDialog.this.buttonRuleAdd.setEnabled(DesignRuleSetPropertiesDialog.this.allDesignRulesList.size() > 0);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.bnSaveRuleSets.setEnabled(true);
            ((DesignRuleSetPropertiesDialog)DesignRuleSetPropertiesDialog.this).parent.ruleSetsSaved = false;
        }
    }

    private class SelRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5686761803148703793L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.ModelType"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Object"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Name")};

        private SelRulesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleSetPropertiesDialog.this.selDesignRulesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignRule rs = (DesignRule)DesignRuleSetPropertiesDialog.this.selDesignRulesList.get(row);
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                if (rs.getRuleHandler() != null) {
                    return rs.getContextString();
                }
                return DesignRuleSetPropertiesDialog.NA;
            }
            if (col == 2) {
                if (rs.getRuleHandler() != null) {
                    return rs.getRuleHandler().getLabel();
                }
                return DesignRuleSetPropertiesDialog.NA;
            }
            if (col == 3) {
                return rs.getName();
            }
            return row + 1;
        }
    }

    private class AllRulesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5587454722645897967L;
        final String[] COL_NAMES = new String[]{" ", Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.ModelType"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Object"), Messages.getString("DesignRuleSetPropertiesDialog.DesignRuleSetPropertiesDialog.Name")};

        private AllRulesTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return DesignRuleSetPropertiesDialog.this.allDesignRulesList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignRule rs = (DesignRule)DesignRuleSetPropertiesDialog.this.allDesignRulesList.get(row);
            if (col == 0) {
                return row + 1;
            }
            if (col == 1) {
                return rs.getContextString();
            }
            if (col == 2) {
                return rs.getRuleHandler().getLabel();
            }
            if (col == 3) {
                return rs.getName();
            }
            return row + 1;
        }
    }
}

