/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCellEditor;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static DiagramCellEditor cellEditor = new DefaultDiagramCellEditor();
    protected AbstractDiagram diagram = null;
    protected CellMapper mapper = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected Map attributes = DiagramConstants.createMap();
    protected Map allAttributes;
    private List selfReferences = new ArrayList();

    public AbstractCellView(Object cell, AbstractDiagram diagram, CellMapper mapper) {
        this.cell = cell;
        this.diagram = diagram;
        this.mapper = mapper;
        this.updateAllAttributes();
    }

    public AbstractDiagram getDiagram() {
        return this.diagram;
    }

    public DiagramModel getModel() {
        return this.diagram.getModel();
    }

    public CellMapper getMapper() {
        return this.mapper;
    }

    @Override
    public Object getCell() {
        return this.cell;
    }

    public void setNewBounds(Rectangle bounds) {
        this.setNewBounds(bounds, true);
    }

    public void setNewBounds(Rectangle bounds, boolean postEdit) {
        Hashtable<Object, Map> attributeMap = new Hashtable<Object, Map>();
        Map attributes = DiagramConstants.createMap();
        DiagramConstants.setBounds(attributes, bounds);
        attributeMap.put(this.cell, attributes);
        this.diagram.getDiagramLayoutCache().edit(attributeMap, null, null, null, postEdit);
    }

    @Override
    public void refresh(boolean createDependentViews) {
        boolean reorder;
        this.update();
        if (this.mapper != null && this.getModel() != null) {
            Object par = this.getModel().getParent(this.cell);
            if (this.diagram.getDiagramLayoutCache().isVisible(par)) {
                CellView tmp = this.mapper.getMapping(par, createDependentViews);
                if (tmp != this.parent) {
                    this.removeFromParent();
                }
                this.parent = tmp;
            } else if (this.parent != null) {
                this.removeFromParent();
                this.parent = null;
            }
        }
        boolean bl = reorder = !this.diagram.getDiagramLayoutCache().isOrdered();
        if (reorder) {
            this.childViews.clear();
        }
        DiagramModel model = this.getModel();
        for (int i = 0; i < model.getChildCount(this.cell); ++i) {
            CellView view;
            Object child = model.getChild(this.cell, i);
            if (!this.diagram.getDiagramLayoutCache().isVisible(child) || (view = this.mapper.getMapping(child, createDependentViews)) == null || model.isPort(child) || this.childViews.contains(view) && !reorder) continue;
            this.childViews.add(view);
        }
    }

    @Override
    public void update() {
        this.updateAllAttributes();
        this.childUpdated();
    }

    protected void updateAllAttributes() {
        boolean exists = false;
        Object beginDashed = null;
        Object endDashed = null;
        this.allAttributes = this.getModel().getAttributes(this.cell);
        if (this.allAttributes != null) {
            exists = true;
            beginDashed = this.allAttributes.get("beginDashed");
            endDashed = this.allAttributes.get("endDashed");
            this.allAttributes = DiagramConstants.cloneMap(this.allAttributes);
        } else {
            this.allAttributes = DiagramConstants.createMap();
        }
        this.allAttributes.putAll(this.attributes);
        if (exists && beginDashed != null && endDashed != null) {
            this.allAttributes.put("beginDashed", beginDashed);
            this.allAttributes.put("endDashed", endDashed);
        }
    }

    @Override
    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
    }

    @Override
    public CellView getParentView() {
        return this.parent;
    }

    @Override
    public CellView[] getChildViews() {
        CellView[] array = new CellView[this.childViews.size()];
        this.childViews.toArray(array);
        return array;
    }

    public static CellView[] getDescendantViews(CellView[] views) {
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < views.length; ++i) {
            stack.add(views[i]);
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!stack.isEmpty()) {
            CellView tmp = (CellView)stack.pop();
            CellView[] children = tmp.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                stack.add(children[i]);
            }
            result.add(tmp);
        }
        CellView[] ret = new CellView[result.size()];
        result.toArray(ret);
        return ret;
    }

    @Override
    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public Map getAllAttributes() {
        return this.allAttributes;
    }

    @Override
    public Map setAttributes(Map change) {
        Map undo = DiagramConstants.applyMap(change, this.attributes);
        this.update();
        return undo;
    }

    @Override
    public abstract Rectangle2D getBounds();

    public static Rectangle2D getBounds(CellView[] views) {
        if (views != null && views.length > 0) {
            Rectangle2D ret = null;
            for (int i = 0; i < views.length; ++i) {
                Rectangle2D r;
                if (views[i] == null || (r = views[i].getBounds()) == null) continue;
                if (ret == null) {
                    ret = DiagramConstants.createRect(r);
                    continue;
                }
                Rectangle2D.union(ret, r, ret);
            }
            return ret;
        }
        return null;
    }

    public void setBounds(Rectangle2D bounds) {
        Rectangle2D oldBounds = this.getBounds();
        if (oldBounds == null) {
            oldBounds = DiagramConstants.createRect();
        }
        Point2D p0 = DiagramConstants.createPoint(oldBounds.getX(), oldBounds.getY());
        Point2D pe = DiagramConstants.createPoint(bounds.getX(), bounds.getY());
        Rectangle2D localBounds = DiagramConstants.createRect(bounds);
        if (DiagramConstants.isMoveable(this.getAttributes()) && !pe.equals(p0)) {
            this.translate(pe.getX() - p0.getX(), pe.getY() - p0.getY());
        } else {
            localBounds.setFrame(localBounds.getX(), localBounds.getY(), bounds.getWidth() - pe.getX() + p0.getX(), bounds.getHeight() - pe.getY() + p0.getY());
        }
        double lbw = localBounds.getWidth();
        double lbh = localBounds.getHeight();
        double obw = oldBounds.getWidth();
        double obh = oldBounds.getHeight();
        if ((lbw != obw || lbh != obh) && obw > 0.0 && obh > 0.0) {
            this.scale(lbw / obw, lbh / obh, pe);
        }
    }

    protected void translate(double dx, double dy) {
        if (this.isLeaf()) {
            DiagramConstants.translate(this.getAttributes(), dx, dy, this.getDiagram());
        } else {
            for (Object view : this.childViews) {
                if (!(view instanceof AbstractCellView)) continue;
                AbstractCellView child = (AbstractCellView)view;
                child.translate(dx, dy);
            }
        }
    }

    protected void scale(double sx, double sy, Point2D origin) {
        if (this.isLeaf()) {
            DiagramConstants.scale(this.getAttributes(), sx, sy, origin, this.getDiagram());
        } else {
            for (Object view : this.childViews) {
                AbstractCellView child;
                Map attributes;
                if (!(view instanceof AbstractCellView) || !DiagramConstants.isSizeable(attributes = (child = (AbstractCellView)view).getAttributes()) && !DiagramConstants.isAutoSize(attributes)) continue;
                child.scale(sx, sy, origin);
            }
        }
    }

    @Override
    public boolean intersects(Graphics g, Rectangle2D rect) {
        if (this.isLeaf()) {
            Rectangle2D bounds = this.getBounds();
            if (bounds != null) {
                return bounds.intersects(rect);
            }
        } else {
            Iterator it = this.childViews.iterator();
            while (it.hasNext()) {
                if (!((CellView)it.next()).intersects(g, rect)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, boolean selected, boolean focus, boolean preview) {
        CellViewRenderer cvr = this.getRenderer();
        if (cvr != null) {
            return cvr.getRendererComponent(diagram, this, selected, focus, preview);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    public abstract Point2D getCenterPoint();

    public abstract Point2D getPerimeterPoint(Point2D var1, Point2D var2, boolean var3);

    @Override
    public abstract CellHandle getHandle(DiagramContext var1);

    @Override
    public DiagramCellEditor getEditor() {
        return cellEditor;
    }

    private boolean containsSelfRef(EdgeView edge) {
        for (int i = 0; i < this.selfReferences.size(); ++i) {
            EdgeView ev = (EdgeView)this.selfReferences.get(i);
            if (edge.getCell() == null || ev.getCell() != edge.getCell()) continue;
            return true;
        }
        return false;
    }

    public int getSelfRefPos(EdgeView edge) {
        int pos;
        for (int i = this.selfReferences.size() - 1; i >= 0; --i) {
            EdgeView ev = (EdgeView)this.selfReferences.get(i);
            if (ev.isSelfReference() && ((DefaultEdge)ev.getCell()).getSource() != null && ((DefaultEdge)ev.getCell()).getTarget() != null) continue;
            this.selfReferences.remove(ev);
        }
        if (!this.containsSelfRef(edge)) {
            this.selfReferences.add(edge);
        }
        if ((pos = this.selfReferences.indexOf(edge)) < 0) {
            pos = 0;
        }
        return pos + 1;
    }
}

