/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.relational.DPVRelational;

public class ContainerRenderer
extends JLabel
implements CellViewRenderer {
    public static final String NOT_NULL = "*";
    public static final String ALLOW_NULL = "";
    protected static final Icon FK_ICON = GUIConfiguration.getInstance().getIcon("FKEY_SMALL_ICON");
    protected static final Icon KEY_ICON = GUIConfiguration.getInstance().getIcon("KEY_ICON");
    protected static final Icon PKEY_ICON = GUIConfiguration.getInstance().getIcon("PKEY_ICON");
    protected static final Icon REMOTE_TABLE_ICON = GUIConfiguration.getInstance().getIcon("REMOTE_TABLE_LINK_ICON");
    public static final int TITLE_PADDING = 3;
    public static final int COLUMN_PADDING = 1;
    public static final int COLUMN_LEFT = 25;
    public static final int DATATYPE_LEFT = 40;
    public static final int ALLOW_NULL_LEFT = 16;
    public static final int TYPE_LEFT = 2;
    public static final int ROW_SPACING = 3;
    public static final int MORE_ARROW_PADDING = 4;
    public static final int MORE_ARROW_WIDTH = 8;
    public static final int MORE_ARROW_HEIGHT = 8;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = Color.BLACK;
    protected transient Color defaultBackground = Color.WHITE;
    protected transient Color bordercolor;
    protected transient Color datatypeColor = new Color(0, 128, 0);
    protected transient Color allowNullColor = Color.RED;
    protected transient Color typeColor = Color.BLUE;
    protected transient int borderWidth;
    protected transient ContainerObject container;
    protected String title = "";
    protected String longName = "";
    public static Color SUMMARY_COLOR = new Color(207, 244, 202);
    public static Color TEMP_COLOR = new Color(255, 255, 255);
    public static Color LOGGING_COLOR = new Color(228, 228, 228);
    protected CellView view;

    protected Color getBackgroundColor() {
        return this.defaultBackground;
    }

    protected Color getElementsColor() {
        return Color.BLACK;
    }

    protected Font getElementsFont() {
        return new Font("Dialog", 0, 10);
    }

    protected Font getKeysFont() {
        return this.getTopView().getFontObject(EditableFonts.FO_KEY).getFont();
    }

    protected Color getKeyColor() {
        return this.getTopView().getFontObject(EditableFonts.FO_KEY).getColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView cellview, boolean sel, boolean focus, boolean preview) {
        if (cellview instanceof ContainerView) {
            ContainerDiagramCell containerCell = (ContainerDiagramCell)cellview.getCell();
            this.container = containerCell.getContainer();
            if (containerCell.getTopView() != null) {
                this.title = containerCell.getTopView().toString();
            }
            if (this.container.isBST()) {
                this.title = this.title + " (" + this.container.getBasedOnStructuredType().getName() + ")";
            }
            this.longName = containerCell.getDiagram().getDesignPartView().showSchemaName() && this.container.getSchemaObject() != null ? this.container.getSchemaObject().getName() + "." + this.title : this.title;
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            if (cellview.isLeaf()) {
                this.installAttributes(cellview);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            this.view = cellview;
            return this;
        }
        return null;
    }

    protected String getType() {
        return null;
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        Map map = view.getAllAttributes();
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setBorder(DiagramConstants.getBorder(map));
        this.bordercolor = DiagramConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = DiagramConstants.getForeground(map)) != null ? foreground : this.defaultForeground);
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.getBackgroundColor());
        this.setFont(this.diagram.getFont());
    }

    protected String getDataType(ContainedObjectWithDomain element) {
        Datatype datatype;
        if (this.container instanceof Entity || this.container instanceof Table) {
            String formulaDesc = element.getFormulaDesc();
            if (formulaDesc != null && formulaDesc.length() > 0 && ("Derived".equalsIgnoreCase(element.getSourceType()) || "Aggregate".equalsIgnoreCase(element.getSourceType()) || element instanceof Column && ((Column)element).isComputed().booleanValue())) {
                return formulaDesc;
            }
            if (element instanceof Attribute) {
                return ((Attribute)element).getLogicalRepresentationName();
            }
            if (element.isReference() && element.getDataType() instanceof StructuredType) {
                return "REF " + element.getDataType().toString();
            }
        }
        if ((datatype = element.getDataType()) instanceof DistinctType && element instanceof Column) {
            String rdbmsName = element.getSelectedRDBMSType().toString();
            if (rdbmsName.startsWith("DB2")) {
                return datatype.getName();
            }
            datatype = element.getDataType(rdbmsName);
        }
        if (datatype != null) {
            return datatype.toString();
        }
        return ALLOW_NULL;
    }

    protected int getMaxSize(String text, Font colFont, Graphics g) {
        FontMetrics fm = g.getFontMetrics(colFont);
        int size = fm.stringWidth(text);
        return size;
    }

    protected void strikeThrough(Graphics2D graph, String text, int x, int y) {
        FontMetrics fm = graph.getFontMetrics();
        int lineWidth = fm.stringWidth(text);
        int half = (int)((double)(fm.getAscent() - fm.getDescent()) / 2.2);
        Stroke stroke = graph.getStroke();
        graph.setStroke(new BasicStroke(Math.max(1, fm.getFont().getSize() / 10)));
        graph.drawLine(x, y - half, x + lineWidth, y - half);
        graph.setStroke(stroke);
    }

    @Override
    public void paint(Graphics g) {
        DesignPartView dpv;
        int yCursor;
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        g2.setPaint(this.getBackgroundColor());
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(this.getBorderColor());
        g.drawRect(0, 0, width - 1, height - 1);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getHeight();
        int classTypePos = yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.longName)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        if (this.container instanceof Table && ((Table)this.container).isRemoteObject()) {
            REMOTE_TABLE_ICON.paintIcon(this, g2, 2, 2);
        }
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        String[] wrappedTitle = ContainerRenderer.wrapText(this.longName, ContainerRenderer.getMaxChars(this.longName, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            if (this.container.isDeprecated()) {
                this.strikeThrough(g2, text, xCursor, yCursor);
            }
            yCursor += colTextHeight;
        }
        if (efo.getHiddenElements().size() > 0) {
            g.setColor(this.getBorderColor());
            int right = width - 4;
            int left = right - 8;
            int center = right - 4;
            int[] xPts = new int[]{center, left, right};
            int[] yPts = new int[]{2, 10, 10};
            g.fillPolygon(xPts, yPts, 3);
        }
        yCursor -= colTextHeight;
        String contType = this.getType();
        if (contType != null && contType.length() > 0) {
            g.drawString(contType, 5, classTypePos);
        }
        if ((dpv = this.getDesignPartView()) != null && !dpv.clearDetails()) {
            if (!dpv.isShowNamesOnly()) {
                List keys;
                int[] yPts;
                int top;
                int bottom;
                int keyIconYOffset;
                Icon icon;
                Iterator it;
                g2.setStroke(lineStroke);
                g.setColor(this.getBorderColor());
                g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                if (dpv.isShowClassificationTypes() && this.container instanceof ContainerWithKeyObject) {
                    ContainerWithKeyObject cwk = (ContainerWithKeyObject)this.container;
                    String clname = ALLOW_NULL;
                    ClassificationType ct = cwk.getClassificationType();
                    if (ct != null) {
                        clname = ct.getTypeName();
                    }
                    String clnames = ALLOW_NULL;
                    List<String> list = cwk.getAdd_ClassificationTypeNames();
                    for (int k = 0; k < list.size(); ++k) {
                        clnames = k > 0 ? clnames + ", " + list.get(k) : list.get(0);
                    }
                    if (!ALLOW_NULL.equals(clname) || !ALLOW_NULL.equals(clnames)) {
                        String types = !ALLOW_NULL.equals(clname) ? clname + " / " : "- / ";
                        types = !ALLOW_NULL.equals(clnames) ? types + clnames : types + "-";
                        xCursor = (width - fm.stringWidth(types)) / 2;
                        if (xCursor < 20) {
                            xCursor = 20;
                        }
                        g.setFont(titleFont);
                        g.drawString(types, xCursor, yCursor += colTextHeight);
                        g2.setStroke(lineStroke);
                        g.setColor(this.getBorderColor());
                        g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                    }
                }
                if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeyElements()) {
                    if (this.container.isBST() && this.container.getTypeSubstitution() != null) {
                        StructuredType st = this.container.getBasedOnStructuredType();
                        if (st != null) {
                            TypeElement[] elements = st.getElements();
                            String longestName = this.getLongestTypeName(elements);
                            g.setFont(this.getElementsFont());
                            fm = g.getFontMetrics();
                            colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                            for (int i = 0; i < elements.length; ++i) {
                                TypeElement elm = elements[i];
                                g.setColor(this.getElementsColor());
                                g.setFont(this.getElementsFont());
                                float fontSize = this.getElementsFont().getSize2D();
                                g.drawString(elm.getName(), 25, yCursor += fm.getHeight());
                                fm = g.getFontMetrics();
                                int anLeft = fm.stringWidth(longestName) + 50;
                                g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                                g.setFont(efo.getFontObject(EditableFonts.FO_DATATYPE).getFont().deriveFont(fontSize));
                                g.drawString(elm.getDataType(), anLeft, yCursor);
                                g.setColor(this.getForeground());
                            }
                        }
                    } else {
                        g2.setStroke(textStroke);
                        ContainedObject[] elements = this.container.getElements();
                        String longestName = this.getLongestName(elements);
                        String longestDTName = this.getLongestDTName(elements);
                        FontObject fo = efo.getFontObject(EditableFonts.FO_COLUMN);
                        if (fo == null) {
                            fo = efo.getFontObject(EditableFonts.FO_ATTRIBUTE);
                        }
                        Font colFont = fo.getFont();
                        float fontSize = Math.max(this.getElementsFont().getSize2D(), colFont.getSize2D());
                        colFont = colFont.deriveFont(fontSize);
                        int nameSize = this.getMaxSize(longestName, colFont, g2);
                        int dtNameSize = this.getMaxSize(longestDTName, colFont, g2);
                        int nnPos = this.getMaxSize("KW", colFont, g2);
                        int namePos = 3 + this.getMaxSize("KWN", colFont, g2);
                        int dtPos = 20 + namePos + nameSize;
                        int cPos = 20 + namePos + nameSize;
                        if (dpv.showAllDetails() || dpv.showDatatype()) {
                            cPos = 20 + dtPos + dtNameSize;
                        }
                        g.setFont(this.getElementsFont().deriveFont(fontSize));
                        fm = g.getFontMetrics();
                        colTextHeight = fm.getHeight();
                        for (int i = 0; i < elements.length; ++i) {
                            ContainedObjectWithDomain element = (ContainedObjectWithDomain)elements[i];
                            if (efo.getHiddenElements().contains(element) || element.isOid() || dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                            fm = g.getFontMetrics();
                            int anLeft = nnPos;
                            g.setColor(efo.getFontObject(EditableFonts.FO_NOT_NULL).getColor());
                            g.setFont(colFont);
                            g.drawString(element.getNullsAllowed() ? ALLOW_NULL : NOT_NULL, anLeft, yCursor += fm.getHeight());
                            String type = " ";
                            if (element.isPKElement()) {
                                type = "P";
                                g.setColor(efo.getFontObject(EditableFonts.FO_PK).getColor());
                                g.setFont(colFont);
                                if (element.isFKElement()) {
                                    type = type.concat("F");
                                }
                                g.drawString(type, 2, yCursor);
                            } else if (element.isUnique()) {
                                type = "U";
                                g.setColor(efo.getFontObject(EditableFonts.FO_UK).getColor());
                                g.setFont(colFont);
                                if (element.isFKElement()) {
                                    type = type.concat("F");
                                }
                                g.drawString(type, 2, yCursor);
                            } else if (element.isFKElement()) {
                                type = "F";
                                g.setColor(efo.getFontObject(EditableFonts.FO_FK).getColor());
                                g.setFont(colFont);
                                g.drawString(type, 2, yCursor);
                            } else {
                                g.setColor(this.getElementsColor());
                                g.setFont(colFont);
                            }
                            boolean hasSens = false;
                            boolean hasMask = false;
                            if ((ApplicationView.SHOW_MASKED_DATA || ApplicationView.SHOW_SENSITIVE_DATA) && element instanceof Column) {
                                String m;
                                Column col = (Column)element;
                                if (ApplicationView.SHOW_SENSITIVE_DATA) {
                                    Boolean sens = col.isContainsSensitiveInformation();
                                    boolean bl = hasSens = sens != null && sens != false;
                                }
                                if (ApplicationView.SHOW_MASKED_DATA && (m = col.getMaskingType()) != null && !"NO".equals(m) && !ALLOW_NULL.equals(m)) {
                                    hasMask = true;
                                }
                            }
                            if (hasSens || hasMask) {
                                g.setColor(Color.RED);
                                if (!hasMask) {
                                    g.setFont(g.getFont().deriveFont(3));
                                }
                            }
                            anLeft = namePos;
                            if (element.isDeprecated()) {
                                this.strikeThrough(g2, element.getName(), anLeft, yCursor);
                            }
                            g.drawString(element.getName(), anLeft, yCursor);
                            if (dpv.showAllDetails() || dpv.showDatatype()) {
                                g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                                g.setFont(colFont);
                                anLeft = dtPos;
                                if (hasSens && !hasMask) {
                                    g.setColor(Color.RED);
                                    g.setFont(g.getFont().deriveFont(3));
                                }
                                g.drawString(this.getDataType(element), anLeft, yCursor);
                            }
                            if (dpv.showComments()) {
                                g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                                g.setFont(colFont);
                                anLeft = cPos;
                                g.drawString(element.getCommentInRDBMS(), anLeft, yCursor);
                            }
                            g.setColor(this.getForeground());
                            if (yCursor <= height) continue;
                            g.setColor(this.getBorderColor());
                            int right = width - 4;
                            int left = right - 8;
                            int center = right - 4;
                            int bottom2 = height - 4;
                            int top2 = bottom2 - 8;
                            int[] xPts = new int[]{center, left, right};
                            int[] yPts2 = new int[]{bottom2, top2, top2};
                            g.fillPolygon(xPts, yPts2, 3);
                            break;
                        }
                    }
                }
                if (dpv.showAllDetails() || dpv.showKeys()) {
                    List keys2 = this.getKeys(((ContainerWithKeyObject)this.container).getKeys());
                    it = null;
                    if (keys2.size() > 0) {
                        if (dpv.showAllDetails() || dpv.showElements()) {
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            yCursor += 6;
                            for (KeyObject key : keys2) {
                                if (efo.getHiddenElements().contains(key)) continue;
                                g.drawLine(0, yCursor, width - 2, yCursor);
                                break;
                            }
                        }
                        g2.setStroke(textStroke);
                        for (KeyObject key : keys2) {
                            if (!key.isPK() && !key.isUnique() || efo.getHiddenElements().contains(key)) continue;
                            int LEFT = 4;
                            if (key.isPK()) {
                                icon = PKEY_ICON;
                                LEFT = 2;
                            } else {
                                icon = KEY_ICON;
                            }
                            g.setColor(this.getKeyColor());
                            g.setFont(this.getKeysFont());
                            fm = g.getFontMetrics();
                            yCursor += fm.getHeight();
                            keyIconYOffset = -(icon.getIconHeight() + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                            try {
                                icon.paintIcon(this, g, LEFT, yCursor + keyIconYOffset + 1);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            String keyName = key.getName();
                            if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                                Index ind;
                                ContainedObject[] columns = key.getElements();
                                keyName = keyName + " (";
                                String expr = null;
                                if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                                    expr = null;
                                }
                                if (expr == null) {
                                    for (int j = 0; j < columns.length; ++j) {
                                        ContainedObject column = columns[j];
                                        String colName = column.getName();
                                        if (j > 0) {
                                            keyName = keyName + ", ";
                                        }
                                        keyName = keyName + colName;
                                    }
                                } else {
                                    keyName = keyName + expr;
                                }
                                keyName = keyName + ")";
                            }
                            if (key.isDeprecated()) {
                                this.strikeThrough(g2, keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            }
                            g.drawString(keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            if (yCursor <= height) continue;
                            g.setColor(this.getBorderColor());
                            int right = width - 4;
                            int left = right - 8;
                            int center = right - 4;
                            bottom = height - 4;
                            top = bottom - 8;
                            int[] xPts = new int[]{center, left, right};
                            yPts = new int[]{bottom, top, top};
                            g.fillPolygon(xPts, yPts, 3);
                            break;
                        }
                    }
                }
                if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showFKeys())) {
                    List fKeys = this.getFKeys(((ContainerWithKeyObject)this.container).getKeys());
                    it = null;
                    if (fKeys.size() > 0) {
                        if (dpv.showAllDetails() || dpv.showElements()) {
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            yCursor += 6;
                            for (KeyObject key : fKeys) {
                                if (efo.getHiddenElements().contains(key)) continue;
                                g.drawLine(0, yCursor, width - 2, yCursor);
                                break;
                            }
                        }
                        g2.setStroke(textStroke);
                        for (KeyObject key : fKeys) {
                            if (efo.getHiddenElements().contains(key)) continue;
                            icon = FK_ICON;
                            int LEFT = 2;
                            g.setColor(this.getKeyColor());
                            g.setFont(this.getKeysFont());
                            fm = g.getFontMetrics();
                            yCursor += fm.getHeight();
                            keyIconYOffset = -(icon.getIconHeight() + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                            try {
                                icon.paintIcon(this, g, LEFT, yCursor + keyIconYOffset + 1);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            String keyName = key.getName();
                            if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                                Index ind;
                                ContainedObject[] columns = key.getElements();
                                keyName = keyName + " (";
                                String expr = null;
                                if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                                    expr = null;
                                }
                                if (expr == null) {
                                    for (int j = 0; j < columns.length; ++j) {
                                        ContainedObject column = columns[j];
                                        String colName = column.getName();
                                        if (j > 0) {
                                            keyName = keyName + ", ";
                                        }
                                        keyName = keyName + colName;
                                    }
                                } else {
                                    keyName = keyName + expr;
                                }
                                keyName = keyName + ")";
                            }
                            if (key.isDeprecated()) {
                                this.strikeThrough(g2, keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            }
                            g.drawString(keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            if (yCursor <= height) continue;
                            g.setColor(this.getBorderColor());
                            int right = width - 4;
                            int left = right - 8;
                            int center = right - 4;
                            bottom = height - 4;
                            top = bottom - 8;
                            int[] xPts = new int[]{center, left, right};
                            yPts = new int[]{bottom, top, top};
                            g.fillPolygon(xPts, yPts, 3);
                            break;
                        }
                    }
                }
                if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showIndexes()) && (keys = this.getIndexes(((ContainerWithKeyObject)this.container).getKeys())).size() > 0) {
                    if (dpv.showAllDetails() || dpv.showElements() || dpv.showKeys()) {
                        for (KeyObject key : keys) {
                            if (efo.getHiddenElements().contains(key)) continue;
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            g.drawLine(0, yCursor += 6, width - 2, yCursor);
                            break;
                        }
                    }
                    g2.setStroke(textStroke);
                    for (KeyObject key : keys) {
                        if (efo.getHiddenElements().contains(key)) continue;
                        int LEFT = 4;
                        icon = KEY_ICON;
                        g.setColor(this.getKeyColor());
                        g.setFont(this.getKeysFont());
                        fm = g.getFontMetrics();
                        yCursor += fm.getHeight();
                        keyIconYOffset = -(icon.getIconHeight() + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                        try {
                            icon.paintIcon(this, g, LEFT, yCursor + keyIconYOffset + 1);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        String keyName = key.getName();
                        if ((dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) && (dpv.showAllDetails() || dpv.showKeyAndIndexColumns())) {
                            Index ind;
                            ContainedObject[] columns = key.getElements();
                            keyName = keyName + " (";
                            String expr = null;
                            if (key instanceof Index && ALLOW_NULL.equals(expr = (ind = (Index)key).getIndexExpression())) {
                                expr = null;
                            }
                            if (expr == null) {
                                for (int j = 0; j < columns.length; ++j) {
                                    ContainedObject column = columns[j];
                                    String colName = column.getName();
                                    if (j > 0) {
                                        keyName = keyName + ", ";
                                    }
                                    keyName = keyName + colName;
                                }
                            } else {
                                keyName = keyName + expr;
                            }
                            keyName = keyName + ")";
                        }
                        if (key.isDeprecated()) {
                            this.strikeThrough(g2, keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                        }
                        g.drawString(keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                        if (yCursor <= height) continue;
                        g.setColor(this.getBorderColor());
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        bottom = height - 4;
                        top = bottom - 8;
                        int[] xPts = new int[]{center, left, right};
                        yPts = new int[]{bottom, top, top};
                        g.fillPolygon(xPts, yPts, 3);
                        break;
                    }
                }
            }
            String comments = this.container.getCommentInRDBMS().trim();
            if (dpv.showComments() && !ALLOW_NULL.equalsIgnoreCase(comments)) {
                g.setColor(this.getBorderColor());
                g2.setStroke(lineStroke);
                g.drawLine(0, yCursor += 6, width - 2, yCursor);
                g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                g.setFont(titleFont);
                fm = g.getFontMetrics();
                yCursor += fm.getHeight();
                String[] wrappedComments = ContainerRenderer.wrapText(comments, ContainerRenderer.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    String text = wrappedComments[t];
                    g.drawString(text, 5, yCursor);
                    yCursor += fm.getHeight();
                }
            }
        }
    }

    protected String getLongestName(ContainedObject[] elements) {
        String name = ALLOW_NULL;
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected String getLongestTypeName(TypeElement[] elements) {
        String name = ALLOW_NULL;
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected String getLongestDTName(ContainedObject[] elements) {
        String name = ALLOW_NULL;
        for (int i = 0; i < elements.length; ++i) {
            String n = this.getDataType((ContainedObjectWithDomain)elements[i]);
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected boolean allKeysAreFK(KeyObject[] keys) {
        boolean result = true;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            result = false;
            break;
        }
        return result;
    }

    protected List getFKeys(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isFK()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    protected List getKeys(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isPK() && !keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    protected List getIndexes(KeyObject[] keys) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK() || keys[i].isPK() || keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list;
    }

    public Point2D getPerimeterPoint(ContainerView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.container != null) {
            return this.container.getTopView();
        }
        return null;
    }

    public static String[] wrapText(String text, int length) {
        if (length > 0) {
            Pattern wrapRE = Pattern.compile("([\\S\\S&&[^\\p{Punct}]]{" + length + ",}|.{1," + length + "})(\\p{Punct}+|\\s+|$)");
            LinkedList<String> list = new LinkedList<String>();
            Matcher m = wrapRE.matcher(text);
            while (m.find()) {
                list.add(m.group());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[]{text};
    }

    public static int getMaxChars(String text, FontMetrics fm, int length) {
        for (int i = 0; i < text.length(); ++i) {
            String subStr = text.substring(0, i);
            int s1 = fm.stringWidth(subStr);
            if (s1 <= length) continue;
            return i;
        }
        return text.length();
    }
}

