/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelEvent;
import oracle.dbtools.crest.swingui.diagram.event.DiagramModelListener;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramLayoutCache;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.ParentMap;
import oracle.dbtools.crest.swingui.diagram.graph.Port;

public class DefaultDiagramModel
extends UndoableEditSupport
implements Serializable,
DiagramModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = new ArrayList();
    protected boolean asksAllowsChildren = false;
    protected Map attributes = new Hashtable();

    @Override
    public int getRootCount() {
        return this.roots.size();
    }

    @Override
    public Object getRootAt(int index) {
        return this.roots.get(index);
    }

    @Override
    public int getIndexOfRoot(Object root) {
        return this.roots.indexOf(root);
    }

    @Override
    public boolean contains(Object node) {
        Object parentNode = null;
        while ((parentNode = this.getParent(node)) != null) {
            node = parentNode;
        }
        return this.roots.contains(node);
    }

    @Override
    public Map getAttributes(Object node) {
        if (node instanceof DiagramCell) {
            return ((DiagramCell)node).getAttributes();
        }
        return this.attributes;
    }

    public Map getAttributes() {
        return this.getAttributes(null);
    }

    @Override
    public Object getSource(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getSource();
        }
        return null;
    }

    @Override
    public Object getTarget(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getTarget();
        }
        return null;
    }

    @Override
    public boolean acceptsSource(Object edge, Object port) {
        return true;
    }

    @Override
    public boolean acceptsTarget(Object edge, Object port) {
        return true;
    }

    @Override
    public Iterator edges(Object port) {
        if (port instanceof Port) {
            return ((Port)port).edges();
        }
        return this.emptyIterator;
    }

    @Override
    public boolean isEdge(Object edge) {
        return edge instanceof Edge;
    }

    @Override
    public boolean isPort(Object port) {
        return port instanceof Port;
    }

    @Override
    public Map cloneCells(Object[] cells) {
        Hashtable<DefaultDiagramCell, DefaultDiagramCell> map = new Hashtable<DefaultDiagramCell, DefaultDiagramCell>();
        ArrayList<Object> q = new ArrayList<Object>();
        for (int i = 0; i < cells.length; ++i) {
            q.add(cells[i]);
        }
        while (!q.isEmpty()) {
            DefaultMutableTreeNode p;
            Object node = q.remove(0);
            if (!(node instanceof DefaultDiagramCell)) continue;
            for (int i = 0; i < this.getChildCount(node); ++i) {
                q.add(this.getChild(node, i));
            }
            DefaultDiagramCell cell = (DefaultDiagramCell)node;
            DefaultDiagramCell clone = (DefaultDiagramCell)cell.clone();
            Object par = this.getParent(cell);
            if (par != null && (p = (DefaultMutableTreeNode)map.get(par)) != null) {
                p.add(clone);
            }
            map.put(cell, clone);
        }
        for (Object obj : map.values()) {
            Port anchor;
            if (!(obj instanceof Port) || (anchor = ((Port)obj).getAnchor()) == null) continue;
            ((Port)obj).setAnchor((Port)map.get(anchor));
        }
        return map;
    }

    @Override
    public Object getParent(Object child) {
        if (child != null && child instanceof TreeNode) {
            return ((TreeNode)child).getParent();
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    @Override
    public Object getChild(Object parent, int index) {
        try {
            if (parent instanceof TreeNode) {
                return ((TreeNode)parent).getChildAt(index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof TreeNode) {
            return ((TreeNode)parent).getChildCount();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (this.asksAllowsChildren && node instanceof TreeNode) {
            return !((TreeNode)node).getAllowsChildren();
        }
        return ((TreeNode)node).isLeaf();
    }

    @Override
    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        DiagramModelEdit edit = this.createInsertEdit(roots, attributes, cs, pm, edits);
        if (edit != null) {
            edit.execute();
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    if (!(edits[i] instanceof DiagramModelEvent.ExecutableDiagramChange)) continue;
                    ((DiagramModelEvent.ExecutableDiagramChange)((Object)edits[i])).execute();
                }
            }
            this.postEdit(edit);
        }
    }

    @Override
    public void remove(Object[] roots) {
        DiagramModelEdit edit = this.createRemoveEdit(roots);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    @Override
    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        this.edit(attributes, cs, pm, edits, true);
    }

    @Override
    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits, boolean postEdit) {
        if ((attributes == null || attributes.isEmpty()) && (cs == null || cs.isEmpty()) && pm == null && edits != null && edits.length == 1) {
            if (edits[0] instanceof DiagramModelEvent.ExecutableDiagramChange) {
                ((DiagramModelEvent.ExecutableDiagramChange)((Object)edits[0])).execute();
            }
            this.postEdit(edits[0]);
        } else {
            DiagramModelEdit edit = this.createCellEdit(attributes, cs, pm, edits);
            if (edit != null) {
                edit.execute();
                if (edits != null) {
                    for (int i = 0; i < edits.length; ++i) {
                        if (!(edits[i] instanceof DiagramModelEvent.ExecutableDiagramChange)) continue;
                        ((DiagramModelEvent.ExecutableDiagramChange)((Object)edits[i])).execute();
                    }
                }
                if (postEdit) {
                    this.postEdit(edit);
                }
            }
        }
    }

    @Override
    public void toBack(Object[] cells) {
        DiagramModelLayerEdit edit = this.createLayerEdit(cells, -2);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    @Override
    public void toFront(Object[] cells) {
        DiagramModelLayerEdit edit = this.createLayerEdit(cells, -1);
        if (edit != null) {
            edit.execute();
            this.postEdit(edit);
        }
    }

    protected DiagramModelLayerEdit createLayerEdit(Object[] cells, int layer) {
        return new DiagramModelLayerEdit(cells, layer);
    }

    protected DiagramModelEdit createInsertEdit(Object[] cells, Map attributeMap, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        DiagramModelEdit edit = this.createEdit(cells, null, attributeMap, cs, pm);
        if (edit != null) {
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    edit.addEdit(edits[i]);
                }
            }
            edit.end();
        }
        return edit;
    }

    protected DiagramModelEdit createRemoveEdit(Object[] cells) {
        ParentMap pm;
        ConnectionSet cs = ConnectionSet.create(this, cells, false);
        DiagramModelEdit edit = this.createEdit(null, cells, null, cs, pm = ParentMap.create(this, cells, true, false));
        if (edit != null) {
            edit.end();
        }
        return edit;
    }

    protected DiagramModelEdit createCellEdit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        DiagramModelEdit edit = this.createEdit(null, null, attributes, cs, pm);
        if (edit != null) {
            if (edits != null) {
                for (int i = 0; i < edits.length; ++i) {
                    edit.addEdit(edits[i]);
                }
            }
            edit.end();
        }
        return edit;
    }

    protected DiagramModelEdit createEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm) {
        return new DiagramModelEdit(inserted, removed, attributes, cs, pm);
    }

    protected Object[] handleInsert(Object[] cells) {
        Object[] inserted = null;
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (this.getParent(cells[i]) != null) continue;
                this.roots.add(cells[i]);
            }
            inserted = DefaultDiagramModel.getDescendants(this, cells).toArray();
        }
        return inserted;
    }

    protected Object[] handleRemove(Object[] cells) {
        ArrayList<Object> removedRoots = new ArrayList<Object>();
        if (cells != null) {
            for (int i = 0; i < cells.length; ++i) {
                if (this.getParent(cells[i]) != null || !this.roots.remove(cells[i])) continue;
                removedRoots.add(cells[i]);
            }
        }
        return removedRoots.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap undo = new ParentMap();
            Iterator it = parentMap.entries();
            while (it.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)it.next();
                Object child = entry.getChild();
                Object parent = entry.getParent();
                undo.addEntry(child, this.getParent(child));
                if (parent == null) {
                    if (child instanceof MutableTreeNode) {
                        ((MutableTreeNode)child).removeFromParent();
                    }
                } else if (parent instanceof DefaultMutableTreeNode && child instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)parent).add((MutableTreeNode)child);
                }
                boolean isRoot = this.roots.contains(child);
                if (parent == null && !isRoot) {
                    this.roots.add(child);
                    continue;
                }
                if (parent == null || !isRoot) continue;
                this.roots.remove(child);
            }
            return undo;
        }
        return null;
    }

    protected Map handleAttributes(Map attributes) {
        if (attributes != null) {
            Hashtable undo = new Hashtable();
            for (Map.Entry entry : attributes.entrySet()) {
                Object cell = entry.getKey();
                Map deltaNew = (Map)entry.getValue();
                if (cell instanceof DiagramCell) {
                    Map deltaOld = ((DiagramCell)cell).changeAttributes(deltaNew);
                    undo.put(cell, deltaOld);
                    continue;
                }
                Map attr = this.getAttributes(cell);
                if (attr == null) continue;
                Map deltaOld = DiagramConstants.applyMap(deltaNew, attr);
                undo.put(cell, deltaOld);
            }
            return undo;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet cs) {
        if (cs != null) {
            ConnectionSet csundo = new ConnectionSet();
            Iterator it = cs.connections();
            while (it.hasNext()) {
                ConnectionSet.Connection c = (ConnectionSet.Connection)it.next();
                Object edge = c.getEdge();
                if (c.isSource()) {
                    csundo.connect(edge, this.getSource(edge), true);
                } else {
                    csundo.connect(edge, this.getTarget(edge), false);
                }
                this.handleConnection(c);
            }
            return csundo;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection c) {
        Object edge = c.getEdge();
        Object old = c.isSource() ? this.getSource(edge) : this.getTarget(edge);
        Object port = c.getPort();
        if (port != old) {
            this.connect(edge, old, c.isSource(), true);
            if (this.contains(port) && this.contains(edge)) {
                this.connect(edge, port, c.isSource(), false);
            }
        }
    }

    protected void connect(Object edge, Object port, boolean isSource, boolean remove) {
        if (port instanceof Port) {
            if (remove) {
                ((Port)port).removeEdge(edge);
            } else {
                ((Port)port).addEdge(edge);
            }
        }
        if (remove) {
            port = null;
        }
        if (edge instanceof Edge) {
            if (isSource) {
                ((Edge)edge).setSource(port);
            } else {
                ((Edge)edge).setTarget(port);
            }
        }
    }

    @Override
    public void addDiagramModelListener(DiagramModelListener l) {
        this.listenerList.add(DiagramModelListener.class, l);
    }

    @Override
    public void removeDiagramModelListener(DiagramModelListener l) {
        this.listenerList.remove(DiagramModelListener.class, l);
    }

    protected void fireDiagramChanged(Object source, DiagramModelEvent.DiagramModelChange edit) {
        Object[] listeners = this.listenerList.getListenerList();
        DiagramModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DiagramModelListener.class) continue;
            if (e == null) {
                e = new DiagramModelEvent(source, edit);
            }
            ((DiagramModelListener)listeners[i + 1]).diagramChanged(e);
        }
    }

    public DiagramModelListener[] getDiagramModelListeners() {
        return (DiagramModelListener[])this.listenerList.getListeners(DiagramModelListener.class);
    }

    public static Object getSourceVertex(DiagramModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getSource(edge));
        }
        return null;
    }

    public static Object getTargetVertex(DiagramModel model, Object edge) {
        if (model != null) {
            return model.getParent(model.getTarget(edge));
        }
        return null;
    }

    public static Object[] getRoots(DiagramModel model) {
        Object[] cells = null;
        if (model != null) {
            cells = new Object[model.getRootCount()];
            for (int i = 0; i < cells.length; ++i) {
                cells[i] = model.getRootAt(i);
            }
        }
        return cells;
    }

    public static Set getEdges(DiagramModel model, Object[] cells) {
        HashSet result = new HashSet();
        Set allCells = DefaultDiagramModel.getDescendants(model, cells);
        if (allCells != null) {
            Iterator it = allCells.iterator();
            while (it.hasNext()) {
                Iterator edges = model.edges(it.next());
                while (edges.hasNext()) {
                    result.add(edges.next());
                }
            }
            result.removeAll(allCells);
        }
        return result;
    }

    public static Set getDescendants(DiagramModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = 0; i < cells.length; ++i) {
                stack.add(cells[i]);
            }
            HashSet result = new HashSet();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                for (int i = 0; i < model.getChildCount(tmp); ++i) {
                    stack.add(model.getChild(tmp, i));
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    public static List getDescendantList(DiagramModel model, Object[] cells) {
        if (cells != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i = cells.length - 1; i >= 0; --i) {
                stack.add(cells[i]);
            }
            LinkedList result = new LinkedList();
            while (!stack.isEmpty()) {
                Object tmp = stack.pop();
                for (int i = model.getChildCount(tmp) - 1; i >= 0; --i) {
                    stack.add(model.getChild(tmp, i));
                }
                if (tmp == null) continue;
                result.add(tmp);
            }
            return result;
        }
        return null;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public class DiagramModelLayerEdit
    extends DiagramLayoutCache.DiagramViewLayerEdit
    implements DiagramModelEvent.DiagramModelChange {
        protected Object[] parents;

        public DiagramModelLayerEdit(Object[] cells, int layer) {
            super(DefaultDiagramModel.this, cells, layer);
            HashSet<TreeNode> par = new HashSet<TreeNode>();
            for (int i = 0; i < cells.length; ++i) {
                if (!(cells[i] instanceof TreeNode)) continue;
                par.add(((TreeNode)cells[i]).getParent());
            }
            this.parents = par.toArray();
        }

        @Override
        public Object getSource() {
            return DefaultDiagramModel.this;
        }

        @Override
        public Object[] getChanged() {
            return this.parents;
        }

        @Override
        public Object[] getInserted() {
            return null;
        }

        @Override
        public Object[] getRemoved() {
            return null;
        }

        @Override
        public Map getPreviousAttributes() {
            return null;
        }

        @Override
        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        @Override
        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit edit) {
        }

        @Override
        public CellView[] getViews(DiagramLayoutCache view) {
            return null;
        }

        @Override
        public void putViews(DiagramLayoutCache view, CellView[] cellViews) {
        }

        @Override
        protected void updateListeners() {
            DefaultDiagramModel.this.fireDiagramChanged(DefaultDiagramModel.this, this);
        }

        @Override
        protected List getParentList(Object cell) {
            List list = null;
            if (cell instanceof DefaultMutableTreeNode) {
                TreeNode parent = ((DefaultMutableTreeNode)cell).getParent();
                list = parent instanceof DefaultDiagramCell ? ((DefaultDiagramCell)parent).getChildren() : DefaultDiagramModel.this.roots;
            }
            return list;
        }
    }

    public class DiagramModelEdit
    extends CompoundEdit
    implements DiagramModelEvent.DiagramModelChange,
    DiagramModelEvent.ExecutableDiagramChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();
        boolean inProgress_ = true;
        boolean firstExecute = true;
        String presentation;

        public DiagramModelEdit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet connectionSet, ParentMap parentMap) {
            this.insert = inserted;
            this.remove = removed;
            this.connectionSet = connectionSet;
            this.attributes = attributes;
            this.parentMap = parentMap;
            this.previousAttributes = attributes;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                Hashtable childCount = new Hashtable();
                Iterator it = parentMap.entries();
                while (it.hasNext()) {
                    Object newParent;
                    Object oldParent;
                    ParentMap.Entry entry = (ParentMap.Entry)it.next();
                    Object child = entry.getChild();
                    if (DefaultDiagramModel.this.isPort(child) || (oldParent = DefaultDiagramModel.this.getParent(child)) == (newParent = entry.getParent())) continue;
                    this.changeChildCount(childCount, oldParent, -1);
                    this.changeChildCount(childCount, newParent, 1);
                }
                this.handleEmptyGroups(this.filterParents(childCount, 0));
            }
            if (attributes != null && attributes.keySet().size() > 1) {
                this.presentation = Messages.getString("DefaultDiagramModel.MoveOfGroupOfObjects");
            } else if (attributes != null && attributes.keySet().size() == 1) {
                Iterator it = attributes.keySet().iterator();
                Object value = it.next();
                this.presentation = value instanceof DefaultDiagramCell && ((DefaultDiagramCell)value).getTopView() != null ? ((DefaultDiagramCell)value).getTopView().toString() : value.toString();
            }
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (!this.inProgress_) {
                return false;
            }
            UndoableEdit last = this.lastEdit();
            if (last == null) {
                this.edits.addElement(anEdit);
            } else if (!last.addEdit(anEdit)) {
                if (anEdit.replaceEdit(last)) {
                    this.edits.removeElementAt(this.edits.size() - 1);
                }
                this.edits.addElement(anEdit);
            }
            return true;
        }

        @Override
        public void end() {
            super.end();
            this.inProgress_ = false;
        }

        public Object[] filterParents(Map childCount, int children) {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : childCount.entrySet()) {
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != children) continue;
                list.add(entry.getKey());
            }
            return list.toArray();
        }

        protected void changeChildCount(Map childCount, Object parent, int change) {
            if (parent != null) {
                Integer count = (Integer)childCount.get(parent);
                if (count == null) {
                    count = new Integer(DefaultDiagramModel.this.getChildCount(parent));
                }
                int newValue = count + change;
                childCount.put(parent, new Integer(newValue));
            }
        }

        protected void handleEmptyGroups(Object[] groups) {
            if (groups != null && groups.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] tmp = new Object[this.remove.length + groups.length];
                System.arraycopy(this.remove, 0, tmp, 0, this.remove.length);
                System.arraycopy(groups, 0, tmp, this.remove.length, groups.length);
                this.remove = tmp;
            }
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public Object getSource() {
            return DefaultDiagramModel.this;
        }

        @Override
        public Object[] getChanged() {
            return this.changed;
        }

        @Override
        public Object[] getContext() {
            return this.context;
        }

        @Override
        public Object[] getInserted() {
            return this.inserted;
        }

        @Override
        public Object[] getRemoved() {
            return this.removed;
        }

        @Override
        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        @Override
        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        @Override
        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        @Override
        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        @Override
        public void execute() {
            HashSet tmp = new HashSet();
            if (this.attributes != null) {
                tmp.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                tmp.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                for (int i = 0; i < this.remove.length; ++i) {
                    tmp.remove(this.remove[i]);
                }
            }
            this.changed = tmp.toArray();
            Set ctx = DefaultDiagramModel.getEdges(DefaultDiagramModel.this, this.changed);
            if (this.firstExecute) {
                this.firstExecute = false;
                if (this.attributes != null && this.attributes.keySet().size() == 1) {
                    Object key = this.attributes.keySet().iterator().next();
                    Map map = (Map)this.attributes.get(key);
                    if (key instanceof DefaultEdge) {
                        List points = DiagramConstants.getPoints(map);
                        if (this.changed != null && this.changed.length == 1) {
                            map = ((DefaultDiagramCell)this.changed[0]).getAttributes();
                            List points2 = DiagramConstants.getPoints(map);
                            if (points != null && points2 != null) {
                                this.presentation = points.size() != points2.size() ? (points.size() > points2.size() ? MessageFormat.format(Messages.getString("DefaultDiagramModel.PointInserted"), this.presentation) : MessageFormat.format(Messages.getString("DefaultDiagramModel.PointDeleted"), this.presentation)) : MessageFormat.format(Messages.getString("DefaultDiagramModel.PointMoved"), this.presentation);
                            }
                        }
                    } else {
                        Rectangle2D rect = DiagramConstants.getBounds(map);
                        if (this.changed != null && this.changed.length == 1) {
                            map = ((DefaultDiagramCell)this.changed[0]).getAttributes();
                            Rectangle2D rect2 = DiagramConstants.getBounds(map);
                            if (rect != null && rect2 != null) {
                                this.presentation = rect.getWidth() != rect2.getWidth() || rect.getHeight() != rect2.getHeight() ? MessageFormat.format(Messages.getString("DefaultDiagramModel.Resize"), this.presentation) : MessageFormat.format(Messages.getString("DefaultDiagramModel.Move"), this.presentation);
                            }
                        }
                    }
                }
            }
            this.context = ctx.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultDiagramModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultDiagramModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                tmp.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultDiagramModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultDiagramModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultDiagramModel.this.handleAttributes(this.attributes);
            this.changed = tmp.toArray();
            DefaultDiagramModel.this.fireDiagramChanged(DefaultDiagramModel.this, this);
        }

        @Override
        public void putViews(DiagramLayoutCache view, CellView[] views) {
            if (view != null && views != null) {
                this.cellViews.put(view, views);
            }
        }

        @Override
        public CellView[] getViews(DiagramLayoutCache view) {
            return (CellView[])this.cellViews.get(view);
        }

        @Override
        public String toString() {
            int i;
            String s = new String();
            if (this.inserted != null) {
                s = s + Messages.getString("DefaultDiagramModel.Inserted");
                for (i = 0; i < this.inserted.length; ++i) {
                    s = s + "  " + this.inserted[i] + "\n";
                }
            } else {
                s = s + Messages.getString("DefaultDiagramModel.NoneInserted");
            }
            if (this.removed != null) {
                s = s + Messages.getString("DefaultDiagramModel.Removed");
                for (i = 0; i < this.removed.length; ++i) {
                    s = s + "  " + this.removed[i] + "\n";
                }
            } else {
                s = s + Messages.getString("DefaultDiagramModel.NoneRemoved");
            }
            if (this.changed != null && this.changed.length > 0) {
                s = s + Messages.getString("DefaultDiagramModel.Changed");
                for (i = 0; i < this.changed.length; ++i) {
                    s = s + "  " + this.changed[i] + "\n";
                }
            } else {
                s = s + Messages.getString("DefaultDiagramModel.NoneChanged");
            }
            s = this.parentMap != null ? s + this.parentMap.toString() : s + Messages.getString("DefaultDiagramModel.NoParentMap");
            return s;
        }

        public void setInProgress_(boolean inProgress_) {
            this.inProgress_ = inProgress_;
        }

        public String getPresentation() {
            return this.presentation;
        }

        public void setPresentation(String presentation) {
            this.presentation = presentation;
        }

        @Override
        public String getRedoPresentationName() {
            return MessageFormat.format(Messages.getString("DefaultDiagramModel.Redo"), this.presentation);
        }

        @Override
        public String getUndoPresentationName() {
            return MessageFormat.format(Messages.getString("DefaultDiagramModel.Undo"), this.presentation);
        }
    }
}

