/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramUI;

public class DiagramViewView
extends AbstractCellView {
    private DiagramViewRenderer renderer;
    protected Rectangle2D bounds;
    protected Rectangle2D groupBounds = DefaultDiagramCell.defaultBounds;
    public static transient int[] defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
    public static transient int[] xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
    public static transient int[] yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};

    public DiagramViewView(Object cell, AbstractDiagram diagram, CellMapper mapper) {
        super(cell, diagram, mapper);
        ((DefaultDiagramCell)cell).setCellView(this);
    }

    @Override
    public void update() {
        super.update();
        this.bounds = DiagramConstants.getBounds(this.allAttributes);
        this.groupBounds = null;
        TopView topView = ((DiagramViewDiagramCell)this.getCell()).getTopView();
        if (topView != null) {
            // empty if block
        }
    }

    @Override
    public void childUpdated() {
        super.childUpdated();
        this.groupBounds = null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return this.bounds;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    protected void updateGroupBounds() {
        CellView[] childViews = this.getChildViews();
        LinkedList<CellView> result = new LinkedList<CellView>();
        for (int i = 0; i < childViews.length; ++i) {
            if (!this.includeInGroupBounds(childViews[i])) continue;
            result.add(childViews[i]);
        }
        childViews = new CellView[result.size()];
        result.toArray(childViews);
        this.groupBounds = DiagramViewView.getBounds(childViews);
    }

    private boolean includeInGroupBounds(CellView view) {
        if (view instanceof EdgeView) {
            DiagramModel model = this.diagram.getModel();
            EdgeView edgeView = (EdgeView)view;
            if (edgeView.getCell() instanceof DefaultMutableTreeNode) {
                TreeNode target;
                TreeNode source;
                DefaultMutableTreeNode edge = (DefaultMutableTreeNode)edgeView.getCell();
                if (model.getSource(edge) instanceof TreeNode && ((DefaultMutableTreeNode)(source = (TreeNode)model.getSource(edge)).getParent()).isNodeDescendant(edge)) {
                    return false;
                }
                if (model.getTarget(edge) instanceof TreeNode && ((DefaultMutableTreeNode)(target = (TreeNode)model.getTarget(edge)).getParent()).isNodeDescendant(edge)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public CellViewRenderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new DiagramViewRenderer();
        }
        return this.renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext context) {
        if (DiagramConstants.isSizeable(this.getAllAttributes()) && context.getDiagram().isSizeable()) {
            return new SizeHandle(this, context);
        }
        return null;
    }

    @Override
    public Point2D getCenterPoint() {
        Rectangle2D r = this.getBounds();
        return DiagramConstants.createPoint(r.getCenterX(), r.getCenterY());
    }

    @Override
    public Point2D getPerimeterPoint(Point2D source, Point2D p, boolean simple) {
        return ((DiagramViewRenderer)this.getRenderer()).getPerimeterPoint(this, source, p, simple);
    }

    public static class SizeHandle
    implements CellViewHandle,
    Serializable {
        protected transient Image offscreen;
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient AbstractDiagram diagram;
        protected transient DiagramViewView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient DiagramContext context;
        protected transient Rectangle2D initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle2D[] r = new Rectangle2D[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = null;

        public SizeHandle(DiagramViewView vertexview, DiagramContext ctx) {
            this.diagram = ctx.getDiagram();
            this.vertex = vertexview;
            int sizeableAxis = DiagramConstants.getSizeableAxis(this.vertex.getAllAttributes());
            this.cursors = sizeableAxis == 1 ? xCursors : (sizeableAxis == 2 ? yCursors : defaultCursors);
            this.portViews = ctx.createTemporaryPortViews();
            this.initialBounds = DiagramConstants.createRect(this.vertex.getBounds());
            this.context = ctx;
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = DiagramConstants.createRect();
            }
            this.invalidate();
        }

        @Override
        public CellView getCellView() {
            return this.vertex;
        }

        public boolean isConstrainedSizeEvent(MouseEvent e) {
            DiagramUI ui = this.diagram.getUI();
            if (ui instanceof DefaultDiagramUI) {
                return ((DefaultDiagramUI)ui).isConstrainedMoveEvent(e);
            }
            return false;
        }

        @Override
        public void paint(Graphics g) {
            this.invalidate();
            g.setColor(this.diagram.getHandleColor());
            for (int i = 0; i < this.r.length; ++i) {
                if (this.cursors[i] == 0) continue;
                g.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
            }
        }

        protected void initOffscreen() {
            try {
                Rectangle rect = this.diagram.getBounds();
                this.offscreen = new BufferedImage(rect.width, rect.height, 1);
                this.offgraphics = this.offscreen.getGraphics();
                this.offgraphics.setClip(0, 0, rect.width, rect.height);
                this.offgraphics.setColor(this.diagram.getBackground());
                this.offgraphics.fillRect(0, 0, rect.width, rect.height);
                this.diagram.getUI().paint(this.offgraphics, this.diagram);
            }
            catch (Error e) {
                this.offscreen = null;
                this.offgraphics = null;
            }
        }

        @Override
        public void overlay(Graphics g) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    g.setColor(Color.black);
                    Rectangle2D tmp = this.diagram.toScreen(DiagramConstants.createRect(this.cachedBounds));
                    g.drawRect((int)tmp.getX(), (int)tmp.getY(), (int)tmp.getWidth() - 2, (int)tmp.getHeight() - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D g2 = (Graphics2D)g;
                    AffineTransform oldTransform = g2.getTransform();
                    g2.scale(this.diagram.getScale(), this.diagram.getScale());
                    this.diagram.getUI().paintCell(g, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        for (int i = 0; i < this.contextViews.length; ++i) {
                            this.diagram.getUI().paintCell(g, this.contextViews[i], this.contextViews[i].getBounds(), true);
                        }
                    }
                    g2.setTransform(oldTransform);
                    if (this.portViews != null && this.diagram.isPortsVisible()) {
                        this.diagram.getUI().paintPorts(g, this.portViews);
                    }
                }
            }
            this.firstOverlayInvocation = false;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (this.vertex != null) {
                for (int i = 0; i < this.r.length; ++i) {
                    if (!this.r[i].contains(event.getPoint())) continue;
                    this.diagram.setCursor(new Cursor(this.cursors[i]));
                    event.consume();
                    return;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!this.diagram.isSizeable()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(event.getPoint()) || this.cursors[i] == 0) continue;
                HashSet<Object> set = new HashSet<Object>();
                set.add(this.vertex.getCell());
                this.contextViews = this.context.createTemporaryContextViews(set);
                CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                if (all.length >= DefaultDiagramUI.MAXHANDLES) {
                    this.cachedBounds = DiagramConstants.createRect(this.initialBounds);
                }
                event.consume();
                this.index = i;
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Rectangle2D t;
            Graphics g;
            if (this.firstDrag && this.diagram.isDoubleBuffered() && this.cachedBounds == null) {
                this.firstDrag = false;
            }
            Rectangle2D dirty = null;
            Graphics graphics = g = this.offgraphics != null ? this.offgraphics : this.diagram.getGraphics();
            if (this.index == -1) {
                return;
            }
            Rectangle2D newBounds = this.computeBounds(event);
            g.setColor(this.diagram.getForeground());
            g.setXORMode(this.diagram.getBackground().darker());
            this.overlay(g);
            if (this.offgraphics != null) {
                dirty = this.diagram.toScreen(DiagramConstants.createRect(this.vertex.getBounds()));
                t = this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t != null) {
                    dirty.add(t);
                }
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = newBounds;
            } else {
                CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                for (int i = 0; i < all.length; ++i) {
                    CellView orig = this.diagram.getDiagramLayoutCache().getMapping(all[i].getCell(), false);
                    Map origAttr = DiagramConstants.cloneMap(orig.getAllAttributes());
                    all[i].setAttributes(origAttr);
                    all[i].refresh(false);
                }
                this.vertex.setBounds(newBounds);
                if (this.vertex != null) {
                    this.diagram.getDiagramLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.diagram.getDiagramLayoutCache().update(this.contextViews);
                }
            }
            this.overlay(g);
            if (this.offscreen != null) {
                dirty.add(this.diagram.toScreen(DiagramConstants.createRect(this.vertex.getBounds())));
                t = this.diagram.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t != null) {
                    dirty.add(t);
                }
                int size = 2;
                dirty.setFrame(dirty.getX() - (double)size, dirty.getY() - (double)size, dirty.getWidth() + (double)(size * 2), dirty.getHeight() + (double)(size * 2));
                double sx1 = DiagramConstants.NEGATIVE_ALLOWED ? dirty.getX() : Math.max(0.0, dirty.getX());
                double sy1 = DiagramConstants.NEGATIVE_ALLOWED ? dirty.getY() : Math.max(0.0, dirty.getY());
                double sx2 = sx1 + dirty.getWidth();
                double sy2 = sy1 + dirty.getHeight();
                this.diagram.getGraphics().drawImage(this.offscreen, (int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2, this.diagram);
            }
        }

        protected Rectangle2D computeBounds(MouseEvent event) {
            double left = this.initialBounds.getX();
            double right = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double top = this.initialBounds.getY();
            double bottom = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D p = this.diagram.fromScreen(this.diagram.snap(DiagramConstants.createPoint(event.getPoint())));
            if (!DiagramConstants.NEGATIVE_ALLOWED) {
                p.setLocation(Math.max(0.0, p.getX()), Math.max(0.0, p.getY()));
            }
            if (this.index > 4) {
                bottom = p.getY();
            } else if (this.index < 3) {
                top = p.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                left = p.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                right = p.getX();
            }
            double width = right - left;
            double height = bottom - top;
            if (this.isConstrainedSizeEvent(event)) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    height = width;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    width = height;
                } else {
                    height = width;
                    top = bottom - height;
                }
            }
            if (width < 0.0) {
                left += width;
                width = Math.abs(width);
            }
            if (height < 0.0) {
                top += height;
                height = Math.abs(height);
            }
            return DiagramConstants.createRect(left, top, width + 1.0, height + 1.0);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(e);
                this.vertex.setBounds(this.cachedBounds);
                Object[] views = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map attributes = DiagramConstants.createAttributes(views, null);
                this.diagram.getDiagramLayoutCache().edit(attributes, null, null, null);
            }
            e.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }

        private void invalidate() {
            Rectangle2D tmp = this.diagram.getCellBounds(this.vertex.getCell());
            if (tmp != null) {
                tmp = DiagramConstants.createRect(tmp);
                this.diagram.toScreen(tmp);
                int handlesize = this.diagram.getHandleSize();
                int s2 = 2 * handlesize;
                double left = tmp.getX() - (double)handlesize;
                double top = tmp.getY() - (double)handlesize;
                double w2 = tmp.getX() + tmp.getWidth() / 2.0 - (double)handlesize;
                double h2 = tmp.getY() + tmp.getHeight() / 2.0 - (double)handlesize;
                double right = tmp.getX() + tmp.getWidth() - (double)handlesize;
                double bottom = tmp.getY() + tmp.getHeight() - (double)handlesize;
                this.r[0].setFrame(left, top, s2, s2);
                this.r[1].setFrame(w2, top, s2, s2);
                this.r[2].setFrame(right, top, s2, s2);
                this.r[3].setFrame(left, h2, s2, s2);
                this.r[4].setFrame(right, h2, s2, s2);
                this.r[5].setFrame(left, bottom, s2, s2);
                this.r[6].setFrame(w2, bottom, s2, s2);
                this.r[7].setFrame(right, bottom, s2, s2);
            }
        }
    }
}

