/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.relational.FKEdge;
import oracle.dbtools.crest.swingui.diagram.util.Bezier;
import oracle.dbtools.crest.swingui.diagram.util.Spline2D;
import oracle.dbtools.crest.swingui.logical.DPVLogical;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient Graphics fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
    protected transient FontMetrics metrics;
    protected transient AbstractDiagram diagram;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean labelTransformEnabled;
    protected transient boolean transferable;
    protected transient boolean transferableSource;
    protected transient boolean transferableTarget;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;
    protected Bezier bezier;
    protected Spline2D spline;
    protected boolean beginDashed;
    protected boolean endDashed;

    public void setView(CellView value) {
        if (value instanceof EdgeView) {
            this.view = (EdgeView)value;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    protected int getLineWidth() {
        int width = ((DefaultDiagramCell)this.view.getCell()).getTopView().useDefaultColor() ? ((DefaultDiagramCell)this.view.getCell()).getTopView().getDefaultLineWidth() : ((DefaultDiagramCell)this.view.getCell()).getTopView().getLineWidth();
        if (this.view.isWiderLine()) {
            width += 2;
        }
        return width;
    }

    @Override
    public Color getForeground() {
        if (((DefaultDiagramCell)this.view.getCell()).getTopView().useDefaultColor()) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDefaultLineColor();
        }
        return ((DefaultDiagramCell)this.view.getCell()).getTopView().getBackgroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackground();
    }

    @Override
    public Color getFGColor() {
        return this.getForeground();
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof EdgeView && diagram != null) {
            this.diagram = diagram;
            this.focus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setView(view);
            return this;
        }
        return null;
    }

    private ApplicationView getAppView() {
        return ((Diagram)this.view.getDiagram()).getAppView();
    }

    public boolean intersects(AbstractDiagram diagram, CellView value, Rectangle r) {
        if (value instanceof EdgeView && diagram != null && value != null) {
            if (value.getCell() != null && value.getCell() instanceof FKEdge && ((FKEdge)value.getCell()).getTopView() == null) {
                return false;
            }
            this.setView(value);
            Graphics2D g2 = (Graphics2D)diagram.getGraphics();
            if (this.view.getShape() == null) {
                return false;
            }
            boolean hit = g2.hit(r, this.view.getShape(), true);
            if (hit) {
                return true;
            }
        }
        return false;
    }

    public Rectangle2D getBounds(CellView value) {
        try {
            if (value instanceof EdgeView && value != null) {
                this.setView(value);
                Rectangle2D r = this.getPaintBounds(this.view);
                int b = (int)Math.ceil(this.getLineWidth());
                r.setFrame(r.getX() - (double)b, r.getY() - (double)b, r.getWidth() + (double)(2 * b), r.getHeight() + (double)(2 * b));
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void installAttributes(CellView view) {
        Map map = view.getAllAttributes();
        this.beginDeco = DiagramConstants.getLineBegin(map);
        this.beginSize = DiagramConstants.getBeginSize(map);
        this.beginFill = DiagramConstants.isBeginFill(map) && this.isFillable(this.beginDeco);
        this.beginDashed = DiagramConstants.isBeginDashed(map);
        this.endDashed = DiagramConstants.isEndDashed(map);
        this.endDeco = DiagramConstants.getLineEnd(map);
        this.endSize = DiagramConstants.getEndSize(map);
        this.endFill = DiagramConstants.isEndFill(map) && this.isFillable(this.endDeco);
        this.lineStyle = DiagramConstants.getLineStyle(map);
        this.lineDash = DiagramConstants.getDashPattern(map);
        this.borderColor = DiagramConstants.getBorderColor(map);
        Color foreground = DiagramConstants.getLineColor(map);
        this.setForeground(foreground != null ? foreground : this.defaultForeground);
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setFont(DiagramConstants.getFont(map));
        Color tmp = DiagramConstants.getForeground(map);
        this.fontColor = tmp != null ? tmp : this.getForeground();
        this.fontGraphics.setFont(this.getFont());
        this.metrics = this.fontGraphics.getFontMetrics();
        this.labelTransformEnabled = false;
        this.transferable = DiagramConstants.isTransferable(map);
        this.transferableSource = DiagramConstants.isTransferableSource(map);
        this.transferableTarget = DiagramConstants.isTransferableTarget(map);
    }

    protected boolean isFillable(int decoration) {
        return decoration != 4 && decoration != 7 && decoration != 8;
    }

    public Rectangle2D getPaintBounds(EdgeView view) {
        this.setView(view);
        if (view.getShape() != null) {
            return view.getShape().getBounds();
        }
        return null;
    }

    private void paintBeginDashed(Graphics2D g2, boolean dashed) {
        if (dashed && this.view.lineShape != null) {
            GeneralPath shape = new GeneralPath();
            int n = this.view.getPointCount();
            if (n > 1) {
                Point2D[] p = new Point2D[n];
                for (int i = 0; i < n; ++i) {
                    p[i] = this.view.getPoint(i);
                }
                if (n == 2) {
                    shape.moveTo((float)p[0].getX(), (float)p[0].getY());
                    double x1 = p[1].getX() - p[0].getX();
                    double y1 = p[1].getY() - p[0].getY();
                    x1 = p[0].getX() + x1 / 2.0;
                    y1 = p[0].getY() + y1 / 2.0;
                    shape.lineTo((float)x1, (float)y1);
                } else {
                    shape.moveTo((float)p[0].getX(), (float)p[0].getY());
                    shape.lineTo((float)p[1].getX(), (float)p[1].getY());
                }
            }
            g2.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
            g2.setColor(this.diagram.getBackground());
            g2.draw(shape);
        }
    }

    private void paintEndDashed(Graphics2D g2, boolean dashed) {
        if (dashed && this.view.lineShape != null) {
            GeneralPath shape = new GeneralPath();
            int n = this.view.getPointCount();
            if (n > 1) {
                int i;
                Point2D[] p = new Point2D[n];
                for (i = 0; i < n; ++i) {
                    p[i] = this.view.getPoint(i);
                }
                if (n == 2) {
                    shape.moveTo((float)p[1].getX(), (float)p[1].getY());
                    double x1 = p[0].getX() - p[1].getX();
                    double y1 = p[0].getY() - p[1].getY();
                    x1 = p[1].getX() + x1 / 2.0;
                    y1 = p[1].getY() + y1 / 2.0;
                    shape.lineTo((float)x1, (float)y1);
                } else {
                    i = p.length;
                    shape.moveTo((float)p[i - 1].getX(), (float)p[i - 1].getY());
                    shape.lineTo((float)p[i - 2].getX(), (float)p[i - 2].getY());
                }
            }
            g2.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
            g2.setColor(this.diagram.getBackground());
            g2.draw(shape);
        }
    }

    @Override
    public void paint(Graphics g) {
        try {
            Shape edgeShape = this.view.getShape();
            if (edgeShape != null) {
                Graphics2D g2 = (Graphics2D)g;
                int c = 0;
                int j = 0;
                g2.setStroke(new BasicStroke(this.getLineWidth(), c, j));
                this.translateGraphics(g);
                g.setColor(this.getForeground());
                g.setFont(this.diagram.getFont());
                if (this.lineDash != null) {
                    g2.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
                }
                int not = this.getAppView().getSettings().getNotation();
                DesignPartView dpv = this.getDesignPartView();
                if (dpv != null) {
                    not = dpv.getNotation();
                }
                if (dpv != null && dpv instanceof DPVLogical) {
                    if (not == 1) {
                        if (this.beginDashed && this.endDashed) {
                            g2.setStroke(new BasicStroke(this.getLineWidth(), 0, 0, 10.0f, DiagramConstants.dash, 0.0f));
                            g2.draw(this.view.lineShape);
                        } else {
                            if (this.view.lineShape != null) {
                                g2.draw(this.view.lineShape);
                            }
                            this.paintBeginDashed(g2, this.beginDashed);
                            this.paintEndDashed(g2, this.endDashed);
                        }
                    } else if (this.view.lineShape != null) {
                        g2.draw(this.view.lineShape);
                    }
                } else if (this.view.lineShape != null) {
                    g2.draw(this.view.lineShape);
                }
                g2.setStroke(new BasicStroke(this.getLineWidth(), c, j));
                g.setColor(this.getForeground());
                g.setFont(this.diagram.getFont());
                if (this.view.beginShape != null) {
                    if (this.beginFill) {
                        g2.fill(this.view.beginShape);
                    }
                    g2.draw(this.view.beginShape);
                }
                if (this.view.endShape != null) {
                    if (this.endFill) {
                        g2.fill(this.view.endShape);
                    }
                    g2.draw(this.view.endShape);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void translateGraphics(Graphics g) {
        g.translate(-this.getX(), -this.getY());
    }

    protected Shape createShape() {
        try {
            int n = this.view.getPointCount();
            if (n > 1) {
                EdgeView tmp = this.view;
                Point2D[] p = new Point2D[n];
                for (int i = 0; i < n; ++i) {
                    p[i] = DiagramConstants.createPoint(tmp.getPoint(i));
                }
                if (this.view != tmp) {
                    this.view = tmp;
                    this.installAttributes(this.view);
                }
                if (this.view.sharedPath == null) {
                    this.view.sharedPath = new GeneralPath(1);
                } else {
                    this.view.sharedPath.reset();
                }
                this.view.endShape = null;
                this.view.lineShape = null;
                this.view.beginShape = null;
                Point2D p0 = p[0];
                Point2D pe = p[n - 1];
                Point2D p1 = p[1];
                Point2D p2 = p[n - 2];
                if (this.lineStyle == 12 && n > 2) {
                    this.bezier = new Bezier(p);
                    p2 = this.bezier.getPoint(this.bezier.getPointCount() - 1);
                } else if (this.lineStyle == 13 && n > 2) {
                    this.spline = new Spline2D(p);
                    double[] point = this.spline.getPoint(0.9875);
                    double scaledX = pe.getX() - (pe.getX() - point[0]) * 128.0;
                    double scaledY = pe.getY() - (pe.getY() - point[1]) * 128.0;
                    p2.setLocation(scaledX, scaledY);
                }
                boolean temp = this.transferable;
                this.transferable = temp && this.transferableSource;
                this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, p1, p0);
                this.transferable = temp && this.transferableTarget;
                this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, p2, pe);
                this.transferable = temp;
                this.view.sharedPath.moveTo((float)p0.getX(), (float)p0.getY());
                if (this.lineStyle == 12 && n > 2) {
                    Point2D[] b = this.bezier.getPoints();
                    this.view.sharedPath.quadTo((float)b[0].getX(), (float)b[0].getY(), (float)p1.getX(), (float)p1.getY());
                    for (int i = 2; i < n - 1; ++i) {
                        Point2D b0 = b[2 * i - 3];
                        Point2D b1 = b[2 * i - 2];
                        this.view.sharedPath.curveTo((float)b0.getX(), (float)b0.getY(), (float)b1.getX(), (float)b1.getY(), (float)p[i].getX(), (float)p[i].getY());
                    }
                    this.view.sharedPath.quadTo((float)b[b.length - 1].getX(), (float)b[b.length - 1].getY(), (float)p[n - 1].getX(), (float)p[n - 1].getY());
                } else if (this.lineStyle == 13 && n > 2) {
                    for (double t = 0.0; t <= 1.0; t += 0.0125) {
                        double[] xy = this.spline.getPoint(t);
                        this.view.sharedPath.lineTo((float)xy[0], (float)xy[1]);
                    }
                } else {
                    for (int i = 1; i < n - 1; ++i) {
                        this.view.sharedPath.lineTo((float)p[i].getX(), (float)p[i].getY());
                    }
                    this.view.sharedPath.lineTo((float)pe.getX(), (float)pe.getY());
                }
                this.view.sharedPath.moveTo((float)pe.getX(), (float)pe.getY());
                this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
                if (this.view.endShape != null) {
                    this.view.sharedPath.append(this.view.endShape, true);
                }
                if (this.view.beginShape != null) {
                    this.view.sharedPath.append(this.view.beginShape, true);
                }
                return this.view.sharedPath;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Shape createLineEnd(int size, int style, Point2D src, Point2D dst) {
        try {
            if (src.getX() == dst.getX() - 1.0 || src.getX() == dst.getX() + 1.0) {
                dst.setLocation(src.getX(), dst.getY());
            }
            if (src.getY() == dst.getY() - 1.0 || src.getY() == dst.getY() + 1.0) {
                dst.setLocation(dst.getX(), src.getY());
            }
            int d = (int)Math.max(1.0, dst.distance(src));
            int ax = (int)(-((double)size * (dst.getX() - src.getX()) / (double)d));
            int ay = (int)(-((double)size * (dst.getY() - src.getY()) / (double)d));
            if (style == 9) {
                Polygon poly = new Polygon();
                poly.addPoint((int)dst.getX(), (int)dst.getY());
                poly.addPoint((int)(dst.getX() + (double)(ax / 2) + (double)(ay / 3)), (int)(dst.getY() + (double)(ay / 2) - (double)(ax / 3)));
                Point2D last = (Point2D)dst.clone();
                dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
                poly.addPoint((int)dst.getX(), (int)dst.getY());
                poly.addPoint((int)(last.getX() + (double)(ax / 2) - (double)(ay / 3)), (int)(last.getY() + (double)(ay / 2) + (double)(ax / 3)));
                return poly;
            }
            if (style == 14) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)(dst.getX() + (double)ax * 1.5 + (double)(ay / 2)), (float)(dst.getY() + (double)ay * 1.5 - (double)(ax / 2)));
                path.lineTo((float)(dst.getX() + (double)ax * 1.5 - (double)(ay / 2)), (float)(dst.getY() + (double)ay * 1.5 + (double)(ax / 2)));
                Polygon poly = new Polygon();
                poly.addPoint((int)dst.getX(), (int)dst.getY());
                poly.addPoint((int)(dst.getX() + (double)ax + (double)(ay / 2)), (int)(dst.getY() + (double)ay - (double)(ax / 2)));
                Point2D last = (Point2D)dst.clone();
                dst.setLocation((int)(dst.getX() + (double)ax), (int)(dst.getY() + (double)ay));
                poly.addPoint((int)(last.getX() + (double)ax - (double)(ay / 2)), (int)(last.getY() + (double)ay + (double)(ax / 2)));
                path.append(poly, false);
                return path;
            }
            if (style == 2 || style == 1) {
                Polygon poly = new Polygon();
                poly.addPoint((int)dst.getX(), (int)dst.getY());
                poly.addPoint((int)(dst.getX() + (double)ax + (double)(ay / 2)), (int)(dst.getY() + (double)ay - (double)(ax / 2)));
                Point2D last = (Point2D)dst.clone();
                if (style == 1) {
                    dst.setLocation((int)(dst.getX() + (double)(ax * 2 / 3)), (int)(dst.getY() + (double)(ay * 2 / 3)));
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                } else if (style == 9) {
                    dst.setLocation(dst.getX() + (double)(2 * ax), dst.getY() + (double)(2 * ay));
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                } else {
                    dst.setLocation((int)(dst.getX() + (double)ax), (int)(dst.getY() + (double)ay));
                }
                poly.addPoint((int)(last.getX() + (double)ax - (double)(ay / 2)), (int)(last.getY() + (double)ay + (double)(ax / 2)));
                return poly;
            }
            if (style == 4) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)(dst.getX() + (double)ax + (double)(ay / 2)), (float)(dst.getY() + (double)ay - (double)(ax / 2)));
                path.lineTo((float)dst.getX(), (float)dst.getY());
                path.lineTo((float)(dst.getX() + (double)ax - (double)(ay / 2)), (float)(dst.getY() + (double)ay + (double)(ax / 2)));
                return path;
            }
            if (style == 5) {
                Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)(ax / 2) - (double)(size / 2)), (float)(dst.getY() + (double)(ay / 2) - (double)(size / 2)), size, size);
                dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
                return ellipse;
            }
            if (style == 15) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)(dst.getX() + (double)ax * 1.5 + (double)(ay / 2)), (float)(dst.getY() + (double)ay * 1.5 - (double)(ax / 2)));
                path.lineTo((float)(dst.getX() + (double)ax * 1.5 - (double)(ay / 2)), (float)(dst.getY() + (double)ay * 1.5 + (double)(ax / 2)));
                Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)(ax / 2) - (double)(size / 2)), (float)(dst.getY() + (double)(ay / 2) - (double)(size / 2)), size, size);
                dst.setLocation(dst.getX() + (double)ax, dst.getY() + (double)ay);
                path.append(ellipse, false);
                return path;
            }
            if (style == 7 || style == 8 || style == 0) {
                if (style == 0 && this.transferable) {
                    return null;
                }
                GeneralPath path = new GeneralPath(1, 4);
                if (style != 0) {
                    path.moveTo((float)(dst.getX() + (double)ax + (double)ay), (float)(dst.getY() + (double)ay - (double)ax));
                    path.lineTo((float)(dst.getX() + (double)ax - (double)ay), (float)(dst.getY() + (double)ay + (double)ax));
                }
                float offset = 1.9f;
                if (style == 8) {
                    path.moveTo((float)(dst.getX() + (double)((float)ax * offset) + (double)ay), (float)(dst.getY() + (double)((float)ay * offset) - (double)ax));
                    path.lineTo((float)(dst.getX() + (double)((float)ax * offset) - (double)ay), (float)(dst.getY() + (double)((float)ay * offset) + (double)ax));
                }
                if (!this.transferable) {
                    path.moveTo((float)dst.getX(), (float)dst.getY());
                    path.lineTo((float)(dst.getX() + (double)ax * 2.8), (float)(dst.getY() + (double)ay * 2.8));
                    dst.setLocation(dst.getX() + (double)ax * 2.8, dst.getY() + (double)ay * 2.8);
                    Polygon poly = new Polygon();
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(dst.getX() + (double)ax + (double)ay / 1.5), (int)(dst.getY() + (double)ay - (double)ax / 1.5));
                    Point2D last = (Point2D)dst.clone();
                    dst.setLocation(dst.getX() + (double)(ax * 2), dst.getY() + (double)(ay * 2));
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(last.getX() + (double)ax - (double)ay / 1.5), (int)(last.getY() + (double)ay + (double)ax / 1.5));
                    path.append(poly, false);
                }
                return path;
            }
            if (style == 16 || style == 17) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)dst.getX() + (float)ay, (float)(dst.getY() - (double)ax));
                path.lineTo((float)(dst.getX() + (double)(ax * 2)), (float)dst.getY() + (float)(ay * 2));
                path.lineTo((float)dst.getX() - (float)ay, (float)(dst.getY() + (double)ax));
                float offset = 2.1f;
                if (style == 17) {
                    path.moveTo((float)(dst.getX() + (double)((float)ax * offset) + (double)ay), (float)(dst.getY() + (double)((float)ay * offset) - (double)ax));
                    path.lineTo((float)(dst.getX() + (double)((float)ax * offset) - (double)ay), (float)(dst.getY() + (double)((float)ay * offset) + (double)ax));
                }
                if (!this.transferable) {
                    offset = 3.0f;
                    path.moveTo((float)dst.getX(), (float)dst.getY());
                    path.lineTo((float)(dst.getX() + (double)((float)ax * offset)), (float)(dst.getY() + (double)((float)ay * offset)));
                    dst.setLocation(dst.getX() + (double)((float)ax * offset), dst.getY() + (double)((float)ay * offset));
                    Polygon poly = new Polygon();
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(dst.getX() + (double)ax + (double)ay / 1.5), (int)(dst.getY() + (double)ay - (double)ax / 1.5));
                    Point2D last = (Point2D)dst.clone();
                    dst.setLocation(dst.getX() + (double)(ax * 2), dst.getY() + (double)(ay * 2));
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(last.getX() + (double)ax - (double)ay / 1.5), (int)(last.getY() + (double)ay + (double)ax / 1.5));
                    path.append(poly, false);
                }
                return path;
            }
            if (style == 18) {
                GeneralPath path = new GeneralPath(1, 4);
                float offset = 1.0f;
                path.moveTo((float)(dst.getX() + (double)((float)ax / offset) + (double)ay), (float)(dst.getY() + (double)((float)ay / offset) - (double)ax));
                path.lineTo((float)(dst.getX() + (double)((float)ax / offset) - (double)ay), (float)(dst.getY() + (double)((float)ay / offset) + (double)ax));
                int wh = (int)((double)size * 1.8);
                Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)ax * 2.7 - (double)(wh / 2)), (float)(dst.getY() + (double)ay * 2.7 - (double)(wh / 2)), wh, wh);
                path.append(ellipse, false);
                return path;
            }
            if (style == 19) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)dst.getX() + (float)ay, (float)(dst.getY() - (double)ax));
                path.lineTo((double)((float)(dst.getX() + (double)ax * 1.6)), (double)((float)dst.getY()) + (double)ay * 1.6);
                path.lineTo((float)dst.getX() - (float)ay, (float)(dst.getY() + (double)ax));
                int wh = (int)((double)size * 1.8);
                Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)ax * 2.8 - (double)(wh / 2)), (float)(dst.getY() + (double)ay * 2.8 - (double)(wh / 2)), wh, wh);
                path.append(ellipse, false);
                return path;
            }
            if (style == 20) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)dst.getX() + (float)ay, (float)(dst.getY() - (double)ax));
                path.lineTo((float)(dst.getX() + (double)(ax * 2)), (float)dst.getY() + (float)(ay * 2));
                path.lineTo((float)dst.getX() - (float)ay, (float)(dst.getY() + (double)ax));
                path.moveTo((float)dst.getX(), (float)dst.getY());
                path.lineTo((double)((float)(dst.getX() + (double)ax * 2.4)), (double)((float)dst.getY()) + (double)ay * 2.4);
                int wh = (int)((double)size * 1.8);
                Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)ax * 3.2 - (double)(wh / 2)), (float)(dst.getY() + (double)ay * 3.2 - (double)(wh / 2)), wh, wh);
                path.append(ellipse, false);
                dst.setLocation(dst.getX() + (double)ax * 4.1, dst.getY() + (double)ay * 4.1);
                return path;
            }
            if (style == 21) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)dst.getX() + (float)ay, (float)(dst.getY() - (double)ax));
                path.lineTo((float)(dst.getX() + (double)(ax * 2)), (float)dst.getY() + (float)(ay * 2));
                path.lineTo((float)dst.getX() - (float)ay, (float)(dst.getY() + (double)ax));
                path.moveTo((float)(dst.getX() + (double)ax * 2.5 + (double)ay / 1.5), (float)(dst.getY() + (double)ay * 2.5 - (double)ax / 1.5));
                path.lineTo((float)(dst.getX() + (double)ax * 3.5 - (double)ay / 1.5), (float)(dst.getY() + (double)ay * 3.5 + (double)ax / 1.5));
                path.moveTo((float)(dst.getX() + (double)ax * 3.5 + (double)ay / 1.5), (float)(dst.getY() + (double)ay * 3.5 - (double)ax / 1.5));
                path.lineTo((float)(dst.getX() + (double)ax * 2.5 - (double)ay / 1.5), (float)(dst.getY() + (double)ay * 2.5 + (double)ax / 1.5));
                if (!this.transferable) {
                    float offset = 4.0f;
                    path.moveTo((float)dst.getX(), (float)dst.getY());
                    path.lineTo((float)(dst.getX() + (double)((float)ax * offset)), (float)(dst.getY() + (double)((float)ay * offset)));
                    dst.setLocation(dst.getX() + (double)((float)ax * offset), dst.getY() + (double)((float)ay * offset));
                    Polygon poly = new Polygon();
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(dst.getX() + (double)ax + (double)ay / 1.5), (int)(dst.getY() + (double)ay - (double)ax / 1.5));
                    Point2D last = (Point2D)dst.clone();
                    dst.setLocation(dst.getX() + (double)(ax * 2), dst.getY() + (double)(ay * 2));
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(last.getX() + (double)ax - (double)ay / 1.5), (int)(last.getY() + (double)ay + (double)ax / 1.5));
                    path.append(poly, false);
                }
                return path;
            }
            if (style == 22) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)(dst.getX() + (double)ax + (double)ay), (float)(dst.getY() + (double)ay - (double)ax));
                path.lineTo((float)(dst.getX() + (double)ax - (double)ay), (float)(dst.getY() + (double)ay + (double)ax));
                float offset1 = 1.4f;
                float offset2 = 2.4f;
                path.moveTo((float)(dst.getX() + (double)((float)ax * offset1) + (double)((float)ay / offset1)), (float)(dst.getY() + (double)((float)ay * offset1) - (double)((float)ax / offset1)));
                path.lineTo((float)(dst.getX() + (double)((float)ax * offset2) - (double)((float)ay / offset1)), (float)(dst.getY() + (double)((float)ay * offset2) + (double)((float)ax / offset1)));
                path.moveTo((float)(dst.getX() + (double)((float)ax * offset2) + (double)((float)ay / offset1)), (float)(dst.getY() + (double)((float)ay * offset2) - (double)((float)ax / offset1)));
                path.lineTo((float)(dst.getX() + (double)((float)ax * offset1) - (double)((float)ay / offset1)), (float)(dst.getY() + (double)((float)ay * offset1) + (double)((float)ax / offset1)));
                if (!this.transferable) {
                    path.moveTo((float)dst.getX(), (float)dst.getY());
                    path.lineTo((float)(dst.getX() + (double)ax * 2.8), (float)(dst.getY() + (double)ay * 2.8));
                    dst.setLocation(dst.getX() + (double)ax * 2.8, dst.getY() + (double)ay * 2.8);
                    Polygon poly = new Polygon();
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(dst.getX() + (double)ax + (double)ay / 1.5), (int)(dst.getY() + (double)ay - (double)ax / 1.5));
                    Point2D last = (Point2D)dst.clone();
                    dst.setLocation(dst.getX() + (double)(ax * 2), dst.getY() + (double)(ay * 2));
                    poly.addPoint((int)dst.getX(), (int)dst.getY());
                    poly.addPoint((int)(last.getX() + (double)ax - (double)ay / 1.5), (int)(last.getY() + (double)ay + (double)ax / 1.5));
                    path.append(poly, false);
                }
                return path;
            }
            if (style == 23) {
                GeneralPath path = new GeneralPath(1, 4);
                path.moveTo((float)(dst.getX() + (double)ax + (double)ay), (float)(dst.getY() + (double)ay - (double)ax));
                path.lineTo((float)(dst.getX() + (double)ax - (double)ay), (float)(dst.getY() + (double)ay + (double)ax));
                path.moveTo((float)dst.getX(), (float)dst.getY());
                path.lineTo((double)((float)(dst.getX() + (double)ax * 1.6)), (double)((float)dst.getY()) + (double)ay * 1.6);
                int wh = (int)((double)size * 1.8);
                Ellipse2D.Float ellipse = new Ellipse2D.Float((float)(dst.getX() + (double)ax * 2.7 - (double)(wh / 2)), (float)(dst.getY() + (double)ay * 2.7 - (double)(wh / 2)), wh, wh);
                path.append(ellipse, false);
                dst.setLocation(dst.getX() + (double)ax * 3.3, dst.getY() + (double)ay * 3.3);
                return path;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
        this.createShape();
        this.update(this.getGraphics());
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }
}

