/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellHandle;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramContext;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.ui.DiagramUI;
import oracle.dbtools.crest.swingui.diagram.ui.def.DefaultDiagramUI;

public class EdgeView
extends AbstractCellView {
    public static EdgeRenderer renderer = new EdgeRenderer();
    protected List points;
    protected CellView source;
    protected CellView target;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected Rectangle2D cachedLabelBounds = null;
    protected Rectangle2D cachedBounds = null;
    private double sourceOffcet = 0.0;
    private double targetOffcet = 0.0;
    private boolean dragging = false;
    private boolean widerLine = false;
    private PortView portView = null;

    public EdgeView(Object cell, AbstractDiagram diagram, CellMapper mapper) {
        super(cell, diagram, mapper);
        ((DefaultDiagramCell)cell).setCellView(this);
    }

    @Override
    public void refresh(boolean createDependentViews) {
        super.refresh(createDependentViews);
        if (this.points != null) {
            Object modelSource = this.getModel().getSource(this.cell);
            Object modelTarget = this.getModel().getTarget(this.cell);
            this.setSource(this.mapper.getMapping(modelSource, createDependentViews));
            this.setTarget(this.mapper.getMapping(modelTarget, createDependentViews));
        }
    }

    public void refreshLabels() {
        TVConnector tv;
        if (this.points != null && (tv = (TVConnector)((DefaultDiagramCell)this.cell).getTopView()) != null && !tv.wait) {
            try {
                if (tv.getLabel(0) != null || tv.getLabel(2) != null) {
                    double ypt;
                    double yps;
                    double xpt;
                    double xps;
                    Point2D ps = ((PortView)this.getSource()).getLocation(this);
                    Point2D pt = ((PortView)this.getTarget()).getLocation(this);
                    Rectangle2D rs = this.getSource().getParentView().getBounds();
                    Rectangle2D rt = this.getTarget().getParentView().getBounds();
                    Object obj1 = this.points.get(0);
                    Object obj2 = this.points.get(this.points.size() - 1);
                    if (this.points.size() > 2) {
                        obj1 = this.points.get(this.points.size() - 2);
                        obj2 = this.points.get(1);
                    }
                    Point2D p1 = obj1 instanceof PortView ? ((PortView)obj1).getPoint() : (Point2D)obj1;
                    Point2D p2 = obj2 instanceof PortView ? ((PortView)obj2).getPoint() : (Point2D)obj2;
                    if (this.points.size() > 2) {
                        if (ps.getX() < pt.getX()) {
                            if (ps.getX() == p2.getX()) {
                                xps = ps.getX() + 5.0;
                                xpt = pt.getX() + 5.0;
                            } else {
                                xps = ps.getX();
                                xpt = pt.getX() - 15.0;
                            }
                        } else if (ps.getX() == p2.getX()) {
                            xps = ps.getX() + 5.0;
                            xpt = pt.getX() + 5.0;
                        } else {
                            xps = ps.getX() - 15.0;
                            xpt = pt.getX();
                        }
                        if (ps.getY() < pt.getY()) {
                            if (ps.getY() == p2.getY()) {
                                yps = ps.getY() + 5.0;
                                ypt = pt.getY() + 5.0;
                            } else {
                                yps = ps.getY();
                                ypt = pt.getY() - 15.0;
                            }
                        } else if (ps.getY() == p2.getY()) {
                            yps = ps.getY() + 5.0;
                            ypt = pt.getY() + 5.0;
                        } else {
                            yps = ps.getY() - 15.0;
                            ypt = pt.getY();
                        }
                    } else if (ps.getX() != pt.getX() && ps.getY() != pt.getY()) {
                        xps = ps.getX() + 15.0;
                        xpt = pt.getX() + 15.0;
                        yps = ps.getY();
                        ypt = pt.getY();
                    } else {
                        if (ps.getX() < pt.getX()) {
                            xps = ps.getX() - 15.0;
                            xpt = pt.getX();
                        } else if (ps.getX() > pt.getX()) {
                            xps = ps.getX();
                            xpt = pt.getX() - 15.0;
                        } else {
                            xps = ps.getX() + 5.0;
                            xpt = pt.getX() + 5.0;
                        }
                        if (ps.getY() < pt.getY()) {
                            yps = ps.getY() - 15.0;
                            ypt = pt.getY();
                        } else if (ps.getY() > pt.getY()) {
                            yps = ps.getY();
                            ypt = pt.getY() - 15.0;
                        } else {
                            yps = ps.getY() + 5.0;
                            ypt = pt.getY() + 5.0;
                        }
                    }
                    Point2D.Double p1pv = new Point2D.Double(xps, yps);
                    Point2D.Double p2pv = new Point2D.Double(xpt, ypt);
                    tv.updateLabelPos(p1pv, p2, rs, 0);
                    tv.updateLabelPos(p2pv, p1, rt, 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.points = DiagramConstants.getPoints(this.allAttributes);
        Edge.Routing routing = DiagramConstants.getRouting(this.allAttributes);
        if (routing != null) {
            routing.route(this, this.points);
        }
        if (this.getModel().getSource(this.cell) != null) {
            this.setSource(this.getSource());
        }
        if (this.getModel().getTarget(this.cell) != null) {
            this.setTarget(this.getTarget());
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    void invalidate() {
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public PortView getPortView() {
        return this.portView;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Override
    public boolean intersects(Graphics g, Rectangle2D rect) {
        Rectangle r = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        return this.getEdgeRenderer().intersects(this.diagram, this, r);
    }

    @Override
    public Rectangle2D getBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        this.cachedBounds = this.getEdgeRenderer().getBounds(this);
        return this.cachedBounds;
    }

    public EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(DiagramContext context) {
        return new EdgeHandle(this, context);
    }

    public CellView getSource() {
        return this.source;
    }

    public void setSource(CellView sourceView) {
        this.source = sourceView;
        if (this.source != null) {
            if (this.source instanceof PortView) {
                ((PortView)this.source).setPoint(this.getPoint(0));
            }
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public void setTarget(CellView targetView) {
        this.target = targetView;
        int n = this.points.size() - 1;
        if (this.target != null) {
            if (this.target instanceof PortView) {
                ((PortView)this.target).setPoint(this.getPoint(n));
            }
            this.points.set(n, this.target);
        } else {
            this.points.set(n, this.getPoint(n));
        }
        this.invalidate();
    }

    public List getPoints() {
        return DiagramConstants.getPoints(this.allAttributes);
    }

    public int getPointCount() {
        return this.getPoints().size();
    }

    public Point2D getPoint(int index) {
        try {
            this.portView = null;
            Object obj = this.points.get(index);
            if (obj instanceof PortView) {
                this.portView = (PortView)obj;
                return ((PortView)obj).getLocation(this);
            }
            if (obj instanceof CellView) {
                Rectangle2D r = ((CellView)obj).getBounds();
                return DiagramConstants.createPoint(r.getX(), r.getY());
            }
            if (obj instanceof Point2D) {
                return (Point2D)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setPoint(int index, Point2D p) {
        this.points.set(index, p);
        this.updateAllAttributes();
        this.invalidate();
    }

    public void addPoint(int index, Point2D p) {
        this.points.add(index, p);
        HashMap map = new HashMap();
        DiagramConstants.setPoints(map, this.points);
        this.setAttributes(map);
        this.invalidate();
    }

    public void removePoint(int index) {
        if (index > 0 && index < this.points.size() - 1) {
            this.points.remove(index);
            this.invalidate();
        }
    }

    public void updatePoints() {
        ConnectionSet cs = this.createConnectionSet(this, this.getCell(), false);
        Map nested = DiagramConstants.createAttributes(new CellView[]{this}, null);
        this.diagram.getDiagramLayoutCache().edit(nested, cs, null, null);
    }

    protected ConnectionSet createConnectionSet(EdgeView view, Object edge, boolean verbose) {
        ConnectionSet cs = new ConnectionSet();
        Object sourcePort = null;
        Object targetPort = null;
        if (view.getSource() != null) {
            sourcePort = view.getSource().getCell();
        }
        if (view.getTarget() != null) {
            targetPort = view.getTarget().getCell();
        }
        if (verbose || sourcePort != view.getDiagram().getModel().getSource(edge)) {
            cs.connect(edge, sourcePort, true);
        }
        if (verbose || targetPort != view.getDiagram().getModel().getTarget(edge)) {
            cs.connect(edge, targetPort, false);
        }
        return cs;
    }

    public static double getLength(CellView view) {
        double cost = 1.0;
        if (view instanceof EdgeView) {
            EdgeView edge = (EdgeView)view;
            Point2D last = null;
            Point2D current = null;
            for (int i = 0; i < edge.getPointCount(); ++i) {
                current = edge.getPoint(i);
                if (last != null) {
                    cost += last.distance(current);
                }
                last = current;
            }
        }
        return cost;
    }

    public boolean canDeleteBreakpoint() {
        int n = this.getPointCount();
        boolean canDelete = false;
        canDelete = this.isSelfReference() ? n > 4 : n > 2;
        return canDelete;
    }

    @Override
    public Point2D getCenterPoint() {
        return null;
    }

    @Override
    public Point2D getPerimeterPoint(Point2D source, Point2D p, boolean simple) {
        return null;
    }

    public boolean isSelfReference() {
        return this.source != null && this.target != null && this.source.getParentView() == this.target.getParentView();
    }

    public double getSourceOffcet() {
        return this.sourceOffcet;
    }

    public void setSourceOffcet(double sourceOffcet) {
        this.sourceOffcet = sourceOffcet;
    }

    public double getTargetOffcet() {
        return this.targetOffcet;
    }

    public void setTargetOffcet(double targetOffcet) {
        this.targetOffcet = targetOffcet;
    }

    public boolean isWiderLine() {
        return this.widerLine;
    }

    public void setWiderLine(boolean widerLine) {
        this.widerLine = widerLine;
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected AbstractDiagram diagram;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean sourceLabel = false;
        protected boolean targetLabel = false;
        protected boolean source = false;
        protected boolean target = false;
        protected Point2D currentPoint;
        protected PortView currectPort;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected transient Rectangle2D sourceLoc;
        protected transient Rectangle2D targetLoc;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;

        public EdgeHandle(EdgeView edge, DiagramContext ctx) {
            this.diagram = ctx.getDiagram();
            this.edge = edge;
            this.loc = new Rectangle();
            this.sourceLoc = new Rectangle();
            this.targetLoc = new Rectangle();
            this.orig = (EdgeView)this.diagram.getDiagramLayoutCache().getMapping(edge.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = DiagramConstants.isConnectable(edge.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edge) {
            this.relevantEdge = edge;
            this.r = new Rectangle[edge.getPointCount()];
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle();
            }
            this.invalidate();
        }

        @Override
        public void paint(Graphics g) {
            this.invalidate();
            for (int i = 0; i < this.r.length; ++i) {
                if (this.isEdgeConnectable) {
                    g.setColor(this.diagram.getHandleColor());
                } else {
                    g.setColor(this.diagram.getLockedHandleColor());
                }
                g.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
                CellView port = null;
                if (i == 0 && this.edge.getSource() != null) {
                    port = this.edge.getSource();
                } else if (i == this.r.length - 1 && this.edge.getTarget() != null) {
                    port = this.edge.getTarget();
                }
                if (port == null) continue;
                g.setColor(this.diagram.getLockedHandleColor());
                Point2D tmp = DiagramConstants.getOffset(port.getAllAttributes());
                if (tmp != null) {
                    g.drawLine((int)this.r[i].getX() + 1, (int)this.r[i].getY() + 1, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3);
                    g.drawLine((int)this.r[i].getX() + 1, (int)(this.r[i].getY() + this.r[i].getHeight()) - 3, (int)(this.r[i].getX() + this.r[i].getWidth()) - 3, (int)this.r[i].getY() + 1);
                    continue;
                }
                g.drawRect((int)this.r[i].getX() + 2, (int)this.r[i].getY() + 2, (int)this.r[i].getWidth() - 5, (int)this.r[i].getHeight() - 5);
            }
        }

        @Override
        public void overlay(Graphics g) {
            if (this.edge != null && !this.firstOverlayCall) {
                g.setColor(this.diagram.getForeground());
                g.setXORMode(this.diagram.getBackground().darker());
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform oldTransform = g2.getTransform();
                g2.scale(this.diagram.getScale(), this.diagram.getScale());
                this.diagram.getUI().paintCell(g, this.edge, this.edge.getBounds(), true);
                g2.setTransform(oldTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(g, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(g, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics g, CellView p) {
            boolean offset = DiagramConstants.getOffset(p.getAllAttributes()) != null;
            Rectangle2D r = offset ? p.getBounds() : p.getParentView().getBounds();
            r = this.diagram.toScreen(DiagramConstants.createRect(r));
            int s = 3;
            r.setFrame(r.getX() - (double)s, r.getY() - (double)s, r.getWidth() + (double)(2 * s), r.getHeight() + (double)(2 * s));
            this.diagram.getUI().paintCell(g, p, r, true);
        }

        protected boolean snap(boolean source, Point2D point) {
            CellView portView;
            boolean connect = this.diagram.isConnectable() && this.isEdgeConnectable;
            Object port = this.diagram.getPortForLocation(point.getX(), point.getY());
            if (port != null && connect && DiagramConstants.isConnectable((portView = this.diagram.getDiagramLayoutCache().getMapping(port, false)).getParentView().getAllAttributes())) {
                Object cell = this.edge.getCell();
                if (source && this.edge.getSource() != portView && this.edge.getDiagram().getModel().acceptsSource(cell, port)) {
                    this.overlay(this.diagram.getGraphics());
                    this.edge.setSource(portView);
                    this.edge.update();
                    this.overlay(this.diagram.getGraphics());
                } else if (!source && this.edge.getTarget() != portView && this.edge.getDiagram().getModel().acceptsTarget(cell, port)) {
                    this.overlay(this.diagram.getGraphics());
                    this.edge.setTarget(portView);
                    this.edge.update();
                    this.overlay(this.diagram.getGraphics());
                }
                return portView != null;
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent e) {
            DiagramUI ui = this.diagram.getUI();
            if (ui instanceof DefaultDiagramUI) {
                return ((DefaultDiagramUI)ui).isConstrainedMoveEvent(e);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent event) {
            return event.isControlDown() && (SwingUtilities.isLeftMouseButton(event) || SwingUtilities.isRightMouseButton(event));
        }

        public boolean isRemovePointEvent(MouseEvent event) {
            return event.isControlDown() && (SwingUtilities.isLeftMouseButton(event) || SwingUtilities.isRightMouseButton(event));
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.sourceLabel || this.targetLabel || this.currentPoint != null;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            for (int i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(event.getPoint())) continue;
                this.diagram.setCursor(new Cursor(1));
                event.consume();
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean bendable = this.diagram.isBendable() && DiagramConstants.isBendable(this.edge.getAllAttributes());
            boolean disconnectable = this.diagram.isDisconnectable() && DiagramConstants.isDisconnectable(this.orig.getAllAttributes());
            int x = event.getX();
            int y = event.getY();
            int index = 0;
            for (index = 0; index < this.r.length; ++index) {
                if (!this.r[index].contains(x, y)) continue;
                this.currentPoint = this.edge.getPoint(index);
                this.currectPort = this.edge.getPortView();
                this.source = index == 0 && (this.edge.getSource() == null || disconnectable && DiagramConstants.isDisconnectable(this.edge.getSource().getParentView().getAllAttributes()));
                this.target = index == this.r.length - 1 && (this.edge.getTarget() == null || disconnectable && DiagramConstants.isDisconnectable(this.edge.getTarget().getParentView().getAllAttributes()));
                break;
            }
            if (!this.isEditing() && this.diagram.isMoveable() && DiagramConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(x, y) && !this.isAddPointEvent(event) && !this.isRemovePointEvent(event)) {
                if (event.getClickCount() == this.diagram.getEditClickCount()) {
                    this.diagram.startEditingAtCell(this.edge);
                } else {
                    this.label = true;
                }
            } else if (!this.isEditing() && this.diagram.isMoveable() && DiagramConstants.isMoveable(this.edge.getAllAttributes()) && this.sourceLoc != null && this.sourceLoc.contains(x, y) && !this.isAddPointEvent(event) && !this.isRemovePointEvent(event)) {
                if (event.getClickCount() == this.diagram.getEditClickCount()) {
                    this.diagram.startEditingAtCell(this.edge);
                } else {
                    this.sourceLabel = true;
                }
            } else if (!this.isEditing() && this.diagram.isMoveable() && DiagramConstants.isMoveable(this.edge.getAllAttributes()) && this.targetLoc != null && this.targetLoc.contains(x, y) && !this.isAddPointEvent(event) && !this.isRemovePointEvent(event)) {
                if (event.getClickCount() == this.diagram.getEditClickCount()) {
                    this.diagram.startEditingAtCell(this.edge);
                } else {
                    this.targetLabel = true;
                }
            }
            if (this.isRemovePointEvent(event) && this.currentPoint != null && !this.source && !this.target && bendable) {
                if (this.edge.canDeleteBreakpoint()) {
                    this.edge.removePoint(index);
                    this.mouseReleased(event);
                }
            } else if (this.isAddPointEvent(event) && !this.isEditing() && bendable) {
                int s = this.diagram.getHandleSize();
                Rectangle2D rect = this.diagram.fromScreen(new Rectangle(x - s, y - s, 2 * s, 2 * s));
                if (this.edge.intersects(this.diagram.getGraphics(), rect)) {
                    Point2D point = this.diagram.fromScreen(this.diagram.snap(new Point(event.getPoint())));
                    double min = Double.MAX_VALUE;
                    double dist = 0.0;
                    for (int i = 0; i < this.edge.getPointCount() - 1; ++i) {
                        Point2D p1;
                        Point2D p = this.edge.getPoint(i);
                        dist = new Line2D.Double(p, p1 = this.edge.getPoint(i + 1)).ptLineDistSq(point);
                        if (!(dist < min)) continue;
                        min = dist;
                        index = i + 1;
                    }
                    this.edge.addPoint(index, point);
                    this.currentPoint = point;
                    this.reloadPoints(this.edge);
                    this.paint(this.diagram.getGraphics());
                }
            }
            if (this.isEditing()) {
                event.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            this.edge.setDragging(true);
            Point2D p = this.diagram.fromScreen(new Point(event.getPoint()));
            if (!(!this.isEditing() || this.source && this.snap(true, p) || this.target && this.snap(false, p) || !(this.source && this.edge.getDiagram().getModel().acceptsSource(this.edge.getCell(), null) || this.target && this.edge.getDiagram().getModel().acceptsTarget(this.edge.getCell(), null)) && (this.source || this.target))) {
                this.overlay(this.diagram.getGraphics());
                p = this.diagram.fromScreen(this.diagram.snap(new Point(event.getPoint())));
                if (this.isConstrainedMoveEvent(event)) {
                    EdgeView orig = (EdgeView)this.diagram.getDiagramLayoutCache().getMapping(this.edge.getCell(), false);
                    int index = 0;
                    if (this.target) {
                        index = orig.getPointCount() - 1;
                    }
                    Point2D origPoint = orig.getPoint(index);
                    double totDx = p.getX() - origPoint.getX();
                    double totDy = p.getY() - origPoint.getY();
                    if (Math.abs(totDx) < Math.abs(totDy)) {
                        p.setLocation(origPoint.getX(), p.getY());
                    } else {
                        p.setLocation(p.getX(), origPoint.getY());
                    }
                }
                if (!DiagramConstants.NEGATIVE_ALLOWED) {
                    p.setLocation(Math.max(0.0, p.getX()), Math.max(0.0, p.getY()));
                }
                this.currentPoint.setLocation(p);
                if (this.currectPort != null) {
                    this.currectPort.fixPoint();
                    this.currectPort.setPoint(this.currentPoint);
                }
                if (this.source) {
                    this.edge.setPoint(0, p);
                    this.edge.setSource(null);
                } else if (this.target) {
                    this.edge.setPoint(this.edge.getPointCount() - 1, p);
                    this.edge.setTarget(null);
                }
                this.edge.update();
                this.overlay(this.diagram.getGraphics());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.edge.setDragging(false);
            boolean clone = e.isControlDown() && this.diagram.isCloneable();
            ConnectionSet cs = this.createConnectionSet(this.edge, this.edge.getCell(), clone);
            Map nested = DiagramConstants.createAttributes(new CellView[]{this.edge}, null);
            if (clone) {
                Map cellMap = this.diagram.cloneCells(new Object[]{this.edge.getCell()});
                nested = DiagramConstants.replaceKeys(cellMap, nested);
                cs = cs.clone(cellMap);
                this.diagram.getDiagramLayoutCache().insert(cellMap.values().toArray(), nested, cs, null, null);
            } else {
                this.diagram.getDiagramLayoutCache().edit(nested, cs, null, null);
            }
            this.edge.updatePoints();
            this.edge.refreshLabels();
            e.consume();
            if (this.relevantEdge != null) {
                this.relevantEdge.refresh(false);
            }
        }

        protected ConnectionSet createConnectionSet(EdgeView view, Object edge, boolean verbose) {
            ConnectionSet cs = new ConnectionSet();
            Object sourcePort = null;
            Object targetPort = null;
            if (view.getSource() != null) {
                sourcePort = view.getSource().getCell();
            }
            if (view.getTarget() != null) {
                targetPort = view.getTarget().getCell();
            }
            if (verbose || sourcePort != view.getDiagram().getModel().getSource(edge)) {
                cs.connect(edge, sourcePort, true);
            }
            if (verbose || targetPort != view.getDiagram().getModel().getTarget(edge)) {
                cs.connect(edge, targetPort, false);
            }
            return cs;
        }

        protected void invalidate() {
            EdgeView e = this.relevantEdge;
            int handlesize = this.diagram.getHandleSize();
            for (int i = 0; i < this.r.length; ++i) {
                Point2D p = this.diagram.toScreen(DiagramConstants.createPoint(e.getPoint(i)));
                this.r[i].setFrame(p.getX() - (double)handlesize, p.getY() - (double)handlesize, 2 * handlesize, 2 * handlesize);
            }
        }
    }
}

