/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypes;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.BasicMarqueeHandler;
import oracle.dbtools.crest.swingui.diagram.graph.ConnectionSet;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.Port;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.diagram.logical.ArcDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.diagram.relational.FKArcDiagramCell;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.swingui.process.DPVTransformation;
import oracle.dbtools.crest.swingui.relational.DPVRelational;

public class MarqueeHandler
extends BasicMarqueeHandler {
    protected AbstractDiagram diagram;

    public MarqueeHandler(AbstractDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public boolean isForceMarqueeEvent(MouseEvent e) {
        Object cell = this.diagram.getFirstCellForLocation(e.getX(), e.getY());
        Diagram d = (Diagram)this.diagram;
        if (cell != null) {
            if (d.getDrawnObjectID() == 6) {
                return true;
            }
            if (!(cell instanceof DefaultEdge || cell instanceof ArcDiagramCell || cell instanceof FKArcDiagramCell)) {
                oracle.dbtools.crest.swingui.diagram.logical.EntityView cellView;
                this.diagram.getDiagramLayoutCache().toFront(new Object[]{cell});
                if (cell instanceof EntityDiagramCell && d.getDesignPartView().isBoxInBox() && (cellView = (oracle.dbtools.crest.swingui.diagram.logical.EntityView)((EntityDiagramCell)cell).getCellView()).isParent()) {
                    cellView.toFront();
                }
            }
            if (!e.isShiftDown() && !SwingUtilities.isRightMouseButton(e) || SwingUtilities.isRightMouseButton(e) && this.diagram.getSelectionCells().length <= 1) {
                if (((DefaultDiagramCell)cell).getTopView() != null) {
                    ((DefaultDiagramCell)cell).getTopView().makeSelected();
                }
                if (e.getClickCount() == 2 && cell instanceof DefaultDiagramCell) {
                    ((DefaultDiagramCell)cell).doubleClick();
                }
            }
            d.LabelsToFront();
        } else if (d.getAppView().getCurrentDPV() != null) {
            d.getAppView().getCurrentDPV().setCurrentSelection(null);
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            return true;
        }
        return super.isForceMarqueeEvent(e);
    }

    private boolean drawLine() {
        Diagram d = (Diagram)this.diagram;
        return d.getDrawnObjectID() == 1 || d.getDrawnObjectID() == 3;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            super.mousePressed(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.start != null && !e.isConsumed()) {
            Graphics g = this.diagram.getGraphics();
            this.paintConnector(Color.black, this.diagram.getBackground(), g);
            this.paintConnector(this.diagram.getBackground(), Color.black, g);
            e.consume();
        }
        super.mouseDragged(e);
    }

    public PortView getSourcePortAt(Point2D point) {
        Point2D tmp = this.diagram.fromScreen(DiagramConstants.createPoint(point));
        return this.diagram.getPortViewAt(tmp.getX(), tmp.getY());
    }

    protected PortView getTargetPortAt(Point2D point) {
        Object cell = this.diagram.getFirstCellForLocation(point.getX(), point.getY());
        for (int i = 0; i < this.diagram.getModel().getChildCount(cell); ++i) {
            Object tmp = this.diagram.getModel().getChild(cell, i);
            tmp = this.diagram.getDiagramLayoutCache().getMapping(tmp, false);
            if (!(tmp instanceof PortView) || tmp == this.firstPort) continue;
            return (PortView)tmp;
        }
        return this.getSourcePortAt(point);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Rectangle2D bnds;
        Object cell;
        Diagram d = (Diagram)this.diagram;
        if (!SwingUtilities.isRightMouseButton(e) && d.getDrawnObjectID() == 6) {
            cell = this.diagram.getFirstCellForLocation(e.getX(), e.getY());
            if (cell instanceof DefaultDiagramCell && !ApplicationView.IS_VIEWER) {
                ((DefaultDiagramCell)cell).deleteSelected();
            }
            e.consume();
        } else if (!this.drawLine() && (bnds = this.diagram.fromScreen(DiagramConstants.createRect(this.marqueeBounds))) != null) {
            double x = bnds.getX();
            double y = bnds.getY();
            if (this.diagram != null && this.diagram.isGridVisible()) {
                double sgs = this.diagram.getGridSize();
                x = Math.round((double)Math.round(x / sgs) * sgs);
                y = Math.round((double)Math.round(y / sgs) * sgs);
            }
            this.createObject(new Rectangle((int)x, (int)y, (int)bnds.getWidth(), (int)bnds.getHeight()));
            e.consume();
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            cell = this.diagram.getFirstCellForLocation(e.getX(), e.getY());
            if (cell != null && cell instanceof DefaultDiagramCell) {
                ((DefaultDiagramCell)cell).showPopupMenu(e.getPoint());
            } else {
                ((Diagram)this.diagram).setDrawnObjectID(-1);
                ((Diagram)this.diagram).setCursor(new Cursor(0));
                ((Diagram)this.diagram).getDesignPartView().getController().select_SelectAction();
                ((Diagram)this.diagram).showPopupMenu(e.getPoint());
            }
        } else if (SwingUtilities.isMiddleMouseButton(e) && (e.getModifiers() & 2) == 2) {
            ((Diagram)this.diagram).getDesignPartView().actualSize();
            e.consume();
        }
        this.diagram.repaint();
        this.port = null;
        this.firstPort = null;
        this.current = null;
        this.start = null;
        super.mouseReleased(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Diagram d = (Diagram)this.diagram;
        double notches = e.getWheelRotation();
        if (notches < 0.0) {
            d.getDesignPartView().zoomIn();
        } else if (notches > 0.0) {
            d.getDesignPartView().zoomOut();
        }
    }

    private void createObject(Rectangle r) {
        Diagram d = (Diagram)this.diagram;
        ApplicationView view = d.getAppView();
        switch (d.getDrawnObjectID()) {
            case 0: {
                this.addEntity(d, view, r);
                break;
            }
            case 19: {
                this.addEntityView(d, view, r);
                break;
            }
            case 2: {
                this.addTable(d, view, r);
                break;
            }
            case 4: {
                this.addView(d, view, r);
                break;
            }
            case 5: {
                this.addNote(d, view, r);
                break;
            }
            case 7: {
                this.addProcess(d, view, r);
                break;
            }
            case 15: {
                this.addTransformation(d, view, r);
                break;
            }
            case 8: {
                this.addAgent(d, view, r);
                break;
            }
            case 9: {
                this.addStore(d, view, r);
                break;
            }
            case 11: {
                this.addCube(d, view, r);
                break;
            }
            case 12: {
                this.addLevel(d, view, r);
                break;
            }
            case 13: {
                this.addDimension(d, view, r);
                break;
            }
            case 17: {
                this.addStructuredType(d, view, r);
            }
        }
    }

    private void addEntity(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateEntity"));
        Entity entity = ((LogicalDesign)view.getCurrentDPV().getDesignPart()).createEntity();
        TopView topView = view.getCurrentDPV().getViewFor(entity);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 170;
            }
            if (r.height <= 1) {
                r.height = 110;
            }
            topView.getCellView().setNewBounds(r, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        entity.showPropertyDialogOnNew();
    }

    private void addEntityView(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateView"));
        EntityView entityView = ((LogicalDesign)view.getCurrentDPV().getDesignPart()).getEntityViewSet().createEntityView(null);
        TopView topView = view.getCurrentDPV().getViewFor(entityView);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 170;
            }
            if (r.height <= 1) {
                r.height = 110;
            }
            topView.getCellView().setNewBounds(r, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        entityView.showPropertyDialogOnNew();
    }

    private void addTable(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateTable"));
        RelationalDesign phdes = (RelationalDesign)view.getCurrentDPV().getDesignPart();
        Table table = phdes.createTable();
        TopView topView = view.getCurrentDPV().getViewFor(table);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 170;
            }
            if (r.height <= 1) {
                r.height = 110;
            }
            topView.getCellView().setNewBounds(r, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        if (table.getDesign().getAppView().getSettings().showPropertiesDialogOnNew()) {
            table.showPropertyDialogOnNew();
        } else if (table.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
            phdes.postTableCreateEdit(table);
        }
    }

    private void addView(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateView"));
        TableView tableView = ((RelationalDesign)view.getCurrentDPV().getDesignPart()).getTableViewSet().createTableView(null);
        TopView topView = view.getCurrentDPV().getViewFor(tableView);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 170;
            }
            if (r.height <= 1) {
                r.height = 110;
            }
            topView.getCellView().setNewBounds(r, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        tableView.showPropertyDialogOnNew();
    }

    private void addProcess(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateProcess"));
        Process process = ((DataFlowDesign)view.getCurrentDPV().getDesignPart()).getProcessSet().createProcess(null);
        TopView topView = view.getCurrentDPV().getViewFor(process);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 130;
            }
            if (r.height <= 1) {
                r.height = 90;
            }
            topView.getCellView().setNewBounds(r, false);
        }
        process.showPropertyDialogOnNew();
    }

    private void addTransformation(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateProcess"));
        Transformation process = ((TransformationTask)view.getCurrentDPV().getDesignPart()).getTransformationSet().createTransformation(null);
        TopView topView = view.getCurrentDPV().getViewFor(process);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 130;
            }
            if (r.height <= 1) {
                r.height = 90;
            }
            topView.getCellView().setNewBounds(r, false);
        }
        process.showPropertyDialogOnNew();
    }

    private void addAgent(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateExternalAgent"));
        ExternalAgent agent = ((DataFlowDesign)view.getCurrentDPV().getDesignPart()).getExternalAgentSet().createExternalAgent(null);
        TopView topView = view.getCurrentDPV().getViewFor(agent);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 80;
            }
            if (r.height <= 1) {
                r.height = 80;
            }
            topView.getCellView().setNewBounds(r, false);
        }
        agent.showPropertyDialogOnNew();
    }

    private void addStore(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateInformationStore"));
        InfoStore store = view.getCurrentDPV().getDesignPart() instanceof TransformationTask ? ((TransformationTask)view.getCurrentDPV().getDesignPart()).getInfoStoreSet().createInfoStore(null) : ((DataFlowDesign)view.getCurrentDPV().getDesignPart()).getInfoStoreSet().createInfoStore(null);
        TopView topView = view.getCurrentDPV().getViewFor(store);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 140;
            }
            if (r.height <= 1) {
                r.height = 30;
            }
            topView.getCellView().setNewBounds(r, false);
        }
        store.showPropertyDialogOnNew();
    }

    private void addCube(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateCube"));
        Cube cube = ((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getCubeSet().createCube(null);
        TopView topView = view.getCurrentDPV().getViewFor(cube);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 170;
            }
            if (r.height <= 1) {
                r.height = 110;
            }
            topView.getCellView().setNewBounds(r, false);
            if (!(view.getCurrentDPV() instanceof DPVCompactMultidimentional)) {
                AbstractMDTV tvSynonym = (AbstractMDTV)((ContainerView)topView).createViewSynonim(((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getCompactDiagram(), false);
                if (tvSynonym.getCellView() != null) {
                    int size;
                    Rectangle r2 = tvSynonym.getBounds();
                    r2.width = size = Math.min(r2.width, r2.height);
                    r2.height = size;
                    tvSynonym.getCellView().setNewBounds(r2);
                }
            } else {
                int size;
                Rectangle r2 = topView.getBounds();
                r2.width = size = Math.min(r2.width, r2.height);
                r2.height = size;
                topView.getCellView().setNewBounds(r2);
                TopView tv = cube.getFirstViewForDPV(cube.getDesign().getMultidimensionalDesign().getMainView());
                if (tv != topView && tv.getCellView() != null) {
                    Rectangle rec = tv.getBounds();
                    rec.x = r2.x;
                    rec.y = r2.y;
                    rec.height = 110;
                    rec.width = 170;
                    tv.getCellView().setNewBounds(rec);
                }
            }
        }
        cube.showPropertyDialogOnNew();
    }

    private void addLevel(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateLevel"));
        Level level = ((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getLevelSet().createLevel(null);
        TopView topView = view.getCurrentDPV().getViewFor(level);
        if (topView != null && topView.getCellView() != null) {
            if (view.getCurrentDPV() instanceof DPVCompactMultidimentional) {
                if (r.width <= 1) {
                    r.width = 80;
                }
                if (r.height <= 1) {
                    r.height = 30;
                }
            } else {
                if (r.width <= 1) {
                    r.width = 170;
                }
                if (r.height <= 1) {
                    r.height = 110;
                }
            }
            topView.getCellView().setNewBounds(r, false);
            if (!(view.getCurrentDPV() instanceof DPVCompactMultidimentional)) {
                AbstractMDTV tvSynonym = (AbstractMDTV)((ContainerView)topView).createViewSynonim(((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getCompactDiagram(), false);
                if (tvSynonym.getCellView() != null) {
                    Rectangle rec = tvSynonym.getBounds();
                    rec.height = 30;
                    rec.width = 80;
                    tvSynonym.getCellView().setNewBounds(rec);
                }
            } else {
                TopView tv = level.getFirstViewForDPV(level.getDesign().getMultidimensionalDesign().getMainView());
                if (tv != topView && tv.getCellView() != null) {
                    Rectangle rec = tv.getBounds();
                    rec.x = r.x;
                    rec.y = r.y;
                    rec.height = 110;
                    rec.width = 170;
                    tv.getCellView().setNewBounds(rec);
                }
            }
        }
        level.showPropertyDialogOnNew();
    }

    private void addDimension(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateDimension"));
        Dimension dimension = ((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getDimensionSet().createDimension(null);
        TopView topView = view.getCurrentDPV().getViewFor(dimension);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 80;
            }
            if (r.height <= 1) {
                r.height = 30;
            }
            topView.getCellView().setNewBounds(r, false);
            if (!(view.getCurrentDPV() instanceof DPVCompactMultidimentional)) {
                ((ContainerView)topView).createViewSynonim(((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getCompactDiagram(), false);
            } else {
                TopView tv = dimension.getFirstViewForDPV(dimension.getDesign().getMultidimensionalDesign().getMainView());
                if (tv != topView) {
                    tv.getCellView().setNewBounds(topView.getBounds());
                }
            }
        }
        dimension.showPropertyDialogOnNew();
    }

    private void addStructuredType(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateStructuredType"));
        StructuredType structuredType = ((DataTypesDesign)view.getCurrentDPV().getDesignPart()).createStructuredType();
        TopView topView = view.getCurrentDPV().getViewFor(structuredType);
        if (topView != null && topView.getCellView() != null) {
            if (r.width <= 1) {
                r.width = 170;
            }
            if (r.height <= 1) {
                r.height = 110;
            }
            topView.getCellView().setNewBounds(r, false);
            topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
        }
        structuredType.showPropertyDialogOnNew();
    }

    private void addNote(Diagram d, ApplicationView view, Rectangle r) {
        ApplicationView.log(Messages.getString("MarqueeHandler.CreateNote"));
        Note note = null;
        TopView topView = null;
        if (view.getCurrentDPV() instanceof DPVLogical) {
            note = ((LogicalDesign)view.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(view.getCurrentDPV());
            if (topView == null) {
                topView = ((LogicalDesign)view.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (view.getCurrentDPV() instanceof DPVRelational) {
            note = ((RelationalDesign)view.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(view.getCurrentDPV());
            if (topView == null) {
                topView = ((RelationalDesign)view.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (view.getCurrentDPV() instanceof DPVProcess) {
            note = ((DataFlowDesign)view.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(view.getCurrentDPV());
            if (topView == null) {
                topView = ((DataFlowDesign)view.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (view.getCurrentDPV() instanceof DPVTransformation) {
            note = ((TransformationTask)view.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(view.getCurrentDPV());
            if (topView == null) {
                topView = ((TransformationTask)view.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (view.getCurrentDPV() instanceof DPVMultidimensional) {
            note = ((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).createNote();
            topView = note.getFirstViewForDPV(view.getCurrentDPV());
            if (topView == null) {
                topView = ((MultidimensionalDesign)view.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
            }
        } else if (view.getCurrentDPV() instanceof DPVDataTypes && (topView = (note = ((DataTypesDesign)view.getCurrentDPV().getDesignPart()).createNote()).getFirstViewForDPV(view.getCurrentDPV())) == null) {
            topView = ((DataTypesDesign)view.getCurrentDPV().getDesignPart()).getMainView().createViewFor(note);
        }
        if (note != null) {
            if (topView != null && topView.getCellView() != null) {
                if (r.height == 0) {
                    r.height = 40;
                }
                if (r.width == 0) {
                    r.width = 95;
                }
                topView.getCellView().setNewBounds(r, false);
                topView.getDesignPartView().synchronizeSynonymWithDisplays(topView);
            }
            note.showPropertyDialogOnNew();
            if (note.getDesignObjectSet() != DesignObjectSet.NULL_SET) {
                note.getDesignPart().postNoteCreateEdit(note);
            }
        }
    }

    public void connect(Port source, Port target) {
        ConnectionSet cs = new ConnectionSet();
        DefaultEdge edge = new DefaultEdge();
        cs.connect((Object)edge, (Object)source, target);
        Map map = DiagramConstants.createMap();
        DiagramConstants.setLineEnd(map, 2);
        DiagramConstants.setEndFill(map, true);
        Hashtable<DefaultEdge, Map> attributes = new Hashtable<DefaultEdge, Map>();
        attributes.put(edge, map);
        DiagramConstants.setDisconnectable(map, false);
        Object[] egges = new Object[]{edge};
        this.diagram.getDiagramLayoutCache().insert(egges, attributes, cs, null, null);
        this.diagram.getDiagramLayoutCache().toBack(egges);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e != null && this.getSourcePortAt(e.getPoint()) != null && !e.isConsumed() && this.diagram.isPortsVisible()) {
            this.diagram.setCursor(new Cursor(12));
            e.consume();
        }
        super.mouseMoved(e);
    }

    protected void paintConnector(Color fg, Color bg, Graphics g) {
        g.setColor(fg);
        g.setXORMode(bg);
        this.paintPort(this.diagram.getGraphics());
        if (this.firstPort != null && this.start != null && this.current != null) {
            g.drawLine((int)this.start.getX(), (int)this.start.getY(), (int)this.current.getX(), (int)this.current.getY());
        }
    }

    protected void paintPort(Graphics g) {
        if (this.port != null) {
            boolean o = DiagramConstants.getOffset(this.port.getAttributes()) != null;
            Rectangle2D r = o ? this.port.getBounds() : this.port.getParentView().getBounds();
            r = this.diagram.toScreen(DiagramConstants.createRect(r));
            r.setFrame(r.getX() - 3.0, r.getY() - 3.0, r.getWidth() + 6.0, r.getHeight() + 6.0);
            this.diagram.getUI().paintCell(g, this.port, r, true);
        }
    }
}

