/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.logical.TVEntity;

public class EntityDiagramCell
extends ContainerDiagramCell {
    private JMenuItem miPaste;
    private JMenuItem miSelectNeighbors;
    private JMenuItem miDeleteView;
    private JMenuItem miDeleteObject;
    private JMenuItem miSortAscending;
    private JMenuItem miSortDescending;

    public EntityDiagramCell(ContainerObject container) {
        super(container);
    }

    public EntityDiagramCell(ContainerObject container, Map attributeMap) {
        super(container, attributeMap);
    }

    private void showProperty() {
        this.getContainer().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        if (this.isEditable() && this.selectedObjects.length == 1) {
            if (this.getTopView().canRemove()) {
                this.miDeleteView.setEnabled(true);
            } else {
                this.miDeleteView.setEnabled(false);
            }
        }
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            AbstractAction cr_syn = new AbstractAction(CREATE_SYNONYM){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.getTopView().createViewSynonim(EntityDiagramCell.this.getDiagram().getAppView().getCurrentDPV());
                }
            };
            Entity ent = (Entity)this.getTopView().getModel();
            if (ent.isHierarchicalEntityType()) {
                cr_syn.setEnabled(false);
            }
            this.menu.add(cr_syn);
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(CREATE_SUBVIEW_FROM_SELECTED){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.getTopView().getDesignPartView().createSubViewFromSelected();
                }
            });
            this.menu.addSeparator();
            this.miSelectNeighbors = this.menu.add(new AbstractAction(SELECT_NEIGHBORS){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.getTopView().getDesignPartView().selectNeighbors(EntityDiagramCell.this.getContainer());
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.getContainer().getAppView().clearCopiedObjects();
                    EntityDiagramCell.access$002(EntityDiagramCell.this, EntityDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < EntityDiagramCell.this.selectedObjects.length; ++i) {
                        if (!(EntityDiagramCell.this.selectedObjects[i] instanceof DesignObject)) continue;
                        EntityDiagramCell.this.getContainer().getAppView().addCopiedObject((DesignObject)EntityDiagramCell.this.selectedObjects[i]);
                    }
                }
            });
            this.miPaste = this.menu.add(new AbstractAction(PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.access$402(EntityDiagramCell.this, EntityDiagramCell.this.getTopView().getDesignPartView().getSelectedObjects());
                    for (int i = 0; i < EntityDiagramCell.this.selectedObjects.length; ++i) {
                        ((ContainerObject)EntityDiagramCell.this.selectedObjects[i]).paste();
                    }
                }
            });
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(EntityDiagramCell.this.selectedObjects, EntityDiagramCell.this.getDiagram().getAppView());
                    }
                });
                if (!this.getDiagram().getDesignPartView().isMainDiagram()) {
                    this.menu.add(new AbstractAction(DELETE_VIEWS){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EntityDiagramCell.this.getDiagram().getDesignPartView().removeTopViewsWithUndo(EntityDiagramCell.this.getDiagram().getSelectionCells());
                        }
                    });
                }
            } else {
                this.miDeleteObject = this.menu.add(new AbstractAction(DELETE_OBJECT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EntityDiagramCell.this.deleteEntity();
                    }
                });
                this.miDeleteView = this.menu.add(new AbstractAction(DELETE_VIEW){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EntityDiagramCell.this.getTopView().getDesignPartView().postTopViewRemove(EntityDiagramCell.this.getTopView());
                        EntityDiagramCell.this.getTopView().getDesignPartView().unregisterFromTreemodel(EntityDiagramCell.this.getTopView());
                        ((ContainerView)EntityDiagramCell.this.getTopView()).remove(false);
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.format();
                }
            });
            this.menu.add(new AbstractAction(SHOW_HIDE_ELEMENTS){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.showHideElements();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.getTopView().sendToBack();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESIZE_TO_VISIBLE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EntityDiagramCell.this.getTopView().getDesignPartView().resizeSelectedObjects();
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(this.getSortMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDiagramCell.this.showProperty();
            }
        });
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.getContainer().canPaste());
            this.miSelectNeighbors.setEnabled(this.enableSelectNeighbors());
            this.setEnabled(this.miDeleteObject, this.canDeleteModelObject());
        } else {
            this.setEnabled(this.miPaste, false);
            this.setEnabled(this.miDeleteObject, false);
        }
        return this.menu;
    }

    private boolean enableSelectNeighbors() {
        Entity entity = (Entity)this.getContainer();
        List relations = entity.getRelations();
        for (Relation rel : relations) {
            if (rel instanceof InheritanceRelation || rel.getSourceEntity() == rel.getTargetEntity()) continue;
            return true;
        }
        return false;
    }

    public void deleteEntity() {
        this.deleteSelected();
    }

    @Override
    public void deleteSelected() {
        ((TVEntity)this.getTopView()).remove(MessageFormat.format(Messages.getString("EntityDiagramCell.DeleteEntity"), this.getContainer().getName()));
    }

    public JMenu getSortMenu() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JMenu sortMenu = new JMenu(MenuUtils.getMnemonicStr(SORT_ATTRIBUTES_FOR_SELECTED_ENTITIES));
        this.miSortAscending = new JMenuItem(SORT_ATTRIBUTES_FOR_SELECTED_ENTITIES_ASC, configuration.getIcon("SORT_ASC_ICON", 16));
        this.miSortAscending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDiagramCell.this.getTopView().getDesignPartView().sortEntitiesAttributes(false, true);
            }
        });
        this.miSortDescending = new JMenuItem(SORT_ATTRIBUTES_FOR_SELECTED_ENTITIES_DESC, configuration.getIcon("SORT_DESC_ICON", 16));
        this.miSortDescending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityDiagramCell.this.getTopView().getDesignPartView().sortEntitiesAttributes(false, false);
            }
        });
        sortMenu.add(this.miSortAscending);
        sortMenu.add(this.miSortDescending);
        return sortMenu;
    }

    static /* synthetic */ Object[] access$002(EntityDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$402(EntityDiagramCell x0, Object[] x1) {
        x0.selectedObjects = x1;
        return x1;
    }
}

