/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.logical;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class RelationEdge
extends DefaultEdge {
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        this.point.setLocation(pt);
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.isEditable()) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            if (this.selectedObjects.length > 1) {
                DesignPartView dpv;
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(RelationEdge.this.selectedObjects, RelationEdge.this.getDiagram().getAppView());
                    }
                });
                final List list = this.getConnectors(this.selectedObjects);
                if (list.size() > 0 && this.getTopView() != null && !(dpv = this.getTopView().getDesignPartView()).isMainDiagram() && dpv.isSupportLineHiding()) {
                    this.menu.addSeparator();
                    this.menu.add(new AbstractAction(HIDE_LINES){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RelationEdge.this.hideRelations(list);
                        }
                    });
                }
            } else {
                DesignPartView dpv;
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RelationEdge.this.deleteRelation();
                    }
                });
                if (this.getTopView() != null && !(dpv = this.getTopView().getDesignPartView()).isMainDiagram() && dpv.isSupportLineHiding()) {
                    this.menu.addSeparator();
                    this.menu.add(new AbstractAction(HIDE){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RelationEdge.this.hideRelation();
                        }
                    });
                }
            }
            this.menu.addSeparator();
            this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.straightenLine();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.format();
                }
            });
            this.menu.addSeparator();
            this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.addBreakpoint(RelationEdge.this.point);
                }
            });
            this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationEdge.this.removeBreakpoint(RelationEdge.this.point);
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelationEdge.this.showProperty();
            }
        });
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute() && this.onlyEdgesAreSelected());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean b = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!b);
                this.miRemoveBP.setEnabled(b && this.canDeleteBreakpoint());
            }
        }
        return this.menu;
    }

    public Relation getRelation() {
        return (Relation)this.getTopView().getModel();
    }

    @Override
    public String getName() {
        if (this.getTopView() != null) {
            return this.getRelation().getName();
        }
        return "";
    }

    public void deleteRelation() {
        Relation relation = this.getRelation();
        TVConnector connector = (TVConnector)this.getTopView();
        if (connector.remove(relation)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("RelationEdge.RemoveRelation"), relation.getName()));
        }
    }

    public String getSourceCardinality() {
        return this.getRelation().getSourceCardinality().toString();
    }

    public String getSourceName() {
        return this.getRelation().getNameOnSource();
    }

    public String getTargetCardinality() {
        return this.getRelation().getTargetCardinality().toString();
    }

    public String getTargetName() {
        return this.getRelation().getNameOnTarget();
    }

    public String getSourceLabel() {
        return this.getSourceName() != null ? this.getSourceName() : "";
    }

    public String getTargetLabel() {
        return this.getTargetName() != null ? this.getTargetName() : "";
    }

    public String getAttributesAsString() {
        Collection collection = this.getRelation().getAttributesCollection();
        if (collection.size() > 0) {
            String result = "";
            int p = 0;
            for (ContainedObjectWithDomain next : collection) {
                if (p > 0) {
                    result = result + "\n";
                }
                ++p;
                String rowText = !next.getNullsAllowed() ? "*" : "o";
                rowText = rowText + " " + next.getName();
                int notation = this.getDiagram().getDesignPartView().getNotation();
                if (notation != 1) {
                    rowText = rowText + "    " + ((Attribute)next).getLogicalRepresentationName();
                }
                result = result + rowText;
            }
            return result;
        }
        return null;
    }

    @Override
    public void deleteSelected() {
        this.deleteRelation();
    }
}

