/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class LinkEdge
extends DefaultEdge {
    private JPopupMenu menu;
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        this.point.setLocation(pt);
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.menu.add(new AbstractAction(DELETE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEdge.this.deleteLink();
                }
            });
            this.menu.addSeparator();
            this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEdge.this.straightenLine();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEdge.this.format();
                }
            });
            this.menu.addSeparator();
            this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEdge.this.addBreakpoint(LinkEdge.this.point);
                }
            });
            this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEdge.this.removeBreakpoint(LinkEdge.this.point);
                }
            });
        }
        if (this.getLink().getRollupLink() != null && !(this.getLink().getSourceMDObject() instanceof Dimension)) {
            if (this.isEditable()) {
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LinkEdge.this.showProperty();
                }
            });
        }
        if (this.getLink().getSourceMDObject() instanceof Dimension) {
            Dimension dim = (Dimension)this.getLink().getSourceMDObject();
            Iterator it = dim.getHierarchies().iterator();
            while (it.hasNext()) {
                Hierarchy hier = (Hierarchy)it.next();
                if (this.isEditable()) {
                    this.menu.addSeparator();
                }
                this.menu.add(new HierarchyAction(MessageFormat.format(Messages.getString("LinkEdge.PropertiesOf"), hier.getName()), hier));
            }
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute() && this.onlyEdgesAreSelected());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean b = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!b);
                this.miRemoveBP.setEnabled(b && this.canDeleteBreakpoint());
            }
        }
        return this.menu;
    }

    public Link getLink() {
        return (Link)this.getTopView().getModel();
    }

    @Override
    public String getName() {
        if (this.getLink().getRollupLink() != null) {
            return this.getLink().getRollupLink().getName();
        }
        return "";
    }

    @Override
    public Object getUserObject() {
        if (this.getTopView() != null && this.getLink() != null) {
            return this.getName();
        }
        return null;
    }

    public boolean showName() {
        return this.getLink().getRollupLink() != null && this.getLink().getRollupLink().isRolePlaying();
    }

    public void deleteLink() {
        Link link = this.getLink();
        TVConnector connector = (TVConnector)this.getTopView();
        if (connector.remove(link)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("LinkEdge.RemoveLink"), link.getName()));
        }
    }

    public String getSourceName() {
        return this.getLink().getSource().getName();
    }

    public String getTargetName() {
        return this.getLink().getDestination().getName();
    }

    @Override
    public void deleteSelected() {
        this.deleteLink();
    }

    class HierarchyAction
    extends AbstractAction {
        private Hierarchy hierarchy;

        HierarchyAction(String title, Hierarchy hier) {
            super(title);
            this.hierarchy = hier;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.hierarchy.showPropertyDialog();
        }
    }
}

