/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TableViewRenderer
extends ContainerRenderer {
    public static final int COLUMN_LEFT = 10;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(150, 255, 150);
    public static final Color DEFAULT_DATATYPE_COLOR = Color.BLUE;
    protected static final Icon ERROR_ICON = GUIConfiguration.getInstance().getIcon("ERROR_ICON");
    protected static final Icon WARNING_RED_ICON = GUIConfiguration.getInstance().getIcon("WARNING_RED_ICON");
    protected static final Icon WARNING_YELLOW_ICON = GUIConfiguration.getInstance().getIcon("WARNING_YELLOW_ICON");

    public TableViewRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Relational View");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackgroundColor();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Relational View");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        return this.getTopView().getFontObject(EditableFonts.FO_COLUMN).getColor();
    }

    @Override
    protected Font getElementsFont() {
        return this.getTopView().getFontObject(EditableFonts.FO_COLUMN).getFont();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        TopView efo = this.getTopView();
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 40, 40);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 40, 40);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.longName)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        boolean isValidSQL = ((AbstractView)this.container).isValidSQL();
        boolean isParsed = ((AbstractView)this.container).isParsed();
        boolean isIncorrectSQL = ((AbstractView)this.container).isIncorrectSQL();
        Icon icon = null;
        if (isIncorrectSQL) {
            icon = WARNING_RED_ICON;
        } else if (!isValidSQL) {
            icon = WARNING_RED_ICON;
        } else if (!isParsed) {
            icon = WARNING_YELLOW_ICON;
        }
        if (icon != null) {
            icon.paintIcon(this, g, 10, yCursor - 8);
            if (this.container.isRemoteObject()) {
                REMOTE_TABLE_ICON.paintIcon(this, g2, 26, 2);
            }
        } else if (this.container.isRemoteObject()) {
            REMOTE_TABLE_ICON.paintIcon(this, g2, 10, 2);
        }
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g.setFont(efo.getFontObject(EditableFonts.FO_TITLE).getFont());
        String[] wrappedTitle = TableViewRenderer.wrapText(this.longName, TableViewRenderer.getMaxChars(this.longName, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            if (this.container.isDeprecated()) {
                this.strikeThrough(g2, text, xCursor, yCursor);
            }
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null && !dpv.clearDetails()) {
            boolean drawLine = true;
            if (!dpv.isShowNamesOnly() && (dpv.showAllDetails() || dpv.showElements())) {
                String longestName;
                DesignObject[] elements;
                g2.setStroke(lineStroke);
                g.setColor(this.getBorderColor());
                g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                if (this.container.isBST()) {
                    StructuredType st = this.container.getBasedOnStructuredType();
                    if (st != null) {
                        elements = this.container.getTypeSubstitution() == null ? st.toElementObjectArray(st.getAllElements()) : st.getElements();
                        longestName = this.getLongestTypeName((TypeElement[])elements);
                        g.setFont(this.getElementsFont());
                        fm = g.getFontMetrics();
                        colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                        for (int i = 0; i < elements.length; ++i) {
                            DesignObject elm = elements[i];
                            g.setColor(this.getElementsColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(elm.getName(), 10, yCursor += 3 + fm.getMaxAscent());
                            fm = g.getFontMetrics();
                            int anLeft = fm.stringWidth(longestName) + 20;
                            g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            g.drawString(((TypeElement)elm).getDataType(), anLeft, yCursor);
                            g.setColor(this.getForeground());
                        }
                    }
                } else {
                    g2.setStroke(textStroke);
                    boolean hasHeader = ((TableView)this.container).hasValidHeader();
                    elements = ((TableView)this.container).getColumns();
                    longestName = this.getLongestName((ContainedObject[])elements, hasHeader);
                    String longestDTName = this.getLongestVDTName((ContainedObject[])elements);
                    g.setFont(this.getElementsFont());
                    fm = g.getFontMetrics();
                    int dtLeft = fm.stringWidth(longestName) + 20;
                    int cLeft = fm.stringWidth(longestDTName) + 10;
                    if (dpv.showAllDetails() || dpv.showDatatype()) {
                        cLeft += dtLeft;
                    }
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < elements.length; ++i) {
                        ColumnView element = (ColumnView)elements[i];
                        yCursor += 3 + fm.getMaxAscent();
                        String name = element.getPresentationName(hasHeader);
                        g.setFont(this.getElementsFont());
                        g.setColor(this.getElementsColor());
                        if (element.isDeprecated()) {
                            this.strikeThrough(g2, name, 10, yCursor);
                        }
                        g.drawString(name, 10, yCursor);
                        fm = g.getFontMetrics();
                        if (dpv.showAllDetails() || dpv.showDatatype()) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            String dt = this.getDataType(element);
                            if ((dt == null || "".equals(dt)) && (dt = element.getExpression()) == null) {
                                dt = "";
                            }
                            g.drawString(dt, dtLeft, yCursor);
                        }
                        if (dpv.showComments()) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(element.getCommentInRDBMS(), cLeft, yCursor);
                        }
                        g.setColor(this.getForegroundColor());
                        if (yCursor <= height) continue;
                        g.setColor(this.getBorderColor());
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        int[] xPts = new int[]{center, left, right};
                        int[] yPts = new int[]{bottom, top, top};
                        g.fillPolygon(xPts, yPts, 3);
                        break;
                    }
                }
                if (dpv.showAllDetails()) {
                    List usedContainers;
                    if (!((TableView)this.container).isIncorrectSQL() && !((TableView)this.container).getUsedTablesAndViews().isEmpty()) {
                        usedContainers = ((TableView)this.container).getUsedTablesAndViews();
                        if (usedContainers.size() > 0) {
                            g2.setStroke(lineStroke);
                            int p = colTextHeight / 5;
                            g.setColor(this.getBorderColor());
                            g.drawLine(0, yCursor += 3 + this.borderWidth + p, width - 2, yCursor);
                            g.setFont(this.getElementsFont());
                            g.setColor(this.getElementsColor());
                            for (SQLNameHelper helper : usedContainers) {
                                yCursor += 3 + fm.getMaxAscent();
                                String name = helper.getTableName();
                                g.setFont(this.getElementsFont());
                                if (helper.isDeprecated()) {
                                    this.strikeThrough(g2, name, 10, yCursor);
                                }
                                g.drawString(name, 10, yCursor);
                            }
                        }
                    } else {
                        usedContainers = ((TableView)this.container).getUsedContainers();
                        if (usedContainers.size() > 0) {
                            g2.setStroke(lineStroke);
                            int p = colTextHeight / 5;
                            g.setColor(this.getBorderColor());
                            g.drawLine(0, yCursor += 3 + this.borderWidth + p, width - 2, yCursor);
                            g.setFont(this.getElementsFont());
                            g.setColor(this.getElementsColor());
                            for (AbstractView.ContainerHolder holder : usedContainers) {
                                yCursor += 3 + fm.getMaxAscent();
                                String name = holder.getContainer().getName();
                                g.setFont(this.getElementsFont());
                                if (holder.getContainer().isDeprecated()) {
                                    this.strikeThrough(g2, name, 10, yCursor);
                                }
                                g.drawString(name, 10, yCursor);
                            }
                        }
                    }
                }
            }
            String comments = this.container.getCommentInRDBMS().trim();
            if (dpv.showComments() && !"".equalsIgnoreCase(comments)) {
                if (drawLine) {
                    g.setColor(this.getBorderColor());
                    g2.setStroke(lineStroke);
                    g.drawLine(0, yCursor += 6, width - 2, yCursor);
                }
                g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                g.setFont(titleFont);
                fm = g.getFontMetrics();
                yCursor += fm.getHeight();
                String[] wrappedComments = TableViewRenderer.wrapText(comments, TableViewRenderer.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    String text = wrappedComments[t];
                    g.drawString(text, 10, yCursor);
                    yCursor += fm.getHeight();
                }
            }
        }
    }

    @Override
    protected String getLongestTypeName(TypeElement[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    private String getDataType(ColumnView column) {
        if (column.getReferencedColumn() != null && ("Aggregate".equalsIgnoreCase(column.getReferencedColumn().getSourceType()) || "Derived".equalsIgnoreCase(column.getReferencedColumn().getSourceType()) && column.getReferencedColumn().getFormulaDesc() != null && column.getReferencedColumn().getFormulaDesc().length() > 0)) {
            return column.getReferencedColumn().getFormulaDesc();
        }
        return column.getDataType();
    }

    @Override
    protected String getLongestName(ContainedObject[] elements) {
        return this.getLongestName(elements, false);
    }

    protected String getLongestName(ContainedObject[] elements, boolean hasHeader) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = null;
            if (hasHeader) {
                n = ((ColumnView)elements[i]).getHeaderAlias();
            }
            if ((n == null || "".equalsIgnoreCase(n)) && ((n = ((ColumnView)elements[i]).getAlias()) == null || "".equalsIgnoreCase(n))) {
                n = ((ColumnView)elements[i]).getReferencedName();
            }
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected String getLongestVDTName(ContainedObject[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            ColumnView element = (ColumnView)elements[i];
            String dt = this.getDataType(element);
            if ((dt == null || "".equals(dt)) && (dt = element.getExpression()) == null) {
                dt = "";
            }
            if (dt.length() <= name.length()) continue;
            name = dt;
        }
        return name;
    }
}

