/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.domains;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.imports.domains.DomainImportSelection;
import oracle.dbtools.crest.imports.domains.DomainsImporter;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.domains.Messages;
import oracle.dbtools.crest.swingui.editor.TextCompareDialog;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareCheckEditor;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class ImportDomainsDialog
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JScrollPane detailsSP;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private JTable compareTable = new JTable();
    private SelectedCellRenderer selRenderer = new SelectedCellRenderer();
    private ModifiableCellRenderer propertyNamerenderer = new ModifiableCellRenderer();
    private JDialog dialog;
    private JPanel buttonPanel;
    private LogicalDesign ldes;
    private static String STATE_ALL = Messages.getString("ImportDomainsDialog.ShowAllObjects");
    private static String STATE_NEW = Messages.getString("ImportDomainsDialog.ShowNewObjects");
    private static String STATE_MODIFIED = Messages.getString("ImportDomainsDialog.ShowModifiedObjects");
    JCheckBoxMenuItem item = new JCheckBoxMenuItem(STATE_ALL);
    JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(STATE_NEW);
    JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(STATE_MODIFIED);
    private JPopupMenu menu;
    private String fileNameNoExt = "";
    private DomainImportSelection leftEngineer = null;
    private static File lastFolder = null;
    private static final Logger LOGGER = new Logger(ImportDomainsDialog.class);
    JScrollBar leftSB;
    JScrollBar rightSB;
    private JButton button;
    JButton bnOpenFile;
    JCheckBox chbSaveInDefDomains;
    MyJTree startTree = null;
    boolean started = false;
    boolean sb_started = false;
    boolean sel_started = false;

    public ImportDomainsDialog(ApplicationView view, LogicalDesign design) {
        super(view);
        this.ldes = design;
        this.leftEngineer = new DomainImportSelection(this.ldes, new File(""));
        this.initRightTreePanel(this.leftEngineer.getRightRoot());
        this.initLeftTreePanel(this.leftEngineer.getLeftRoot());
        this.resetRightTree(this.leftEngineer.getRightRoot());
        this.resetLeftTree(this.leftEngineer.getLeftRoot());
        this.leftTreePanel.setPreferredSize(new Dimension(450, 400));
        this.rightTreePanel.setPreferredSize(new Dimension(450, 400));
        this.leftTreePanel.setMinimumSize(new Dimension(450, 200));
        this.rightTreePanel.setMinimumSize(new Dimension(450, 200));
        this.tabbedPane.setPreferredSize(new Dimension(900, 200));
        this.detailsSP = new JScrollPane(this.compareTable);
        this.compareTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int col;
                if (e.getClickCount() == 2 && ((col = ImportDomainsDialog.this.compareTable.getSelectedColumn()) == 2 || col == 3)) {
                    int row = ImportDomainsDialog.this.compareTable.getSelectedRow();
                    String name = (String)ImportDomainsDialog.this.compareTable.getModel().getValueAt(row, 0);
                    Object leftValue = ImportDomainsDialog.this.compareTable.getModel().getValueAt(row, 2);
                    Object rightValue = ImportDomainsDialog.this.compareTable.getModel().getValueAt(row, 3);
                    if (leftValue instanceof String && rightValue instanceof String && (!"".equalsIgnoreCase((String)leftValue) || !"".equalsIgnoreCase((String)rightValue))) {
                        TextCompareDialog dialog = new TextCompareDialog(ImportDomainsDialog.this.getApplicationView(), (String)leftValue, (String)rightValue);
                        dialog.setTitle(name);
                        dialog.showDialog();
                    }
                }
            }
        });
        this.detailsSP.setPreferredSize(new Dimension(900, 200));
        JSplitPane sp1 = new JSplitPane(1);
        sp1.setLeftComponent(this.leftTreePanel);
        sp1.setRightComponent(this.rightTreePanel);
        sp1.setDividerLocation(-1);
        sp1.setResizeWeight(0.5);
        JSplitPane splitPane = new JSplitPane(0, sp1, this.tabbedPane);
        this.add((Component)splitPane, "Center");
        this.tabbedPane.add(Messages.getString("ImportDomainsDialog.Details"), this.detailsSP);
        this.initToolbar();
        this.add((Component)this.getButtonPanel(), "South");
        this.updateCompareTable(null);
    }

    private void openFile() {
        try {
            File selected;
            URLFilter filter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith("defaultdomains".concat(".xml")) || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("ImportDomainsDialog.OracleSQLDeveloperModelingDomainsFiles");
                }
            };
            URLChooser fileChooser = DialogUtil.newURLChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(filter);
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultDesignsPath();
                if ("".equals(lastDir)) {
                    lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                }
                if ("".equals(lastDir)) {
                    lastDir = this.getApplicationView().getSettings().getDefaultSystemTypesPath();
                }
                if ("".equals(lastDir)) {
                    lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
                }
                if ("".equals(lastDir)) {
                    lastDir = this.getApplicationView().getCurrentDesign().getDesignPath();
                }
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("ImportDomainsDialog.SelectFileModelingDomains"));
            if (status == 0 && (selected = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = selected.getParentFile();
                FileOpenHistory.getInstance().updateFileHistory(lastFolder.toURI().toURL());
                this.fileNameNoExt = FileUtils.removeExt(selected.getName());
                this.resetDomainsFile(selected);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error import domain file ", e);
        }
    }

    private void resetDomainsFile(File file) {
        DomainImportSelection engineer;
        this.unregisterListeners();
        this.leftEngineer = engineer = new DomainImportSelection(this.ldes, file);
        this.resetRightTree(engineer.getRightRoot());
        this.resetLeftTree(engineer.getLeftRoot());
    }

    public String getCaption() {
        return Messages.getString("ImportDomainsDialog.ImportModelingDomains");
    }

    private void initLeftTreePanel(ModelIdObjectSelection root) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        CompareTreeRenderer renderer = new CompareTreeRenderer(true);
        this.leftTree.setCellRenderer(renderer);
        CompareCheckEditor editor = new CompareCheckEditor(true);
        this.leftTree.setCellEditor(editor);
        JScrollPane jsp = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jsp, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jsp.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
    }

    private void resetLeftTree(EngineeringObjectSelection root) {
        root.resetModifiedStatus();
        this.leftNavDesign = new CompareTreeNavigationDesign(root);
        this.leftTree.setModel(this.leftNavDesign);
    }

    private void initRightTreePanel(ModelIdObjectSelection root) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        CompareTreeRenderer renderer = new CompareTreeRenderer(false);
        renderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(renderer);
        JScrollPane jsp = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jsp, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jsp.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
    }

    private void resetRightTree(EngineeringObjectSelection root) {
        root.resetModifiedStatus();
        this.rightNavDesign = new CompareTreeNavigationDesign(root);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void unregisterListeners() {
        this.leftNavDesign.unregisterAsListener();
        this.rightNavDesign.unregisterAsListener();
    }

    private void initToolbar() {
        Dimension dim = new Dimension(190, 23);
        JPanel jpanel1 = new JPanel(new FlowLayout(0));
        this.bnOpenFile = new JButton(Messages.getString("ImportDomainsDialog.OpenDomainFile"));
        this.bnOpenFile.setMnemonic(79);
        this.bnOpenFile.setPreferredSize(dim);
        this.bnOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImportDomainsDialog.this.openFile();
                ImportDomainsDialog.this.updateCompareTable(null);
            }
        });
        jpanel1.add(this.bnOpenFile);
        this.chbSaveInDefDomains = new JCheckBox(Messages.getString("ImportDomainsDialog.ImportDefaultDomains"));
        this.chbSaveInDefDomains.setToolTipText(Messages.getString("ImportDomainsDialog.DomainsSavedInFile"));
        jpanel1.add(this.chbSaveInDefDomains);
        this.button = new JButton(Messages.getString("ImportDomainsDialog.Filter"));
        this.button.setMnemonic(70);
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JPopupMenu menu = ImportDomainsDialog.this.getFilterPopupMenu();
                menu.show(ImportDomainsDialog.this.button, e.getPoint().x, e.getPoint().y);
            }
        });
        this.leftTreePanel.add((Component)jpanel1, "North");
        JPanel jpanel2 = new JPanel(new FlowLayout(0));
        this.rightTreePanel.add((Component)jpanel2, "North");
        jpanel2.setPreferredSize(jpanel1.getPreferredSize());
        jpanel2.add(this.button);
    }

    private void engineer() {
        DomainsImporter imp = new DomainsImporter(this.getDesign());
        if (this.chbSaveInDefDomains.isSelected()) {
            this.getDesign().setSaveDefaultDomains(true);
            imp.importDomains(this.leftEngineer.getLeftRoot().getChilds(), "defaultdomains");
        } else {
            imp.importDomains(this.leftEngineer.getLeftRoot().getChilds(), this.fileNameNoExt);
        }
        ApplicationView.getInstance().getXMLTransformationManager().saveDomains(this.getDesign());
        if (((JDialog)this.getDialog()).isModal()) {
            this.unregisterListeners();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.synchroizeSelection(e);
        TreePath path = e.getPath();
        Object object = path.getLastPathComponent();
        this.updateCompareTable(object);
    }

    private void updateCompareTable(Object object) {
        if (object instanceof EngineeringObjectSelection || object == null) {
            int[] wide = new int[]{0, 0, 0, 0};
            boolean exists = this.compareTable.getColumnModel() != null;
            int count = 4;
            if (exists) {
                count = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < count; ++i) {
                    wide[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            GeneralPropertiesComparator pc = object == null ? new EngEmptyPropertiesComparator(null, null) : ((EngineeringObjectSelection)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(pc));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn column = this.compareTable.getColumnModel().getColumn(1);
            column.setPreferredWidth(60);
            column.setWidth(60);
            column.setMaxWidth(70);
            column.setCellRenderer(this.selRenderer);
            column = this.compareTable.getColumnModel().getColumn(0);
            column.setCellRenderer(this.propertyNamerenderer);
            if (exists) {
                for (int i = 0; i < count; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(wide[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(wide[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.processExpEvent(event, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.processExpEvent(event, true);
    }

    void processExpEvent(TreeExpansionEvent event, boolean state) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.started) {
            this.startTree = (MyJTree)source;
            this.started = true;
            TreePath tp = event.getPath();
            EngineeringObjectSelection os = (EngineeringObjectSelection)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setExpandedState(new TreePath(os.getCorrespondentNode().getPath()), state);
            this.started = false;
        }
    }

    MyJTree getOtherTree(JTree tree) {
        if (tree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source instanceof JScrollBar && !this.sb_started) {
            JScrollBar jsb = (JScrollBar)source;
            if (jsb == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jsb == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    private void synchroizeSelection(TreeSelectionEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)source;
            this.sel_started = true;
            TreePath tp = event.getPath();
            EngineeringObjectSelection os = (EngineeringObjectSelection)tp.getLastPathComponent();
            MyJTree other = this.getOtherTree(this.startTree);
            other.setSelectionPath(new TreePath(os.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = ImportDomainsDialog.this.dialog.getWidth();
                    int h = ImportDomainsDialog.this.dialog.getHeight();
                    w = Math.max(800, w);
                    h = Math.max(650, h);
                    ImportDomainsDialog.this.dialog.setSize(w, h);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_DOMAINS_DIALOG";
    }

    public void setModal(boolean modal) {
        ((JDialog)this.getDialog()).setModal(modal);
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton bnEngineer = new JButton(Messages.getString("ImportDomainsDialog.Import"));
            bnEngineer.setMnemonic(73);
            bnEngineer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDomainsDialog.this.engineer();
                    ImportDomainsDialog.this.close();
                }
            });
            JButton bnCancel = new JButton(Messages.getString("ImportDomainsDialog.Cancel"));
            bnCancel.setMnemonic(67);
            bnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportDomainsDialog.this.close();
                }
            });
            JButton bnHelp = new JButton(this.getHelpAction());
            bnHelp.setMnemonic(72);
            bnEngineer.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(bnEngineer);
            this.buttonPanel.add(bnCancel);
            this.buttonPanel.add(bnHelp);
        }
        return this.buttonPanel;
    }

    private void setFilter(JTree tree, EngFilter filter) {
        EngineeringObjectSelection rightRoot = (EngineeringObjectSelection)tree.getModel().getRoot();
        ((EngFilteredSelection)rightRoot).setFilter(filter);
    }

    private JPopupMenu getFilterPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            this.item1.addActionListener(new PopupMenuListener());
            this.item3.addActionListener(new PopupMenuListener());
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    class ShowAllListener
    implements ActionListener {
        EngFilter filter = new EngFilter();

        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImportDomainsDialog.this.item.isSelected()) {
                this.filter.clearFilters();
                ImportDomainsDialog.this.item.setEnabled(false);
                ImportDomainsDialog.this.item1.setSelected(false);
                ImportDomainsDialog.this.item3.setSelected(false);
                this.filter.addFilter(EngFilter.NO_FILTER);
                ImportDomainsDialog.this.setFilter(ImportDomainsDialog.this.leftTree, this.filter);
                ImportDomainsDialog.this.setFilter(ImportDomainsDialog.this.rightTree, this.filter);
                ImportDomainsDialog.this.leftTree.updateUI();
                ImportDomainsDialog.this.rightTree.updateUI();
            } else {
                ImportDomainsDialog.this.item.setEnabled(true);
            }
            ImportDomainsDialog.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        EngFilter filter = new EngFilter();

        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filter.clearFilters();
            if (ImportDomainsDialog.this.item1.isSelected() || ImportDomainsDialog.this.item3.isSelected()) {
                ImportDomainsDialog.this.item.setSelected(false);
            }
            if (ImportDomainsDialog.this.item1.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (ImportDomainsDialog.this.item3.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            ImportDomainsDialog.this.item.setEnabled(true);
            if (!ImportDomainsDialog.this.item1.isSelected() && !ImportDomainsDialog.this.item3.isSelected()) {
                this.filter.addFilter(EngFilter.NO_FILTER);
                ImportDomainsDialog.this.item.setSelected(true);
                ImportDomainsDialog.this.item.setEnabled(false);
            }
            ImportDomainsDialog.this.setFilter(ImportDomainsDialog.this.leftTree, this.filter);
            ImportDomainsDialog.this.setFilter(ImportDomainsDialog.this.rightTree, this.filter);
            ImportDomainsDialog.this.leftTree.updateUI();
            ImportDomainsDialog.this.rightTree.updateUI();
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setText(ph.getName());
                if (ph.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                    if (!ph.isModified()) {
                        this.setForeground(table.getSelectionForeground());
                    }
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            if (table.getModel() instanceof CompareModel) {
                CompareModel cm = (CompareModel)table.getModel();
                EngPropertyHolder ph = (EngPropertyHolder)cm.getPropertiesList().get(row);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(val);
                if (ph.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            return this;
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private GeneralPropertiesComparator comp;

        CompareModel(GeneralPropertiesComparator comparator) {
            this.comp = comparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ImportDomainsDialog.Property");
            }
            if (column == 1) {
                return Messages.getString("ImportDomainsDialog.Selected");
            }
            if (column == 2) {
                return this.comp.getLeftName();
            }
            if (column == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(rowIndex);
                return ph.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(row);
            if (col == 0) {
                return ph.getName();
            }
            if (col == 1) {
                return new Boolean(ph.isSelected());
            }
            if (col == 2) {
                return ph.getLeftValue();
            }
            if (col == 3) {
                return ph.getRightValue();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (col == 1) {
                EngPropertyHolder ph = (EngPropertyHolder)this.comp.getPropertiesList().get(row);
                ph.setSelected((Boolean)aValue);
            }
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel model) {
            super(model);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath path, boolean state) {
            super.setExpandedState(path, state);
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ImportDomainsDialog.this.unregisterListeners();
        }
    }
}

