/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;

public abstract class AbstractDatatypePropertiesDialog
extends AbstractPropertiesDialog {
    private JPanel pnUsedIn;
    private JPanel pnAttributes;
    private JPanel pnColumns;
    private JPanel pnObjAttributes;
    protected JTable attrTable;
    protected JTable columnsTable;
    protected JTable objAttrTable;
    private List<DesignUtilities.AttributeRef> usedInAttributesList;
    private List<TypeElement> usedInObjAttributesList;
    private List<DesignUtilities.ColumnRef> usedInColumnsList;
    protected DesignObject datatypeObject;
    private short use;
    protected JTabbedPane tabbedPaneUsedIn;

    public AbstractDatatypePropertiesDialog(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    public AbstractDatatypePropertiesDialog(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
    }

    @Override
    protected JPanel getUsedInPanel() {
        if (this.pnUsedIn == null) {
            this.pnUsedIn = this.createPage(Messages.getString("AbstractDatatypePropertiesDialog.UsedIn"));
            this.taUsedIn = new JTextArea();
            this.taUsedIn.setEnabled(super.isEditable());
            this.pnUsedIn.add(new JScrollPane(this.taUsedIn));
            this.usedInAttributesList = new ArrayList<DesignUtilities.AttributeRef>();
            this.usedInColumnsList = new ArrayList<DesignUtilities.ColumnRef>();
            this.usedInObjAttributesList = new ArrayList<TypeElement>();
            this.pnAttributes = this.initAttributesPanel();
            this.pnColumns = this.initColumnsPanel();
            this.pnObjAttributes = this.initObjAttributesPanel();
            this.tabbedPaneUsedIn = new JTabbedPane();
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.Attributes"), this.pnAttributes);
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.Columns"), this.pnColumns);
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.ObjAttributes"), this.pnObjAttributes);
            this.pnUsedIn.add(this.tabbedPaneUsedIn);
        }
        return this.pnUsedIn;
    }

    public JPanel createUsedInPanel(JTable table, MouseAdapter tableMouseAdapter, ActionListener propertiesButtonActionListener) {
        return this.createUsedInPanel(table, tableMouseAdapter, propertiesButtonActionListener, null);
    }

    public JPanel createUsedInPanel(final JTable table, MouseAdapter tableMouseAdapter, ActionListener propertiesButtonActionListener, ActionListener addButtonActionListener) {
        JPanel result = new JPanel(new BorderLayout());
        table.setSelectionMode(0);
        table.addMouseListener(tableMouseAdapter);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(BTN_PROPERTIES);
        btnProperties.addActionListener(propertiesButtonActionListener);
        toolBar.add(btnProperties);
        btnProperties.setEnabled(false);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                btnProperties.setEnabled(table.getSelectedRow() > -1);
            }
        });
        if (super.isEditable() && addButtonActionListener != null) {
            JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(addButtonActionListener);
            toolBar.add(btnAdd);
        }
        buttonPanel.add(toolBar);
        JPanel attrPanel = new JPanel(new BorderLayout());
        attrPanel.add((Component)buttonPanel, "North");
        attrPanel.add(new JScrollPane(table));
        result.add(attrPanel);
        return result;
    }

    public JPanel initAttributesPanel() {
        this.attrTable = new JTable(new AttributeTableModel());
        MouseAdapter tableMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedColumn();
                    int row = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedRow();
                    if (row != -1 && AbstractDatatypePropertiesDialog.this.usedInAttributesList.size() > 0 && row < AbstractDatatypePropertiesDialog.this.usedInAttributesList.size()) {
                        DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)AbstractDatatypePropertiesDialog.this.usedInAttributesList.get(row);
                        if (col == 0) {
                            Entity attrEntity = attrDomain.getEntity();
                            if (!attrEntity.isDialogVisible()) {
                                attrEntity.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                attrEntity.showPropertyDialog();
                            }
                        } else {
                            Attribute attr = attrDomain.getAttribute();
                            if (!attr.isDialogVisible()) {
                                attr.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                attr.showPropertyDialog();
                            }
                        }
                    }
                }
            }
        };
        ActionListener propertiesButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedColumn();
                int row = AbstractDatatypePropertiesDialog.this.attrTable.getSelectedRow();
                if (row != -1 && AbstractDatatypePropertiesDialog.this.usedInAttributesList.size() > 0 && row < AbstractDatatypePropertiesDialog.this.usedInAttributesList.size()) {
                    int icol = AbstractDatatypePropertiesDialog.this.attrTable.getEditingColumn();
                    int irow = AbstractDatatypePropertiesDialog.this.attrTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        AbstractDatatypePropertiesDialog.this.attrTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)AbstractDatatypePropertiesDialog.this.usedInAttributesList.get(row);
                    if (column == 0) {
                        Entity ent = attrDomain.getEntity();
                        if (!ent.isDialogVisible()) {
                            ent.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            ent.showPropertyDialog();
                        }
                    } else {
                        Attribute attr = attrDomain.getAttribute();
                        if (!attr.isDialogVisible()) {
                            attr.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            attr.showPropertyDialog();
                        }
                    }
                }
            }
        };
        return this.createUsedInPanel(this.attrTable, tableMouseAdapter, propertiesButtonActionListener);
    }

    public JPanel initColumnsPanel() {
        this.columnsTable = new JTable(new ColumnTableModel());
        MouseAdapter tableMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedColumn();
                    int row = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedRow();
                    if (row != -1 && AbstractDatatypePropertiesDialog.this.usedInColumnsList.size() > 0 && row < AbstractDatatypePropertiesDialog.this.usedInColumnsList.size()) {
                        DesignUtilities.ColumnRef colDomain = (DesignUtilities.ColumnRef)AbstractDatatypePropertiesDialog.this.usedInColumnsList.get(row);
                        if (col == 0) {
                            RelationalDesign model = colDomain.getModel();
                            if (!model.isDialogVisible()) {
                                model.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                model.showPropertyDialog();
                            }
                        } else if (col == 1) {
                            Table tbl = colDomain.getTable();
                            if (!tbl.isDialogVisible()) {
                                tbl.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                tbl.showPropertyDialog();
                            }
                        } else {
                            Column clm = colDomain.getColumn();
                            if (!clm.isDialogVisible()) {
                                clm.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                clm.showPropertyDialog();
                            }
                        }
                    }
                }
            }
        };
        ActionListener propertiesButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedColumn();
                int row = AbstractDatatypePropertiesDialog.this.columnsTable.getSelectedRow();
                if (row != -1 && AbstractDatatypePropertiesDialog.this.usedInColumnsList.size() > 0 && row < AbstractDatatypePropertiesDialog.this.usedInColumnsList.size()) {
                    int icol = AbstractDatatypePropertiesDialog.this.columnsTable.getEditingColumn();
                    int irow = AbstractDatatypePropertiesDialog.this.columnsTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        AbstractDatatypePropertiesDialog.this.columnsTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    DesignUtilities.ColumnRef colDomain = (DesignUtilities.ColumnRef)AbstractDatatypePropertiesDialog.this.usedInColumnsList.get(row);
                    if (col == 0) {
                        RelationalDesign model = colDomain.getModel();
                        if (!model.isDialogVisible()) {
                            model.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            model.showPropertyDialog();
                        }
                    } else if (col == 1) {
                        Table tbl = colDomain.getTable();
                        if (!tbl.isDialogVisible()) {
                            tbl.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            tbl.showPropertyDialog();
                        }
                    } else {
                        Column clm = colDomain.getColumn();
                        if (!clm.isDialogVisible()) {
                            clm.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            clm.showPropertyDialog();
                        }
                    }
                }
            }
        };
        return this.createUsedInPanel(this.columnsTable, tableMouseAdapter, propertiesButtonActionListener);
    }

    public JPanel initObjAttributesPanel() {
        this.objAttrTable = new JTable(new ObjAttributeTableModel());
        MouseAdapter tableMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedColumn();
                    int row = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedRow();
                    if (row != -1 && AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size() > 0 && row < AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size()) {
                        TypeElement attr = (TypeElement)AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.get(row);
                        if (col == 0) {
                            StructuredType attrST = attr.getStructuredType();
                            if (!attrST.isDialogVisible()) {
                                attrST.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                                attrST.showPropertyDialog();
                            }
                        } else if (!attr.isDialogVisible()) {
                            attr.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            attr.showPropertyDialog();
                        }
                    }
                }
            }
        };
        ActionListener propertiesButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedColumn();
                int row = AbstractDatatypePropertiesDialog.this.objAttrTable.getSelectedRow();
                if (row != -1 && AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size() > 0 && row < AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size()) {
                    int icol = AbstractDatatypePropertiesDialog.this.objAttrTable.getEditingColumn();
                    int irow = AbstractDatatypePropertiesDialog.this.objAttrTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        AbstractDatatypePropertiesDialog.this.objAttrTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    TypeElement attr = (TypeElement)AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.get(row);
                    if (column == 0) {
                        StructuredType attrST = attr.getStructuredType();
                        if (!attrST.isDialogVisible()) {
                            attrST.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                            attrST.showPropertyDialog();
                        }
                    } else if (!attr.isDialogVisible()) {
                        attr.showModal = AbstractDatatypePropertiesDialog.this.datatypeObject.showModal;
                        attr.showPropertyDialog();
                    }
                }
            }
        };
        return this.createUsedInPanel(this.objAttrTable, tableMouseAdapter, propertiesButtonActionListener);
    }

    protected void initUsedInAttributes(DesignObject datatypeObject, short use) {
        this.datatypeObject = datatypeObject;
        this.use = use;
        this.usedInAttributesList = DesignUtilities.extractUsedInAttributes(this.getDesignObject().getDesign(), datatypeObject, use);
    }

    protected void initUsedInColumns() {
        this.usedInColumnsList = DesignUtilities.extractUsedInColumns(this.getDesignObject().getDesign(), this.datatypeObject, this.use);
    }

    protected void initUsedInObjectAttributes() {
        this.usedInObjAttributesList = DesignUtilities.extractUsedInStructuredTypeAttributes(this.getDesignObject().getDesign(), this.datatypeObject);
    }

    class ColumnTableModel
    extends UsedInObjectModel {
        ColumnTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return AbstractDatatypePropertiesDialog.this.usedInColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Model");
            }
            if (column == 1) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Table");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Column");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignUtilities.ColumnRef columnDomain = (DesignUtilities.ColumnRef)AbstractDatatypePropertiesDialog.this.usedInColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return columnDomain.getModel().getName();
            }
            if (columnIndex == 1) {
                return columnDomain.getTable().getName();
            }
            if (columnIndex == 2) {
                return columnDomain.getColumn().getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class ObjAttributeTableModel
    extends UsedInObjectModel {
        ObjAttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Object");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Attribute");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TypeElement attr = (TypeElement)AbstractDatatypePropertiesDialog.this.usedInObjAttributesList.get(rowIndex);
            if (columnIndex == 0) {
                return attr.getStructuredType().getName();
            }
            if (columnIndex == 1) {
                return attr.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class AttributeTableModel
    extends UsedInObjectModel {
        AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AbstractDatatypePropertiesDialog.this.usedInAttributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Entity");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Attribute");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)AbstractDatatypePropertiesDialog.this.usedInAttributesList.get(rowIndex);
            if (columnIndex == 0) {
                return attrDomain.getEntity().getName();
            }
            if (columnIndex == 1) {
                return attrDomain.getAttribute().getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    protected abstract class UsedInObjectModel
    extends AbstractTableModel {
        protected UsedInObjectModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return new Integer(rowIndex * columnIndex);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

