/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AddChangeRequestDialog
extends JDialog
implements AbstractEditorConstants {
    private DesignObject desObject;
    private List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;
    private int counter = 0;

    public AddChangeRequestDialog(ApplicationView view, DesignObject desObject, List sList) {
        super(view.getFrame());
        this.setModal(true);
        this.desObject = desObject;
        this.sList = sList;
        this.setTitle(Messages.getString("AddChangeRequestDialog.AddChangeRequest"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddChangeRequestDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1));
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddChangeRequestDialog.SelectRequest")));
        RadioListener listener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("AddChangeRequestDialog.NewChangeRequest"));
        this.rbNew.addActionListener(listener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("AddChangeRequestDialog.AvailableChangeRequests"));
        this.rbAll.addActionListener(listener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbNew);
        group.add(this.rbAll);
        pnTop.add(this.rbNew);
        pnTop.add(this.rbAll);
        this.generalPanel.add((Component)pnTop, "North");
        JPanel pnList = new JPanel();
        pnList.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddChangeRequestDialog.AllChangeRequests")));
        this.allList.addAll(this.getAllRequests());
        this.allTable = new JTable(new AllRequestsModel());
        this.allTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.allTable);
        scrollpane.setPreferredSize(new Dimension(320, 220));
        pnList.add(scrollpane);
        this.generalPanel.add(pnList);
        this.enableControls(!this.rbNew.isSelected());
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.setResizable(false);
    }

    private void enableControls(boolean enable) {
        this.allTable.setEnabled(enable);
        this.allTable.clearSelection();
        if (!enable) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    private List getAllRequests() {
        ArrayList<ChangeRequest> list = new ArrayList<ChangeRequest>();
        int length = this.desObject.getDesign().getChangeRequestSet().size();
        for (int i = 0; i < length; ++i) {
            ChangeRequest request = (ChangeRequest)this.desObject.getDesign().getChangeRequestSet().getElement(i);
            if (this.sList.contains(request)) continue;
            list.add(request);
        }
        return list;
    }

    protected String generateRequestName() {
        String m = Messages.getString("AddChangeRequestDialog.Request");
        int newNumber = 0;
        int lastNumber = this.sList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        String mName = m.concat("_").concat(Integer.toString(newNumber));
        while (this.requestExists(mName)) {
            newNumber = ++this.counter;
            mName = m.concat("_").concat(Integer.toString(newNumber));
        }
        return mName;
    }

    private boolean requestExists(String name) {
        for (int i = 0; i < this.sList.size(); ++i) {
            ChangeRequest req = (ChangeRequest)this.sList.get(i);
            if (!name.equalsIgnoreCase(req.getName())) continue;
            return true;
        }
        return false;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddChangeRequestDialog.this.dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddChangeRequestDialog.this.rbNew.isSelected()) {
                ChangeRequest request = AddChangeRequestDialog.this.desObject.getDesign().getChangeRequestSet().createChangeRequest(null);
                request.setObject(AddChangeRequestDialog.this.desObject);
                AddChangeRequestDialog.this.sList.add(request);
            } else {
                int row = AddChangeRequestDialog.this.allTable.getSelectedRow();
                if (row != -1 && AddChangeRequestDialog.this.allList.size() > 0 && row < AddChangeRequestDialog.this.allList.size()) {
                    ChangeRequest request = (ChangeRequest)AddChangeRequestDialog.this.allList.get(row);
                    AddChangeRequestDialog.this.sList.add(request);
                }
            }
            AddChangeRequestDialog.this.dispose();
        }
    }

    private class AllRequestsModel
    extends AbstractTableModel {
        private AllRequestsModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AddChangeRequestDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AddChangeRequestDialog.ChangeRequest");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ChangeRequest request = (ChangeRequest)AddChangeRequestDialog.this.allList.get(row);
            if (col == 0) {
                return request.getName();
            }
            return new Integer(row * col);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddChangeRequestDialog.this.enableControls(!AddChangeRequestDialog.this.rbNew.isSelected());
        }
    }
}

