/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class DDLExceptionPropertyDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel buttonPanel;
    private JPanel general;
    private JIntegerField ifNumber;
    private static Dimension dim1 = new Dimension(90, 20);
    private static Dimension dim2 = new Dimension(250, 20);
    private JTextArea taDescription;
    private DDLException ddlException;
    private JButton bnOK;
    private Dialog parent;

    public DDLExceptionPropertyDialog(ApplicationView appView, DDLException ddlException, Dialog parent) {
        super(appView);
        this.ddlException = ddlException;
        this.parent = parent;
        this.general = new JPanel();
        this.general.setBorder(BorderFactory.createEtchedBorder(0));
        this.initGeneral();
        this.add((Component)this.general, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
    }

    private void initGeneral() {
        JPanel jpanel = new JPanel(new BorderLayout(0, 10));
        JLabel lbType = new JLabel(Messages.getString("DDLExceptionPropertyDialog.Number"));
        lbType.setPreferredSize(dim1);
        this.ifNumber = new JIntegerField();
        this.ifNumber.setPreferredSize(dim2);
        jpanel.add((Component)this.createRow(lbType, this.ifNumber), "North");
        JLabel lbDescription = new JLabel(Messages.getString("DDLExceptionPropertyDialog.Description"));
        lbDescription.setPreferredSize(dim1);
        this.taDescription = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taDescription);
        sp.setPreferredSize(new Dimension(250, 180));
        jpanel.add((Component)this.createRow(lbDescription, sp), "Center");
        this.general.add(jpanel);
    }

    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            this.bnOK = new JButton(Messages.getString("DDLExceptionPropertyDialog.OK"));
            this.bnOK.setMnemonic(79);
            this.bnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DDLExceptionPropertyDialog.this.setProperties();
                    DDLExceptionPropertyDialog.this.close();
                }
            });
            JButton cancel = new JButton(Messages.getString("DDLExceptionPropertyDialog.Cancel"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DDLExceptionPropertyDialog.this.close();
                }
            });
            this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(this.bnOK);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, Messages.getString("DDLExceptionPropertyDialog.DDLExceptionProperties"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog, false);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        this.ifNumber.requestFocus();
        this.ifNumber.selectAll();
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public void initProperties() {
        this.ifNumber.setValue((long)this.ddlException.getNumber());
        this.taDescription.setText(this.ddlException.getDescription());
    }

    private void setProperties() {
        this.ddlException.setNumber(this.ifNumber.getIntValue());
        this.ddlException.setDescription(this.taDescription.getText());
    }
}

