/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.glossary.GlossaryDialog;
import oracle.dbtools.crest.util.ColorChooserDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.TopViewColorDialog;
import oracle.dbtools.crest.util.compare.CompareMappingDialog;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.dbtools.crest.util.gui.swing.JLWComboBox;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.dbtools.crest.util.options.format.DefaultLineWidthAndColor;
import oracle.dbtools.crest.util.options.namingstandards.GlossaryFile;
import oracle.dbtools.crest.util.options.namingstandards.WordRule;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DesignPropertiesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private static final String NAME_PART = Messages.getString("DesignPropertiesDialog.NamePart");
    private static final String MANDATORY = Messages.getString("DesignPropertiesDialog.Mandatory");
    private static final String PRIME_WORD_L = Messages.getString("DesignPropertiesDialog.PrimeWord");
    private static final String CLASS_WORD_L = Messages.getString("DesignPropertiesDialog.ClassWord");
    private static final String MODIFIER_L = Messages.getString("DesignPropertiesDialog.Modifier");
    private static final String QUALIFIER_L = Messages.getString("DesignPropertiesDialog.Qialifier");
    private static final String btnName = Messages.getString("DesignPropertiesDialog.AddVariable");
    private static final String USE_DOMAN_NAME = Messages.getString("DesignPropertiesDialog.DomainName");
    private static final String USE_LOGICAL_TYPE = Messages.getString("DesignPropertiesDialog.UsedLogicalType");
    private static final String[] domain_presentation = new String[]{USE_DOMAN_NAME, USE_LOGICAL_TYPE};
    private JDialog dialog;
    private JPanel pnGeneral;
    private JPanel pnSettings;
    private JPanel pnDDL;
    private JPanel pnDDLMigration;
    private JPanel pnDiagram;
    private JPanel pnDiagramLogical;
    private JPanel pnClassificationTypes;
    private JPanel pnFormat;
    private JPanel pnCompareMappings;
    private JPanel pnNamingStandard;
    private JPanel pnNamingStandardAttribute;
    private JPanel pnNamingStandardColumn;
    private JPanel pnNamingStandardDomain;
    private JPanel pnNamingStandardEntity;
    private JPanel pnNamingStandardTable;
    private JPanel pnNamingStandardTemplates;
    private JPanel buttonPanel;
    private Design design;
    protected JTextField tfName;
    protected JTextArea taComments;
    protected JTextArea taNotes;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    private Dimension defaultSize = new Dimension(150, 20);
    private JPanel pnMain;
    protected CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnComments;
    private JPanel pnNotes;
    private JPanel pnSummary;
    private JTree tree;
    private List substitutionList;
    private List localSubstitutionList;
    private JTable tbSubstituiton;
    private JButton bnRemoveClassificationType;
    private JButton bnRemoveSubstitution;
    private List classificationTypeList;
    private List localClassificationTypeList;
    private JTable classificationTypeTable;
    private List defaultFCList;
    private List localDefaultFCList;
    private JTable tbDefaultFC;
    private List defaultLWCList;
    private List localDefaultLWCList;
    private List nsAttributesList;
    private JTable nsAttributesTable;
    private List nsColumnsList;
    private JTable nsColumnsTable;
    private List nsDomainsList;
    private JTable nsDomainsTable;
    private List nsEntitiesList;
    private JTable nsEntitiesTable;
    private List nsTablesList;
    private JTable nsTablesTable;
    private JTable tbDefaultLWC;
    private JComboBox cbDomainPresentation;
    public static LinkedHashMap namePartMap = new LinkedHashMap();
    private JCheckBox checkBox = new JCheckBox();
    private DefaultCellEditor optionalEditor = new DefaultCellEditor(this.checkBox);
    private LinkedHashMap logicalModelSeparatorMap = new LinkedHashMap();
    private JTextField tfForeignKey;
    private JTextField tfPrimaryKey;
    private JTextField tfCheckConstr;
    private JTextField tfUniqueConstr;
    private JTextField tfIndex;
    private JTextField tfAutomaticIndex;
    private JTextField tfColCheckConstr;
    private JTextField tfColNNConstr;
    private JTextField tfColumnForeignKey;
    private JTextField tfSurrogateKey;
    private JTextField tfSurrogateKeyColumn;
    private JTextField tfDiscriminatorColumn;
    private JTextField tfPrimaryIdentifier;
    private JTextField tfAttributeRelation;
    private JCharField separatorText;
    private JCharField characterField;
    private JCharField dmsSeparator;
    private JComboBox separatorBox;
    private JCheckBox abbreviatedOnly;
    private JTable glossaryTable;
    private JCheckBox chAutomaticPKGeneration;
    private JCheckBox chAutomaticUKGeneration;
    private JCheckBox chAutomaticFKGeneration;
    private JCheckBox cbPreserveDDLGenerationOptions;
    private String pkConsr = "{table}_PK";
    private String fkConsr = "{child}_{parent}_FK";
    private String ckConsr = "{table}_CK";
    private String unConstr = "{table}_{column}_UN";
    private String idxConstr = "{table}_{column}_IDX";
    private String automaticIdxConstr = "{constraint}_IX";
    private String colckConstr = "CK_ {table}_{column}";
    private String colNNConstr = "NNC_{table abbr}_{column}";
    private String attrRelation = "{ref entity}_{ref attribute}";
    private String colForeignKey = "{ref table}_{ref column}";
    private String surrogateKey = "{table abbr}_PK";
    private String surrogateKeyCol = "{table abbr}_ID";
    private String discriminatorCol = "{table abbr}_TYPE";
    private String uiConsr = "{entity} PK";
    private String automaticIndexText = Messages.getString("DesignPropertiesDialog.AutoIndex");
    private String sKeyConstrText = Messages.getString("DesignPropertiesDialog.SurrogateKey");
    private String sKeyColConstrText = Messages.getString("DesignPropertiesDialog.SurrogatekeyColumn");
    private String dColumnConstrText = Messages.getString("DesignPropertiesDialog.DiscriminatorColumn");
    private String pkConstrText = Messages.getString("DesignPropertiesDialog.PrimaryKey");
    private String fkConstrText = Messages.getString("DesignPropertiesDialog.ForeignKey");
    private String chkConstrText = Messages.getString("DesignPropertiesDialog.CheckConstraint");
    private String ukConstrText = Messages.getString("DesignPropertiesDialog.UniqueConstraint");
    private String idxConstrText = Messages.getString("DesignPropertiesDialog.Index");
    private String colChkConstrText = Messages.getString("DesignPropertiesDialog.ColumnCheckConstraint");
    private String colNNConstrText = Messages.getString("DesignPropertiesDialog.ColumnNotNullConstraint");
    private String colFKText = Messages.getString("DesignPropertiesDialog.ColumnForeignKey");
    private String prIDConstrText = Messages.getString("DesignPropertiesDialog.PrimaryIdentifier");
    private String attrRelConstrText = Messages.getString("DesignPropertiesDialog.AttributeRelation");
    private DesignLevelSettings designLevelSettings;
    private final List glossariesList = new ArrayList();
    private JButton bnSelectAllSubstitutions;
    private JButton bnDeselectAllSubstitutions;
    private File lastFolder;
    private File lastImpDirectory;
    private File lastExpDirectory;
    private StringBuffer buffer;
    private static final Logger LOGGER = new Logger(DesignPropertiesDialog.class);
    private final String[] comboItems = new String[]{this.pkConstrText, this.fkConstrText, this.chkConstrText, this.ukConstrText, this.idxConstrText, this.automaticIndexText, this.colChkConstrText, this.colNNConstrText, this.colFKText, this.sKeyConstrText, this.sKeyColConstrText, this.dColumnConstrText, this.prIDConstrText, this.attrRelConstrText};

    public DesignPropertiesDialog(ApplicationView appView, Design design) {
        super(appView);
        this.design = design;
        this.designLevelSettings = design.getDesignLevelSettings();
        this.classificationTypeList = this.designLevelSettings.getClassificationTypeList();
        this.defaultFCList = this.designLevelSettings.getDefaultFCObjects();
        this.defaultLWCList = this.designLevelSettings.getDefaultLWCObjects();
        this.substitutionList = this.designLevelSettings.getSubstitutionList();
        this.initConstants();
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(170, 0));
        JSplitPane splitPane = new JSplitPane(1, scrollPane, this.getMainPanel());
        splitPane.setDividerLocation(150);
        splitPane.setDividerSize(3);
        this.add((Component)splitPane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.getDialog().getLocation(), this.getDialog().getSize());
        this.design.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.design.setDialogVisible(false, null);
        this.getDialog().dispose();
    }

    protected int getMinimumWidth() {
        return 650;
    }

    protected int getMinimumHeight() {
        return 550;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), MessageFormat.format(Messages.getString("DesignPropertiesDialog.DesignProperties"), this.design.getName()));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DesignPropertiesDialog.this.dialog.getWidth();
                    int h = DesignPropertiesDialog.this.dialog.getHeight();
                    w = Math.max(DesignPropertiesDialog.this.getMinimumWidth(), w);
                    h = Math.max(DesignPropertiesDialog.this.getMinimumHeight(), h);
                    DesignPropertiesDialog.this.dialog.setSize(w, h);
                }
            });
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            Rectangle rectangle = this.design.getAppView().getSettings().getDialogSettings(this.getClass().getName());
            if (rectangle == null) {
                this.dialog.setSize(this.getMinimumWidth(), this.getMinimumHeight());
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                this.dialog.setSize(rectangle.getSize());
                this.dialog.setLocation(rectangle.getLocation());
            }
        }
        return this.dialog;
    }

    public void showDialog() {
        this.design.setDialogVisible(true, (JDialog)this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return "DESIGN_PROPERTIES_DIALOG";
    }

    public JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    protected void addToTree(DefaultMutableTreeNode node, JPanel panel) {
        node.add(new DefaultMutableTreeNode(panel));
        this.getMainPanel().add((Component)panel, panel.getName());
    }

    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        DefaultMutableTreeNode settingsNode = new DefaultMutableTreeNode(this.getSettingsPanel());
        this.getMainPanel().add((Component)this.getSettingsPanel(), this.getSettingsPanel().getName());
        this.addToTree(settingsNode, this.getCompareMappingsPanel());
        DefaultMutableTreeNode diagramNode = new DefaultMutableTreeNode(this.getDiagramPanel());
        this.getMainPanel().add((Component)this.getDiagramPanel(), this.getDiagramPanel().getName());
        this.addToTree(diagramNode, this.getDiagramClassificationTypesPanel());
        this.addToTree(diagramNode, this.getDiagramFormatPanel());
        this.addToTree(diagramNode, this.getDiagramLogicalPanel());
        settingsNode.add(diagramNode);
        DefaultMutableTreeNode settingsDDLNode = new DefaultMutableTreeNode(this.getDDLPanel());
        this.getMainPanel().add((Component)this.getDDLPanel(), this.getDDLPanel().getName());
        this.addToTree(settingsDDLNode, this.getDDLMIgrationPanel());
        settingsNode.add(settingsDDLNode);
        DefaultMutableTreeNode nsNode = new DefaultMutableTreeNode(this.getNamingStandardPanel());
        this.getMainPanel().add((Component)this.getNamingStandardPanel(), this.getNamingStandardPanel().getName());
        this.addToTree(nsNode, this.getNamingStandardAttributePanel());
        this.addToTree(nsNode, this.getNamingStandardColumnPanel());
        this.addToTree(nsNode, this.getNamingStandardDomainPanel());
        this.addToTree(nsNode, this.getNamingStandardEntityPanel());
        this.addToTree(nsNode, this.getNamingStandardTablePanel());
        this.addToTree(nsNode, this.getNamingStandardTemplatesPanel());
        settingsNode.add(nsNode);
        root.add(settingsNode);
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("DesignPropertiesDialog.Comments"));
            this.taComments = new JTextArea();
            this.taComments.setEnabled(this.isEditable());
            this.pnComments.add(new JScrollPane(this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("DesignPropertiesDialog.Notes"));
            this.taNotes = new JTextArea();
            this.taNotes.setEnabled(this.isEditable());
            this.pnNotes.add(new JScrollPane(this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("DesignPropertiesDialog.Summary"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbObjectID = new JLabel(LB_OBJECT_ID);
            lbObjectID.setPreferredSize(this.defaultSize);
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.defaultSize);
            this.tfObjectID.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbObjectID, this.tfObjectID));
            JLabel lbCreator = new JLabel(LB_CREATOR);
            lbCreator.setPreferredSize(this.defaultSize);
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.defaultSize);
            this.tfCreator.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbCreator, this.tfCreator));
            JLabel lbCreationTime = new JLabel(LB_CREATION_TIME);
            lbCreationTime.setPreferredSize(this.defaultSize);
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.defaultSize);
            this.tfCreationTime.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbCreationTime, this.tfCreationTime));
            JLabel lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
            lbLastChangedBy.setPreferredSize(this.defaultSize);
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.defaultSize);
            this.tfLastChangedBy.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbLastChangedBy, this.tfLastChangedBy));
            JLabel lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
            lbLastChangedTime.setPreferredSize(this.defaultSize);
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.defaultSize);
            this.tfLastChangedTime.setEditable(false);
            pnSummaryGrid.add(this.createRow(lbLastChangedTime, this.tfLastChangedTime));
            jpanel.add((Component)pnSummaryGrid, "North");
            this.pnSummary.add((Component)jpanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel createPage(String title) {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel("<html><body><b>" + title + "</b>" + "</body>" + "</html>");
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("DesignPropertiesDialog.General"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbName = new JLabel(LB_NAME);
            lbName.setPreferredSize(this.defaultSize);
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.defaultSize);
            this.tfName.setEnabled(false);
            pnGeneralGrid.add(this.createRow(lbName, this.tfName));
            jpanel.add((Component)pnGeneralGrid, "North");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getSettingsPanel() {
        if (this.pnSettings == null) {
            this.pnSettings = this.createPage(Messages.getString("DesignPropertiesDialog.Settings"));
            JPanel btnPanel = new JPanel(new GridBagLayout());
            JButton bnImport = new JButton(Messages.getString("DesignPropertiesDialog.Import"));
            bnImport.setMnemonic(73);
            bnImport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnImport.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("DesignPropertiesDialog.XMLFiles");
                        }
                    };
                    URLChooser fileChooser = DialogUtil.newURLChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    if (DesignPropertiesDialog.this.lastImpDirectory != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)DesignPropertiesDialog.this.lastImpDirectory));
                    } else {
                        String lastDir = DesignPropertiesDialog.this.getApplicationView().getSettings().getDefaultImportPath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = DesignPropertiesDialog.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int result = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DesignPropertiesDialog.ImportDLS"));
                    if (result == 0) {
                        Reader in = null;
                        File file = null;
                        try {
                            file = new File(fileChooser.getSelectedURL().getPath());
                            if (file.exists()) {
                                int ch;
                                DesignPropertiesDialog.this.lastImpDirectory = file.getParentFile();
                                DesignPropertiesDialog.this.buffer = new StringBuffer();
                                FileInputStream fis = new FileInputStream(file);
                                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                                in = new BufferedReader(isr);
                                while ((ch = in.read()) > -1) {
                                    DesignPropertiesDialog.this.buffer.append((char)ch);
                                }
                                in.close();
                                DesignPropertiesDialog.this.designLevelSettings.loadDesignLevellSettingsFromString(DesignPropertiesDialog.this.buffer.toString());
                                DesignPropertiesDialog.this.initProperties();
                                DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                                MessageDialogs.showMessage("Design level settings inported successfully from file " + file.getAbsolutePath());
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Unable to initialize design level settings from the imported file " + fileChooser.getSelectedURL().getPath() + " ", ex);
                            MessageDialogs.showMessage("Error when importing file with design level settings " + file.getAbsolutePath() + "/nPlease see the log file for more information.");
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e1) {
                                    LOGGER.error("Import design level settings. Unable to close the input reader ", e1);
                                }
                            }
                        }
                    }
                }
            });
            JButton bnExport = new JButton(Messages.getString("DesignPropertiesDialog.Export"));
            bnExport.setMnemonic(69);
            bnExport.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URLFilter fileFilter = new URLFilter(){

                        public boolean accept(URL url) {
                            File file = new File(url.getPath());
                            return file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                        }

                        public String toString() {
                            return Messages.getString("DesignPropertiesDialog.XMLFiles");
                        }
                    };
                    URLChooser fileChooser = DialogUtil.newURLChooser();
                    fileChooser.clearChooseableURLFilters();
                    fileChooser.setSelectionScope(0);
                    fileChooser.setSelectionMode(0);
                    fileChooser.setShowJarsAsDirs(false);
                    fileChooser.setURLFilter(fileFilter);
                    if (DesignPropertiesDialog.this.lastExpDirectory != null) {
                        fileChooser.setSelectedURL(URLFactory.newDirURL((File)DesignPropertiesDialog.this.lastExpDirectory));
                    } else {
                        String lastDir = DesignPropertiesDialog.this.getApplicationView().getSettings().getDefaultSavePath();
                        if (lastDir != null && lastDir.length() > 0) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                        } else {
                            URL url = DesignPropertiesDialog.this.getApplicationView().getUserHomeDirectory();
                            if (url != null) {
                                fileChooser.setSelectedURL(url);
                            }
                        }
                    }
                    int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DesignPropertiesDialog.ExportDLS"));
                    if (status == 0) {
                        File file = null;
                        try {
                            file = new File(fileChooser.getSelectedURL().getPath());
                            if (file != null) {
                                DesignPropertiesDialog.this.designLevelSettings.saveDesignLevelLSettingsFile(file.getAbsolutePath());
                                MessageDialogs.showMessage("Design level settings are exported successfully in file " + file.getAbsolutePath());
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("Unable to export design level settings in file " + fileChooser.getSelectedURL().getPath() + " ", ex);
                            MessageDialogs.showMessage("Error when exporting file with design level settings " + file.getAbsolutePath() + "/nPlease see the log file for more information.");
                        }
                    }
                }
            });
            JButton bnSave = new JButton("Save");
            bnSave.setMnemonic(69);
            bnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        DesignPropertiesDialog.this.setProperties();
                        DesignPropertiesDialog.this.design.saveDesignLevelSettings();
                        MessageDialogs.showMessage("Design level settings are saved successfully.");
                    }
                    catch (Exception ex) {
                        LOGGER.error("Unable to save design level settings", ex);
                        MessageDialogs.showMessage("Error when saving design level settings. /nPlease see the log file for more information.");
                    }
                }
            });
            this.addItem(btnPanel, bnImport, 0, 1, 1, 1, 17, 0, 1);
            this.addItem(btnPanel, bnExport, 1, 1, 1, 1, 17, 0, 1);
            this.addItem(btnPanel, bnSave, 2, 1, 1, 1, 17, 0, 1);
            JPanel jp = new JPanel(new GridBagLayout());
            jp.add((Component)new JLabel(""), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 1, 1));
            jp.add((Component)btnPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.pnSettings.add((Component)jp, "Center");
        }
        return this.pnSettings;
    }

    protected JPanel getDiagramPanel() {
        if (this.pnDiagram == null) {
            this.pnDiagram = this.createPage(Messages.getString("DesignPropertiesDialog.Diagram"));
        }
        return this.pnDiagram;
    }

    protected JPanel getDiagramLogicalPanel() {
        if (this.pnDiagramLogical == null) {
            this.pnDiagramLogical = this.createPage(Messages.getString("DesignPropertiesDialog.LogicalModel"));
            JPanel jpanel = new JPanel(new FlowLayout(0));
            JLabel lbDomainPresentation = new JLabel(Messages.getString("DesignPropertiesDialog.DomainsPresentation"));
            this.cbDomainPresentation = new JComboBox<String>(new DefaultComboBoxModel<String>(domain_presentation));
            if (ApplicationView.IS_VIEWER && !this.getApplicationView().getCurrentDesign().isNewDesign()) {
                this.cbDomainPresentation.setEnabled(false);
            } else {
                this.cbDomainPresentation.setEnabled(true);
            }
            jpanel.add(lbDomainPresentation);
            jpanel.add(this.cbDomainPresentation);
            this.pnDiagramLogical.add((Component)jpanel, "Center");
        }
        return this.pnDiagramLogical;
    }

    protected JPanel getDDLPanel() {
        if (this.pnDDL == null) {
            this.pnDDL = this.createPage(Messages.getString("DesignPropertiesDialog.DDL"));
            JPanel jp = new JPanel(new GridBagLayout());
            JPanel pnIndexGeneration = new JPanel(new GridBagLayout());
            pnIndexGeneration.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.AutoIndexGeneration")));
            this.chAutomaticPKGeneration = new JCheckBox(Messages.getString("DesignPropertiesDialog.PKConstraint"));
            this.addItem(pnIndexGeneration, this.chAutomaticPKGeneration, 0, 0, 1, 1, 17, 1, 1);
            this.chAutomaticUKGeneration = new JCheckBox(Messages.getString("DesignPropertiesDialog.UKConstraint"));
            this.addItem(pnIndexGeneration, this.chAutomaticUKGeneration, 0, 1, 1, 1, 17, 1, 1);
            this.chAutomaticFKGeneration = new JCheckBox(Messages.getString("DesignPropertiesDialog.FKConstraint"));
            this.addItem(pnIndexGeneration, this.chAutomaticFKGeneration, 0, 2, 1, 1, 17, 1, 1);
            if (ApplicationView.IS_VIEWER) {
                this.chAutomaticPKGeneration.setEnabled(false);
                this.chAutomaticUKGeneration.setEnabled(false);
                this.chAutomaticFKGeneration.setEnabled(false);
            } else {
                this.chAutomaticPKGeneration.setEnabled(true);
                this.chAutomaticUKGeneration.setEnabled(true);
                this.chAutomaticFKGeneration.setEnabled(true);
            }
            JPanel pnPreserveCurrentDDLGenerationOptionsSelection = new JPanel(new GridBagLayout());
            pnPreserveCurrentDDLGenerationOptionsSelection.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.PreserveCurrentDDLGenerationOptions")));
            this.cbPreserveDDLGenerationOptions = new JCheckBox(Messages.getString("DesignPropertiesDialog.PreserveDDLGenerationOptions"));
            this.addItem(pnPreserveCurrentDDLGenerationOptionsSelection, this.cbPreserveDDLGenerationOptions, 0, 0, 1, 1, 17, 1, 1);
            this.cbPreserveDDLGenerationOptions.setSelected(true);
            this.cbPreserveDDLGenerationOptions.setEnabled(true);
            jp.add((Component)pnIndexGeneration, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jp.add((Component)pnPreserveCurrentDDLGenerationOptionsSelection, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jp.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 0, 0, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 1, 1));
            this.pnDDL.add((Component)jp, "Center");
        }
        return this.pnDDL;
    }

    protected JPanel getDDLMIgrationPanel() {
        if (this.pnDDLMigration == null) {
            this.pnDDLMigration = this.createPage(Messages.getString("DesignPropertiesDialog.Migration"));
            JPanel substPanel = new JPanel(new GridBagLayout());
            substPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.NameSubstitution")));
            this.localSubstitutionList = new ArrayList();
            this.tbSubstituiton = new JTable(new SubstitutionModel());
            this.tbSubstituiton.setSelectionMode(0);
            this.tbSubstituiton.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int selRow = DesignPropertiesDialog.this.tbSubstituiton.getSelectedRow();
                    if (selRow == -1) {
                        DesignPropertiesDialog.this.bnRemoveSubstitution.setEnabled(false);
                    } else {
                        DesignPropertiesDialog.this.bnRemoveSubstitution.setEnabled(true);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.tbSubstituiton);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton bnAddSubstitution = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            bnAddSubstitution.setToolTipText(BTN_ADD);
            bnAddSubstitution.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SubstitutionPattern substPattern = new SubstitutionPattern();
                    DesignPropertiesDialog.this.localSubstitutionList.add(substPattern);
                    DesignPropertiesDialog.this.tbSubstituiton.getSelectionModel().setSelectionInterval(DesignPropertiesDialog.this.tbSubstituiton.getRowCount() - 1, DesignPropertiesDialog.this.tbSubstituiton.getRowCount() - 1);
                    DesignPropertiesDialog.this.tbSubstituiton.updateUI();
                    DesignPropertiesDialog.this.bnSelectAllSubstitutions.setEnabled(true);
                    DesignPropertiesDialog.this.bnDeselectAllSubstitutions.setEnabled(true);
                }
            });
            this.bnRemoveSubstitution = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnRemoveSubstitution.setToolTipText(BTN_REMOVE);
            this.bnRemoveSubstitution.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = DesignPropertiesDialog.this.tbSubstituiton.getSelectedRow();
                    if (objectNumber != -1 && DesignPropertiesDialog.this.localSubstitutionList.size() > 0 && objectNumber < DesignPropertiesDialog.this.localSubstitutionList.size()) {
                        SubstitutionPattern substPattern = (SubstitutionPattern)DesignPropertiesDialog.this.localSubstitutionList.get(objectNumber);
                        DesignPropertiesDialog.this.localSubstitutionList.remove(substPattern);
                        DesignPropertiesDialog.this.tbSubstituiton.updateUI();
                    }
                    if (DesignPropertiesDialog.this.localSubstitutionList.size() > 0) {
                        DesignPropertiesDialog.this.bnRemoveSubstitution.setEnabled(true);
                        DesignPropertiesDialog.this.bnSelectAllSubstitutions.setEnabled(true);
                        DesignPropertiesDialog.this.bnDeselectAllSubstitutions.setEnabled(true);
                    } else {
                        DesignPropertiesDialog.this.bnRemoveSubstitution.setEnabled(false);
                        DesignPropertiesDialog.this.bnSelectAllSubstitutions.setEnabled(false);
                        DesignPropertiesDialog.this.bnDeselectAllSubstitutions.setEnabled(false);
                    }
                }
            });
            this.bnRemoveSubstitution.setEnabled(false);
            this.bnSelectAllSubstitutions = new JButton(configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
            this.bnSelectAllSubstitutions.setToolTipText(Messages.getString("DesignPropertiesDialog.SelectAll"));
            this.bnSelectAllSubstitutions.addActionListener(new SelectAllSubstitutionAction());
            this.bnSelectAllSubstitutions.setEnabled(false);
            this.bnDeselectAllSubstitutions = new JButton(configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
            this.bnDeselectAllSubstitutions.setToolTipText(Messages.getString("DesignPropertiesDialog.DeselectAll"));
            this.bnDeselectAllSubstitutions.addActionListener(new DeselectAllSubstitutionAction());
            this.bnDeselectAllSubstitutions.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(bnAddSubstitution);
            toolBar.add(this.bnRemoveSubstitution);
            toolBar.addSeparator();
            toolBar.add(this.bnSelectAllSubstitutions);
            toolBar.add(this.bnDeselectAllSubstitutions);
            substPanel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            substPanel.add((Component)scrollpane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 1, 1));
            this.pnDDLMigration.add((Component)substPanel, "Center");
        }
        return this.pnDDLMigration;
    }

    protected JPanel getDiagramClassificationTypesPanel() {
        if (this.pnClassificationTypes == null) {
            this.pnClassificationTypes = this.createPage(Messages.getString("DesignPropertiesDialog.ClassificationTypes"));
            try {
                this.localClassificationTypeList = new ArrayList();
                this.classificationTypeTable = new JTable(new ClassificationTypeModel());
                TableColumn classificationTypeColumn = this.classificationTypeTable.getColumnModel().getColumn(2);
                classificationTypeColumn.setCellEditor(new ClassificationTypeViewCellEditor());
                classificationTypeColumn.setCellRenderer(new ClassificationTypeCellRenderer());
                this.classificationTypeTable.setSelectionMode(0);
                JScrollPane scrollpane = new JScrollPane(this.classificationTypeTable);
                GUIConfiguration configuration = GUIConfiguration.getInstance();
                JButton bnAddClassificationType = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                bnAddClassificationType.setToolTipText(BTN_ADD);
                bnAddClassificationType.addActionListener(new AddClassificationTypeAction());
                this.bnRemoveClassificationType = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.bnRemoveClassificationType.setToolTipText(BTN_REMOVE);
                this.bnRemoveClassificationType.addActionListener(new RemoveClassificationType());
                this.bnRemoveClassificationType.setEnabled(false);
                this.classificationTypeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            int objectNumber = DesignPropertiesDialog.this.classificationTypeTable.getSelectedRow();
                            if (objectNumber != -1) {
                                if (DesignPropertiesDialog.this.localClassificationTypeList.size() > 0 && objectNumber < DesignPropertiesDialog.this.localClassificationTypeList.size()) {
                                    ClassificationType classType = (ClassificationType)DesignPropertiesDialog.this.localClassificationTypeList.get(objectNumber);
                                    DesignPropertiesDialog.this.bnRemoveClassificationType.setEnabled(!classType.isReadOnly());
                                }
                            } else if (objectNumber == -1) {
                                DesignPropertiesDialog.this.bnRemoveClassificationType.setEnabled(false);
                            }
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(bnAddClassificationType);
                toolBar.add(this.bnRemoveClassificationType);
                JPanel clfPanel = new JPanel(new GridBagLayout());
                clfPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.Type")));
                clfPanel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
                clfPanel.add((Component)scrollpane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 1, 1));
                this.pnClassificationTypes.add((Component)clfPanel, "Center");
            }
            catch (Exception e) {
                LOGGER.error("Unable to create Diagram -> Classification Types panel: ", e);
            }
        }
        return this.pnClassificationTypes;
    }

    protected JPanel getDiagramFormatPanel() {
        if (this.pnFormat == null) {
            this.pnFormat = this.createPage(Messages.getString("DesignPropertiesDialog.Format"));
            JTabbedPane tabbed = new JTabbedPane();
            this.localDefaultFCList = new ArrayList();
            this.tbDefaultFC = new JTable(new DefaultFCModel());
            this.tbDefaultFC.setSelectionMode(0);
            FontsAndColorsCellRenderer dfcRenderer = new FontsAndColorsCellRenderer();
            TableColumn tvColumn = this.tbDefaultFC.getColumnModel().getColumn(1);
            tvColumn.setCellRenderer(dfcRenderer);
            tvColumn = this.tbDefaultFC.getColumnModel().getColumn(2);
            tvColumn.setCellRenderer(dfcRenderer);
            this.tbDefaultFC.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int objectNumber;
                    if (e.getClickCount() == 2 && (objectNumber = DesignPropertiesDialog.this.tbDefaultFC.getSelectedRow()) != -1 && DesignPropertiesDialog.this.localDefaultFCList.size() > 0 && objectNumber < DesignPropertiesDialog.this.localDefaultFCList.size()) {
                        DefaultFontAndColor dfc = (DefaultFontAndColor)DesignPropertiesDialog.this.localDefaultFCList.get(objectNumber);
                        new TopViewColorDialog(dfc).setVisible(true);
                        DesignPropertiesDialog.this.tbDefaultFC.updateUI();
                        DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.tbDefaultFC);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton bnEdit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            bnEdit.setToolTipText(Messages.getString("DesignPropertiesDialog.Modify"));
            bnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = DesignPropertiesDialog.this.tbDefaultFC.getSelectedRow();
                    if (objectNumber != -1 && DesignPropertiesDialog.this.localDefaultFCList.size() > 0 && objectNumber < DesignPropertiesDialog.this.localDefaultFCList.size()) {
                        DefaultFontAndColor dfc = (DefaultFontAndColor)DesignPropertiesDialog.this.localDefaultFCList.get(objectNumber);
                        new TopViewColorDialog(dfc).setVisible(true);
                        DesignPropertiesDialog.this.tbDefaultFC.updateUI();
                        DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(bnEdit);
            buttonGeneral.add(toolBar);
            JPanel jpanel = new JPanel(new GridBagLayout());
            jpanel.add((Component)buttonGeneral, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            jpanel.add((Component)scrollpane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
            tabbed.add(Messages.getString("DesignPropertiesDialog.DefaultObjectFOC"), jpanel);
            this.localDefaultLWCList = new ArrayList();
            this.tbDefaultLWC = new JTable(new DefaultLWCModel());
            this.tbDefaultLWC.setSelectionMode(0);
            TableColumn tcColor = this.tbDefaultLWC.getColumnModel().getColumn(1);
            tcColor.setCellRenderer(new LineColorCellRenderer());
            tcColor.setCellEditor(new ColorEditor());
            TableColumn tcWidth = this.tbDefaultLWC.getColumnModel().getColumn(2);
            tcWidth.setCellRenderer(new LineWidthCellRenderer());
            tcWidth.setCellEditor(new LWCCellEditor());
            tcWidth.setMinWidth(130);
            tcWidth.setMaxWidth(130);
            JScrollPane scrollpane1 = new JScrollPane(this.tbDefaultLWC);
            JPanel jpanel1 = new JPanel(new GridBagLayout());
            jpanel1.add((Component)scrollpane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
            tabbed.add(Messages.getString("DesignPropertiesDialog.DefaultLWC"), jpanel1);
            this.pnFormat.add((Component)tabbed, "Center");
        }
        return this.pnFormat;
    }

    protected JPanel getCompareMappingsPanel() {
        if (this.pnCompareMappings == null) {
            this.pnCompareMappings = this.createPage(Messages.getString("DesignPropertiesDialog.CompareMappings"));
            JPanel cmPanel = new JPanel(new GridBagLayout());
            cmPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.CompareMappings")));
            JPanel compareMappingsPanel = new CompareMappingDialog(this.getApplicationView()).getGeneralPane();
            cmPanel.add((Component)compareMappingsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 1, -1));
            this.pnCompareMappings.add((Component)cmPanel, "Center");
        }
        return this.pnCompareMappings;
    }

    protected JPanel getNamingStandardPanel() {
        if (this.pnNamingStandard == null) {
            this.pnNamingStandard = this.createPage(Messages.getString("DesignPropertiesDialog.NamingStandard"));
            String separator = Messages.getString("DesignPropertiesDialog.Separator");
            String space = Messages.getString("DesignPropertiesDialog.Space");
            String titleCase = Messages.getString("DesignPropertiesDialog.TitleCase");
            final String character = Messages.getString("DesignPropertiesDialog.Character");
            JPanel jp = new JPanel(new GridBagLayout());
            JPanel logicalPanel = new JPanel(new GridBagLayout());
            logicalPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.LogicalModel")));
            JPanel logSeparatorPanel = new JPanel(new FlowLayout(0));
            JLabel logSeparatorLabel = new JLabel(separator);
            this.addItem(logSeparatorPanel, logSeparatorLabel, 0, 0, 1, 1, 17, 100, 100);
            this.logicalModelSeparatorMap.put("Space", space);
            this.logicalModelSeparatorMap.put("Title Case", titleCase);
            this.logicalModelSeparatorMap.put("Character", character);
            this.separatorBox = new JComboBox<Object>(this.logicalModelSeparatorMap.values().toArray());
            this.separatorBox.setEditable(false);
            this.separatorBox.setSelectedItem(space);
            this.addItem(logSeparatorPanel, this.separatorBox, 1, 0, 1, 1, 17, 100, 100);
            this.characterField = new JCharField();
            this.characterField.setText(" ");
            this.addItem(logSeparatorPanel, this.characterField, 2, 0, 1, 1, 17, 100, 100);
            this.separatorBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((String)DesignPropertiesDialog.this.separatorBox.getSelectedItem()).equals(character)) {
                        DesignPropertiesDialog.this.characterField.setEnabled(true);
                        DesignPropertiesDialog.this.characterField.setEditable(true);
                    } else {
                        DesignPropertiesDialog.this.characterField.setText(" ");
                        DesignPropertiesDialog.this.characterField.setEnabled(false);
                    }
                }
            });
            this.addItem(logicalPanel, logSeparatorPanel, 0, 0, 1, 1, 17, 100, 100);
            jp.add((Component)logicalPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 1, 1));
            JPanel relationalPanel = new JPanel(new GridBagLayout());
            relationalPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.RelationalModel")));
            JPanel relSeparatorPanel = new JPanel(new FlowLayout(0));
            JLabel relSeparatorLabel = new JLabel(separator);
            this.addItem(relSeparatorPanel, relSeparatorLabel, 0, 0, 1, 1, 17, 100, 100);
            this.separatorText = new JCharField();
            this.separatorText.setText("_");
            this.separatorText.setEditable(true);
            this.addItem(relSeparatorPanel, this.separatorText, 1, 0, 1, 1, 17, 100, 100);
            this.abbreviatedOnly = new JCheckBox(Messages.getString("DesignPropertiesDialog.AbbreviatedOnly"));
            this.addItem(relSeparatorPanel, this.abbreviatedOnly, 2, 0, 1, 1, 17, 100, 100);
            this.addItem(relationalPanel, relSeparatorPanel, 0, 0, 1, 1, 17, 100, 100);
            jp.add((Component)relationalPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 1, 1));
            JPanel domainPanel = new JPanel(new GridBagLayout());
            domainPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.Domain")));
            JPanel dmsSeparatorPanel = new JPanel(new FlowLayout(0));
            JLabel dmsSeparatorLabel = new JLabel(separator);
            this.addItem(dmsSeparatorPanel, dmsSeparatorLabel, 0, 0, 1, 1, 17, 100, 100);
            this.dmsSeparator = new JCharField();
            this.dmsSeparator.setText(" ");
            this.dmsSeparator.setEditable(true);
            this.addItem(dmsSeparatorPanel, this.dmsSeparator, 1, 0, 1, 1, 17, 100, 100);
            this.addItem(domainPanel, dmsSeparatorPanel, 0, 0, 1, 1, 17, 100, 100);
            jp.add((Component)domainPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 1, 1));
            JPanel pnGlossary = new JPanel(new GridBagLayout());
            pnGlossary.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.Glossary")));
            JPanel filePanel = new JPanel(new GridBagLayout());
            filePanel.setBackground(Color.WHITE);
            this.glossaryTable = new JTable(new GlossaryTableModel());
            this.glossaryTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ((GlossaryFile)DesignPropertiesDialog.this.glossariesList.get(DesignPropertiesDialog.this.glossaryTable.getSelectedRow())).getFilePath();
                        Glossary glossary = new Glossary(new File(((GlossaryFile)DesignPropertiesDialog.this.glossariesList.get(DesignPropertiesDialog.this.glossaryTable.getSelectedRow())).getFilePath()));
                        GlossaryDialog dialog = new GlossaryDialog(DesignPropertiesDialog.this.getApplicationView(), glossary);
                        dialog.showDialog();
                    }
                }
            });
            JTableHeader header = this.glossaryTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton addButton = new JButton(configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        File file;
                        URLFilter fileFilter = new URLFilter(){

                            public boolean accept(URL url) {
                                File file = new File(url.getPath());
                                return file.getName().toLowerCase().endsWith(".glossary") || file.isDirectory();
                            }

                            public String toString() {
                                return Messages.getString("DesignPropertiesDialog.GlossaryFile");
                            }
                        };
                        URLChooser fileChooser = DialogUtil.newURLChooser();
                        fileChooser.clearChooseableURLFilters();
                        fileChooser.setSelectionScope(0);
                        fileChooser.setSelectionMode(0);
                        fileChooser.setShowJarsAsDirs(false);
                        fileChooser.setURLFilter(fileFilter);
                        if (DesignPropertiesDialog.this.lastFolder != null) {
                            fileChooser.setSelectedURL(URLFactory.newDirURL((File)DesignPropertiesDialog.this.lastFolder));
                        } else {
                            String lastDir = DesignPropertiesDialog.this.getApplicationView().getSettings().getDefaultImportPath();
                            if (lastDir != null && lastDir.length() > 0) {
                                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                            } else {
                                URL url = DesignPropertiesDialog.this.getApplicationView().getUserHomeDirectory();
                                if (url != null) {
                                    fileChooser.setSelectedURL(url);
                                }
                            }
                        }
                        int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DesignPropertiesDialog.SelectGlossaryFile"));
                        if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                            DesignPropertiesDialog.this.lastFolder = file.getParentFile();
                            Glossary selected = new Glossary(file);
                            DesignPropertiesDialog.this.glossariesList.add(new GlossaryFile(selected.getName(), selected.getDescription(), file.getAbsolutePath()));
                            DesignPropertiesDialog.this.glossaryTable.updateUI();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            toolBar.add(addButton);
            JButton removeButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            removeButton.setToolTipText(BTN_REMOVE);
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int objectNumber = DesignPropertiesDialog.this.glossaryTable.getSelectedRow();
                    if (objectNumber != -1 && DesignPropertiesDialog.this.glossariesList.size() > 0 && objectNumber < DesignPropertiesDialog.this.glossariesList.size()) {
                        GlossaryFile file = (GlossaryFile)DesignPropertiesDialog.this.glossariesList.get(objectNumber);
                        DesignPropertiesDialog.this.glossariesList.remove(file);
                        DesignPropertiesDialog.this.glossaryTable.updateUI();
                    }
                }
            });
            toolBar.add(removeButton);
            JScrollPane sp = new JScrollPane(this.glossaryTable);
            pnGlossary.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            pnGlossary.add((Component)sp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 2, 2, 2), 1, 1));
            jp.add((Component)pnGlossary, new GridBagConstraints(0, 3, 0, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 1, 1));
            this.getApplicationView();
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = logSeparatorPanel.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                logicalPanel.validate();
                Component[] comp1 = relSeparatorPanel.getComponents();
                for (int x = 0; x < comp1.length; ++x) {
                    Component c = comp1[x];
                    c.setEnabled(false);
                }
                relationalPanel.validate();
                Component[] comp2 = dmsSeparatorPanel.getComponents();
                for (int x = 0; x < comp2.length; ++x) {
                    Component c = comp2[x];
                    c.setEnabled(false);
                }
                domainPanel.validate();
                Component[] comp3 = toolBar.getComponents();
                for (int x = 0; x < comp3.length; ++x) {
                    Component c = comp3[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.glossaryTable.setEnabled(false);
            }
            this.pnNamingStandard.add((Component)jp, "Center");
        }
        return this.pnNamingStandard;
    }

    protected JPanel getNamingStandardAttributePanel() {
        if (this.pnNamingStandardAttribute == null) {
            this.pnNamingStandardAttribute = this.createPage(Messages.getString("DesignPropertiesDialog.Attribute"));
            this.nsAttributesList = new ArrayList();
            JPanel jpAttributes = new JPanel(new GridBagLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton addButton = new JButton(configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            JButton removeButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            removeButton.setToolTipText(BTN_REMOVE);
            JButton moveUpButton = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            moveUpButton.setToolTipText(BTN_UP);
            JButton moveDownButton = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            moveDownButton.setToolTipText(BTN_DOWN);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.addToNSTable(DesignPropertiesDialog.this.nsAttributesTable, DesignPropertiesDialog.this.nsAttributesList);
                }
            });
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.removeFromNSTable(DesignPropertiesDialog.this.nsAttributesTable, DesignPropertiesDialog.this.nsAttributesList);
                }
            });
            moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementUp(DesignPropertiesDialog.this.nsAttributesTable, DesignPropertiesDialog.this.nsAttributesList);
                }
            });
            moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementDown(DesignPropertiesDialog.this.nsAttributesTable, DesignPropertiesDialog.this.nsAttributesList);
                }
            });
            toolBar.add(addButton);
            toolBar.add(removeButton);
            toolBar.addSeparator();
            toolBar.add(moveUpButton);
            toolBar.add(moveDownButton);
            this.nsAttributesTable = new JTable(new AttributeTableModel());
            JTableHeader header = this.nsAttributesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsAttributesTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(namePartMap.values().toArray())));
            TableColumn entOptionalColumn = this.nsAttributesTable.getColumnModel().getColumn(1);
            entOptionalColumn.setCellEditor(this.optionalEditor);
            this.nsAttributesTable.setSelectionMode(0);
            jpAttributes.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jpAttributes.add((Component)new JScrollPane(this.nsAttributesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsAttributesTable.setEnabled(false);
            }
            this.pnNamingStandardAttribute.add((Component)jpAttributes, "Center");
        }
        return this.pnNamingStandardAttribute;
    }

    protected JPanel getNamingStandardColumnPanel() {
        if (this.pnNamingStandardColumn == null) {
            this.pnNamingStandardColumn = this.createPage(Messages.getString("DesignPropertiesDialog.Column"));
            JPanel jpColumns = new JPanel(new GridBagLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton addButton = new JButton(configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            JButton removeButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            removeButton.setToolTipText(BTN_REMOVE);
            JButton moveUpButton = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            moveUpButton.setToolTipText(BTN_UP);
            JButton moveDownButton = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            moveDownButton.setToolTipText(BTN_DOWN);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.addToNSTable(DesignPropertiesDialog.this.nsColumnsTable, DesignPropertiesDialog.this.nsColumnsList);
                }
            });
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.removeFromNSTable(DesignPropertiesDialog.this.nsColumnsTable, DesignPropertiesDialog.this.nsColumnsList);
                }
            });
            moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementUp(DesignPropertiesDialog.this.nsColumnsTable, DesignPropertiesDialog.this.nsColumnsList);
                }
            });
            moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementDown(DesignPropertiesDialog.this.nsColumnsTable, DesignPropertiesDialog.this.nsColumnsList);
                }
            });
            toolBar.add(addButton);
            toolBar.add(removeButton);
            toolBar.addSeparator();
            toolBar.add(moveUpButton);
            toolBar.add(moveDownButton);
            this.nsColumnsList = new ArrayList();
            this.nsColumnsTable = new JTable(new ColumnTableModel());
            JTableHeader header = this.nsColumnsTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsColumnsTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(namePartMap.values().toArray())));
            TableColumn entOptionalColumn = this.nsColumnsTable.getColumnModel().getColumn(1);
            entOptionalColumn.setCellEditor(this.optionalEditor);
            this.nsColumnsTable.setSelectionMode(0);
            jpColumns.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jpColumns.add((Component)new JScrollPane(this.nsColumnsTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsColumnsTable.setEnabled(false);
            }
            this.pnNamingStandardColumn.add((Component)jpColumns, "Center");
        }
        return this.pnNamingStandardColumn;
    }

    protected JPanel getNamingStandardDomainPanel() {
        if (this.pnNamingStandardDomain == null) {
            this.pnNamingStandardDomain = this.createPage(Messages.getString("DesignPropertiesDialog.Domain"));
            JPanel jpDomains = new JPanel(new GridBagLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton addButton = new JButton(configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            JButton removeButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            removeButton.setToolTipText(BTN_REMOVE);
            JButton moveUpButton = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            moveUpButton.setToolTipText(BTN_UP);
            JButton moveDownButton = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            moveDownButton.setToolTipText(BTN_DOWN);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.addToNSTable(DesignPropertiesDialog.this.nsDomainsTable, DesignPropertiesDialog.this.nsDomainsList);
                }
            });
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.removeFromNSTable(DesignPropertiesDialog.this.nsDomainsTable, DesignPropertiesDialog.this.nsDomainsList);
                }
            });
            moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementUp(DesignPropertiesDialog.this.nsDomainsTable, DesignPropertiesDialog.this.nsDomainsList);
                }
            });
            moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementDown(DesignPropertiesDialog.this.nsDomainsTable, DesignPropertiesDialog.this.nsDomainsList);
                }
            });
            toolBar.add(addButton);
            toolBar.add(removeButton);
            toolBar.addSeparator();
            toolBar.add(moveUpButton);
            toolBar.add(moveDownButton);
            this.nsDomainsList = new ArrayList();
            this.nsDomainsTable = new JTable(new DomainTableModel());
            JTableHeader header = this.nsDomainsTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsDomainsTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(namePartMap.values().toArray())));
            TableColumn entOptionalColumn = this.nsDomainsTable.getColumnModel().getColumn(1);
            entOptionalColumn.setCellEditor(this.optionalEditor);
            this.nsDomainsTable.setSelectionMode(0);
            jpDomains.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jpDomains.add((Component)new JScrollPane(this.nsDomainsTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
            this.getApplicationView();
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsDomainsTable.setEnabled(false);
            }
            this.pnNamingStandardDomain.add((Component)jpDomains, "Center");
        }
        return this.pnNamingStandardDomain;
    }

    protected JPanel getNamingStandardEntityPanel() {
        if (this.pnNamingStandardEntity == null) {
            this.pnNamingStandardEntity = this.createPage(Messages.getString("DesignPropertiesDialog.Entity"));
            JPanel jpEntities = new JPanel(new GridBagLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton addButton = new JButton(configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            JButton removeButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            removeButton.setToolTipText(BTN_REMOVE);
            JButton moveUpButton = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            moveUpButton.setToolTipText(BTN_UP);
            JButton moveDownButton = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            moveDownButton.setToolTipText(BTN_DOWN);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.addToNSTable(DesignPropertiesDialog.this.nsEntitiesTable, DesignPropertiesDialog.this.nsEntitiesList);
                }
            });
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.removeFromNSTable(DesignPropertiesDialog.this.nsEntitiesTable, DesignPropertiesDialog.this.nsEntitiesList);
                }
            });
            moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementUp(DesignPropertiesDialog.this.nsEntitiesTable, DesignPropertiesDialog.this.nsEntitiesList);
                }
            });
            moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementDown(DesignPropertiesDialog.this.nsEntitiesTable, DesignPropertiesDialog.this.nsEntitiesList);
                }
            });
            toolBar.add(addButton);
            toolBar.add(removeButton);
            toolBar.addSeparator();
            toolBar.add(moveUpButton);
            toolBar.add(moveDownButton);
            this.nsEntitiesList = new ArrayList();
            this.nsEntitiesTable = new JTable(new EntityTableModel());
            JTableHeader header = this.nsEntitiesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsEntitiesTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(namePartMap.values().toArray())));
            TableColumn entOptionalColumn = this.nsEntitiesTable.getColumnModel().getColumn(1);
            entOptionalColumn.setCellEditor(this.optionalEditor);
            this.nsEntitiesTable.setSelectionMode(0);
            jpEntities.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jpEntities.add((Component)new JScrollPane(this.nsEntitiesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
            this.getApplicationView();
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsEntitiesTable.setEnabled(false);
            }
            this.pnNamingStandardEntity.add((Component)jpEntities, "Center");
        }
        return this.pnNamingStandardEntity;
    }

    protected JPanel getNamingStandardTablePanel() {
        if (this.pnNamingStandardTable == null) {
            this.pnNamingStandardTable = this.createPage(Messages.getString("DesignPropertiesDialog.Table"));
            JPanel jpTables = new JPanel(new GridBagLayout());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton addButton = new JButton(configuration.getIcon("ADD_ICON", 16));
            addButton.setToolTipText(BTN_ADD);
            JButton removeButton = new JButton(configuration.getIcon("REMOVE_ICON", 16));
            removeButton.setToolTipText(BTN_REMOVE);
            JButton moveUpButton = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            moveUpButton.setToolTipText(BTN_UP);
            JButton moveDownButton = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            moveDownButton.setToolTipText(BTN_DOWN);
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.addToNSTable(DesignPropertiesDialog.this.nsTablesTable, DesignPropertiesDialog.this.nsTablesList);
                }
            });
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.removeFromNSTable(DesignPropertiesDialog.this.nsTablesTable, DesignPropertiesDialog.this.nsTablesList);
                }
            });
            moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementUp(DesignPropertiesDialog.this.nsTablesTable, DesignPropertiesDialog.this.nsTablesList);
                }
            });
            moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.moveNSElementDown(DesignPropertiesDialog.this.nsTablesTable, DesignPropertiesDialog.this.nsTablesList);
                }
            });
            toolBar.add(addButton);
            toolBar.add(removeButton);
            toolBar.addSeparator();
            toolBar.add(moveUpButton);
            toolBar.add(moveDownButton);
            this.nsTablesList = new ArrayList();
            this.nsTablesTable = new JTable(new TableElementModel());
            JTableHeader header = this.nsTablesTable.getTableHeader();
            header.setReorderingAllowed(false);
            header.setResizingAllowed(false);
            TableColumn entTypeColumn = this.nsTablesTable.getColumnModel().getColumn(0);
            entTypeColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(namePartMap.values().toArray())));
            TableColumn entOptionalColumn = this.nsTablesTable.getColumnModel().getColumn(1);
            entOptionalColumn.setCellEditor(this.optionalEditor);
            this.nsTablesTable.setSelectionMode(0);
            jpTables.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            jpTables.add((Component)new JScrollPane(this.nsTablesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 1));
            this.getApplicationView();
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = toolBar.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                toolBar.validate();
                this.nsTablesTable.setEnabled(false);
            }
            this.pnNamingStandardTable.add((Component)jpTables, "Center");
        }
        return this.pnNamingStandardTable;
    }

    protected JPanel getNamingStandardTemplatesPanel() {
        if (this.pnNamingStandardTemplates == null) {
            this.pnNamingStandardTemplates = this.createPage(Messages.getString("DesignPropertiesDialog.Templates"));
            JPanel jpTemplates = new JPanel(new GridBagLayout());
            JPanel constraintsPanel = new JPanel(new GridBagLayout());
            constraintsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.TableConstraints")));
            JLabel constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.PrimaryKey"));
            this.addItem(constraintsPanel, constrLabel, 0, 0, 1, 1, 17, 0, 100);
            this.tfPrimaryKey = new JTextField();
            this.tfPrimaryKey.setText(this.pkConsr);
            this.addItem(constraintsPanel, this.tfPrimaryKey, 1, 0, 1, 1, 17, 100, 100);
            JButton addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 0, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] namePK = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignPropertiesDialog.ColumnAbbreviation")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(namePK, DesignPropertiesDialog.this.tfPrimaryKey);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.FK"));
            this.addItem(constraintsPanel, constrLabel, 0, 1, 1, 1, 17, 0, 100);
            this.tfForeignKey = new JTextField();
            this.tfForeignKey.setText(this.fkConsr);
            this.addItem(constraintsPanel, this.tfForeignKey, 1, 1, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 1, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameFK = new String[][]{{"{parent}", Messages.getString("DesignPropertiesDialog.ParentTableName")}, {"{parent abbr}", Messages.getString("DesignPropertiesDialog.ParentTableAbbreviation")}, {"{child}", Messages.getString("DesignPropertiesDialog.ChildTableName")}, {"{child abbr}", Messages.getString("DesignPropertiesDialog.ChildTableAbbreviation")}, {"{seq nr}", Messages.getString("DesignPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}, {"{relationship}", Messages.getString("DesignPropertiesDialog.RelationshipName")}, {"{ref column}", Messages.getString("DesignPropertiesDialog.RefColName")}, {"{ref column abbr}", Messages.getString("DesignPropertiesDialog.RefColAbbreviation")}};
                    DesignPropertiesDialog.this.createDialog(nameFK, DesignPropertiesDialog.this.tfForeignKey);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.CheckConstraint"));
            this.addItem(constraintsPanel, constrLabel, 0, 2, 1, 1, 17, 0, 100);
            this.tfCheckConstr = new JTextField();
            this.tfCheckConstr.setText(this.ckConsr);
            this.addItem(constraintsPanel, this.tfCheckConstr, 1, 2, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 2, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCK = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{seq nr}", Messages.getString("DesignPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(nameCK, DesignPropertiesDialog.this.tfCheckConstr);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.UK"));
            this.addItem(constraintsPanel, constrLabel, 0, 3, 1, 1, 17, 0, 100);
            this.tfUniqueConstr = new JTextField();
            this.tfUniqueConstr.setText(this.unConstr);
            this.addItem(constraintsPanel, this.tfUniqueConstr, 1, 3, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 3, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameUC = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignPropertiesDialog.ColumnAbbreviation")}, {"{seq nr}", Messages.getString("DesignPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(nameUC, DesignPropertiesDialog.this.tfUniqueConstr);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.Index"));
            this.addItem(constraintsPanel, constrLabel, 0, 4, 1, 1, 17, 0, 100);
            this.tfIndex = new JTextField();
            this.addItem(constraintsPanel, this.tfIndex, 1, 4, 1, 1, 17, 100, 100);
            this.tfIndex.setText(this.idxConstr);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 4, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] index = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignPropertiesDialog.ColumnAbbreviation")}, {"{seq nr}", Messages.getString("DesignPropertiesDialog.SeqNumber")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(index, DesignPropertiesDialog.this.tfIndex);
                }
            });
            JLabel automaticIndexLabel = new JLabel(this.automaticIndexText);
            this.addItem(constraintsPanel, automaticIndexLabel, 0, 5, 1, 1, 17, 0, 100);
            this.tfAutomaticIndex = new JTextField();
            this.addItem(constraintsPanel, this.tfAutomaticIndex, 1, 5, 1, 1, 17, 100, 100);
            this.tfAutomaticIndex.setText(this.idxConstr);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 5, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] automaticIndex = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignPropertiesDialog.ColumnAbbreviation")}, {"{constraint}", Messages.getString("DesignPropertiesDialog.Constraint")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(automaticIndex, DesignPropertiesDialog.this.tfAutomaticIndex);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.ColumnCheckConstraint"));
            this.addItem(constraintsPanel, constrLabel, 0, 6, 1, 1, 17, 0, 100);
            this.tfColCheckConstr = new JTextField();
            this.addItem(constraintsPanel, this.tfColCheckConstr, 1, 6, 1, 1, 17, 100, 100);
            this.tfColCheckConstr.setText(this.colckConstr);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 6, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCC = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignPropertiesDialog.ColumnAbbreviation")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(nameCC, DesignPropertiesDialog.this.tfColCheckConstr);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.ColumnNotNullConstraint"));
            this.addItem(constraintsPanel, constrLabel, 0, 7, 1, 1, 17, 0, 100);
            this.tfColNNConstr = new JTextField();
            this.addItem(constraintsPanel, this.tfColNNConstr, 1, 7, 1, 1, 17, 100, 100);
            this.tfColNNConstr.setText(this.colNNConstr);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 7, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCC = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}, {"{column}", Messages.getString("DesignPropertiesDialog.ColumnName")}, {"{column abbr}", Messages.getString("DesignPropertiesDialog.ColumnAbbreviation")}, {"{model}", Messages.getString("DesignPropertiesDialog.ModelName")}};
                    DesignPropertiesDialog.this.createDialog(nameCC, DesignPropertiesDialog.this.tfColNNConstr);
                }
            });
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.ColumnFK"));
            this.addItem(constraintsPanel, constrLabel, 0, 8, 1, 1, 17, 0, 1);
            this.tfColumnForeignKey = new JTextField();
            this.tfColumnForeignKey.setText(this.colForeignKey);
            this.addItem(constraintsPanel, this.tfColumnForeignKey, 1, 8, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 8, 1, 1, 17, 0, 1);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameCC = new String[][]{{"{ref table}", Messages.getString("DesignPropertiesDialog.ReftableName")}, {"{ref table abbr}", Messages.getString("DesignPropertiesDialog.ReftableAbbreviation")}, {"{relationship}", Messages.getString("DesignPropertiesDialog.RelMappedToFK")}, {"{foreign key}", Messages.getString("DesignPropertiesDialog.FKName")}, {"{ref column}", Messages.getString("DesignPropertiesDialog.RefColumnName")}, {"{ref column abbr}", Messages.getString("DesignPropertiesDialog.RefColumnAbbreviation")}};
                    DesignPropertiesDialog.this.createDialog(nameCC, DesignPropertiesDialog.this.tfColumnForeignKey);
                }
            });
            constrLabel = new JLabel(this.sKeyConstrText);
            this.addItem(constraintsPanel, constrLabel, 0, 9, 1, 1, 17, 0, 100);
            this.tfSurrogateKey = new JTextField();
            this.tfSurrogateKey.setText(this.surrogateKey);
            this.addItem(constraintsPanel, this.tfSurrogateKey, 1, 9, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 9, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameSK = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}};
                    DesignPropertiesDialog.this.createDialog(nameSK, DesignPropertiesDialog.this.tfSurrogateKey);
                }
            });
            constrLabel = new JLabel(this.sKeyColConstrText);
            this.addItem(constraintsPanel, constrLabel, 0, 10, 1, 1, 17, 0, 100);
            this.tfSurrogateKeyColumn = new JTextField();
            this.tfSurrogateKeyColumn.setText(this.surrogateKeyCol);
            this.addItem(constraintsPanel, this.tfSurrogateKeyColumn, 1, 10, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 10, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameSKC = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}};
                    DesignPropertiesDialog.this.createDialog(nameSKC, DesignPropertiesDialog.this.tfSurrogateKeyColumn);
                }
            });
            constrLabel = new JLabel(this.dColumnConstrText);
            this.addItem(constraintsPanel, constrLabel, 0, 11, 1, 1, 17, 0, 100);
            this.tfDiscriminatorColumn = new JTextField();
            this.tfDiscriminatorColumn.setText(this.discriminatorCol);
            this.addItem(constraintsPanel, this.tfDiscriminatorColumn, 1, 11, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(constraintsPanel, addVariables, 2, 11, 1, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] nameDC = new String[][]{{"{table}", Messages.getString("DesignPropertiesDialog.TableName")}, {"{table abbr}", Messages.getString("DesignPropertiesDialog.TableAbbreviation")}};
                    DesignPropertiesDialog.this.createDialog(nameDC, DesignPropertiesDialog.this.tfDiscriminatorColumn);
                }
            });
            JPanel pnEntity = new JPanel(new GridBagLayout());
            pnEntity.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.EntityIdentifier")));
            JLabel identifierLabel = new JLabel(Messages.getString("DesignPropertiesDialog.PrimaryIdentifier"));
            this.addItem(pnEntity, identifierLabel, 0, 0, 1, 1, 17, 0, 100);
            this.tfPrimaryIdentifier = new JTextField();
            this.tfPrimaryIdentifier.setText(this.uiConsr);
            this.addItem(pnEntity, this.tfPrimaryIdentifier, 1, 0, 1, 1, 17, 100, 100);
            addVariables = new JButton(btnName);
            this.addItem(pnEntity, addVariables, 2, 0, 0, 1, 17, 0, 100);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] namePK = new String[][]{{"{entity}", Messages.getString("DesignPropertiesDialog.EntityName")}};
                    DesignPropertiesDialog.this.createDialog(namePK, DesignPropertiesDialog.this.tfPrimaryIdentifier);
                }
            });
            JLabel relationLabel = new JLabel(Messages.getString("DesignPropertiesDialog.AttributeRelation"));
            this.addItem(pnEntity, relationLabel, 0, 1, 1, 1, 17, 0, 1);
            this.tfAttributeRelation = new JTextField();
            this.tfAttributeRelation.setText(this.attrRelation);
            this.addItem(pnEntity, this.tfAttributeRelation, 1, 1, 1, 1, 17, 1, 1);
            addVariables = new JButton(btnName);
            this.addItem(pnEntity, addVariables, 2, 1, 0, 1, 17, 0, 1);
            addVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[][] values = new String[][]{{"{ref entity}", Messages.getString("DesignPropertiesDialog.RefEntityName")}, {"{ref entity short name}", Messages.getString("DesignPropertiesDialog.RefEntityShortName")}, {"{ref entity pref abbr}", Messages.getString("DesignPropertiesDialog.RefEntityPrefAbbreviation")}, {"{relationship}", Messages.getString("DesignPropertiesDialog.RelName")}, {"{ref attribute}", Messages.getString("DesignPropertiesDialog.RefAttributeName")}, {"{ref attribute pref abbr}", Messages.getString("DesignPropertiesDialog.RefAttributePrefAbbreviation")}};
                    DesignPropertiesDialog.this.createDialog(values, DesignPropertiesDialog.this.tfAttributeRelation);
                }
            });
            jpTemplates.add((Component)constraintsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 1));
            jpTemplates.add((Component)pnEntity, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 1));
            JPanel pnSample = new JPanel(new GridBagLayout());
            pnSample.setBorder(BorderFactory.createTitledBorder(Messages.getString("DesignPropertiesDialog.Example")));
            constrLabel = new JLabel(Messages.getString("DesignPropertiesDialog.Example"));
            this.addItem(pnSample, constrLabel, 0, 0, 1, 1, 17, 0, 1);
            final JTextField exampleTextField = new JTextField();
            this.addItem(pnSample, exampleTextField, 1, 0, 1, 1, 17, 1, 1);
            exampleTextField.setEditable(false);
            final JLNComboBox exampleBox = new JLNComboBox(this.comboItems);
            this.addItem(pnSample, exampleBox, 2, 0, 0, 1, 17, 0, 1);
            exampleBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s;
                    String oldString;
                    String choice = (String)exampleBox.getSelectedItem();
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.pkConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfPrimaryKey.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.fkConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfForeignKey.getText();
                        s = oldString.replaceAll("\\{parent\\}", "parentTable");
                        s = s.replaceAll("\\{child\\}", "childTable");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.chkConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfCheckConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.ukConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfUniqueConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.idxConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfIndex.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        s = s.replaceAll("\\{model\\}", "myModel");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.automaticIndexText)) {
                        oldString = DesignPropertiesDialog.this.tfAutomaticIndex.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        s = s.replaceAll("\\{seq nr\\}", "1");
                        s = s.replaceAll("\\{constraint\\}", "myConstraint");
                        s = s.replaceAll("\\{model\\}", "myModel");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.colChkConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfColCheckConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.colNNConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfColNNConstr.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        s = s.replaceAll("\\{column\\}", "myColumn");
                        s = s.replaceAll("\\{column abbr\\}", "myColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.colFKText)) {
                        oldString = DesignPropertiesDialog.this.tfColumnForeignKey.getText();
                        s = oldString.replaceAll("\\{ref table\\}", "referencedTable");
                        s = s.replaceAll("\\{ref table abbr\\}", "referencedTableAbbreviation");
                        s = s.replaceAll("\\{ref column\\}", "referencedColumn");
                        s = s.replaceAll("\\{ref column abbr\\}", "referencedColumnAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.prIDConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfPrimaryIdentifier.getText();
                        s = oldString.replaceAll("\\{entity\\}", "myEntity");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase(DesignPropertiesDialog.this.attrRelConstrText)) {
                        oldString = DesignPropertiesDialog.this.tfAttributeRelation.getText();
                        s = oldString.replaceAll("\\{ref entity\\}", "referencedEntity");
                        s = s.replaceAll("\\{ref entity short name\\}", "referencedEntityShortName");
                        s = s.replaceAll("\\{ref entity pref abr\\}", "referencedEntityPreferredAbbreviation");
                        s = s.replaceAll("\\{ref attribute\\}", "referencedAttribute");
                        s = s.replaceAll("\\{ref attribute pref abbr\\}", "referencedAttributePreferredAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase("Surrogate Key")) {
                        oldString = DesignPropertiesDialog.this.tfSurrogateKey.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase("Surrogate Key Column")) {
                        oldString = DesignPropertiesDialog.this.tfSurrogateKeyColumn.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        exampleTextField.setText(s);
                    }
                    if (choice.equalsIgnoreCase("Discriminator Column")) {
                        oldString = DesignPropertiesDialog.this.tfDiscriminatorColumn.getText();
                        s = oldString.replaceAll("\\{table\\}", "myTable");
                        s = s.replaceAll("\\{table abbr\\}", "myTableAbbreviation");
                        exampleTextField.setText(s);
                    }
                }
            });
            jpTemplates.add((Component)pnSample, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 1));
            if (ApplicationView.IS_VIEWER) {
                Component[] comp = constraintsPanel.getComponents();
                for (int x = 0; x < comp.length; ++x) {
                    Component c = comp[x];
                    c.setEnabled(false);
                }
                constraintsPanel.validate();
                Component[] comp1 = pnEntity.getComponents();
                for (int x = 0; x < comp1.length; ++x) {
                    Component c = comp1[x];
                    c.setEnabled(false);
                }
                pnEntity.validate();
                Component[] comp2 = pnSample.getComponents();
                for (int x = 0; x < comp2.length; ++x) {
                    Component c = comp2[x];
                    c.setEnabled(false);
                }
                pnSample.validate();
            }
            jpTemplates.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 1, 1));
            this.pnNamingStandardTemplates.add((Component)jpTemplates, "Center");
        }
        return this.pnNamingStandardTemplates;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            if (this.isEditable()) {
                JButton ok = new JButton(Messages.getString("DesignPropertiesDialog.OK"));
                ok.setMnemonic(79);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            DesignPropertiesDialog.this.setProperties();
                            DesignPropertiesDialog.this.close();
                            DesignPropertiesDialog.this.design.setDirty(true);
                            DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                        }
                        catch (EmptyFieldException exp) {
                            JOptionPane.showMessageDialog(DesignPropertiesDialog.this, exp.getMessage(), Messages.getString("DesignPropertiesDialog.Error"), 0);
                        }
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
                JButton apply = new JButton(Messages.getString("DesignPropertiesDialog.Apply"));
                apply.setMnemonic(65);
                apply.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            DesignPropertiesDialog.this.setProperties();
                            DesignPropertiesDialog.this.design.setDirty(true);
                            DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
                        }
                        catch (EmptyFieldException exp) {
                            JOptionPane.showMessageDialog(DesignPropertiesDialog.this, exp.getMessage(), Messages.getString("DesignPropertiesDialog.Error"), 0);
                        }
                    }
                });
                apply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(apply);
            }
            JButton cancel = new JButton(this.isEditable() ? Messages.getString("DesignPropertiesDialog.Cancel") : Messages.getString("DesignPropertiesDialog.Close"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignPropertiesDialog.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            this.buttonPanel.add(cancel);
            this.buttonPanel.add(btnHelp);
        }
        return this.buttonPanel;
    }

    public void initProperties() {
        try {
            this.tfName.setText(this.design.getName());
            this.taComments.setText(this.design.getComment());
            this.taNotes.setText(this.design.getNotes());
            this.tfObjectID.setText(this.design.getDesignID());
            this.tfCreationTime.setText(this.design.getCreationTime());
            this.tfCreator.setText(this.design.getCreator().getName());
            this.tfLastChangedBy.setText(this.design.getChanger().getName());
            this.tfLastChangedTime.setText(this.design.getChangeTime());
            this.localClassificationTypeList.clear();
            for (ClassificationType classificationType : this.classificationTypeList) {
                this.localClassificationTypeList.add(classificationType.copy());
            }
            this.classificationTypeTable.updateUI();
            this.localDefaultFCList.clear();
            for (DefaultFontAndColor dfc : this.defaultFCList) {
                this.localDefaultFCList.add(dfc.copy());
            }
            this.tbDefaultFC.updateUI();
            this.localDefaultLWCList.clear();
            for (DefaultLineWidthAndColor dlwc : this.defaultLWCList) {
                this.localDefaultLWCList.add(dlwc.copy());
            }
            this.tbDefaultLWC.updateUI();
            if (this.designLevelSettings.isLogicalTypeForDomainPresentation()) {
                this.cbDomainPresentation.setSelectedItem(USE_LOGICAL_TYPE);
            } else {
                this.cbDomainPresentation.setSelectedItem(USE_DOMAN_NAME);
            }
            this.chAutomaticPKGeneration.setSelected(this.designLevelSettings.isAutomaticPKGeneration());
            this.chAutomaticUKGeneration.setSelected(this.designLevelSettings.isAutomaticUKGeneration());
            this.chAutomaticFKGeneration.setSelected(this.designLevelSettings.isAutomaticFKGeneration());
            this.cbPreserveDDLGenerationOptions.setSelected(this.designLevelSettings.isPreserveDDLGenerationOptions());
            if (this.tbSubstituiton.getCellEditor() != null) {
                this.tbSubstituiton.getCellEditor().stopCellEditing();
            }
            this.localSubstitutionList.clear();
            for (SubstitutionPattern substPattern : this.substitutionList) {
                this.localSubstitutionList.add(substPattern.copy());
            }
            this.tbSubstituiton.updateUI();
            String lSeparator = (String)this.logicalModelSeparatorMap.get(this.designLevelSettings.getNamingStandardRule().getLogicalSep());
            this.separatorBox.setSelectedItem(lSeparator);
            this.characterField.setText(this.designLevelSettings.getNamingStandardRule().getLogicalChar());
            this.separatorText.setText(this.designLevelSettings.getNamingStandardRule().getRelSep());
            this.abbreviatedOnly.setSelected(this.designLevelSettings.getNamingStandardRule().isAbbreviatedOnly());
            this.dmsSeparator.setText(this.designLevelSettings.getNamingStandardRule().getDomainsSep());
            this.glossariesList.clear();
            for (GlossaryFile file : this.designLevelSettings.getNamingStandardRule().getGlossariesList()) {
                Glossary glossary = new Glossary(new File(file.getFilePath()));
                this.glossariesList.add(new GlossaryFile(glossary.getName(), glossary.getDescription(), glossary.getFileName()));
            }
            this.glossaryTable.updateUI();
            this.nsAttributesList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getAttributesList()) {
                this.nsAttributesList.add(wr.copy());
            }
            this.nsAttributesTable.updateUI();
            this.nsColumnsList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getColumnsList()) {
                this.nsColumnsList.add(wr.copy());
            }
            this.nsColumnsTable.updateUI();
            this.nsDomainsList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getDomainsList()) {
                this.nsDomainsList.add(wr.copy());
            }
            this.nsDomainsTable.updateUI();
            this.nsEntitiesList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getEntitiesList()) {
                this.nsEntitiesList.add(wr.copy());
            }
            this.nsEntitiesTable.updateUI();
            this.nsTablesList.clear();
            for (WordRule wr : this.designLevelSettings.getNamingStandardRule().getTablesList()) {
                this.nsTablesList.add(wr.copy());
            }
            this.nsTablesTable.updateUI();
            String value = this.designLevelSettings.getNamingStandardRule().getPkConstr();
            if (value == null || "null".equals(value)) {
                this.tfPrimaryKey.setText(this.pkConsr);
            } else {
                this.tfPrimaryKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getFkConstr();
            if (value == null || "null".equals(value)) {
                this.tfForeignKey.setText(this.fkConsr);
            } else {
                this.tfForeignKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getCkConstr();
            if (value == null || "null".equals(value)) {
                this.tfCheckConstr.setText(this.ckConsr);
            } else {
                this.tfCheckConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getUnConstr();
            if (value == null || "null".equals(value)) {
                this.tfUniqueConstr.setText(this.unConstr);
            } else {
                this.tfUniqueConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getIdxConstr();
            if (value == null || "null".equals(value)) {
                this.tfIndex.setText(this.idxConstr);
            } else {
                this.tfIndex.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getAutomaticIdxConstr();
            if (value == null || "null".equals(value)) {
                this.tfAutomaticIndex.setText(this.automaticIdxConstr);
            } else {
                this.tfAutomaticIndex.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getColckConstr();
            if (value == null || "null".equals(value)) {
                this.tfColCheckConstr.setText(this.colckConstr);
            } else {
                this.tfColCheckConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getColNNConstr();
            if (value == null || "null".equals(value)) {
                this.tfColNNConstr.setText(this.colNNConstr);
            } else {
                this.tfColNNConstr.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getUIConstr();
            if (value == null || "null".equals(value)) {
                this.tfPrimaryIdentifier.setText(this.uiConsr);
            } else {
                this.tfPrimaryIdentifier.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getRelationAttribute();
            if (value == null || "null".equals(value)) {
                this.tfAttributeRelation.setText(this.attrRelation);
            } else {
                this.tfAttributeRelation.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getFkColumn();
            if (value == null || "null".equals(value)) {
                this.tfColumnForeignKey.setText(this.colForeignKey);
            } else {
                this.tfColumnForeignKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getSurrogateKey();
            if (value == null || "null".equals(value)) {
                this.tfSurrogateKey.setText(this.surrogateKey);
            } else {
                this.tfSurrogateKey.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getSurrogateKeyColumn();
            if (value == null || "null".equals(value)) {
                this.tfSurrogateKeyColumn.setText(this.surrogateKeyCol);
            } else {
                this.tfSurrogateKeyColumn.setText(value);
            }
            value = this.designLevelSettings.getNamingStandardRule().getDiscriminatorColumn();
            if (value == null || "null".equals(value)) {
                this.tfDiscriminatorColumn.setText(this.discriminatorCol);
            } else {
                this.tfDiscriminatorColumn.setText(value);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to init design properties: ", e);
        }
    }

    private void setProperties() throws EmptyFieldException {
        try {
            if (this.classificationTypeTable.getCellEditor() != null) {
                this.classificationTypeTable.getCellEditor().stopCellEditing();
            }
            this.classificationTypeList.clear();
            for (ClassificationType classType : this.localClassificationTypeList) {
                this.classificationTypeList.add(classType);
            }
            this.defaultFCList.clear();
            for (DefaultFontAndColor dfc : this.localDefaultFCList) {
                this.defaultFCList.add(dfc);
            }
            this.defaultLWCList.clear();
            for (DefaultLineWidthAndColor dlwc : this.localDefaultLWCList) {
                this.defaultLWCList.add(dlwc);
            }
            this.getApplicationView();
            if (!ApplicationView.IS_VIEWER && !this.getApplicationView().getCurrentDesign().isNewDesign()) {
                this.designLevelSettings.setLogicalTypeForDomainPresentation(this.cbDomainPresentation.getSelectedItem() == USE_LOGICAL_TYPE);
                this.design.getLogicalDesign().getMainView().updateDiagramSettings();
            }
            if (!ApplicationView.IS_VIEWER) {
                this.designLevelSettings.setAutomaticPKGeneration(this.chAutomaticPKGeneration.isSelected());
                this.designLevelSettings.setAutomaticUKGeneration(this.chAutomaticUKGeneration.isSelected());
                this.designLevelSettings.setAutomaticFKGeneration(this.chAutomaticFKGeneration.isSelected());
                this.designLevelSettings.setPreserveDDLGenerationOptions(this.cbPreserveDDLGenerationOptions.isSelected());
            }
            this.substitutionList.clear();
            for (SubstitutionPattern substPattern : this.localSubstitutionList) {
                this.substitutionList.add(substPattern);
            }
            this.tbSubstituiton.updateUI();
            String key = "";
            for (Map.Entry entry : this.logicalModelSeparatorMap.entrySet()) {
                if (!entry.getValue().equals(this.separatorBox.getSelectedItem().toString())) continue;
                key = (String)entry.getKey();
                break;
            }
            this.designLevelSettings.getNamingStandardRule().setLogicalSep(key);
            this.designLevelSettings.getNamingStandardRule().setLogicalChar(this.characterField.getText());
            this.designLevelSettings.getNamingStandardRule().setRelSep(this.separatorText.getText());
            this.designLevelSettings.getNamingStandardRule().setAbbreviatedOnly(this.abbreviatedOnly.isSelected());
            this.designLevelSettings.getNamingStandardRule().setDomainsSep(this.dmsSeparator.getText());
            this.designLevelSettings.getNamingStandardRule().getGlossariesList().clear();
            this.designLevelSettings.getNamingStandardRule().getGlossariesList().addAll(this.glossariesList);
            this.designLevelSettings.getNamingStandardRule().getAttributesList().clear();
            this.designLevelSettings.getNamingStandardRule().getAttributesList().addAll(this.nsAttributesList);
            this.designLevelSettings.getNamingStandardRule().getColumnsList().clear();
            this.designLevelSettings.getNamingStandardRule().getColumnsList().addAll(this.nsColumnsList);
            this.designLevelSettings.getNamingStandardRule().getDomainsList().clear();
            this.designLevelSettings.getNamingStandardRule().getDomainsList().addAll(this.nsDomainsList);
            this.designLevelSettings.getNamingStandardRule().getEntitiesList().clear();
            this.designLevelSettings.getNamingStandardRule().getEntitiesList().addAll(this.nsEntitiesList);
            this.designLevelSettings.getNamingStandardRule().getTablesList().clear();
            this.designLevelSettings.getNamingStandardRule().getTablesList().addAll(this.nsTablesList);
            this.designLevelSettings.getNamingStandardRule().setPkConstr(this.tfPrimaryKey.getText());
            this.designLevelSettings.getNamingStandardRule().setFkConstr(this.tfForeignKey.getText());
            this.designLevelSettings.getNamingStandardRule().setCkConstr(this.tfCheckConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setUnConstr(this.tfUniqueConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setIdxConstr(this.tfIndex.getText());
            this.designLevelSettings.getNamingStandardRule().setAutomaticIdxConstr(this.tfAutomaticIndex.getText());
            this.designLevelSettings.getNamingStandardRule().setColckConstr(this.tfColCheckConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setColNNConstr(this.tfColNNConstr.getText());
            this.designLevelSettings.getNamingStandardRule().setUIConstr(this.tfPrimaryIdentifier.getText());
            this.designLevelSettings.getNamingStandardRule().setRelationAttribute(this.tfAttributeRelation.getText());
            this.designLevelSettings.getNamingStandardRule().setFkColumn(this.tfColumnForeignKey.getText());
            this.designLevelSettings.getNamingStandardRule().setSurrogateKey(this.tfSurrogateKey.getText());
            this.designLevelSettings.getNamingStandardRule().setSurrogateKeyColumn(this.tfSurrogateKeyColumn.getText());
            this.designLevelSettings.getNamingStandardRule().setDiscriminatorColumn(this.tfDiscriminatorColumn.getText());
            this.design.setComment(this.taComments.getText());
            this.design.setNotes(this.taNotes.getText());
        }
        catch (Exception e) {
            LOGGER.error("Unable to set design properties: ", e);
        }
    }

    @Override
    protected boolean isEditable() {
        if (this.design.isReadOnly()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER;
    }

    protected void addItem(JPanel p, JComponent c, int x, int y, int width, int height, int align, int wx, int wy) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = width;
        gc.gridheight = height;
        gc.weightx = wx;
        gc.weighty = wy;
        gc.insets = new Insets(0, 0, 0, 5);
        gc.anchor = align;
        gc.fill = 2;
        p.add((Component)c, gc);
    }

    public final int getPreferredIconSize() {
        return 16;
    }

    private void addToNSTable(JTable table, List list) {
        WordRule type;
        int row = table.getSelectedRow();
        String rule_type = "Prime Word";
        if (row > -1 && row < list.size()) {
            type = (WordRule)list.get(row);
            rule_type = type.getWordType();
        }
        type = new WordRule(rule_type, false);
        list.add(type);
        table.updateUI();
    }

    private void removeFromNSTable(JTable table, List list) {
        int objectNumber = table.getSelectedRow();
        if (objectNumber != -1 && list.size() > 0 && objectNumber < list.size()) {
            WordRule type = (WordRule)list.get(objectNumber);
            list.remove(type);
            table.updateUI();
        }
    }

    private void moveNSElementUp(JTable table, List list) {
        int objectNumber = table.getSelectedRow();
        if (objectNumber > 0) {
            WordRule type = (WordRule)list.get(objectNumber);
            this.moveToIndex(list, type, objectNumber - 1);
            table.changeSelection(objectNumber - 1, 0, false, false);
        }
    }

    private void moveNSElementDown(JTable table, List list) {
        int objectNumber = table.getSelectedRow();
        if (objectNumber > -1 && objectNumber + 1 < list.size()) {
            WordRule type = (WordRule)list.get(objectNumber);
            this.moveToIndex(list, type, objectNumber + 1);
            table.changeSelection(objectNumber + 1, 0, false, false);
            table.updateUI();
        }
    }

    private boolean moveToIndex(List list, WordRule object, int index) {
        if (list.contains(object) && list.size() > index && index >= 0) {
            list.remove(object);
            list.add(index, object);
            return true;
        }
        return false;
    }

    private void initConstants() {
        namePartMap.put("Prime Word", PRIME_WORD_L);
        namePartMap.put("Class Word", CLASS_WORD_L);
        namePartMap.put("Modifier", MODIFIER_L);
        namePartMap.put("Qualifier", QUALIFIER_L);
    }

    protected void createDialog(String[][] value, JTextField field) {
        AbstractPP.KeyDialog keyDialog = new AbstractPP.KeyDialog(this.getApplicationView(), null);
        keyDialog.setValues(value);
        keyDialog.setVisible(true);
        StringBuffer buffer = new StringBuffer();
        int cursorPos = field.getCaretPosition();
        int tfSize = field.getText().length();
        if (cursorPos == 0) {
            buffer.append(keyDialog.getProviderName());
        }
        if (tfSize != 0) {
            for (int i = 0; i < tfSize; ++i) {
                String providerName;
                buffer.append(field.getText().charAt(i));
                if (cursorPos != i + 1 || (providerName = keyDialog.getProviderName()) == null) continue;
                buffer.append(providerName);
            }
            field.setText(buffer.toString());
        } else {
            field.setText(keyDialog.getProviderName());
        }
    }

    public class GlossaryTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.glossariesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignPropertiesDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("DesignPropertiesDialog.Description");
            }
            if (column == 2) {
                return Messages.getString("DesignPropertiesDialog.File");
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            GlossaryFile glFile = (GlossaryFile)DesignPropertiesDialog.this.glossariesList.get(rowIndex);
            if (columnIndex == 0) {
                return glFile.getFileName();
            }
            if (columnIndex == 1) {
                return glFile.getDescription();
            }
            if (columnIndex == 2) {
                return glFile.getFilePath();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    class TableElementModel
    extends AbstractTableModel {
        TableElementModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.nsTablesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return NAME_PART;
            }
            return MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignPropertiesDialog.this.nsTablesList.get(rowIndex);
            if (columnIndex == 0) {
                return namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignPropertiesDialog.this.nsTablesTable.getRowCount()) {
                WordRule type = (WordRule)DesignPropertiesDialog.this.nsTablesList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    class EntityTableModel
    extends AbstractTableModel {
        EntityTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.nsEntitiesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return NAME_PART;
            }
            return MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignPropertiesDialog.this.nsEntitiesList.get(rowIndex);
            if (columnIndex == 0) {
                return namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignPropertiesDialog.this.nsEntitiesTable.getRowCount()) {
                WordRule type = (WordRule)DesignPropertiesDialog.this.nsEntitiesList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    class DomainTableModel
    extends AbstractTableModel {
        DomainTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.nsDomainsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return NAME_PART;
            }
            return MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignPropertiesDialog.this.nsDomainsList.get(rowIndex);
            if (columnIndex == 0) {
                return namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignPropertiesDialog.this.nsDomainsTable.getRowCount()) {
                WordRule type = (WordRule)DesignPropertiesDialog.this.nsDomainsList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    class ColumnTableModel
    extends AbstractTableModel {
        ColumnTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.nsColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return NAME_PART;
            }
            return MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignPropertiesDialog.this.nsColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignPropertiesDialog.this.nsColumnsTable.getRowCount()) {
                WordRule type = (WordRule)DesignPropertiesDialog.this.nsColumnsList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.nsAttributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return NAME_PART;
            }
            return MANDATORY;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            WordRule type = (WordRule)DesignPropertiesDialog.this.nsAttributesList.get(rowIndex);
            if (columnIndex == 0) {
                return namePartMap.get(type.getWordType());
            }
            if (columnIndex == 1) {
                return type.isMandatory();
            }
            return rowIndex * columnIndex;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            if (row < DesignPropertiesDialog.this.nsAttributesTable.getRowCount()) {
                WordRule type = (WordRule)DesignPropertiesDialog.this.nsAttributesList.get(row);
                if (column == 0) {
                    String key = "";
                    for (Map.Entry pairs : namePartMap.entrySet()) {
                        if (!pairs.getValue().equals(value)) continue;
                        key = (String)pairs.getKey();
                        break;
                    }
                    type.setWordType(key);
                }
                if (column == 1) {
                    type.setMandatory((Boolean)value);
                }
            }
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    static class LWCCellEditor
    extends DefaultCellEditor {
        JLWComboBox cbox = (JLWComboBox)this.getComponent();

        LWCCellEditor() {
            super(new JLWComboBox());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.cbox.setModel(new DefaultComboBoxModel<Object>(JLWComboBox.getItems().toArray()));
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)value;
            switch (dlwc.getWidth()) {
                case 1: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_1);
                    break;
                }
                case 2: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_2);
                    break;
                }
                case 3: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_3);
                    break;
                }
                case 4: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_4);
                    break;
                }
                case 5: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_5);
                    break;
                }
                case 6: {
                    this.cbox.setSelectedItem(JLWComboBox.ICON_6);
                }
            }
            return this.cbox;
        }
    }

    public static class ColorEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        Color currentColor;
        JButton button = new JButton();
        protected static final String EDIT = "edit";

        public ColorEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setBackground(this.currentColor);
                ColorChooserDialog colorDialog = new ColorChooserDialog(null, Messages.getString("DesignPropertiesDialog.PickColor"), this.currentColor);
                Color newColor = colorDialog.showDialog();
                if (newColor != null) {
                    this.currentColor = newColor;
                }
                this.fireEditingStopped();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentColor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentColor = ((DefaultLineWidthAndColor)value).getColor();
            return this.button;
        }
    }

    static class LineWidthCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LineWidthCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)value;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBackground(Color.WHITE);
            switch (dlwc.getWidth()) {
                case 1: {
                    this.setIcon(JLWComboBox.ICON_1);
                    break;
                }
                case 2: {
                    this.setIcon(JLWComboBox.ICON_2);
                    break;
                }
                case 3: {
                    this.setIcon(JLWComboBox.ICON_3);
                    break;
                }
                case 4: {
                    this.setIcon(JLWComboBox.ICON_4);
                    break;
                }
                case 5: {
                    this.setIcon(JLWComboBox.ICON_5);
                    break;
                }
                case 6: {
                    this.setIcon(JLWComboBox.ICON_6);
                }
            }
            return this;
        }
    }

    static class LineColorCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LineColorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)value;
            this.setOpaque(true);
            this.setBackground(dlwc.getColor());
            return this;
        }
    }

    public class DefaultLWCModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.localDefaultLWCList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignPropertiesDialog.DesignObject");
            }
            if (column == 1) {
                return Messages.getString("DesignPropertiesDialog.Color");
            }
            if (column == 2) {
                return Messages.getString("DesignPropertiesDialog.Width");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)DesignPropertiesDialog.this.localDefaultLWCList.get(row);
            if (col == 0) {
                return dlwc.getClassName();
            }
            if (col == 1 || col == 2) {
                return dlwc;
            }
            return row * col;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            DefaultLineWidthAndColor dlwc = (DefaultLineWidthAndColor)DesignPropertiesDialog.this.localDefaultLWCList.get(rowIndex);
            if (columnIndex == 1) {
                dlwc.setColor((Color)aValue);
            } else if (columnIndex == 2) {
                dlwc.setWidth(JLWComboBox.IndexOf(aValue) + 1);
            }
        }
    }

    public class DefaultFCModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.localDefaultFCList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignPropertiesDialog.DesignObject");
            }
            if (column == 1) {
                return Messages.getString("DesignPropertiesDialog.Background");
            }
            if (column == 2) {
                return Messages.getString("DesignPropertiesDialog.Foreground");
            }
            if (column == 3) {
                return Messages.getString("DesignPropertiesDialog.TitleFont");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DefaultFontAndColor dfc = (DefaultFontAndColor)DesignPropertiesDialog.this.localDefaultFCList.get(row);
            if (col == 0) {
                return dfc.getClassName();
            }
            if (col == 1 || col == 2) {
                return dfc;
            }
            if (col == 3) {
                return ((FontObject)dfc.getEditableFonts().get(0)).getFont().getName();
            }
            return row * col;
        }
    }

    static class FontsAndColorsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        FontsAndColorsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            DefaultFontAndColor dfc = (DefaultFontAndColor)value;
            this.setOpaque(true);
            if (col == 1) {
                this.setBackground(dfc.getBackgroundColor());
            } else {
                this.setBackground(dfc.getForegroundColor());
            }
            return this;
        }
    }

    private class AddClassificationTypeAction
    implements ActionListener {
        private AddClassificationTypeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassificationType addType = new ClassificationType("Type_" + DesignPropertiesDialog.this.localClassificationTypeList.size(), Color.BLACK, new GUID().toString(), "");
            DesignPropertiesDialog.this.localClassificationTypeList.add(addType);
            DesignPropertiesDialog.this.classificationTypeTable.updateUI();
            DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
        }
    }

    private class RemoveClassificationType
    implements ActionListener {
        private RemoveClassificationType() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ClassificationType classType;
            int objectNumber = DesignPropertiesDialog.this.classificationTypeTable.getSelectedRow();
            if (objectNumber != -1 && DesignPropertiesDialog.this.localClassificationTypeList.size() > 0 && objectNumber < DesignPropertiesDialog.this.localClassificationTypeList.size() && !(classType = (ClassificationType)DesignPropertiesDialog.this.localClassificationTypeList.get(objectNumber)).isReadOnly()) {
                DesignPropertiesDialog.this.localClassificationTypeList.remove(classType);
                DesignPropertiesDialog.this.classificationTypeTable.updateUI();
                DesignPropertiesDialog.this.design.setDesignLevelSettingsChanged(true);
            }
        }
    }

    static class ClassificationTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ClassificationTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            ClassificationType classificationType = (ClassificationType)value;
            this.setOpaque(true);
            this.setBackground(classificationType.getTypeColor());
            this.setToolTipText(Messages.getString("DesignPropertiesDialog.ClickToEdit"));
            return this;
        }
    }

    class ClassificationTypeViewCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton colorEditButton = new JButton();
        ClassificationType classificationType;

        ClassificationTypeViewCellEditor() {
            this.colorEditButton.setOpaque(true);
            this.colorEditButton.addActionListener(this);
            this.colorEditButton.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newEditedColor = new ColorChooserDialog((Dialog)new JDialog(DesignPropertiesDialog.this.getApplicationView().getFrame()), Messages.getString("DesignPropertiesDialog.SelectColor"), this.classificationType.getTypeColor()).showDialog();
            if (newEditedColor != null) {
                this.colorEditButton.setBackground(newEditedColor);
                this.classificationType.setTypeColor(newEditedColor);
            }
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            return this.classificationType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.classificationType = (ClassificationType)value;
            return this.colorEditButton;
        }
    }

    public class ClassificationTypeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.localClassificationTypeList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignPropertiesDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("DesignPropertiesDialog.Prefix");
            }
            return Messages.getString("DesignPropertiesDialog.Color");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            ClassificationType classType = (ClassificationType)DesignPropertiesDialog.this.localClassificationTypeList.get(rowIndex);
            if (columnIndex == 0) {
                return !classType.isReadOnly();
            }
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ClassificationType classType = (ClassificationType)DesignPropertiesDialog.this.localClassificationTypeList.get(row);
            if (column == 0) {
                return String.valueOf(classType.getTypeName());
            }
            if (column == 1) {
                return String.valueOf(classType.getTypePrefix());
            }
            if (column == 2) {
                return classType;
            }
            return row * column;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ClassificationType classType = (ClassificationType)DesignPropertiesDialog.this.localClassificationTypeList.get(row);
            if (column == 0) {
                classType.setTypeName((String)value);
            } else if (column == 1) {
                classType.setTypePrefix((String)value);
            }
        }
    }

    private class DeselectAllSubstitutionAction
    implements ActionListener {
        private DeselectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SubstitutionPattern substPattern : DesignPropertiesDialog.this.localSubstitutionList) {
                substPattern.setSelected(false);
            }
            DesignPropertiesDialog.this.tbSubstituiton.updateUI();
        }
    }

    private class SelectAllSubstitutionAction
    implements ActionListener {
        private SelectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SubstitutionPattern substPattern : DesignPropertiesDialog.this.localSubstitutionList) {
                substPattern.setSelected(true);
            }
            DesignPropertiesDialog.this.tbSubstituiton.updateUI();
        }
    }

    public class SubstitutionModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return DesignPropertiesDialog.this.localSubstitutionList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DesignPropertiesDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DesignPropertiesDialog.CaseSensitive");
            }
            if (column == 2) {
                return Messages.getString("DesignPropertiesDialog.Oid");
            }
            if (column == 3) {
                return Messages.getString("DesignPropertiesDialog.New");
            }
            if (column == 4) {
                return Messages.getString("DesignPropertiesDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SubstitutionPattern substPattern = (SubstitutionPattern)DesignPropertiesDialog.this.localSubstitutionList.get(row);
            if (col == 0) {
                return substPattern.isSelected();
            }
            if (col == 1) {
                return substPattern.isCaseSensitive();
            }
            if (col == 2) {
                return substPattern.getSourceString();
            }
            if (col == 3) {
                return substPattern.getReplacementString();
            }
            if (col == 4) {
                return substPattern.getComments();
            }
            return row * col;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            SubstitutionPattern substPattern = (SubstitutionPattern)DesignPropertiesDialog.this.localSubstitutionList.get(row);
            if (col == 0) {
                substPattern.setSelected((Boolean)aValue);
            } else if (col == 1) {
                substPattern.setCaseSensitive((Boolean)aValue);
            } else if (col == 2) {
                substPattern.setSourceString(this.checkValue((String)aValue, true));
            } else if (col == 3) {
                substPattern.setReplacementString(this.checkValue((String)aValue, false));
            } else if (col == 4) {
                substPattern.setComments((String)aValue);
            }
        }

        private String checkValue(String value, boolean isSource) {
            block4: {
                if (value.trim().equals("")) break block4;
                if (isSource) {
                    for (SubstitutionPattern pattern : DesignPropertiesDialog.this.localSubstitutionList) {
                        if (pattern.getReplacementString().indexOf(value) <= -1) continue;
                        JOptionPane.showMessageDialog(new JDialog(DesignPropertiesDialog.this.getApplicationView().getFrame()), new Object[]{""}, "", 0);
                        return "";
                    }
                } else {
                    for (SubstitutionPattern pattern : DesignPropertiesDialog.this.localSubstitutionList) {
                        if (pattern.getSourceString().indexOf(value) <= -1) continue;
                        JOptionPane.showMessageDialog(DesignPropertiesDialog.this.getApplicationView().getFrame(), new Object[]{""}, "", 0);
                        return "";
                    }
                }
            }
            return value;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)DesignPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                DesignPropertiesDialog.this.cardLayout.show(DesignPropertiesDialog.this.getMainPanel(), ((Component)obj).getName());
            }
        }
    }

    public class TreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }
}

