/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.undo.NoteUpdateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NoteEditor
extends CustomDialog
implements AbstractEditorConstants {
    private JEditorPane editorPane;
    private JPanel buttonPanel;
    private Note note;
    private JDialog dialog;

    public NoteEditor(ApplicationView view) {
        super(view);
    }

    public NoteEditor(ApplicationView view, Note note) {
        super(view);
        this.note = note;
        this.editorPane = this.getEditorPane();
        this.initProperties(note);
        JScrollPane scrollPane = new JScrollPane(this.editorPane);
        this.add((Component)scrollPane, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
    }

    public String getCaption() {
        return Messages.getString("NoteEditor.Note");
    }

    private void setProperties() {
        NoteUpdateEdit edit = new NoteUpdateEdit(this.note, this.editorPane.getText());
        edit.end();
        edit.applyUpdates();
        this.note.getDesignPart().postUndoableEdit(edit);
    }

    protected JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(500, 300));
            this.editorPane.setEnabled(this.isEditable());
        }
        return this.editorPane;
    }

    public void initProperties(Note note) {
        this.editorPane.setText(note.getText());
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            if (this.isEditable()) {
                JButton ok = new JButton(Messages.getString("NoteEditor.OK"));
                ok.setCursor(Cursor.getPredefinedCursor(12));
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NoteEditor.this.setProperties();
                        NoteEditor.this.close();
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
            }
            JButton cancel = new JButton(this.isEditable() ? Messages.getString("NoteEditor.Cancel") : Messages.getString("NoteEditor.Close"));
            cancel.setCursor(Cursor.getPredefinedCursor(12));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (NoteEditor.this.note.showForFirstTime()) {
                        NoteEditor.this.note.remove(false);
                    }
                    NoteEditor.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }

    protected JPanel initMainPanel() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        if (this.note.showModal || this.note.showForFirstTime()) {
            ((JDialog)this.getDialog()).setModal(true);
        }
        this.getDialog().show();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }
}

