/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DMDExportsPersistence;
import oracle.dbtools.crest.swingui.editor.ExpObject;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SelectExportDialog
extends CustomDialog {
    private static final String TEMPLATE_NAME = "Export Configuration";
    private Action actionEscape;
    private JDialog dialog;
    private String title;
    private Design design;
    private boolean cancelled = false;
    private ToStringComparator toStringComparator = new ToStringComparator();
    private JPanel mainPanel;
    private JButton btnSave;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnRemove;
    private JButton btnOK = new JButton(Messages.getString("SelectExportDialog.OK"));
    private JTextField txtName;
    private JTextArea txtDescription;
    private DefaultListModel exportsModel;
    private int cgCounter = 0;
    private JList exportsList;
    private boolean manuallyClicked = false;
    private boolean isSaved = true;
    private ExportsListSelectionHandler exportsListHandler;
    private JScrollPane exportstSP;
    private List<ExpObject> allExportsList;
    private ArrayList allAvailableModelsList;
    private ArrayList allAvailableSubViewsList;
    private JTextField modelsFilter;
    private JTextField subviewsFilter;
    private List currentNonSelectedModelsList = new ArrayList();
    private FilteredModelsJList modelsList;
    private DefaultListModel selectedModelsListModel;
    private JList selectedModelsList;
    private JScrollPane selectedModelsPane;
    private JScrollPane modelsPane;
    private JButton btnModelAdd;
    private JButton btnModelRemove;
    private List currentNonSelectedSubViewsList = new ArrayList();
    private FilteredSUbViewsJList subviewsList;
    private DefaultListModel selectedCurrentModelSubviewsModel;
    private DefaultListModel selectedAllSubviewsListModel;
    private JList selectedCurrentModelSubviewsList;
    private JList selectedAllSubviewsList;
    private JScrollPane selectedStandaloneSubviewsSPane;
    private JScrollPane selectedAllSubviewsSPane;
    private JScrollPane subviewsSPane;
    private JButton btnSubviewAdd;
    private JButton btnSubviewRemove;
    private DMDExportsPersistence exportsPersistence;
    private JTabbedPane jpane;
    private boolean isSelectedExportConfig = false;

    public SelectExportDialog(ApplicationView appView, String title) {
        super(appView);
        this.design = appView.getCurrentDesign();
        this.title = title;
        this.allExportsList = appView.getDMDExports();
        this.exportsPersistence = new DMDExportsPersistence(appView, this.design);
        this.design = appView.getCurrentDesign();
        this.init();
        this.add((Component)this.getButtonPanel(), "South");
        this.loadModels();
        this.loadSubViews();
        this.loadExports();
    }

    private void init() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(560, 680));
        JPanel exportsPanel = new JPanel(new SpringLayout());
        exportsPanel.setPreferredSize(new Dimension(560, 160));
        exportsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.ExportConfigurations")));
        this.exportsModel = new DefaultListModel();
        this.exportsList = new JList(this.exportsModel);
        this.exportsListHandler = new ExportsListSelectionHandler();
        this.exportsList.addListSelectionListener(this.exportsListHandler);
        this.exportsList.setCellRenderer(new ExportRenderer());
        this.exportsList.setSelectionMode(0);
        this.exportstSP = new JScrollPane(this.exportsList);
        this.exportstSP.setPreferredSize(new Dimension(340, 120));
        CommonUtil.setObjectConstraints((SpringLayout)exportsPanel.getLayout(), this.exportstSP, 5, 5);
        exportsPanel.add(this.exportstSP);
        this.btnAdd = new JButton(Messages.getString("SelectExportDialog.Add"));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new AddAction());
        this.btnAdd.setMnemonic(65);
        CommonUtil.setObjectConstraints((SpringLayout)exportsPanel.getLayout(), this.btnAdd, 360, 5);
        exportsPanel.add(this.btnAdd);
        this.btnEdit = new JButton(Messages.getString("SelectExportDialog.Edit"));
        this.btnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new EditAction());
        this.btnEdit.setMnemonic(69);
        CommonUtil.setObjectConstraints((SpringLayout)exportsPanel.getLayout(), this.btnEdit, 360, 35);
        exportsPanel.add(this.btnEdit);
        this.btnRemove = new JButton(Messages.getString("SelectExportDialog.Remove"));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        CommonUtil.setObjectConstraints((SpringLayout)exportsPanel.getLayout(), this.btnRemove, 360, 65);
        exportsPanel.add(this.btnRemove);
        this.btnSave = new JButton(Messages.getString("SelectExportDialog.Save"));
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(83);
        CommonUtil.setObjectConstraints((SpringLayout)exportsPanel.getLayout(), this.btnSave, 360, 95);
        exportsPanel.add(this.btnSave);
        JPanel nameDescriptionScopePanel = new JPanel(new SpringLayout());
        nameDescriptionScopePanel.setPreferredSize(new Dimension(280, 100));
        JLabel lblName = new JLabel(Messages.getString("SelectExportDialog.Name"));
        lblName.setPreferredSize(new Dimension(70, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), lblName, 5, 5);
        this.txtName = new JTextField();
        this.txtName.setEnabled(false);
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        });
        this.txtName.setPreferredSize(new Dimension(250, 20));
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), this.txtName, 100, 5);
        JLabel lblComments = new JLabel(Messages.getString("SelectExportDialog.Description"));
        lblComments.setPreferredSize(new Dimension(70, 20));
        CommonUtil.setLabelConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), lblComments, 5, 35);
        this.txtDescription = new JTextArea();
        this.txtDescription.setEnabled(false);
        this.txtDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        });
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        JScrollPane commentsScrollPane = new JScrollPane(this.txtDescription);
        commentsScrollPane.setPreferredSize(new Dimension(250, 50));
        CommonUtil.setObjectConstraints((SpringLayout)nameDescriptionScopePanel.getLayout(), commentsScrollPane, 100, 35);
        nameDescriptionScopePanel.add(lblName);
        nameDescriptionScopePanel.add(this.txtName);
        nameDescriptionScopePanel.add(lblComments);
        nameDescriptionScopePanel.add(commentsScrollPane);
        JPanel jjM = new JPanel();
        GroupLayout glModels = new GroupLayout(jjM);
        JPanel allModelsPanel = new JPanel(new BorderLayout());
        allModelsPanel.setPreferredSize(new Dimension(250, 195));
        allModelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.AllModels")));
        this.modelsList = new FilteredModelsJList();
        this.modelsList.setCellRenderer(new AllModelsRenderer());
        this.modelsPane = new JScrollPane(this.modelsList);
        this.modelsPane.setPreferredSize(new Dimension(250, 150));
        this.modelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectExportDialog.this.subviewsList.clearSelection();
                SelectExportDialog.this.selectedCurrentModelSubviewsModel.clear();
                if (SelectExportDialog.this.modelsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnModelAdd.setEnabled(false);
                } else {
                    SubViewsFilterModel subviewsFilterModel = (SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel();
                    subviewsFilterModel.clear();
                    int[] selectedModelsIndices = SelectExportDialog.this.modelsList.getSelectedIndices();
                    for (int i = 0; i < selectedModelsIndices.length; ++i) {
                        DesignPart dp = (DesignPart)SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelsIndices[i]);
                        Iterator it0 = dp.getDesignSubviews().iterator();
                        while (it0.hasNext()) {
                            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                            if (SelectExportDialog.this.selectedAllSubviewsListModel.contains(ph)) {
                                SelectExportDialog.this.selectedCurrentModelSubviewsModel.addElement(ph);
                                continue;
                            }
                            subviewsFilterModel.addElement(ph);
                        }
                    }
                    SelectExportDialog.this.btnModelAdd.setEnabled(true);
                    ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).setInitialState();
                }
            }
        });
        JPanel modelsFilterPanel = new JPanel(new SpringLayout());
        modelsFilterPanel.setPreferredSize(new Dimension(200, 25));
        JLabel modelsFilterLabel = new JLabel(Messages.getString("SelectExportDialog.Filter"));
        this.modelsFilter = new JTextField();
        this.modelsFilter.setPreferredSize(new Dimension(148, 20));
        this.modelsFilter.getDocument().addDocumentListener(new ModelsFilterListener());
        CommonUtil.setObjectConstraints((SpringLayout)modelsFilterPanel.getLayout(), modelsFilterLabel, 5, 0);
        CommonUtil.setObjectConstraints((SpringLayout)modelsFilterPanel.getLayout(), this.modelsFilter, 50, 0);
        modelsFilterPanel.add(modelsFilterLabel);
        modelsFilterPanel.add(this.modelsFilter);
        allModelsPanel.add((Component)modelsFilterPanel, "North");
        allModelsPanel.add((Component)this.modelsPane, "Center");
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnModelAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnModelAdd.addActionListener(new AddModelActionListener());
        this.btnModelAdd.setEnabled(false);
        this.btnModelAdd.setPreferredSize(new Dimension(32, 32));
        this.btnModelRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnModelRemove.addActionListener(new RemoveModelActionListener());
        this.btnModelRemove.setEnabled(false);
        this.btnModelRemove.setPreferredSize(new Dimension(32, 32));
        JPanel jpButtonsM = new JPanel();
        jpButtonsM.setLayout(new BoxLayout(jpButtonsM, 3));
        jpButtonsM.add(this.btnModelAdd);
        jpButtonsM.add(this.btnModelRemove);
        Box verticalBoxM = Box.createVerticalBox();
        verticalBoxM.setPreferredSize(new Dimension(32, 195));
        verticalBoxM.add(Box.createVerticalGlue());
        verticalBoxM.add(jpButtonsM);
        verticalBoxM.add(Box.createVerticalGlue());
        JPanel selectedModelsPanel = new JPanel(new BorderLayout());
        selectedModelsPanel.setPreferredSize(new Dimension(250, 195));
        selectedModelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.SelectedModels")));
        this.selectedModelsListModel = new DefaultListModel();
        this.selectedModelsList = new JList(this.selectedModelsListModel);
        this.selectedModelsList.setCellRenderer(new SelectedModelsRenderer());
        this.selectedModelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectExportDialog.this.selectedModelsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnModelRemove.setEnabled(false);
                } else {
                    SelectExportDialog.this.btnModelRemove.setEnabled(true);
                }
            }
        });
        this.selectedModelsPane = new JScrollPane(this.selectedModelsList);
        selectedModelsPanel.add(this.selectedModelsPane);
        JPanel modelsPanel = new JPanel(new BorderLayout());
        modelsPanel.setPreferredSize(new Dimension(560, 200));
        glModels.setHorizontalGroup(glModels.createSequentialGroup().addComponent(allModelsPanel, -1, -1, Short.MAX_VALUE).addComponent(verticalBoxM, -1, -1, Short.MAX_VALUE).addComponent(selectedModelsPanel, -1, -1, Short.MAX_VALUE));
        modelsPanel.add(jjM);
        JPanel allSubviewsPanel = new JPanel(new BorderLayout());
        allSubviewsPanel.setPreferredSize(new Dimension(250, 195));
        allSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.AllSW")));
        this.subviewsList = new FilteredSUbViewsJList();
        this.subviewsList.setCellRenderer(new AllSubviewsRenderer());
        this.subviewsSPane = new JScrollPane(this.subviewsList);
        this.subviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectExportDialog.this.subviewsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
                } else {
                    SelectExportDialog.this.btnSubviewAdd.setEnabled(true);
                }
            }
        });
        JPanel subviewsFilterPanel = new JPanel(new SpringLayout());
        subviewsFilterPanel.setPreferredSize(new Dimension(200, 25));
        JLabel subviewsFilterLabel = new JLabel(Messages.getString("SelectExportDialog.Filter"));
        this.subviewsFilter = new JTextField();
        this.subviewsFilter.setPreferredSize(new Dimension(148, 20));
        this.subviewsFilter.getDocument().addDocumentListener(new SubViewsFilterListener());
        CommonUtil.setObjectConstraints((SpringLayout)subviewsFilterPanel.getLayout(), subviewsFilterLabel, 5, 0);
        CommonUtil.setObjectConstraints((SpringLayout)subviewsFilterPanel.getLayout(), this.subviewsFilter, 50, 0);
        subviewsFilterPanel.add(subviewsFilterLabel);
        subviewsFilterPanel.add(this.subviewsFilter);
        allSubviewsPanel.add((Component)subviewsFilterPanel, "North");
        allSubviewsPanel.add((Component)this.subviewsSPane, "Center");
        this.btnSubviewAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnSubviewAdd.addActionListener(new AddSubviewActionListener());
        this.btnSubviewAdd.setEnabled(false);
        this.btnSubviewAdd.setPreferredSize(new Dimension(32, 32));
        this.btnSubviewRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnSubviewRemove.addActionListener(new RemoveSubviewActionListener());
        this.btnSubviewRemove.setEnabled(false);
        this.btnSubviewRemove.setPreferredSize(new Dimension(32, 32));
        JPanel jpButtons = new JPanel();
        jpButtons.setLayout(new BoxLayout(jpButtons, 3));
        jpButtons.add(this.btnSubviewAdd);
        jpButtons.add(this.btnSubviewRemove);
        Box verticalBoxSW = Box.createVerticalBox();
        verticalBoxSW.setPreferredSize(new Dimension(32, 195));
        verticalBoxSW.add(Box.createVerticalGlue());
        verticalBoxSW.add(jpButtons);
        verticalBoxSW.add(Box.createVerticalGlue());
        JPanel selectedSubviewsPanel = new JPanel(new BorderLayout());
        selectedSubviewsPanel.setPreferredSize(new Dimension(250, 195));
        selectedSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.SelectedSW")));
        this.selectedCurrentModelSubviewsModel = new DefaultListModel();
        this.selectedCurrentModelSubviewsList = new JList(this.selectedCurrentModelSubviewsModel);
        this.selectedCurrentModelSubviewsList.setCellRenderer(new SelectedSubviewsRenderer());
        this.selectedCurrentModelSubviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectExportDialog.this.selectedCurrentModelSubviewsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
                } else {
                    SelectExportDialog.this.btnSubviewRemove.setEnabled(true);
                }
            }
        });
        this.selectedStandaloneSubviewsSPane = new JScrollPane(this.selectedCurrentModelSubviewsList);
        this.selectedAllSubviewsListModel = new DefaultListModel();
        this.selectedAllSubviewsList = new JList(this.selectedAllSubviewsListModel);
        this.selectedAllSubviewsList.setEnabled(false);
        this.selectedAllSubviewsSPane = new JScrollPane(this.selectedAllSubviewsList);
        this.selectedAllSubviewsSPane.setEnabled(false);
        JPanel subviewsPanel = new JPanel(new BorderLayout());
        subviewsPanel.setPreferredSize(new Dimension(560, 200));
        this.jpane = new JTabbedPane();
        this.jpane.setPreferredSize(new Dimension(263, 200));
        this.jpane.addTab(Messages.getString("SelectExportDialog.CurrentModel"), this.selectedStandaloneSubviewsSPane);
        this.jpane.addTab(Messages.getString("SelectExportDialog.AllSelected"), this.selectedAllSubviewsSPane);
        selectedSubviewsPanel.add(this.jpane);
        JPanel jjS = new JPanel();
        GroupLayout glSubviews = new GroupLayout(jjS);
        glSubviews.setHorizontalGroup(glSubviews.createSequentialGroup().addComponent(allSubviewsPanel, -1, -1, Short.MAX_VALUE).addComponent(verticalBoxSW, -1, -1, Short.MAX_VALUE).addComponent(selectedSubviewsPanel, -1, -1, Short.MAX_VALUE));
        subviewsPanel.add(jjS);
        JPanel jp = new JPanel(new BorderLayout());
        jp.add((Component)modelsPanel, "North");
        jp.add((Component)subviewsPanel, "South");
        JPanel exportPanel = new JPanel(new BorderLayout());
        exportPanel.add((Component)nameDescriptionScopePanel, "North");
        exportPanel.add((Component)jp, "Center");
        this.mainPanel.add((Component)exportsPanel, "North");
        this.mainPanel.add((Component)exportPanel, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    private void loadModels() {
        this.allAvailableModelsList = new ArrayList();
        for (Object o : this.design.getStorableDesignParts()) {
            if (o instanceof DataFlowDesign) continue;
            this.allAvailableModelsList.add(o);
        }
        this.resetModels();
    }

    private void resetModels() {
        this.selectedModelsListModel.clear();
        ModelsFilterModel modelsFilterModel = (ModelsFilterModel)this.modelsList.getModel();
        modelsFilterModel.clear();
        Iterator it0 = this.allAvailableModelsList.iterator();
        while (it0.hasNext()) {
            modelsFilterModel.addElement(it0.next());
        }
        ((ModelsFilterModel)this.modelsList.getModel()).setInitialState();
    }

    private void loadSubViews() {
        this.allAvailableSubViewsList = new ArrayList();
        Iterator it = this.design.getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            this.allAvailableSubViewsList.add(ph);
        }
        it = this.design.getRelationalDesigns().iterator();
        while (it.hasNext()) {
            DesignPart dp = (DesignPart)it.next();
            Iterator it0 = dp.getDesignSubviews().iterator();
            while (it0.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                this.allAvailableSubViewsList.add(ph);
            }
        }
        this.resetSubViews();
    }

    private void resetSubViews() {
        this.selectedAllSubviewsListModel.clear();
        SubViewsFilterModel subviewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
        subviewsFilterModel.clear();
        Iterator it = this.allAvailableSubViewsList.iterator();
        while (it.hasNext()) {
            subviewsFilterModel.addElement(it.next());
        }
        ((SubViewsFilterModel)this.subviewsList.getModel()).setInitialState();
    }

    @Override
    protected Action getEscapeAction() {
        if (this.actionEscape == null) {
            this.actionEscape = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SelectExportDialog.this.canClose()) {
                        SelectExportDialog.this.cancelled = true;
                        SelectExportDialog.this.close();
                    }
                }
            };
        }
        return this.actionEscape;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setPreferredSize(new Dimension(560, 730));
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_CONFIGURATIONS_DIALOG";
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.btnOK.setMnemonic(79);
        this.btnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectExportDialog.this.getSelectedModelsAndSWs().size() > 0) {
                    SelectExportDialog.this.cancelled = false;
                    SelectExportDialog.this.close();
                } else {
                    JOptionPane.showMessageDialog(SelectExportDialog.this, Messages.getString("SelectExportDialog.ExportCanNotContinue"), Messages.getString("SelectExportDialog.ExportToDMD"), 0);
                    SelectExportDialog.this.cancelled = true;
                }
            }
        });
        JButton btnCancel = new JButton(Messages.getString("SelectExportDialog.Cancel"));
        btnCancel.setMnemonic(67);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectExportDialog.this.canClose()) {
                    SelectExportDialog.this.cancelled = true;
                    SelectExportDialog.this.close();
                }
            }
        });
        btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(this.btnOK);
        buttonPanel.add(btnCancel);
        buttonPanel.add(btnHelp);
        return buttonPanel;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    public List getSelectedModelsAndSWs() {
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(Arrays.asList(this.selectedModelsListModel.toArray()));
        all.addAll(Arrays.asList(this.selectedAllSubviewsListModel.toArray()));
        return all;
    }

    private String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.exportsModel.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsForDesign(nName, null)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsForDesign(String name, ExpObject current) {
        for (int i = 0; i < this.exportsModel.size(); ++i) {
            ExpObject ex = (ExpObject)this.exportsModel.get(i);
            if (ex == current || !name.equalsIgnoreCase(ex.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = Messages.getString("SelectExportDialog.Yes");
            String s2 = Messages.getString("SelectExportDialog.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("SelectExportDialog.ConfigNotSaved"), Messages.getString("SelectExportDialog.CloseConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    @Override
    public void setDefaultActions(JDialog dialog, boolean enableHelp) {
        this.setDefaultActions((JComponent)dialog.getContentPane(), enableHelp);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectExportDialog.this.cancelled = true;
                if (SelectExportDialog.this.canClose()) {
                    SelectExportDialog.this.close();
                }
            }
        });
    }

    private DefaultListModel sortDMDExports(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = ((ExpObject)list.get(i)).getName().toString();
                String s2 = ((ExpObject)list.get(i - 1)).getName().toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void loadExports() {
        this.exportsPersistence.loadExports();
        for (ExpObject ex : this.allExportsList) {
            if (!ex.getDesignID().equals(this.design.getObjectID())) continue;
            this.exportsModel.addElement(ex);
        }
        this.sortDMDExports(this.exportsModel);
    }

    private void showDetails(ExpObject ex) {
        this.txtName.setText(ex.getName());
        this.txtDescription.setText(ex.getDescription());
        this.resetModels();
        this.resetSubViews();
        SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
        ArrayList<ModelIDObject> tempList = new ArrayList<ModelIDObject>();
        if (ex.getModels().size() > 0) {
            block0: for (String string : ex.getModels()) {
                for (DesignPart dp : this.allAvailableModelsList) {
                    if (!dp.getObjectID().equals(string)) continue;
                    this.selectedModelsListModel.addElement(dp);
                    Iterator it1 = dp.getDesignSubviews().iterator();
                    while (it1.hasNext()) {
                        DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it1.next();
                        subViewsFilterModel.remove(ph);
                    }
                    tempList.add(dp);
                    continue block0;
                }
            }
            ModelsFilterModel modelsFilterModel = (ModelsFilterModel)this.modelsList.getModel();
            Iterator it = tempList.iterator();
            while (it.hasNext()) {
                modelsFilterModel.remove(it.next());
            }
        }
        if (ex.getSubViews().size() > 0) {
            tempList.clear();
            block4: for (String string : ex.getSubViews()) {
                for (DesignPartViewPlaceHolder ph : this.allAvailableSubViewsList) {
                    if (!ph.getObjectID().equals(string)) continue;
                    this.selectedAllSubviewsListModel.addElement(ph);
                    tempList.add(ph);
                    continue block4;
                }
            }
            for (Object e : tempList) {
                subViewsFilterModel.remove(e);
            }
        }
    }

    private DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = list.get(i).toString();
                String s2 = list.get(i - 1).toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private class SelectedSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)value;
                DesignPart dp = ph.getDesignPart();
                this.setText(ph.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class SelectedModelsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedModelsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPart) {
                this.setText(((DesignPart)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class AllSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)value;
                DesignPart dp = ph.getDesignPart();
                this.setText(ph.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class AllModelsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllModelsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPart) {
                this.setText(((DesignPart)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class RemoveSubviewActionListener
    implements ActionListener {
        private RemoveSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList removalList = new ArrayList();
            ArrayList selectedObjects = new ArrayList();
            int[] selectedSubviewsIndices = SelectExportDialog.this.selectedCurrentModelSubviewsList.getSelectedIndices();
            for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                o = SelectExportDialog.this.selectedCurrentModelSubviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                selectedObjects.add(o);
                if (((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).contains(o)) continue;
                ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).add(o);
                removalList.add(o);
            }
            for (DesignPartViewPlaceHolder ph : removalList) {
                if (SelectExportDialog.this.selectedCurrentModelSubviewsModel.contains(ph)) {
                    SelectExportDialog.this.selectedCurrentModelSubviewsModel.removeElement(ph);
                }
                if (!SelectExportDialog.this.selectedAllSubviewsListModel.contains(ph)) continue;
                SelectExportDialog.this.selectedAllSubviewsListModel.removeElement(ph);
            }
            if (SelectExportDialog.this.selectedCurrentModelSubviewsModel.size() > 0) {
                SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedIndex(selectedSubviewsIndices[0] - 1);
                } else {
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedIndex(selectedSubviewsIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
            }
            Iterator it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.subviewsList.setSelectedValue(it.next(), true);
            }
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class AddSubviewActionListener
    implements ActionListener {
        private AddSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList selectedObjects = new ArrayList();
            ArrayList removalList = new ArrayList();
            int[] selectedSubviewsIndices = SelectExportDialog.this.subviewsList.getSelectedIndices();
            for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                o = SelectExportDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                selectedObjects.add(o);
                if (!SelectExportDialog.this.selectedCurrentModelSubviewsModel.contains(o)) {
                    SelectExportDialog.this.selectedCurrentModelSubviewsModel.addElement(o);
                    removalList.add(o);
                }
                if (SelectExportDialog.this.selectedAllSubviewsListModel.contains(o)) continue;
                SelectExportDialog.this.selectedAllSubviewsListModel.addElement(o);
            }
            Iterator it = removalList.iterator();
            while (it.hasNext()) {
                ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).remove(it.next());
            }
            if (((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).getSize() > 0) {
                SelectExportDialog.this.subviewsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.subviewsList.setSelectedIndex(selectedSubviewsIndices[0] - 1);
                } else {
                    SelectExportDialog.this.subviewsList.setSelectedIndex(selectedSubviewsIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
            }
            it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedValue(it.next(), true);
            }
            SelectExportDialog.this.sort(SelectExportDialog.this.selectedCurrentModelSubviewsModel);
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class RemoveModelActionListener
    implements ActionListener {
        private RemoveModelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList removalList = new ArrayList();
            ArrayList selectedObjects = new ArrayList();
            int[] selectedModelsIndices = SelectExportDialog.this.selectedModelsList.getSelectedIndices();
            for (int i = 0; i < selectedModelsIndices.length; ++i) {
                o = SelectExportDialog.this.selectedModelsList.getModel().getElementAt(selectedModelsIndices[i]);
                selectedObjects.add(o);
                if (((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).contains(o)) continue;
                ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).add(o);
                removalList.add(o);
            }
            Iterator it = removalList.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.selectedModelsListModel.removeElement(it.next());
            }
            if (SelectExportDialog.this.selectedModelsListModel.size() > 0) {
                SelectExportDialog.this.selectedModelsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelsIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.selectedModelsList.setSelectedIndex(selectedModelsIndices[0] - 1);
                } else {
                    SelectExportDialog.this.selectedModelsList.setSelectedIndex(selectedModelsIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnModelRemove.setEnabled(false);
            }
            it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.modelsList.setSelectedValue(it.next(), true);
            }
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class AddModelActionListener
    implements ActionListener {
        private AddModelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList selectedObjects = new ArrayList();
            ArrayList removalList = new ArrayList();
            int[] selectedModelIndices = SelectExportDialog.this.modelsList.getSelectedIndices();
            for (int i = 0; i < selectedModelIndices.length; ++i) {
                o = SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelIndices[i]);
                selectedObjects.add(o);
                if (SelectExportDialog.this.selectedModelsListModel.contains(o)) continue;
                SelectExportDialog.this.selectedModelsListModel.addElement(o);
                removalList.add(o);
            }
            for (DesignPart dp : removalList) {
                ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).remove(dp);
                Iterator it0 = dp.getDesignSubviews().iterator();
                while (it0.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                    ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).remove(ph);
                    SelectExportDialog.this.selectedCurrentModelSubviewsModel.removeElement(ph);
                    SelectExportDialog.this.selectedAllSubviewsListModel.removeElement(ph);
                }
            }
            if (((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).getSize() > 0) {
                SelectExportDialog.this.modelsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.modelsList.setSelectedIndex(selectedModelIndices[0] - 1);
                } else {
                    SelectExportDialog.this.modelsList.setSelectedIndex(selectedModelIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnModelAdd.setEnabled(false);
            }
            Iterator it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.selectedModelsList.setSelectedValue(it.next(), true);
            }
            SelectExportDialog.this.sort(SelectExportDialog.this.selectedModelsListModel);
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class SubViewsFilterListener
    implements DocumentListener {
        private SubViewsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).refilter();
        }
    }

    private class ModelsFilterListener
    implements DocumentListener {
        private ModelsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).refilter();
        }
    }

    private class SubViewsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SelectExportDialog.this.currentNonSelectedSubViewsList.add(o);
            this.fireContentsChanged(this, 0, this.getSize());
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SelectExportDialog.this.currentNonSelectedSubViewsList.remove(o);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SelectExportDialog.this.subviewsFilter.getText();
            for (int i = 0; i < SelectExportDialog.this.currentNonSelectedSubViewsList.size(); ++i) {
                String name = ((DesignPartViewPlaceHolder)SelectExportDialog.this.currentNonSelectedSubViewsList.get(i)).getName();
                if (SelectExportDialog.match(name, term)) {
                    this.filterItems.add(SelectExportDialog.this.currentNonSelectedSubViewsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
            SelectExportDialog.this.currentNonSelectedSubViewsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SelectExportDialog.this.currentNonSelectedSubViewsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    private class ModelsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SelectExportDialog.this.currentNonSelectedModelsList.add(o);
            this.fireContentsChanged(this, 0, this.getSize());
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SelectExportDialog.this.currentNonSelectedModelsList.remove(o);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SelectExportDialog.this.modelsFilter.getText();
            for (int i = 0; i < SelectExportDialog.this.currentNonSelectedModelsList.size(); ++i) {
                String name = ((DesignPart)SelectExportDialog.this.currentNonSelectedModelsList.get(i)).getName();
                if (SelectExportDialog.match(name, term)) {
                    this.filterItems.add(SelectExportDialog.this.currentNonSelectedModelsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
            SelectExportDialog.this.currentNonSelectedModelsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SelectExportDialog.this.currentNonSelectedModelsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    class FilteredSUbViewsJList
    extends JList {
        public FilteredSUbViewsJList() {
            this.setModel((ListModel)new SubViewsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof SubViewsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    class FilteredModelsJList
    extends JList {
        public FilteredModelsJList() {
            this.setModel((ListModel)new ModelsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof ModelsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class ExportRenderer
    extends JLabel
    implements ListCellRenderer {
        private ExportRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ExpObject ex = (ExpObject)value;
            this.setText(ex.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ExportsListSelectionHandler
    implements ListSelectionListener {
        private ExportsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selected = SelectExportDialog.this.exportsList.getSelectedIndex();
                if (selected == -1) {
                    SelectExportDialog.this.btnAdd.setEnabled(true);
                    SelectExportDialog.this.btnEdit.setEnabled(false);
                    SelectExportDialog.this.btnRemove.setEnabled(false);
                    SelectExportDialog.this.btnSave.setEnabled(false);
                    SelectExportDialog.this.resetModels();
                    SelectExportDialog.this.resetSubViews();
                    SelectExportDialog.this.modelsList.setEnabled(true);
                    SelectExportDialog.this.selectedModelsList.setEnabled(true);
                    SelectExportDialog.this.subviewsList.setEnabled(true);
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(true);
                    SelectExportDialog.this.modelsFilter.setEnabled(true);
                    SelectExportDialog.this.subviewsFilter.setEnabled(true);
                    SelectExportDialog.this.isSelectedExportConfig = false;
                } else {
                    SelectExportDialog.this.btnAdd.setEnabled(true);
                    SelectExportDialog.this.btnEdit.setEnabled(true);
                    SelectExportDialog.this.btnRemove.setEnabled(true);
                    SelectExportDialog.this.btnSave.setEnabled(false);
                    SelectExportDialog.this.modelsList.clearSelection();
                    SelectExportDialog.this.selectedModelsList.clearSelection();
                    SelectExportDialog.this.subviewsList.clearSelection();
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.clearSelection();
                    SelectExportDialog.this.selectedAllSubviewsList.clearSelection();
                    SelectExportDialog.this.modelsList.setEnabled(false);
                    SelectExportDialog.this.selectedModelsList.setEnabled(false);
                    SelectExportDialog.this.subviewsList.setEnabled(false);
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(false);
                    SelectExportDialog.this.modelsFilter.setEnabled(false);
                    SelectExportDialog.this.subviewsFilter.setEnabled(false);
                    SelectExportDialog.this.isSelectedExportConfig = true;
                    SelectExportDialog.this.showDetails((ExpObject)SelectExportDialog.this.exportsModel.get(SelectExportDialog.this.exportsList.getSelectedIndex()));
                }
            }
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectExportDialog.this.txtName.getText().equals("")) {
                JOptionPane.showMessageDialog(SelectExportDialog.this, Messages.getString("SelectExportDialog.NameCanNotBeEmtpy"), Messages.getString("SelectExportDialog.Error"), 0);
                SelectExportDialog.this.txtName.requestFocus();
            } else {
                ExpObject ex = (ExpObject)SelectExportDialog.this.exportsModel.get(SelectExportDialog.this.exportsList.getSelectedIndex());
                String name = SelectExportDialog.this.txtName.getText();
                int counter = 0;
                while (SelectExportDialog.this.nameExistsForDesign(name, ex)) {
                    name = SelectExportDialog.this.txtName.getText().concat("_").concat(Integer.toString(++counter));
                }
                ex.setName(name);
                ex.setDescription(SelectExportDialog.this.txtDescription.getText());
                List sw = ex.getSubViews();
                sw.clear();
                for (Object obj : Arrays.asList(SelectExportDialog.this.selectedAllSubviewsListModel.toArray())) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)obj;
                    sw.add(ph.getObjectID());
                }
                List models = ex.getModels();
                models.clear();
                for (Object obj : Arrays.asList(SelectExportDialog.this.selectedModelsListModel.toArray())) {
                    DesignPart ph = (DesignPart)obj;
                    models.add(ph.getObjectID());
                }
                boolean found = false;
                for (ExpObject expObject : SelectExportDialog.this.allExportsList) {
                    if (!ex.getExportID().equals(expObject.getExportID()) || !ex.getDesignID().equals(expObject.getDesignID())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    SelectExportDialog.this.allExportsList.add(ex);
                }
                SelectExportDialog.this.exportsPersistence.saveExports();
                SelectExportDialog.this.txtName.setEnabled(false);
                SelectExportDialog.this.txtDescription.setEnabled(false);
                SelectExportDialog.this.modelsFilter.setEnabled(false);
                SelectExportDialog.this.modelsList.setEnabled(false);
                SelectExportDialog.this.selectedModelsList.setEnabled(false);
                SelectExportDialog.this.btnModelAdd.setEnabled(false);
                SelectExportDialog.this.btnModelRemove.setEnabled(false);
                SelectExportDialog.this.subviewsFilter.setEnabled(false);
                SelectExportDialog.this.subviewsList.setEnabled(false);
                SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(false);
                SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
                SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
                SelectExportDialog.this.modelsList.clearSelection();
                SelectExportDialog.this.selectedModelsList.clearSelection();
                SelectExportDialog.this.subviewsList.clearSelection();
                SelectExportDialog.this.selectedCurrentModelSubviewsList.clearSelection();
                SelectExportDialog.this.btnSave.setEnabled(false);
                SelectExportDialog.this.btnAdd.setEnabled(true);
                SelectExportDialog.this.btnEdit.setEnabled(true);
                SelectExportDialog.this.btnRemove.setEnabled(true);
                SelectExportDialog.this.exportsList.setEnabled(true);
                SelectExportDialog.this.manuallyClicked = true;
                SelectExportDialog.this.sortDMDExports(SelectExportDialog.this.exportsModel);
                SelectExportDialog.this.exportsList.setSelectedValue(ex, true);
                SelectExportDialog.this.showDetails(ex);
                SelectExportDialog.this.isSaved = true;
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExpObject ex = (ExpObject)SelectExportDialog.this.exportsModel.get(SelectExportDialog.this.exportsList.getSelectedIndex());
            int result = JOptionPane.showConfirmDialog(SelectExportDialog.this, MessageFormat.format(Messages.getString("SelectExportDialog.AreYouSure"), ex.getName()), Messages.getString("SelectExportDialog.SelectAnOption"), 0);
            if (result == 0) {
                SelectExportDialog.this.exportsModel.remove(SelectExportDialog.this.exportsList.getSelectedIndex());
                for (ExpObject ex0 : SelectExportDialog.this.allExportsList) {
                    if (!ex.getExportID().equals(ex0.getExportID())) continue;
                    SelectExportDialog.this.allExportsList.remove(ex0);
                    SelectExportDialog.this.exportsPersistence.saveExports();
                    break;
                }
                if (SelectExportDialog.this.exportsList.getModel().getSize() > 0) {
                    SelectExportDialog.this.exportsList.setSelectedIndex(0);
                }
            }
            SelectExportDialog.this.exportsList.setEnabled(true);
            SelectExportDialog.this.txtName.setEnabled(false);
            SelectExportDialog.this.txtDescription.setEnabled(false);
            SelectExportDialog.this.modelsFilter.setEnabled(false);
            SelectExportDialog.this.modelsList.setEnabled(false);
            SelectExportDialog.this.selectedModelsList.setEnabled(false);
            SelectExportDialog.this.btnModelAdd.setEnabled(false);
            SelectExportDialog.this.btnModelRemove.setEnabled(false);
            SelectExportDialog.this.subviewsFilter.setEnabled(false);
            SelectExportDialog.this.subviewsList.setEnabled(false);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(false);
            SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
            SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
            SelectExportDialog.this.btnSave.setEnabled(false);
            SelectExportDialog.this.btnAdd.setEnabled(true);
            SelectExportDialog.this.btnEdit.setEnabled(true);
            SelectExportDialog.this.btnRemove.setEnabled(true);
            SelectExportDialog.this.isSaved = true;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectExportDialog.this.txtDescription.setEnabled(true);
            SelectExportDialog.this.txtName.setEnabled(true);
            SelectExportDialog.this.exportsList.setEnabled(false);
            SelectExportDialog.this.modelsFilter.setEnabled(true);
            SelectExportDialog.this.modelsList.setEnabled(true);
            SelectExportDialog.this.selectedModelsList.setEnabled(true);
            SelectExportDialog.this.subviewsFilter.setEnabled(true);
            SelectExportDialog.this.subviewsList.setEnabled(true);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(true);
            SelectExportDialog.this.btnAdd.setEnabled(false);
            SelectExportDialog.this.btnEdit.setEnabled(false);
            SelectExportDialog.this.btnSave.setEnabled(true);
            SelectExportDialog.this.btnRemove.setEnabled(false);
            SelectExportDialog.this.selectedCurrentModelSubviewsModel.clear();
            SubViewsFilterModel subviewsFilterModel = (SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel();
            subviewsFilterModel.clear();
            SelectExportDialog.this.isSaved = false;
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = SelectExportDialog.this.generateName();
            ExpObject expObject = new ExpObject("", SelectExportDialog.this.getApplicationView().getCurrentDesign().getObjectID(), name, "", new ArrayList(), new ArrayList());
            SelectExportDialog.this.exportsModel.addElement(expObject);
            SelectExportDialog.this.exportsList.setSelectedValue(expObject, true);
            SelectExportDialog.this.manuallyClicked = true;
            SelectExportDialog.this.exportsList.setEnabled(false);
            SelectExportDialog.this.txtName.setText(name);
            SelectExportDialog.this.txtName.setEnabled(true);
            SelectExportDialog.this.txtDescription.setText("");
            SelectExportDialog.this.txtDescription.setEnabled(true);
            SelectExportDialog.this.modelsFilter.setEnabled(true);
            SelectExportDialog.this.modelsList.setEnabled(true);
            SelectExportDialog.this.selectedModelsList.setEnabled(true);
            SelectExportDialog.this.subviewsFilter.setEnabled(true);
            SelectExportDialog.this.subviewsList.setEnabled(true);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(true);
            SelectExportDialog.this.btnAdd.setEnabled(false);
            SelectExportDialog.this.btnEdit.setEnabled(false);
            SelectExportDialog.this.btnRemove.setEnabled(true);
            SelectExportDialog.this.btnSave.setEnabled(true);
            SelectExportDialog.this.isSaved = false;
        }
    }
}

