/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SelectTypeDialog
extends CustomDialog {
    private static final String dialogName = Messages.getString("SelectTypeDialog.SetClassificationTypes");
    private final List allTypes = new ArrayList();
    private final List allContainers = new ArrayList();
    private final JButton buttonOK;
    private final JButton buttonApply;
    private final JButton buttonCancel;
    private final JButton buttonHelp;
    private JButton buttonAdd;
    private JButton buttonRemove;
    private final JPanel generalPanel;
    private final JPanel leftPanel;
    private final JPanel rightPanel;
    private JPanel containerItem;
    private JPanel selectedItem;
    private JDialog dialog;
    private List containerList;
    private JTable eTable;
    private ListSelectionListener tableListSelectionListener;
    private FilteredSelectedElementsJList selectedList;
    private JList typeList;
    private DefaultListModel typeModel;
    private JSearchTextField filterBox;
    private JTextField selectedElementsFilter;
    private List currentNonSelectedElementsList = new ArrayList();
    private ToStringComparator toStringComparator = new ToStringComparator();
    private TableRowSorter<ElementsModel> allObjectsSorter;
    private static final Logger LOGGER = new Logger(SelectTypeDialog.class);

    public SelectTypeDialog(ApplicationView applView, Object[] containers, String elementsName) {
        super(applView);
        this.generalPanel = new JPanel(new BorderLayout());
        this.allTypes.addAll(this.getDesign().getDesignLevelSettings().getClassificationTypeList());
        for (int i = 0; i < containers.length; ++i) {
            ContainerWithKeyObject object = (ContainerWithKeyObject)containers[i];
            if (object.isRemoteObject()) continue;
            this.allContainers.add(new ContainerType(object));
        }
        this.leftPanel = new JPanel(new BorderLayout());
        this.leftPanel.setPreferredSize(new Dimension(380, 510));
        this.initContainerList(this.leftPanel, elementsName);
        this.rightPanel = new JPanel(new BorderLayout());
        this.initTypeList(this.rightPanel);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        this.buttonOK = new JButton(this.createButtonOK());
        this.buttonOK.setMnemonic(79);
        this.buttonApply = new JButton(this.createButtonApply());
        this.buttonApply.setMnemonic(65);
        this.buttonCancel = new JButton(this.createCancelButton());
        this.buttonCancel.setMnemonic(67);
        this.buttonHelp = new JButton(this.getHelpAction());
        this.buttonHelp.setMnemonic(72);
        buttonsPanel.add(this.buttonOK);
        buttonsPanel.add(this.buttonApply);
        buttonsPanel.add(this.buttonCancel);
        buttonsPanel.add(this.buttonHelp);
        this.buttonOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.generalPanel.add((Component)this.leftPanel, "West");
        this.generalPanel.add((Component)this.rightPanel, "Center");
        this.generalPanel.add((Component)buttonsPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.fillTypeList();
        this.generalPanel.setPreferredSize(new Dimension(600, 510));
        this.typeList.setSelectedIndex(0);
        if (this.allContainers.size() > 0) {
            this.filterBox.setEnabled(true);
        }
    }

    public void fillTypeList() {
        Iterator it = this.allTypes.iterator();
        while (it.hasNext()) {
            this.typeModel.addElement(it.next());
        }
    }

    private void initContainerList(JPanel panel, String elementsName) {
        this.containerItem = new JPanel(new BorderLayout());
        this.initElementList(elementsName);
        this.initAddRemoveButtons();
        panel.add(this.containerItem);
    }

    private void initElementList(String elementsName) {
        JPanel elementList = new JPanel(new BorderLayout());
        elementList.setBorder(BorderFactory.createTitledBorder(elementsName));
        this.containerList = new ArrayList();
        this.eTable = new JTable(new ElementsModel());
        this.eTable.getTableHeader().setReorderingAllowed(false);
        TableColumn col0 = this.eTable.getColumnModel().getColumn(0);
        col0.setMinWidth(50);
        TableColumn col1 = this.eTable.getColumnModel().getColumn(1);
        col1.setMinWidth(50);
        this.tableListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (SelectTypeDialog.this.eTable.getSelectedRowCount() > 0) {
                        SelectTypeDialog.this.buttonAdd.setEnabled(true);
                    } else {
                        SelectTypeDialog.this.buttonAdd.setEnabled(false);
                    }
                }
            }
        };
        this.eTable.getSelectionModel().addListSelectionListener(this.tableListSelectionListener);
        this.allObjectsSorter = new TableRowSorter<TableModel>(this.eTable.getModel());
        this.allObjectsSorter.setSortsOnUpdates(true);
        JScrollPane scrollPane = new JScrollPane(this.eTable);
        scrollPane.setPreferredSize(new Dimension(250, 250));
        JPanel fp = new JPanel(new FlowLayout(0));
        fp.setPreferredSize(new Dimension(200, 30));
        this.filterBox = new JSearchTextField(false, true, Messages.getString("SelectTypeDialog.Name"));
        this.filterBox.setEnabled(false);
        this.filterBox.setPreferredSize(new Dimension(200, 20));
        this.filterBox.getDocument().addDocumentListener(new FilterListener());
        fp.add(this.filterBox);
        elementList.add((Component)fp, "North");
        elementList.add((Component)scrollPane, "Center");
        this.containerItem.add((Component)elementList, "Center");
    }

    private void initTypeList(JPanel panel) {
        this.selectedItem = new JPanel(new BorderLayout());
        this.typeModel = new DefaultListModel();
        this.initType();
        this.initSelected();
        panel.add(this.selectedItem);
    }

    private void initType() {
        JPanel typePanel = new JPanel(new BorderLayout());
        this.typeList = new JList(this.typeModel);
        ListSelectionModel selectionModel = this.typeList.getSelectionModel();
        selectionModel.addListSelectionListener(new TypeListener());
        JScrollPane pane = new JScrollPane(this.typeList);
        pane.setPreferredSize(new Dimension(280, 180));
        typePanel.add(pane);
        typePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectTypeDialog.ClassificationTypes")));
        this.selectedItem.add((Component)typePanel, "North");
    }

    private void initSelected() {
        JPanel itemsPanel = new JPanel(new BorderLayout());
        JPanel fp = new JPanel(new FlowLayout(0));
        fp.setPreferredSize(new Dimension(200, 30));
        this.selectedElementsFilter = new JSearchTextField(false, true, Messages.getString("SelectTypeDialog.Name"));
        this.selectedElementsFilter.setEnabled(false);
        this.selectedElementsFilter.setPreferredSize(new Dimension(200, 20));
        this.selectedElementsFilter.getDocument().addDocumentListener(new SelectedElementsFilterListener());
        fp.add(this.selectedElementsFilter);
        this.selectedList = new FilteredSelectedElementsJList();
        ListSelectionModel selectListener = this.selectedList.getSelectionModel();
        selectListener.addListSelectionListener(new SelectListener());
        JScrollPane scrollPane = new JScrollPane(this.selectedList);
        scrollPane.setPreferredSize(new Dimension(280, 225));
        itemsPanel.add((Component)fp, "North");
        itemsPanel.add((Component)scrollPane, "Center");
        itemsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectTypeDialog.SelectedElements")));
        this.selectedItem.add((Component)itemsPanel, "South");
    }

    private void initAddRemoveButtons() {
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1));
        JPanel jp1 = new JPanel();
        JPanel jpButtons = new JPanel(new BorderLayout());
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.buttonAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonAdd.addActionListener(new AddObjectActionListener());
        this.buttonAdd.setEnabled(false);
        this.buttonAdd.setToolTipText(Messages.getString("SelectTypeDialog.Add"));
        this.buttonRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonRemove.setToolTipText(Messages.getString("SelectTypeDialog.Remove"));
        this.buttonAdd.setPreferredSize(new Dimension(32, 32));
        this.buttonRemove.setPreferredSize(this.buttonAdd.getPreferredSize());
        jpButtons.add((Component)this.buttonAdd, "North");
        jpButtons.add((Component)this.buttonRemove, "Center");
        jp1.add(jpButtons);
        buttonPanel.add(new JPanel());
        buttonPanel.add(new JPanel());
        buttonPanel.add(jp1);
        buttonPanel.add(new JPanel());
        this.containerItem.add((Component)buttonPanel, "East");
    }

    @Override
    protected String getHelpIndex() {
        return "CLASSIFICATION_TYPES_DIALOG";
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), dialogName, false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.buttonOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectTypeDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTypeDialog.this.close();
            }
        };
        return action;
    }

    public Action createButtonApply() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectTypeDialog.Apply")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTypeDialog.this.setType();
            }
        };
        return action;
    }

    public Action createButtonOK() {
        AbstractAction action = new AbstractAction(Messages.getString("SelectTypeDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectTypeDialog.this.setType();
                SelectTypeDialog.this.close();
            }
        };
        return action;
    }

    public void setType() {
        for (int i = 0; i < this.allContainers.size(); ++i) {
            ContainerType selObject = (ContainerType)this.allContainers.get(i);
            selObject.applyType();
        }
        try {
            if (this.getApplicationView().getCurrentDPV() != null) {
                this.getApplicationView().getCurrentDPV().getWorkSpace().updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getSelectedType() {
        return ((ClassificationType)this.typeList.getSelectedValue()).getTypeName();
    }

    private void newFilter() {
        block5: {
            try {
                RowFilter rf = null;
                if (this.containerList.size() <= 0) break block5;
                if (!"".equals(this.filterBox.getText())) {
                    try {
                        rf = RowFilter.regexFilter("(?i)" + this.filterBox.getText(), this.eTable.convertColumnIndexToModel(0));
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                    ((DefaultRowSorter)this.eTable.getRowSorter()).setRowFilter(rf);
                    break block5;
                }
                ((DefaultRowSorter)this.eTable.getRowSorter()).setRowFilter(null);
                this.eTable.clearSelection();
            }
            catch (Exception ex) {
                LOGGER.error("SelectTypeDialog.newFilter:  " + ex);
            }
        }
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private class SelectedElementsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SelectTypeDialog.this.currentNonSelectedElementsList.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
            Collections.sort(this.filterItems, SelectTypeDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SelectTypeDialog.this.currentNonSelectedElementsList.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SelectTypeDialog.this.selectedElementsFilter.getText();
            for (int i = 0; i < SelectTypeDialog.this.currentNonSelectedElementsList.size(); ++i) {
                String name = "";
                name = ((ContainerType)SelectTypeDialog.this.currentNonSelectedElementsList.get(i)).getContainerObject().getName();
                if (SelectTypeDialog.match(name, term)) {
                    this.filterItems.add(SelectTypeDialog.this.currentNonSelectedElementsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SelectTypeDialog.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, SelectTypeDialog.this.toStringComparator);
            SelectTypeDialog.this.currentNonSelectedElementsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SelectTypeDialog.this.currentNonSelectedElementsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    private class SelectedElementsFilterListener
    implements DocumentListener {
        private SelectedElementsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).refilter();
        }
    }

    class FilteredSelectedElementsJList
    extends JList {
        public FilteredSelectedElementsJList() {
            this.setModel((ListModel)new SelectedElementsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof SelectedElementsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class FilterListener
    implements DocumentListener {
        private FilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            SelectTypeDialog.this.newFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            SelectTypeDialog.this.newFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            SelectTypeDialog.this.newFilter();
        }
    }

    private class ContainerType {
        private ContainerWithKeyObject containerObject;
        private String classTypeName = "";
        private ClassificationType classType = null;

        public ContainerType(ContainerWithKeyObject obj) {
            this.containerObject = obj;
            this.classTypeName = SelectTypeDialog.this.getDesign().getDesignLevelSettings().getClassificationTypeNameByID(this.containerObject.getTypeID());
        }

        public ContainerWithKeyObject getContainerObject() {
            return this.containerObject;
        }

        public String getClassTypeName() {
            return this.classTypeName;
        }

        public void setClassTypeName(String typeName) {
            this.classTypeName = typeName;
        }

        public String toString() {
            return this.containerObject.getName();
        }

        public void applyType() {
            this.classType = SelectTypeDialog.this.getDesign().getDesignLevelSettings().getClassificationTypeByName(this.classTypeName);
            if (this.classType != null) {
                this.containerObject.setTypeID(this.classType.getTypeID());
                this.containerObject.setDirty(true);
            }
        }
    }

    private class TypeListener
    implements ListSelectionListener {
        private TypeListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                SelectTypeDialog.this.eTable.setRowSorter(null);
                SelectTypeDialog.this.eTable.setAutoCreateRowSorter(false);
                SelectTypeDialog.this.filterBox.setText("");
                SelectTypeDialog.this.selectedList.clearSelection();
                SelectTypeDialog.this.selectedElementsFilter.setText("");
                ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).clear();
                SelectTypeDialog.this.eTable.clearSelection();
                ElementsModel tableModel = (ElementsModel)SelectTypeDialog.this.eTable.getModel();
                tableModel.clear();
                Iterator it = SelectTypeDialog.this.allContainers.iterator();
                if (SelectTypeDialog.this.typeList.getSelectedIndex() != -1) {
                    while (it.hasNext()) {
                        ContainerType object = (ContainerType)it.next();
                        if (object.getClassTypeName().equals(SelectTypeDialog.this.getSelectedType())) {
                            ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).add(object);
                            continue;
                        }
                        tableModel.addRow(object);
                    }
                } else {
                    SelectTypeDialog.this.buttonAdd.setEnabled(false);
                    SelectTypeDialog.this.buttonRemove.setEnabled(false);
                    SelectTypeDialog.this.eTable.clearSelection();
                    while (it.hasNext()) {
                        tableModel.addRow(it.next());
                    }
                }
                if (((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).getSize() > 0) {
                    SelectTypeDialog.this.selectedElementsFilter.setEnabled(true);
                } else {
                    SelectTypeDialog.this.selectedElementsFilter.setEnabled(false);
                }
                SelectTypeDialog.this.eTable.updateUI();
                SelectTypeDialog.this.eTable.clearSelection();
                SelectTypeDialog.this.buttonAdd.setEnabled(false);
                if (SelectTypeDialog.this.containerList.size() > 0) {
                    SelectTypeDialog.this.eTable.setRowSorter(SelectTypeDialog.this.allObjectsSorter);
                    SelectTypeDialog.this.eTable.setAutoCreateRowSorter(true);
                    WindowsTableHeader.setSortedHeader(SelectTypeDialog.this.eTable, 0);
                    SelectTypeDialog.this.eTable.setRowSelectionInterval(0, 0);
                }
            }
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object[] selectedObject = SelectTypeDialog.this.selectedList.getSelectedValues();
                if (selectedObject.length > 0) {
                    for (int i = 0; i < selectedObject.length; ++i) {
                        ContainerType obj = (ContainerType)selectedObject[i];
                        if (SelectTypeDialog.this.containerList.contains(obj)) continue;
                        ((ElementsModel)SelectTypeDialog.this.eTable.getModel()).addRow(obj);
                        ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).remove(obj);
                        obj.setClassTypeName("");
                        obj.getContainerObject().setTypeID("");
                    }
                    SelectTypeDialog.this.eTable.updateUI();
                    SelectTypeDialog.this.eTable.clearSelection();
                    SelectTypeDialog.this.newFilter();
                    if (((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).getSize() > 0) {
                        SelectTypeDialog.this.selectedElementsFilter.setEnabled(true);
                    } else {
                        SelectTypeDialog.this.selectedElementsFilter.setEnabled(false);
                    }
                    if (SelectTypeDialog.this.containerList.size() > 0) {
                        SelectTypeDialog.this.eTable.setRowSorter(SelectTypeDialog.this.allObjectsSorter);
                        SelectTypeDialog.this.eTable.setAutoCreateRowSorter(true);
                        WindowsTableHeader.setSortedHeader(SelectTypeDialog.this.eTable, 0);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("SelectTypeDialog.RemoveObjectActionListener:  " + ex);
            }
        }
    }

    private class AddObjectActionListener
    implements ActionListener {
        private AddObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int[] selected = SelectTypeDialog.this.eTable.getSelectedRows();
                if (selected.length > 0 && SelectTypeDialog.this.getSelectedType() != null) {
                    SelectTypeDialog.this.selectedList.setSelectedIndex(-1);
                    for (int i = selected.length - 1; i >= 0; --i) {
                        ContainerType obj = (ContainerType)SelectTypeDialog.this.containerList.get(SelectTypeDialog.this.eTable.convertRowIndexToModel(selected[i]));
                        if (((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).contains(obj)) continue;
                        ((SelectedElementsFilterModel)SelectTypeDialog.this.selectedList.getModel()).add(obj);
                        ((ElementsModel)SelectTypeDialog.this.eTable.getModel()).removeRow(SelectTypeDialog.this.eTable.convertRowIndexToModel(selected[i]));
                        obj.setClassTypeName(SelectTypeDialog.this.getSelectedType());
                        SelectTypeDialog.this.selectedList.setSelectedValue(obj, true);
                        SelectTypeDialog.this.selectedElementsFilter.setEnabled(true);
                    }
                    SelectTypeDialog.this.eTable.updateUI();
                    SelectTypeDialog.this.newFilter();
                    if (SelectTypeDialog.this.containerList.size() == 0) {
                        SelectTypeDialog.this.eTable.setAutoCreateRowSorter(false);
                        SelectTypeDialog.this.eTable.setRowSorter(null);
                        SelectTypeDialog.this.buttonAdd.setEnabled(false);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("SelectTypeDialog.AddObjectActionListener:  " + ex);
            }
        }
    }

    private class SelectListener
    implements ListSelectionListener {
        private SelectListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectTypeDialog.this.selectedList.getSelectedIndices().length > 0) {
                    SelectTypeDialog.this.buttonRemove.setEnabled(true);
                } else {
                    SelectTypeDialog.this.buttonRemove.setEnabled(false);
                }
            }
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SelectTypeDialog.this.containerList.size();
        }

        public void removeRow(int row) {
            SelectTypeDialog.this.containerList.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void addRow(Object obj) {
            SelectTypeDialog.this.containerList.add(obj);
            this.fireTableRowsInserted(SelectTypeDialog.this.containerList.size() - 1, SelectTypeDialog.this.containerList.size() - 1);
        }

        public void clear() {
            int rows = this.getRowCount();
            if (rows == 0) {
                return;
            }
            SelectTypeDialog.this.containerList.clear();
            this.fireTableRowsDeleted(0, rows - 1);
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SelectTypeDialog.Name");
            }
            if (column == 1) {
                return Messages.getString("SelectTypeDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainerType ct = (ContainerType)SelectTypeDialog.this.containerList.get(row);
            if (col == 0) {
                return ct.toString();
            }
            if (col == 1) {
                return ct.getClassTypeName();
            }
            return new Integer(row * col);
        }
    }
}

