/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignUtilities;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractModelIDObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.SensitiveTypeUsedInDialog;

public class SensitiveTypePropertiesDialog
extends AbstractModelIDObjectPropertiesDialog {
    private SensitiveType sensitiveType;
    protected JTextArea taDescription;
    private JPanel pnDescription;
    private JPanel pnUsedIn;
    private List<DesignUtilities.AttributeRef> usedInAttributesList;
    private List<DesignUtilities.ColumnRef> usedInColumnsList;
    private List<Domain> usedInDomainsList;
    private JPanel pnAttributes;
    private JPanel pnColumns;
    private JPanel pnDomains;
    protected JTable attrTable;
    protected JTable columnsTable;
    protected JTable domainsTable;
    protected JTabbedPane tabbedPaneUsedIn;
    private JCheckBox chGenerateInDDL;
    private JCheckBox chEnable;
    private Design design;

    public SensitiveTypePropertiesDialog(ApplicationView view, ModelIDObject object, Design design) {
        super(view, object);
        this.design = design;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SensitiveTypePropertiesDialog.SensitiveTypeProperties");
    }

    private void initGeneral() {
        JLabel lbGenerateInDDL = new JLabel(LB_GENERATE_IN_DDL);
        lbGenerateInDDL.setPreferredSize(this.getDefaultSize());
        this.chGenerateInDDL = new JCheckBox();
        this.chGenerateInDDL.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbGenerateInDDL, this.chGenerateInDDL));
        JLabel lbEnable = new JLabel(LB_ENABLE);
        lbEnable.setPreferredSize(this.getDefaultSize());
        this.chEnable = new JCheckBox();
        this.chEnable.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbEnable, this.chEnable));
    }

    @Override
    public void initProperties(ModelIDObject object) {
        if (object instanceof SensitiveType) {
            this.sensitiveType = (SensitiveType)object;
            this.tfName.setText(this.sensitiveType.getName());
            this.taDescription.setText(this.sensitiveType.getDescription());
            this.taComments.setText(this.sensitiveType.getComment());
            this.taNotes.setText(this.sensitiveType.getNotes());
            this.tfObjectID.setText(this.sensitiveType.getObjectID());
            this.tfCreationTime.setText(this.sensitiveType.getCreationTime());
            this.tfCreator.setText(this.sensitiveType.getCreator().getName());
            this.tfDesign.setText(this.sensitiveType.getOwnerDesignName());
            this.tfGeneratorName.setText(NONE);
            this.tfLastChangedBy.setText(this.sensitiveType.getChanger().getName());
            this.tfLastChangedTime.setText(this.sensitiveType.getChangeTime());
            this.chGenerateInDDL.setSelected(this.sensitiveType.getGenerateInDDL());
            this.chEnable.setSelected(this.sensitiveType.isEnable());
            this.initUsedIn();
        }
    }

    @Override
    protected void setProperties() {
        this.sensitiveType.setName(this.tfName.getText());
        this.sensitiveType.setDescription(this.taDescription.getText());
        this.sensitiveType.setComment(this.taComments.getText());
        this.sensitiveType.setNotes(this.taNotes.getText());
        this.sensitiveType.setGenerateInDDL(this.chGenerateInDDL.isSelected());
        this.sensitiveType.setEnable(this.chEnable.isSelected());
        this.getAppView().saveSensitiveTypes();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getUsedInPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    protected JPanel getDescriptionPanel() {
        if (this.pnDescription == null) {
            this.pnDescription = this.createPage(Messages.getString("AbstractPropertiesDialog.Description"));
            this.taDescription = new JTextArea();
            this.taDescription.setEditable(this.isEditable());
            this.taDescription.setLineWrap(true);
            this.taDescription.setWrapStyleWord(true);
            this.pnDescription.add(new JScrollPane(this.taDescription));
        }
        return this.pnDescription;
    }

    @Override
    protected JPanel getUsedInPanel() {
        if (this.pnUsedIn == null) {
            this.pnUsedIn = this.createPage(Messages.getString("AbstractDatatypePropertiesDialog.UsedIn"));
            this.taUsedIn = new JTextArea();
            this.taUsedIn.setEnabled(super.isEditable());
            this.pnUsedIn.add(new JScrollPane(this.taUsedIn));
            this.usedInAttributesList = new ArrayList<DesignUtilities.AttributeRef>();
            this.usedInColumnsList = new ArrayList<DesignUtilities.ColumnRef>();
            this.usedInDomainsList = new ArrayList<Domain>();
            this.pnAttributes = this.initAttributesPanel();
            this.pnColumns = this.initColumnsPanel();
            this.pnDomains = this.initDomainsPanel();
            this.tabbedPaneUsedIn = new JTabbedPane();
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.Attributes"), this.pnAttributes);
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractDatatypePropertiesDialog.Columns"), this.pnColumns);
            this.tabbedPaneUsedIn.addTab(Messages.getString("AbstractEditorConstants.Domains"), this.pnDomains);
            this.pnUsedIn.add(this.tabbedPaneUsedIn);
        }
        return this.pnUsedIn;
    }

    public JPanel initAttributesPanel() {
        this.attrTable = new JTable(new AttributeTableModel());
        MouseAdapter tableMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = SensitiveTypePropertiesDialog.this.attrTable.getSelectedColumn();
                    int row = SensitiveTypePropertiesDialog.this.attrTable.getSelectedRow();
                    if (row != -1 && SensitiveTypePropertiesDialog.this.usedInAttributesList.size() > 0 && row < SensitiveTypePropertiesDialog.this.usedInAttributesList.size()) {
                        DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)SensitiveTypePropertiesDialog.this.usedInAttributesList.get(row);
                        if (col == 0) {
                            Entity attrEntity = attrDomain.getEntity();
                            if (!attrEntity.isDialogVisible()) {
                                attrEntity.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                                attrEntity.showPropertyDialog();
                            }
                        } else {
                            Attribute attr = attrDomain.getAttribute();
                            if (!attr.isDialogVisible()) {
                                attr.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                                attr.showPropertyDialog();
                            }
                        }
                    }
                }
            }
        };
        ActionListener propertiesButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int column = SensitiveTypePropertiesDialog.this.attrTable.getSelectedColumn();
                int row = SensitiveTypePropertiesDialog.this.attrTable.getSelectedRow();
                if (row != -1 && SensitiveTypePropertiesDialog.this.usedInAttributesList.size() > 0 && row < SensitiveTypePropertiesDialog.this.usedInAttributesList.size()) {
                    int icol = SensitiveTypePropertiesDialog.this.attrTable.getEditingColumn();
                    int irow = SensitiveTypePropertiesDialog.this.attrTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        SensitiveTypePropertiesDialog.this.attrTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)SensitiveTypePropertiesDialog.this.usedInAttributesList.get(row);
                    if (column == 0) {
                        Entity ent = attrDomain.getEntity();
                        if (!ent.isDialogVisible()) {
                            ent.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                            ent.showPropertyDialog();
                        }
                    } else {
                        Attribute attr = attrDomain.getAttribute();
                        if (!attr.isDialogVisible()) {
                            attr.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                            attr.showPropertyDialog();
                        }
                    }
                }
            }
        };
        return this.createUsedInPanel(this.attrTable, tableMouseAdapter, propertiesButtonActionListener);
    }

    public JPanel initColumnsPanel() {
        this.columnsTable = new JTable(new ColumnTableModel());
        MouseAdapter tableMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = SensitiveTypePropertiesDialog.this.columnsTable.getSelectedColumn();
                    int row = SensitiveTypePropertiesDialog.this.columnsTable.getSelectedRow();
                    if (row != -1 && SensitiveTypePropertiesDialog.this.usedInColumnsList.size() > 0 && row < SensitiveTypePropertiesDialog.this.usedInColumnsList.size()) {
                        DesignUtilities.ColumnRef colDomain = (DesignUtilities.ColumnRef)SensitiveTypePropertiesDialog.this.usedInColumnsList.get(row);
                        if (col == 0) {
                            RelationalDesign model = colDomain.getModel();
                            if (!model.isDialogVisible()) {
                                model.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                                model.showPropertyDialog();
                            }
                        } else if (col == 1) {
                            Table tbl = colDomain.getTable();
                            if (!tbl.isDialogVisible()) {
                                tbl.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                                tbl.showPropertyDialog();
                            }
                        } else {
                            Column clm = colDomain.getColumn();
                            if (!clm.isDialogVisible()) {
                                clm.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                                clm.showPropertyDialog();
                            }
                        }
                    }
                }
            }
        };
        ActionListener propertiesButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = SensitiveTypePropertiesDialog.this.columnsTable.getSelectedColumn();
                int row = SensitiveTypePropertiesDialog.this.columnsTable.getSelectedRow();
                if (row != -1 && SensitiveTypePropertiesDialog.this.usedInColumnsList.size() > 0 && row < SensitiveTypePropertiesDialog.this.usedInColumnsList.size()) {
                    int icol = SensitiveTypePropertiesDialog.this.columnsTable.getEditingColumn();
                    int irow = SensitiveTypePropertiesDialog.this.columnsTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        SensitiveTypePropertiesDialog.this.columnsTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    DesignUtilities.ColumnRef colDomain = (DesignUtilities.ColumnRef)SensitiveTypePropertiesDialog.this.usedInColumnsList.get(row);
                    if (col == 0) {
                        RelationalDesign model = colDomain.getModel();
                        if (!model.isDialogVisible()) {
                            model.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                            model.showPropertyDialog();
                        }
                    } else if (col == 1) {
                        Table tbl = colDomain.getTable();
                        if (!tbl.isDialogVisible()) {
                            tbl.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                            tbl.showPropertyDialog();
                        }
                    } else {
                        Column clm = colDomain.getColumn();
                        if (!clm.isDialogVisible()) {
                            clm.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                            clm.showPropertyDialog();
                        }
                    }
                }
            }
        };
        return this.createUsedInPanel(this.columnsTable, tableMouseAdapter, propertiesButtonActionListener);
    }

    public JPanel initDomainsPanel() {
        this.domainsTable = new JTable(new DomainTableModel());
        MouseAdapter tableMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Domain domain;
                int row;
                if (e.getClickCount() == 2 && (row = SensitiveTypePropertiesDialog.this.domainsTable.getSelectedRow()) != -1 && SensitiveTypePropertiesDialog.this.usedInDomainsList.size() > 0 && row < SensitiveTypePropertiesDialog.this.usedInDomainsList.size() && !(domain = (Domain)SensitiveTypePropertiesDialog.this.usedInDomainsList.get(row)).isDialogVisible()) {
                    domain.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                    domain.showPropertyDialog();
                }
            }
        };
        ActionListener propertiesButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = SensitiveTypePropertiesDialog.this.domainsTable.getSelectedRow();
                if (row != -1 && SensitiveTypePropertiesDialog.this.usedInDomainsList.size() > 0 && row < SensitiveTypePropertiesDialog.this.usedInDomainsList.size()) {
                    Domain domain;
                    int icol = SensitiveTypePropertiesDialog.this.domainsTable.getEditingColumn();
                    int irow = SensitiveTypePropertiesDialog.this.domainsTable.getEditingRow();
                    if (icol > -1 && irow > -1) {
                        SensitiveTypePropertiesDialog.this.domainsTable.getCellEditor(irow, icol).stopCellEditing();
                    }
                    if (!(domain = (Domain)SensitiveTypePropertiesDialog.this.usedInDomainsList.get(row)).isDialogVisible()) {
                        domain.showModal = ((SensitiveTypePropertiesDialog)SensitiveTypePropertiesDialog.this).sensitiveType.showModal;
                        domain.showPropertyDialog();
                    }
                }
            }
        };
        return this.createUsedInPanel(this.domainsTable, tableMouseAdapter, propertiesButtonActionListener, null, null);
    }

    public JPanel createUsedInPanel(final JTable table, MouseAdapter tableMouseAdapter, ActionListener propertiesButtonActionListener, ActionListener addButtonActionListener, ActionListener removeButtonActionListener) {
        JPanel result = new JPanel(new BorderLayout());
        table.setSelectionMode(0);
        table.addMouseListener(tableMouseAdapter);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(BTN_PROPERTIES);
        btnProperties.addActionListener(propertiesButtonActionListener);
        toolBar.add(btnProperties);
        btnProperties.setEnabled(false);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                btnProperties.setEnabled(table.getSelectedRow() > -1);
            }
        });
        if (super.isEditable() && addButtonActionListener != null) {
            JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            btnAdd.setToolTipText(BTN_ADD);
            btnAdd.addActionListener(addButtonActionListener);
            toolBar.add(btnAdd);
        }
        if (super.isEditable() && removeButtonActionListener != null) {
            JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            btnRemove.setToolTipText(BTN_REMOVE);
            btnRemove.addActionListener(removeButtonActionListener);
            toolBar.add(btnRemove);
        }
        buttonPanel.add(toolBar);
        JPanel attrPanel = new JPanel(new BorderLayout());
        attrPanel.add((Component)buttonPanel, "North");
        attrPanel.add(new JScrollPane(table));
        result.add(attrPanel);
        return result;
    }

    protected void initUsedIn() {
        this.usedInAttributesList.clear();
        this.usedInColumnsList.clear();
        this.usedInDomainsList.clear();
        Iterator it = this.getAppView().getDesigns().iterator();
        while (it.hasNext()) {
            Design design = (Design)it.next();
            if (design != this.design) continue;
            Iterator it2 = design.getRelationalDesigns().iterator();
            while (it2.hasNext()) {
                RelationalDesign relationalDesign = (RelationalDesign)it2.next();
                Iterator iter = relationalDesign.getTableSet().iterator();
                while (iter.hasNext()) {
                    Table colTable = (Table)iter.next();
                    ContainedObject[] columns = colTable.getElements();
                    for (int i = 0; i < columns.length; ++i) {
                        Column col = (Column)columns[i];
                        if (col.getSensitiveType() != this.sensitiveType) continue;
                        this.usedInColumnsList.add(new DesignUtilities.ColumnRef(relationalDesign, colTable, col));
                    }
                }
            }
            it2 = design.getLogicalDesign().getEntitySet().iterator();
            while (it2.hasNext()) {
                Entity attrEntity = (Entity)it2.next();
                ContainedObject[] attributes = attrEntity.getElements();
                for (int i = 0; i < attributes.length; ++i) {
                    Attribute attr = (Attribute)attributes[i];
                    if (attr.getSensitiveType() != this.sensitiveType) continue;
                    this.usedInAttributesList.add(new DesignUtilities.AttributeRef(attrEntity, attr));
                }
            }
            it2 = design.getDomainSet().iterator();
            while (it2.hasNext()) {
                Domain domain = (Domain)it2.next();
                if (domain.getSensitiveType() != this.sensitiveType) continue;
                this.usedInDomainsList.add(domain);
            }
        }
    }

    public JPanel createUsedInPanel(JTable table, MouseAdapter tableMouseAdapter, ActionListener propertiesButtonActionListener) {
        return this.createUsedInPanel(table, tableMouseAdapter, propertiesButtonActionListener, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new SensitiveTypeUsedInDialog(SensitiveTypePropertiesDialog.this.getAppView(), SensitiveTypePropertiesDialog.this.sensitiveType, SensitiveTypePropertiesDialog.this.design).showDialog();
                SensitiveTypePropertiesDialog.this.initUsedIn();
                SensitiveTypePropertiesDialog.this.attrTable.updateUI();
                SensitiveTypePropertiesDialog.this.columnsTable.updateUI();
                SensitiveTypePropertiesDialog.this.domainsTable.updateUI();
            }
        }, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SensitiveTypePropertiesDialog.this.tabbedPaneUsedIn.getSelectedIndex() == 0) {
                    DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)SensitiveTypePropertiesDialog.this.usedInAttributesList.get(SensitiveTypePropertiesDialog.this.attrTable.getSelectedRow());
                    SensitiveTypePropertiesDialog.this.usedInAttributesList.remove(attrDomain);
                    SensitiveTypePropertiesDialog.this.attrTable.updateUI();
                    Attribute attr = attrDomain.getAttribute();
                    attr.setSensitiveType(null);
                    attr.setDirty(true);
                } else if (SensitiveTypePropertiesDialog.this.tabbedPaneUsedIn.getSelectedIndex() == 1) {
                    DesignUtilities.ColumnRef attrDomain = (DesignUtilities.ColumnRef)SensitiveTypePropertiesDialog.this.usedInColumnsList.get(SensitiveTypePropertiesDialog.this.columnsTable.getSelectedRow());
                    SensitiveTypePropertiesDialog.this.usedInColumnsList.remove(attrDomain);
                    SensitiveTypePropertiesDialog.this.columnsTable.updateUI();
                    Column col = attrDomain.getColumn();
                    col.setSensitiveType(null);
                    col.setDirty(true);
                }
            }
        });
    }

    @Override
    protected String getHelpIndex() {
        return "SENSITIVE_TYPE_PROPERTIES_DIALOG";
    }

    class DomainTableModel
    extends UsedInObjectModel {
        DomainTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return SensitiveTypePropertiesDialog.this.usedInDomainsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return Messages.getString("AbstractEditorConstants.Domain");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Domain domain = (Domain)SensitiveTypePropertiesDialog.this.usedInDomainsList.get(rowIndex);
            if (columnIndex == 0) {
                return domain.getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class ColumnTableModel
    extends UsedInObjectModel {
        ColumnTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return SensitiveTypePropertiesDialog.this.usedInColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Model");
            }
            if (column == 1) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Table");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Column");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignUtilities.ColumnRef columnDomain = (DesignUtilities.ColumnRef)SensitiveTypePropertiesDialog.this.usedInColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return columnDomain.getModel().getName();
            }
            if (columnIndex == 1) {
                return columnDomain.getTable().getName();
            }
            if (columnIndex == 2) {
                return columnDomain.getColumn().getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    class AttributeTableModel
    extends UsedInObjectModel {
        AttributeTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SensitiveTypePropertiesDialog.this.usedInAttributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AbstractDatatypePropertiesDialog.Entity");
            }
            return Messages.getString("AbstractDatatypePropertiesDialog.Attribute");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DesignUtilities.AttributeRef attrDomain = (DesignUtilities.AttributeRef)SensitiveTypePropertiesDialog.this.usedInAttributesList.get(rowIndex);
            if (columnIndex == 0) {
                return attrDomain.getEntity().getName();
            }
            if (columnIndex == 1) {
                return attrDomain.getAttribute().getName();
            }
            return super.getValueAt(rowIndex, columnIndex);
        }
    }

    protected abstract class UsedInObjectModel
    extends AbstractTableModel {
        protected UsedInObjectModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return new Integer(rowIndex * columnIndex);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

