/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;

public class TLConstraintEditor {
    private JTextField name = new JTextField();
    private JEditorPane rule = new JEditorPane();
    private JDialog dialog;
    private boolean result;
    private ApplicationView appView;
    private DesignPart designPart;
    private TableLevelConstraint newConstraint;
    private boolean readOnly = false;

    public TLConstraintEditor(ApplicationView view, DesignPart designPart, boolean readOnly) {
        this.appView = view;
        this.designPart = designPart;
        this.readOnly = readOnly;
    }

    public boolean showDialog() {
        this.result = false;
        this.dialog = new JDialog((Frame)this.appView.getFrame(), Messages.getString("TLConstraintEditor.TableLevelConstraint"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel namePanel = new JPanel();
        TitledBorder title = BorderFactory.createTitledBorder(Messages.getString("TLConstraintEditor.Name"));
        namePanel.setBorder(title);
        this.name.setPreferredSize(new Dimension(405, 20));
        this.name.setEnabled(!this.readOnly);
        namePanel.add(this.name);
        jpanel.add((Component)namePanel, "North");
        JPanel rulePanel = new JPanel();
        title = BorderFactory.createTitledBorder(Messages.getString("TLConstraintEditor.ValidationRule"));
        rulePanel.setBorder(title);
        this.rule.setPreferredSize(new Dimension(400, 150));
        this.rule.setEnabled(!this.readOnly);
        rulePanel.add(new JScrollPane(this.rule));
        jpanel.add((Component)rulePanel, "Center");
        JPanel bottom = new JPanel();
        if (!this.readOnly) {
            JButton okButton = new JButton(Messages.getString("TLConstraintEditor.OK"));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TLConstraintEditor.this.result = TLConstraintEditor.this.check();
                    if (TLConstraintEditor.this.result) {
                        TLConstraintEditor.this.newConstraint = new TableLevelConstraint(TLConstraintEditor.this.designPart, TLConstraintEditor.this.getName(), TLConstraintEditor.this.getRule());
                        TLConstraintEditor.this.dialog.dispose();
                    }
                }
            });
            bottom.add(okButton);
            okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        JButton cancelButton = new JButton(!this.readOnly ? Messages.getString("TLConstraintEditor.Cancel") : Messages.getString("TLConstraintEditor.Close"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TLConstraintEditor.this.result = false;
                TLConstraintEditor.this.dialog.dispose();
            }
        });
        bottom.add(cancelButton);
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jpanel.add((Component)bottom, "South");
        this.dialog.getContentPane().add(jpanel);
        this.dialog.pack();
        CommonUtil.centerOnScreen(this.dialog);
        this.dialog.setResizable(false);
        this.dialog.show();
        return this.result;
    }

    private boolean check() {
        if (!StringUtilities.isNotEmpty(this.name.getText())) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TLConstraintEditor.NameCcouldntBeEmpty"), Messages.getString("TLConstraintEditor.Warning"), 2);
            return false;
        }
        if (!StringUtilities.isNotEmpty(this.rule.getText())) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("TLConstraintEditor.EnterValidationRule"), Messages.getString("TLConstraintEditor.Warning"), 2);
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name.getText();
    }

    public void setName(String name) {
        this.name.setText(name);
    }

    public String getRule() {
        return this.rule.getText();
    }

    public void setRule(String rule) {
        this.rule.setText(rule);
    }

    public void clear() {
        this.name.setText("");
        this.rule.setText("");
    }

    public TableLevelConstraint getNewConstraint() {
        return this.newConstraint;
    }

    public void setNewConstraint(TableLevelConstraint newConstraint) {
        this.newConstraint = newConstraint;
    }
}

