/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;

public class UrlPropertiesDialogEx
extends AbstractPropertiesDialog {
    private JTextField tfUrl;
    private BIResourceLocator url;
    private JTable cTable;
    private List cList;
    private JPanel pnContacts;

    public UrlPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public UrlPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbUrl = new JLabel(LB_URL);
        lbUrl.setPreferredSize(this.getDefaultSize());
        this.tfUrl = new JTextField();
        this.tfUrl.setPreferredSize(this.getDefaultSize());
        this.tfUrl.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbUrl, this.tfUrl));
    }

    @Override
    public String getCaption() {
        return Messages.getString("UrlPropertiesDialogEx.ResourceLocatorProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BIResourceLocator) {
            this.url = (BIResourceLocator)object;
            this.tfName.setText(this.url.getName());
            this.tfUrl.setText(this.url.getUrl());
            this.cList.addAll(this.url.getContacts());
            this.taComments.setText(this.url.getComment());
            this.tfObjectID.setText(this.url.getObjectID());
            this.tfCreationTime.setText(this.url.getCreationTime());
            this.tfCreator.setText(this.url.getCreator().getName());
            this.tfDesign.setText(this.url.getOwnerDesignName());
            if (this.url.getGenerator() != null) {
                this.tfGeneratorName.setText(this.url.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.url.getChanger().getName());
            this.tfLastChangedTime.setText(this.url.getChangeTime());
            this.dynamicPropertiesList.clear();
            Iterator it = this.url.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.url.getProperty(propName);
                DynamicProperty dp = new DynamicProperty(propName, value);
                this.dynamicPropertiesList.add(dp);
            }
            this.dynamicPropertiesTable.updateUI();
        }
    }

    @Override
    protected void setProperties() {
        this.url.setName(this.tfName.getText());
        this.url.setComment(this.taComments.getText());
        this.url.setUrl(this.tfUrl.getText());
        UrlPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.url.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.url.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getContactsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "URL_PROPERTIES_DIALOG";
    }

    private JPanel getContactsPanel() {
        if (this.pnContacts == null) {
            this.pnContacts = this.createPage(Messages.getString("UrlPropertiesDialogEx.Contacts"));
            this.cList = new ArrayList();
            this.cTable = new JTable(new ContactTableModel());
            this.cTable.setSelectionMode(0);
            this.cTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = UrlPropertiesDialogEx.this.cTable.getSelectedRow()) != -1 && UrlPropertiesDialogEx.this.cList.size() > 0 && row < UrlPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)UrlPropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.cTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("UrlPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = UrlPropertiesDialogEx.this.cTable.getSelectedRow();
                    if (row != -1 && UrlPropertiesDialogEx.this.cList.size() > 0 && row < UrlPropertiesDialogEx.this.cList.size()) {
                        DesignObject object = (DesignObject)UrlPropertiesDialogEx.this.cList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnContacts.add(pPanel);
        }
        return this.pnContacts;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class ContactTableModel
    extends AbstractTableModel {
        private ContactTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return UrlPropertiesDialogEx.this.cList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("UrlPropertiesDialogEx.Contacts");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)UrlPropertiesDialogEx.this.cList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

